/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.jmx.JMXHostProvider;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.UriInfo;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ConfigBasedJmxHostProvider
implements JMXHostProvider {
    private final Map<String, UriInfo> overriddenJmxUris;
    private final JMXHostProvider defaultProvider;
    private final ConfigHelper configHelper;

    public ConfigBasedJmxHostProvider(Map<String, UriInfo> overriddenJmxUris, JMXHostProvider defaultProvider, ConfigHelper configHelper) {
        this.overriddenJmxUris = overriddenJmxUris;
        this.defaultProvider = defaultProvider;
        this.configHelper = configHelper;
    }

    @Override
    public String getPublicHostName(String clusterName, String hostName) {
        return this.defaultProvider.getPublicHostName(clusterName, hostName);
    }

    @Override
    public Set<String> getHostNames(String clusterName, String componentName) {
        return this.overridenJmxUri(componentName).map(uri -> Collections.singleton(this.resolve((UriInfo)uri, clusterName).getHost())).orElseGet(() -> this.defaultProvider.getHostNames(clusterName, componentName));
    }

    private URI resolve(UriInfo uri, String clusterName) {
        try {
            return uri.resolve(this.config(clusterName));
        }
        catch (OBDPException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getPort(String clusterName, String componentName, String hostName, boolean httpsEnabled) {
        return this.overridenJmxUri(componentName).map(uri -> String.valueOf(this.resolve((UriInfo)uri, clusterName).getPort())).orElseGet(() -> this.defaultProvider.getPort(clusterName, componentName, hostName, httpsEnabled));
    }

    @Override
    public String getJMXProtocol(String clusterName, String componentName) {
        return this.overridenJmxUri(componentName).map(uri -> this.resolve((UriInfo)uri, clusterName).getScheme()).orElseGet(() -> this.defaultProvider.getJMXProtocol(clusterName, componentName));
    }

    @Override
    public String getJMXRpcMetricTag(String clusterName, String componentName, String port) {
        return this.defaultProvider.getJMXRpcMetricTag(clusterName, componentName, port);
    }

    private Optional<UriInfo> overridenJmxUri(String component) {
        return Optional.ofNullable(this.overriddenJmxUris.get(component));
    }

    private Map<String, Map<String, String>> config(String clusterName) throws OBDPException {
        return this.configHelper.getEffectiveConfigProperties(clusterName, null);
    }
}

