/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.ClusterNotFoundException;
import id.onyx.obdp.server.DuplicateResourceException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ObjectNotFoundException;
import id.onyx.obdp.server.ParentObjectNotFoundException;
import id.onyx.obdp.server.ServiceNotFoundException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.controller.MaintenanceStateHelper;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.RequestStatusResponse;
import id.onyx.obdp.server.controller.ServiceComponentRequest;
import id.onyx.obdp.server.controller.ServiceComponentResponse;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.DeleteHostComponentStatusMetaData;
import id.onyx.obdp.server.controller.internal.RequestOperationLevel;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentFactory;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.State;
import id.onyx.obdp.server.topology.STOMPComponentsDeleteHandler;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentResourceProvider
extends AbstractControllerResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentResourceProvider.class);
    public static final String SERVICE_COMPONENT_INFO = "ServiceComponentInfo";
    public static final String CLUSTER_NAME_PROPERTY_ID = "cluster_name";
    public static final String SERVICE_NAME_PROPERTY_ID = "service_name";
    public static final String COMPONENT_NAME_PROPERTY_ID = "component_name";
    public static final String DISPLAY_NAME_PROPERTY_ID = "display_name";
    public static final String STATE_PROPERTY_ID = "state";
    public static final String CATEGORY_PROPERTY_ID = "category";
    public static final String TOTAL_COUNT_PROPERTY_ID = "total_count";
    public static final String STARTED_COUNT_PROPERTY_ID = "started_count";
    public static final String INSTALLED_COUNT_PROPERTY_ID = "installed_count";
    public static final String INSTALLED_AND_MAINTENANCE_OFF_COUNT_PROPERTY_ID = "installed_and_maintenance_off_count";
    public static final String INIT_COUNT_PROPERTY_ID = "init_count";
    public static final String UNKNOWN_COUNT_PROPERTY_ID = "unknown_count";
    public static final String INSTALL_FAILED_COUNT_PROPERTY_ID = "install_failed_count";
    public static final String RECOVERY_ENABLED_PROPERTY_ID = "recovery_enabled";
    public static final String DESIRED_STACK_PROPERTY_ID = "desired_stack";
    public static final String DESIRED_VERSION_PROPERTY_ID = "desired_version";
    public static final String REPOSITORY_STATE_PROPERTY_ID = "repository_state";
    public static final String CLUSTER_NAME = "ServiceComponentInfo/cluster_name";
    public static final String SERVICE_NAME = "ServiceComponentInfo/service_name";
    public static final String COMPONENT_NAME = "ServiceComponentInfo/component_name";
    public static final String DISPLAY_NAME = "ServiceComponentInfo/display_name";
    public static final String STATE = "ServiceComponentInfo/state";
    public static final String CATEGORY = "ServiceComponentInfo/category";
    public static final String TOTAL_COUNT = "ServiceComponentInfo/total_count";
    public static final String STARTED_COUNT = "ServiceComponentInfo/started_count";
    public static final String INSTALLED_COUNT = "ServiceComponentInfo/installed_count";
    public static final String INSTALLED_AND_MAINTENANCE_OFF_COUNT = "ServiceComponentInfo/installed_and_maintenance_off_count";
    public static final String INIT_COUNT = "ServiceComponentInfo/init_count";
    public static final String UNKNOWN_COUNT = "ServiceComponentInfo/unknown_count";
    public static final String INSTALL_FAILED_COUNT = "ServiceComponentInfo/install_failed_count";
    public static final String RECOVERY_ENABLED = "ServiceComponentInfo/recovery_enabled";
    public static final String DESIRED_STACK = "ServiceComponentInfo/desired_stack";
    public static final String DESIRED_VERSION = "ServiceComponentInfo/desired_version";
    public static final String REPOSITORY_STATE = "ServiceComponentInfo/repository_state";
    private static final String TRUE = "true";
    private static final String QUERY_PARAMETERS_RUN_SMOKE_TEST_ID = "params/run_smoke_test";
    private static final Set<String> pkPropertyIds = Sets.newHashSet((Object[])new String[]{"ServiceComponentInfo/cluster_name", "ServiceComponentInfo/service_name", "ServiceComponentInfo/component_name"});
    private static final Set<String> PROPERTY_IDS = new HashSet<String>();
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS = new HashMap<Resource.Type, String>();
    private MaintenanceStateHelper maintenanceStateHelper;
    @Inject
    private STOMPComponentsDeleteHandler STOMPComponentsDeleteHandler;

    @AssistedInject
    ComponentResourceProvider(@Assisted OBDPManagementController managementController, MaintenanceStateHelper maintenanceStateHelper) {
        super(Resource.Type.Component, PROPERTY_IDS, KEY_PROPERTY_IDS, managementController);
        this.maintenanceStateHelper = maintenanceStateHelper;
        this.setRequiredCreateAuthorizations(EnumSet.of(RoleAuthorization.SERVICE_ADD_DELETE_SERVICES, RoleAuthorization.HOST_ADD_DELETE_COMPONENTS));
        this.setRequiredDeleteAuthorizations(EnumSet.of(RoleAuthorization.SERVICE_ADD_DELETE_SERVICES, RoleAuthorization.HOST_ADD_DELETE_COMPONENTS));
        this.setRequiredGetAuthorizations(RoleAuthorization.AUTHORIZATIONS_VIEW_SERVICE);
        this.setRequiredGetAuthorizations(RoleAuthorization.AUTHORIZATIONS_VIEW_SERVICE);
        this.setRequiredUpdateAuthorizations(RoleAuthorization.AUTHORIZATIONS_UPDATE_SERVICE);
    }

    @Override
    protected RequestStatus createResourcesAuthorized(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        final HashSet<ServiceComponentRequest> requests = new HashSet<ServiceComponentRequest>();
        for (Map<String, Object> propertyMap : request.getProperties()) {
            requests.add(this.getRequest(propertyMap));
        }
        this.createResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException, AuthorizationException {
                ComponentResourceProvider.this.createComponents(requests);
                return null;
            }
        });
        this.notifyCreate(Resource.Type.Component, request);
        return this.getRequestStatus(null);
    }

    @Override
    @Transactional
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<ServiceComponentRequest> requests = new HashSet<ServiceComponentRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            requests.add(this.getRequest(propertyMap));
        }
        Set<ServiceComponentResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<ServiceComponentResponse>>(){

            @Override
            public Set<ServiceComponentResponse> invoke() throws OBDPException {
                return ComponentResourceProvider.this.getComponents(requests);
            }
        });
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<Resource> resources = new HashSet<Resource>();
        for (ServiceComponentResponse response : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.Component);
            ComponentResourceProvider.setResourceProperty(resource, CLUSTER_NAME, response.getClusterName(), requestedIds);
            ComponentResourceProvider.setResourceProperty(resource, SERVICE_NAME, response.getServiceName(), requestedIds);
            ComponentResourceProvider.setResourceProperty(resource, COMPONENT_NAME, response.getComponentName(), requestedIds);
            ComponentResourceProvider.setResourceProperty(resource, DISPLAY_NAME, response.getDisplayName(), requestedIds);
            ComponentResourceProvider.setResourceProperty(resource, STATE, response.getDesiredState(), requestedIds);
            ComponentResourceProvider.setResourceProperty(resource, CATEGORY, response.getCategory(), requestedIds);
            ComponentResourceProvider.setResourceProperty(resource, TOTAL_COUNT, response.getServiceComponentStateCount().get("totalCount"), requestedIds);
            ComponentResourceProvider.setResourceProperty(resource, STARTED_COUNT, response.getServiceComponentStateCount().get("startedCount"), requestedIds);
            ComponentResourceProvider.setResourceProperty(resource, INSTALLED_COUNT, response.getServiceComponentStateCount().get("installedCount"), requestedIds);
            ComponentResourceProvider.setResourceProperty(resource, INSTALLED_AND_MAINTENANCE_OFF_COUNT, response.getServiceComponentStateCount().get("installedAndMaintenanceOffCount"), requestedIds);
            ComponentResourceProvider.setResourceProperty(resource, INSTALL_FAILED_COUNT, response.getServiceComponentStateCount().get("installFailedCount"), requestedIds);
            ComponentResourceProvider.setResourceProperty(resource, INIT_COUNT, response.getServiceComponentStateCount().get("initCount"), requestedIds);
            ComponentResourceProvider.setResourceProperty(resource, UNKNOWN_COUNT, response.getServiceComponentStateCount().get("unknownCount"), requestedIds);
            ComponentResourceProvider.setResourceProperty(resource, RECOVERY_ENABLED, String.valueOf(response.isRecoveryEnabled()), requestedIds);
            ComponentResourceProvider.setResourceProperty(resource, DESIRED_STACK, response.getDesiredStackId(), requestedIds);
            ComponentResourceProvider.setResourceProperty(resource, DESIRED_VERSION, response.getDesiredVersion(), requestedIds);
            ComponentResourceProvider.setResourceProperty(resource, REPOSITORY_STATE, (Object)response.getRepositoryState(), requestedIds);
            resources.add(resource);
        }
        return resources;
    }

    @Override
    public RequestStatus updateResourcesAuthorized(final Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<ServiceComponentRequest> requests = new HashSet<ServiceComponentRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(request.getProperties().iterator().next(), predicate)) {
            requests.add(this.getRequest(propertyMap));
        }
        Object queryParameterValue = ComponentResourceProvider.getQueryParameterValue(QUERY_PARAMETERS_RUN_SMOKE_TEST_ID, predicate);
        final boolean runSmokeTest = TRUE.equals(queryParameterValue);
        RequestStatusResponse response = this.modifyResources(new AbstractResourceProvider.Command<RequestStatusResponse>(){

            @Override
            public RequestStatusResponse invoke() throws OBDPException, AuthorizationException {
                return ComponentResourceProvider.this.updateComponents(requests, request.getRequestInfoProperties(), runSmokeTest);
            }
        });
        this.notifyUpdate(Resource.Type.Component, request, predicate);
        return this.getRequestStatus(response);
    }

    @Override
    protected RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<ServiceComponentRequest> requests = new HashSet<ServiceComponentRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            requests.add(this.getRequest(propertyMap));
        }
        RequestStatusResponse response = this.modifyResources(new AbstractResourceProvider.Command<RequestStatusResponse>(){

            @Override
            public RequestStatusResponse invoke() throws OBDPException, AuthorizationException {
                return ComponentResourceProvider.this.deleteComponents(requests);
            }
        });
        this.notifyDelete(Resource.Type.Component, predicate);
        return this.getRequestStatus(response);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return pkPropertyIds;
    }

    private ServiceComponentRequest getRequest(Map<String, Object> properties) {
        return new ServiceComponentRequest((String)properties.get(CLUSTER_NAME), (String)properties.get(SERVICE_NAME), (String)properties.get(COMPONENT_NAME), (String)properties.get(STATE), (String)properties.get(RECOVERY_ENABLED), (String)properties.get(CATEGORY));
    }

    public void createComponents(Set<ServiceComponentRequest> requests) throws OBDPException, AuthorizationException {
        Cluster cluster;
        if (requests.isEmpty()) {
            LOG.warn("Received an empty requests set");
            return;
        }
        Clusters clusters = this.getManagementController().getClusters();
        OBDPMetaInfo obdpMetaInfo = this.getManagementController().getAmbariMetaInfo();
        ServiceComponentFactory serviceComponentFactory = this.getManagementController().getServiceComponentFactory();
        HashMap componentNames = new HashMap();
        HashSet<String> duplicates = new HashSet<String>();
        for (ServiceComponentRequest request : requests) {
            StackId stackId;
            Map serviceComponents;
            Validate.notEmpty((String)request.getComponentName(), (String)"component name should be non-empty");
            cluster = this.getClusterForRequest(request, clusters);
            this.isAuthorized(cluster, this.getRequiredCreateAuthorizations());
            this.setServiceNameIfAbsent(request, cluster, obdpMetaInfo);
            this.debug("Received a createComponent request: {}", request);
            if (!componentNames.containsKey(request.getClusterName())) {
                componentNames.put(request.getClusterName(), new HashMap());
            }
            if (!(serviceComponents = (Map)componentNames.get(request.getClusterName())).containsKey(request.getServiceName())) {
                serviceComponents.put(request.getServiceName(), new HashSet());
            }
            if (((Set)serviceComponents.get(request.getServiceName())).contains(request.getComponentName())) {
                duplicates.add(request.toString());
                continue;
            }
            ((Set)serviceComponents.get(request.getServiceName())).add(request.getComponentName());
            if (StringUtils.isNotEmpty((String)request.getDesiredState())) {
                Validate.isTrue((State.INIT == State.valueOf(request.getDesiredState()) ? 1 : 0) != 0, (String)("Invalid desired state only INIT state allowed during creation, providedDesiredState=" + request.getDesiredState()));
            }
            Service s = this.getServiceFromCluster(request, cluster);
            try {
                ServiceComponent sc = s.getServiceComponent(request.getComponentName());
                if (sc != null) {
                    duplicates.add(request.toString());
                    continue;
                }
            }
            catch (OBDPException sc) {
                // empty catch block
            }
            if (obdpMetaInfo.isValidServiceComponent((stackId = s.getDesiredStackId()).getStackName(), stackId.getStackVersion(), s.getName(), request.getComponentName())) continue;
            throw new IllegalArgumentException("Unsupported or invalid component in stack stackInfo=" + stackId.getStackId() + " request=" + request);
        }
        Validate.isTrue((componentNames.size() == 1 ? 1 : 0) != 0, (String)"Invalid arguments, updates allowed on only one cluster at a time");
        if (!duplicates.isEmpty()) {
            throw new DuplicateResourceException("Attempted to create one or more components which already exist:" + StringUtils.join(duplicates, (String)","));
        }
        for (ServiceComponentRequest request : requests) {
            cluster = clusters.getCluster(request.getClusterName());
            Service s = cluster.getService(request.getServiceName());
            ServiceComponent sc = serviceComponentFactory.createNew(s, request.getComponentName());
            sc.setDesiredRepositoryVersion(s.getDesiredRepositoryVersion());
            if (StringUtils.isNotEmpty((String)request.getDesiredState())) {
                State state = State.valueOf(request.getDesiredState());
                sc.setDesiredState(state);
            } else {
                sc.setDesiredState(s.getDesiredState());
            }
            if (StringUtils.isNotEmpty((String)request.getRecoveryEnabled())) {
                boolean recoveryEnabled = Boolean.parseBoolean(request.getRecoveryEnabled());
                sc.setRecoveryEnabled(recoveryEnabled);
                LOG.info("Component: {}, recovery_enabled from request: {}", (Object)request.getComponentName(), (Object)recoveryEnabled);
            } else {
                StackId stackId = s.getDesiredStackId();
                ComponentInfo componentInfo = obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), s.getName(), request.getComponentName());
                if (componentInfo == null) {
                    throw new OBDPException("Could not get component information from stack definition: Stack=" + stackId + ", Service=" + s.getName() + ", Component=" + request.getComponentName());
                }
                sc.setRecoveryEnabled(componentInfo.isRecoveryEnabled());
                LOG.info("Component: {}, recovery_enabled from stack definition:{}", (Object)componentInfo.getName(), (Object)componentInfo.isRecoveryEnabled());
            }
            s.addServiceComponent(sc);
        }
    }

    protected Set<ServiceComponentResponse> getComponents(Set<ServiceComponentRequest> requests) throws OBDPException {
        HashSet<ServiceComponentResponse> response = new HashSet<ServiceComponentResponse>();
        for (ServiceComponentRequest request : requests) {
            try {
                response.addAll(this.getComponents(request));
            }
            catch (ObjectNotFoundException e) {
                if (requests.size() != 1) continue;
                throw e;
            }
        }
        return response;
    }

    private Set<ServiceComponentResponse> getComponents(ServiceComponentRequest request) throws OBDPException {
        OBDPMetaInfo obdpMetaInfo = this.getManagementController().getAmbariMetaInfo();
        Clusters clusters = this.getManagementController().getClusters();
        Cluster cluster = this.getCluster(request, clusters);
        HashSet<ServiceComponentResponse> response = new HashSet<ServiceComponentResponse>();
        String category = null;
        if (request.getComponentName() != null) {
            this.setServiceNameIfAbsent(request, cluster, obdpMetaInfo);
            Service s = this.getServiceFromCluster(request, cluster);
            ServiceComponent sc = s.getServiceComponent(request.getComponentName());
            ServiceComponentResponse serviceComponentResponse = sc.convertToResponse();
            StackId stackId = sc.getDesiredStackId();
            try {
                ComponentInfo componentInfo = obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), s.getName(), request.getComponentName());
                category = componentInfo.getCategory();
                if (category != null) {
                    serviceComponentResponse.setCategory(category);
                }
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            response.add(serviceComponentResponse);
            return response;
        }
        HashSet<Service> services = new HashSet<Service>();
        if (StringUtils.isNotEmpty((String)request.getServiceName())) {
            services.add(this.getServiceFromCluster(request, cluster));
        } else {
            services.addAll(cluster.getServices().values());
        }
        State desiredStateToCheck = this.getValidDesiredState(request);
        for (Service s : services) {
            for (ServiceComponent sc : s.getServiceComponents().values()) {
                if (desiredStateToCheck != null && desiredStateToCheck != sc.getDesiredState()) continue;
                StackId stackId = sc.getDesiredStackId();
                ServiceComponentResponse serviceComponentResponse = sc.convertToResponse();
                try {
                    ComponentInfo componentInfo = obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), s.getName(), sc.getName());
                    category = componentInfo.getCategory();
                    if (category != null) {
                        serviceComponentResponse.setCategory(category);
                    }
                }
                catch (ObjectNotFoundException componentInfo) {
                    // empty catch block
                }
                String requestedCategory = request.getComponentCategory();
                if (StringUtils.isNotEmpty((String)requestedCategory) && !requestedCategory.equalsIgnoreCase(category)) continue;
                response.add(serviceComponentResponse);
            }
        }
        return response;
    }

    protected RequestStatusResponse updateComponents(Set<ServiceComponentRequest> requests, Map<String, String> requestProperties, boolean runSmokeTest) throws OBDPException, AuthorizationException {
        Resource.Type reqOpLvl;
        if (requests.isEmpty()) {
            LOG.warn("Received an empty requests set");
            return null;
        }
        Clusters clusters = this.getManagementController().getClusters();
        OBDPMetaInfo obdpMetaInfo = this.getManagementController().getAmbariMetaInfo();
        HashMap<State, List<ServiceComponent>> changedComps = new HashMap<State, List<ServiceComponent>>();
        HashMap<String, Map<State, List<ServiceComponentHost>>> changedScHosts = new HashMap<String, Map<State, List<ServiceComponentHost>>>();
        ArrayList<ServiceComponentHost> ignoredScHosts = new ArrayList<ServiceComponentHost>();
        HashSet<String> clusterNames = new HashSet<String>();
        HashMap componentNames = new HashMap();
        HashSet<State> seenNewStates = new HashSet<State>();
        ArrayList<ServiceComponent> recoveryEnabledComponents = new ArrayList<ServiceComponent>();
        ArrayList<ServiceComponent> recoveryDisabledComponents = new ArrayList<ServiceComponent>();
        if (requestProperties.containsKey("operation_level/level")) {
            Iterator operationLevel = new RequestOperationLevel(requestProperties);
            reqOpLvl = ((RequestOperationLevel)((Object)operationLevel)).getLevel();
        } else {
            LOG.warn("Can not determine request operation level. Operation level property should be specified for this request.");
            reqOpLvl = Resource.Type.Cluster;
        }
        for (ServiceComponentRequest request : requests) {
            Validate.notEmpty((String)request.getComponentName(), (String)"component name should be non-empty");
            Cluster cluster = this.getClusterForRequest(request, clusters);
            String clusterName = request.getClusterName();
            String componentName = request.getComponentName();
            LOG.info("Received a updateComponent request: {}", (Object)request);
            this.setServiceNameIfAbsent(request, cluster, obdpMetaInfo);
            String serviceName = request.getServiceName();
            this.debug("Received a updateComponent request: {}", request);
            clusterNames.add(clusterName);
            Validate.isTrue((clusterNames.size() == 1 ? 1 : 0) != 0, (String)"Updates to multiple clusters is not supported");
            if (!componentNames.containsKey(clusterName)) {
                componentNames.put(clusterName, new HashMap());
            }
            if (!((Map)componentNames.get(clusterName)).containsKey(serviceName)) {
                ((Map)componentNames.get(clusterName)).put(serviceName, new HashSet());
            }
            if (((Set)((Map)componentNames.get(clusterName)).get(serviceName)).contains(componentName)) {
                throw new IllegalArgumentException("Invalid request contains duplicate service components");
            }
            ((Set)((Map)componentNames.get(clusterName)).get(serviceName)).add(componentName);
            Service s = cluster.getService(serviceName);
            ServiceComponent sc = s.getServiceComponent(componentName);
            State newState = this.getValidDesiredState(request);
            if (!this.maintenanceStateHelper.isOperationAllowed(reqOpLvl, s)) {
                LOG.info("Operations cannot be applied to component " + componentName + " because service " + serviceName + " is in the maintenance state of " + s.getMaintenanceState());
                continue;
            }
            if (!StringUtils.isEmpty((String)request.getRecoveryEnabled())) {
                AuthorizationHelper.verifyAuthorization(ResourceType.CLUSTER, this.getClusterResourceId(clusterName), EnumSet.of(RoleAuthorization.CLUSTER_MANAGE_AUTO_START, RoleAuthorization.SERVICE_MANAGE_AUTO_START));
                boolean newRecoveryEnabled = Boolean.parseBoolean(request.getRecoveryEnabled());
                boolean oldRecoveryEnabled = sc.isRecoveryEnabled();
                LOG.info("Component: {}, oldRecoveryEnabled: {}, newRecoveryEnabled {}", new Object[]{componentName, oldRecoveryEnabled, newRecoveryEnabled});
                if (newRecoveryEnabled != oldRecoveryEnabled) {
                    if (newRecoveryEnabled) {
                        recoveryEnabledComponents.add(sc);
                    } else {
                        recoveryDisabledComponents.add(sc);
                    }
                }
            }
            if (newState == null) {
                this.debug("Nothing to do for new updateServiceComponent request, request ={}, newDesiredState=null" + request, new Object[0]);
                continue;
            }
            if (sc.isClientComponent() && !newState.isValidClientComponentState()) {
                throw new OBDPException("Invalid desired state for a client component");
            }
            seenNewStates.add(newState);
            State oldScState = sc.getDesiredState();
            if (newState != oldScState) {
                if (newState == State.INSTALLED || newState == State.STARTED) {
                    this.isAuthorized(cluster, RoleAuthorization.SERVICE_START_STOP);
                }
                if (!State.isValidDesiredStateTransition(oldScState, newState)) {
                    throw new OBDPException("Invalid transition for servicecomponent, clusterName=" + cluster.getClusterName() + ", clusterId=" + cluster.getClusterId() + ", serviceName=" + sc.getServiceName() + ", componentName=" + sc.getName() + ", recoveryEnabled=" + sc.isRecoveryEnabled() + ", currentDesiredState=" + oldScState + ", newDesiredState=" + newState);
                }
                if (!changedComps.containsKey((Object)newState)) {
                    changedComps.put(newState, new ArrayList());
                }
                this.debug("Handling update to ServiceComponent, clusterName=" + clusterName + ", serviceName=" + serviceName + ", componentName=" + sc.getName() + ", recoveryEnabled=" + sc.isRecoveryEnabled() + ", currentDesiredState=" + oldScState + ", newDesiredState=" + newState, new Object[0]);
                ((List)changedComps.get((Object)newState)).add(sc);
            }
            for (ServiceComponentHost sch : sc.getServiceComponentHosts().values()) {
                State oldSchState = sch.getState();
                if (oldSchState == State.DISABLED || oldSchState == State.UNKNOWN) {
                    this.debug("Ignoring ServiceComponentHost, clusterName=" + clusterName + ", serviceName=" + serviceName + ", componentName=" + sc.getName() + ", recoveryEnabled=" + sc.isRecoveryEnabled() + ", hostname=" + sch.getHostName() + ", currentState=" + oldSchState + ", newDesiredState=" + newState, new Object[0]);
                    continue;
                }
                if (newState == oldSchState) {
                    ignoredScHosts.add(sch);
                    this.debug("Ignoring ServiceComponentHost, clusterName=" + clusterName + ", serviceName=" + serviceName + ", componentName=" + sc.getName() + ", recoveryEnabled=" + sc.isRecoveryEnabled() + ", hostname=" + sch.getHostName() + ", currentState=" + oldSchState + ", newDesiredState=" + newState, new Object[0]);
                    continue;
                }
                if (!this.maintenanceStateHelper.isOperationAllowed(reqOpLvl, sch)) {
                    ignoredScHosts.add(sch);
                    this.debug("Ignoring ServiceComponentHost in maintenance state, clusterName=" + clusterName + ", serviceName=" + serviceName + ", componentName=" + sc.getName() + ", recoveryEnabled=" + sc.isRecoveryEnabled() + ", hostname=" + sch.getHostName(), new Object[0]);
                    continue;
                }
                if (!State.isValidStateTransition(oldSchState, newState)) {
                    throw new OBDPException("Invalid transition for servicecomponenthost, clusterName=" + cluster.getClusterName() + ", clusterId=" + cluster.getClusterId() + ", serviceName=" + sch.getServiceName() + ", componentName=" + sch.getServiceComponentName() + ", recoveryEnabled=" + sc.isRecoveryEnabled() + ", hostname=" + sch.getHostName() + ", currentState=" + oldSchState + ", newDesiredState=" + newState);
                }
                if (!changedScHosts.containsKey(sc.getName())) {
                    changedScHosts.put(sc.getName(), new HashMap());
                }
                if (!((Map)changedScHosts.get(sc.getName())).containsKey((Object)newState)) {
                    ((Map)changedScHosts.get(sc.getName())).put(newState, new ArrayList());
                }
                this.debug("Handling update to ServiceComponentHost, clusterName=" + clusterName + ", serviceName=" + serviceName + ", componentName=" + sc.getName() + ", recoveryEnabled=" + sc.isRecoveryEnabled() + ", hostname=" + sch.getHostName() + ", currentState=" + oldSchState + ", newDesiredState=" + newState, new Object[0]);
                ((List)((Map)changedScHosts.get(sc.getName())).get((Object)newState)).add(sch);
            }
        }
        Validate.isTrue((seenNewStates.size() <= 1 ? 1 : 0) != 0, (String)"Cannot handle different desired state changes for a set of service components at the same time");
        for (ServiceComponent sc : recoveryEnabledComponents) {
            sc.setRecoveryEnabled(true);
        }
        for (ServiceComponent sc : recoveryDisabledComponents) {
            sc.setRecoveryEnabled(false);
        }
        Cluster cluster = clusters.getCluster((String)clusterNames.iterator().next());
        return this.getManagementController().createAndPersistStages(cluster, requestProperties, null, null, changedComps, changedScHosts, ignoredScHosts, runSmokeTest, false);
    }

    protected RequestStatusResponse deleteComponents(Set<ServiceComponentRequest> requests) throws OBDPException, AuthorizationException {
        Clusters clusters = this.getManagementController().getClusters();
        OBDPMetaInfo obdpMetaInfo = this.getManagementController().getAmbariMetaInfo();
        DeleteHostComponentStatusMetaData deleteMetaData = new DeleteHostComponentStatusMetaData();
        for (ServiceComponentRequest request : requests) {
            Validate.notEmpty((String)request.getComponentName(), (String)"component name should be non-empty");
            Cluster cluster = this.getClusterForRequest(request, clusters);
            this.setServiceNameIfAbsent(request, cluster, obdpMetaInfo);
            Service s = this.getServiceFromCluster(request, cluster);
            ServiceComponent sc = s.getServiceComponent(request.getComponentName());
            if (sc == null) continue;
            this.deleteHostComponentsForServiceComponent(sc, request, deleteMetaData);
            this.STOMPComponentsDeleteHandler.processDeleteByMetaDataException(deleteMetaData);
            sc.setDesiredState(State.DISABLED);
            s.deleteServiceComponent(request.getComponentName(), deleteMetaData);
            this.STOMPComponentsDeleteHandler.processDeleteByMetaDataException(deleteMetaData);
        }
        this.STOMPComponentsDeleteHandler.processDeleteByMetaData(deleteMetaData);
        return null;
    }

    private void deleteHostComponentsForServiceComponent(ServiceComponent sc, ServiceComponentRequest request, DeleteHostComponentStatusMetaData deleteMetaData) throws OBDPException {
        for (ServiceComponentHost sch : sc.getServiceComponentHosts().values()) {
            if (sch.getDesiredState().isRemovableState()) continue;
            deleteMetaData.setAmbariException(new OBDPException("Found non removable host component when trying to delete service component. To remove host component, it must be in DISABLED/INIT/INSTALLED/INSTALL_FAILED/UNKNOWN/UNINSTALLED/INSTALLING state., request=" + request.toString() + ", current state=" + sc.getDesiredState() + "."));
            return;
        }
        for (ServiceComponentHost sch : sc.getServiceComponentHosts().values()) {
            sch.delete(deleteMetaData);
        }
    }

    private Cluster getClusterForRequest(ServiceComponentRequest request, Clusters clusters) throws OBDPException {
        Validate.notEmpty((String)request.getClusterName(), (String)"cluster name should be non-empty");
        try {
            return clusters.getCluster(request.getClusterName());
        }
        catch (ClusterNotFoundException e) {
            throw new ParentObjectNotFoundException("Attempted to add a component to a cluster which doesn't exist:", e);
        }
    }

    private Service getServiceFromCluster(ServiceComponentRequest request, Cluster cluster) throws OBDPException {
        try {
            return cluster.getService(request.getServiceName());
        }
        catch (ServiceNotFoundException e) {
            throw new ParentObjectNotFoundException("Parent Service resource doesn't exist.", e);
        }
    }

    private Cluster getCluster(ServiceComponentRequest request, Clusters clusters) throws OBDPException {
        Validate.notEmpty((String)request.getClusterName(), (String)"cluster name should be non-empty");
        try {
            return clusters.getCluster(request.getClusterName());
        }
        catch (ObjectNotFoundException e) {
            throw new ParentObjectNotFoundException("Parent Cluster resource doesn't exist", e);
        }
    }

    private void isAuthorized(Cluster cluster, RoleAuthorization roleAuthorization) throws AuthorizationException {
        this.isAuthorized(cluster, EnumSet.of(roleAuthorization));
    }

    private void isAuthorized(Cluster cluster, Set<RoleAuthorization> requiredAuthorizations) throws AuthorizationException {
        if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), requiredAuthorizations)) {
            throw new AuthorizationException("The user is not authorized to for roles " + requiredAuthorizations);
        }
    }

    private void setServiceNameIfAbsent(ServiceComponentRequest request, Cluster cluster, OBDPMetaInfo obdpMetaInfo) throws OBDPException {
        if (StringUtils.isEmpty((String)request.getServiceName())) {
            String componentName = request.getComponentName();
            String serviceName = this.getManagementController().findServiceName(cluster, componentName);
            this.debug("Looking up service name for component, componentName={}, serviceName={}", componentName, serviceName);
            if (StringUtils.isEmpty((String)serviceName)) {
                throw new OBDPException("Could not find service for component, componentName=" + request.getComponentName() + ", clusterName=" + cluster.getClusterName());
            }
            request.setServiceName(serviceName);
        }
    }

    private State getValidDesiredState(ServiceComponentRequest request) {
        if (StringUtils.isEmpty((String)request.getDesiredState())) {
            return null;
        }
        State desiredStateToCheck = State.valueOf(request.getDesiredState());
        Validate.isTrue((boolean)desiredStateToCheck.isValidDesiredState(), (String)("Invalid arguments, invalid desired state, desiredState=" + desiredStateToCheck));
        return desiredStateToCheck;
    }

    private void debug(String format, Object ... arguments) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(format, arguments);
        }
    }

    static {
        PROPERTY_IDS.add(CLUSTER_NAME);
        PROPERTY_IDS.add(SERVICE_NAME);
        PROPERTY_IDS.add(COMPONENT_NAME);
        PROPERTY_IDS.add(DISPLAY_NAME);
        PROPERTY_IDS.add(STATE);
        PROPERTY_IDS.add(CATEGORY);
        PROPERTY_IDS.add(TOTAL_COUNT);
        PROPERTY_IDS.add(STARTED_COUNT);
        PROPERTY_IDS.add(INSTALLED_COUNT);
        PROPERTY_IDS.add(INSTALLED_AND_MAINTENANCE_OFF_COUNT);
        PROPERTY_IDS.add(INIT_COUNT);
        PROPERTY_IDS.add(UNKNOWN_COUNT);
        PROPERTY_IDS.add(INSTALL_FAILED_COUNT);
        PROPERTY_IDS.add(RECOVERY_ENABLED);
        PROPERTY_IDS.add(DESIRED_STACK);
        PROPERTY_IDS.add(DESIRED_VERSION);
        PROPERTY_IDS.add(REPOSITORY_STATE);
        PROPERTY_IDS.add(QUERY_PARAMETERS_RUN_SMOKE_TEST_ID);
        KEY_PROPERTY_IDS.put(Resource.Type.Component, COMPONENT_NAME);
        KEY_PROPERTY_IDS.put(Resource.Type.Service, SERVICE_NAME);
        KEY_PROPERTY_IDS.put(Resource.Type.Cluster, CLUSTER_NAME);
    }
}

