/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.api.resources.OperatingSystemResourceDefinition;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.CompatibleRepositoryVersion;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.predicate.AndPredicate;
import id.onyx.obdp.server.controller.predicate.EqualsPredicate;
import id.onyx.obdp.server.controller.predicate.OrPredicate;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PredicateBuilder;
import id.onyx.obdp.server.orm.dao.RepositoryVersionDAO;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.repository.ManifestServiceInfo;
import id.onyx.obdp.server.state.repository.VersionDefinitionXml;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class CompatibleRepositoryVersionResourceProvider
extends ReadOnlyResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CompatibleRepositoryVersionResourceProvider.class);
    public static final String REPOSITORY_VERSION_ID_PROPERTY_ID = "CompatibleRepositoryVersions/id";
    public static final String REPOSITORY_VERSION_STACK_NAME_PROPERTY_ID = "CompatibleRepositoryVersions/stack_name";
    public static final String REPOSITORY_VERSION_STACK_VERSION_PROPERTY_ID = "CompatibleRepositoryVersions/stack_version";
    public static final String REPOSITORY_VERSION_REPOSITORY_VERSION_PROPERTY_ID = "CompatibleRepositoryVersions/repository_version";
    public static final String REPOSITORY_VERSION_DISPLAY_NAME_PROPERTY_ID = "CompatibleRepositoryVersions/display_name";
    public static final String REPOSITORY_UPGRADES_SUPPORTED_TYPES_ID = "CompatibleRepositoryVersions/upgrade_types";
    public static final String REPOSITORY_VERSION_SERVICES = "CompatibleRepositoryVersions/services";
    public static final String REPOSITORY_VERSION_STACK_SERVICES = "CompatibleRepositoryVersions/stack_services";
    public static final String SUBRESOURCE_OPERATING_SYSTEMS_PROPERTY_ID = new OperatingSystemResourceDefinition().getPluralName();
    private static final String REPOSITORY_STACK_VALUE = "stack_value";
    private static final Set<String> pkPropertyIds = Collections.singleton("CompatibleRepositoryVersions/id");
    static final Set<String> propertyIds = ImmutableSet.of((Object)"stack_value", (Object)"CompatibleRepositoryVersions/id", (Object)"CompatibleRepositoryVersions/repository_version", (Object)"CompatibleRepositoryVersions/display_name", (Object)"CompatibleRepositoryVersions/stack_name", (Object)"CompatibleRepositoryVersions/stack_version", (Object[])new String[]{SUBRESOURCE_OPERATING_SYSTEMS_PROPERTY_ID, "CompatibleRepositoryVersions/upgrade_types", "CompatibleRepositoryVersions/services", "CompatibleRepositoryVersions/stack_services"});
    static final Map<Resource.Type, String> keyPropertyIds = new ImmutableMap.Builder().put((Object)Resource.Type.Stack, (Object)"CompatibleRepositoryVersions/stack_name").put((Object)Resource.Type.StackVersion, (Object)"CompatibleRepositoryVersions/stack_version").put((Object)Resource.Type.Upgrade, (Object)"CompatibleRepositoryVersions/upgrade_types").put((Object)Resource.Type.CompatibleRepositoryVersion, (Object)"CompatibleRepositoryVersions/id").build();
    @Inject
    private static RepositoryVersionDAO s_repositoryVersionDAO;
    @Inject
    private static Provider<OBDPMetaInfo> s_ambariMetaInfo;

    public CompatibleRepositoryVersionResourceProvider(OBDPManagementController amc) {
        super(Resource.Type.CompatibleRepositoryVersion, propertyIds, keyPropertyIds, amc);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        Long currentStackUniqueId = null;
        HashMap<Long, CompatibleRepositoryVersion> compatibleRepositoryVersionsMap = new HashMap<Long, CompatibleRepositoryVersion>();
        StackId stackId = null;
        for (Map<String, Object> propertyMap : propertyMaps) {
            if (!propertyMap.containsKey(REPOSITORY_STACK_VALUE)) continue;
            stackId = new StackId(propertyMap.get(REPOSITORY_STACK_VALUE).toString());
            break;
        }
        if (null == stackId) {
            if (propertyMaps.size() == 1) {
                Map<String, Object> propertyMap = propertyMaps.iterator().next();
                stackId = this.getStackInformationFromUrl(propertyMap);
            } else {
                LOG.error("Property Maps size is NOT equal to 1. Current 'propertyMaps' size = {}", (Object)propertyMaps.size());
            }
        }
        if (null == stackId) {
            LOG.error("Could not determine stack to process.  Returning empty set.");
            return resources;
        }
        for (RepositoryVersionEntity repositoryVersionEntity : s_repositoryVersionDAO.findByStack(stackId)) {
            currentStackUniqueId = repositoryVersionEntity.getId();
            compatibleRepositoryVersionsMap.put(repositoryVersionEntity.getId(), new CompatibleRepositoryVersion(repositoryVersionEntity));
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Added current stack id: {} to map", (Object)repositoryVersionEntity.getId());
        }
        Map<String, UpgradePack> packs = ((OBDPMetaInfo)s_ambariMetaInfo.get()).getUpgradePacks(stackId.getStackName(), stackId.getStackVersion());
        for (UpgradePack up : packs.values()) {
            if (null != up.getTargetStack()) {
                StackId targetStackId = new StackId(up.getTargetStack());
                List<RepositoryVersionEntity> repositoryVersionEntities = s_repositoryVersionDAO.findByStack(targetStackId);
                for (RepositoryVersionEntity repositoryVersionEntity : repositoryVersionEntities) {
                    if (compatibleRepositoryVersionsMap.containsKey(repositoryVersionEntity.getId())) {
                        ((CompatibleRepositoryVersion)compatibleRepositoryVersionsMap.get(repositoryVersionEntity.getId())).addUpgradePackType(up.getType());
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Stack id: {} exists in map.  Appended new upgrade type {}{}", (Object)up.getType(), (Object)repositoryVersionEntity.getId());
                        continue;
                    }
                    CompatibleRepositoryVersion compatibleRepositoryVersionEntity = new CompatibleRepositoryVersion(repositoryVersionEntity);
                    compatibleRepositoryVersionEntity.addUpgradePackType(up.getType());
                    compatibleRepositoryVersionsMap.put(repositoryVersionEntity.getId(), compatibleRepositoryVersionEntity);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Added Stack id: {} to map with upgrade type {}", (Object)repositoryVersionEntity.getId(), (Object)up.getType());
                }
                continue;
            }
            if (currentStackUniqueId != null) {
                ((CompatibleRepositoryVersion)compatibleRepositoryVersionsMap.get(currentStackUniqueId)).addUpgradePackType(up.getType());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Current Stack id: {} retrieved from map. Added upgrade type {}", (Object)currentStackUniqueId, (Object)up.getType());
                continue;
            }
            LOG.error("Couldn't retrieve Current stack entry from Map.");
        }
        for (CompatibleRepositoryVersion entity : compatibleRepositoryVersionsMap.values()) {
            List<Object> stackServices;
            StackInfo stack;
            VersionDefinitionXml xml;
            RepositoryVersionEntity repositoryVersionEntity = entity.getRepositoryVersionEntity();
            ResourceImpl resource = new ResourceImpl(Resource.Type.CompatibleRepositoryVersion);
            CompatibleRepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_ID_PROPERTY_ID, repositoryVersionEntity.getId(), requestedIds);
            CompatibleRepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_STACK_NAME_PROPERTY_ID, repositoryVersionEntity.getStackName(), requestedIds);
            CompatibleRepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_STACK_VERSION_PROPERTY_ID, repositoryVersionEntity.getStackVersion(), requestedIds);
            CompatibleRepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_DISPLAY_NAME_PROPERTY_ID, repositoryVersionEntity.getDisplayName(), requestedIds);
            CompatibleRepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_REPOSITORY_VERSION_PROPERTY_ID, repositoryVersionEntity.getVersion(), requestedIds);
            CompatibleRepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_UPGRADES_SUPPORTED_TYPES_ID, entity.getSupportedTypes(), requestedIds);
            try {
                xml = repositoryVersionEntity.getRepositoryXml();
            }
            catch (Exception e) {
                throw new SystemException(String.format("Could not load xml for Repository %s", repositoryVersionEntity.getId()), e);
            }
            try {
                stack = ((OBDPMetaInfo)s_ambariMetaInfo.get()).getStack(repositoryVersionEntity.getStackName(), repositoryVersionEntity.getStackVersion());
            }
            catch (OBDPException e) {
                throw new SystemException(String.format("Could not load stack %s for Repository %s", repositoryVersionEntity.getStackId().toString(), repositoryVersionEntity.getId()));
            }
            if (null != xml) {
                CompatibleRepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_SERVICES, xml.getAvailableServices(stack), requestedIds);
                stackServices = xml.getStackServices(stack);
            } else {
                stackServices = new ArrayList();
                for (ServiceInfo si : stack.getServices()) {
                    stackServices.add(new ManifestServiceInfo(si.getName(), si.getDisplayName(), si.getComment(), Collections.singleton(si.getVersion())));
                }
            }
            CompatibleRepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_STACK_SERVICES, stackServices, requestedIds);
            resources.add(resource);
        }
        return resources;
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return pkPropertyIds;
    }

    protected StackId getStackInformationFromUrl(Map<String, Object> propertyMap) {
        if (propertyMap.containsKey(REPOSITORY_VERSION_STACK_NAME_PROPERTY_ID) && propertyMap.containsKey(REPOSITORY_VERSION_STACK_VERSION_PROPERTY_ID)) {
            return new StackId(propertyMap.get(REPOSITORY_VERSION_STACK_NAME_PROPERTY_ID).toString(), propertyMap.get(REPOSITORY_VERSION_STACK_VERSION_PROPERTY_ID).toString());
        }
        return null;
    }

    @Override
    public Predicate amendPredicate(Predicate predicate) {
        if (!AndPredicate.class.isInstance(predicate)) {
            return null;
        }
        AndPredicate ap = (AndPredicate)predicate;
        if (2 != ap.getPropertyIds().size()) {
            return null;
        }
        if (!ap.getPropertyIds().contains(REPOSITORY_VERSION_STACK_NAME_PROPERTY_ID) && !ap.getPropertyIds().contains(REPOSITORY_VERSION_STACK_VERSION_PROPERTY_ID)) {
            return null;
        }
        Predicate[] predicates = ap.getPredicates();
        if (!EqualsPredicate.class.isInstance(predicates[0]) || !EqualsPredicate.class.isInstance(predicates[1])) {
            return null;
        }
        EqualsPredicate pred1 = (EqualsPredicate)predicates[0];
        EqualsPredicate pred2 = (EqualsPredicate)predicates[1];
        StackId stackId = null;
        stackId = pred1.getPropertyId().equals(REPOSITORY_VERSION_STACK_NAME_PROPERTY_ID) ? new StackId(pred1.getValue().toString(), pred2.getValue().toString()) : new StackId(pred2.getValue().toString(), pred1.getValue().toString());
        Map<String, UpgradePack> packs = ((OBDPMetaInfo)s_ambariMetaInfo.get()).getUpgradePacks(stackId.getStackName(), stackId.getStackVersion());
        HashSet<String> stackIds = new HashSet<String>();
        for (Map.Entry<String, UpgradePack> entry : packs.entrySet()) {
            UpgradePack pack = entry.getValue();
            String packStack = pack.getTargetStack();
            if (null != packStack && packStack.equals(stackId.toString())) continue;
            stackIds.add(packStack);
        }
        ArrayList<Predicate> usable = new ArrayList<Predicate>();
        usable.add(predicate);
        for (String requiredStack : stackIds) {
            StackId targetStack = new StackId(requiredStack);
            Predicate p = new PredicateBuilder().property(REPOSITORY_VERSION_STACK_NAME_PROPERTY_ID).equals(targetStack.getStackName()).and().property(REPOSITORY_VERSION_STACK_VERSION_PROPERTY_ID).equals(targetStack.getStackVersion()).toPredicate();
            usable.add(p);
        }
        Predicate p = new PredicateBuilder().property(REPOSITORY_STACK_VALUE).equals(stackId.toString()).toPredicate();
        usable.add(p);
        p = new OrPredicate(usable.toArray(new Predicate[usable.size()]));
        return p;
    }
}

