/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.actionmanager.ActionManager;
import id.onyx.obdp.server.actionmanager.RequestFactory;
import id.onyx.obdp.server.actionmanager.Stage;
import id.onyx.obdp.server.actionmanager.StageFactory;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.ActionExecutionContext;
import id.onyx.obdp.server.controller.OBDPActionExecutionHelper;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.RequestStatusResponse;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.RequestResourceFilter;
import id.onyx.obdp.server.controller.internal.RequestStageContainer;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.dao.HostVersionDAO;
import id.onyx.obdp.server.orm.dao.RepositoryVersionDAO;
import id.onyx.obdp.server.orm.dao.UpgradeDAO;
import id.onyx.obdp.server.orm.entities.HostVersionEntity;
import id.onyx.obdp.server.orm.entities.RepoDefinitionEntity;
import id.onyx.obdp.server.orm.entities.RepoOsEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.orm.entities.UpgradeEntity;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.stack.upgrade.RepositoryVersionHelper;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.RepositoryVersionState;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.repository.ClusterVersionSummary;
import id.onyx.obdp.server.state.repository.VersionDefinitionXml;
import id.onyx.obdp.server.utils.StageUtils;
import id.onyx.obdp.server.utils.VersionUtils;
import id.onyx.obdp.spi.RepositoryType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class ClusterStackVersionResourceProvider
extends AbstractControllerResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterStackVersionResourceProvider.class);
    protected static final String CLUSTER_STACK_VERSION_ID_PROPERTY_ID = PropertyHelper.getPropertyId("ClusterStackVersions", "id");
    protected static final String CLUSTER_STACK_VERSION_CLUSTER_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("ClusterStackVersions", "cluster_name");
    protected static final String CLUSTER_STACK_VERSION_STACK_PROPERTY_ID = PropertyHelper.getPropertyId("ClusterStackVersions", "stack");
    protected static final String CLUSTER_STACK_VERSION_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("ClusterStackVersions", "version");
    protected static final String CLUSTER_STACK_VERSION_STATE_PROPERTY_ID = PropertyHelper.getPropertyId("ClusterStackVersions", "state");
    protected static final String CLUSTER_STACK_VERSION_HOST_STATES_PROPERTY_ID = PropertyHelper.getPropertyId("ClusterStackVersions", "host_states");
    protected static final String CLUSTER_STACK_VERSION_REPO_SUMMARY_PROPERTY_ID = PropertyHelper.getPropertyId("ClusterStackVersions", "repository_summary");
    protected static final String CLUSTER_STACK_VERSION_REPO_SUPPORTS_REVERT = PropertyHelper.getPropertyId("ClusterStackVersions", "supports_revert");
    protected static final String CLUSTER_STACK_VERSION_REPO_REVERT_UPGRADE_ID = PropertyHelper.getPropertyId("ClusterStackVersions", "revert_upgrade_id");
    protected static final String CLUSTER_STACK_VERSION_REPOSITORY_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("ClusterStackVersions", "repository_version");
    protected static final String CLUSTER_STACK_VERSION_STAGE_SUCCESS_FACTOR = PropertyHelper.getPropertyId("ClusterStackVersions", "success_factor");
    protected static final String CLUSTER_STACK_VERSION_FORCE = "ClusterStackVersions/force";
    protected static final String INSTALL_PACKAGES_ACTION = "install_packages";
    protected static final String INSTALL_PACKAGES_FULL_NAME = "Install Version";
    private static final float INSTALL_PACKAGES_SUCCESS_FACTOR = 0.85f;
    private static final Set<String> pkPropertyIds = Sets.newHashSet((Object[])new String[]{CLUSTER_STACK_VERSION_CLUSTER_NAME_PROPERTY_ID, CLUSTER_STACK_VERSION_ID_PROPERTY_ID, CLUSTER_STACK_VERSION_STACK_PROPERTY_ID, CLUSTER_STACK_VERSION_VERSION_PROPERTY_ID, CLUSTER_STACK_VERSION_STATE_PROPERTY_ID, CLUSTER_STACK_VERSION_REPOSITORY_VERSION_PROPERTY_ID});
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{CLUSTER_STACK_VERSION_ID_PROPERTY_ID, CLUSTER_STACK_VERSION_CLUSTER_NAME_PROPERTY_ID, CLUSTER_STACK_VERSION_STACK_PROPERTY_ID, CLUSTER_STACK_VERSION_VERSION_PROPERTY_ID, CLUSTER_STACK_VERSION_HOST_STATES_PROPERTY_ID, CLUSTER_STACK_VERSION_STATE_PROPERTY_ID, CLUSTER_STACK_VERSION_REPOSITORY_VERSION_PROPERTY_ID, CLUSTER_STACK_VERSION_STAGE_SUCCESS_FACTOR, "ClusterStackVersions/force", CLUSTER_STACK_VERSION_REPO_SUMMARY_PROPERTY_ID, CLUSTER_STACK_VERSION_REPO_SUPPORTS_REVERT, CLUSTER_STACK_VERSION_REPO_REVERT_UPGRADE_ID});
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Cluster, (Object)CLUSTER_STACK_VERSION_CLUSTER_NAME_PROPERTY_ID).put((Object)Resource.Type.ClusterStackVersion, (Object)CLUSTER_STACK_VERSION_ID_PROPERTY_ID).put((Object)Resource.Type.Stack, (Object)CLUSTER_STACK_VERSION_STACK_PROPERTY_ID).put((Object)Resource.Type.StackVersion, (Object)CLUSTER_STACK_VERSION_VERSION_PROPERTY_ID).put((Object)Resource.Type.RepositoryVersion, (Object)CLUSTER_STACK_VERSION_REPOSITORY_VERSION_PROPERTY_ID).build();
    @Inject
    private static HostVersionDAO hostVersionDAO;
    @Inject
    private static UpgradeDAO upgradeDAO;
    @Inject
    private static RepositoryVersionDAO repositoryVersionDAO;
    @Inject
    private static Provider<OBDPActionExecutionHelper> actionExecutionHelper;
    @Inject
    private static StageFactory stageFactory;
    @Inject
    private static RequestFactory requestFactory;
    @Inject
    private static Configuration configuration;
    @Inject
    private static RepositoryVersionHelper repoVersionHelper;
    @Inject
    private static Gson gson;
    @Inject
    private static Provider<OBDPMetaInfo> metaInfo;
    @Inject
    private static Provider<Clusters> clusters;
    @Inject
    private static Provider<ConfigHelper> configHelperProvider;

    @Inject
    public ClusterStackVersionResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.ClusterStackVersion, propertyIds, keyPropertyIds, managementController);
        this.setRequiredCreateAuthorizations(EnumSet.of(RoleAuthorization.OBDP_MANAGE_STACK_VERSIONS, RoleAuthorization.CLUSTER_UPGRADE_DOWNGRADE_STACK));
        this.setRequiredDeleteAuthorizations(EnumSet.of(RoleAuthorization.OBDP_MANAGE_STACK_VERSIONS, RoleAuthorization.CLUSTER_UPGRADE_DOWNGRADE_STACK));
        this.setRequiredUpdateAuthorizations(EnumSet.of(RoleAuthorization.OBDP_MANAGE_STACK_VERSIONS, RoleAuthorization.CLUSTER_UPGRADE_DOWNGRADE_STACK));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<Resource> getResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Cluster cluster;
        LinkedHashSet<Resource> resources = new LinkedHashSet<Resource>();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        if (1 != propertyMaps.size()) {
            throw new SystemException("Cannot request more than one resource");
        }
        Map<String, Object> propertyMap = propertyMaps.iterator().next();
        String clusterName = propertyMap.get(CLUSTER_STACK_VERSION_CLUSTER_NAME_PROPERTY_ID).toString();
        try {
            cluster = ((Clusters)clusters.get()).getCluster(clusterName);
        }
        catch (OBDPException e) {
            throw new SystemException(e.getMessage(), e);
        }
        LinkedHashSet<Long> requestedEntities = new LinkedHashSet<Long>();
        if (propertyMap.containsKey(CLUSTER_STACK_VERSION_ID_PROPERTY_ID)) {
            Long id = Long.parseLong(propertyMap.get(CLUSTER_STACK_VERSION_ID_PROPERTY_ID).toString());
            requestedEntities.add(id);
        } else {
            List entities = repositoryVersionDAO.findAll();
            Collections.sort(entities, new Comparator<RepositoryVersionEntity>(){

                @Override
                public int compare(RepositoryVersionEntity o1, RepositoryVersionEntity o2) {
                    return VersionUtils.compareVersionsWithBuild((String)o1.getVersion(), (String)o2.getVersion(), (int)4);
                }
            });
            for (RepositoryVersionEntity entity : entities) {
                requestedEntities.add(entity.getId());
            }
        }
        if (requestedEntities.isEmpty()) {
            throw new SystemException("Could not find any repositories to show");
        }
        UpgradeEntity revertableUpgrade = null;
        if (null == cluster.getUpgradeInProgress()) {
            revertableUpgrade = upgradeDAO.findRevertable(cluster.getClusterId());
        }
        for (Long repositoryVersionId : requestedEntities) {
            void var20_23;
            ResourceImpl resource = new ResourceImpl(Resource.Type.ClusterStackVersion);
            RepositoryVersionEntity repositoryVersion = (RepositoryVersionEntity)repositoryVersionDAO.findByPK(repositoryVersionId);
            ArrayList<RepositoryVersionState> allStates = new ArrayList<RepositoryVersionState>();
            HashMap hostStates = new HashMap();
            for (RepositoryVersionState repositoryVersionState : RepositoryVersionState.values()) {
                hostStates.put(repositoryVersionState, new ArrayList());
            }
            StackEntity repoVersionStackEntity = repositoryVersion.getStack();
            StackId repoVersionStackId = new StackId(repoVersionStackEntity);
            List<HostVersionEntity> hostVersionsForRepository = hostVersionDAO.findHostVersionByClusterAndRepository(cluster.getClusterId(), repositoryVersion);
            for (HostVersionEntity hostVersionEntity : hostVersionsForRepository) {
                ((List)hostStates.get((Object)hostVersionEntity.getState())).add(hostVersionEntity.getHostName());
                allStates.add(hostVersionEntity.getState());
            }
            Object var20_27 = null;
            try {
                VersionDefinitionXml vdf = repositoryVersion.getRepositoryXml();
                if (null != vdf) {
                    ClusterVersionSummary clusterVersionSummary = vdf.getClusterSummary(cluster, (OBDPMetaInfo)metaInfo.get());
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Version %s is backed by a version definition, but it could not be parsed", repositoryVersion.getVersion()), e);
            }
            ClusterStackVersionResourceProvider.setResourceProperty(resource, CLUSTER_STACK_VERSION_CLUSTER_NAME_PROPERTY_ID, clusterName, requestedIds);
            ClusterStackVersionResourceProvider.setResourceProperty(resource, CLUSTER_STACK_VERSION_HOST_STATES_PROPERTY_ID, hostStates, requestedIds);
            ClusterStackVersionResourceProvider.setResourceProperty(resource, CLUSTER_STACK_VERSION_REPO_SUMMARY_PROPERTY_ID, var20_23, requestedIds);
            ClusterStackVersionResourceProvider.setResourceProperty(resource, CLUSTER_STACK_VERSION_ID_PROPERTY_ID, repositoryVersion.getId(), requestedIds);
            ClusterStackVersionResourceProvider.setResourceProperty(resource, CLUSTER_STACK_VERSION_STACK_PROPERTY_ID, repoVersionStackId.getStackName(), requestedIds);
            ClusterStackVersionResourceProvider.setResourceProperty(resource, CLUSTER_STACK_VERSION_VERSION_PROPERTY_ID, repoVersionStackId.getStackVersion(), requestedIds);
            ClusterStackVersionResourceProvider.setResourceProperty(resource, CLUSTER_STACK_VERSION_REPOSITORY_VERSION_PROPERTY_ID, repositoryVersion.getId(), requestedIds);
            RepositoryVersionState aggregateState = RepositoryVersionState.getAggregateState(allStates);
            ClusterStackVersionResourceProvider.setResourceProperty(resource, CLUSTER_STACK_VERSION_STATE_PROPERTY_ID, (Object)aggregateState, requestedIds);
            boolean revertable = false;
            if (null != revertableUpgrade) {
                RepositoryVersionEntity revertableRepositoryVersion = revertableUpgrade.getRepositoryVersion();
                revertable = Objects.equals(revertableRepositoryVersion.getId(), repositoryVersionId);
            }
            ClusterStackVersionResourceProvider.setResourceProperty(resource, CLUSTER_STACK_VERSION_REPO_SUPPORTS_REVERT, revertable, requestedIds);
            if (revertable) {
                ClusterStackVersionResourceProvider.setResourceProperty(resource, CLUSTER_STACK_VERSION_REPO_REVERT_UPGRADE_ID, revertableUpgrade.getId(), requestedIds);
            }
            if (predicate != null && !predicate.evaluate(resource)) continue;
            resources.add(resource);
        }
        return resources;
    }

    @Override
    public RequestStatus createResourcesAuthorized(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        Cluster cluster;
        if (request.getProperties().size() > 1) {
            throw new UnsupportedOperationException("Multiple requests cannot be executed at the same time.");
        }
        Iterator<Map<String, Object>> iterator = request.getProperties().iterator();
        Map<String, Object> propertyMap = iterator.next();
        HashSet<String> requiredProperties = new HashSet<String>();
        requiredProperties.add(CLUSTER_STACK_VERSION_CLUSTER_NAME_PROPERTY_ID);
        requiredProperties.add(CLUSTER_STACK_VERSION_REPOSITORY_VERSION_PROPERTY_ID);
        requiredProperties.add(CLUSTER_STACK_VERSION_STACK_PROPERTY_ID);
        requiredProperties.add(CLUSTER_STACK_VERSION_VERSION_PROPERTY_ID);
        for (String requiredProperty : requiredProperties) {
            if (propertyMap.containsKey(requiredProperty)) continue;
            throw new IllegalArgumentException(String.format("The required property %s is not defined", requiredProperty));
        }
        String clName = (String)propertyMap.get(CLUSTER_STACK_VERSION_CLUSTER_NAME_PROPERTY_ID);
        String desiredRepoVersion = (String)propertyMap.get(CLUSTER_STACK_VERSION_REPOSITORY_VERSION_PROPERTY_ID);
        OBDPManagementController managementController = this.getManagementController();
        OBDPMetaInfo ami = managementController.getAmbariMetaInfo();
        try {
            Clusters clusters = managementController.getClusters();
            cluster = clusters.getCluster(clName);
        }
        catch (OBDPException e) {
            throw new NoSuchParentResourceException(e.getMessage(), e);
        }
        UpgradeEntity entity = cluster.getUpgradeInProgress();
        if (null != entity) {
            throw new IllegalArgumentException(String.format("Cluster %s %s is in progress.  Cannot install packages.", cluster.getClusterName(), entity.getDirection().getText(false)));
        }
        String stackName = (String)propertyMap.get(CLUSTER_STACK_VERSION_STACK_PROPERTY_ID);
        String stackVersion = (String)propertyMap.get(CLUSTER_STACK_VERSION_VERSION_PROPERTY_ID);
        if (StringUtils.isBlank((String)stackName) || StringUtils.isBlank((String)stackVersion)) {
            String message = String.format("Both the %s and %s properties are required when distributing a new stack", CLUSTER_STACK_VERSION_STACK_PROPERTY_ID, CLUSTER_STACK_VERSION_VERSION_PROPERTY_ID);
            throw new SystemException(message);
        }
        StackId stackId = new StackId(stackName, stackVersion);
        if (!ami.isSupportedStack(stackName, stackVersion)) {
            throw new NoSuchParentResourceException(String.format("Stack %s is not supported", stackId));
        }
        try {
            this.bootstrapStackTools(stackId, cluster);
        }
        catch (OBDPException ambariException) {
            throw new SystemException("Unable to modify stack tools for new stack being distributed", ambariException);
        }
        RepositoryVersionEntity repoVersionEntity = repositoryVersionDAO.findByStackAndVersion(stackId, desiredRepoVersion);
        if (repoVersionEntity == null) {
            throw new IllegalArgumentException(String.format("Repo version %s is not available for stack %s", desiredRepoVersion, stackId));
        }
        VersionDefinitionXml desiredVersionDefinition = null;
        try {
            desiredVersionDefinition = repoVersionEntity.getRepositoryXml();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Version %s is backed by a version definition, but it could not be parsed", desiredRepoVersion), e);
        }
        try {
            Set<String> missingDependencies;
            if (repoVersionEntity.getType().isPartial() && !(missingDependencies = desiredVersionDefinition.getMissingDependencies(cluster, (OBDPMetaInfo)metaInfo.get())).isEmpty()) {
                String message = String.format("The following services are also required to be included in this upgrade: %s", StringUtils.join(missingDependencies, (String)", "));
                throw new SystemException(message.toString());
            }
        }
        catch (OBDPException ambariException) {
            throw new SystemException("Unable to determine if this repository contains the necessary service dependencies", ambariException);
        }
        boolean forceInstalled = Boolean.parseBoolean((String)propertyMap.get(CLUSTER_STACK_VERSION_FORCE));
        try {
            return this.createOrUpdateHostVersions(cluster, repoVersionEntity, desiredVersionDefinition, stackId, forceInstalled, propertyMap);
        }
        catch (OBDPException e) {
            throw new SystemException("Can not persist request", e);
        }
    }

    @Transactional(rollbackOn={RuntimeException.class, SystemException.class, OBDPException.class})
    RequestStatus createOrUpdateHostVersions(Cluster cluster, RepositoryVersionEntity repoVersionEntity, VersionDefinitionXml versionDefinitionXml, StackId stackId, boolean forceInstalled, Map<String, Object> propertyMap) throws OBDPException, SystemException {
        String desiredRepoVersion = repoVersionEntity.getVersion();
        ArrayList hosts = Lists.newArrayList(cluster.getHosts());
        for (Host host : hosts) {
            for (HostVersionEntity hostVersion : host.getAllHostVersions()) {
                int compare;
                RepositoryVersionEntity hostRepoVersion = hostVersion.getRepositoryVersion();
                if (!hostRepoVersion.getStackName().equals(repoVersionEntity.getStackName()) || (compare = VersionUtils.compareVersionsWithBuild((String)hostRepoVersion.getVersion(), (String)desiredRepoVersion, (int)4)) <= 0 || null == versionDefinitionXml || !StringUtils.isBlank((String)versionDefinitionXml.getPackageVersion(host.getOsFamily()))) continue;
                String msg = String.format("Ambari cannot install version %s.  Version %s is already installed.", desiredRepoVersion, hostRepoVersion.getVersion());
                throw new IllegalArgumentException(msg);
            }
        }
        List<Host> hostsNeedingInstallCommands = cluster.transitionHostsToInstalling(repoVersionEntity, versionDefinitionXml, forceInstalled);
        RequestStatusResponse response = null;
        if (!forceInstalled) {
            RequestStageContainer installRequest = this.createOrchestration(cluster, stackId, hostsNeedingInstallCommands, repoVersionEntity, versionDefinitionXml, propertyMap);
            response = installRequest.getRequestStatusResponse();
        }
        return this.getRequestStatus(response);
    }

    @Transactional
    RequestStageContainer createOrchestration(Cluster cluster, StackId stackId, List<Host> hosts, RepositoryVersionEntity repoVersionEnt, VersionDefinitionXml desiredVersionDefinition, Map<String, Object> propertyMap) throws OBDPException, SystemException {
        OBDPManagementController managementController = this.getManagementController();
        OBDPMetaInfo ami = managementController.getAmbariMetaInfo();
        List<RepoOsEntity> operatingSystems = repoVersionEnt.getRepoOsEntities();
        HashMap<String, List<RepoDefinitionEntity>> perOsRepos = new HashMap<String, List<RepoDefinitionEntity>>();
        for (RepoOsEntity operatingSystem : operatingSystems) {
            if (operatingSystem.isAmbariManaged()) {
                perOsRepos.put(operatingSystem.getFamily(), operatingSystem.getRepoDefinitionEntities());
                continue;
            }
            perOsRepos.put(operatingSystem.getFamily(), Collections.emptyList());
        }
        RequestStageContainer req = this.createRequest();
        Iterator<Host> hostIterator = hosts.iterator();
        HashMap<String, String> hostLevelParams = new HashMap<String, String>();
        hostLevelParams.put("jdk_location", this.getManagementController().getJdkResourceUrl());
        String hostParamsJson = StageUtils.getGson().toJson(hostLevelParams);
        int maxTasks = configuration.getAgentPackageParallelCommandsLimit();
        int hostCount = hosts.size();
        int batchCount = (int)Math.ceil((double)hostCount / (double)maxTasks);
        long stageId = req.getLastStageId() + 1L;
        if (0L == stageId) {
            stageId = 1L;
        }
        Float successFactor = Float.valueOf(0.85f);
        String successFactorProperty = (String)propertyMap.get(CLUSTER_STACK_VERSION_STAGE_SUCCESS_FACTOR);
        if (StringUtils.isNotBlank((String)successFactorProperty)) {
            successFactor = Float.valueOf(successFactorProperty);
        }
        boolean hasStage = false;
        ArrayList<Stage> stages = new ArrayList<Stage>(batchCount);
        for (int batchId = 1; batchId <= batchCount; ++batchId) {
            String stageName = batchCount > 1 ? String.format("Install Version. Batch %d of %d", batchId, batchCount) : INSTALL_PACKAGES_FULL_NAME;
            Stage stage = stageFactory.createNew(req.getId(), "/tmp/obdp", cluster.getClusterName(), cluster.getClusterId(), stageName, "{}", hostParamsJson);
            stage.getSuccessFactors().put(Role.INSTALL_PACKAGES, successFactor);
            stage.setStageId(stageId);
            ++stageId;
            stages.add(stage);
            HashSet<String> serviceNames = new HashSet<String>();
            if (RepositoryType.STANDARD != repoVersionEnt.getType()) {
                ClusterVersionSummary clusterSummary = desiredVersionDefinition.getClusterSummary(cluster, (OBDPMetaInfo)metaInfo.get());
                serviceNames.addAll(clusterSummary.getAvailableServiceNames());
            } else {
                serviceNames.addAll(ami.getStack(stackId).getServiceNames());
            }
            for (int i = 0; i < maxTasks && hostIterator.hasNext(); ++i) {
                ActionExecutionContext actionContext;
                Host host = hostIterator.next();
                if (!this.hostHasVersionableComponents(cluster, serviceNames, ami, stackId, host) || null == (actionContext = this.getHostVersionInstallCommand(repoVersionEnt, cluster, managementController, ami, stackId, serviceNames, stage, host))) continue;
                try {
                    ((OBDPActionExecutionHelper)actionExecutionHelper.get()).addExecutionCommandsToStage(actionContext, stage, null);
                    hasStage = true;
                    continue;
                }
                catch (OBDPException e) {
                    throw new SystemException("Cannot modify stage", e);
                }
            }
        }
        if (!hasStage) {
            throw new SystemException(String.format("There are no hosts that have components to install for repository %s", repoVersionEnt.getDisplayName()));
        }
        req.addStages(stages);
        req.persist();
        return req;
    }

    @Transactional
    ActionExecutionContext getHostVersionInstallCommand(RepositoryVersionEntity repoVersion, Cluster cluster, OBDPManagementController managementController, OBDPMetaInfo ami, StackId stackId, Set<String> repoServices, Stage stage1, Host host) throws SystemException {
        String osFamily = host.getOsFamily();
        RepoOsEntity osEntity = repoVersionHelper.getOSEntityForHost(host, repoVersion);
        if (CollectionUtils.isEmpty(osEntity.getRepoDefinitionEntities())) {
            throw new SystemException(String.format("Repositories for os type %s are not defined for version %s of Stack %s.", osFamily, repoVersion.getVersion(), stackId));
        }
        HashSet<String> servicesOnHost = new HashSet<String>();
        List<ServiceComponentHost> components = cluster.getServiceComponentHosts(host.getHostName());
        for (ServiceComponentHost component : components) {
            if (!repoServices.isEmpty() && !repoServices.contains(component.getServiceName())) continue;
            servicesOnHost.add(component.getServiceName());
        }
        if (servicesOnHost.isEmpty()) {
            return null;
        }
        Map<String, String> roleParams = repoVersionHelper.buildRoleParams(managementController, repoVersion, osFamily, servicesOnHost);
        RequestResourceFilter filter = new RequestResourceFilter(null, null, Collections.singletonList(host.getHostName()));
        ActionExecutionContext actionContext = new ActionExecutionContext(cluster.getClusterName(), INSTALL_PACKAGES_ACTION, Collections.singletonList(filter), roleParams);
        actionContext.setStackId(repoVersion.getStackId());
        actionContext.setTimeout(Integer.valueOf(configuration.getDefaultAgentTaskTimeout(true)));
        repoVersionHelper.addCommandRepositoryToContext(actionContext, repoVersion, osEntity);
        return actionContext;
    }

    private boolean hostHasVersionableComponents(Cluster cluster, Set<String> serviceNames, OBDPMetaInfo ami, StackId stackId, Host host) throws SystemException {
        List<ServiceComponentHost> components = cluster.getServiceComponentHosts(host.getHostName());
        for (ServiceComponentHost component : components) {
            ComponentInfo componentInfo;
            if (!serviceNames.isEmpty() && !serviceNames.contains(component.getServiceName())) continue;
            try {
                componentInfo = ami.getComponent(stackId.getStackName(), stackId.getStackVersion(), component.getServiceName(), component.getServiceComponentName());
            }
            catch (OBDPException e) {
                LOG.warn(String.format("Exception while accessing component %s of service %s for stack %s", component.getServiceComponentName(), component.getServiceName(), stackId));
                continue;
            }
            if (!componentInfo.isVersionAdvertised()) continue;
            return true;
        }
        return false;
    }

    private RequestStageContainer createRequest() {
        ActionManager actionManager = this.getManagementController().getActionManager();
        RequestStageContainer requestStages = new RequestStageContainer(actionManager.getNextRequestId(), null, requestFactory, actionManager);
        requestStages.setRequestContext(INSTALL_PACKAGES_FULL_NAME);
        return requestStages;
    }

    @Override
    public RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new SystemException("Method not supported");
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return pkPropertyIds;
    }

    private void bootstrapStackTools(StackId stackId, Cluster cluster) throws OBDPException {
        if (StringUtils.equals((String)stackId.getStackName(), (String)cluster.getCurrentStackVersion().getStackName())) {
            return;
        }
        ConfigHelper configHelper = (ConfigHelper)configHelperProvider.get();
        Map<String, Map<String, String>> defaultStackConfigurationsByType = configHelper.getDefaultStackProperties(stackId);
        Map<String, String> clusterEnvDefaults = defaultStackConfigurationsByType.get("cluster-env");
        Config clusterEnv = cluster.getDesiredConfigByType("cluster-env");
        Map<String, String> clusterEnvProperties = clusterEnv.getProperties();
        HashSet properties = Sets.newHashSet((Object[])new String[]{"stack_root", "stack_tools", "stack_features", "stack_packages"});
        HashMap<String, String> updatedProperties = new HashMap<String, String>();
        for (String property : properties) {
            Map newStackJsonAsObject;
            Map existingJson;
            String newStackDefaultJson = clusterEnvDefaults.get(property);
            if (StringUtils.isBlank((String)newStackDefaultJson)) continue;
            String existingPropertyJson = clusterEnvProperties.get(property);
            if (StringUtils.isBlank((String)existingPropertyJson)) {
                updatedProperties.put(property, newStackDefaultJson);
                continue;
            }
            if (StringUtils.equals((String)property, (String)"stack_root")) {
                existingJson = (Map)gson.fromJson(existingPropertyJson, Map.class);
                newStackJsonAsObject = (Map)gson.fromJson(newStackDefaultJson, Map.class);
            } else {
                existingJson = (Map)gson.fromJson(existingPropertyJson, Map.class);
                newStackJsonAsObject = (Map)gson.fromJson(newStackDefaultJson, Map.class);
            }
            if (existingJson.keySet().contains(stackId.getStackName())) continue;
            existingJson.put(stackId.getStackName(), newStackJsonAsObject.get(stackId.getStackName()));
            String newJson = gson.toJson((Object)existingJson);
            updatedProperties.put(property, newJson);
        }
        if (!updatedProperties.isEmpty()) {
            OBDPManagementController amc = this.getManagementController();
            String serviceNote = String.format("Adding stack tools for %s while distributing a new repository", stackId.toString());
            configHelper.updateConfigType(cluster, stackId, amc, clusterEnv.getType(), updatedProperties, null, amc.getAuthName(), serviceNote);
        }
    }
}

