/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.ClusterRequest;
import id.onyx.obdp.server.controller.ClusterResponse;
import id.onyx.obdp.server.controller.ConfigurationRequest;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.RequestStatusResponse;
import id.onyx.obdp.server.controller.ServiceConfigVersionRequest;
import id.onyx.obdp.server.controller.ServiceConfigVersionResponse;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ProvisionClusterRequest;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.state.SecurityType;
import id.onyx.obdp.server.topology.InvalidTopologyException;
import id.onyx.obdp.server.topology.InvalidTopologyTemplateException;
import id.onyx.obdp.server.topology.SecurityConfiguration;
import id.onyx.obdp.server.topology.SecurityConfigurationFactory;
import id.onyx.obdp.server.topology.TopologyManager;
import id.onyx.obdp.server.topology.TopologyRequestFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;

public class ClusterResourceProvider
extends AbstractControllerResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterResourceProvider.class);
    public static final String RESPONSE_KEY = "Clusters";
    public static final String ALL_PROPERTIES = "Clusters/*";
    public static final String CLUSTER_ID = "cluster_id";
    public static final String CLUSTER_NAME = "cluster_name";
    public static final String VERSION = "version";
    public static final String PROVISIONING_STATE = "provisioning_state";
    public static final String SECURITY_TYPE = "security_type";
    public static final String DESIRED_CONFIGS = "desired_configs";
    public static final String DESIRED_SERVICE_CONFIG_VERSIONS = "desired_service_config_versions";
    public static final String TOTAL_HOSTS = "total_hosts";
    public static final String HEALTH_REPORT = "health_report";
    public static final String CREDENTIAL_STORE_PROPERTIES = "credential_store_properties";
    public static final String REPO_VERSION = "repository_version";
    public static final String CLUSTER_ID_PROPERTY_ID = "Clusters/cluster_id";
    public static final String CLUSTER_NAME_PROPERTY_ID = "Clusters/cluster_name";
    public static final String CLUSTER_VERSION_PROPERTY_ID = "Clusters/version";
    public static final String CLUSTER_PROVISIONING_STATE_PROPERTY_ID = "Clusters/provisioning_state";
    public static final String CLUSTER_SECURITY_TYPE_PROPERTY_ID = "Clusters/security_type";
    public static final String CLUSTER_DESIRED_CONFIGS_PROPERTY_ID = "Clusters/desired_configs";
    public static final String CLUSTER_DESIRED_SERVICE_CONFIG_VERSIONS_PROPERTY_ID = "Clusters/desired_service_config_versions";
    public static final String CLUSTER_TOTAL_HOSTS_PROPERTY_ID = "Clusters/total_hosts";
    public static final String CLUSTER_HEALTH_REPORT_PROPERTY_ID = "Clusters/health_report";
    public static final String CLUSTER_CREDENTIAL_STORE_PROPERTIES_PROPERTY_ID = "Clusters/credential_store_properties";
    public static final String CLUSTER_STATE_PROPERTY_ID = PropertyHelper.getPropertyId("Clusters", "state");
    static final String BLUEPRINT = "blueprint";
    public static final String SECURITY = "security";
    public static final String CREDENTIALS = "credentials";
    private static final String QUICKLINKS_PROFILE = "quicklinks_profile";
    private static final String SESSION_ATTRIBUTES = "session_attributes";
    private static final String SESSION_ATTRIBUTES_PROPERTY_PREFIX = "session_attributes/";
    public static final String GET_IGNORE_PERMISSIONS_PROPERTY_ID = "get_resource/ignore_permissions";
    private static TopologyManager topologyManager;
    private static TopologyRequestFactory topologyRequestFactory;
    private static SecurityConfigurationFactory securityConfigurationFactory;
    protected static final Map<Resource.Type, String> keyPropertyIds;
    protected static final Set<String> propertyIds;
    private static Gson jsonSerializer;

    ClusterResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.Cluster, propertyIds, keyPropertyIds, managementController);
        this.setRequiredCreateAuthorizations(EnumSet.of(RoleAuthorization.OBDP_ADD_DELETE_CLUSTERS));
        this.setRequiredDeleteAuthorizations(EnumSet.of(RoleAuthorization.OBDP_ADD_DELETE_CLUSTERS));
        this.setRequiredGetAuthorizations(RoleAuthorization.AUTHORIZATIONS_VIEW_CLUSTER);
        this.setRequiredUpdateAuthorizations(RoleAuthorization.AUTHORIZATIONS_UPDATE_CLUSTER);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(Collections.singletonList(CLUSTER_ID_PROPERTY_ID));
    }

    @Override
    public Set<String> checkPropertyIds(Set<String> propertyIds) {
        Set<String> baseUnsupported = super.checkPropertyIds(propertyIds);
        baseUnsupported.remove(BLUEPRINT);
        baseUnsupported.remove("host_groups");
        baseUnsupported.remove("default_password");
        baseUnsupported.remove("configurations");
        baseUnsupported.remove(CREDENTIALS);
        baseUnsupported.remove("config_recommendation_strategy");
        baseUnsupported.remove("provision_action");
        baseUnsupported.remove(REPO_VERSION);
        baseUnsupported.remove("repository_version_id");
        return this.checkConfigPropertyIds(baseUnsupported, RESPONSE_KEY);
    }

    @Override
    protected boolean isAuthorizedToCreateResources(Authentication authentication, Request request) {
        return AuthorizationHelper.isAuthorized(authentication, ResourceType.OBDP, null, this.getRequiredCreateAuthorizations());
    }

    @Override
    protected boolean isAuthorizedToDeleteResources(Authentication authentication, Predicate predicate) throws SystemException {
        return AuthorizationHelper.isAuthorized(authentication, ResourceType.OBDP, null, this.getRequiredDeleteAuthorizations());
    }

    @Override
    protected RequestStatus createResourcesAuthorized(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        RequestStatusResponse createResponse = null;
        for (Map<String, Object> properties : request.getProperties()) {
            if (this.isCreateFromBlueprint(properties)) {
                createResponse = this.processBlueprintCreate(properties, request.getRequestInfoProperties());
                continue;
            }
            this.createClusterResource(properties);
        }
        this.notifyCreate(Resource.Type.Cluster, request);
        return this.getRequestStatus(createResponse);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<ClusterRequest> requests = new HashSet<ClusterRequest>();
        if (predicate == null) {
            requests.add(this.getRequest(Collections.emptyMap()));
        } else {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
                requests.add(this.getRequest(propertyMap));
            }
        }
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<ClusterResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<ClusterResponse>>(){

            @Override
            public Set<ClusterResponse> invoke() throws OBDPException, AuthorizationException {
                return ClusterResourceProvider.this.getManagementController().getClusters(requests);
            }
        });
        HashSet<Resource> resources = new HashSet<Resource>();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found clusters matching getClusters request, clusterResponseCount={}", (Object)responses.size());
        }
        for (ClusterResponse response : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.Cluster);
            ClusterResourceProvider.setResourceProperty(resource, CLUSTER_ID_PROPERTY_ID, response.getClusterId(), requestedIds);
            ClusterResourceProvider.setResourceProperty(resource, CLUSTER_NAME_PROPERTY_ID, response.getClusterName(), requestedIds);
            ClusterResourceProvider.setResourceProperty(resource, CLUSTER_PROVISIONING_STATE_PROPERTY_ID, response.getProvisioningState().name(), requestedIds);
            ClusterResourceProvider.setResourceProperty(resource, CLUSTER_SECURITY_TYPE_PROPERTY_ID, response.getSecurityType().name(), requestedIds);
            ClusterResourceProvider.setResourceProperty(resource, CLUSTER_DESIRED_CONFIGS_PROPERTY_ID, response.getDesiredConfigs(), requestedIds);
            ClusterResourceProvider.setResourceProperty(resource, CLUSTER_DESIRED_SERVICE_CONFIG_VERSIONS_PROPERTY_ID, response.getDesiredServiceConfigVersions(), requestedIds);
            ClusterResourceProvider.setResourceProperty(resource, CLUSTER_TOTAL_HOSTS_PROPERTY_ID, response.getTotalHosts(), requestedIds);
            ClusterResourceProvider.setResourceProperty(resource, CLUSTER_HEALTH_REPORT_PROPERTY_ID, response.getClusterHealthReport(), requestedIds);
            ClusterResourceProvider.setResourceProperty(resource, CLUSTER_CREDENTIAL_STORE_PROPERTIES_PROPERTY_ID, response.getCredentialStoreServiceProperties(), requestedIds);
            ClusterResourceProvider.setResourceProperty(resource, CLUSTER_VERSION_PROPERTY_ID, response.getDesiredStackVersion(), requestedIds);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding ClusterResponse to resource, clusterResponse={}", (Object)response);
            }
            resources.add(resource);
        }
        return resources;
    }

    @Override
    protected RequestStatus updateResourcesAuthorized(final Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<ClusterRequest> requests = new HashSet<ClusterRequest>();
        for (Map<String, Object> requestPropertyMap : request.getProperties()) {
            Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(requestPropertyMap, predicate);
            for (Map<String, Object> propertyMap : propertyMaps) {
                ClusterRequest clusterRequest = this.getRequest(propertyMap);
                requests.add(clusterRequest);
            }
        }
        RequestStatusResponse response = this.modifyResources(new AbstractResourceProvider.Command<RequestStatusResponse>(){

            @Override
            public RequestStatusResponse invoke() throws OBDPException, AuthorizationException {
                return ClusterResourceProvider.this.getManagementController().updateClusters(requests, request.getRequestInfoProperties());
            }
        });
        this.notifyUpdate(Resource.Type.Cluster, request, predicate);
        HashSet<ResourceImpl> associatedResources = null;
        for (ClusterRequest clusterRequest : requests) {
            Map<String, Collection<ServiceConfigVersionResponse>> serviceConfigVersions;
            ClusterResponse updateResults = this.getManagementController().getClusterUpdateResults(clusterRequest);
            if (updateResults == null || (serviceConfigVersions = updateResults.getDesiredServiceConfigVersions()) == null) continue;
            associatedResources = new HashSet<ResourceImpl>();
            for (Collection<ServiceConfigVersionResponse> scvCollection : serviceConfigVersions.values()) {
                for (ServiceConfigVersionResponse serviceConfigVersionResponse : scvCollection) {
                    ResourceImpl resource = new ResourceImpl(Resource.Type.ServiceConfigVersion);
                    resource.setProperty("service_name", serviceConfigVersionResponse.getServiceName());
                    resource.setProperty("service_config_version", serviceConfigVersionResponse.getVersion());
                    resource.setProperty("service_config_version_note", serviceConfigVersionResponse.getNote());
                    resource.setProperty("group_id", serviceConfigVersionResponse.getGroupId());
                    resource.setProperty("group_name", serviceConfigVersionResponse.getGroupName());
                    if (serviceConfigVersionResponse.getConfigurations() != null) {
                        resource.setProperty("configurations", serviceConfigVersionResponse.getConfigurations());
                    }
                    associatedResources.add(resource);
                }
            }
        }
        return this.getRequestStatus(response, associatedResources);
    }

    @Override
    protected RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            final ClusterRequest clusterRequest = this.getRequest(propertyMap);
            this.modifyResources(new AbstractResourceProvider.Command<Void>(){

                @Override
                public Void invoke() throws OBDPException {
                    ClusterResourceProvider.this.getManagementController().deleteCluster(clusterRequest);
                    return null;
                }
            });
        }
        this.notifyDelete(Resource.Type.Cluster, predicate);
        return this.getRequestStatus(null);
    }

    public static void init(TopologyManager manager, TopologyRequestFactory requestFactory, SecurityConfigurationFactory securityFactory, Gson instance) {
        topologyManager = manager;
        topologyRequestFactory = requestFactory;
        securityConfigurationFactory = securityFactory;
        jsonSerializer = instance;
    }

    private ClusterRequest getRequest(Map<String, Object> properties) {
        ServiceConfigVersionRequest serviceConfigVersionRequest;
        SecurityType securityType;
        String requestedSecurityType = (String)properties.get(CLUSTER_SECURITY_TYPE_PROPERTY_ID);
        if (requestedSecurityType == null) {
            securityType = null;
        } else {
            try {
                securityType = SecurityType.valueOf(requestedSecurityType.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Cannot set cluster security type to invalid value: %s", requestedSecurityType));
            }
        }
        ClusterRequest cr = new ClusterRequest((Long)properties.get(CLUSTER_ID_PROPERTY_ID), (String)properties.get(CLUSTER_NAME_PROPERTY_ID), (String)properties.get(CLUSTER_PROVISIONING_STATE_PROPERTY_ID), securityType, (String)properties.get(CLUSTER_VERSION_PROPERTY_ID), null, this.getSessionAttributes(properties));
        List<ConfigurationRequest> configRequests = ClusterResourceProvider.getConfigurationRequests(RESPONSE_KEY, properties);
        if (!configRequests.isEmpty()) {
            cr.setDesiredConfig(configRequests);
        }
        if ((serviceConfigVersionRequest = ClusterResourceProvider.getServiceConfigVersionRequest(RESPONSE_KEY, properties)) != null) {
            cr.setServiceConfigVersionRequest(serviceConfigVersionRequest);
        }
        return cr;
    }

    private Map<String, Object> getSessionAttributes(Map<String, Object> properties) {
        HashMap<String, Object> sessionAttributes = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String property = entry.getKey();
            if (!property.startsWith(SESSION_ATTRIBUTES_PROPERTY_PREFIX)) continue;
            String attributeName = property.substring(SESSION_ATTRIBUTES_PROPERTY_PREFIX.length());
            sessionAttributes.put(attributeName, entry.getValue());
        }
        return sessionAttributes;
    }

    protected static ServiceConfigVersionRequest getServiceConfigVersionRequest(String parentCategory, Map<String, Object> properties) {
        ServiceConfigVersionRequest serviceConfigVersionRequest = null;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String absCategory = PropertyHelper.getPropertyCategory(entry.getKey());
            String propName = PropertyHelper.getPropertyName(entry.getKey());
            if (absCategory == null || !absCategory.startsWith(parentCategory + "/desired_service_config_version")) continue;
            ServiceConfigVersionRequest serviceConfigVersionRequest2 = serviceConfigVersionRequest = serviceConfigVersionRequest == null ? new ServiceConfigVersionRequest() : serviceConfigVersionRequest;
            if (propName == null) continue;
            switch (propName) {
                case "service_name": {
                    serviceConfigVersionRequest.setServiceName(entry.getValue().toString());
                    break;
                }
                case "service_config_version": {
                    serviceConfigVersionRequest.setVersion(Long.valueOf(entry.getValue().toString()));
                    break;
                }
                case "service_config_version_note": {
                    serviceConfigVersionRequest.setNote(entry.getValue().toString());
                }
            }
        }
        return serviceConfigVersionRequest;
    }

    private boolean isCreateFromBlueprint(Map<String, Object> properties) {
        return properties.get(BLUEPRINT) != null;
    }

    private RequestStatusResponse processBlueprintCreate(Map<String, Object> properties, Map<String, String> requestInfoProperties) throws ResourceAlreadyExistsException, SystemException, UnsupportedPropertyException, NoSuchParentResourceException {
        ProvisionClusterRequest createClusterRequest;
        LOG.info("Creating Cluster '" + properties.get(CLUSTER_NAME_PROPERTY_ID) + "' based on blueprint '" + String.valueOf(properties.get(BLUEPRINT)) + "'.");
        String rawRequestBody = requestInfoProperties.get("RAW_REQUEST_BODY");
        Map rawBodyMap = (Map)jsonSerializer.fromJson(rawRequestBody, Map.class);
        SecurityConfiguration securityConfiguration = securityConfigurationFactory.createSecurityConfigurationFromRequest(rawBodyMap, false);
        try {
            createClusterRequest = topologyRequestFactory.createProvisionClusterRequest(properties, securityConfiguration);
        }
        catch (InvalidTopologyTemplateException e) {
            throw new IllegalArgumentException("Invalid Cluster Creation Template: " + e, e);
        }
        if (securityConfiguration != null && securityConfiguration.getType() == SecurityType.NONE && createClusterRequest.getBlueprint().getSecurity() != null && createClusterRequest.getBlueprint().getSecurity().getType() == SecurityType.KERBEROS) {
            throw new IllegalArgumentException("Setting security to NONE is not allowed as security type in blueprint is set to KERBEROS!");
        }
        try {
            return topologyManager.provisionCluster(createClusterRequest);
        }
        catch (InvalidTopologyException e) {
            throw new IllegalArgumentException("Topology validation failed: " + e, e);
        }
        catch (OBDPException e) {
            throw new SystemException("Unknown exception when asking TopologyManager to provision cluster", e);
        }
        catch (RuntimeException e) {
            throw new SystemException("An exception occurred during cluster provisioning: " + e.getMessage(), e);
        }
    }

    private void createClusterResource(final Map<String, Object> properties) throws ResourceAlreadyExistsException, SystemException, NoSuchParentResourceException {
        this.createResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException, AuthorizationException {
                ClusterResourceProvider.this.getManagementController().createCluster(ClusterResourceProvider.this.getRequest(properties));
                return null;
            }
        });
    }

    static {
        keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Cluster, (Object)CLUSTER_NAME_PROPERTY_ID).build();
        propertyIds = ImmutableSet.builder().add((Object)CLUSTER_ID_PROPERTY_ID).add((Object)CLUSTER_NAME_PROPERTY_ID).add((Object)CLUSTER_VERSION_PROPERTY_ID).add((Object)CLUSTER_PROVISIONING_STATE_PROPERTY_ID).add((Object)CLUSTER_SECURITY_TYPE_PROPERTY_ID).add((Object)CLUSTER_DESIRED_CONFIGS_PROPERTY_ID).add((Object)CLUSTER_DESIRED_SERVICE_CONFIG_VERSIONS_PROPERTY_ID).add((Object)CLUSTER_TOTAL_HOSTS_PROPERTY_ID).add((Object)CLUSTER_HEALTH_REPORT_PROPERTY_ID).add((Object)CLUSTER_CREDENTIAL_STORE_PROPERTIES_PROPERTY_ID).add((Object)BLUEPRINT).add((Object)SESSION_ATTRIBUTES).add((Object)SECURITY).add((Object)CREDENTIALS).add((Object)QUICKLINKS_PROFILE).add((Object)CLUSTER_STATE_PROPERTY_ID).build();
    }
}

