/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.internal.PrivilegeResourceProvider;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.orm.dao.ClusterDAO;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.GroupEntity;
import id.onyx.obdp.server.orm.entities.PermissionEntity;
import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import id.onyx.obdp.server.orm.entities.ResourceEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterPrivilegeResourceProvider
extends PrivilegeResourceProvider<ClusterEntity> {
    protected static ClusterDAO clusterDAO;
    protected static final String CLUSTER_NAME_PROPERTY_ID = "cluster_name";
    protected static final String CLUSTER_NAME = "PrivilegeInfo/cluster_name";
    private static final Set<String> propertyIds;
    private static final Map<Resource.Type, String> keyPropertyIds;

    public ClusterPrivilegeResourceProvider() {
        super(propertyIds, keyPropertyIds, Resource.Type.ClusterPrivilege);
        EnumSet<RoleAuthorization> requiredAuthorizations = EnumSet.of(RoleAuthorization.OBDP_ASSIGN_ROLES);
        this.setRequiredCreateAuthorizations(requiredAuthorizations);
        this.setRequiredDeleteAuthorizations(requiredAuthorizations);
        this.setRequiredGetAuthorizations(requiredAuthorizations);
        this.setRequiredUpdateAuthorizations(requiredAuthorizations);
    }

    public static void init(ClusterDAO dao) {
        clusterDAO = dao;
    }

    @Override
    public Map<Resource.Type, String> getKeyPropertyIds() {
        return keyPropertyIds;
    }

    @Override
    public Map<Long, ClusterEntity> getResourceEntities(Map<String, Object> properties) {
        String clusterName = (String)properties.get(CLUSTER_NAME);
        if (clusterName == null) {
            HashMap<Long, ClusterEntity> resourceEntities = new HashMap<Long, ClusterEntity>();
            List<ClusterEntity> clusterEntities = clusterDAO.findAll();
            for (ClusterEntity clusterEntity : clusterEntities) {
                resourceEntities.put(clusterEntity.getResource().getId(), clusterEntity);
            }
            return resourceEntities;
        }
        ClusterEntity clusterEntity = clusterDAO.findByName(clusterName);
        return Collections.singletonMap(clusterEntity.getResource().getId(), clusterEntity);
    }

    @Override
    public Long getResourceEntityId(Predicate predicate) {
        String clusterName = ClusterPrivilegeResourceProvider.getQueryParameterValue(CLUSTER_NAME, predicate).toString();
        ClusterEntity clusterEntity = clusterDAO.findByName(clusterName);
        return clusterEntity.getResource().getId();
    }

    @Override
    protected Resource toResource(PrivilegeEntity privilegeEntity, Map<Long, UserEntity> userEntities, Map<Long, GroupEntity> groupEntities, Map<Long, PermissionEntity> roleEntities, Map<Long, ClusterEntity> resourceEntities, Set<String> requestedIds) {
        Resource resource = super.toResource(privilegeEntity, userEntities, groupEntities, roleEntities, resourceEntities, requestedIds);
        if (resource != null) {
            ClusterEntity clusterEntity = resourceEntities.get(privilegeEntity.getResource().getId());
            ClusterPrivilegeResourceProvider.setResourceProperty(resource, CLUSTER_NAME, clusterEntity.getClusterName(), requestedIds);
        }
        return resource;
    }

    @Override
    protected PermissionEntity getPermission(String permissionName, ResourceEntity resourceEntity) throws OBDPException {
        return super.getPermission(permissionName, resourceEntity);
    }

    static {
        propertyIds = Sets.newHashSet((Object[])new String[]{CLUSTER_NAME, "PrivilegeInfo/privilege_id", "PrivilegeInfo/permission_name", "PrivilegeInfo/permission_name", "PrivilegeInfo/permission_label", "PrivilegeInfo/principal_name", "PrivilegeInfo/principal_type"});
        keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Cluster, (Object)CLUSTER_NAME).put((Object)Resource.Type.ClusterPrivilege, (Object)"PrivilegeInfo/privilege_id").build();
    }
}

