/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ClusterKerberosDescriptorResourceProvider
extends ReadOnlyResourceProvider {
    public static final String DIRECTIVE_EVALUATE_WHEN_CLAUSE = "evaluate_when";
    public static final String DIRECTIVE_ADDITIONAL_SERVICES = "additional_services";
    public static final String CLUSTER_KERBEROS_DESCRIPTOR_CLUSTER_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("KerberosDescriptor", "cluster_name");
    public static final String CLUSTER_KERBEROS_DESCRIPTOR_TYPE_PROPERTY_ID = PropertyHelper.getPropertyId("KerberosDescriptor", "type");
    public static final String CLUSTER_KERBEROS_DESCRIPTOR_DESCRIPTOR_PROPERTY_ID = PropertyHelper.getPropertyId("KerberosDescriptor", "kerberos_descriptor");
    private static final Set<String> PK_PROPERTY_IDS;
    private static final Set<String> PROPERTY_IDS;
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS;
    private static final Set<RoleAuthorization> REQUIRED_GET_AUTHORIZATIONS;

    public ClusterKerberosDescriptorResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.ClusterKerberosDescriptor, PROPERTY_IDS, KEY_PROPERTY_IDS, managementController);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        AuthorizationHelper.verifyAuthorization(ResourceType.CLUSTER, null, REQUIRED_GET_AUTHORIZATIONS);
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<Resource> resources = new HashSet<Resource>();
        OBDPManagementController managementController = this.getManagementController();
        Clusters clusters = managementController.getClusters();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            KerberosDescriptor kerberosDescriptor;
            Cluster cluster;
            String clusterName = this.getClusterName(propertyMap);
            try {
                cluster = clusters.getCluster(clusterName);
                if (cluster == null) {
                    throw new NoSuchParentResourceException(String.format("A cluster with the name %s does not exist.", clusterName));
                }
            }
            catch (OBDPException e) {
                throw new NoSuchParentResourceException(String.format("A cluster with the name %s does not exist.", clusterName));
            }
            AuthorizationHelper.verifyAuthorization(ResourceType.CLUSTER, cluster.getResourceId(), REQUIRED_GET_AUTHORIZATIONS);
            KerberosHelper.KerberosDescriptorType kerberosDescriptorType = this.getKerberosDescriptorType(propertyMap);
            if (kerberosDescriptorType == null) {
                for (KerberosHelper.KerberosDescriptorType type : KerberosHelper.KerberosDescriptorType.values()) {
                    resources.add(this.toResource(clusterName, type, null, requestedIds));
                }
                continue;
            }
            try {
                KerberosHelper kerberosHelper = this.getManagementController().getKerberosHelper();
                Map<String, String> requestInfoProperties = request.getRequestInfoProperties();
                kerberosDescriptor = kerberosHelper.getKerberosDescriptor(kerberosDescriptorType, cluster, this.getEvaluateWhen(requestInfoProperties), this.getAdditionalServices(requestInfoProperties), false, null, null);
            }
            catch (OBDPException e) {
                throw new SystemException("An unexpected error occurred building the cluster's composite Kerberos Descriptor", e);
            }
            if (kerberosDescriptor == null) continue;
            resources.add(this.toResource(clusterName, kerberosDescriptorType, kerberosDescriptor, requestedIds));
        }
        return resources;
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return PK_PROPERTY_IDS;
    }

    private String getClusterName(Map<String, Object> propertyMap) {
        String clusterName = (String)propertyMap.get(CLUSTER_KERBEROS_DESCRIPTOR_CLUSTER_NAME_PROPERTY_ID);
        if (StringUtils.isEmpty((String)clusterName)) {
            throw new IllegalArgumentException("Invalid argument, cluster name is required");
        }
        return clusterName;
    }

    private KerberosHelper.KerberosDescriptorType getKerberosDescriptorType(Map<String, Object> propertyMap) {
        String type = (String)propertyMap.get(CLUSTER_KERBEROS_DESCRIPTOR_TYPE_PROPERTY_ID);
        KerberosHelper.KerberosDescriptorType kerberosDescriptorType = null;
        if (!StringUtils.isEmpty((String)type)) {
            try {
                kerberosDescriptorType = KerberosHelper.KerberosDescriptorType.valueOf(type.trim().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid argument, kerberos descriptor type of 'STACK', 'USER', or 'COMPOSITE' is required");
            }
        }
        return kerberosDescriptorType;
    }

    private boolean getEvaluateWhen(Map<String, String> requestInfoProperties) {
        return requestInfoProperties != null && "true".equalsIgnoreCase(requestInfoProperties.get(DIRECTIVE_EVALUATE_WHEN_CLAUSE));
    }

    private Collection<String> getAdditionalServices(Map<String, String> requestInfoProperties) {
        String value;
        if (requestInfoProperties != null && !StringUtils.isEmpty((String)(value = requestInfoProperties.get(DIRECTIVE_ADDITIONAL_SERVICES)))) {
            return Arrays.asList(value.split("\\s*,\\s*"));
        }
        return null;
    }

    private Resource toResource(String clusterName, KerberosHelper.KerberosDescriptorType kerberosDescriptorType, KerberosDescriptor kerberosDescriptor, Set<String> requestedIds) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.ClusterKerberosDescriptor);
        ClusterKerberosDescriptorResourceProvider.setResourceProperty(resource, CLUSTER_KERBEROS_DESCRIPTOR_CLUSTER_NAME_PROPERTY_ID, clusterName, requestedIds);
        if (kerberosDescriptorType != null) {
            ClusterKerberosDescriptorResourceProvider.setResourceProperty(resource, CLUSTER_KERBEROS_DESCRIPTOR_TYPE_PROPERTY_ID, kerberosDescriptorType.name(), requestedIds);
        }
        if (kerberosDescriptor != null) {
            ClusterKerberosDescriptorResourceProvider.setResourceProperty(resource, CLUSTER_KERBEROS_DESCRIPTOR_DESCRIPTOR_PROPERTY_ID, kerberosDescriptor.toMap(), requestedIds);
        }
        return resource;
    }

    static {
        REQUIRED_GET_AUTHORIZATIONS = EnumSet.of(RoleAuthorization.CLUSTER_TOGGLE_KERBEROS, RoleAuthorization.CLUSTER_VIEW_CONFIGS, RoleAuthorization.HOST_VIEW_CONFIGS, RoleAuthorization.SERVICE_VIEW_CONFIGS);
        HashSet<String> set = new HashSet<String>();
        set.add(CLUSTER_KERBEROS_DESCRIPTOR_CLUSTER_NAME_PROPERTY_ID);
        set.add(CLUSTER_KERBEROS_DESCRIPTOR_TYPE_PROPERTY_ID);
        PK_PROPERTY_IDS = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(CLUSTER_KERBEROS_DESCRIPTOR_CLUSTER_NAME_PROPERTY_ID);
        set.add(CLUSTER_KERBEROS_DESCRIPTOR_TYPE_PROPERTY_ID);
        set.add(CLUSTER_KERBEROS_DESCRIPTOR_DESCRIPTOR_PROPERTY_ID);
        PROPERTY_IDS = Collections.unmodifiableSet(set);
        HashMap<Resource.Type, String> map = new HashMap<Resource.Type, String>();
        map.put(Resource.Type.Cluster, CLUSTER_KERBEROS_DESCRIPTOR_CLUSTER_NAME_PROPERTY_ID);
        map.put(Resource.Type.ClusterKerberosDescriptor, CLUSTER_KERBEROS_DESCRIPTOR_TYPE_PROPERTY_ID);
        KEY_PROPERTY_IDS = Collections.unmodifiableMap(map);
    }
}

