/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.controller.internal.DefaultResourcePredicateEvaluator;
import id.onyx.obdp.server.controller.internal.PageResponseImpl;
import id.onyx.obdp.server.controller.internal.QueryResponseImpl;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.SchemaImpl;
import id.onyx.obdp.server.controller.spi.ClusterController;
import id.onyx.obdp.server.controller.spi.ExtendedResourceProvider;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.PageRequest;
import id.onyx.obdp.server.controller.spi.PageResponse;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.PropertyProvider;
import id.onyx.obdp.server.controller.spi.ProviderModule;
import id.onyx.obdp.server.controller.spi.QueryResponse;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.ResourcePredicateEvaluator;
import id.onyx.obdp.server.controller.spi.ResourceProvider;
import id.onyx.obdp.server.controller.spi.Schema;
import id.onyx.obdp.server.controller.spi.SortRequest;
import id.onyx.obdp.server.controller.spi.SortRequestProperty;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PredicateBuilder;
import id.onyx.obdp.server.controller.utilities.PredicateHelper;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterControllerImpl
implements ClusterController {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterControllerImpl.class);
    private final ProviderModule providerModule;
    private final Map<Resource.Type, ExtendedResourceProviderWrapper> resourceProviders = new HashMap<Resource.Type, ExtendedResourceProviderWrapper>();
    private final Map<Resource.Type, List<PropertyProvider>> propertyProviders = new HashMap<Resource.Type, List<PropertyProvider>>();
    private final Map<Resource.Type, Schema> schemas = new HashMap<Resource.Type, Schema>();
    private final ResourceComparator comparator = new ResourceComparator();
    private static final DefaultResourcePredicateEvaluator DEFAULT_RESOURCE_PREDICATE_EVALUATOR = new DefaultResourcePredicateEvaluator();

    public ClusterControllerImpl(ProviderModule providerModule) {
        this.providerModule = providerModule;
    }

    @Override
    public Predicate getAmendedPredicate(Resource.Type type, Predicate predicate) {
        ExtendedResourceProviderWrapper provider = this.ensureResourceProviderWrapper(type);
        this.ensurePropertyProviders(type);
        return provider.getAmendedPredicate(predicate);
    }

    @Override
    public QueryResponse getResources(Resource.Type type, Request request, Predicate predicate) throws UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException, SystemException {
        QueryResponse queryResponse = null;
        ExtendedResourceProviderWrapper provider = this.ensureResourceProviderWrapper(type);
        this.ensurePropertyProviders(type);
        if (provider != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using resource provider {} for request type {}", (Object)provider.getClass().getName(), (Object)type);
            }
            this.checkProperties(type, request, predicate);
            queryResponse = provider.queryForResources(request, predicate);
        }
        return queryResponse == null ? new QueryResponseImpl(Collections.emptySet()) : queryResponse;
    }

    @Override
    public Set<Resource> populateResources(Resource.Type type, Set<Resource> resources, Request request, Predicate predicate) throws SystemException {
        Set<Resource> keepers = resources;
        List<PropertyProvider> propertyProviders = this.ensurePropertyProviders(type);
        for (PropertyProvider propertyProvider : propertyProviders) {
            if (!this.providesRequestProperties(propertyProvider, request, predicate)) continue;
            keepers = propertyProvider.populateResources(keepers, request, predicate);
        }
        return keepers;
    }

    @Override
    public Iterable<Resource> getIterable(Resource.Type type, QueryResponse queryResponse, Request request, Predicate predicate, PageRequest pageRequest, SortRequest sortRequest) throws NoSuchParentResourceException, UnsupportedPropertyException, NoSuchResourceException, SystemException {
        return this.getPage(type, queryResponse, request, predicate, pageRequest, sortRequest).getIterable();
    }

    @Override
    public PageResponse getPage(Resource.Type type, QueryResponse queryResponse, Request request, Predicate predicate, PageRequest pageRequest, SortRequest sortRequest) throws UnsupportedPropertyException, SystemException, NoSuchResourceException, NoSuchParentResourceException {
        Set<Resource> providerResources = queryResponse.getResources();
        ExtendedResourceProviderWrapper provider = this.ensureResourceProviderWrapper(type);
        int totalCount = 0;
        Set<Resource> resources = providerResources;
        if (!providerResources.isEmpty()) {
            boolean providerAlreadyPaged = queryResponse.isPagedResponse();
            boolean providerAlreadySorted = queryResponse.isSortedResponse();
            ResourceComparator resourceComparator = this.comparator;
            if (null != sortRequest) {
                this.checkSortRequestProperties(sortRequest, type, provider);
                resourceComparator = new ResourceComparator(sortRequest);
            }
            if (!providerAlreadySorted) {
                TreeSet<Resource> sortedResources = new TreeSet<Resource>(resourceComparator);
                sortedResources.addAll(providerResources);
                resources = sortedResources;
            }
            totalCount = resources.size();
            if (null != pageRequest && !providerAlreadyPaged) {
                switch (pageRequest.getStartingPoint()) {
                    case Beginning: {
                        return this.getPageFromOffset(pageRequest.getPageSize(), 0, resources, predicate, provider);
                    }
                    case End: {
                        return this.getPageToOffset(pageRequest.getPageSize(), -1, resources, predicate, provider);
                    }
                    case OffsetStart: {
                        return this.getPageFromOffset(pageRequest.getPageSize(), pageRequest.getOffset(), resources, predicate, provider);
                    }
                    case OffsetEnd: {
                        return this.getPageToOffset(pageRequest.getPageSize(), pageRequest.getOffset(), resources, predicate, provider);
                    }
                    case PredicateStart: 
                    case PredicateEnd: {
                        break;
                    }
                }
            } else if (providerAlreadyPaged) {
                totalCount = queryResponse.getTotalResourceCount();
            }
        }
        return new PageResponseImpl(new ResourceIterable(resources, predicate, provider), 0, null, null, totalCount);
    }

    private void checkSortRequestProperties(SortRequest sortRequest, Resource.Type type, ResourceProvider provider) throws UnsupportedPropertyException {
        Set<String> requestPropertyIds = provider.checkPropertyIds(new HashSet<String>(sortRequest.getPropertyIds()));
        if (requestPropertyIds.size() > 0) {
            List<PropertyProvider> propertyProviders = this.ensurePropertyProviders(type);
            for (PropertyProvider propertyProvider : propertyProviders) {
                requestPropertyIds = propertyProvider.checkPropertyIds(requestPropertyIds);
                if (requestPropertyIds.size() != 0) continue;
                return;
            }
            throw new UnsupportedPropertyException(type, requestPropertyIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema getSchema(Resource.Type type) {
        Schema schema = this.schemas.get(type);
        if (schema == null) {
            Map<Resource.Type, Schema> map = this.schemas;
            synchronized (map) {
                schema = this.schemas.get(type);
                if (schema == null) {
                    schema = new SchemaImpl(this.ensureResourceProvider(type));
                    this.schemas.put(type, schema);
                }
            }
        }
        return schema;
    }

    @Override
    public RequestStatus createResources(Resource.Type type, Request request) throws UnsupportedPropertyException, SystemException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        ResourceProvider provider = this.ensureResourceProvider(type);
        if (provider != null) {
            this.checkProperties(type, request, null);
            return provider.createResources(request);
        }
        return null;
    }

    @Override
    public RequestStatus updateResources(Resource.Type type, Request request, Predicate predicate) throws UnsupportedPropertyException, SystemException, NoSuchResourceException, NoSuchParentResourceException {
        ResourceProvider provider = this.ensureResourceProvider(type);
        if (provider != null) {
            if (!this.checkProperties(type, request, predicate) && (predicate = this.resolvePredicate(type, predicate)) == null) {
                return null;
            }
            return provider.updateResources(request, predicate);
        }
        return null;
    }

    @Override
    public RequestStatus deleteResources(Resource.Type type, Request request, Predicate predicate) throws UnsupportedPropertyException, SystemException, NoSuchResourceException, NoSuchParentResourceException {
        ResourceProvider provider = this.ensureResourceProvider(type);
        if (provider != null) {
            if (!this.checkProperties(type, null, predicate) && (predicate = this.resolvePredicate(type, predicate)) == null) {
                return null;
            }
            return provider.deleteResources(request, predicate);
        }
        return null;
    }

    @Override
    public ResourceProvider ensureResourceProvider(Resource.Type type) {
        ExtendedResourceProviderWrapper providerWrapper = this.ensureResourceProviderWrapper(type);
        return providerWrapper == null ? null : providerWrapper.resourceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtendedResourceProviderWrapper ensureResourceProviderWrapper(Resource.Type type) {
        Map<Resource.Type, ExtendedResourceProviderWrapper> map = this.resourceProviders;
        synchronized (map) {
            if (!this.resourceProviders.containsKey(type)) {
                this.resourceProviders.put(type, new ExtendedResourceProviderWrapper(this.providerModule.getResourceProvider(type)));
            }
        }
        return this.resourceProviders.get(type);
    }

    protected Iterable<Resource> getResourceIterable(Resource.Type type, Request request, Predicate predicate) throws UnsupportedPropertyException, SystemException, NoSuchParentResourceException, NoSuchResourceException {
        return this.getResources(type, request, predicate, null, null).getIterable();
    }

    protected PageResponse getResources(Resource.Type type, Request request, Predicate predicate, PageRequest pageRequest, SortRequest sortRequest) throws UnsupportedPropertyException, SystemException, NoSuchResourceException, NoSuchParentResourceException {
        QueryResponse queryResponse = this.getResources(type, request, predicate);
        this.populateResources(type, queryResponse.getResources(), request, predicate);
        return this.getPage(type, queryResponse, request, predicate, pageRequest, sortRequest);
    }

    private boolean checkProperties(Resource.Type type, Request request, Predicate predicate) throws UnsupportedPropertyException {
        ResourceProvider provider;
        Set<Object> requestPropertyIds;
        Set<Object> set = requestPropertyIds = request == null ? new HashSet() : PropertyHelper.getAssociatedPropertyIds(request);
        if (predicate != null) {
            requestPropertyIds.addAll(PredicateHelper.getPropertyIds(predicate));
        }
        if (requestPropertyIds.size() > 0 && (requestPropertyIds = (provider = this.ensureResourceProvider(type)).checkPropertyIds(requestPropertyIds)).size() > 0) {
            List<PropertyProvider> propertyProviders = this.ensurePropertyProviders(type);
            for (PropertyProvider propertyProvider : propertyProviders) {
                requestPropertyIds = propertyProvider.checkPropertyIds(requestPropertyIds);
                if (requestPropertyIds.size() != 0) continue;
                return false;
            }
            throw new UnsupportedPropertyException(type, requestPropertyIds);
        }
        return true;
    }

    private Predicate resolvePredicate(Resource.Type type, Predicate predicate) throws UnsupportedPropertyException, SystemException, NoSuchResourceException, NoSuchParentResourceException {
        ResourceProvider provider = this.ensureResourceProvider(type);
        HashSet<String> keyPropertyIds = new HashSet<String>(provider.getKeyPropertyIds().values());
        Request readRequest = PropertyHelper.getReadRequest(keyPropertyIds);
        Iterable<Resource> resources = this.getResourceIterable(type, readRequest, predicate);
        PredicateBuilder pb = new PredicateBuilder();
        PredicateBuilder.PredicateBuilderWithPredicate pbWithPredicate = null;
        for (Resource resource : resources) {
            if (pbWithPredicate != null) {
                pb = pbWithPredicate.or();
            }
            pb = pb.begin();
            pbWithPredicate = null;
            for (String keyPropertyId : keyPropertyIds) {
                if (pbWithPredicate != null) {
                    pb = pbWithPredicate.and();
                }
                pbWithPredicate = pb.property(keyPropertyId).equals((Comparable)resource.getPropertyValue(keyPropertyId));
            }
            if (pbWithPredicate == null) continue;
            pbWithPredicate = pbWithPredicate.end();
        }
        return pbWithPredicate == null ? null : pbWithPredicate.toPredicate();
    }

    private boolean providesRequestProperties(PropertyProvider provider, Request request, Predicate predicate) {
        HashSet<String> requestPropertyIds = new HashSet<String>(request.getPropertyIds());
        if (requestPropertyIds.size() == 0) {
            return true;
        }
        requestPropertyIds.addAll(PredicateHelper.getPropertyIds(predicate));
        int size = requestPropertyIds.size();
        return size > provider.checkPropertyIds(requestPropertyIds).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PropertyProvider> ensurePropertyProviders(Resource.Type type) {
        Map<Resource.Type, List<PropertyProvider>> map = this.propertyProviders;
        synchronized (map) {
            if (!this.propertyProviders.containsKey(type)) {
                List<PropertyProvider> providers = this.providerModule.getPropertyProviders(type);
                this.propertyProviders.put(type, providers == null ? Collections.emptyList() : providers);
            }
        }
        return this.propertyProviders.get(type);
    }

    private LinkedList<Resource> getEvaluatedResources(ResourceIterable resourceIterable) {
        LinkedList<Resource> resources = new LinkedList<Resource>();
        if (resourceIterable != null) {
            for (Resource resource : resourceIterable) {
                resources.add(resource);
            }
        }
        return resources;
    }

    private PageResponse getPageFromOffset(int pageSize, int offset, Set<Resource> resources, Predicate predicate, ResourcePredicateEvaluator evaluator) {
        int currentOffset;
        Resource previous = null;
        LinkedHashSet<Resource> pageResources = new LinkedHashSet<Resource>();
        LinkedList<Resource> filteredResources = this.getEvaluatedResources(new ResourceIterable(resources, predicate, evaluator));
        Iterator iterator = filteredResources.iterator();
        for (currentOffset = 0; currentOffset < offset && iterator.hasNext(); ++currentOffset) {
            previous = (Resource)iterator.next();
        }
        for (int i = 0; i < pageSize && iterator.hasNext(); ++i) {
            pageResources.add((Resource)iterator.next());
        }
        return new PageResponseImpl(pageResources, currentOffset, previous, iterator.hasNext() ? (Resource)iterator.next() : null, filteredResources.size());
    }

    private PageResponse getPageToOffset(int pageSize, int offset, Set<Resource> resources, Predicate predicate, ResourcePredicateEvaluator evaluator) {
        int currentOffset;
        Resource next = null;
        LinkedList<Resource> pageResources = new LinkedList<Resource>();
        LinkedList<Resource> filteredResources = this.getEvaluatedResources(new ResourceIterable(resources, predicate, evaluator));
        Iterator<Resource> iterator = filteredResources.descendingIterator();
        if (offset != -1) {
            for (currentOffset = resources.size() - 1; currentOffset > offset && iterator.hasNext(); --currentOffset) {
                next = iterator.next();
            }
        }
        for (int i = 0; i < pageSize && iterator.hasNext(); ++i) {
            pageResources.add(0, iterator.next());
            --currentOffset;
        }
        return new PageResponseImpl(pageResources, currentOffset + 1, iterator.hasNext() ? iterator.next() : null, next, filteredResources.size());
    }

    protected Comparator<Resource> getComparator() {
        return this.comparator;
    }

    protected class ResourceComparator
    implements Comparator<Resource> {
        SortRequest sortRequest;

        protected ResourceComparator() {
        }

        protected ResourceComparator(SortRequest sortRequest) {
            this.sortRequest = sortRequest;
        }

        @Override
        public int compare(Resource resource1, Resource resource2) {
            Resource.Type resourceType = resource1.getType();
            int compVal = resourceType.compareTo(resource2.getType());
            if (compVal == 0 && this.sortRequest != null) {
                for (SortRequestProperty property : this.sortRequest.getProperties()) {
                    compVal = this.compareValues(resource1.getPropertyValue(property.getPropertyId()), resource2.getPropertyValue(property.getPropertyId()), property.getOrder());
                    if (compVal == 0) continue;
                    return compVal;
                }
            }
            if (compVal == 0) {
                Schema schema = ClusterControllerImpl.this.getSchema(resourceType);
                for (Resource.Type type : schema.getKeyTypes()) {
                    String keyPropertyId = schema.getKeyPropertyId(type);
                    if (keyPropertyId == null || (compVal = this.compareValues(resource1.getPropertyValue(keyPropertyId), resource2.getPropertyValue(keyPropertyId))) == 0) continue;
                    return compVal;
                }
            }
            return resource1.toString().compareTo(resource2.toString());
        }

        private int compareValues(Object val1, Object val2) {
            if (val1 == null || val2 == null) {
                return val1 == null && val2 == null ? 0 : (val1 == null ? -1 : 1);
            }
            if (val1 instanceof Comparable) {
                try {
                    return ((Comparable)val1).compareTo(val2);
                }
                catch (ClassCastException e) {
                    return 0;
                }
            }
            return 0;
        }

        private int compareValues(Object val1, Object val2, SortRequest.Order order) {
            if (order == SortRequest.Order.ASC) {
                return this.compareValues(val1, val2);
            }
            return -1 * this.compareValues(val1, val2);
        }
    }

    private static class ExtendedResourceProviderWrapper
    implements ExtendedResourceProvider,
    ResourcePredicateEvaluator {
        private final ResourceProvider resourceProvider;
        private final ResourcePredicateEvaluator evaluator;
        private final ExtendedResourceProvider extendedResourceProvider;

        public ExtendedResourceProviderWrapper(ResourceProvider resourceProvider) {
            this.resourceProvider = resourceProvider;
            this.extendedResourceProvider = resourceProvider instanceof ExtendedResourceProvider ? (ExtendedResourceProvider)resourceProvider : null;
            this.evaluator = resourceProvider instanceof ResourcePredicateEvaluator ? (ResourcePredicateEvaluator)((Object)resourceProvider) : DEFAULT_RESOURCE_PREDICATE_EVALUATOR;
        }

        public Predicate getAmendedPredicate(Predicate predicate) {
            if (ReadOnlyResourceProvider.class.isInstance(this.resourceProvider)) {
                return ((ReadOnlyResourceProvider)this.resourceProvider).amendPredicate(predicate);
            }
            return null;
        }

        @Override
        public QueryResponse queryForResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
            return this.extendedResourceProvider == null ? new QueryResponseImpl(this.resourceProvider.getResources(request, predicate)) : this.extendedResourceProvider.queryForResources(request, predicate);
        }

        @Override
        public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
            return this.resourceProvider.createResources(request);
        }

        @Override
        public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
            return this.resourceProvider.getResources(request, predicate);
        }

        @Override
        public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
            return this.resourceProvider.updateResources(request, predicate);
        }

        @Override
        public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
            return this.resourceProvider.deleteResources(request, predicate);
        }

        @Override
        public Map<Resource.Type, String> getKeyPropertyIds() {
            return this.resourceProvider.getKeyPropertyIds();
        }

        @Override
        public Set<String> checkPropertyIds(Set<String> propertyIds) {
            return this.resourceProvider.checkPropertyIds(propertyIds);
        }

        @Override
        public boolean evaluate(Predicate predicate, Resource resource) {
            return this.evaluator.evaluate(predicate, resource);
        }
    }

    private static class ResourceIterable
    implements Iterable<Resource> {
        private final Set<Resource> resources;
        private final Predicate predicate;
        private final ResourcePredicateEvaluator evaluator;

        private ResourceIterable(Set<Resource> resources, Predicate predicate, ResourcePredicateEvaluator evaluator) {
            this.resources = resources;
            this.predicate = predicate;
            this.evaluator = evaluator;
        }

        @Override
        public Iterator<Resource> iterator() {
            return new ResourceIterator(this.resources, this.predicate, this.evaluator);
        }
    }

    private static class ResourceIterator
    implements Iterator<Resource> {
        private final Iterator<Resource> iterator;
        private final Predicate predicate;
        private Resource nextResource;
        private final ResourcePredicateEvaluator evaluator;

        private ResourceIterator(Set<Resource> resources, Predicate predicate, ResourcePredicateEvaluator evaluator) {
            this.iterator = resources.iterator();
            this.predicate = predicate;
            this.evaluator = evaluator;
            this.nextResource = this.getNextResource();
        }

        @Override
        public boolean hasNext() {
            return this.nextResource != null;
        }

        @Override
        public Resource next() {
            if (this.nextResource == null) {
                throw new NoSuchElementException("Iterator has no more elements.");
            }
            Resource currentResource = this.nextResource;
            this.nextResource = this.getNextResource();
            return currentResource;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported.");
        }

        private Resource getNextResource() {
            while (this.iterator.hasNext()) {
                Resource next = this.iterator.next();
                if (this.predicate != null && !this.evaluator.evaluate(this.predicate, next)) continue;
                return next;
            }
            return null;
        }
    }
}

