/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.MaintenanceStateHelper;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OBDPManagementControllerImpl;
import id.onyx.obdp.server.controller.ServiceComponentHostRequest;
import id.onyx.obdp.server.controller.ServiceComponentHostResponse;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.state.ClientConfigFileDefinition;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.ServiceOsSpecific;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.utils.SecretReference;
import id.onyx.obdp.server.utils.StageUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConfigResourceProvider
extends AbstractControllerResourceProvider {
    protected static final String COMPONENT_CLUSTER_NAME_PROPERTY_ID = "ServiceComponentInfo/cluster_name";
    protected static final String COMPONENT_SERVICE_NAME_PROPERTY_ID = "ServiceComponentInfo/service_name";
    protected static final String COMPONENT_COMPONENT_NAME_PROPERTY_ID = "ServiceComponentInfo/component_name";
    protected static final String HOST_COMPONENT_HOST_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("HostRoles", "host_name");
    private final Gson gson = new Gson();
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Cluster, (Object)"ServiceComponentInfo/cluster_name").put((Object)Resource.Type.Service, (Object)"ServiceComponentInfo/service_name").put((Object)Resource.Type.Component, (Object)"ServiceComponentInfo/component_name").put((Object)Resource.Type.Host, (Object)HOST_COMPONENT_HOST_NAME_PROPERTY_ID).build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{"ServiceComponentInfo/cluster_name", "ServiceComponentInfo/service_name", "ServiceComponentInfo/component_name", HOST_COMPONENT_HOST_NAME_PROPERTY_ID});
    private MaintenanceStateHelper maintenanceStateHelper;
    private static final Logger LOG = LoggerFactory.getLogger(ClientConfigResourceProvider.class);

    @AssistedInject
    ClientConfigResourceProvider(@Assisted OBDPManagementController managementController) {
        super(Resource.Type.ClientConfig, propertyIds, keyPropertyIds, managementController);
        this.setRequiredGetAuthorizations(EnumSet.of(RoleAuthorization.HOST_VIEW_CONFIGS, RoleAuthorization.SERVICE_VIEW_CONFIGS, RoleAuthorization.CLUSTER_VIEW_CONFIGS));
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new SystemException("The request is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public Set<Resource> getResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        final HashSet<ServiceComponentHostRequest> requests = new HashSet<ServiceComponentHostRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            requests.add(this.getRequest(propertyMap));
        }
        Set<ServiceComponentHostResponse> responses = null;
        try {
            responses = this.getResources(new AbstractResourceProvider.Command<Set<ServiceComponentHostResponse>>(){

                @Override
                public Set<ServiceComponentHostResponse> invoke() throws OBDPException {
                    return ClientConfigResourceProvider.this.getManagementController().getHostComponents(requests);
                }
            });
        }
        catch (Exception e) {
            throw new SystemException("Failed to get components ", e);
        }
        HashMap<String, ServiceComponentHostResponse> componentMap = new HashMap<String, ServiceComponentHostResponse>();
        for (ServiceComponentHostResponse resp : responses) {
            String componentName = resp.getComponentName();
            if (componentMap.containsKey(componentName)) continue;
            componentMap.put(resp.getComponentName(), resp);
        }
        ServiceComponentHostRequest schRequest = (ServiceComponentHostRequest)requests.iterator().next();
        String requestComponentName = schRequest.getComponentName();
        String requestServiceName = schRequest.getServiceName();
        String requestHostName = schRequest.getHostname();
        HashMap serviceToComponentMap = new HashMap();
        ArrayList<ServiceComponentHostResponse> schWithConfigFiles = new ArrayList<ServiceComponentHostResponse>();
        Configuration configs = new Configuration();
        Map<String, String> configMap = configs.getConfigsMap();
        String TMP_PATH = configMap.get(Configuration.SERVER_TMP_DIR.getKey());
        String pythonCmd = configMap.get(Configuration.OBDP_PYTHON_WRAP.getKey());
        ArrayList<String> pythonCompressFilesCmds = new ArrayList<String>();
        ArrayList<File> commandFiles = new ArrayList<File>();
        for (ServiceComponentHostResponse response : componentMap.values()) {
            OBDPManagementController managementController = this.getManagementController();
            ConfigHelper configHelper = managementController.getConfigHelper();
            Cluster cluster = null;
            Clusters clusters = managementController.getClusters();
            try {
                void var56_66;
                String configType;
                cluster = clusters.getCluster(response.getClusterName());
                String serviceName = response.getServiceName();
                String componentName = response.getComponentName();
                String hostName = response.getHostname();
                String publicHostName = response.getPublicHostname();
                ComponentInfo componentInfo = null;
                String packageFolder = null;
                Service service = cluster.getService(serviceName);
                ServiceComponent component = service.getServiceComponent(componentName);
                StackId stackId = component.getDesiredStackId();
                componentInfo = managementController.getAmbariMetaInfo().getComponent(stackId.getStackName(), stackId.getStackVersion(), serviceName, componentName);
                packageFolder = managementController.getAmbariMetaInfo().getService(stackId.getStackName(), stackId.getStackVersion(), serviceName).getServicePackageFolder();
                String commandScript = componentInfo.getCommandScript().getScript();
                List<ClientConfigFileDefinition> clientConfigFiles = componentInfo.getClientConfigFiles();
                if (clientConfigFiles == null) {
                    if (componentMap.size() == 1) {
                        throw new SystemException("No configuration files defined for the component " + componentInfo.getName());
                    }
                    LOG.debug("No configuration files defined for the component {}", (Object)componentInfo.getName());
                    continue;
                }
                schWithConfigFiles.add(response);
                if (serviceToComponentMap.containsKey(response.getServiceName())) {
                    schResponseList = (List)serviceToComponentMap.get(serviceName);
                    schResponseList.add(response);
                } else {
                    schResponseList = new ArrayList();
                    schResponseList.add(response);
                    serviceToComponentMap.put(serviceName, schResponseList);
                }
                String resourceDirPath = configs.getResourceDirPath();
                String packageFolderAbsolute = resourceDirPath + File.separator + packageFolder;
                String commandScriptAbsolute = packageFolderAbsolute + File.separator + commandScript;
                TreeMap<String, Map<String, String>> configurations = new TreeMap<String, Map<String, String>>();
                TreeMap<String, Long> configVersions = new TreeMap<String, Long>();
                TreeMap<String, Map<PropertyInfo.PropertyType, Set<String>>> configPropertiesTypes = new TreeMap<String, Map<PropertyInfo.PropertyType, Set<String>>>();
                TreeMap<String, Map<String, Map<String, String>>> configurationAttributes = new TreeMap<String, Map<String, Map<String, String>>>();
                Map<String, DesiredConfig> desiredClusterConfigs = cluster.getDesiredConfigs();
                for (Map.Entry<String, DesiredConfig> entry : desiredClusterConfigs.entrySet()) {
                    DesiredConfig desiredConfig;
                    configType = entry.getKey();
                    Config clusterConfig = cluster.getConfig(configType, (desiredConfig = entry.getValue()).getTag());
                    if (clusterConfig == null) continue;
                    HashMap<String, String> props = new HashMap<String, String>(clusterConfig.getProperties());
                    Map<String, Map<String, String>> allConfigTags = null;
                    allConfigTags = configHelper.getEffectiveDesiredTags(cluster, schRequest.getHostname());
                    HashMap<String, Map<String, String>> configTags = new HashMap<String, Map<String, String>>();
                    for (Map.Entry<String, Map<String, String>> entry2 : allConfigTags.entrySet()) {
                        if (!entry2.getKey().equals(clusterConfig.getType())) continue;
                        configTags.put(clusterConfig.getType(), (Map)entry2.getValue());
                    }
                    Map<String, Map<String, String>> properties = configHelper.getEffectiveConfigProperties(cluster, configTags);
                    if (!properties.isEmpty()) {
                        Map.Entry<String, Map<String, String>> entry2;
                        entry2 = properties.values().iterator();
                        while (entry2.hasNext()) {
                            Map propertyMap = (Map)entry2.next();
                            props.putAll(propertyMap);
                        }
                    }
                    configurations.put(clusterConfig.getType(), props);
                    configVersions.put(clusterConfig.getType(), clusterConfig.getVersion());
                    configPropertiesTypes.put(clusterConfig.getType(), clusterConfig.getPropertiesTypes());
                    TreeMap<String, Map<String, String>> attrs = new TreeMap<String, Map<String, String>>();
                    configHelper.cloneAttributesMap(clusterConfig.getPropertiesAttributes(), attrs);
                    Map<String, Map<String, Map<String, String>>> attributes = configHelper.getEffectiveConfigAttributes(cluster, configTags);
                    for (Map<String, Map<String, String>> map : attributes.values()) {
                        configHelper.cloneAttributesMap(map, attrs);
                    }
                    configurationAttributes.put(clusterConfig.getType(), attrs);
                }
                ConfigHelper.processHiddenAttribute(configurations, configurationAttributes, componentName, true);
                for (Map.Entry<String, DesiredConfig> entry : configurationAttributes.entrySet()) {
                    Map attrs = (Map)((Object)entry.getValue());
                    attrs.remove("hidden");
                }
                for (Map.Entry<String, DesiredConfig> entry : configurations.entrySet()) {
                    configType = entry.getKey();
                    Map configProperties = (Map)((Object)entry.getValue());
                    Long configVersion = (Long)configVersions.get(configType);
                    Map propertiesTypes = (Map)configPropertiesTypes.get(configType);
                    SecretReference.replacePasswordsWithReferences(propertiesTypes, configProperties, configType, configVersion);
                }
                Map<String, Set<String>> clusterHostInfo = null;
                Object var45_54 = null;
                String osFamily = null;
                clusterHostInfo = StageUtils.getClusterHostInfo(cluster);
                ServiceInfo serviceInfo = managementController.getAmbariMetaInfo().getService(stackId.getStackName(), stackId.getStackVersion(), serviceName);
                try {
                    clusterHostInfo = StageUtils.substituteHostIndexes(clusterHostInfo);
                }
                catch (OBDPException e) {
                    throw new SystemException(e.getMessage(), e);
                }
                osFamily = clusters.getHost(hostName).getOsFamily();
                ServiceOsSpecific anyOs = null;
                if (serviceInfo.getOsSpecifics().containsKey("any")) {
                    anyOs = serviceInfo.getOsSpecifics().get("any");
                }
                ServiceOsSpecific hostOs = this.populateServicePackagesInfo(serviceInfo, osFamily);
                ArrayList<ServiceOsSpecific.Package> packages = new ArrayList<ServiceOsSpecific.Package>();
                if (anyOs != null) {
                    packages.addAll(anyOs.getPackages());
                }
                if (hostOs != null) {
                    packages.addAll(hostOs.getPackages());
                }
                String packageList = this.gson.toJson(packages);
                String jsonConfigurations = null;
                HashMap<String, Object> commandParams = new HashMap<String, Object>();
                LinkedList xmlConfigs = new LinkedList();
                LinkedList envConfigs = new LinkedList();
                LinkedList propertiesConfigs = new LinkedList();
                for (ClientConfigFileDefinition clientConfigFile : clientConfigFiles) {
                    HashMap<String, String> fileDict = new HashMap<String, String>();
                    fileDict.put(clientConfigFile.getFileName(), clientConfigFile.getDictionaryName());
                    if (clientConfigFile.getType().equals("xml")) {
                        xmlConfigs.add(fileDict);
                        continue;
                    }
                    if (clientConfigFile.getType().equals("env")) {
                        envConfigs.add(fileDict);
                        continue;
                    }
                    if (!clientConfigFile.getType().equals("properties")) continue;
                    propertiesConfigs.add(fileDict);
                }
                Object var56_70 = null;
                TreeMap<String, String> ambariLevelParams = null;
                TreeMap<Object, Object> topologyCommandParams = new TreeMap();
                if (this.getManagementController() instanceof OBDPManagementControllerImpl) {
                    OBDPManagementControllerImpl controller = (OBDPManagementControllerImpl)this.getManagementController();
                    TreeMap<String, String> treeMap = controller.getMetadataClusterLevelParams(cluster, stackId);
                    ambariLevelParams = controller.getMetadataAmbariLevelParams();
                    Service s = cluster.getService(serviceName);
                    ServiceComponent sc = s.getServiceComponent(componentName);
                    ServiceComponentHost sch = sc.getServiceComponentHost(response.getHostname());
                    topologyCommandParams = controller.getTopologyCommandParams(cluster.getClusterId(), serviceName, componentName, sch);
                }
                TreeMap<String, String> agentLevelParams = new TreeMap<String, String>();
                agentLevelParams.put("hostname", hostName);
                agentLevelParams.put("public_hostname", publicHostName);
                commandParams.put("package_list", packageList);
                commandParams.put("xml_configs_list", xmlConfigs);
                commandParams.put("env_configs_list", envConfigs);
                commandParams.put("properties_configs_list", propertiesConfigs);
                commandParams.put("output_file", componentName + "-configs" + Configuration.DEF_ARCHIVE_EXTENSION);
                commandParams.putAll(topologyCommandParams);
                TreeMap<String, Object> jsonContent = new TreeMap<String, Object>();
                jsonContent.put("configurations", configurations);
                jsonContent.put("configurationAttributes", configurationAttributes);
                jsonContent.put("commandParams", commandParams);
                jsonContent.put("clusterHostInfo", clusterHostInfo);
                jsonContent.put("ambariLevelParams", ambariLevelParams);
                jsonContent.put("clusterLevelParams", var56_66);
                jsonContent.put("agentLevelParams", agentLevelParams);
                jsonContent.put("hostname", hostName);
                jsonContent.put("public_hostname", publicHostName);
                jsonContent.put("clusterName", cluster.getClusterName());
                jsonContent.put("serviceName", serviceName);
                jsonContent.put("role", componentName);
                jsonContent.put("componentVersionMap", cluster.getComponentVersionMap());
                jsonConfigurations = this.gson.toJson(jsonContent);
                File tmpDirectory = new File(TMP_PATH);
                if (!tmpDirectory.exists()) {
                    try {
                        tmpDirectory.mkdirs();
                        tmpDirectory.setWritable(true, true);
                        tmpDirectory.setReadable(true, true);
                    }
                    catch (SecurityException se) {
                        throw new SystemException("Failed to get temporary directory to store configurations", se);
                    }
                }
                File jsonFile = File.createTempFile(componentName, "-configuration.json", tmpDirectory);
                try {
                    jsonFile.setWritable(true, true);
                    jsonFile.setReadable(true, true);
                }
                catch (SecurityException e) {
                    throw new SystemException("Failed to set permission", e);
                }
                PrintWriter printWriter = null;
                try {
                    printWriter = new PrintWriter(jsonFile.getAbsolutePath());
                    printWriter.print(jsonConfigurations);
                    printWriter.close();
                }
                catch (FileNotFoundException e) {
                    throw new SystemException("Failed to write configurations to json file ", e);
                }
                String cmd = pythonCmd + " " + commandScriptAbsolute + " generate_configs " + jsonFile.getAbsolutePath() + " " + packageFolderAbsolute + " " + TMP_PATH + File.separator + "structured-out.json INFO " + TMP_PATH;
                commandFiles.add(jsonFile);
                pythonCompressFilesCmds.add(cmd);
            }
            catch (IOException e) {
                throw new SystemException("Controller error ", e);
            }
        }
        if (schWithConfigFiles.isEmpty()) {
            throw new SystemException("No configuration files defined for any component");
        }
        Integer totalCommands = pythonCompressFilesCmds.size() * 2;
        Integer threadPoolSize = Math.min(totalCommands, configs.getExternalScriptThreadPoolSize());
        ExecutorService processExecutor = Executors.newFixedThreadPool(threadPoolSize);
        try {
            List<CommandLineThreadWrapper> pythonCmdThreads = this.executeCommands(processExecutor, pythonCompressFilesCmds);
            Integer timeout = configs.getExternalScriptTimeout();
            this.waitForAllThreadsToJoin(processExecutor, pythonCmdThreads, timeout);
        }
        finally {
            for (File each : commandFiles) {
                each.delete();
            }
        }
        if (StringUtils.isEmpty((String)requestComponentName)) {
            String fileName;
            List<ServiceComponentHostResponse> schToTarConfigFiles = schWithConfigFiles;
            if (StringUtils.isNotEmpty((String)requestHostName)) {
                fileName = requestHostName + "(" + Resource.InternalType.Host.toString().toUpperCase() + ")";
            } else if (StringUtils.isNotEmpty((String)requestServiceName)) {
                fileName = requestServiceName + "(" + Resource.InternalType.Service.toString().toUpperCase() + ")";
                schToTarConfigFiles = (List)serviceToComponentMap.get(requestServiceName);
            } else {
                fileName = schRequest.getClusterName() + "(" + Resource.InternalType.Cluster.toString().toUpperCase() + ")";
            }
            TarUtils tarUtils = new TarUtils(TMP_PATH, fileName, schToTarConfigFiles);
            tarUtils.tarConfigFiles();
        }
        ResourceImpl resource = new ResourceImpl(Resource.Type.ClientConfig);
        resources.add(resource);
        return resources;
    }

    private List<CommandLineThreadWrapper> executeCommands(ExecutorService processExecutor, List<String> commandLines) throws SystemException {
        ArrayList<CommandLineThreadWrapper> commandLineThreadWrappers = new ArrayList<CommandLineThreadWrapper>();
        try {
            for (String commandLine : commandLines) {
                CommandLineThreadWrapper commandLineThreadWrapper = this.executeCommand(processExecutor, commandLine);
                commandLineThreadWrappers.add(commandLineThreadWrapper);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to run generate client configs script for components");
            processExecutor.shutdownNow();
            throw new SystemException("Failed to run generate client configs script for components");
        }
        return commandLineThreadWrappers;
    }

    private CommandLineThreadWrapper executeCommand(ExecutorService processExecutor, String commandLine) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(Arrays.asList(commandLine.split("\\s+")));
        builder.redirectErrorStream(true);
        Process process = builder.start();
        CommandLineThread commandLineThread = new CommandLineThread(process);
        LogStreamReader logStream = new LogStreamReader(process.getInputStream());
        Thread logStreamThread = new Thread((Runnable)logStream, "LogStreamReader");
        processExecutor.execute(logStreamThread);
        processExecutor.execute(commandLineThread);
        return new CommandLineThreadWrapper(commandLine, commandLineThread, logStreamThread, logStream, process);
    }

    private void waitForAllThreadsToJoin(ExecutorService processExecutor, List<CommandLineThreadWrapper> pythonCmdThreads, Integer timeout) throws SystemException {
        processExecutor.shutdown();
        try {
            processExecutor.awaitTermination(timeout.intValue(), TimeUnit.MILLISECONDS);
            processExecutor.shutdownNow();
            for (CommandLineThreadWrapper commandLineThreadWrapper : pythonCmdThreads) {
                CommandLineThread commandLineThread = commandLineThreadWrapper.getCommandLineThread();
                try {
                    Integer returnCode = commandLineThread.getReturnCode();
                    if (returnCode == null) {
                        throw new TimeoutException();
                    }
                    if (returnCode == 0) continue;
                    throw new ExecutionException(String.format("Execution of \"%s\" returned %d.", commandLineThreadWrapper.getCommandLine(), returnCode), new Throwable(commandLineThreadWrapper.getLogStream().getOutput()));
                }
                catch (TimeoutException e) {
                    LOG.error("Generate client configs script was killed due to timeout ", (Throwable)e);
                    throw new SystemException("Generate client configs script was killed due to timeout ", e);
                }
                catch (ExecutionException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    throw new SystemException(e.getMessage() + " " + e.getCause());
                }
                finally {
                    commandLineThreadWrapper.getProcess().destroy();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            processExecutor.shutdownNow();
            LOG.error("Failed to run generate client configs script for components");
            throw new SystemException("Failed to run generate client configs script for components");
        }
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new SystemException("The request is not supported");
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new SystemException("The request is not supported");
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    private ServiceComponentHostRequest getRequest(Map<String, Object> properties) {
        return new ServiceComponentHostRequest((String)properties.get(COMPONENT_CLUSTER_NAME_PROPERTY_ID), (String)properties.get(COMPONENT_SERVICE_NAME_PROPERTY_ID), (String)properties.get(COMPONENT_COMPONENT_NAME_PROPERTY_ID), (String)properties.get(HOST_COMPONENT_HOST_NAME_PROPERTY_ID), null);
    }

    protected ServiceOsSpecific populateServicePackagesInfo(ServiceInfo serviceInfo, String osFamily) {
        ServiceOsSpecific hostOs = new ServiceOsSpecific(osFamily);
        List<ServiceOsSpecific> foundedOSSpecifics = this.getOSSpecificsByFamily(serviceInfo.getOsSpecifics(), osFamily);
        if (!foundedOSSpecifics.isEmpty()) {
            for (ServiceOsSpecific osSpecific : foundedOSSpecifics) {
                hostOs.addPackages(osSpecific.getPackages());
            }
        }
        return hostOs;
    }

    private List<ServiceOsSpecific> getOSSpecificsByFamily(Map<String, ServiceOsSpecific> osSpecifics, String osFamily) {
        ArrayList<ServiceOsSpecific> foundedOSSpecifics = new ArrayList<ServiceOsSpecific>();
        for (Map.Entry<String, ServiceOsSpecific> osSpecific : osSpecifics.entrySet()) {
            if (osSpecific.getKey().indexOf(osFamily) == -1) continue;
            foundedOSSpecifics.add(osSpecific.getValue());
        }
        return foundedOSSpecifics;
    }

    protected static class TarUtils {
        private String tmpDir;
        private String fileName;
        private List<ServiceComponentHostResponse> serviceComponentHostResponses;

        TarUtils(String tmpDir, String fileName, List<ServiceComponentHostResponse> serviceComponentHostResponses) {
            this.tmpDir = tmpDir;
            this.fileName = fileName;
            this.serviceComponentHostResponses = serviceComponentHostResponses;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void tarConfigFiles() throws SystemException {
            try {
                File compressedOutputFile = new File(this.tmpDir, this.fileName + "-configs" + Configuration.DEF_ARCHIVE_EXTENSION);
                FileOutputStream fOut = new FileOutputStream(compressedOutputFile);
                BufferedOutputStream bOut = new BufferedOutputStream(fOut);
                GzipCompressorOutputStream gzOut = new GzipCompressorOutputStream((OutputStream)bOut);
                TarArchiveOutputStream tOut = new TarArchiveOutputStream((OutputStream)gzOut);
                tOut.setLongFileMode(3);
                tOut.setBigNumberMode(2);
                try {
                    for (ServiceComponentHostResponse schResponse : this.serviceComponentHostResponses) {
                        String componentName = schResponse.getComponentName();
                        File compressedInputFile = new File(this.tmpDir, componentName + "-configs" + Configuration.DEF_ARCHIVE_EXTENSION);
                        FileInputStream fin = new FileInputStream(compressedInputFile);
                        BufferedInputStream bIn = new BufferedInputStream(fin);
                        GzipCompressorInputStream gzIn = new GzipCompressorInputStream((InputStream)bIn);
                        TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzIn);
                        TarArchiveEntry entry = null;
                        try {
                            while ((entry = tarIn.getNextTarEntry()) != null) {
                                entry.setName(componentName + File.separator + entry.getName());
                                tOut.putArchiveEntry((ArchiveEntry)entry);
                                if (entry.isFile()) {
                                    IOUtils.copy((InputStream)tarIn, (OutputStream)tOut);
                                }
                                tOut.closeArchiveEntry();
                            }
                        }
                        catch (Exception e) {
                            throw new SystemException(e.getMessage(), e);
                        }
                        finally {
                            tarIn.close();
                            gzIn.close();
                            bIn.close();
                            fin.close();
                        }
                    }
                }
                finally {
                    tOut.finish();
                    tOut.close();
                }
            }
            catch (Exception e) {
                throw new SystemException(e.getMessage(), e);
            }
        }
    }

    private static class CommandLineThreadWrapper {
        private String commandLine;
        private CommandLineThread commandLineThread;
        private Thread logStreamThread;
        private LogStreamReader logStream;
        private Process process;

        private CommandLineThreadWrapper(String commandLine, CommandLineThread commandLineThread, Thread logStreamThread, LogStreamReader logStream, Process process) {
            this.commandLine = commandLine;
            this.commandLineThread = commandLineThread;
            this.logStreamThread = logStreamThread;
            this.logStream = logStream;
            this.process = process;
        }

        private String getCommandLine() {
            return this.commandLine;
        }

        private void setCommandLine(String commandLine) {
            this.commandLine = commandLine;
        }

        private CommandLineThread getCommandLineThread() {
            return this.commandLineThread;
        }

        private void setCommandLineThread(CommandLineThread commandLineThread) {
            this.commandLineThread = commandLineThread;
        }

        private Thread getLogStreamThread() {
            return this.logStreamThread;
        }

        private void setLogStreamThread(Thread logStreamThread) {
            this.logStreamThread = logStreamThread;
        }

        private LogStreamReader getLogStream() {
            return this.logStream;
        }

        private void setLogStream(LogStreamReader logStream) {
            this.logStream = logStream;
        }

        private Process getProcess() {
            return this.process;
        }

        private void setProcess(Process process) {
            this.process = process;
        }
    }

    private static class CommandLineThread
    extends Thread {
        private final Process process;
        private Integer returnCode;

        private void setReturnCode(Integer exit) {
            this.returnCode = exit;
        }

        private Integer getReturnCode() {
            return this.returnCode;
        }

        private CommandLineThread(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            try {
                this.setReturnCode(this.process.waitFor());
            }
            catch (InterruptedException ignore) {
                return;
            }
        }
    }

    private class LogStreamReader
    implements Runnable {
        private BufferedReader reader;
        private StringBuilder output;

        public LogStreamReader(InputStream is) {
            this.reader = new BufferedReader(new InputStreamReader(is));
            this.output = new StringBuilder("");
        }

        public String getOutput() {
            return this.output.toString();
        }

        @Override
        public void run() {
            try {
                String line = this.reader.readLine();
                while (line != null) {
                    this.output.append(line);
                    this.output.append("\n");
                    line = this.reader.readLine();
                }
                this.reader.close();
            }
            catch (IOException e) {
                LOG.warn(e.getMessage());
            }
        }
    }
}

