/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.actionmanager.Stage;
import id.onyx.obdp.server.events.listeners.tasks.TaskStatusListener;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.dao.HostRoleCommandStatusSummaryDTO;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.orm.entities.StageEntity;
import id.onyx.obdp.server.orm.entities.StageEntityPK;
import id.onyx.obdp.server.topology.LogicalRequest;
import id.onyx.obdp.server.topology.TopologyManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CalculatedStatus {
    private final HostRoleStatus status;
    private final HostRoleStatus displayStatus;
    private final double percent;
    public static final CalculatedStatus COMPLETED = new CalculatedStatus(HostRoleStatus.COMPLETED, HostRoleStatus.COMPLETED, 100.0);
    public static final CalculatedStatus PENDING = new CalculatedStatus(HostRoleStatus.PENDING, HostRoleStatus.PENDING, 0.0);
    public static final CalculatedStatus ABORTED = new CalculatedStatus(HostRoleStatus.ABORTED, HostRoleStatus.ABORTED, -1.0);

    private CalculatedStatus(HostRoleStatus status, double percent) {
        this(status, null, percent);
    }

    private CalculatedStatus(HostRoleStatus status, HostRoleStatus displayStatus, double percent) {
        this.status = status;
        this.displayStatus = displayStatus;
        this.percent = percent;
    }

    public HostRoleStatus getStatus() {
        return this.status;
    }

    public HostRoleStatus getDisplayStatus() {
        return this.displayStatus;
    }

    public double getPercent() {
        return this.percent;
    }

    public static CalculatedStatus statusFromTaskEntities(Collection<HostRoleCommandEntity> tasks, boolean skippable) {
        int size = tasks.size();
        Map<HostRoleStatus, Integer> taskStatusCounts = CalculatedStatus.calculateTaskEntityStatusCounts(tasks);
        HostRoleStatus status = CalculatedStatus.calculateSummaryStatus(taskStatusCounts, size, skippable);
        double progressPercent = CalculatedStatus.calculateProgressPercent(taskStatusCounts, size);
        return new CalculatedStatus(status, progressPercent);
    }

    public static CalculatedStatus statusFromStageEntities(Collection<StageEntity> stages) {
        HashSet<HostRoleStatus> stageStatuses = new HashSet<HostRoleStatus>();
        HashSet<HostRoleCommandEntity> tasks = new HashSet<HostRoleCommandEntity>();
        for (StageEntity stage : stages) {
            Collection<HostRoleCommandEntity> stageTasks = stage.getHostRoleCommands();
            HostRoleStatus stageStatus = CalculatedStatus.calculateSummaryStatus(CalculatedStatus.calculateTaskEntityStatusCounts(stageTasks), stageTasks.size(), stage.isSkippable());
            stageStatuses.add(stageStatus);
            tasks.addAll(stageTasks);
        }
        HostRoleStatus status = CalculatedStatus.calculateSummaryStatusOfUpgrade(CalculatedStatus.calculateStatusCounts(stageStatuses), stageStatuses.size());
        double progressPercent = CalculatedStatus.calculateProgressPercent(CalculatedStatus.calculateTaskEntityStatusCounts(tasks), tasks.size());
        return new CalculatedStatus(status, progressPercent);
    }

    public static CalculatedStatus statusFromStages(Collection<Stage> stages) {
        HashSet<HostRoleStatus> stageStatuses = new HashSet<HostRoleStatus>();
        HashSet<HostRoleCommand> tasks = new HashSet<HostRoleCommand>();
        for (Stage stage : stages) {
            List<HostRoleCommand> stageTasks = stage.getOrderedHostRoleCommands();
            HostRoleStatus stageStatus = CalculatedStatus.calculateSummaryStatus(CalculatedStatus.calculateTaskStatusCounts(stageTasks), stageTasks.size(), stage.isSkippable());
            stageStatuses.add(stageStatus);
            tasks.addAll(stageTasks);
        }
        HostRoleStatus status = CalculatedStatus.calculateSummaryStatusOfUpgrade(CalculatedStatus.calculateStatusCounts(stageStatuses), stageStatuses.size());
        double progressPercent = CalculatedStatus.calculateProgressPercent(CalculatedStatus.calculateTaskStatusCounts(tasks), tasks.size());
        return new CalculatedStatus(status, progressPercent);
    }

    public static Map<HostRoleStatus, Integer> calculateStatusCounts(Collection<HostRoleStatus> hostRoleStatuses) {
        HashMap<HostRoleStatus, Integer> counters = new HashMap<HostRoleStatus, Integer>();
        for (HostRoleStatus hostRoleStatus : HostRoleStatus.values()) {
            counters.put(hostRoleStatus, 0);
        }
        for (HostRoleStatus status : hostRoleStatuses) {
            if (status.isCompletedState() && status != HostRoleStatus.COMPLETED) {
                counters.put(HostRoleStatus.COMPLETED, (Integer)counters.get((Object)HostRoleStatus.COMPLETED) + 1);
            }
            counters.put(status, (Integer)counters.get((Object)status) + 1);
        }
        counters.put(HostRoleStatus.IN_PROGRESS, hostRoleStatuses.size() - (Integer)counters.get((Object)HostRoleStatus.COMPLETED) - (Integer)counters.get((Object)HostRoleStatus.QUEUED) - (Integer)counters.get((Object)HostRoleStatus.PENDING));
        return counters;
    }

    public static Map<HostRoleStatus, Integer> calculateStatusCountsForTasks(Collection<HostRoleCommand> hostRoleCommands) {
        HashMap<HostRoleStatus, Integer> counters = new HashMap<HostRoleStatus, Integer>();
        for (HostRoleStatus hostRoleStatus : HostRoleStatus.values()) {
            counters.put(hostRoleStatus, 0);
        }
        for (HostRoleCommand hrc : hostRoleCommands) {
            if (hrc.getStatus().isCompletedState() && hrc.getStatus() != HostRoleStatus.COMPLETED) {
                counters.put(HostRoleStatus.COMPLETED, (Integer)counters.get((Object)HostRoleStatus.COMPLETED) + 1);
            }
            counters.put(hrc.getStatus(), (Integer)counters.get((Object)hrc.getStatus()) + 1);
        }
        counters.put(HostRoleStatus.IN_PROGRESS, hostRoleCommands.size() - (Integer)counters.get((Object)HostRoleStatus.COMPLETED) - (Integer)counters.get((Object)HostRoleStatus.QUEUED) - (Integer)counters.get((Object)HostRoleStatus.PENDING));
        return counters;
    }

    public static Map<StatusType, Map<HostRoleStatus, Integer>> calculateStatusCountsForStage(Collection<TaskStatusListener.ActiveStage> stages) {
        HashMap<StatusType, Map<HostRoleStatus, Integer>> counters = new HashMap<StatusType, Map<HostRoleStatus, Integer>>();
        for (StatusType statusType : StatusType.values()) {
            HashMap<HostRoleStatus, Integer> statusMap = new HashMap<HostRoleStatus, Integer>();
            counters.put(statusType, statusMap);
            for (HostRoleStatus hostRoleStatus : HostRoleStatus.values()) {
                statusMap.put(hostRoleStatus, 0);
            }
            for (TaskStatusListener.ActiveStage stage : stages) {
                HostRoleStatus status = statusType == StatusType.DISPLAY_STATUS ? stage.getDisplayStatus() : stage.getStatus();
                if (status.isCompletedState() && status != HostRoleStatus.COMPLETED) {
                    statusMap.put(HostRoleStatus.COMPLETED, (Integer)statusMap.get((Object)HostRoleStatus.COMPLETED) + 1);
                }
                statusMap.put(status, (Integer)statusMap.get((Object)status) + 1);
            }
            statusMap.put(HostRoleStatus.IN_PROGRESS, stages.size() - (Integer)statusMap.get((Object)HostRoleStatus.COMPLETED) - (Integer)statusMap.get((Object)HostRoleStatus.QUEUED) - (Integer)statusMap.get((Object)HostRoleStatus.PENDING));
        }
        return counters;
    }

    public static Map<HostRoleStatus, Integer> calculateStatusCountsForTasks(Collection<HostRoleCommand> hostRoleCommands, StageEntityPK stage) {
        HashMap<HostRoleStatus, Integer> counters = new HashMap<HostRoleStatus, Integer>();
        ArrayList<HostRoleCommand> hostRoleCommandsOfStage = new ArrayList<HostRoleCommand>();
        for (HostRoleStatus hostRoleStatus : HostRoleStatus.values()) {
            counters.put(hostRoleStatus, 0);
        }
        for (HostRoleCommand hrc : hostRoleCommands) {
            if (stage.getStageId().longValue() != hrc.getStageId() || stage.getRequestId().longValue() != hrc.getRequestId()) continue;
            if (hrc.getStatus().isCompletedState() && hrc.getStatus() != HostRoleStatus.COMPLETED) {
                counters.put(HostRoleStatus.COMPLETED, (Integer)counters.get((Object)HostRoleStatus.COMPLETED) + 1);
            }
            counters.put(hrc.getStatus(), (Integer)counters.get((Object)hrc.getStatus()) + 1);
            hostRoleCommandsOfStage.add(hrc);
        }
        counters.put(HostRoleStatus.IN_PROGRESS, hostRoleCommandsOfStage.size() - (Integer)counters.get((Object)HostRoleStatus.COMPLETED) - (Integer)counters.get((Object)HostRoleStatus.QUEUED) - (Integer)counters.get((Object)HostRoleStatus.PENDING));
        return counters;
    }

    public static Map<HostRoleStatus, Integer> calculateTaskEntityStatusCounts(Collection<HostRoleCommandEntity> tasks) {
        LinkedList<HostRoleStatus> hostRoleStatuses = new LinkedList<HostRoleStatus>();
        for (HostRoleCommandEntity hostRoleCommand : tasks) {
            hostRoleStatuses.add(hostRoleCommand.getStatus());
        }
        return CalculatedStatus.calculateStatusCounts(hostRoleStatuses);
    }

    public static Map<HostRoleStatus, Integer> calculateTaskStatusCounts(Map<Long, HostRoleCommandStatusSummaryDTO> stageDto, Set<Long> stageIds) {
        ArrayList<HostRoleStatus> status = new ArrayList<HostRoleStatus>();
        for (Long stageId : stageIds) {
            if (!stageDto.containsKey(stageId)) continue;
            HostRoleCommandStatusSummaryDTO dto = stageDto.get(stageId);
            status.addAll(dto.getTaskStatuses());
        }
        return CalculatedStatus.calculateStatusCounts(status);
    }

    public static CalculatedStatus statusFromRequest(HostRoleCommandDAO s_hostRoleCommandDAO, TopologyManager topologyManager, Long requestId) {
        Map<Long, HostRoleCommandStatusSummaryDTO> summary = s_hostRoleCommandDAO.findAggregateCounts(requestId);
        summary.putAll(topologyManager.getStageSummaries(requestId));
        LogicalRequest logicalRequest = topologyManager.getRequest(requestId);
        CalculatedStatus status = summary.isEmpty() && null != logicalRequest ? (logicalRequest.getHostRequests().isEmpty() ? COMPLETED : PENDING) : CalculatedStatus.statusFromStageSummary(summary, summary.keySet());
        return status;
    }

    public static CalculatedStatus statusFromStageSummary(Map<Long, HostRoleCommandStatusSummaryDTO> stageDto, Set<Long> stageIds) {
        if (stageDto.isEmpty() || stageIds.isEmpty()) {
            return COMPLETED;
        }
        HashSet<HostRoleStatus> stageStatuses = new HashSet<HostRoleStatus>();
        HashSet<HostRoleStatus> stageDisplayStatuses = new HashSet<HostRoleStatus>();
        ArrayList<HostRoleStatus> taskStatuses = new ArrayList<HostRoleStatus>();
        for (Long stageId : stageIds) {
            if (!stageDto.containsKey(stageId)) continue;
            HostRoleCommandStatusSummaryDTO summary = stageDto.get(stageId);
            int total = summary.getTaskTotal();
            boolean skip = summary.isStageSkippable();
            Map<HostRoleStatus, Integer> counts = CalculatedStatus.calculateStatusCounts(summary.getTaskStatuses());
            HostRoleStatus stageStatus = CalculatedStatus.calculateSummaryStatus(counts, total, skip);
            HostRoleStatus stageDisplayStatus = CalculatedStatus.calculateSummaryDisplayStatus(counts, total, skip);
            stageStatuses.add(stageStatus);
            stageDisplayStatuses.add(stageDisplayStatus);
            taskStatuses.addAll(summary.getTaskStatuses());
        }
        Map<HostRoleStatus, Integer> counts = CalculatedStatus.calculateStatusCounts(stageStatuses);
        Map<HostRoleStatus, Integer> displayCounts = CalculatedStatus.calculateStatusCounts(stageDisplayStatuses);
        HostRoleStatus status = CalculatedStatus.calculateSummaryStatusOfUpgrade(counts, stageStatuses.size());
        HostRoleStatus displayStatus = CalculatedStatus.calculateSummaryDisplayStatus(displayCounts, stageDisplayStatuses.size(), false);
        double progressPercent = CalculatedStatus.calculateProgressPercent(CalculatedStatus.calculateStatusCounts(taskStatuses), taskStatuses.size());
        return new CalculatedStatus(status, displayStatus, progressPercent);
    }

    private static Map<HostRoleStatus, Integer> calculateTaskStatusCounts(Collection<HostRoleCommand> tasks) {
        LinkedList<HostRoleStatus> hostRoleStatuses = new LinkedList<HostRoleStatus>();
        for (HostRoleCommand hostRoleCommand : tasks) {
            hostRoleStatuses.add(hostRoleCommand.getStatus());
        }
        return CalculatedStatus.calculateStatusCounts(hostRoleStatuses);
    }

    private static double calculateProgressPercent(Map<HostRoleStatus, Integer> counters, double total) {
        return total == 0.0 ? 0.0 : ((double)counters.get((Object)HostRoleStatus.QUEUED).intValue() * 0.09 + (double)counters.get((Object)HostRoleStatus.IN_PROGRESS).intValue() * 0.35 + (double)counters.get((Object)HostRoleStatus.HOLDING).intValue() * 0.35 + (double)counters.get((Object)HostRoleStatus.HOLDING_FAILED).intValue() * 0.35 + (double)counters.get((Object)HostRoleStatus.HOLDING_TIMEDOUT).intValue() * 0.35 + (double)counters.get((Object)HostRoleStatus.COMPLETED).intValue()) / total * 100.0;
    }

    public static HostRoleStatus calculateSummaryStatus(Map<HostRoleStatus, Integer> counters, int total, boolean skippable) {
        if (total == 0) {
            return HostRoleStatus.COMPLETED;
        }
        if (counters.get((Object)HostRoleStatus.PENDING) == total) {
            return HostRoleStatus.PENDING;
        }
        if (counters.get((Object)HostRoleStatus.HOLDING) > 0 || counters.get((Object)HostRoleStatus.HOLDING_FAILED) > 0 || counters.get((Object)HostRoleStatus.HOLDING_TIMEDOUT) > 0) {
            return counters.get((Object)HostRoleStatus.HOLDING) > 0 ? HostRoleStatus.HOLDING : (counters.get((Object)HostRoleStatus.HOLDING_FAILED) > 0 ? HostRoleStatus.HOLDING_FAILED : HostRoleStatus.HOLDING_TIMEDOUT);
        }
        if (counters.get((Object)HostRoleStatus.FAILED) > 0 && !skippable) {
            return HostRoleStatus.FAILED;
        }
        if (counters.get((Object)HostRoleStatus.TIMEDOUT) > 0 && !skippable) {
            return HostRoleStatus.TIMEDOUT;
        }
        int numActiveTasks = counters.get((Object)HostRoleStatus.PENDING) + counters.get((Object)HostRoleStatus.QUEUED) + counters.get((Object)HostRoleStatus.IN_PROGRESS);
        if (counters.get((Object)HostRoleStatus.ABORTED) > 0 && numActiveTasks == 0) {
            return HostRoleStatus.ABORTED;
        }
        if (counters.get((Object)HostRoleStatus.COMPLETED) == total) {
            return HostRoleStatus.COMPLETED;
        }
        return HostRoleStatus.IN_PROGRESS;
    }

    public static HostRoleStatus calculateSummaryStatusFromPartialSet(Map<HostRoleStatus, Integer> counters, boolean skippable) {
        int inProgressTasks;
        HostRoleStatus status = HostRoleStatus.PENDING;
        if (counters.get((Object)HostRoleStatus.HOLDING) > 0 || counters.get((Object)HostRoleStatus.HOLDING_FAILED) > 0 || counters.get((Object)HostRoleStatus.HOLDING_TIMEDOUT) > 0) {
            HostRoleStatus hostRoleStatus = counters.get((Object)HostRoleStatus.HOLDING) > 0 ? HostRoleStatus.HOLDING : (status = counters.get((Object)HostRoleStatus.HOLDING_FAILED) > 0 ? HostRoleStatus.HOLDING_FAILED : HostRoleStatus.HOLDING_TIMEDOUT);
        }
        if (counters.get((Object)HostRoleStatus.FAILED) > 0 && !skippable) {
            status = HostRoleStatus.FAILED;
        }
        if (counters.get((Object)HostRoleStatus.TIMEDOUT) > 0 && !skippable) {
            status = HostRoleStatus.TIMEDOUT;
        }
        if ((inProgressTasks = counters.get((Object)HostRoleStatus.QUEUED) + counters.get((Object)HostRoleStatus.IN_PROGRESS)) > 0) {
            status = HostRoleStatus.IN_PROGRESS;
        }
        return status;
    }

    public static HostRoleStatus calculateStageStatus(List<HostRoleCommand> hostRoleCommands, Map<HostRoleStatus, Integer> counters, Map<Role, Float> successFactors, boolean skippable) {
        Set<Role> rolesWithTimedOutTasks;
        Boolean didStageFailed;
        Set<Role> rolesWithTimedOutTasks2;
        Set<Role> rolesWithFailedTasks;
        Boolean didStageFailed2;
        int total = hostRoleCommands.size();
        if (total == 0) {
            return HostRoleStatus.COMPLETED;
        }
        if (counters.get((Object)HostRoleStatus.PENDING) == total) {
            return HostRoleStatus.PENDING;
        }
        if (counters.get((Object)HostRoleStatus.HOLDING) > 0 || counters.get((Object)HostRoleStatus.HOLDING_FAILED) > 0 || counters.get((Object)HostRoleStatus.HOLDING_TIMEDOUT) > 0) {
            return counters.get((Object)HostRoleStatus.HOLDING) > 0 ? HostRoleStatus.HOLDING : (counters.get((Object)HostRoleStatus.HOLDING_FAILED) > 0 ? HostRoleStatus.HOLDING_FAILED : HostRoleStatus.HOLDING_TIMEDOUT);
        }
        if (counters.get((Object)HostRoleStatus.FAILED) > 0 && !skippable && (didStageFailed2 = CalculatedStatus.didStageFailed(hostRoleCommands, rolesWithFailedTasks = CalculatedStatus.getRolesOfFailedTasks(hostRoleCommands), successFactors)).booleanValue()) {
            return HostRoleStatus.FAILED;
        }
        if (counters.get((Object)HostRoleStatus.TIMEDOUT) > 0 && !skippable && (didStageFailed2 = CalculatedStatus.didStageFailed(hostRoleCommands, rolesWithTimedOutTasks2 = CalculatedStatus.getRolesOfTimedOutTasks(hostRoleCommands), successFactors)).booleanValue()) {
            return HostRoleStatus.TIMEDOUT;
        }
        int numActiveTasks = counters.get((Object)HostRoleStatus.PENDING) + counters.get((Object)HostRoleStatus.QUEUED) + counters.get((Object)HostRoleStatus.IN_PROGRESS);
        if (numActiveTasks > 0) {
            return HostRoleStatus.IN_PROGRESS;
        }
        if (counters.get((Object)HostRoleStatus.ABORTED) > 0 && (didStageFailed = CalculatedStatus.didStageFailed(hostRoleCommands, rolesWithTimedOutTasks = CalculatedStatus.getRolesOfAbortedTasks(hostRoleCommands), successFactors)).booleanValue()) {
            return HostRoleStatus.ABORTED;
        }
        return HostRoleStatus.COMPLETED;
    }

    protected static Set<Role> getRolesOfFailedTasks(List<HostRoleCommand> hostRoleCommands) {
        return CalculatedStatus.getRolesOfTasks(hostRoleCommands, HostRoleStatus.FAILED);
    }

    protected static Set<Role> getRolesOfTimedOutTasks(List<HostRoleCommand> hostRoleCommands) {
        return CalculatedStatus.getRolesOfTasks(hostRoleCommands, HostRoleStatus.TIMEDOUT);
    }

    protected static Set<Role> getRolesOfAbortedTasks(List<HostRoleCommand> hostRoleCommands) {
        return CalculatedStatus.getRolesOfTasks(hostRoleCommands, HostRoleStatus.ABORTED);
    }

    protected static Set<Role> getRolesOfTasks(List<HostRoleCommand> hostRoleCommands, final HostRoleStatus status) {
        Predicate<HostRoleCommand> predicate = new Predicate<HostRoleCommand>(){

            public boolean apply(HostRoleCommand hrc) {
                return hrc.getStatus() == status;
            }
        };
        Function<HostRoleCommand, Role> transform = new Function<HostRoleCommand, Role>(){

            public Role apply(HostRoleCommand hrc) {
                return hrc.getRole();
            }
        };
        return FluentIterable.from(hostRoleCommands).filter((Predicate)predicate).transform((Function)transform).toSet();
    }

    protected static Boolean didStageFailed(List<HostRoleCommand> hostRoleCommands, Set<Role> roles, Map<Role, Float> successFactors) {
        Boolean isFailed = Boolean.FALSE;
        for (Role role : roles) {
            List<HostRoleCommand> hostRoleCommandsOfRole = CalculatedStatus.getHostRoleCommandsOfRole(hostRoleCommands, role);
            List<HostRoleCommand> failedHostRoleCommands = CalculatedStatus.getFailedHostRoleCommands(hostRoleCommandsOfRole);
            float successRatioForRole = (hostRoleCommandsOfRole.size() - failedHostRoleCommands.size()) / hostRoleCommandsOfRole.size();
            float f = successFactors.get(role) == null ? 1.0f : successFactors.get(role).floatValue();
            Float successFactorForRole = Float.valueOf(f);
            if (!(successRatioForRole < successFactorForRole.floatValue())) continue;
            isFailed = Boolean.TRUE;
            break;
        }
        return isFailed;
    }

    protected static List<HostRoleCommand> getHostRoleCommandsOfRole(List<HostRoleCommand> hostRoleCommands, final Role role) {
        Predicate<HostRoleCommand> predicate = new Predicate<HostRoleCommand>(){

            public boolean apply(HostRoleCommand hrc) {
                return hrc.getRole() == role;
            }
        };
        return FluentIterable.from(hostRoleCommands).filter((Predicate)predicate).toList();
    }

    protected static List<HostRoleCommand> getFailedHostRoleCommands(List<HostRoleCommand> hostRoleCommands) {
        Predicate<HostRoleCommand> predicate = new Predicate<HostRoleCommand>(){

            public boolean apply(HostRoleCommand hrc) {
                return hrc.getStatus().isFailedAndNotSkippableState();
            }
        };
        return FluentIterable.from(hostRoleCommands).filter((Predicate)predicate).toList();
    }

    public static HostRoleStatus getOverallStatusForRequest(Collection<HostRoleStatus> hostRoleStatuses) {
        Map<HostRoleStatus, Integer> statusCount = CalculatedStatus.calculateStatusCounts(hostRoleStatuses);
        return CalculatedStatus.calculateSummaryStatus(statusCount, hostRoleStatuses.size(), false);
    }

    public static HostRoleStatus getOverallDisplayStatusForRequest(Collection<HostRoleStatus> hostRoleStatuses) {
        Map<HostRoleStatus, Integer> statusCount = CalculatedStatus.calculateStatusCounts(hostRoleStatuses);
        return CalculatedStatus.calculateSummaryDisplayStatus(statusCount, hostRoleStatuses.size(), false);
    }

    protected static HostRoleStatus calculateSummaryStatusOfUpgrade(Map<HostRoleStatus, Integer> counters, int total) {
        return CalculatedStatus.calculateSummaryStatus(counters, total, false);
    }

    public static HostRoleStatus calculateSummaryDisplayStatus(Map<HostRoleStatus, Integer> counters, int total, boolean skippable) {
        return counters.get((Object)HostRoleStatus.FAILED) > 0 ? HostRoleStatus.FAILED : (counters.get((Object)HostRoleStatus.TIMEDOUT) > 0 ? HostRoleStatus.TIMEDOUT : (counters.get((Object)HostRoleStatus.SKIPPED_FAILED) > 0 ? HostRoleStatus.SKIPPED_FAILED : CalculatedStatus.calculateSummaryStatus(counters, total, skippable)));
    }

    public static enum StatusType {
        STATUS("status"),
        DISPLAY_STATUS("display_status");

        private String value;

        private StatusType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

