/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import id.onyx.obdp.server.DuplicateResourceException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.RequestImpl;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.dao.BlueprintDAO;
import id.onyx.obdp.server.orm.dao.TopologyRequestDAO;
import id.onyx.obdp.server.orm.entities.BlueprintConfigEntity;
import id.onyx.obdp.server.orm.entities.BlueprintConfiguration;
import id.onyx.obdp.server.orm.entities.BlueprintEntity;
import id.onyx.obdp.server.orm.entities.BlueprintSettingEntity;
import id.onyx.obdp.server.orm.entities.HostGroupComponentEntity;
import id.onyx.obdp.server.orm.entities.HostGroupEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.orm.entities.TopologyRequestEntity;
import id.onyx.obdp.server.stack.NoSuchStackException;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.SecurityType;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.topology.Blueprint;
import id.onyx.obdp.server.topology.BlueprintFactory;
import id.onyx.obdp.server.topology.GPLLicenseNotAcceptedException;
import id.onyx.obdp.server.topology.InvalidTopologyException;
import id.onyx.obdp.server.topology.SecurityConfiguration;
import id.onyx.obdp.server.topology.SecurityConfigurationFactory;
import id.onyx.obdp.server.utils.SecretReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintResourceProvider
extends AbstractControllerResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(BlueprintResourceProvider.class);
    public static final String BLUEPRINT_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Blueprints", "blueprint_name");
    public static final String STACK_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Blueprints", "stack_name");
    public static final String STACK_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("Blueprints", "stack_version");
    public static final String BLUEPRINT_SECURITY_PROPERTY_ID = PropertyHelper.getPropertyId("Blueprints", "security");
    public static final String BLUEPRINTS_PROPERTY_ID = "Blueprints";
    public static final String HOST_GROUP_PROPERTY_ID = "host_groups";
    public static final String HOST_GROUP_NAME_PROPERTY_ID = "name";
    public static final String HOST_GROUP_CARDINALITY_PROPERTY_ID = "cardinality";
    public static final String COMPONENT_PROPERTY_ID = "components";
    public static final String COMPONENT_NAME_PROPERTY_ID = "name";
    public static final String COMPONENT_PROVISION_ACTION_PROPERTY_ID = "provision_action";
    public static final String CONFIGURATION_PROPERTY_ID = "configurations";
    public static final String SETTING_PROPERTY_ID = "settings";
    public static final String PROPERTIES_PROPERTY_ID = "properties";
    public static final String PROPERTIES_ATTRIBUTES_PROPERTY_ID = "properties_attributes";
    public static final String SCHEMA_IS_NOT_SUPPORTED_MESSAGE = "Configuration format provided in Blueprint is not supported";
    public static final String REQUEST_BODY_EMPTY_ERROR_MESSAGE = "Request body for Blueprint create request is empty";
    public static final String CONFIGURATION_LIST_CHECK_ERROR_MESSAGE = "Configurations property must be a List of Maps";
    public static final String CONFIGURATION_MAP_CHECK_ERROR_MESSAGE = "Configuration elements must be Maps";
    public static final String CONFIGURATION_MAP_SIZE_CHECK_ERROR_MESSAGE = "Configuration Maps must hold a single configuration type each";
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Blueprint, (Object)BLUEPRINT_NAME_PROPERTY_ID).build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{BLUEPRINT_NAME_PROPERTY_ID, STACK_NAME_PROPERTY_ID, STACK_VERSION_PROPERTY_ID, BLUEPRINT_SECURITY_PROPERTY_ID, "host_groups", "configurations", "settings"});
    private static BlueprintFactory blueprintFactory;
    private static SecurityConfigurationFactory securityConfigurationFactory;
    private static BlueprintDAO blueprintDAO;
    private static TopologyRequestDAO topologyRequestDAO;
    private static Gson jsonSerializer;
    private static OBDPMetaInfo obdpMetaInfo;

    BlueprintResourceProvider(OBDPManagementController controller) {
        super(Resource.Type.Blueprint, propertyIds, keyPropertyIds, controller);
    }

    public static void init(BlueprintFactory factory, BlueprintDAO bpDao, TopologyRequestDAO trDao, SecurityConfigurationFactory securityFactory, Gson gson, OBDPMetaInfo metaInfo) {
        blueprintFactory = factory;
        blueprintDAO = bpDao;
        topologyRequestDAO = trDao;
        securityConfigurationFactory = securityFactory;
        jsonSerializer = gson;
        obdpMetaInfo = metaInfo;
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        for (Map<String, Object> properties : request.getProperties()) {
            try {
                this.createResources(this.getCreateCommand(properties, request.getRequestInfoProperties()));
            }
            catch (IllegalArgumentException e) {
                LOG.error("Exception while creating blueprint", (Throwable)e);
                throw e;
            }
        }
        this.notifyCreate(Resource.Type.Blueprint, request);
        return this.getRequestStatus(null);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        String name;
        Set<Map<String, Object>> requestProps;
        List<BlueprintEntity> results = null;
        boolean applyPredicate = false;
        if (predicate != null && (requestProps = this.getPropertyMaps(predicate)).size() == 1 && (name = (String)requestProps.iterator().next().get(BLUEPRINT_NAME_PROPERTY_ID)) != null) {
            BlueprintEntity entity = blueprintDAO.findByName(name);
            List<Object> list = results = entity == null ? Collections.emptyList() : Collections.singletonList(entity);
        }
        if (results == null) {
            applyPredicate = true;
            results = blueprintDAO.findAll();
        }
        HashSet<Resource> resources = new HashSet<Resource>();
        for (BlueprintEntity entity : results) {
            Resource resource = this.toResource(entity, this.getRequestPropertyIds(request, predicate));
            if (predicate != null && applyPredicate && !predicate.evaluate(resource)) continue;
            resources.add(resource);
        }
        if (predicate != null && resources.isEmpty()) {
            throw new NoSuchResourceException("The requested resource doesn't exist: Blueprint not found, " + predicate);
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        return null;
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Set<Resource> setResources = this.getResources(new RequestImpl(null, null, null, null), predicate);
        List<TopologyRequestEntity> provisionRequests = topologyRequestDAO.findAllProvisionRequests();
        Set provisionedBlueprints = provisionRequests.stream().map(TopologyRequestEntity::getBlueprintName).collect(Collectors.toSet());
        for (Resource resource : setResources) {
            String blueprintName = (String)resource.getPropertyValue(BLUEPRINT_NAME_PROPERTY_ID);
            Preconditions.checkArgument((!provisionedBlueprints.contains(blueprintName) ? 1 : 0) != 0, (String)"Blueprint %s cannot be deleted as cluster provisioning was initiated on it.", (Object)blueprintName);
            LOG.info("Deleting Blueprint, name = " + blueprintName);
            this.modifyResources(() -> {
                blueprintDAO.removeByName(blueprintName);
                return null;
            });
        }
        this.notifyDelete(Resource.Type.Blueprint, predicate);
        return this.getRequestStatus(null);
    }

    protected Resource toResource(BlueprintEntity entity, Set<String> requestedIds) throws NoSuchResourceException {
        StackEntity stackEntity = entity.getStack();
        ResourceImpl resource = new ResourceImpl(Resource.Type.Blueprint);
        BlueprintResourceProvider.setResourceProperty(resource, BLUEPRINT_NAME_PROPERTY_ID, entity.getBlueprintName(), requestedIds);
        BlueprintResourceProvider.setResourceProperty(resource, STACK_NAME_PROPERTY_ID, stackEntity.getStackName(), requestedIds);
        BlueprintResourceProvider.setResourceProperty(resource, STACK_VERSION_PROPERTY_ID, stackEntity.getStackVersion(), requestedIds);
        ArrayList listGroupProps = new ArrayList();
        Collection<HostGroupEntity> hostGroups = entity.getHostGroups();
        for (HostGroupEntity hostGroup : hostGroups) {
            HashMap<String, Object> mapGroupProps = new HashMap<String, Object>();
            mapGroupProps.put("name", hostGroup.getName());
            listGroupProps.add(mapGroupProps);
            mapGroupProps.put(HOST_GROUP_CARDINALITY_PROPERTY_ID, hostGroup.getCardinality());
            ArrayList listComponentProps = new ArrayList();
            Collection<HostGroupComponentEntity> components = hostGroup.getComponents();
            for (HostGroupComponentEntity component : components) {
                HashMap<String, String> mapComponentProps = new HashMap<String, String>();
                mapComponentProps.put("name", component.getName());
                if (component.getProvisionAction() != null) {
                    mapComponentProps.put(COMPONENT_PROVISION_ACTION_PROPERTY_ID, component.getProvisionAction().toString());
                }
                listComponentProps.add(mapComponentProps);
            }
            mapGroupProps.put(COMPONENT_PROPERTY_ID, listComponentProps);
            mapGroupProps.put(CONFIGURATION_PROPERTY_ID, this.populateConfigurationList(hostGroup.getConfigurations()));
        }
        BlueprintResourceProvider.setResourceProperty(resource, HOST_GROUP_PROPERTY_ID, listGroupProps, requestedIds);
        BlueprintResourceProvider.setResourceProperty(resource, CONFIGURATION_PROPERTY_ID, this.populateConfigurationList(entity.getConfigurations()), requestedIds);
        BlueprintResourceProvider.setResourceProperty(resource, SETTING_PROPERTY_ID, BlueprintResourceProvider.populateSettingList(entity.getSettings()), requestedIds);
        if (entity.getSecurityType() != null) {
            LinkedHashMap<String, String> securityConfigMap = new LinkedHashMap<String, String>();
            securityConfigMap.put("type", entity.getSecurityType().name());
            if (entity.getSecurityType() == SecurityType.KERBEROS) {
                securityConfigMap.put("kerberos_descriptor_reference", entity.getSecurityDescriptorReference());
            }
            BlueprintResourceProvider.setResourceProperty(resource, BLUEPRINT_SECURITY_PROPERTY_ID, securityConfigMap, requestedIds);
        }
        return resource;
    }

    List<Map<String, Map<String, Object>>> populateConfigurationList(Collection<? extends BlueprintConfiguration> configurations) throws NoSuchResourceException {
        ArrayList<Map<String, Map<String, Object>>> listConfigurations = new ArrayList<Map<String, Map<String, Object>>>();
        for (BlueprintConfiguration blueprintConfiguration : configurations) {
            HashMap mapConfigurations = new HashMap();
            HashMap<String, Map> configTypeDefinition = new HashMap<String, Map>();
            String type = blueprintConfiguration.getType();
            if (blueprintConfiguration instanceof BlueprintConfigEntity) {
                StackInfo metaInfoStack;
                properties = (Map)jsonSerializer.fromJson(blueprintConfiguration.getConfigData(), Map.class);
                StackEntity stack = ((BlueprintConfigEntity)blueprintConfiguration).getBlueprintEntity().getStack();
                try {
                    metaInfoStack = obdpMetaInfo.getStack(stack.getStackName(), stack.getStackVersion());
                }
                catch (OBDPException e) {
                    throw new NoSuchResourceException(e.getMessage());
                }
                Map<PropertyInfo.PropertyType, Set<String>> propertiesTypes = metaInfoStack.getConfigPropertiesTypes(type);
                SecretReference.replacePasswordsWithReferences(propertiesTypes, properties, type, -1L);
                configTypeDefinition.put(PROPERTIES_PROPERTY_ID, properties);
            } else {
                properties = (Map)jsonSerializer.fromJson(blueprintConfiguration.getConfigData(), Map.class);
                configTypeDefinition.put(PROPERTIES_PROPERTY_ID, properties);
            }
            Map attributes = (Map)jsonSerializer.fromJson(blueprintConfiguration.getConfigAttributes(), Map.class);
            if (attributes != null && !attributes.isEmpty()) {
                configTypeDefinition.put(PROPERTIES_ATTRIBUTES_PROPERTY_ID, attributes);
            }
            mapConfigurations.put(type, configTypeDefinition);
            listConfigurations.add(mapConfigurations);
        }
        return listConfigurations;
    }

    public static List<Map<String, Object>> populateSettingList(Collection<? extends BlueprintSettingEntity> settings) throws NoSuchResourceException {
        ArrayList<Map<String, Object>> listSettings = new ArrayList<Map<String, Object>>();
        if (settings != null) {
            for (BlueprintSettingEntity blueprintSettingEntity : settings) {
                List propertiesList = (List)jsonSerializer.fromJson(blueprintSettingEntity.getSettingData(), List.class);
                HashMap<String, List> settingMap = new HashMap<String, List>();
                settingMap.put(blueprintSettingEntity.getSettingName(), propertiesList);
                listSettings.add(settingMap);
            }
        }
        return listSettings;
    }

    void createBlueprintConfigEntities(Collection<Map<String, String>> propertyMaps, BlueprintEntity blueprint) {
        ArrayList<BlueprintConfigEntity> configurations = new ArrayList<BlueprintConfigEntity>();
        if (propertyMaps != null) {
            for (Map<String, String> configuration : propertyMaps) {
                BlueprintConfigEntity configEntity = new BlueprintConfigEntity();
                configEntity.setBlueprintEntity(blueprint);
                configEntity.setBlueprintName(blueprint.getBlueprintName());
                this.populateConfigurationEntity(configuration, configEntity);
                configurations.add(configEntity);
            }
        }
        blueprint.setConfigurations(configurations);
    }

    void populateConfigurationEntity(Map<String, String> configuration, BlueprintConfiguration configEntity) {
        BlueprintConfigPopulationStrategy p = this.decidePopulationStrategy(configuration);
        p.applyConfiguration(configuration, configEntity);
    }

    BlueprintConfigPopulationStrategy decidePopulationStrategy(Map<String, String> configuration) {
        if (configuration != null && !configuration.isEmpty()) {
            String keyEntry = configuration.keySet().iterator().next();
            String[] keyNameTokens = keyEntry.split("/");
            int levels = keyNameTokens.length;
            String propertiesType = keyNameTokens[1];
            if (levels == 2) {
                return new BlueprintConfigPopulationStrategyV1();
            }
            if (levels == 3 && PROPERTIES_PROPERTY_ID.equals(propertiesType) || levels == 4 && PROPERTIES_ATTRIBUTES_PROPERTY_ID.equals(propertiesType)) {
                return new BlueprintConfigPopulationStrategyV2();
            }
            throw new IllegalArgumentException(SCHEMA_IS_NOT_SUPPORTED_MESSAGE);
        }
        return new BlueprintConfigPopulationStrategyV2();
    }

    private AbstractResourceProvider.Command<Void> getCreateCommand(final Map<String, Object> properties, final Map<String, String> requestInfoProps) {
        return new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                Blueprint blueprint;
                String rawRequestBody = (String)requestInfoProps.get("RAW_REQUEST_BODY");
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)rawRequestBody) ? 1 : 0) != 0, (Object)BlueprintResourceProvider.REQUEST_BODY_EMPTY_ERROR_MESSAGE);
                Map rawBodyMap = (Map)jsonSerializer.fromJson(rawRequestBody, Map.class);
                Object configurationData = rawBodyMap.get(BlueprintResourceProvider.CONFIGURATION_PROPERTY_ID);
                if (configurationData != null) {
                    Preconditions.checkArgument((boolean)(configurationData instanceof List), (Object)BlueprintResourceProvider.CONFIGURATION_LIST_CHECK_ERROR_MESSAGE);
                    for (Object map : (List)configurationData) {
                        Preconditions.checkArgument((boolean)(map instanceof Map), (Object)BlueprintResourceProvider.CONFIGURATION_MAP_CHECK_ERROR_MESSAGE);
                        Preconditions.checkArgument((((Map)map).size() <= 1 ? 1 : 0) != 0, (Object)BlueprintResourceProvider.CONFIGURATION_MAP_SIZE_CHECK_ERROR_MESSAGE);
                    }
                }
                SecurityConfiguration securityConfiguration = securityConfigurationFactory.createSecurityConfigurationFromRequest((Map)rawBodyMap.get(BlueprintResourceProvider.BLUEPRINTS_PROPERTY_ID), true);
                try {
                    blueprint = blueprintFactory.createBlueprint(properties, securityConfiguration);
                }
                catch (NoSuchStackException e) {
                    throw new IllegalArgumentException("Specified stack doesn't exist: " + e, e);
                }
                if (blueprintDAO.findByName(blueprint.getName()) != null) {
                    throw new DuplicateResourceException("Attempted to create a Blueprint which already exists, blueprint_name=" + blueprint.getName());
                }
                try {
                    blueprint.validateRequiredProperties();
                }
                catch (GPLLicenseNotAcceptedException | InvalidTopologyException e) {
                    throw new IllegalArgumentException("Blueprint configuration validation failed: " + e.getMessage(), e);
                }
                String validateTopology = (String)requestInfoProps.get("validate_topology");
                if (validateTopology == null || !validateTopology.equalsIgnoreCase("false")) {
                    try {
                        blueprint.validateTopology();
                    }
                    catch (InvalidTopologyException e) {
                        throw new IllegalArgumentException(e.getMessage());
                    }
                }
                LOG.info("Creating Blueprint, name=" + blueprint.getName());
                String blueprintSetting = blueprint.getSetting() == null ? "(null)" : jsonSerializer.toJson(blueprint.getSetting().getProperties());
                LOG.info("Blueprint setting=" + blueprintSetting);
                try {
                    blueprintDAO.create(blueprint.toEntity());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        };
    }

    protected static abstract class BlueprintConfigPopulationStrategy {
        protected BlueprintConfigPopulationStrategy() {
        }

        public void applyConfiguration(Map<String, String> configuration, BlueprintConfiguration blueprintConfiguration) {
            HashMap<String, String> configData = new HashMap<String, String>();
            HashMap<String, Map<String, String>> configAttributes = new HashMap<String, Map<String, String>>();
            if (configuration != null) {
                for (Map.Entry<String, String> entry : configuration.entrySet()) {
                    String absolutePropName = entry.getKey();
                    String propertyValue = entry.getValue();
                    String[] propertyNameTokens = absolutePropName.split("/");
                    if (blueprintConfiguration.getType() == null) {
                        blueprintConfiguration.setType(propertyNameTokens[0]);
                    }
                    this.addProperty(configData, configAttributes, propertyNameTokens, propertyValue);
                }
            }
            blueprintConfiguration.setConfigData(jsonSerializer.toJson(configData));
            blueprintConfiguration.setConfigAttributes(jsonSerializer.toJson(configAttributes));
        }

        protected abstract void addProperty(Map<String, String> var1, Map<String, Map<String, String>> var2, String[] var3, String var4);
    }

    protected static class BlueprintConfigPopulationStrategyV1
    extends BlueprintConfigPopulationStrategy {
        protected BlueprintConfigPopulationStrategyV1() {
        }

        @Override
        protected void addProperty(Map<String, String> configData, Map<String, Map<String, String>> configAttributes, String[] propertyNameTokens, String propertyValue) {
            configData.put(propertyNameTokens[1], propertyValue);
        }
    }

    protected static class BlueprintConfigPopulationStrategyV2
    extends BlueprintConfigPopulationStrategy {
        protected BlueprintConfigPopulationStrategyV2() {
        }

        @Override
        protected void addProperty(Map<String, String> configData, Map<String, Map<String, String>> configAttributes, String[] propertyNameTokens, String propertyValue) {
            if (BlueprintResourceProvider.PROPERTIES_PROPERTY_ID.equals(propertyNameTokens[1])) {
                configData.put(propertyNameTokens[2], propertyValue);
            } else if (BlueprintResourceProvider.PROPERTIES_ATTRIBUTES_PROPERTY_ID.equals(propertyNameTokens[1])) {
                this.addConfigAttribute(configAttributes, propertyNameTokens, propertyValue);
            }
        }

        private void addConfigAttribute(Map<String, Map<String, String>> configDependencyProperties, String[] propertyNameTokens, String value) {
            if (!configDependencyProperties.containsKey(propertyNameTokens[2])) {
                configDependencyProperties.put(propertyNameTokens[2], new HashMap());
            }
            Map<String, String> propertiesGroup = configDependencyProperties.get(propertyNameTokens[2]);
            propertiesGroup.put(propertyNameTokens[3], value);
        }
    }
}

