/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.topology.Configuration;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BlueprintExportType {
    FULL{

        @Override
        public Configuration filter(Configuration actualConfig, Configuration defaultConfig) {
            return actualConfig;
        }

        @Override
        public boolean include(String value, String defaultValue) {
            return true;
        }

        @Override
        public boolean include(Collection<?> collection) {
            return true;
        }

        @Override
        public boolean include(Map<?, ?> map) {
            return true;
        }
    }
    ,
    MINIMAL{

        @Override
        public Configuration filter(Configuration actualConfig, Configuration defaultConfig) {
            String configType;
            for (Map.Entry configTypeEntry : ImmutableSet.copyOf(actualConfig.getProperties().entrySet())) {
                configType = (String)configTypeEntry.getKey();
                Map properties = (Map)configTypeEntry.getValue();
                for (Map.Entry propertyEntry : ImmutableSet.copyOf(properties.entrySet())) {
                    String defaultValue;
                    String propertyName = (String)propertyEntry.getKey();
                    String propertyValue = (String)propertyEntry.getValue();
                    if (this.include(propertyValue, defaultValue = defaultConfig.getPropertyValue(configType, propertyName))) {
                        LOG.debug("Including {}/{} in exported blueprint, as default value and actual value differ:\n{}\nvs\n{}", new Object[]{configType, propertyName, defaultValue, propertyValue});
                        continue;
                    }
                    LOG.debug("Omitting {}/{} from exported blueprint, as it has the default value of {}", new Object[]{configType, propertyName, propertyValue});
                    actualConfig.removeProperty(configType, propertyName);
                }
                if (!properties.isEmpty()) continue;
                actualConfig.getProperties().remove(configType);
            }
            for (Map.Entry configTypeEntry : ImmutableSet.copyOf(actualConfig.getAttributes().entrySet())) {
                configType = (String)configTypeEntry.getKey();
                Map attributes = (Map)configTypeEntry.getValue();
                for (Map.Entry attributeEntry : ImmutableSet.copyOf(attributes.entrySet())) {
                    String attributeName = (String)attributeEntry.getKey();
                    Map properties = (Map)attributeEntry.getValue();
                    for (Map.Entry propertyEntry : ImmutableSet.copyOf(properties.entrySet())) {
                        String defaultValue;
                        String propertyName = (String)propertyEntry.getKey();
                        String attributeValue = (String)propertyEntry.getValue();
                        if (this.include(attributeValue, defaultValue = defaultConfig.getAttributeValue(configType, propertyName, attributeName))) {
                            LOG.debug("Including {}/{}/{} in exported blueprint, as default value and actual value differ:\n{}\nvs\n{}", new Object[]{configType, attributeName, propertyName, defaultValue, attributeValue});
                            continue;
                        }
                        LOG.debug("Omitting {}/{}/{} from exported blueprint, as it has the default value of {}", new Object[]{configType, attributeName, propertyName, attributeValue});
                        properties.remove(propertyName);
                    }
                    if (!properties.isEmpty()) continue;
                    attributes.remove(attributeName);
                }
                if (!attributes.isEmpty()) continue;
                actualConfig.getAttributes().remove(configType);
            }
            return actualConfig;
        }

        @Override
        public boolean include(String value, String defaultValue) {
            return value != null && (defaultValue == null || !Objects.equals(StringUtils.trim((String)defaultValue), StringUtils.trim((String)value)));
        }

        @Override
        public boolean include(Collection<?> collection) {
            return collection != null && !collection.isEmpty();
        }

        @Override
        public boolean include(Map<?, ?> map) {
            return map != null && !map.isEmpty();
        }
    };

    public static final BlueprintExportType DEFAULT;
    public static final String PREFIX = "blueprint";
    private static final String SEPARATOR = "_";
    private static final Logger LOG;

    public abstract Configuration filter(Configuration var1, Configuration var2);

    public abstract boolean include(String var1, String var2);

    public abstract boolean include(Collection<?> var1);

    public abstract boolean include(Map<?, ?> var1);

    public static Optional<BlueprintExportType> parse(String input) {
        if (input == null || !input.startsWith(PREFIX)) {
            return Optional.empty();
        }
        int separatorPos = input.indexOf(SEPARATOR);
        if (separatorPos == -1 || separatorPos + 1 == input.length()) {
            return Optional.of(DEFAULT);
        }
        switch (input.substring(separatorPos + 1)) {
            case "full": {
                return Optional.of(FULL);
            }
            case "minimal": {
                return Optional.of(MINIMAL);
            }
        }
        return Optional.of(DEFAULT);
    }

    static {
        DEFAULT = MINIMAL;
        LOG = LoggerFactory.getLogger(BlueprintExportType.class);
    }
}

