/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.internal.BlueprintExportType;
import id.onyx.obdp.server.controller.internal.ConfigurationTopologyException;
import id.onyx.obdp.server.controller.internal.PropertyValueTrimmingStrategyDefiner;
import id.onyx.obdp.server.controller.internal.Stack;
import id.onyx.obdp.server.controller.internal.TrimmingStrategy;
import id.onyx.obdp.server.controller.internal.UnitUpdater;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.PropertyDependencyInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.ValueAttributesInfo;
import id.onyx.obdp.server.topology.AdvisedConfiguration;
import id.onyx.obdp.server.topology.AmbariContext;
import id.onyx.obdp.server.topology.Blueprint;
import id.onyx.obdp.server.topology.Cardinality;
import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.ConfigRecommendationStrategy;
import id.onyx.obdp.server.topology.Configuration;
import id.onyx.obdp.server.topology.HostGroup;
import id.onyx.obdp.server.topology.HostGroupInfo;
import id.onyx.obdp.server.topology.InvalidTopologyException;
import id.onyx.obdp.server.topology.validators.NameNodeHaValidator;
import id.onyx.obdp.server.topology.validators.UnitValidatedProperty;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintConfigurationProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(BlueprintConfigurationProcessor.class);
    private static final String COMMAND_RETRY_ENABLED_PROPERTY_NAME = "command_retry_enabled";
    private static final String COMMANDS_TO_RETRY_PROPERTY_NAME = "commands_to_retry";
    private static final String COMMAND_RETRY_MAX_TIME_IN_SEC_PROPERTY_NAME = "command_retry_max_time_in_sec";
    private static final String COMMAND_RETRY_ENABLED_DEFAULT = "true";
    private static final String COMMANDS_TO_RETRY_DEFAULT = "INSTALL,START";
    private static final String COMMAND_RETRY_MAX_TIME_IN_SEC_DEFAULT = "600";
    private static final String CLUSTER_ENV_CONFIG_TYPE_NAME = "cluster-env";
    private static final String HBASE_SITE_HBASE_COPROCESSOR_MASTER_CLASSES = "hbase.coprocessor.master.classes";
    private static final String HBASE_SITE_HBASE_COPROCESSOR_REGION_CLASSES = "hbase.coprocessor.region.classes";
    private static final String HAWQ_SITE_HAWQ_STANDBY_ADDRESS_HOST = "hawq_standby_address_host";
    private static final String HAWQSTANDBY = "HAWQSTANDBY";
    private static final String HDFS_HA_INITIAL_CONFIG_TYPE = "cluster-env";
    private static final String HDFS_ACTIVE_NAMENODE_PROPERTY_NAME = "dfs_ha_initial_namenode_active";
    private static final String HDFS_STANDBY_NAMENODE_PROPERTY_NAME = "dfs_ha_initial_namenode_standby";
    private static final String HDFS_ACTIVE_NAMENODE_SET_PROPERTY_NAME = "dfs_ha_initial_namenode_active_set";
    private static final String HDFS_STANDBY_NAMENODE_SET_PROPERTY_NAME = "dfs_ha_initial_namenode_standby_set";
    private static final String HDFS_HA_INITIAL_CLUSTER_ID_PROPERTY_NAME = "dfs_ha_initial_cluster_id";
    private static final Set<String> HDFS_HA_INITIAL_PROPERTIES = ImmutableSet.of((Object)"dfs_ha_initial_namenode_active", (Object)"dfs_ha_initial_namenode_active_set", (Object)"dfs_ha_initial_namenode_standby", (Object)"dfs_ha_initial_namenode_standby_set", (Object)"dfs_ha_initial_cluster_id");
    public static final Map<String, Set<String>> TEMPORARY_PROPERTIES_FOR_CLUSTER_DEPLOYMENT = ImmutableMap.of((Object)"cluster-env", HDFS_HA_INITIAL_PROPERTIES);
    private static final String HADOOP_ENV_CONFIG_TYPE_NAME = "hadoop-env";
    private static final String RANGER_TAGSYNC_SITE_CONFIG_TYPE_NAME = "ranger-tagsync-site";
    private static final String LOCALHOST = "localhost";
    protected static final Map<String, Map<String, PropertyUpdater>> singleHostTopologyUpdaters = new HashMap<String, Map<String, PropertyUpdater>>();
    private static final Map<String, Map<String, PropertyUpdater>> multiHostTopologyUpdaters = new HashMap<String, Map<String, PropertyUpdater>>();
    private static final Map<String, Map<String, PropertyUpdater>> dbHostTopologyUpdaters = new HashMap<String, Map<String, PropertyUpdater>>();
    private static final Map<String, Map<String, PropertyUpdater>> mPropertyUpdaters = new HashMap<String, Map<String, PropertyUpdater>>();
    private static final Map<String, Map<String, PropertyUpdater>> nonTopologyUpdaters = new HashMap<String, Map<String, PropertyUpdater>>();
    private final Map<String, Map<String, PropertyUpdater>> removePropertyUpdaters = new HashMap<String, Map<String, PropertyUpdater>>();
    private static final Collection<Map<String, Map<String, PropertyUpdater>>> allUpdaters = new ArrayList<Map<String, Map<String, PropertyUpdater>>>();
    private static final Pattern HOSTGROUP_PORT_REGEX = Pattern.compile("%HOSTGROUP::(\\S+?)%:?(\\d+)?");
    private static final Pattern LOCALHOST_PORT_REGEX = Pattern.compile("localhost:?(\\d+)?");
    private static final Pattern PLACEHOLDER = Pattern.compile("\\{\\{.*\\}\\}");
    private static final String BIND_ALL_IP_ADDRESS = "0.0.0.0";
    private static final Set<String> configPropertiesWithHASupport = new HashSet<String>(Arrays.asList("fs.defaultFS", "hbase.rootdir", "instance.volumes", "policymgr_external_url", "xasecure.audit.destination.hdfs.dir"));
    private static final Set<Pair<String, String>> PROPERTIES_FOR_HADOOP_PROXYUSER = ImmutableSet.of((Object)Pair.of((Object)"oozie-env", (Object)"oozie_user"), (Object)Pair.of((Object)"hive-env", (Object)"hive_user"), (Object)Pair.of((Object)"hive-env", (Object)"webhcat_user"), (Object)Pair.of((Object)"hbase-env", (Object)"hbase_user"), (Object)Pair.of((Object)"falcon-env", (Object)"falcon_user"));
    private static final String HADOOP_PROXYUSER_HOSTS_FORMAT = "hadoop.proxyuser.%s.hosts";
    private static final String HADOOP_PROXYUSER_GROUPS_FORMAT = "hadoop.proxyuser.%s.groups";
    private static final PropertyFilter[] clusterUpdatePropertyFilters = new PropertyFilter[]{new DependencyEqualsFilter("hbase.security.authorization", "hbase-site", "true"), new DependencyNotEqualsFilter("hive.server2.authentication", "hive-site", "NONE"), new ConditionalPropertyFilter("hbase-site", "hbase.rpc.controllerfactory.class", "org.apache.hadoop.hbase.ipc.controller.ServerRpcControllerFactory"), new HDFSNameNodeHAFilter(), new HawqHAFilter()};
    private ClusterTopology clusterTopology;

    private PropertyFilter[] getExportPropertyFilters(Map<Long, Set<String>> authToLocalPerClusterMap) {
        return new PropertyFilter[]{new PasswordPropertyFilter(), new SimplePropertyNameExportFilter("tez.tez-ui.history-url.base", "tez-site"), new SimplePropertyNameExportFilter("admin_server_host", "kerberos-env"), new SimplePropertyNameExportFilter("kdc_hosts", "kerberos-env"), new SimplePropertyNameExportFilter("master_kdc", "kerberos-env"), new SimplePropertyNameExportFilter("realm", "kerberos-env"), new SimplePropertyNameExportFilter("kdc_type", "kerberos-env"), new SimplePropertyNameExportFilter("ldap-url", "kerberos-env"), new SimplePropertyNameExportFilter("container_dn", "kerberos-env"), new SimplePropertyNameExportFilter("domains", "krb5-conf"), new SimplePropertyNameExportFilter(HDFS_ACTIVE_NAMENODE_PROPERTY_NAME, HADOOP_ENV_CONFIG_TYPE_NAME), new SimplePropertyNameExportFilter(HDFS_STANDBY_NAMENODE_PROPERTY_NAME, HADOOP_ENV_CONFIG_TYPE_NAME), new SimplePropertyNameExportFilter(HDFS_ACTIVE_NAMENODE_SET_PROPERTY_NAME, HADOOP_ENV_CONFIG_TYPE_NAME), new SimplePropertyNameExportFilter(HDFS_STANDBY_NAMENODE_SET_PROPERTY_NAME, HADOOP_ENV_CONFIG_TYPE_NAME), new SimplePropertyNameExportFilter(HDFS_ACTIVE_NAMENODE_PROPERTY_NAME, "cluster-env"), new SimplePropertyNameExportFilter(HDFS_STANDBY_NAMENODE_PROPERTY_NAME, "cluster-env"), new SimplePropertyNameExportFilter(HDFS_ACTIVE_NAMENODE_SET_PROPERTY_NAME, "cluster-env"), new SimplePropertyNameExportFilter(HDFS_STANDBY_NAMENODE_SET_PROPERTY_NAME, "cluster-env"), new StackPropertyTypeFilter(), new KerberosAuthToLocalRulesFilter(authToLocalPerClusterMap)};
    }

    public BlueprintConfigurationProcessor(ClusterTopology clusterTopology) {
        this.clusterTopology = clusterTopology;
        this.initRemovePropertyUpdaters();
    }

    public Map<String, Map<String, PropertyUpdater>> getRemovePropertyUpdaters() {
        return this.removePropertyUpdaters;
    }

    public void initRemovePropertyUpdaters() {
        if (this.containsHostFromHostGroups("oozie-site", "oozie.service.JPAService.jdbc.url")) {
            Map<String, PropertyUpdater> oozieSiteUpdaters = singleHostTopologyUpdaters.get("oozie-site");
            Map<String, PropertyUpdater> oozieEnvUpdaters = singleHostTopologyUpdaters.get("oozie-env");
            if (oozieSiteUpdaters == null) {
                oozieSiteUpdaters = new HashMap<String, PropertyUpdater>();
            }
            if (oozieEnvUpdaters == null) {
                oozieEnvUpdaters = new HashMap<String, PropertyUpdater>();
            }
            oozieEnvUpdaters.put("oozie_existing_mysql_host", new SingleHostTopologyUpdater("OOZIE_SERVER"));
            oozieEnvUpdaters.put("oozie_existing_oracle_host", new SingleHostTopologyUpdater("OOZIE_SERVER"));
            oozieEnvUpdaters.put("oozie_existing_postgresql_host", new SingleHostTopologyUpdater("OOZIE_SERVER"));
            oozieSiteUpdaters.put("oozie.service.JPAService.jdbc.url", new SingleHostTopologyUpdater("OOZIE_SERVER"));
            singleHostTopologyUpdaters.put("oozie-env", oozieEnvUpdaters);
            singleHostTopologyUpdaters.put("oozie-site", oozieSiteUpdaters);
        } else {
            HashMap<String, OriginalValuePropertyUpdater> oozieEnvOriginalValueMap = new HashMap<String, OriginalValuePropertyUpdater>();
            HashMap<String, OriginalValuePropertyUpdater> oozieSiteOriginalValueMap = new HashMap<String, OriginalValuePropertyUpdater>();
            oozieEnvOriginalValueMap.put("oozie_existing_mysql_host", new OriginalValuePropertyUpdater());
            oozieEnvOriginalValueMap.put("oozie_existing_oracle_host", new OriginalValuePropertyUpdater());
            oozieEnvOriginalValueMap.put("oozie_existing_postgresql_host", new OriginalValuePropertyUpdater());
            oozieSiteOriginalValueMap.put("oozie.service.JPAService.jdbc.url", new OriginalValuePropertyUpdater());
            this.removePropertyUpdaters.put("oozie-env", oozieEnvOriginalValueMap);
            this.removePropertyUpdaters.put("oozie-site", oozieSiteOriginalValueMap);
        }
        HashMap<String, OriginalValuePropertyUpdater> hiveEnvOriginalValueMap = new HashMap<String, OriginalValuePropertyUpdater>();
        hiveEnvOriginalValueMap.put("hive_existing_oracle_host", new OriginalValuePropertyUpdater());
        hiveEnvOriginalValueMap.put("hive_existing_mssql_server_2_host", new OriginalValuePropertyUpdater());
        hiveEnvOriginalValueMap.put("hive_existing_mssql_server_host", new OriginalValuePropertyUpdater());
        hiveEnvOriginalValueMap.put("hive_existing_postgresql_host", new OriginalValuePropertyUpdater());
        hiveEnvOriginalValueMap.put("hive_existing_mysql_host", new OriginalValuePropertyUpdater());
        this.removePropertyUpdaters.put("hive-env", hiveEnvOriginalValueMap);
    }

    private boolean containsHostFromHostGroups(String configType, String propertyName) {
        String propertyValue = this.clusterTopology.getConfiguration().getPropertyValue(configType, propertyName);
        if (StringUtils.isEmpty((String)propertyValue)) {
            return false;
        }
        Matcher m = HostGroup.HOSTGROUP_REGEX.matcher(propertyValue);
        if (m.find()) {
            return true;
        }
        for (HostGroupInfo groupInfo : this.clusterTopology.getHostGroupInfo().values()) {
            Collection<String> hosts = groupInfo.getHostNames();
            for (String host : hosts) {
                if (!propertyValue.contains(host)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<String> getRequiredHostGroups() {
        HashSet<String> requiredHostGroups = new HashSet<String>();
        Collection<Map<String, Map<String, PropertyUpdater>>> updaters = this.createCollectionOfUpdaters();
        for (Map<String, Map<String, PropertyUpdater>> updaterMap : updaters) {
            for (Map.Entry<String, Map<String, PropertyUpdater>> entry : updaterMap.entrySet()) {
                String type = entry.getKey();
                for (Map.Entry<String, PropertyUpdater> updaterEntry : entry.getValue().entrySet()) {
                    String propertyName = updaterEntry.getKey();
                    PropertyUpdater updater = updaterEntry.getValue();
                    Map<String, Map<String, String>> clusterProps = this.clusterTopology.getConfiguration().getFullProperties();
                    Map<String, String> typeMap = clusterProps.get(type);
                    if (typeMap != null && typeMap.containsKey(propertyName) && typeMap.get(propertyName) != null) {
                        requiredHostGroups.addAll(updater.getRequiredHostGroups(propertyName, typeMap.get(propertyName), clusterProps, this.clusterTopology));
                    }
                    for (HostGroupInfo groupInfo : this.clusterTopology.getHostGroupInfo().values()) {
                        Map<String, Map<String, String>> hgConfigProps = groupInfo.getConfiguration().getProperties();
                        Map<String, String> hgTypeMap = hgConfigProps.get(type);
                        if (hgTypeMap == null || !hgTypeMap.containsKey(propertyName)) continue;
                        requiredHostGroups.addAll(updater.getRequiredHostGroups(propertyName, hgTypeMap.get(propertyName), hgConfigProps, this.clusterTopology));
                    }
                }
            }
        }
        Set<Pair<String, String>> propertiesWithUpdaters = this.getAllPropertiesWithUpdaters(updaters);
        Map<String, Map<String, String>> userDefinedClusterProperties = this.clusterTopology.getConfiguration().getFullProperties(1);
        this.addRequiredHostgroupsByDefaultUpdater(userDefinedClusterProperties, propertiesWithUpdaters, requiredHostGroups);
        this.clusterTopology.getHostGroupInfo().values().stream().forEach(hostGroup -> {
            Configuration hostGroupConfig = hostGroup.getConfiguration();
            Map<String, Map<String, String>> hostGroupConfigProps = hostGroupConfig.getFullProperties(1);
            this.addRequiredHostgroupsByDefaultUpdater(hostGroupConfigProps, propertiesWithUpdaters, requiredHostGroups);
        });
        return requiredHostGroups;
    }

    private void addRequiredHostgroupsByDefaultUpdater(Map<String, Map<String, String>> properties, Set<Pair<String, String>> propertiesWithUpdaters, Set<String> hostGroupAccumulator) {
        properties.entrySet().forEach(configTypeEntry -> {
            String configType = (String)configTypeEntry.getKey();
            ((Map)configTypeEntry.getValue()).entrySet().forEach(propertyEntry -> {
                String propertyName = (String)propertyEntry.getKey();
                String oldValue = (String)propertyEntry.getValue();
                if (!propertiesWithUpdaters.contains(Pair.of((Object)configType, (Object)propertyName))) {
                    Collection<String> requiredHostGroups = PropertyUpdater.defaultUpdater().getRequiredHostGroups(propertyName, oldValue, properties, this.clusterTopology);
                    if (!requiredHostGroups.isEmpty()) {
                        LOG.info("The following host groups are required by applying the default property updater on {}/{} property: {}", new Object[]{configType, propertyName, requiredHostGroups});
                    }
                    hostGroupAccumulator.addAll(requiredHostGroups);
                }
            });
        });
    }

    public Set<String> doUpdateForClusterCreate() throws ConfigurationTopologyException {
        HashSet<String> configTypesUpdated = new HashSet<String>();
        Configuration clusterConfig = this.clusterTopology.getConfiguration();
        this.doRecommendConfigurations(clusterConfig, configTypesUpdated);
        this.doFilterPriorToClusterUpdate(clusterConfig, configTypesUpdated);
        Set<String> propertiesMoved = clusterConfig.moveProperties(HADOOP_ENV_CONFIG_TYPE_NAME, "cluster-env", HDFS_HA_INITIAL_PROPERTIES);
        if (!propertiesMoved.isEmpty()) {
            configTypesUpdated.add(HADOOP_ENV_CONFIG_TYPE_NAME);
            configTypesUpdated.add("cluster-env");
        }
        Map<String, Map<String, String>> clusterProps = clusterConfig.getFullProperties();
        this.doGeneralPropertyUpdatesForClusterCreate(clusterConfig, clusterProps, configTypesUpdated);
        if (this.clusterTopology.isNameNodeHAEnabled()) {
            this.doNameNodeHAUpdateOnClusterCreation(clusterConfig, clusterProps, configTypesUpdated);
        }
        BlueprintConfigurationProcessor.injectDefaults(clusterConfig, configTypesUpdated, this.clusterTopology.getBlueprint().getServices());
        this.setStackToolsAndFeatures(clusterConfig, configTypesUpdated);
        this.addExcludedConfigProperties(clusterConfig, configTypesUpdated, this.clusterTopology.getBlueprint().getStack());
        this.trimProperties(clusterConfig, this.clusterTopology);
        return configTypesUpdated;
    }

    private void doNameNodeHAUpdateOnClusterCreation(Configuration clusterConfig, Map<String, Map<String, String>> clusterProps, Set<String> configTypesUpdated) throws ConfigurationTopologyException {
        String[] parsedNameServices;
        Collection<String> nnHosts = this.clusterTopology.getHostAssignmentsForComponent("NAMENODE");
        if (nnHosts.isEmpty()) {
            LOG.info("NAMENODE HA is enabled but there are no NAMENODE components in the cluster. Assuming external name nodes.");
            try {
                new NameNodeHaValidator().validateExternalNamenodeHa(this.clusterTopology);
            }
            catch (InvalidTopologyException ex) {
                throw new ConfigurationTopologyException(ex.getMessage(), ex);
            }
            return;
        }
        Map<String, String> hdfsSiteConfig = clusterConfig.getFullProperties().get("hdfs-site");
        String nameservices = hdfsSiteConfig.get("dfs.nameservices");
        String int_nameservices = hdfsSiteConfig.get("dfs.internal.nameservices");
        if (int_nameservices == null && nameservices != null) {
            clusterConfig.setProperty("hdfs-site", "dfs.internal.nameservices", nameservices);
        }
        if ((parsedNameServices = BlueprintConfigurationProcessor.parseNameServices(hdfsSiteConfig)).length == 1) {
            LOG.info("Processing a single HDFS NameService, which indicates a default HDFS NameNode HA deployment");
            if (!BlueprintConfigurationProcessor.isNameNodeHAInitialActiveNodeSet(clusterProps) && !BlueprintConfigurationProcessor.isNameNodeHAInitialStandbyNodeSet(clusterProps)) {
                if (nnHosts.size() == 1) {
                    throw new ConfigurationTopologyException("NAMENODE HA requires at least two hosts running NAMENODE but there is only one: " + nnHosts.iterator().next());
                }
                Iterator<String> nnHostIterator = nnHosts.iterator();
                clusterConfig.setProperty("cluster-env", HDFS_ACTIVE_NAMENODE_PROPERTY_NAME, nnHostIterator.next());
                clusterConfig.setProperty("cluster-env", HDFS_STANDBY_NAMENODE_PROPERTY_NAME, nnHostIterator.next());
                configTypesUpdated.add("cluster-env");
            }
        } else if (!BlueprintConfigurationProcessor.isPropertySet(clusterProps, "cluster-env", HDFS_ACTIVE_NAMENODE_SET_PROPERTY_NAME) && !BlueprintConfigurationProcessor.isPropertySet(clusterProps, "cluster-env", HDFS_STANDBY_NAMENODE_SET_PROPERTY_NAME)) {
            LOG.info("Processing multiple HDFS NameService instances, which indicates a NameNode Federation deployment");
            if (parsedNameServices.length > 1) {
                HashSet<String> activeNameNodeHostnames = new HashSet<String>();
                HashSet<String> standbyNameNodeHostnames = new HashSet<String>();
                for (String nameService : parsedNameServices) {
                    String[] nameNodes;
                    ArrayList<String> hostNames = new ArrayList<String>();
                    for (String nameNode : nameNodes = BlueprintConfigurationProcessor.parseNameNodes(nameService, hdfsSiteConfig)) {
                        String propertyName = "dfs.namenode.rpc-address." + nameService + "." + nameNode;
                        String propertyValue = hdfsSiteConfig.get(propertyName);
                        if (propertyValue == null) {
                            throw new ConfigurationTopologyException("NameNode HA property = " + propertyName + " is not found in the cluster config.  This indicates an error in configuration for HA/Federated clusters.  Please recheck the HDFS configuration and try this deployment again");
                        }
                        String hostName = propertyValue.split(":")[0];
                        hostNames.add(hostName);
                    }
                    if (hostNames.size() < 2) {
                        throw new ConfigurationTopologyException("NAMENODE HA for nameservice = " + nameService + " requires at least 2 hosts running NAMENODE but there are: " + hostNames.size() + " Hosts: " + hostNames);
                    }
                    activeNameNodeHostnames.add((String)hostNames.get(0));
                    standbyNameNodeHostnames.add((String)hostNames.get(1));
                }
                if (!activeNameNodeHostnames.isEmpty() && !standbyNameNodeHostnames.isEmpty()) {
                    clusterConfig.setProperty("cluster-env", HDFS_ACTIVE_NAMENODE_SET_PROPERTY_NAME, String.join((CharSequence)",", activeNameNodeHostnames));
                    clusterConfig.setProperty("cluster-env", HDFS_STANDBY_NAMENODE_SET_PROPERTY_NAME, String.join((CharSequence)",", standbyNameNodeHostnames));
                    if (!BlueprintConfigurationProcessor.isPropertySet(clusterProps, "cluster-env", HDFS_HA_INITIAL_CLUSTER_ID_PROPERTY_NAME)) {
                        clusterConfig.setProperty("cluster-env", HDFS_HA_INITIAL_CLUSTER_ID_PROPERTY_NAME, this.getClusterName());
                    }
                    configTypesUpdated.add("cluster-env");
                } else {
                    LOG.warn("Error in processing the set of active/standby namenodes in this federated cluster, please check hdfs-site configuration");
                }
                this.doTagSyncSiteUpdateForNamenodeNFederationEnabledOnClusterCreation(clusterConfig, clusterProps, configTypesUpdated);
            }
        }
    }

    private void doTagSyncSiteUpdateForNamenodeNFederationEnabledOnClusterCreation(Configuration clusterConfig, Map<String, Map<String, String>> clusterProps, Set<String> configTypesUpdated) throws ConfigurationTopologyException {
        boolean isAtlasServerToBeInstalled;
        Map<String, String> hdfsSiteConfig = clusterConfig.getFullProperties().get("hdfs-site");
        String[] parsedNameServices = BlueprintConfigurationProcessor.parseNameServices(hdfsSiteConfig);
        String clusterName = this.getClusterName();
        boolean isRangerHDFSPluginEnabled = false;
        Object rangerHDFSPluginServiceName = "";
        String atlasServerComponentName = "ATLAS_SERVER";
        String rangerAdminComponentName = "RANGER_ADMIN";
        String rangerTagsyncComponentName = "RANGER_TAGSYNC";
        boolean isRangerAdminToBeInstalled = this.clusterTopology.getHostGroupsForComponent(rangerAdminComponentName).size() >= 1;
        boolean isRangerTagsyncToBeInstalled = this.clusterTopology.getHostGroupsForComponent(rangerTagsyncComponentName).size() >= 1;
        boolean bl = isAtlasServerToBeInstalled = this.clusterTopology.getHostGroupsForComponent(atlasServerComponentName).size() >= 1;
        if (isRangerAdminToBeInstalled) {
            Map<String, String> rangerHDFSPluginProperties = clusterProps.get("ranger-hdfs-plugin-properties");
            String rangerHDFSPluginEnabledValue = rangerHDFSPluginProperties.getOrDefault("ranger-hdfs-plugin-enabled", "No");
            isRangerHDFSPluginEnabled = "yes".equalsIgnoreCase(rangerHDFSPluginEnabledValue);
            Map<String, String> rangerHDFSSecurityConfig = clusterProps.get("ranger-hdfs-security");
            rangerHDFSPluginServiceName = rangerHDFSSecurityConfig.get("ranger.plugin.hdfs.service.name");
        }
        boolean isTagsyncPropertyConfigurationRequired = isRangerAdminToBeInstalled && isRangerTagsyncToBeInstalled && isAtlasServerToBeInstalled && isRangerHDFSPluginEnabled;
        Map<String, String> coreSiteConfig = clusterProps.get("core-site");
        String fsDefaultFSValue = coreSiteConfig.get("fs.defaultFS");
        String nameServiceInFsDefaultFSConfig = "";
        if (isTagsyncPropertyConfigurationRequired && "{{repo_name}}".equalsIgnoreCase((String)rangerHDFSPluginServiceName)) {
            rangerHDFSPluginServiceName = clusterName + "_hadoop";
        }
        if (parsedNameServices.length > 1 && isTagsyncPropertyConfigurationRequired) {
            for (String nameService : parsedNameServices) {
                String tagsyncNameserviceMappingProperty = "ranger.tagsync.atlas.hdfs.instance." + clusterName + ".nameservice." + nameService + ".ranger.service";
                String updatedRangerHDFSPluginServiceName = (String)rangerHDFSPluginServiceName + "_" + nameService;
                clusterConfig.setProperty(RANGER_TAGSYNC_SITE_CONFIG_TYPE_NAME, tagsyncNameserviceMappingProperty, updatedRangerHDFSPluginServiceName);
                try {
                    URI fsDefaultFSURI = new URI(fsDefaultFSValue);
                    String fsDefaultFSNameService = fsDefaultFSURI.getHost();
                    if (!fsDefaultFSNameService.contains(nameService)) continue;
                    nameServiceInFsDefaultFSConfig = nameService;
                }
                catch (URISyntaxException e) {
                    LOG.error("Error occurred while parsing the defaultFS URI.", (Throwable)e);
                }
            }
            String rangerTagsyncAtlasNNServiceMappingProperty = "ranger.tagsync.atlas.hdfs.instance." + clusterName + ".ranger.service";
            String rangerTagsyncAtlasNNServiceName = (String)rangerHDFSPluginServiceName + "_" + nameServiceInFsDefaultFSConfig;
            clusterConfig.setProperty(RANGER_TAGSYNC_SITE_CONFIG_TYPE_NAME, rangerTagsyncAtlasNNServiceMappingProperty, rangerTagsyncAtlasNNServiceName);
            configTypesUpdated.add(RANGER_TAGSYNC_SITE_CONFIG_TYPE_NAME);
        }
    }

    private void doGeneralPropertyUpdatesForClusterCreate(Configuration clusterConfig, Map<String, Map<String, String>> clusterProps, Set<String> configTypesUpdated) {
        Collection<Map<String, Map<String, PropertyUpdater>>> updaters = this.createCollectionOfUpdaters();
        for (Map<String, Map<String, PropertyUpdater>> updaterMap : updaters) {
            for (Map.Entry<String, Map<String, PropertyUpdater>> entry : updaterMap.entrySet()) {
                String configType = entry.getKey();
                for (Map.Entry<String, PropertyUpdater> updaterEntry : entry.getValue().entrySet()) {
                    String originalValue;
                    String updatedValue;
                    String propertyName = updaterEntry.getKey();
                    PropertyUpdater updater = updaterEntry.getValue();
                    Map<String, String> typeMap = clusterProps.get(configType);
                    if (typeMap != null && typeMap.containsKey(propertyName) && typeMap.get(propertyName) != null && null == (updatedValue = this.updateValue(configType, propertyName, originalValue = typeMap.get(propertyName), updater, clusterProps, clusterConfig, configTypesUpdated, true))) continue;
                    for (HostGroupInfo groupInfo : this.clusterTopology.getHostGroupInfo().values()) {
                        Configuration hgConfig = groupInfo.getConfiguration();
                        Map<String, Map<String, String>> hgConfigProps = hgConfig.getFullProperties(1);
                        Map<String, String> hgTypeMap = hgConfigProps.get(configType);
                        if (hgTypeMap == null || !hgTypeMap.containsKey(propertyName)) continue;
                        String originalValue2 = hgTypeMap.get(propertyName);
                        this.updateValue(configType, propertyName, originalValue2, updater, hgConfigProps, hgConfig, configTypesUpdated, true);
                    }
                }
            }
        }
        Set<Pair<String, String>> propertiesWithUpdaters = this.getAllPropertiesWithUpdaters(updaters);
        this.applyDefaultUpdater(clusterConfig, clusterConfig.getFullProperties(1), configTypesUpdated, propertiesWithUpdaters);
        this.clusterTopology.getHostGroupInfo().values().stream().forEach(hostGroup -> {
            Configuration hostGroupConfig = hostGroup.getConfiguration();
            Map<String, Map<String, String>> hostGroupConfigProps = hostGroupConfig.getFullProperties(1);
            this.applyDefaultUpdater(hostGroupConfig, hostGroupConfigProps, configTypesUpdated, propertiesWithUpdaters);
        });
    }

    private Set<Pair<String, String>> getAllPropertiesWithUpdaters(Collection<Map<String, Map<String, PropertyUpdater>>> updaters) {
        return updaters.stream().flatMap(map -> map.entrySet().stream()).flatMap(entry -> {
            String configType = (String)entry.getKey();
            return ((Map)entry.getValue()).keySet().stream().map(propertyName -> Pair.of((Object)configType, (Object)propertyName));
        }).collect(Collectors.toSet());
    }

    private void applyDefaultUpdater(Configuration configuration, Map<String, Map<String, String>> properties, Set<String> configTypesUpdated, Set<Pair<String, String>> propertiesWithUpdaters) {
        properties.entrySet().forEach(configTypeEntry -> {
            String configType = (String)configTypeEntry.getKey();
            ((Map)configTypeEntry.getValue()).entrySet().forEach(propertyEntry -> {
                String newValue;
                String oldValue;
                String propertyName = (String)propertyEntry.getKey();
                if (!propertiesWithUpdaters.contains(Pair.of((Object)configType, (Object)propertyName)) && !Objects.equals(oldValue = (String)propertyEntry.getValue(), newValue = this.updateValue(configType, propertyName, oldValue, PropertyUpdater.defaultUpdater(), properties, configuration, configTypesUpdated, false))) {
                    LOG.info("Property {}/{} was updated by the default updater from [{}] to [{}]", new Object[]{configType, propertyName, oldValue, newValue});
                }
            });
        });
    }

    private String updateValue(String configType, String propertyName, String oldValue, PropertyUpdater updater, Map<String, Map<String, String>> allProps, Configuration configuration, Set<String> configTypesUpdated, boolean alwaysUpdateConfig) {
        String newValue = updater.updateForClusterCreate(propertyName, oldValue, allProps, this.clusterTopology);
        if (null != newValue) {
            if (!newValue.equals(oldValue)) {
                configTypesUpdated.add(configType);
            }
            if (!newValue.equals(oldValue) || alwaysUpdateConfig) {
                configuration.setProperty(configType, propertyName, newValue);
            }
        }
        return newValue;
    }

    private String getClusterName() throws ConfigurationTopologyException {
        String clusterNameToReturn = null;
        try {
            clusterNameToReturn = this.clusterTopology.getAmbariContext().getClusterName(this.clusterTopology.getClusterId());
        }
        catch (OBDPException e) {
            throw new ConfigurationTopologyException("Cluster name could not obtained, this may indicate a deployment or configuration error.", e);
        }
        if (clusterNameToReturn == null) {
            throw new ConfigurationTopologyException("Cluster name could not obtained, this may indicate a deployment or configuration error.");
        }
        return clusterNameToReturn;
    }

    private void trimProperties(Configuration clusterConfig, ClusterTopology clusterTopology) {
        Blueprint blueprint = clusterTopology.getBlueprint();
        Stack stack = blueprint.getStack();
        Map<String, Map<String, String>> configTypes = clusterConfig.getFullProperties();
        for (String configType : configTypes.keySet()) {
            Map<String, String> properties = configTypes.get(configType);
            for (String propertyName : properties.keySet()) {
                this.trimPropertyValue(clusterConfig, stack, configType, properties, propertyName);
            }
        }
    }

    private void trimPropertyValue(Configuration clusterConfig, Stack stack, String configType, Map<String, String> properties, String propertyName) {
        String oldValue;
        TrimmingStrategy trimmingStrategy;
        String newValue;
        if (propertyName != null && properties.get(propertyName) != null && !(newValue = (trimmingStrategy = PropertyValueTrimmingStrategyDefiner.defineTrimmingStrategy(stack, propertyName, configType)).trim(oldValue = properties.get(propertyName))).equals(oldValue)) {
            LOG.debug("Changing value for config {} property {} from [{}] to [{}]", new Object[]{configType, propertyName, oldValue, newValue});
            clusterConfig.setProperty(configType, propertyName, newValue);
        }
    }

    private static boolean shouldPropertyBeStoredWithDefault(String propertyName) {
        return !StringUtils.isBlank((String)propertyName) && (HBASE_SITE_HBASE_COPROCESSOR_MASTER_CLASSES.equals(propertyName) || HBASE_SITE_HBASE_COPROCESSOR_REGION_CLASSES.equals(propertyName));
    }

    public void doUpdateForBlueprintExport(BlueprintExportType exportType) {
        if (this.clusterTopology.isNameNodeHAEnabled()) {
            this.doNameNodeHAUpdate();
        }
        if (this.clusterTopology.isYarnResourceManagerHAEnabled()) {
            this.doYarnResourceManagerHAUpdate();
        }
        if (BlueprintConfigurationProcessor.isOozieServerHAEnabled(this.clusterTopology.getConfiguration().getFullProperties())) {
            this.doOozieServerHAUpdate();
        }
        ArrayList<Configuration> allConfigs = new ArrayList<Configuration>();
        Configuration clusterConfig = this.clusterTopology.getConfiguration();
        allConfigs.add(clusterConfig);
        for (HostGroupInfo groupInfo : this.clusterTopology.getHostGroupInfo().values()) {
            Configuration hgConfiguration = groupInfo.getConfiguration();
            if (hgConfiguration.getFullProperties(1).isEmpty()) continue;
            allConfigs.add(new Configuration(hgConfiguration.getProperties(), null, new Configuration(hgConfiguration.getParentConfiguration().getProperties(), null)));
        }
        for (Configuration configuration : allConfigs) {
            this.doSingleHostExportUpdate(singleHostTopologyUpdaters, configuration);
            this.doSingleHostExportUpdate(dbHostTopologyUpdaters, configuration);
            this.doMultiHostExportUpdate(multiHostTopologyUpdaters, configuration);
            this.doNonTopologyUpdate(nonTopologyUpdaters, configuration);
            this.doRemovePropertyExport(this.removePropertyUpdaters, configuration);
            this.doFilterPriorToExport(configuration);
        }
        Blueprint blueprint = this.clusterTopology.getBlueprint();
        this.applyTypeSpecificFilter(exportType, clusterConfig, blueprint.getStack().getConfiguration(), blueprint.getServices());
    }

    @VisibleForTesting
    void applyTypeSpecificFilter(BlueprintExportType exportType, Configuration clusterConfig, Configuration stackConfig, Collection<String> services) {
        if (exportType == BlueprintExportType.MINIMAL) {
            this.doNonTopologyUpdate(mPropertyUpdaters, clusterConfig);
        }
        BlueprintConfigurationProcessor.injectDefaults(stackConfig, new HashSet<String>(), services);
        exportType.filter(clusterConfig, stackConfig);
    }

    private void doFilterPriorToExport(Configuration configuration) {
        Map<String, Map<String, String>> properties = configuration.getFullProperties();
        HashMap<Long, Set<String>> authToLocalPerClusterMap = null;
        try {
            String clusterName = this.clusterTopology.getAmbariContext().getClusterName(this.clusterTopology.getClusterId());
            this.clusterTopology.getAmbariContext();
            Cluster cluster = AmbariContext.getController().getClusters().getCluster(clusterName);
            authToLocalPerClusterMap = new HashMap<Long, Set<String>>();
            Long l = (long)this.clusterTopology.getClusterId();
            this.clusterTopology.getAmbariContext();
            authToLocalPerClusterMap.put(l, AmbariContext.getController().getKerberosHelper().getKerberosDescriptor(cluster, false).getAllAuthToLocalProperties());
        }
        catch (OBDPException e) {
            LOG.error("Error while getting authToLocal properties. ", (Throwable)e);
        }
        PropertyFilter[] exportPropertyFilters = this.getExportPropertyFilters(authToLocalPerClusterMap);
        for (Map.Entry<String, Map<String, String>> configEntry : properties.entrySet()) {
            String type = configEntry.getKey();
            try {
                this.clusterTopology.getBlueprint().getStack().getServiceForConfigType(type);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.error(String.format("Error encountered while trying to obtain the service name for config type [%s]. ", type) + "Further processing on this config type will be skipped. " + "This usually means that a service's definitions have been manually removed from the Ambari stack definitions. " + "If the stack definitions have not been changed manually, this may indicate a stack definition error in Ambari. ", (Throwable)illegalArgumentException);
                continue;
            }
            Map<String, String> typeProperties = configEntry.getValue();
            for (Map.Entry<String, String> propertyEntry : typeProperties.entrySet()) {
                String propertyValue;
                String propertyName = propertyEntry.getKey();
                if (!this.shouldPropertyBeExcludedForBlueprintExport(propertyName, propertyValue = propertyEntry.getValue(), type, this.clusterTopology, exportPropertyFilters)) continue;
                configuration.removeProperty(type, propertyName);
            }
        }
    }

    private void doFilterPriorToClusterUpdate(Configuration configuration, Set<String> configTypesUpdated) {
        Map<String, Map<String, String>> properties = configuration.getFullProperties();
        for (Map.Entry<String, Map<String, String>> configEntry : properties.entrySet()) {
            String configType = configEntry.getKey();
            Map<String, String> configPropertiesPerType = configEntry.getValue();
            for (Map.Entry<String, String> propertyEntry : configPropertiesPerType.entrySet()) {
                String propName = propertyEntry.getKey();
                if (!BlueprintConfigurationProcessor.shouldPropertyBeExcludedForClusterUpdate(propName, propertyEntry.getValue(), configType, this.clusterTopology)) continue;
                configuration.removeProperty(configType, propName);
                configTypesUpdated.add(configType);
            }
        }
    }

    private void doRecommendConfigurations(Configuration configuration, Set<String> configTypesUpdated) {
        ConfigRecommendationStrategy configRecommendationStrategy = this.clusterTopology.getConfigRecommendationStrategy();
        Map<String, AdvisedConfiguration> advisedConfigurations = this.clusterTopology.getAdvisedConfigurations();
        LOG.info("Config recommendation strategy being used is {})", (Object)configRecommendationStrategy);
        if (ConfigRecommendationStrategy.ONLY_STACK_DEFAULTS_APPLY.equals((Object)configRecommendationStrategy)) {
            LOG.info("Filter out recommended configurations. Keep only the stack defaults.");
            this.doFilterStackDefaults(advisedConfigurations);
        }
        if (!ConfigRecommendationStrategy.NEVER_APPLY.equals((Object)configRecommendationStrategy)) {
            for (Map.Entry<String, AdvisedConfiguration> advConfEntry : advisedConfigurations.entrySet()) {
                String configType = advConfEntry.getKey();
                AdvisedConfiguration advisedConfig = advConfEntry.getValue();
                LOG.info("Update '{}' configurations with recommended configurations provided by the stack advisor.", (Object)configType);
                if (advisedConfig.getProperties() != null) {
                    this.doReplaceProperties(configuration, configType, advisedConfig, configTypesUpdated);
                }
                if (advisedConfig.getPropertyValueAttributes() == null) continue;
                this.doRemovePropertiesIfNeeded(configuration, configType, advisedConfig, configTypesUpdated);
            }
        } else {
            LOG.info("No recommended configurations are applied. (strategy: {})", (Object)ConfigRecommendationStrategy.NEVER_APPLY);
        }
    }

    private void doFilterStackDefaults(Map<String, AdvisedConfiguration> advisedConfigurations) {
        Blueprint blueprint = this.clusterTopology.getBlueprint();
        Configuration stackDefaults = blueprint.getStack().getConfiguration(blueprint.getServices());
        Map<String, Map<String, String>> stackDefaultProps = stackDefaults.getProperties();
        for (Map.Entry<String, AdvisedConfiguration> adConfEntry : advisedConfigurations.entrySet()) {
            AdvisedConfiguration advisedConfiguration = adConfEntry.getValue();
            if (stackDefaultProps.containsKey(adConfEntry.getKey())) {
                Map<String, String> defaultProps = stackDefaultProps.get(adConfEntry.getKey());
                if (advisedConfiguration.getProperties() != null) {
                    Map outFilteredProps = Maps.filterKeys(advisedConfiguration.getProperties(), (Predicate)Predicates.not((Predicate)Predicates.in(defaultProps.keySet())));
                    advisedConfiguration.getProperties().keySet().removeAll(Sets.newCopyOnWriteArraySet(outFilteredProps.keySet()));
                }
                if (advisedConfiguration.getPropertyValueAttributes() == null) continue;
                Map outFilteredValueAttrs = Maps.filterKeys(advisedConfiguration.getPropertyValueAttributes(), (Predicate)Predicates.not((Predicate)Predicates.in(defaultProps.keySet())));
                advisedConfiguration.getPropertyValueAttributes().keySet().removeAll(Sets.newCopyOnWriteArraySet(outFilteredValueAttrs.keySet()));
                continue;
            }
            advisedConfiguration.getProperties().clear();
        }
    }

    private void doReplaceProperties(Configuration configuration, String configType, AdvisedConfiguration advisedConfig, Set<String> configTypesUpdated) {
        for (Map.Entry<String, String> propEntry : advisedConfig.getProperties().entrySet()) {
            String originalValue = configuration.getPropertyValue(configType, propEntry.getKey());
            configuration.setProperty(configType, propEntry.getKey(), propEntry.getValue());
            if (propEntry.getValue().equals(originalValue)) continue;
            configTypesUpdated.add(configType);
        }
    }

    private void doRemovePropertiesIfNeeded(Configuration configuration, String configType, AdvisedConfiguration advisedConfig, Set<String> configTypesUpdated) {
        if (advisedConfig.getPropertyValueAttributes() != null) {
            for (Map.Entry<String, ValueAttributesInfo> valueAttrEntry : advisedConfig.getPropertyValueAttributes().entrySet()) {
                if (!COMMAND_RETRY_ENABLED_DEFAULT.equalsIgnoreCase(valueAttrEntry.getValue().getDelete()) || null == configuration.removeProperty(configType, valueAttrEntry.getKey())) continue;
                configTypesUpdated.add(configType);
            }
        }
    }

    Collection<Map<String, Map<String, PropertyUpdater>>> createCollectionOfUpdaters() {
        Collection<Map<String, Map<String, PropertyUpdater>>> updaters = allUpdaters;
        if (this.clusterTopology.isNameNodeHAEnabled()) {
            updaters = this.addNameNodeHAUpdaters(updaters);
        }
        if (this.clusterTopology.isYarnResourceManagerHAEnabled()) {
            updaters = this.addYarnResourceManagerHAUpdaters(updaters);
        }
        if (BlueprintConfigurationProcessor.isOozieServerHAEnabled(this.clusterTopology.getConfiguration().getFullProperties())) {
            updaters = this.addOozieServerHAUpdaters(updaters);
        }
        return updaters;
    }

    private Collection<Map<String, Map<String, PropertyUpdater>>> addNameNodeHAUpdaters(Collection<Map<String, Map<String, PropertyUpdater>>> updaters) {
        LinkedList<Map<String, Map<String, PropertyUpdater>>> highAvailabilityUpdaters = new LinkedList<Map<String, Map<String, PropertyUpdater>>>();
        highAvailabilityUpdaters.addAll(updaters);
        highAvailabilityUpdaters.add(this.createMapOfNameNodeHAUpdaters());
        return highAvailabilityUpdaters;
    }

    private Collection<Map<String, Map<String, PropertyUpdater>>> addYarnResourceManagerHAUpdaters(Collection<Map<String, Map<String, PropertyUpdater>>> updaters) {
        LinkedList<Map<String, Map<String, PropertyUpdater>>> highAvailabilityUpdaters = new LinkedList<Map<String, Map<String, PropertyUpdater>>>();
        highAvailabilityUpdaters.addAll(updaters);
        highAvailabilityUpdaters.add(this.createMapOfYarnResourceManagerHAUpdaters());
        return highAvailabilityUpdaters;
    }

    private Collection<Map<String, Map<String, PropertyUpdater>>> addOozieServerHAUpdaters(Collection<Map<String, Map<String, PropertyUpdater>>> updaters) {
        LinkedList<Map<String, Map<String, PropertyUpdater>>> highAvailabilityUpdaters = new LinkedList<Map<String, Map<String, PropertyUpdater>>>();
        highAvailabilityUpdaters.addAll(updaters);
        highAvailabilityUpdaters.add(this.createMapOfOozieServerHAUpdaters());
        return highAvailabilityUpdaters;
    }

    private void doRemovePropertyExport(Map<String, Map<String, PropertyUpdater>> updaters, Configuration configuration) {
        Map<String, Map<String, String>> properties = configuration.getProperties();
        for (Map.Entry<String, Map<String, PropertyUpdater>> entry : updaters.entrySet()) {
            String type = entry.getKey();
            for (String propertyName : entry.getValue().keySet()) {
                Map<String, String> typeProperties = properties.get(type);
                if (typeProperties == null || !typeProperties.containsKey(propertyName)) continue;
                configuration.removeProperty(type, propertyName);
            }
        }
    }

    public void doNameNodeHAUpdate() {
        Map<String, Map<String, PropertyUpdater>> highAvailabilityUpdaters = this.createMapOfNameNodeHAUpdaters();
        if (highAvailabilityUpdaters.get("hdfs-site").size() > 0) {
            this.doSingleHostExportUpdate(highAvailabilityUpdaters, this.clusterTopology.getConfiguration());
        }
    }

    public void doYarnResourceManagerHAUpdate() {
        Map<String, Map<String, PropertyUpdater>> highAvailabilityUpdaters = this.createMapOfYarnResourceManagerHAUpdaters();
        if (highAvailabilityUpdaters.get("yarn-site").size() > 0) {
            this.doSingleHostExportUpdate(highAvailabilityUpdaters, this.clusterTopology.getConfiguration());
        }
    }

    public void doOozieServerHAUpdate() {
        Map<String, Map<String, PropertyUpdater>> highAvailabilityUpdaters = this.createMapOfOozieServerHAUpdaters();
        if (highAvailabilityUpdaters.get("oozie-site").size() > 0) {
            this.doMultiHostExportUpdate(highAvailabilityUpdaters, this.clusterTopology.getConfiguration());
        }
    }

    private Map<String, Map<String, PropertyUpdater>> createMapOfNameNodeHAUpdaters() {
        HashMap<String, Map<String, PropertyUpdater>> highAvailabilityUpdaters = new HashMap<String, Map<String, PropertyUpdater>>();
        HashMap<CallSite, PropertyUpdater> hdfsSiteUpdatersForAvailability = new HashMap<CallSite, PropertyUpdater>();
        highAvailabilityUpdaters.put("hdfs-site", hdfsSiteUpdatersForAvailability);
        Map<String, String> hdfsSiteConfig = this.clusterTopology.getConfiguration().getFullProperties().get("hdfs-site");
        for (String nameService : BlueprintConfigurationProcessor.parseNameServices(hdfsSiteConfig)) {
            String journalEditsDirPropertyName = "dfs.namenode.shared.edits.dir." + nameService;
            hdfsSiteUpdatersForAvailability.put((CallSite)((Object)journalEditsDirPropertyName), new MultipleHostTopologyUpdater("JOURNALNODE", Character.valueOf(';'), false, false, true));
            for (String nameNode : BlueprintConfigurationProcessor.parseNameNodes(nameService, hdfsSiteConfig)) {
                String httpsPropertyName = "dfs.namenode.https-address." + nameService + "." + nameNode;
                hdfsSiteUpdatersForAvailability.put((CallSite)((Object)httpsPropertyName), new SingleHostTopologyUpdater("NAMENODE"));
                String httpPropertyName = "dfs.namenode.http-address." + nameService + "." + nameNode;
                hdfsSiteUpdatersForAvailability.put((CallSite)((Object)httpPropertyName), new SingleHostTopologyUpdater("NAMENODE"));
                String rpcPropertyName = "dfs.namenode.rpc-address." + nameService + "." + nameNode;
                hdfsSiteUpdatersForAvailability.put((CallSite)((Object)rpcPropertyName), new SingleHostTopologyUpdater("NAMENODE"));
                String serviceRpcPropertyName = "dfs.namenode.servicerpc-address." + nameService + "." + nameNode;
                hdfsSiteUpdatersForAvailability.put((CallSite)((Object)serviceRpcPropertyName), new SingleHostTopologyUpdater("NAMENODE"));
            }
        }
        return highAvailabilityUpdaters;
    }

    private Map<String, Map<String, PropertyUpdater>> createMapOfYarnResourceManagerHAUpdaters() {
        HashMap<String, Map<String, PropertyUpdater>> highAvailabilityUpdaters = new HashMap<String, Map<String, PropertyUpdater>>();
        HashMap<CallSite, SingleHostTopologyUpdater> yarnSiteUpdatersForAvailability = new HashMap<CallSite, SingleHostTopologyUpdater>();
        highAvailabilityUpdaters.put("yarn-site", yarnSiteUpdatersForAvailability);
        Map<String, String> yarnSiteConfig = this.clusterTopology.getConfiguration().getFullProperties().get("yarn-site");
        for (String resourceManager : BlueprintConfigurationProcessor.parseResourceManagers(yarnSiteConfig)) {
            SingleHostTopologyUpdater updater = new SingleHostTopologyUpdater("RESOURCEMANAGER");
            yarnSiteUpdatersForAvailability.put((CallSite)((Object)("yarn.resourcemanager.hostname." + resourceManager)), updater);
            yarnSiteUpdatersForAvailability.put((CallSite)((Object)("yarn.resourcemanager.address." + resourceManager)), updater);
            yarnSiteUpdatersForAvailability.put((CallSite)((Object)("yarn.resourcemanager.admin.address." + resourceManager)), updater);
            yarnSiteUpdatersForAvailability.put((CallSite)((Object)("yarn.resourcemanager.resource-tracker.address." + resourceManager)), updater);
            yarnSiteUpdatersForAvailability.put((CallSite)((Object)("yarn.resourcemanager.scheduler.address." + resourceManager)), updater);
            yarnSiteUpdatersForAvailability.put((CallSite)((Object)("yarn.resourcemanager.webapp.address." + resourceManager)), updater);
            yarnSiteUpdatersForAvailability.put((CallSite)((Object)("yarn.resourcemanager.webapp.https.address." + resourceManager)), updater);
        }
        return highAvailabilityUpdaters;
    }

    private Map<String, Map<String, PropertyUpdater>> createMapOfOozieServerHAUpdaters() {
        HashMap<String, Map<String, PropertyUpdater>> highAvailabilityUpdaters = new HashMap<String, Map<String, PropertyUpdater>>();
        HashMap<String, MultipleHostTopologyUpdater> oozieSiteUpdatersForAvailability = new HashMap<String, MultipleHostTopologyUpdater>();
        highAvailabilityUpdaters.put("oozie-site", oozieSiteUpdatersForAvailability);
        oozieSiteUpdatersForAvailability.put("oozie.zookeeper.connection.string", new MultipleHostTopologyUpdater("ZOOKEEPER_SERVER"));
        return highAvailabilityUpdaters;
    }

    static boolean isOozieServerHAEnabled(Map<String, Map<String, String>> configProperties) {
        return configProperties.containsKey("oozie-site") && configProperties.get("oozie-site").containsKey("oozie.services.ext") && configProperties.get("oozie-site").get("oozie.services.ext").contains("org.apache.oozie.service.ZKLocksService");
    }

    static boolean isHiveServerHAEnabled(Map<String, Map<String, String>> configProperties) {
        return configProperties.containsKey("hive-site") && configProperties.get("hive-site").containsKey("hive.server2.support.dynamic.service.discovery") && configProperties.get("hive-site").get("hive.server2.support.dynamic.service.discovery").equals(COMMAND_RETRY_ENABLED_DEFAULT);
    }

    static boolean isNameNodeHAInitialActiveNodeSet(Map<String, Map<String, String>> configProperties) {
        return configProperties.containsKey("cluster-env") && configProperties.get("cluster-env").containsKey(HDFS_ACTIVE_NAMENODE_PROPERTY_NAME);
    }

    static boolean isNameNodeHAInitialStandbyNodeSet(Map<String, Map<String, String>> configProperties) {
        return configProperties.containsKey("cluster-env") && configProperties.get("cluster-env").containsKey(HDFS_STANDBY_NAMENODE_PROPERTY_NAME);
    }

    static boolean isPropertySet(Map<String, Map<String, String>> configProperties, String configType, String propertyName) {
        return configProperties.containsKey(configType) && configProperties.get(configType).containsKey(propertyName);
    }

    static String[] parseNameServices(Map<String, String> properties) {
        String nameServices = properties.get("dfs.internal.nameservices");
        if (nameServices == null) {
            nameServices = properties.get("dfs.nameservices");
        }
        return BlueprintConfigurationProcessor.splitAndTrimStrings(nameServices);
    }

    static String[] parseResourceManagers(Map<String, String> properties) {
        String resourceManagerNames = properties.get("yarn.resourcemanager.ha.rm-ids");
        return BlueprintConfigurationProcessor.splitAndTrimStrings(resourceManagerNames);
    }

    static String[] parseNameNodes(String nameService, Map<String, String> properties) {
        String nameNodes = properties.get("dfs.ha.namenodes." + nameService);
        return BlueprintConfigurationProcessor.splitAndTrimStrings(nameNodes);
    }

    private boolean shouldPropertyBeExcludedForBlueprintExport(String propertyName, String propertyValue, String propertyType, ClusterTopology topology, PropertyFilter[] exportPropertyFilters) {
        for (PropertyFilter filter : exportPropertyFilters) {
            if (filter.isPropertyIncluded(propertyName, propertyValue, propertyType, topology)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldPropertyBeExcludedForClusterUpdate(String propertyName, String propertyValue, String propertyType, ClusterTopology topology) {
        for (PropertyFilter filter : clusterUpdatePropertyFilters) {
            try {
                if (filter.isPropertyIncluded(propertyName, propertyValue, propertyType, topology) || BlueprintConfigurationProcessor.shouldPropertyBeStoredWithDefault(propertyName)) continue;
                return true;
            }
            catch (Throwable throwable) {
                LOG.warn("Error occurred while attempting to process the property '" + propertyName + "' with a filter.  This may indicate a config error.", throwable);
            }
        }
        return false;
    }

    private void doSingleHostExportUpdate(Map<String, Map<String, PropertyUpdater>> updaters, Configuration configuration) {
        Map<String, Map<String, String>> properties = configuration.getFullProperties();
        for (Map.Entry<String, Map<String, PropertyUpdater>> entry : updaters.entrySet()) {
            String type = entry.getKey();
            Map<String, PropertyUpdater> propertyNameUpdaters = entry.getValue();
            for (Map.Entry<String, PropertyUpdater> propertyNameUpdater : propertyNameUpdaters.entrySet()) {
                String propertyName = propertyNameUpdater.getKey();
                PropertyUpdater propertyUpdater = propertyNameUpdater.getValue();
                boolean matchedHost = false;
                Map<String, String> typeProperties = properties.get(type);
                if (typeProperties == null || !typeProperties.containsKey(propertyName)) continue;
                String propValue = typeProperties.get(propertyName);
                String replacedValue = propertyUpdater.updateForBlueprintExport(propertyName, propValue, properties, this.clusterTopology);
                if (!replacedValue.equals(propValue)) {
                    matchedHost = true;
                    configuration.setProperty(type, propertyName, replacedValue);
                }
                if (matchedHost || BlueprintConfigurationProcessor.isNameServiceProperty(propertyName) || BlueprintConfigurationProcessor.isDatabaseConnectionURL(propertyName) || BlueprintConfigurationProcessor.isSpecialNetworkAddress(propValue) || BlueprintConfigurationProcessor.isUndefinedAddress(propValue) || BlueprintConfigurationProcessor.isPlaceholder(propValue)) continue;
                configuration.removeProperty(type, propertyName);
            }
        }
    }

    private static boolean isPlaceholder(String propertyValue) {
        return PLACEHOLDER.matcher(propertyValue).find();
    }

    private static boolean isNameServiceProperty(String propertyName) {
        return configPropertiesWithHASupport.contains(propertyName);
    }

    private static boolean isDatabaseConnectionURL(String propertyName) {
        return propertyName.equals("javax.jdo.option.ConnectionURL");
    }

    private static boolean isSpecialNetworkAddress(String propertyValue) {
        return propertyValue.contains(BIND_ALL_IP_ADDRESS);
    }

    private static boolean isUndefinedAddress(String propertyValue) {
        return propertyValue.contains("undefined");
    }

    private void doMultiHostExportUpdate(Map<String, Map<String, PropertyUpdater>> updaters, Configuration configuration) {
        Map<String, Map<String, String>> properties = configuration.getFullProperties();
        for (Map.Entry<String, Map<String, PropertyUpdater>> entry : updaters.entrySet()) {
            String type = entry.getKey();
            Map<String, PropertyUpdater> propertyNameUpdaters = entry.getValue();
            for (Map.Entry<String, PropertyUpdater> propertyNameUpdater : propertyNameUpdaters.entrySet()) {
                String propertyName = propertyNameUpdater.getKey();
                PropertyUpdater propertyUpdater = propertyNameUpdater.getValue();
                Map<String, String> typeProperties = properties.get(type);
                if (typeProperties == null || !typeProperties.containsKey(propertyName)) continue;
                String propValue = typeProperties.get(propertyName);
                propValue = propertyUpdater.updateForBlueprintExport(propertyName, propValue, properties, this.clusterTopology);
                HashSet<String> addedGroups = new HashSet<String>();
                String[] toks = propValue.split(",");
                boolean inBrackets = propValue.startsWith("[");
                StringBuilder sb = new StringBuilder();
                if (inBrackets) {
                    sb.append('[');
                }
                boolean firstTok = true;
                for (String tok : toks) {
                    if (addedGroups.add(tok = tok.replaceAll("[\\[\\]]", ""))) {
                        if (!firstTok) {
                            sb.append(',');
                        }
                        sb.append(tok);
                    }
                    firstTok = false;
                }
                if (inBrackets) {
                    sb.append(']');
                }
                configuration.setProperty(type, propertyName, sb.toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<String> getHostStrings(String val, ClusterTopology topology) {
        LinkedHashSet<String> hosts = new LinkedHashSet<String>();
        Matcher m = HOSTGROUP_PORT_REGEX.matcher(val);
        while (m.find()) {
            String groupName = m.group(1);
            String port = m.group(2);
            HostGroupInfo hostGroupInfo = topology.getHostGroupInfo().get(groupName);
            if (hostGroupInfo == null) {
                throw new IllegalArgumentException("Unable to match blueprint host group token to a host group: " + groupName);
            }
            for (String string : hostGroupInfo.getHostNames()) {
                void var8_8;
                if (port != null) {
                    String string2 = string + ":" + port;
                }
                hosts.add((String)var8_8);
            }
        }
        return hosts;
    }

    private static String[] splitAndTrimStrings(String propertyName) {
        if (propertyName != null) {
            LinkedList<String> namesWithoutWhitespace = new LinkedList<String>();
            for (String service : propertyName.split(",")) {
                namesWithoutWhitespace.add(service.trim());
            }
            return namesWithoutWhitespace.toArray(new String[namesWithoutWhitespace.size()]);
        }
        return new String[0];
    }

    private void doNonTopologyUpdate(Map<String, Map<String, PropertyUpdater>> updaters, Configuration configuration) {
        Map<String, Map<String, String>> properties = configuration.getFullProperties();
        for (Map.Entry<String, Map<String, PropertyUpdater>> entry : updaters.entrySet()) {
            String type = entry.getKey();
            for (String propertyName : entry.getValue().keySet()) {
                PropertyUpdater pu = entry.getValue().get(propertyName);
                Map<String, String> typeProperties = properties.get(type);
                if (typeProperties == null || !typeProperties.containsKey(propertyName)) continue;
                String newValue = pu.updateForBlueprintExport(propertyName, typeProperties.get(propertyName), properties, this.clusterTopology);
                configuration.setProperty(type, propertyName, newValue);
            }
        }
    }

    private static void addUnitPropertyUpdaters() {
        Map<String, List<UnitValidatedProperty>> propsPerConfigType = UnitValidatedProperty.ALL.stream().collect(Collectors.groupingBy(UnitValidatedProperty::getConfigType));
        for (String configType : propsPerConfigType.keySet()) {
            HashMap<String, UnitUpdater> unitUpdaters = new HashMap<String, UnitUpdater>();
            for (UnitValidatedProperty each : propsPerConfigType.get(configType)) {
                unitUpdaters.put(each.getPropertyName(), new UnitUpdater(each.getServiceName(), each.getConfigType()));
            }
            mPropertyUpdaters.put(configType, unitUpdaters);
        }
    }

    private static Set<Pair<String, String>> generateHadoopProxyUserPropertyNames(Configuration configuration) {
        HashSet<Pair<String, String>> proxyUsers = new HashSet<Pair<String, String>>();
        Map<String, Map<String, String>> existingProperties = configuration.getFullProperties();
        for (Pair<String, String> userProp : PROPERTIES_FOR_HADOOP_PROXYUSER) {
            String user;
            String configType = (String)userProp.getLeft();
            String property = (String)userProp.getRight();
            Map<String, String> configs = existingProperties.get(configType);
            if (configs == null || Strings.isNullOrEmpty((String)(user = configs.get(property)))) continue;
            proxyUsers.add((Pair<String, String>)Pair.of((Object)configType, (Object)String.format(HADOOP_PROXYUSER_HOSTS_FORMAT, user)));
            proxyUsers.add((Pair<String, String>)Pair.of((Object)configType, (Object)String.format(HADOOP_PROXYUSER_GROUPS_FORMAT, user)));
        }
        return proxyUsers;
    }

    private static void setupHDFSProxyUsers(Configuration configuration, Set<String> configTypesUpdated, Collection<String> services) {
        if (services.contains("HDFS")) {
            Set<Pair<String, String>> configTypePropertyPairs = BlueprintConfigurationProcessor.generateHadoopProxyUserPropertyNames(configuration);
            Set<String> acceptableConfigTypes = BlueprintConfigurationProcessor.getEligibleConfigTypesForHadoopProxyUsers(services);
            Map<String, Map<String, String>> existingProperties = configuration.getFullProperties();
            for (Pair<String, String> pair : configTypePropertyPairs) {
                Map<String, String> configs;
                String configType = (String)pair.getLeft();
                if (!acceptableConfigTypes.contains(configType) || (configs = existingProperties.get(configType)) == null) continue;
                BlueprintConfigurationProcessor.ensureProperty(configuration, "core-site", (String)pair.getRight(), "*", configTypesUpdated);
            }
        }
    }

    private static Set<String> getEligibleConfigTypesForHadoopProxyUsers(Collection<String> services) {
        HashSet<String> acceptableConfigTypes = new HashSet<String>();
        if (services.contains("OOZIE")) {
            acceptableConfigTypes.add("oozie-env");
        }
        if (services.contains("HIVE")) {
            acceptableConfigTypes.add("hive-env");
        }
        if (services.contains("HBASE")) {
            acceptableConfigTypes.add("hbase-env");
        }
        if (services.contains("FALCON")) {
            acceptableConfigTypes.add("falcon-env");
        }
        return acceptableConfigTypes;
    }

    private void addExcludedConfigProperties(Configuration configuration, Set<String> configTypesUpdated, Stack stack) {
        Collection<String> blueprintServices = this.clusterTopology.getBlueprint().getServices();
        LOG.debug("Handling excluded properties for blueprint services: {}", blueprintServices);
        for (String blueprintService : blueprintServices) {
            LOG.debug("Handling excluded properties for blueprint service: {}", (Object)blueprintService);
            Set<String> excludedConfigTypes = stack.getExcludedConfigurationTypes(blueprintService);
            if (excludedConfigTypes.isEmpty()) {
                LOG.debug("There are no excluded config types for blueprint service: {}", (Object)blueprintService);
                continue;
            }
            for (String configType : excludedConfigTypes) {
                String blueprintServiceForExcludedConfig;
                LOG.debug("Handling excluded config type [{}] for blueprint service: [{}]", (Object)configType, (Object)blueprintService);
                try {
                    blueprintServiceForExcludedConfig = stack.getServiceForConfigType(configType);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOG.warn("Error encountered while trying to obtain the service name for config type [" + configType + "].  Further processing on this excluded config type will be skipped.  This usually means that a service's definitions have been manually removed from the Ambari stack definitions.  If the stack definitions have not been changed manually, this may indicate a stack definition error in Ambari.  ", (Throwable)illegalArgumentException);
                    continue;
                }
                if (!blueprintServices.contains(blueprintServiceForExcludedConfig)) {
                    LOG.debug("Service [{}] for excluded config type [{}] is not present in the blueprint. Ignoring excluded config entries.", (Object)blueprintServiceForExcludedConfig, (Object)configType);
                    continue;
                }
                Map<String, String> configProperties = stack.getConfigurationProperties(blueprintService, configType);
                for (Map.Entry<String, String> entry : configProperties.entrySet()) {
                    LOG.debug("ADD property {} {} {}", new Object[]{configType, entry.getKey(), entry.getValue()});
                    BlueprintConfigurationProcessor.ensureProperty(configuration, configType, entry.getKey(), entry.getValue(), configTypesUpdated);
                }
            }
        }
    }

    private static void setRetryConfiguration(Configuration configuration, Set<String> configTypesUpdated) {
        boolean wasUpdated = false;
        if (configuration.getPropertyValue("cluster-env", COMMAND_RETRY_ENABLED_PROPERTY_NAME) == null) {
            configuration.setProperty("cluster-env", COMMAND_RETRY_ENABLED_PROPERTY_NAME, COMMAND_RETRY_ENABLED_DEFAULT);
            wasUpdated = true;
        }
        if (configuration.getPropertyValue("cluster-env", COMMANDS_TO_RETRY_PROPERTY_NAME) == null) {
            configuration.setProperty("cluster-env", COMMANDS_TO_RETRY_PROPERTY_NAME, COMMANDS_TO_RETRY_DEFAULT);
            wasUpdated = true;
        }
        if (configuration.getPropertyValue("cluster-env", COMMAND_RETRY_MAX_TIME_IN_SEC_PROPERTY_NAME) == null) {
            configuration.setProperty("cluster-env", COMMAND_RETRY_MAX_TIME_IN_SEC_PROPERTY_NAME, COMMAND_RETRY_MAX_TIME_IN_SEC_DEFAULT);
            wasUpdated = true;
        }
        if (wasUpdated) {
            configTypesUpdated.add("cluster-env");
        }
    }

    protected void setStackToolsAndFeatures(Configuration configuration, Set<String> configTypesUpdated) throws ConfigurationTopologyException {
        ConfigHelper configHelper = this.clusterTopology.getAmbariContext().getConfigHelper();
        Stack stack = this.clusterTopology.getBlueprint().getStack();
        String stackName = stack.getName();
        String stackVersion = stack.getVersion();
        StackId stackId = new StackId(stackName, stackVersion);
        HashSet properties = Sets.newHashSet((Object[])new String[]{"stack_name", "stack_root", "stack_tools", "stack_features", "stack_packages"});
        try {
            Map<String, Map<String, String>> defaultStackProperties = configHelper.getDefaultStackProperties(stackId);
            Map<String, String> clusterEnvDefaultProperties = defaultStackProperties.get("cluster-env");
            for (String property : properties) {
                String newValue;
                String previous;
                if (!clusterEnvDefaultProperties.containsKey(property) || Objects.equals(this.trimValue(previous = configuration.setProperty("cluster-env", property, newValue = clusterEnvDefaultProperties.get(property)), stack, "cluster-env", property), this.trimValue(newValue, stack, "cluster-env", property))) continue;
                configTypesUpdated.add("cluster-env");
            }
        }
        catch (OBDPException ambariException) {
            throw new ConfigurationTopologyException("Unable to retrieve the stack tools and features", ambariException);
        }
    }

    private static void injectDefaults(Configuration configuration, Set<String> configTypesUpdated, Collection<String> services) {
        BlueprintConfigurationProcessor.setRetryConfiguration(configuration, configTypesUpdated);
        BlueprintConfigurationProcessor.setupHDFSProxyUsers(configuration, configTypesUpdated, services);
    }

    @Nullable
    private String trimValue(@Nullable String value, @NotNull Stack stack, @NotNull String configType, @NotNull String propertyName) {
        if (null == value) {
            return null;
        }
        TrimmingStrategy trimmingStrategy = PropertyValueTrimmingStrategyDefiner.defineTrimmingStrategy(stack, propertyName, configType);
        return trimmingStrategy.trim(value);
    }

    private static void ensureProperty(Configuration configuration, String type, String property, String defaultValue, Set<String> configTypesUpdated) {
        if (configuration.getPropertyValue(type, property) == null) {
            configuration.setProperty(type, property, defaultValue);
            configTypesUpdated.add(type);
        }
    }

    static {
        allUpdaters.add(singleHostTopologyUpdaters);
        allUpdaters.add(multiHostTopologyUpdaters);
        allUpdaters.add(dbHostTopologyUpdaters);
        allUpdaters.add(mPropertyUpdaters);
        allUpdaters.add(nonTopologyUpdaters);
        HashMap<String, 6> amsSiteMap = new HashMap<String, 6>();
        HashMap<String, PropertyUpdater> druidCommon = new HashMap<String, PropertyUpdater>();
        HashMap<String, OptionalSingleHostTopologyUpdater> hdfsSiteMap = new HashMap<String, OptionalSingleHostTopologyUpdater>();
        HashMap<String, SingleHostTopologyUpdater> mapredSiteMap = new HashMap<String, SingleHostTopologyUpdater>();
        HashMap<String, OptionalSingleHostTopologyUpdater> coreSiteMap = new HashMap<String, OptionalSingleHostTopologyUpdater>();
        HashMap<String, OptionalSingleHostTopologyUpdater> hbaseSiteMap = new HashMap<String, OptionalSingleHostTopologyUpdater>();
        HashMap<String, PropertyUpdater> yarnSiteMap = new HashMap<String, PropertyUpdater>();
        HashMap<String, SingleHostTopologyUpdater> hiveSiteMap = new HashMap<String, SingleHostTopologyUpdater>();
        HashMap<String, NonTopologyUpdater> hiveSiteNonTopologyMap = new HashMap<String, NonTopologyUpdater>();
        HashMap hiveEnvOriginalValueMap = new HashMap();
        HashMap oozieSiteOriginalValueMap = new HashMap();
        HashMap oozieSiteMap = new HashMap();
        HashMap<String, SingleHostTopologyUpdater> stormSiteMap = new HashMap<String, SingleHostTopologyUpdater>();
        HashMap<String, 4> stormSiteNonTopologyMap = new HashMap<String, 4>();
        HashMap<String, SingleHostTopologyUpdater> accumuloSiteMap = new HashMap<String, SingleHostTopologyUpdater>();
        HashMap<String, SingleHostTopologyUpdater> falconStartupPropertiesMap = new HashMap<String, SingleHostTopologyUpdater>();
        HashMap<String, OptionalSingleHostTopologyUpdater> kafkaBrokerMap = new HashMap<String, OptionalSingleHostTopologyUpdater>();
        HashMap<String, 5> kafkaBrokerNonTopologyMap = new HashMap<String, 5>();
        HashMap<String, MultipleHostTopologyUpdater> atlasPropsMap = new HashMap<String, MultipleHostTopologyUpdater>();
        HashMap mapredEnvMap = new HashMap();
        HashMap mHadoopEnvMap = new HashMap();
        HashMap shHadoopEnvMap = new HashMap();
        HashMap<String, SingleHostTopologyUpdater> clusterEnvMap = new HashMap<String, SingleHostTopologyUpdater>();
        HashMap hbaseEnvMap = new HashMap();
        HashMap hiveEnvMap = new HashMap();
        HashMap<String, SingleHostTopologyUpdater> hiveInteractiveEnvMap = new HashMap<String, SingleHostTopologyUpdater>();
        HashMap<String, MultipleHostTopologyUpdater> hiveInteractiveSiteMap = new HashMap<String, MultipleHostTopologyUpdater>();
        HashMap oozieEnvMap = new HashMap();
        HashMap oozieEnvHeapSizeMap = new HashMap();
        HashMap<String, PropertyUpdater> multiWebhcatSiteMap = new HashMap<String, PropertyUpdater>();
        HashMap<String, MultipleHostTopologyUpdater> multiHbaseSiteMap = new HashMap<String, MultipleHostTopologyUpdater>();
        HashMap<String, MultipleHostTopologyUpdater> livy2Conf = new HashMap<String, MultipleHostTopologyUpdater>();
        HashMap<String, YamlMultiValuePropertyDecorator> multiStormSiteMap = new HashMap<String, YamlMultiValuePropertyDecorator>();
        HashMap<String, MultipleHostTopologyUpdater> multiCoreSiteMap = new HashMap<String, MultipleHostTopologyUpdater>();
        HashMap<String, MultipleHostTopologyUpdater> multiHdfsSiteMap = new HashMap<String, MultipleHostTopologyUpdater>();
        HashMap<String, MultipleHostTopologyUpdater> multiHiveSiteMap = new HashMap<String, MultipleHostTopologyUpdater>();
        HashMap<String, MultipleHostTopologyUpdater> multiKafkaBrokerMap = new HashMap<String, MultipleHostTopologyUpdater>();
        HashMap<String, MultipleHostTopologyUpdater> multiYarnSiteMap = new HashMap<String, MultipleHostTopologyUpdater>();
        HashMap<String, MultipleHostTopologyUpdater> multiOozieSiteMap = new HashMap<String, MultipleHostTopologyUpdater>();
        HashMap<String, MultipleHostTopologyUpdater> multiAccumuloSiteMap = new HashMap<String, MultipleHostTopologyUpdater>();
        HashMap<String, MultipleHostTopologyUpdater> multiRangerKmsSiteMap = new HashMap<String, MultipleHostTopologyUpdater>();
        HashMap<String, DBTopologyUpdater> dbHiveSiteMap = new HashMap<String, DBTopologyUpdater>();
        HashMap<String, SingleHostTopologyUpdater> rangerAdminPropsMap = new HashMap<String, SingleHostTopologyUpdater>();
        HashMap rangerEnvPropsMap = new HashMap();
        HashMap rangerYarnAuditPropsMap = new HashMap();
        HashMap rangerHdfsAuditPropsMap = new HashMap();
        HashMap rangerHbaseAuditPropsMap = new HashMap();
        HashMap rangerHiveAuditPropsMap = new HashMap();
        HashMap rangerKnoxAuditPropsMap = new HashMap();
        HashMap rangerKafkaAuditPropsMap = new HashMap();
        HashMap rangerStormAuditPropsMap = new HashMap();
        HashMap rangerAtlasAuditPropsMap = new HashMap();
        HashMap<String, SingleHostTopologyUpdater> hawqSiteMap = new HashMap<String, SingleHostTopologyUpdater>();
        HashMap zookeeperEnvMap = new HashMap();
        singleHostTopologyUpdaters.put("ams-site", amsSiteMap);
        singleHostTopologyUpdaters.put("druid-common", druidCommon);
        singleHostTopologyUpdaters.put("hdfs-site", hdfsSiteMap);
        singleHostTopologyUpdaters.put("mapred-site", mapredSiteMap);
        singleHostTopologyUpdaters.put("core-site", coreSiteMap);
        singleHostTopologyUpdaters.put("hbase-site", hbaseSiteMap);
        singleHostTopologyUpdaters.put("yarn-site", yarnSiteMap);
        singleHostTopologyUpdaters.put("hive-site", hiveSiteMap);
        singleHostTopologyUpdaters.put("hive-interactive-env", hiveInteractiveEnvMap);
        singleHostTopologyUpdaters.put("storm-site", stormSiteMap);
        singleHostTopologyUpdaters.put("accumulo-site", accumuloSiteMap);
        singleHostTopologyUpdaters.put("falcon-startup.properties", falconStartupPropertiesMap);
        singleHostTopologyUpdaters.put("hive-env", hiveEnvMap);
        singleHostTopologyUpdaters.put("oozie-env", oozieEnvMap);
        singleHostTopologyUpdaters.put("kafka-broker", kafkaBrokerMap);
        singleHostTopologyUpdaters.put("admin-properties", rangerAdminPropsMap);
        singleHostTopologyUpdaters.put("ranger-env", rangerEnvPropsMap);
        singleHostTopologyUpdaters.put("ranger-yarn-audit", rangerYarnAuditPropsMap);
        singleHostTopologyUpdaters.put("ranger-hdfs-audit", rangerHdfsAuditPropsMap);
        singleHostTopologyUpdaters.put("ranger-hbase-audit", rangerHbaseAuditPropsMap);
        singleHostTopologyUpdaters.put("ranger-hive-audit", rangerHiveAuditPropsMap);
        singleHostTopologyUpdaters.put("ranger-knox-audit", rangerKnoxAuditPropsMap);
        singleHostTopologyUpdaters.put("ranger-kafka-audit", rangerKafkaAuditPropsMap);
        singleHostTopologyUpdaters.put("ranger-storm-audit", rangerStormAuditPropsMap);
        singleHostTopologyUpdaters.put("ranger-atlas-audit", rangerAtlasAuditPropsMap);
        singleHostTopologyUpdaters.put(HADOOP_ENV_CONFIG_TYPE_NAME, shHadoopEnvMap);
        singleHostTopologyUpdaters.put("cluster-env", clusterEnvMap);
        singleHostTopologyUpdaters.put("hawq-site", hawqSiteMap);
        singleHostTopologyUpdaters.put("zookeeper-env", zookeeperEnvMap);
        mPropertyUpdaters.put(HADOOP_ENV_CONFIG_TYPE_NAME, mHadoopEnvMap);
        mPropertyUpdaters.put("hbase-env", hbaseEnvMap);
        mPropertyUpdaters.put("mapred-env", mapredEnvMap);
        mPropertyUpdaters.put("oozie-env", oozieEnvHeapSizeMap);
        multiHostTopologyUpdaters.put("webhcat-site", multiWebhcatSiteMap);
        multiHostTopologyUpdaters.put("hbase-site", multiHbaseSiteMap);
        multiHostTopologyUpdaters.put("storm-site", multiStormSiteMap);
        multiHostTopologyUpdaters.put("core-site", multiCoreSiteMap);
        multiHostTopologyUpdaters.put("hdfs-site", multiHdfsSiteMap);
        multiHostTopologyUpdaters.put("hive-site", multiHiveSiteMap);
        multiHostTopologyUpdaters.put("hive-interactive-site", hiveInteractiveSiteMap);
        multiHostTopologyUpdaters.put("kafka-broker", multiKafkaBrokerMap);
        multiHostTopologyUpdaters.put("yarn-site", multiYarnSiteMap);
        multiHostTopologyUpdaters.put("oozie-site", multiOozieSiteMap);
        multiHostTopologyUpdaters.put("accumulo-site", multiAccumuloSiteMap);
        multiHostTopologyUpdaters.put("kms-site", multiRangerKmsSiteMap);
        multiHostTopologyUpdaters.put("application-properties", atlasPropsMap);
        multiHostTopologyUpdaters.put("livy2-conf", livy2Conf);
        dbHostTopologyUpdaters.put("hive-site", dbHiveSiteMap);
        nonTopologyUpdaters.put("hive-site", hiveSiteNonTopologyMap);
        nonTopologyUpdaters.put("kafka-broker", kafkaBrokerNonTopologyMap);
        nonTopologyUpdaters.put("storm-site", stormSiteNonTopologyMap);
        hdfsSiteMap.put("dfs.http.address", new OptionalSingleHostTopologyUpdater("NAMENODE"));
        hdfsSiteMap.put("dfs.https.address", new OptionalSingleHostTopologyUpdater("NAMENODE"));
        coreSiteMap.put("fs.default.name", new OptionalSingleHostTopologyUpdater("NAMENODE"));
        hdfsSiteMap.put("dfs.namenode.http-address", new OptionalSingleHostTopologyUpdater("NAMENODE"));
        hdfsSiteMap.put("dfs.namenode.https-address", new OptionalSingleHostTopologyUpdater("NAMENODE"));
        hdfsSiteMap.put("dfs.namenode.rpc-address", new OptionalSingleHostTopologyUpdater("NAMENODE"));
        coreSiteMap.put("fs.defaultFS", new OptionalSingleHostTopologyUpdater("NAMENODE"));
        hbaseSiteMap.put("hbase.rootdir", new OptionalSingleHostTopologyUpdater("NAMENODE"));
        accumuloSiteMap.put("instance.volumes", new SingleHostTopologyUpdater("NAMENODE"));
        multiHdfsSiteMap.put("dfs.namenode.shared.edits.dir", new MultipleHostTopologyUpdater("JOURNALNODE", Character.valueOf(';'), false, false, true));
        multiHdfsSiteMap.put("dfs.encryption.key.provider.uri", new MultipleHostTopologyUpdater("RANGER_KMS_SERVER", Character.valueOf(';'), false, false, false));
        clusterEnvMap.put(HDFS_ACTIVE_NAMENODE_PROPERTY_NAME, new SingleHostTopologyUpdater("NAMENODE"));
        clusterEnvMap.put(HDFS_STANDBY_NAMENODE_PROPERTY_NAME, new SingleHostTopologyUpdater("NAMENODE"));
        hdfsSiteMap.put("dfs.secondary.http.address", new OptionalSingleHostTopologyUpdater("SECONDARY_NAMENODE"));
        hdfsSiteMap.put("dfs.namenode.secondary.http-address", new OptionalSingleHostTopologyUpdater("SECONDARY_NAMENODE"));
        mapredSiteMap.put("mapred.job.tracker", new SingleHostTopologyUpdater("JOBTRACKER"));
        mapredSiteMap.put("mapred.job.tracker.http.address", new SingleHostTopologyUpdater("JOBTRACKER"));
        mapredSiteMap.put("mapreduce.history.server.http.address", new SingleHostTopologyUpdater("JOBTRACKER"));
        mapredSiteMap.put("mapreduce.job.hdfs-servers", new SingleHostTopologyUpdater("NAMENODE"));
        yarnSiteMap.put("yarn.log.server.url", new OptionalSingleHostTopologyUpdater("HISTORYSERVER"));
        mapredSiteMap.put("mapreduce.jobhistory.webapp.address", new OptionalSingleHostTopologyUpdater("HISTORYSERVER"));
        mapredSiteMap.put("mapreduce.jobhistory.address", new OptionalSingleHostTopologyUpdater("HISTORYSERVER"));
        yarnSiteMap.put("yarn.resourcemanager.hostname", new OptionalSingleHostTopologyUpdater("RESOURCEMANAGER"));
        yarnSiteMap.put("yarn.resourcemanager.resource-tracker.address", new OptionalSingleHostTopologyUpdater("RESOURCEMANAGER"));
        yarnSiteMap.put("yarn.resourcemanager.webapp.address", new OptionalSingleHostTopologyUpdater("RESOURCEMANAGER"));
        yarnSiteMap.put("yarn.resourcemanager.scheduler.address", new OptionalSingleHostTopologyUpdater("RESOURCEMANAGER"));
        yarnSiteMap.put("yarn.resourcemanager.address", new OptionalSingleHostTopologyUpdater("RESOURCEMANAGER"));
        yarnSiteMap.put("yarn.resourcemanager.admin.address", new OptionalSingleHostTopologyUpdater("RESOURCEMANAGER"));
        yarnSiteMap.put("yarn.resourcemanager.webapp.https.address", new OptionalSingleHostTopologyUpdater("RESOURCEMANAGER"));
        yarnSiteMap.put("yarn.timeline-service.address", new OptionalSingleHostTopologyUpdater("APP_TIMELINE_SERVER"));
        yarnSiteMap.put("yarn.timeline-service.webapp.address", new OptionalSingleHostTopologyUpdater("APP_TIMELINE_SERVER"));
        yarnSiteMap.put("yarn.timeline-service.webapp.https.address", new OptionalSingleHostTopologyUpdater("APP_TIMELINE_SERVER"));
        yarnSiteMap.put("yarn.log.server.web-service.url", new OptionalSingleHostTopologyUpdater("APP_TIMELINE_SERVER"));
        yarnSiteMap.put("yarn.timeline-service.reader.webapp.address", new MultipleHostTopologyUpdater("TIMELINE_READER"));
        yarnSiteMap.put("yarn.timeline-service.reader.webapp.https.address", new MultipleHostTopologyUpdater("TIMELINE_READER"));
        hiveSiteMap.put("hive.server2.authentication.ldap.url", new SingleHostTopologyUpdater("HIVE_SERVER2"));
        multiHiveSiteMap.put("hive.metastore.uris", new MultipleHostTopologyUpdater("HIVE_METASTORE", Character.valueOf(','), true, true, true));
        dbHiveSiteMap.put("javax.jdo.option.ConnectionURL", new DBTopologyUpdater("MYSQL_SERVER", "hive-env", "hive_database"));
        multiCoreSiteMap.put("hadoop.proxyuser.hive.hosts", new MultipleHostTopologyUpdater("HIVE_SERVER"));
        multiCoreSiteMap.put("hadoop.proxyuser.HTTP.hosts", new MultipleHostTopologyUpdater("WEBHCAT_SERVER"));
        multiCoreSiteMap.put("hadoop.proxyuser.hcat.hosts", new MultipleHostTopologyUpdater("WEBHCAT_SERVER"));
        multiCoreSiteMap.put("hadoop.proxyuser.yarn.hosts", new MultipleHostTopologyUpdater("RESOURCEMANAGER"));
        multiCoreSiteMap.put("hadoop.security.key.provider.path", new MultipleHostTopologyUpdater("RANGER_KMS_SERVER", Character.valueOf(';'), false, false, true));
        multiWebhcatSiteMap.put("templeton.hive.properties", new TempletonHivePropertyUpdater());
        multiHiveSiteMap.put("hive.zookeeper.quorum", new MultipleHostTopologyUpdater("ZOOKEEPER_SERVER"));
        multiHiveSiteMap.put("hive.cluster.delegation.token.store.zookeeper.connectString", new MultipleHostTopologyUpdater("ZOOKEEPER_SERVER"));
        hiveInteractiveEnvMap.put("hive_server_interactive_host", new SingleHostTopologyUpdater("HIVE_SERVER_INTERACTIVE"));
        hiveInteractiveSiteMap.put("hive.llap.zk.sm.connectionString", new MultipleHostTopologyUpdater("ZOOKEEPER_SERVER"));
        hiveSiteNonTopologyMap.put("hive.exec.post.hooks", new NonTopologyUpdater(){

            @Override
            public String updateForClusterCreate(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
                String atlasHookClass = "org.apache.atlas.hive.hook.HiveHook";
                String[] hiveHooks = origValue.split(",");
                ArrayList<String> hiveHooksClean = new ArrayList<String>();
                for (String hiveHook : hiveHooks) {
                    if (StringUtils.isBlank((String)hiveHook.trim())) continue;
                    hiveHooksClean.add(hiveHook.trim());
                }
                boolean isAtlasInCluster = topology.getBlueprint().getServices().contains("ATLAS");
                boolean isAtlasHiveHookEnabled = Boolean.parseBoolean(properties.get("hive-env").get("hive.atlas.hook"));
                if (isAtlasInCluster || isAtlasHiveHookEnabled) {
                    if (!hiveHooksClean.contains(atlasHookClass)) {
                        hiveHooksClean.add(atlasHookClass);
                    }
                } else {
                    while (hiveHooksClean.contains(atlasHookClass)) {
                        hiveHooksClean.remove(atlasHookClass);
                    }
                }
                if (!hiveHooksClean.isEmpty()) {
                    return StringUtils.join(hiveHooksClean, (String)",");
                }
                return " ";
            }
        });
        hiveSiteNonTopologyMap.put("atlas.cluster.name", new NonTopologyUpdater(){

            @Override
            public String updateForClusterCreate(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
                if (topology.getBlueprint().getServices().contains("ATLAS")) {
                    if (origValue == null || origValue.trim().isEmpty() || origValue.equals("primary")) {
                        return String.valueOf(topology.getClusterId());
                    }
                    return origValue;
                }
                return origValue;
            }

            @Override
            public String updateForBlueprintExport(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
                if (origValue.equals(String.valueOf(topology.getClusterId()))) {
                    return "primary";
                }
                return origValue;
            }
        });
        hiveSiteMap.put("atlas.rest.address", new SingleHostTopologyUpdater("ATLAS_SERVER"){

            @Override
            public String updateForClusterCreate(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
                if (topology.getBlueprint().getServices().contains("ATLAS")) {
                    String port;
                    String scheme;
                    String host = topology.getHostAssignmentsForComponent("ATLAS_SERVER").iterator().next();
                    boolean tlsEnabled = Boolean.parseBoolean(properties.get("application-properties").get("atlas.enableTLS"));
                    if (tlsEnabled) {
                        scheme = "https";
                        port = properties.get("application-properties").get("atlas.server.https.port");
                    } else {
                        scheme = "http";
                        port = properties.get("application-properties").get("atlas.server.http.port");
                    }
                    return String.format("%s://%s:%s", scheme, host, port);
                }
                return origValue;
            }
        });
        Map<String, PropertyUpdater> oozieStringPropertyUpdaterMap = singleHostTopologyUpdaters.get("oozie-site");
        if (oozieStringPropertyUpdaterMap == null) {
            oozieStringPropertyUpdaterMap = new HashMap<String, PropertyUpdater>();
        }
        oozieStringPropertyUpdaterMap.put("oozie.base.url", new SingleHostTopologyUpdater("OOZIE_SERVER"));
        singleHostTopologyUpdaters.put("oozie-site", oozieStringPropertyUpdaterMap);
        multiCoreSiteMap.put("hadoop.proxyuser.oozie.hosts", new MultipleHostTopologyUpdater("OOZIE_SERVER"));
        multiHbaseSiteMap.put("hbase.zookeeper.quorum", new MultipleHostTopologyUpdater("ZOOKEEPER_SERVER"));
        multiWebhcatSiteMap.put("templeton.zookeeper.hosts", new MultipleHostTopologyUpdater("ZOOKEEPER_SERVER"));
        multiCoreSiteMap.put("ha.zookeeper.quorum", new MultipleHostTopologyUpdater("ZOOKEEPER_SERVER"));
        multiYarnSiteMap.put("hadoop.registry.zk.quorum", new MultipleHostTopologyUpdater("ZOOKEEPER_SERVER"));
        multiYarnSiteMap.put("yarn.resourcemanager.zk-address", new MultipleHostTopologyUpdater("ZOOKEEPER_SERVER"));
        multiKafkaBrokerMap.put("zookeeper.connect", new MultipleHostTopologyUpdater("ZOOKEEPER_SERVER"));
        multiAccumuloSiteMap.put("instance.zookeeper.host", new MultipleHostTopologyUpdater("ZOOKEEPER_SERVER"));
        stormSiteMap.put("nimbus.host", new SingleHostTopologyUpdater("NIMBUS"));
        stormSiteMap.put("nimbus_hosts", new SingleHostTopologyUpdater("NIMBUS"));
        stormSiteMap.put("drpc_server_host", new SingleHostTopologyUpdater("DRPC_SERVER"));
        stormSiteMap.put("drpc.servers", new SingleHostTopologyUpdater("DRPC_SERVER"));
        stormSiteMap.put("storm_ui_server_host", new SingleHostTopologyUpdater("STORM_UI_SERVER"));
        stormSiteMap.put("worker.childopts", new OptionalSingleHostTopologyUpdater("GANGLIA_SERVER"));
        stormSiteMap.put("supervisor.childopts", new OptionalSingleHostTopologyUpdater("GANGLIA_SERVER"));
        stormSiteMap.put("nimbus.childopts", new OptionalSingleHostTopologyUpdater("GANGLIA_SERVER"));
        stormSiteNonTopologyMap.put("metrics.reporter.register", new NonTopologyUpdater(){

            @Override
            public String updateForClusterCreate(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
                if (topology.getBlueprint().getServices().contains("AMBARI_METRICS")) {
                    String amsReporterClass = "org.apache.hadoop.metrics2.sink.storm.StormTimelineMetricsReporter";
                    if (origValue == null || origValue.isEmpty()) {
                        return "org.apache.hadoop.metrics2.sink.storm.StormTimelineMetricsReporter";
                    }
                }
                return origValue;
            }
        });
        multiStormSiteMap.put("supervisor_hosts", new YamlMultiValuePropertyDecorator(new MultipleHostTopologyUpdater("SUPERVISOR")));
        multiStormSiteMap.put("storm.zookeeper.servers", new YamlMultiValuePropertyDecorator(new MultipleHostTopologyUpdater("ZOOKEEPER_SERVER")));
        multiStormSiteMap.put("nimbus.seeds", new YamlMultiValuePropertyDecorator(new MultipleHostTopologyUpdater("NIMBUS"), YamlMultiValuePropertyDecorator.FlowStyle.PLAIN));
        falconStartupPropertiesMap.put("*.broker.url", new SingleHostTopologyUpdater("FALCON_SERVER"));
        kafkaBrokerMap.put("kafka.ganglia.metrics.host", new OptionalSingleHostTopologyUpdater("GANGLIA_SERVER"));
        kafkaBrokerNonTopologyMap.put("kafka.metrics.reporters", new NonTopologyUpdater(){

            @Override
            public String updateForClusterCreate(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
                if (topology.getBlueprint().getServices().contains("AMBARI_METRICS")) {
                    String amsReportesClass = "org.apache.hadoop.metrics2.sink.kafka.KafkaTimelineMetricsReporter";
                    if (origValue == null || origValue.isEmpty()) {
                        return "org.apache.hadoop.metrics2.sink.kafka.KafkaTimelineMetricsReporter";
                    }
                    if (!origValue.contains("org.apache.hadoop.metrics2.sink.kafka.KafkaTimelineMetricsReporter")) {
                        return String.format("%s,%s", origValue, "org.apache.hadoop.metrics2.sink.kafka.KafkaTimelineMetricsReporter");
                    }
                }
                return origValue;
            }
        });
        multiCoreSiteMap.put("hadoop.proxyuser.knox.hosts", new MultipleHostTopologyUpdater("KNOX_GATEWAY"));
        multiWebhcatSiteMap.put("webhcat.proxyuser.knox.hosts", new MultipleHostTopologyUpdater("KNOX_GATEWAY"));
        multiOozieSiteMap.put("hadoop.proxyuser.knox.hosts", new MultipleHostTopologyUpdater("KNOX_GATEWAY"));
        multiOozieSiteMap.put("oozie.service.ProxyUserService.proxyuser.knox.hosts", new MultipleHostTopologyUpdater("KNOX_GATEWAY"));
        atlasPropsMap.put("atlas.server.bind.address", new MultipleHostTopologyUpdater("ATLAS_SERVER"));
        atlasPropsMap.put("atlas.rest.address", new MultipleHostTopologyUpdater("ATLAS_SERVER", Character.valueOf(','), true, true, true));
        atlasPropsMap.put("atlas.kafka.bootstrap.servers", new MultipleHostTopologyUpdater("KAFKA_BROKER"));
        atlasPropsMap.put("atlas.kafka.zookeeper.connect", new MultipleHostTopologyUpdater("ZOOKEEPER_SERVER"));
        atlasPropsMap.put("atlas.graph.index.search.solr.zookeeper-url", new MultipleHostTopologyUpdater("ZOOKEEPER_SERVER", Character.valueOf(','), false, true, true));
        atlasPropsMap.put("atlas.graph.storage.hostname", new MultipleHostTopologyUpdater("ZOOKEEPER_SERVER"));
        atlasPropsMap.put("atlas.audit.hbase.zookeeper.quorum", new MultipleHostTopologyUpdater("ZOOKEEPER_SERVER"));
        rangerAdminPropsMap.put("policymgr_external_url", new SingleHostTopologyUpdater("RANGER_ADMIN"));
        ImmutableList configsWithRangerHdfsAuditDirProperty = ImmutableList.of(rangerEnvPropsMap, rangerYarnAuditPropsMap, rangerHdfsAuditPropsMap, rangerHbaseAuditPropsMap, rangerHiveAuditPropsMap, rangerKnoxAuditPropsMap, rangerKafkaAuditPropsMap, rangerStormAuditPropsMap, rangerAtlasAuditPropsMap);
        for (Map rangerAuditPropsMap : configsWithRangerHdfsAuditDirProperty) {
            rangerAuditPropsMap.put("xasecure.audit.destination.hdfs.dir", new OptionalSingleHostTopologyUpdater("NAMENODE"));
        }
        multiRangerKmsSiteMap.put("hadoop.kms.authentication.signer.secret.provider.zookeeper.connection.string", new MultipleHostTopologyUpdater("ZOOKEEPER_SERVER"));
        BlueprintConfigurationProcessor.addUnitPropertyUpdaters();
        hawqSiteMap.put("hawq_master_address_host", new SingleHostTopologyUpdater("HAWQMASTER"));
        hawqSiteMap.put(HAWQ_SITE_HAWQ_STANDBY_ADDRESS_HOST, new SingleHostTopologyUpdater(HAWQSTANDBY));
        hawqSiteMap.put("hawq_dfs_url", new SingleHostTopologyUpdater("NAMENODE"));
        amsSiteMap.put("timeline.metrics.service.webapp.address", new SingleHostTopologyUpdater("METRICS_COLLECTOR"){

            @Override
            public String updateForClusterCreate(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
                if (!origValue.startsWith(BlueprintConfigurationProcessor.BIND_ALL_IP_ADDRESS)) {
                    return origValue.replace(origValue.split(":")[0], BlueprintConfigurationProcessor.BIND_ALL_IP_ADDRESS);
                }
                return origValue;
            }
        });
        druidCommon.put("metastore_hostname", HostGroupUpdater.INSTANCE);
        druidCommon.put("druid.metadata.storage.connector.connectURI", HostGroupUpdater.INSTANCE);
        druidCommon.put("druid.zk.service.host", new MultipleHostTopologyUpdater("ZOOKEEPER_SERVER"));
        livy2Conf.put("livy.server.recovery.state-store.url", new MultipleHostTopologyUpdater("ZOOKEEPER_SERVER"));
    }

    private static interface PropertyFilter {
        public boolean isPropertyIncluded(String var1, String var2, String var3, ClusterTopology var4);
    }

    private static class PasswordPropertyFilter
    implements PropertyFilter {
        private static final Pattern PASSWORD_NAME_REGEX = Pattern.compile("\\S+(PASSWORD|SECRET)", 2);

        private PasswordPropertyFilter() {
        }

        @Override
        public boolean isPropertyIncluded(String propertyName, String propertyValue, String configType, ClusterTopology topology) {
            return !PASSWORD_NAME_REGEX.matcher(propertyName).matches();
        }
    }

    private static class SimplePropertyNameExportFilter
    implements PropertyFilter {
        private final String propertyName;
        private final String propertyConfigType;

        SimplePropertyNameExportFilter(String propertyName, String propertyConfigType) {
            this.propertyName = propertyName;
            this.propertyConfigType = propertyConfigType;
        }

        @Override
        public boolean isPropertyIncluded(String propertyName, String propertyValue, String configType, ClusterTopology topology) {
            return !this.propertyConfigType.equals(configType) || !this.propertyName.equals(propertyName);
        }
    }

    private static class StackPropertyTypeFilter
    implements PropertyFilter {
        private StackPropertyTypeFilter() {
        }

        @Override
        public boolean isPropertyIncluded(String propertyName, String propertyValue, String configType, ClusterTopology topology) {
            String serviceName;
            Stack stack = topology.getBlueprint().getStack();
            return !stack.isPasswordProperty(serviceName = stack.getServiceForConfigType(configType), configType, propertyName) && !stack.isKerberosPrincipalNameProperty(serviceName, configType, propertyName);
        }
    }

    private static class KerberosAuthToLocalRulesFilter
    implements PropertyFilter {
        Map<Long, Set<String>> authToLocalPerClusterMap = null;

        KerberosAuthToLocalRulesFilter(Map<Long, Set<String>> authToLocalPerClusterMap) {
            this.authToLocalPerClusterMap = authToLocalPerClusterMap;
        }

        @Override
        public boolean isPropertyIncluded(String propertyName, String propertyValue, String configType, ClusterTopology topology) {
            return this.authToLocalPerClusterMap == null || this.authToLocalPerClusterMap.get(topology.getClusterId()) == null || !this.authToLocalPerClusterMap.get(topology.getClusterId()).contains(String.format("%s/%s", configType, propertyName));
        }
    }

    private static class SingleHostTopologyUpdater
    extends HostGroupUpdater {
        private final String component;

        public SingleHostTopologyUpdater(String component) {
            this.component = component;
        }

        @Override
        public String updateForClusterCreate(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            String replacedValue = super.updateForClusterCreate(propertyName, origValue, properties, topology);
            if (!Objects.equals(origValue, replacedValue)) {
                return replacedValue;
            }
            if (null != origValue && !origValue.contains(BlueprintConfigurationProcessor.LOCALHOST)) {
                return origValue;
            }
            int matchingGroupCount = topology.getHostGroupsForComponent(this.component).size();
            if (matchingGroupCount == 1) {
                return origValue.replace(BlueprintConfigurationProcessor.LOCALHOST, topology.getHostAssignmentsForComponent(this.component).iterator().next());
            }
            Cardinality cardinality = topology.getBlueprint().getStack().getCardinality(this.component);
            if (matchingGroupCount == 0 && cardinality.isValidCount(0)) {
                return origValue;
            }
            if (topology.isNameNodeHAEnabled() && this.isComponentNameNode() && matchingGroupCount >= 2) {
                if (properties.containsKey("core-site") && properties.get("core-site").get("fs.defaultFS").equals(origValue)) {
                    return origValue;
                }
                if (properties.containsKey("hbase-site") && properties.get("hbase-site").get("hbase.rootdir").equals(origValue)) {
                    return origValue;
                }
                if (properties.containsKey("accumulo-site") && properties.get("accumulo-site").get("instance.volumes").equals(origValue)) {
                    return origValue;
                }
            }
            if (topology.isNameNodeHAEnabled() && this.isComponentSecondaryNameNode() && matchingGroupCount == 0) {
                return origValue;
            }
            if (this.isComponentNameNode() && topology.hasHadoopCompatibleService()) {
                return origValue;
            }
            throw new IllegalArgumentException(String.format("Unable to update configuration property '%s' with topology information. Component '%s' is mapped to an invalid number of host groups '%s'.", propertyName, this.component, matchingGroupCount));
        }

        @Override
        public String updateForBlueprintExport(String propertyName, String value, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            for (HostGroupInfo groupInfo : topology.getHostGroupInfo().values()) {
                Collection<String> hosts = groupInfo.getHostNames();
                for (String host : hosts) {
                    if (!value.contains(host)) continue;
                    return value.replace(host, "%HOSTGROUP::" + groupInfo.getHostGroupName() + "%");
                }
            }
            return value;
        }

        @Override
        public Collection<String> getRequiredHostGroups(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            Collection<String> result = super.getRequiredHostGroups(propertyName, origValue, properties, topology);
            if (!result.isEmpty()) {
                return result;
            }
            Collection<String> matchingGroups = topology.getHostGroupsForComponent(this.component);
            int matchingGroupCount = matchingGroups.size();
            if (matchingGroupCount != 0) {
                return new HashSet<String>(matchingGroups);
            }
            Cardinality cardinality = topology.getBlueprint().getStack().getCardinality(this.component);
            if (!cardinality.isValidCount(0)) {
                LOG.warn("The property '{}' is associated with the component '{}' which isn't mapped to any host group. This may affect configuration topology resolution.", (Object)propertyName, (Object)this.component);
            }
            return Collections.emptySet();
        }

        private boolean isComponentNameNode() {
            return this.component.equals("NAMENODE");
        }

        private boolean isComponentSecondaryNameNode() {
            return this.component.equals("SECONDARY_NAMENODE");
        }

        private boolean isComponentResourceManager() {
            return this.component.equals("RESOURCEMANAGER");
        }

        private boolean isComponentOozieServer() {
            return this.component.equals("OOZIE_SERVER");
        }

        private boolean isComponentHiveServer() {
            return this.component.equals("HIVE_SERVER");
        }

        private boolean isComponentHiveMetaStoreServer() {
            return this.component.equals("HIVE_METASTORE");
        }

        private boolean isRangerAdmin() {
            return this.component.equals("RANGER_ADMIN");
        }

        private boolean isComponentHistoryServer() {
            return this.component.equals("HISTORYSERVER");
        }

        private boolean isComponentAppTimelineServer() {
            return this.component.equals("APP_TIMELINE_SERVER");
        }

        public String getComponentName() {
            return this.component;
        }
    }

    private static class OriginalValuePropertyUpdater
    implements PropertyUpdater {
        private OriginalValuePropertyUpdater() {
        }

        @Override
        public String updateForClusterCreate(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            return origValue;
        }

        @Override
        public Collection<String> getRequiredHostGroups(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            return Collections.emptySet();
        }
    }

    public static interface PropertyUpdater {
        public String updateForClusterCreate(String var1, String var2, Map<String, Map<String, String>> var3, ClusterTopology var4);

        default public String updateForBlueprintExport(String propertyName, String value, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            return value;
        }

        public Collection<String> getRequiredHostGroups(String var1, String var2, Map<String, Map<String, String>> var3, ClusterTopology var4);

        public static PropertyUpdater defaultUpdater() {
            return HostGroupUpdater.INSTANCE;
        }
    }

    protected static class MultipleHostTopologyUpdater
    implements PropertyUpdater {
        private static final Character DEFAULT_SEPARATOR = Character.valueOf(',');
        private final String component;
        private final Character separator;
        private final boolean usePrefixForEachHost;
        private final boolean useSuffixForEachHost;
        private final boolean usePortForEachHost;

        public MultipleHostTopologyUpdater(String component) {
            this(component, DEFAULT_SEPARATOR, false, false, true);
        }

        public MultipleHostTopologyUpdater(String component, Character separator, boolean usePrefixForEachHost, boolean useSuffixForEachHost, boolean usePortForEachHost) {
            this.component = component;
            this.separator = separator;
            this.usePrefixForEachHost = usePrefixForEachHost;
            this.useSuffixForEachHost = useSuffixForEachHost;
            this.usePortForEachHost = usePortForEachHost;
        }

        @Override
        public String updateForClusterCreate(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            if (!origValue.contains("%HOSTGROUP") && !origValue.contains(BlueprintConfigurationProcessor.LOCALHOST)) {
                return origValue;
            }
            Collection<String> hostStrings = BlueprintConfigurationProcessor.getHostStrings(origValue, topology);
            hostStrings.addAll(this.getHostStringsFromLocalhost(origValue, topology));
            return this.resolveHostGroupPlaceholder(origValue, hostStrings);
        }

        @Override
        public String updateForBlueprintExport(String propertyName, String value, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            for (HostGroupInfo groupInfo : topology.getHostGroupInfo().values()) {
                Collection<String> hosts = groupInfo.getHostNames();
                for (String host : hosts) {
                    value = value.replaceAll(host + "\\b", "%HOSTGROUP::" + groupInfo.getHostGroupName() + "%");
                }
            }
            return value;
        }

        private String getPrefix(String value) {
            Matcher localhostMatcher = LOCALHOST_PORT_REGEX.matcher(value);
            Matcher hostGroupMatcher = HOSTGROUP_PORT_REGEX.matcher(value);
            String prefixCandidate = null;
            if (localhostMatcher.find()) {
                prefixCandidate = value.substring(0, localhostMatcher.start());
            } else if (hostGroupMatcher.find()) {
                prefixCandidate = value.substring(0, hostGroupMatcher.start());
            } else {
                return prefixCandidate;
            }
            if (prefixCandidate.startsWith("[")) {
                prefixCandidate = prefixCandidate.substring(1);
            }
            if (prefixCandidate.startsWith("'")) {
                prefixCandidate = prefixCandidate.substring(1);
            }
            return prefixCandidate;
        }

        private String getSuffix(String value) {
            int indexOfEnd;
            Matcher localhostMatcher = LOCALHOST_PORT_REGEX.matcher(value);
            Matcher hostGroupMatcher = HOSTGROUP_PORT_REGEX.matcher(value);
            Matcher activeMatcher = null;
            if (localhostMatcher.find()) {
                activeMatcher = localhostMatcher;
            } else if (hostGroupMatcher.find()) {
                activeMatcher = hostGroupMatcher;
            } else {
                return null;
            }
            String suffixCandidate = null;
            do {
                indexOfEnd = activeMatcher.end();
            } while (activeMatcher.find());
            suffixCandidate = value.substring(indexOfEnd);
            if (suffixCandidate.endsWith("]")) {
                suffixCandidate = suffixCandidate.substring(0, suffixCandidate.length() - 1);
            }
            if (suffixCandidate.endsWith("'")) {
                suffixCandidate = suffixCandidate.substring(0, suffixCandidate.length() - 1);
            }
            return suffixCandidate;
        }

        /*
         * WARNING - void declaration
         */
        private Collection<String> getHostStringsFromLocalhost(String origValue, ClusterTopology topology) {
            HashSet<String> hostStrings = new HashSet<String>();
            if (origValue.contains(BlueprintConfigurationProcessor.LOCALHOST)) {
                Matcher localhostMatcher = LOCALHOST_PORT_REGEX.matcher(origValue);
                String port = null;
                if (localhostMatcher.find()) {
                    port = MultipleHostTopologyUpdater.calculatePort(localhostMatcher.group());
                }
                for (String string : topology.getHostAssignmentsForComponent(this.component)) {
                    void var7_7;
                    if (port != null) {
                        String string2 = string + ":" + port;
                    }
                    hostStrings.add((String)var7_7);
                }
            }
            return hostStrings;
        }

        protected String resolveHostGroupPlaceholder(String originalValue, Collection<String> hostStrings) {
            String prefix = this.getPrefix(originalValue);
            String suffix = this.getSuffix(originalValue);
            String port = this.removePorts(hostStrings);
            String sep = (this.useSuffixForEachHost ? suffix : "") + this.separator + (this.usePrefixForEachHost ? prefix : "");
            String combinedHosts = (this.usePrefixForEachHost ? prefix : "") + StringUtils.join(hostStrings, (String)sep);
            return (this.usePrefixForEachHost ? "" : prefix) + combinedHosts + (String)(this.usePortForEachHost || port == null ? "" : ":" + port) + suffix;
        }

        private String removePorts(Collection<String> hostStrings) {
            String port = null;
            if (!this.usePortForEachHost && !hostStrings.isEmpty()) {
                HashSet<String> temp = new HashSet<String>();
                Iterator<String> i = hostStrings.iterator();
                do {
                    port = MultipleHostTopologyUpdater.calculatePort(i.next());
                } while (i.hasNext() && port == null);
                if (port != null) {
                    for (String host : hostStrings) {
                        temp.add(host.replace(":" + port, ""));
                    }
                }
                hostStrings.clear();
                hostStrings.addAll(temp);
            }
            return port;
        }

        private static String calculatePort(String origValue) {
            if (origValue.contains(":")) {
                return origValue.substring(origValue.indexOf(":") + 1);
            }
            return null;
        }

        @Override
        public Collection<String> getRequiredHostGroups(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            HashSet<String> requiredHostGroups = new HashSet<String>();
            Matcher m = HOSTGROUP_PORT_REGEX.matcher(origValue);
            while (m.find()) {
                String groupName = m.group(1);
                if (!topology.getBlueprint().getHostGroups().containsKey(groupName)) {
                    throw new IllegalArgumentException("Unable to match blueprint host group token to a host group: " + groupName);
                }
                requiredHostGroups.add(groupName);
            }
            if (requiredHostGroups.isEmpty()) {
                requiredHostGroups.addAll(topology.getHostGroupsForComponent(this.component));
            }
            return requiredHostGroups;
        }
    }

    private static class DependencyEqualsFilter
    extends DependencyFilter {
        private final String value;

        DependencyEqualsFilter(String dependsOnPropertyName, String dependsOnConfigType, String value) {
            super(dependsOnPropertyName, dependsOnConfigType);
            this.value = value;
        }

        @Override
        public boolean isConditionSatisfied(String propertyName, String propertyValue, String propertyType) {
            return this.value.equals(propertyValue);
        }
    }

    private static class DependencyNotEqualsFilter
    extends DependencyFilter {
        private final String value;

        DependencyNotEqualsFilter(String dependsOnPropertyName, String dependsOnConfigType, String value) {
            super(dependsOnPropertyName, dependsOnConfigType);
            this.value = value;
        }

        @Override
        public boolean isConditionSatisfied(String propertyName, String propertyValue, String propertyType) {
            return !this.value.equals(propertyValue);
        }
    }

    private static class ConditionalPropertyFilter
    implements PropertyFilter {
        private final String propertyName;
        private final String propertyValue;
        private final String configType;

        public ConditionalPropertyFilter(String configType, String propertyName, String propertyValue) {
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
            this.configType = configType;
        }

        @Override
        public boolean isPropertyIncluded(String propertyName, String propertyValue, String configType, ClusterTopology topology) {
            return !configType.equals(this.configType) || !propertyName.equals(this.propertyName) || !propertyValue.equals(this.propertyValue);
        }
    }

    private static class HDFSNameNodeHAFilter
    implements PropertyFilter {
        private final Set<String> setOfHDFSPropertyNamesNonHA = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("dfs.namenode.http-address", "dfs.namenode.https-address", "dfs.namenode.rpc-address")));

        private HDFSNameNodeHAFilter() {
        }

        @Override
        public boolean isPropertyIncluded(String propertyName, String propertyValue, String configType, ClusterTopology topology) {
            return !topology.isNameNodeHAEnabled() || !this.setOfHDFSPropertyNamesNonHA.contains(propertyName);
        }
    }

    private static class HawqHAFilter
    implements PropertyFilter {
        private final Set<String> setOfHawqPropertyNamesNonHA = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("hawq_standby_address_host")));

        private HawqHAFilter() {
        }

        @Override
        public boolean isPropertyIncluded(String propertyName, String propertyValue, String configType, ClusterTopology topology) {
            int matchingGroupCount = topology.getHostGroupsForComponent(BlueprintConfigurationProcessor.HAWQSTANDBY).size();
            return matchingGroupCount != 0 || !this.setOfHawqPropertyNamesNonHA.contains(propertyName);
        }
    }

    @Deprecated
    private static class OptionalSingleHostTopologyUpdater
    extends SingleHostTopologyUpdater {
        public OptionalSingleHostTopologyUpdater(String component) {
            super(component);
        }

        @Override
        public String updateForClusterCreate(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            try {
                return super.updateForClusterCreate(propertyName, origValue, properties, topology);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.warn("Error while updating property [{}] with original value [{}]. Exception message: {}", new Object[]{propertyName, origValue, illegalArgumentException.getMessage()});
                return origValue;
            }
        }

        @Override
        public Collection<String> getRequiredHostGroups(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            try {
                return super.getRequiredHostGroups(propertyName, origValue, properties, topology);
            }
            catch (IllegalArgumentException e) {
                return Collections.emptySet();
            }
        }
    }

    private static class DBTopologyUpdater
    extends SingleHostTopologyUpdater {
        private final String configPropertyType;
        private final String conditionalPropertyName;

        private DBTopologyUpdater(String component, String conditionalPropertyType, String conditionalPropertyName) {
            super(component);
            this.configPropertyType = conditionalPropertyType;
            this.conditionalPropertyName = conditionalPropertyName;
        }

        @Override
        public String updateForClusterCreate(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            if (this.isDatabaseManaged(properties)) {
                return super.updateForClusterCreate(propertyName, origValue, properties, topology);
            }
            return origValue;
        }

        @Override
        public String updateForBlueprintExport(String propertyName, String value, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            if (this.isDatabaseManaged(properties)) {
                return super.updateForBlueprintExport(propertyName, value, properties, topology);
            }
            return value;
        }

        @Override
        public Collection<String> getRequiredHostGroups(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            if (this.isDatabaseManaged(properties)) {
                return super.getRequiredHostGroups(propertyName, origValue, properties, topology);
            }
            return Collections.emptySet();
        }

        private boolean isDatabaseManaged(Map<String, Map<String, String>> properties) {
            Map<String, String> configMap = properties.get(this.configPropertyType);
            if (configMap == null) {
                LOG.warn("Config map is null for property type: {}", (Object)this.configPropertyType);
                return false;
            }
            String conditionalValue = configMap.get(this.conditionalPropertyName);
            if (conditionalValue == null) {
                LOG.warn("Conditional value is null for property name: {}", (Object)this.conditionalPropertyName);
                return false;
            }
            boolean isManaged = conditionalValue.startsWith("New");
            LOG.info("Database managed status: {} for value: {}", (Object)isManaged, (Object)conditionalValue);
            return isManaged;
        }
    }

    private static class TempletonHivePropertyUpdater
    implements PropertyUpdater {
        private Map<String, PropertyUpdater> mapOfKeysToUpdaters = new HashMap<String, PropertyUpdater>();

        TempletonHivePropertyUpdater() {
            this.mapOfKeysToUpdaters.put("hive.metastore.uris", new MultipleHostTopologyUpdater("HIVE_METASTORE", Character.valueOf(','), true, false, true));
        }

        @Override
        public String updateForClusterCreate(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            if (!origValue.contains("%HOSTGROUP") && !origValue.contains(BlueprintConfigurationProcessor.LOCALHOST)) {
                return origValue;
            }
            StringBuilder updatedResult = new StringBuilder();
            String[] keyValuePairs = origValue.split(",");
            boolean firstValue = true;
            for (String keyValuePair : keyValuePairs) {
                keyValuePair = keyValuePair.trim();
                if (!firstValue) {
                    updatedResult.append(",");
                } else {
                    firstValue = false;
                }
                String key = keyValuePair.split("=")[0].trim();
                if (this.mapOfKeysToUpdaters.containsKey(key)) {
                    String result = this.mapOfKeysToUpdaters.get(key).updateForClusterCreate(key, keyValuePair.split("=")[1].trim(), properties, topology);
                    updatedResult.append(key);
                    updatedResult.append("=");
                    updatedResult.append(result.replaceAll(",", Matcher.quoteReplacement("\\,")));
                    continue;
                }
                updatedResult.append(keyValuePair);
            }
            return updatedResult.toString();
        }

        @Override
        public Collection<String> getRequiredHostGroups(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            String[] keyValuePairs;
            if (!origValue.contains("%HOSTGROUP") && !origValue.contains(BlueprintConfigurationProcessor.LOCALHOST)) {
                return Collections.emptySet();
            }
            HashSet<String> requiredGroups = new HashSet<String>();
            for (String keyValuePair : keyValuePairs = origValue.split(",")) {
                String key = keyValuePair.split("=")[0];
                if (!this.mapOfKeysToUpdaters.containsKey(key)) continue;
                requiredGroups.addAll(this.mapOfKeysToUpdaters.get(key).getRequiredHostGroups(propertyName, keyValuePair.split("=")[1], properties, topology));
            }
            return requiredGroups;
        }
    }

    static class YamlMultiValuePropertyDecorator
    extends AbstractPropertyValueDecorator {
        private static Pattern REGEX_IN_BRACKETS = Pattern.compile("\\s*\\[(?<INNER>.*)\\]\\s*");
        private static Pattern REGEX_IN_QUOTES = Pattern.compile("\\s*'(?<INNER>.*)'\\s*");
        private final FlowStyle flowStyle;

        public YamlMultiValuePropertyDecorator(PropertyUpdater propertyUpdater) {
            this(propertyUpdater, FlowStyle.SINGLE_QUOTED);
        }

        protected YamlMultiValuePropertyDecorator(PropertyUpdater propertyUpdater, FlowStyle flowStyle) {
            super(propertyUpdater);
            this.flowStyle = flowStyle;
        }

        @Override
        public String doFormat(String origValue) {
            StringBuilder sb = new StringBuilder();
            Matcher m = REGEX_IN_BRACKETS.matcher(origValue);
            if (m.matches()) {
                origValue = m.group("INNER");
            }
            if (origValue != null) {
                sb.append("[");
                boolean isFirst = true;
                for (String value : origValue.split(",")) {
                    m = REGEX_IN_QUOTES.matcher(value);
                    if (m.matches()) {
                        value = m.group("INNER");
                    }
                    if (!isFirst) {
                        sb.append(",");
                    } else {
                        isFirst = false;
                    }
                    if (this.flowStyle == FlowStyle.SINGLE_QUOTED) {
                        sb.append("'");
                    }
                    sb.append(value);
                    if (this.flowStyle != FlowStyle.SINGLE_QUOTED) continue;
                    sb.append("'");
                }
                sb.append("]");
            }
            return sb.toString();
        }

        static enum FlowStyle {
            SINGLE_QUOTED,
            PLAIN;

        }
    }

    static class HostGroupUpdater
    implements PropertyUpdater {
        static final HostGroupUpdater INSTANCE = new HostGroupUpdater();

        HostGroupUpdater() {
        }

        @Override
        public String updateForClusterCreate(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            if (origValue == null) {
                LOG.info("Property {} is null, skipping search for host group placeholder", (Object)propertyName);
                return null;
            }
            HostGroups hostGroups = new HostGroups(topology, propertyName);
            LinkedList<Pair> replacements = new LinkedList<Pair>();
            Matcher m = HostGroup.HOSTGROUP_REGEX.matcher(origValue);
            while (m.find()) {
                String replacement = hostGroups.getHost(m.group(1));
                int from = m.start();
                int to = m.end();
                replacements.add(Pair.of((Object)Pair.of((Object)from, (Object)to), (Object)replacement));
            }
            StringBuilder newValue = new StringBuilder(origValue);
            Iterator it = replacements.descendingIterator();
            while (it.hasNext()) {
                Pair replacement = (Pair)it.next();
                int from = (Integer)((Pair)replacement.getLeft()).getLeft();
                int to = (Integer)((Pair)replacement.getLeft()).getRight();
                String replacementValue = (String)replacement.getRight();
                newValue.replace(from, to, replacementValue);
            }
            return newValue.toString();
        }

        @Override
        public Collection<String> getRequiredHostGroups(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            if (origValue == null) {
                LOG.info("Property {} is null, skipping search for host group placeholder", (Object)propertyName);
                return Collections.emptyList();
            }
            Matcher m = HostGroup.HOSTGROUP_REGEX.matcher(origValue);
            HashSet<String> hostGroups = new HashSet<String>();
            while (m.find()) {
                hostGroups.add(m.group(1));
            }
            return hostGroups;
        }

        static class HostGroups {
            private ClusterTopology topology;
            private String propertyName;
            private Set<String> hostGroupsUsed = new HashSet<String>();

            HostGroups(ClusterTopology topology, String propertyName) {
                this.topology = topology;
                this.propertyName = propertyName;
            }

            String getHost(String hostGroup) {
                Preconditions.checkState((!this.hostGroupsUsed.contains(hostGroup) ? 1 : 0) != 0, (String)"Multiple occurrence of host group [%s] in property value of: [%s].", (Object)hostGroup, (Object)this.propertyName);
                HostGroupInfo hostGroupInfo = this.topology.getHostGroupInfo().get(hostGroup);
                Preconditions.checkArgument((null != hostGroupInfo ? 1 : 0) != 0, (String)"Encountered a host group token in configuration which couldn't be matched to a host group: %s", (Object)hostGroup);
                if (hostGroupInfo.getHostNames().size() > 1) {
                    LOG.warn("Host group {} contains multiple hosts. Using {} with such host groups may result in unintended configuration.", (Object)hostGroup, (Object)HostGroupUpdater.class.getSimpleName());
                }
                this.hostGroupsUsed.add(hostGroup);
                return hostGroupInfo.getHostNames().iterator().next();
            }
        }
    }

    private static abstract class DependencyFilter
    implements PropertyFilter {
        private final String dependsOnPropertyName;
        private final String dependsOnConfigType;

        DependencyFilter(String dependsOnPropertyName, String dependsOnConfigType) {
            this.dependsOnPropertyName = dependsOnPropertyName;
            this.dependsOnConfigType = dependsOnConfigType;
        }

        @Override
        public boolean isPropertyIncluded(String propertyName, String propertyValue, String configType, ClusterTopology topology) {
            Set<PropertyDependencyInfo> dependencyInfos;
            Stack stack = topology.getBlueprint().getStack();
            Configuration configuration = topology.getConfiguration();
            String serviceName = stack.getServiceForConfigType(configType);
            Map<String, Stack.ConfigProperty> typeProperties = stack.getConfigurationPropertiesWithMetadata(serviceName, configType);
            Stack.ConfigProperty configProperty = typeProperties.get(propertyName);
            if (configProperty != null && (dependencyInfos = configProperty.getDependsOnProperties()) != null) {
                for (PropertyDependencyInfo propertyDependencyInfo : dependencyInfos) {
                    if (!propertyDependencyInfo.getName().equals(this.dependsOnPropertyName) || !propertyDependencyInfo.getType().equals(this.dependsOnConfigType)) continue;
                    Map<String, Map<String, String>> clusterConfig = configuration.getFullProperties();
                    Map<String, String> configByType = clusterConfig.get(this.dependsOnConfigType);
                    return this.isConditionSatisfied(this.dependsOnPropertyName, configByType.get(this.dependsOnPropertyName), this.dependsOnConfigType);
                }
            }
            return true;
        }

        public abstract boolean isConditionSatisfied(String var1, String var2, String var3);
    }

    private static abstract class NonTopologyUpdater
    implements PropertyUpdater {
        private NonTopologyUpdater() {
        }

        @Override
        public Collection<String> getRequiredHostGroups(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            return Collections.emptyList();
        }
    }

    private static abstract class AbstractPropertyValueDecorator
    implements PropertyUpdater {
        PropertyUpdater propertyUpdater;

        public AbstractPropertyValueDecorator(PropertyUpdater propertyUpdater) {
            this.propertyUpdater = propertyUpdater;
        }

        @Override
        public String updateForClusterCreate(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            if (this.isFQDNValue(origValue)) {
                return origValue;
            }
            return this.doFormat(this.propertyUpdater.updateForClusterCreate(propertyName, origValue, properties, topology));
        }

        @Override
        public String updateForBlueprintExport(String propertyName, String value, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            return this.doFormat(this.propertyUpdater.updateForBlueprintExport(propertyName, value, properties, topology));
        }

        public abstract String doFormat(String var1);

        @Override
        public Collection<String> getRequiredHostGroups(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
            return this.propertyUpdater.getRequiredHostGroups(propertyName, origValue, properties, topology);
        }

        public boolean isFQDNValue(String value) {
            return !value.contains("%HOSTGROUP") && !value.contains(BlueprintConfigurationProcessor.LOCALHOST);
        }
    }
}

