/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.utilities.PredicateHelper;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseProvider {
    private final Set<String> propertyIds;
    private final Set<String> categoryIds;
    private final Set<String> combinedIds;
    private final Map<String, Pattern> patterns;
    private static final Logger LOG = LoggerFactory.getLogger(BaseProvider.class);
    private static final Pattern METRIC_ARGUMENT_METHOD_REPLACEMENT = Pattern.compile("\\$\\d+(\\.\\S+\\(\\S+\\))*");

    public BaseProvider(Set<String> propertyIds) {
        this.propertyIds = new HashSet<String>(propertyIds);
        this.categoryIds = PropertyHelper.getCategories(propertyIds);
        this.combinedIds = new HashSet<String>(propertyIds);
        this.combinedIds.addAll(this.categoryIds);
        this.patterns = new HashMap<String, Pattern>();
        for (String id : this.combinedIds) {
            if (!this.containsArguments(id)) continue;
            String pattern = METRIC_ARGUMENT_METHOD_REPLACEMENT.matcher(id).replaceAll("(\\\\S*)");
            this.patterns.put(id, Pattern.compile(pattern));
        }
    }

    protected Set<String> checkConfigPropertyIds(Set<String> base, String configCategory) {
        if (0 == base.size()) {
            return base;
        }
        HashSet<String> unsupported = new HashSet<String>();
        for (String propertyId : base) {
            if (propertyId.startsWith(configCategory + "/desired_config")) continue;
            unsupported.add(propertyId);
        }
        return unsupported;
    }

    public Set<String> checkPropertyIds(Set<String> propertyIds) {
        if (!this.propertyIds.containsAll(propertyIds)) {
            HashSet<String> unsupportedPropertyIds = new HashSet<String>(propertyIds);
            unsupportedPropertyIds.removeAll(this.combinedIds);
            HashSet<String> categoryProperties = new HashSet<String>();
            for (String unsupportedPropertyId : unsupportedPropertyIds) {
                if (!this.checkCategory(unsupportedPropertyId) && !this.checkRegExp(unsupportedPropertyId)) continue;
                categoryProperties.add(unsupportedPropertyId);
            }
            unsupportedPropertyIds.removeAll(categoryProperties);
            return unsupportedPropertyIds;
        }
        return Collections.emptySet();
    }

    protected Set<String> getRequestPropertyIds(Request request, Predicate predicate) {
        Set<String> propertyIds = request.getPropertyIds();
        if (propertyIds == null || propertyIds.isEmpty()) {
            return new HashSet<String>(this.propertyIds);
        }
        propertyIds = new HashSet<String>(propertyIds);
        if (predicate != null) {
            propertyIds.addAll(PredicateHelper.getPropertyIds(predicate));
        }
        if (!this.combinedIds.containsAll(propertyIds)) {
            HashSet<String> keepers = new HashSet<String>();
            HashSet<String> unsupportedPropertyIds = new HashSet<String>(propertyIds);
            unsupportedPropertyIds.removeAll(this.combinedIds);
            for (String unsupportedPropertyId : unsupportedPropertyIds) {
                if (!this.checkCategory(unsupportedPropertyId) && !this.checkRegExp(unsupportedPropertyId)) continue;
                keepers.add(unsupportedPropertyId);
            }
            propertyIds.retainAll(this.combinedIds);
            propertyIds.addAll(keepers);
        }
        return propertyIds;
    }

    protected boolean checkCategory(String unsupportedPropertyId) {
        String category = PropertyHelper.getPropertyCategory(unsupportedPropertyId);
        while (category != null) {
            if (this.propertyIds.contains(category)) {
                return true;
            }
            category = PropertyHelper.getPropertyCategory(category);
        }
        return false;
    }

    private boolean checkRegExp(String unsupportedPropertyId) {
        for (Pattern pattern : this.patterns.values()) {
            Matcher matcher = pattern.matcher(unsupportedPropertyId);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    protected Map.Entry<String, Pattern> getRegexEntry(String id) {
        Map.Entry<String, Pattern> regexEntry = null;
        for (Map.Entry<String, Pattern> entry : this.patterns.entrySet()) {
            Pattern pattern = entry.getValue();
            Matcher matcher = pattern.matcher(id);
            if (!matcher.matches()) continue;
            String key = entry.getKey();
            if (regexEntry != null && !key.startsWith(regexEntry.getKey())) continue;
            regexEntry = entry;
        }
        return regexEntry;
    }

    protected List<String> getRegexGroups(String regExpKey, String id) {
        Matcher matcher;
        Pattern pattern = this.patterns.get(regExpKey);
        ArrayList<String> regexGroups = new ArrayList<String>();
        if (pattern != null && (matcher = pattern.matcher(id)).matches()) {
            for (int i = 0; i < matcher.groupCount(); ++i) {
                regexGroups.add(matcher.group(i + 1));
            }
        }
        return regexGroups;
    }

    protected boolean isPatternKey(String id) {
        return this.patterns.containsKey(id);
    }

    protected boolean containsArguments(String propertyId) {
        return PropertyHelper.containsArguments(propertyId);
    }

    protected static boolean isPropertyRequested(String propertyId, Set<String> requestedIds) {
        return requestedIds.contains(propertyId) || BaseProvider.isPropertyCategoryRequested(propertyId, requestedIds) || BaseProvider.isPropertyEntryRequested(propertyId, requestedIds);
    }

    protected static boolean setResourceProperty(Resource resource, String propertyId, Object value, Set<String> requestedIds) {
        boolean contains;
        boolean bl = contains = requestedIds.contains(propertyId) || BaseProvider.isPropertyCategoryRequested(propertyId, requestedIds);
        if (contains) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting property for resource, resourceType={}, propertyId={}, value={}", new Object[]{resource.getType(), propertyId, value});
            }
            if (!BaseProvider.setResourceMapProperty(resource, propertyId, value)) {
                resource.setProperty(propertyId, value);
            }
        } else {
            if (value instanceof Map) {
                Map mapValue = (Map)value;
                for (Map.Entry entry : mapValue.entrySet()) {
                    Object entryValue;
                    String entryPropertyId = PropertyHelper.getPropertyId(propertyId, entry.getKey().toString());
                    contains = BaseProvider.setResourceProperty(resource, entryPropertyId, entryValue = entry.getValue(), requestedIds) || contains;
                }
            }
            if (!contains && LOG.isDebugEnabled()) {
                LOG.debug("Skipping property for resource as not in requestedIds, resourceType={}, propertyId={}, value={}", new Object[]{resource.getType(), propertyId, value});
            }
        }
        return contains;
    }

    private static boolean setResourceMapProperty(Resource resource, String propertyId, Object value) {
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            if (mapValue.isEmpty()) {
                resource.addCategory(propertyId);
            } else {
                for (Map.Entry entry : mapValue.entrySet()) {
                    Object entryValue;
                    String entryPropertyId = PropertyHelper.getPropertyId(propertyId, entry.getKey().toString());
                    if (BaseProvider.setResourceMapProperty(resource, entryPropertyId, entryValue = entry.getValue())) continue;
                    resource.setProperty(entryPropertyId, entryValue);
                }
            }
            return true;
        }
        return false;
    }

    protected static boolean isPropertyEntryRequested(String propertyId, Set<String> requestedIds) {
        for (String requestedId : requestedIds) {
            if (!requestedId.startsWith(propertyId)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isPropertyCategoryRequested(String propertyId, Set<String> requestedIds) {
        String category = PropertyHelper.getPropertyCategory(propertyId);
        while (category != null) {
            if (requestedIds.contains(category)) {
                return true;
            }
            category = PropertyHelper.getPropertyCategory(category);
        }
        return false;
    }

    public Set<String> getPropertyIds() {
        return this.propertyIds;
    }

    public Set<String> getCategoryIds() {
        return this.categoryIds;
    }
}

