/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.api.predicate.InvalidQueryException;
import id.onyx.obdp.server.api.predicate.QueryLexer;
import id.onyx.obdp.server.api.predicate.Token;
import id.onyx.obdp.server.controller.internal.ProvisionAction;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceProvider;
import id.onyx.obdp.server.controller.utilities.ClusterControllerHelper;
import id.onyx.obdp.server.topology.Blueprint;
import id.onyx.obdp.server.topology.BlueprintFactory;
import id.onyx.obdp.server.topology.Configuration;
import id.onyx.obdp.server.topology.HostGroupInfo;
import id.onyx.obdp.server.topology.InvalidTopologyTemplateException;
import id.onyx.obdp.server.topology.SecurityConfiguration;
import id.onyx.obdp.server.topology.TopologyRequest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class BaseClusterRequest
implements TopologyRequest {
    public static final String PROVISION_ACTION_PROPERTY = "provision_action";
    protected final Map<String, HostGroupInfo> hostGroupInfoMap = new HashMap<String, HostGroupInfo>();
    protected ProvisionAction provisionAction;
    protected Long clusterId;
    protected Blueprint blueprint;
    protected Configuration configuration;
    protected SecurityConfiguration securityConfiguration;
    protected static BlueprintFactory blueprintFactory;
    private static final QueryLexer queryLexer;
    private static ResourceProvider hostResourceProvider;

    public static void init(BlueprintFactory factory) {
        blueprintFactory = factory;
    }

    @Override
    public Long getClusterId() {
        return this.clusterId;
    }

    @Override
    public Blueprint getBlueprint() {
        return this.blueprint;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Map<String, HostGroupInfo> getHostGroupInfo() {
        return this.hostGroupInfoMap;
    }

    protected void validateHostPredicateProperties(String predicate) throws InvalidTopologyTemplateException {
        Token[] tokens;
        try {
            tokens = queryLexer.tokens(predicate);
        }
        catch (InvalidQueryException e) {
            throw new InvalidTopologyTemplateException(String.format("The specified host query is invalid: %s", e.getMessage()));
        }
        HashSet<String> propertyIds = new HashSet<String>();
        for (Token token : tokens) {
            if (token.getType() != Token.TYPE.PROPERTY_OPERAND) continue;
            propertyIds.add(token.getValue());
        }
        Set<String> invalidProperties = BaseClusterRequest.ensureHostProvider().checkPropertyIds(propertyIds);
        if (!invalidProperties.isEmpty()) {
            throw new InvalidTopologyTemplateException(String.format("Invalid Host Predicate.  The following properties are not valid for a host predicate: %s", invalidProperties));
        }
    }

    protected void setBlueprint(Blueprint blueprint) {
        this.blueprint = blueprint;
    }

    protected void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    protected BlueprintFactory getBlueprintFactory() {
        return blueprintFactory;
    }

    public SecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    private static synchronized ResourceProvider ensureHostProvider() {
        if (hostResourceProvider == null) {
            hostResourceProvider = ClusterControllerHelper.getClusterController().ensureResourceProvider(Resource.Type.Host);
        }
        return hostResourceProvider;
    }

    public ProvisionAction getProvisionAction() {
        return this.provisionAction;
    }

    public void setProvisionAction(ProvisionAction provisionAction) {
        this.provisionAction = provisionAction;
    }

    static {
        queryLexer = new QueryLexer();
    }
}

