/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.controller.internal.JsonHttpPropertyRequest;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.state.Cluster;
import java.util.Collections;
import java.util.Map;

public class AtlasServerHttpPropertyRequest
extends JsonHttpPropertyRequest {
    private static final String PROPERTY_ENABLE_TLS = "atlas.enableTLS";
    private static final String PROPERTY_SERVER_HTTPS_PORT = "atlas.server.https.port";
    private static final String PROPERTY_SERVER_HTTP_PORT = "atlas.server.http.port";
    private static final String CONFIG_APPLICATION_PROPERTIES = "application-properties";
    private static final String URL_TEMPLATE = "%s://%s:%s/api/atlas/admin/status";
    private static final Map<String, String> PROPERTY_MAPPINGS = Collections.singletonMap("Status", "HostRoles/ha_state");

    public AtlasServerHttpPropertyRequest() {
        super(PROPERTY_MAPPINGS);
    }

    @Override
    public String getUrl(Cluster cluster, String hostName) throws SystemException {
        Map<String, String> atlasConfig = cluster.getDesiredConfigByType(CONFIG_APPLICATION_PROPERTIES).getProperties();
        boolean useHttps = Boolean.parseBoolean(this.getConfigValue(atlasConfig, PROPERTY_ENABLE_TLS, "false"));
        String port = useHttps ? this.getConfigValue(atlasConfig, PROPERTY_SERVER_HTTPS_PORT, "21443") : this.getConfigValue(atlasConfig, PROPERTY_SERVER_HTTP_PORT, "21000");
        return String.format(URL_TEMPLATE, useHttps ? "https" : "http", hostName, port);
    }

    private String getConfigValue(Map<String, String> atlasConfig, String property, String defaultValue) {
        return atlasConfig.containsKey(property) ? atlasConfig.get(property) : defaultValue;
    }
}

