/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.gson.Gson;
import com.google.inject.Inject;
import id.onyx.obdp.server.DuplicateResourceException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ObjectNotFoundException;
import id.onyx.obdp.server.ParentObjectNotFoundException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.RequestImpl;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.orm.dao.ArtifactDAO;
import id.onyx.obdp.server.orm.entities.ArtifactEntity;
import id.onyx.obdp.server.state.Cluster;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class ArtifactResourceProvider
extends AbstractResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactResourceProvider.class);
    public static final String RESPONSE_KEY = "Artifacts";
    public static final String ARTIFACT_NAME = "artifact_name";
    public static final String CLUSTER_NAME = "cluster_name";
    public static final String SERVICE_NAME = "service_name";
    public static final String ARTIFACT_DATA_PROPERTY = "artifact_data";
    public static final String ARTIFACT_NAME_PROPERTY = "Artifacts/artifact_name";
    public static final String CLUSTER_NAME_PROPERTY = "Artifacts/cluster_name";
    public static final String SERVICE_NAME_PROPERTY = "Artifacts/service_name";
    public static final String KERBEROS_DESCRIPTOR = "kerberos_descriptor";
    private static final Set<String> pkPropertyIds = new HashSet<String>();
    private static final Map<Resource.Type, String> keyPropertyIds = new HashMap<Resource.Type, String>();
    private static final Set<String> propertyIds = new HashSet<String>();
    private static final Map<Resource.Type, TypeRegistration> typeRegistrations = new HashMap<Resource.Type, TypeRegistration>();
    private static final Map<String, TypeRegistration> typeRegistrationsByFK = new HashMap<String, TypeRegistration>();
    private static final Map<String, TypeRegistration> typeRegistrationsByShortFK = new HashMap<String, TypeRegistration>();
    private static final Gson jsonSerializer = new Gson();
    @Inject
    private static ArtifactDAO artifactDAO;

    @Inject
    protected ArtifactResourceProvider(OBDPManagementController controller) {
        super(propertyIds, keyPropertyIds);
        for (TypeRegistration typeRegistration : typeRegistrations.values()) {
            typeRegistration.setManagementController(controller);
        }
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return pkPropertyIds;
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        for (Map<String, Object> properties : request.getProperties()) {
            this.createResources(this.getCreateCommand(properties, request.getRequestInfoProperties()));
        }
        this.notifyCreate(Resource.Type.Artifact, request);
        return this.getRequestStatus(null);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Set<Map<String, Object>> requestProps = this.getPropertyMaps(predicate);
        LinkedHashSet<Resource> resources = new LinkedHashSet<Resource>();
        for (Map<String, Object> props : requestProps) {
            resources.addAll((Collection<Resource>)this.getResources(this.getGetCommand(request, predicate, props)));
        }
        if (resources.isEmpty() && this.isInstanceRequest(requestProps)) {
            throw new NoSuchResourceException("The requested resource doesn't exist: Artifact not found, " + predicate);
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        for (Resource resource : this.getResources(request, predicate)) {
            this.modifyResources(this.getUpdateCommand(request, resource));
        }
        this.notifyUpdate(Resource.Type.Artifact, request, predicate);
        return this.getRequestStatus(null);
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Set<Resource> setResources = this.getResources(new RequestImpl(null, null, null, null), predicate);
        for (Resource resource : setResources) {
            this.modifyResources(this.getDeleteCommand(resource));
        }
        this.notifyDelete(Resource.Type.Artifact, predicate);
        return this.getRequestStatus(null);
    }

    private AbstractResourceProvider.Command<Void> getCreateCommand(final Map<String, Object> properties, final Map<String, String> requestInfoProps) {
        return new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                ArtifactResourceProvider.this.validateParent(properties);
                String artifactName = String.valueOf(properties.get(ArtifactResourceProvider.ARTIFACT_NAME_PROPERTY));
                TreeMap<String, String> foreignKeyMap = ArtifactResourceProvider.this.createForeignKeyMap(properties);
                if (artifactDAO.findByNameAndForeignKeys(artifactName, foreignKeyMap) != null) {
                    throw new DuplicateResourceException(String.format("Attempted to create an artifact which already exists, artifact_name='%s', foreign_keys='%s'", artifactName, ArtifactResourceProvider.this.getRequestForeignKeys(properties)));
                }
                LOG.debug("Creating Artifact Resource with name '{}'. Parent information: {}", (Object)artifactName, ArtifactResourceProvider.this.getRequestForeignKeys(properties));
                artifactDAO.create(ArtifactResourceProvider.this.toEntity(properties, (String)requestInfoProps.get("RAW_REQUEST_BODY")));
                return null;
            }
        };
    }

    private AbstractResourceProvider.Command<Set<Resource>> getGetCommand(final Request request, final Predicate predicate, final Map<String, Object> properties) {
        return new AbstractResourceProvider.Command<Set<Resource>>(){

            @Override
            public Set<Resource> invoke() throws OBDPException {
                String name = (String)properties.get(ArtifactResourceProvider.ARTIFACT_NAME_PROPERTY);
                ArtifactResourceProvider.this.validateParent(properties);
                HashSet<Resource> matchingResources = new HashSet<Resource>();
                TreeMap<String, String> foreignKeys = ArtifactResourceProvider.this.createForeignKeyMap(properties);
                Set<String> requestPropertyIds = ArtifactResourceProvider.this.getRequestPropertyIds(request, predicate);
                if (name != null) {
                    Resource instance;
                    ArtifactEntity entity = artifactDAO.findByNameAndForeignKeys(name, foreignKeys);
                    if (entity != null && predicate.evaluate(instance = ArtifactResourceProvider.this.toResource(entity, requestPropertyIds))) {
                        matchingResources.add(instance);
                    }
                } else {
                    List<ArtifactEntity> results = artifactDAO.findByForeignKeys(foreignKeys);
                    for (ArtifactEntity entity : results) {
                        Resource resource = ArtifactResourceProvider.this.toResource(entity, requestPropertyIds);
                        if (!predicate.evaluate(resource)) continue;
                        matchingResources.add(resource);
                    }
                }
                return matchingResources;
            }
        };
    }

    private AbstractResourceProvider.Command<Void> getUpdateCommand(final Request request, final Resource resource) {
        return new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                HashMap<String, Object> entityUpdateProperties = new HashMap<String, Object>(request.getProperties().iterator().next());
                entityUpdateProperties.put(ArtifactResourceProvider.ARTIFACT_NAME_PROPERTY, String.valueOf(resource.getPropertyValue(ArtifactResourceProvider.ARTIFACT_NAME_PROPERTY)));
                artifactDAO.merge(ArtifactResourceProvider.this.toEntity(entityUpdateProperties, request.getRequestInfoProperties().get("RAW_REQUEST_BODY")));
                return null;
            }
        };
    }

    private AbstractResourceProvider.Command<Void> getDeleteCommand(final Resource resource) {
        return new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                TreeMap<String, String> artifactForeignKeys;
                HashMap<String, Object> keyProperties = new HashMap<String, Object>();
                for (Map.Entry<String, Object> entry : resource.getPropertiesMap().get(ArtifactResourceProvider.RESPONSE_KEY).entrySet()) {
                    keyProperties.put(String.format("Artifacts/%s", entry.getKey()), entry.getValue());
                }
                String artifactName = String.valueOf(resource.getPropertyValue(ArtifactResourceProvider.ARTIFACT_NAME_PROPERTY));
                ArtifactEntity entity = artifactDAO.findByNameAndForeignKeys(artifactName, artifactForeignKeys = ArtifactResourceProvider.this.createForeignKeyMap(keyProperties));
                if (entity != null) {
                    LOG.info("Deleting Artifact: name = {}, foreign keys = {}", (Object)entity.getArtifactName(), entity.getForeignKeys());
                    artifactDAO.remove(entity);
                } else {
                    LOG.info("Cannot find Artifact to delete, ignoring: name = {}, foreign keys = {}", (Object)artifactName, artifactForeignKeys);
                }
                return null;
            }
        };
    }

    private void validateParent(Map<String, Object> properties) throws OBDPException {
        Resource.Type parentType = this.getRequestType(properties);
        if (!typeRegistrations.get(parentType).instanceExists(keyPropertyIds, properties)) {
            throw new ParentObjectNotFoundException(String.format("Parent resource doesn't exist: %s", this.getRequestForeignKeys(properties)));
        }
    }

    private Resource.Type getRequestType(Map<String, Object> properties) throws OBDPException {
        Set<String> requestFKs = this.getRequestForeignKeys(properties).keySet();
        for (TypeRegistration registration : typeRegistrations.values()) {
            HashSet<String> typeFKs = new HashSet<String>(registration.getForeignKeyInfo().values());
            typeFKs.add(registration.getFKPropertyName());
            if (!requestFKs.equals(typeFKs)) continue;
            return registration.getType();
        }
        throw new OBDPException("Couldn't determine resource type based on request properties");
    }

    private Map<String, String> getRequestForeignKeys(Map<String, Object> properties) {
        HashMap<String, String> requestFKs = new HashMap<String, String>();
        for (String property : properties.keySet()) {
            if (property.equals(ARTIFACT_NAME_PROPERTY) || property.startsWith(ARTIFACT_DATA_PROPERTY)) continue;
            requestFKs.put(property, String.valueOf(properties.get(property)));
        }
        return requestFKs;
    }

    private ArtifactEntity toEntity(Map<String, Object> properties, String rawRequestBody) throws OBDPException {
        String name = (String)properties.get(ARTIFACT_NAME_PROPERTY);
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Artifact name must be provided");
        }
        ArtifactEntity artifact = new ArtifactEntity();
        artifact.setArtifactName(name);
        artifact.setForeignKeys(this.createForeignKeyMap(properties));
        Map rawBodyMap = (Map)jsonSerializer.fromJson(rawRequestBody, Map.class);
        Object artifactData = rawBodyMap.get(ARTIFACT_DATA_PROPERTY);
        if (artifactData == null) {
            throw new IllegalArgumentException("artifact_data property must be provided");
        }
        if (!(artifactData instanceof Map)) {
            throw new IllegalArgumentException("artifact_data property must be a map");
        }
        artifact.setArtifactData((Map)artifactData);
        return artifact;
    }

    private TreeMap<String, String> createForeignKeyMap(Map<String, Object> properties) throws OBDPException {
        TreeMap<String, String> foreignKeys = new TreeMap<String, String>();
        for (String keyProperty : keyPropertyIds.values()) {
            String origValue;
            if (keyProperty.equals(ARTIFACT_NAME_PROPERTY) || (origValue = (String)properties.get(keyProperty)) == null || origValue.isEmpty()) continue;
            TypeRegistration typeRegistration = typeRegistrationsByFK.get(keyProperty);
            foreignKeys.put(typeRegistration.getShortFKPropertyName(), typeRegistration.toPersistId(origValue));
        }
        return foreignKeys;
    }

    private Resource toResource(ArtifactEntity entity, Set<String> requestedIds) throws OBDPException {
        ResourceImpl resource = new ResourceImpl(Resource.Type.Artifact);
        ArtifactResourceProvider.setResourceProperty(resource, ARTIFACT_NAME_PROPERTY, entity.getArtifactName(), requestedIds);
        ArtifactResourceProvider.setResourceProperty(resource, ARTIFACT_DATA_PROPERTY, entity.getArtifactData(), requestedIds);
        for (Map.Entry<String, String> entry : entity.getForeignKeys().entrySet()) {
            TypeRegistration typeRegistration = typeRegistrationsByShortFK.get(entry.getKey());
            ArtifactResourceProvider.setResourceProperty(resource, typeRegistration.getFKPropertyName(), typeRegistration.fromPersistId(entry.getValue()), requestedIds);
        }
        return resource;
    }

    private boolean isInstanceRequest(Set<Map<String, Object>> requestProps) {
        return requestProps.size() == 1 && requestProps.iterator().next().get(ARTIFACT_NAME_PROPERTY) != null;
    }

    public static String toArtifactDataJson(Map<?, ?> properties) {
        return String.format("{ \"%s\": %s }", ARTIFACT_DATA_PROPERTY, jsonSerializer.toJson(properties));
    }

    static {
        propertyIds.add(ARTIFACT_NAME_PROPERTY);
        propertyIds.add(ARTIFACT_DATA_PROPERTY);
        pkPropertyIds.add(ARTIFACT_NAME_PROPERTY);
        keyPropertyIds.put(Resource.Type.Artifact, ARTIFACT_NAME_PROPERTY);
        ClusterTypeRegistration clusterTypeRegistration = new ClusterTypeRegistration();
        typeRegistrations.put(clusterTypeRegistration.getType(), clusterTypeRegistration);
        ServiceTypeRegistration serviceTypeRegistration = new ServiceTypeRegistration();
        typeRegistrations.put(serviceTypeRegistration.getType(), serviceTypeRegistration);
        for (TypeRegistration registration : typeRegistrations.values()) {
            String fkProperty = registration.getFKPropertyName();
            keyPropertyIds.put(registration.getType(), fkProperty);
            propertyIds.add(fkProperty);
            typeRegistrationsByFK.put(fkProperty, registration);
            typeRegistrationsByShortFK.put(registration.getShortFKPropertyName(), registration);
            for (Map.Entry<Resource.Type, String> ancestor : registration.getForeignKeyInfo().entrySet()) {
                Resource.Type ancestorType = ancestor.getKey();
                if (keyPropertyIds.containsKey(ancestorType)) continue;
                String ancestorFK = ancestor.getValue();
                keyPropertyIds.put(ancestorType, ancestorFK);
                propertyIds.add(ancestorFK);
            }
        }
    }

    public static interface TypeRegistration {
        public void setManagementController(OBDPManagementController var1);

        public Resource.Type getType();

        public String getFKPropertyName();

        public String getShortFKPropertyName();

        public String toPersistId(String var1) throws OBDPException;

        public String fromPersistId(String var1) throws OBDPException;

        public Map<Resource.Type, String> getForeignKeyInfo();

        public boolean instanceExists(Map<Resource.Type, String> var1, Map<String, Object> var2) throws OBDPException;
    }

    private static class ClusterTypeRegistration
    implements TypeRegistration {
        private OBDPManagementController controller = null;

        private ClusterTypeRegistration() {
        }

        @Override
        public void setManagementController(OBDPManagementController controller) {
            this.controller = controller;
        }

        @Override
        public Resource.Type getType() {
            return Resource.Type.Cluster;
        }

        @Override
        public String getFKPropertyName() {
            return ArtifactResourceProvider.CLUSTER_NAME_PROPERTY;
        }

        @Override
        public String getShortFKPropertyName() {
            return "cluster";
        }

        @Override
        public String toPersistId(String value) throws OBDPException {
            return String.valueOf(this.controller.getClusters().getCluster(value).getClusterId());
        }

        @Override
        public String fromPersistId(String value) throws OBDPException {
            return this.controller.getClusters().getClusterById(Long.parseLong(value)).getClusterName();
        }

        @Override
        public Map<Resource.Type, String> getForeignKeyInfo() {
            return Collections.emptyMap();
        }

        @Override
        public boolean instanceExists(Map<Resource.Type, String> keyMap, Map<String, Object> properties) throws OBDPException {
            try {
                String clusterName = String.valueOf(properties.get(ArtifactResourceProvider.CLUSTER_NAME_PROPERTY));
                this.controller.getClusters().getCluster(clusterName);
                return true;
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                return false;
            }
        }
    }

    private static class ServiceTypeRegistration
    implements TypeRegistration {
        private OBDPManagementController controller = null;

        private ServiceTypeRegistration() {
        }

        @Override
        public void setManagementController(OBDPManagementController controller) {
            this.controller = controller;
        }

        @Override
        public Resource.Type getType() {
            return Resource.Type.Service;
        }

        @Override
        public String getFKPropertyName() {
            return ArtifactResourceProvider.SERVICE_NAME_PROPERTY;
        }

        @Override
        public String getShortFKPropertyName() {
            return "service";
        }

        @Override
        public String toPersistId(String value) {
            return value;
        }

        @Override
        public String fromPersistId(String value) {
            return value;
        }

        @Override
        public Map<Resource.Type, String> getForeignKeyInfo() {
            return Collections.singletonMap(Resource.Type.Cluster, ArtifactResourceProvider.CLUSTER_NAME_PROPERTY);
        }

        @Override
        public boolean instanceExists(Map<Resource.Type, String> keyMap, Map<String, Object> properties) throws OBDPException {
            String clusterName = String.valueOf(properties.get(keyMap.get(Resource.Type.Cluster)));
            try {
                Cluster cluster = this.controller.getClusters().getCluster(clusterName);
                cluster.getService(String.valueOf(properties.get(ArtifactResourceProvider.SERVICE_NAME_PROPERTY)));
                return true;
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                return false;
            }
        }
    }
}

