/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppCookieManager {
    static final String HADOOP_AUTH = "hadoop.auth";
    private static final String HADOOP_AUTH_EQ = "hadoop.auth=";
    private static final String SET_COOKIE = "Set-Cookie";
    private static final EmptyJaasCredentials EMPTY_JAAS_CREDENTIALS = new EmptyJaasCredentials();
    private Map<String, String> endpointCookieMap = new ConcurrentHashMap<String, String>();
    private static final Logger LOG = LoggerFactory.getLogger(AppCookieManager.class);

    public static void main(String[] args) throws IOException {
        new AppCookieManager().getAppCookie(args[0], false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAppCookie(String endpoint, boolean refresh) throws IOException {
        String appCookie;
        HttpGet outboundRequest = new HttpGet(endpoint);
        URI uri = outboundRequest.getURI();
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        String path = uri.getPath();
        if (!refresh && (appCookie = this.endpointCookieMap.get(endpoint)) != null) {
            return appCookie;
        }
        this.clearAppCookie(endpoint);
        DefaultHttpClient client = new DefaultHttpClient();
        SPNegoSchemeFactory spNegoSF = new SPNegoSchemeFactory(true);
        client.getAuthSchemes().register("Negotiate", (AuthSchemeFactory)spNegoSF);
        client.getCredentialsProvider().setCredentials(new AuthScope(null, -1, null), (Credentials)EMPTY_JAAS_CREDENTIALS);
        Object hadoopAuthCookie = null;
        CloseableHttpResponse httpResponse = null;
        try {
            HttpHost httpHost = new HttpHost(host, port, scheme);
            HttpOptions httpRequest = new HttpOptions(path);
            httpResponse = client.execute(httpHost, (HttpRequest)httpRequest);
            Header[] headers = httpResponse.getHeaders(SET_COOKIE);
            hadoopAuthCookie = AppCookieManager.getHadoopAuthCookieValue(headers);
            if (hadoopAuthCookie == null) {
                LOG.error("SPNego authentication failed, can not get hadoop.auth cookie for URL: " + endpoint);
                throw new IOException("SPNego authentication failed, can not get hadoop.auth cookie");
            }
        }
        finally {
            HttpEntity entity;
            if (httpResponse != null && (entity = httpResponse.getEntity()) != null) {
                entity.getContent().close();
            }
        }
        hadoopAuthCookie = HADOOP_AUTH_EQ + AppCookieManager.quote((String)hadoopAuthCookie);
        this.setAppCookie(endpoint, (String)hadoopAuthCookie);
        if (LOG.isInfoEnabled()) {
            LOG.info("Successful SPNego authentication to URL:" + uri);
        }
        return hadoopAuthCookie;
    }

    public String getCachedAppCookie(String endpoint) {
        return this.endpointCookieMap.get(endpoint);
    }

    private void setAppCookie(String endpoint, String appCookie) {
        this.endpointCookieMap.put(endpoint, appCookie);
    }

    private void clearAppCookie(String endpoint) {
        this.endpointCookieMap.remove(endpoint);
    }

    static String quote(String s) {
        return s == null ? s : "\"" + s + "\"";
    }

    static String getHadoopAuthCookieValue(Header[] headers) {
        if (headers == null) {
            return null;
        }
        for (Header header : headers) {
            HeaderElement[] elements;
            for (HeaderElement element : elements = header.getElements()) {
                String trimmedVal;
                String cookieName = element.getName();
                if (!cookieName.equals(HADOOP_AUTH) || element.getValue() == null || (trimmedVal = element.getValue().trim()).isEmpty()) continue;
                return trimmedVal;
            }
        }
        return null;
    }

    private static class EmptyJaasCredentials
    implements Credentials {
        private EmptyJaasCredentials() {
        }

        public String getPassword() {
            return null;
        }

        public Principal getUserPrincipal() {
            return null;
        }
    }
}

