/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.internal.AbstractAuthorizedResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.BaseProvider;
import id.onyx.obdp.server.controller.internal.RequestImpl;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.notifications.DispatchFactory;
import id.onyx.obdp.server.notifications.NotificationDispatcher;
import id.onyx.obdp.server.notifications.TargetConfigurationResult;
import id.onyx.obdp.server.orm.dao.AlertDispatchDAO;
import id.onyx.obdp.server.orm.entities.AlertGroupEntity;
import id.onyx.obdp.server.orm.entities.AlertTargetEntity;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.state.AlertState;
import id.onyx.obdp.server.state.alert.AlertGroup;
import java.text.MessageFormat;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class AlertTargetResourceProvider
extends AbstractAuthorizedResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AlertTargetResourceProvider.class);
    public static final String ALERT_TARGET = "AlertTarget";
    public static final String ID_PROPERTY_ID = "id";
    public static final String NAME_PROPERTY_ID = "name";
    public static final String DESCRIPTION_PROPERTY_ID = "description";
    public static final String NOTIFICATION_TYPE_PROPERTY_ID = "notification_type";
    public static final String PROPERTIES_PROPERTY_ID = "properties";
    public static final String GROUPS_PROPERTY_ID = "groups";
    public static final String STATES_PROPERTY_ID = "alert_states";
    public static final String GLOBAL_PROPERTY_ID = "global";
    public static final String ENABLED_PROPERTY_ID = "enabled";
    public static final String ALERT_TARGET_ID = "AlertTarget/id";
    public static final String ALERT_TARGET_NAME = "AlertTarget/name";
    public static final String ALERT_TARGET_DESCRIPTION = "AlertTarget/description";
    public static final String ALERT_TARGET_NOTIFICATION_TYPE = "AlertTarget/notification_type";
    public static final String ALERT_TARGET_PROPERTIES = "AlertTarget/properties";
    public static final String ALERT_TARGET_GROUPS = "AlertTarget/groups";
    public static final String ALERT_TARGET_STATES = "AlertTarget/alert_states";
    public static final String ALERT_TARGET_GLOBAL = "AlertTarget/global";
    public static final String ALERT_TARGET_ENABLED = "AlertTarget/enabled";
    private static final Set<String> PK_PROPERTY_IDS = new HashSet<String>(Arrays.asList("AlertTarget/id", "AlertTarget/name"));
    private static final Set<String> PROPERTY_IDS = new HashSet<String>();
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS = new HashMap<Resource.Type, String>();
    @Inject
    private static AlertDispatchDAO s_dao;
    @Inject
    private static DispatchFactory dispatchFactory;
    private static final Gson s_gson;

    @Inject
    AlertTargetResourceProvider() {
        super(Resource.Type.AlertTarget, PROPERTY_IDS, KEY_PROPERTY_IDS);
        EnumSet<RoleAuthorization> requiredAuthorizations = EnumSet.of(RoleAuthorization.CLUSTER_MANAGE_ALERT_NOTIFICATIONS);
        this.setRequiredCreateAuthorizations(requiredAuthorizations);
        this.setRequiredUpdateAuthorizations(requiredAuthorizations);
        this.setRequiredDeleteAuthorizations(requiredAuthorizations);
    }

    @Override
    protected RequestStatus createResourcesAuthorized(final Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        this.createResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                AlertTargetResourceProvider.this.createAlertTargets(request.getProperties(), request.getRequestInfoProperties());
                return null;
            }
        });
        this.notifyCreate(Resource.Type.AlertTarget, request);
        return this.getRequestStatus(null);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> results = new HashSet<Resource>();
        Set<String> requestPropertyIds = this.getRequestPropertyIds(request, predicate);
        if (null == predicate) {
            List<AlertTargetEntity> entities = s_dao.findAllTargets();
            for (AlertTargetEntity entity : entities) {
                results.add(this.toResource(entity, requestPropertyIds));
            }
        } else {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
                AlertTargetEntity entity;
                String id = (String)propertyMap.get(ALERT_TARGET_ID);
                if (null == id || null == (entity = s_dao.findTargetById(Long.parseLong(id)))) continue;
                results.add(this.toResource(entity, requestPropertyIds));
            }
        }
        return results;
    }

    @Override
    protected RequestStatus updateResourcesAuthorized(final Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        this.modifyResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                Set<Map<String, Object>> requestMaps = request.getProperties();
                for (Map<String, Object> requestMap : requestMaps) {
                    String stringId = (String)requestMap.get(AlertTargetResourceProvider.ALERT_TARGET_ID);
                    if (StringUtils.isEmpty((String)stringId)) {
                        throw new IllegalArgumentException("The ID of the alert target is required when updating an existing target");
                    }
                    long alertTargetId = Long.parseLong(stringId);
                    AlertTargetResourceProvider.this.updateAlertTargets(alertTargetId, requestMap);
                }
                return null;
            }
        });
        this.notifyUpdate(Resource.Type.AlertTarget, request, predicate);
        return this.getRequestStatus(null);
    }

    @Override
    protected RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Set<Resource> resources = this.getResources(new RequestImpl(null, null, null, null), predicate);
        HashSet<Long> targetIds = new HashSet<Long>();
        for (Resource resource : resources) {
            Long id = (Long)resource.getPropertyValue(ALERT_TARGET_ID);
            targetIds.add(id);
        }
        for (Long targetId : targetIds) {
            LOG.info("Deleting alert target {}", (Object)targetId);
            final AlertTargetEntity entity = s_dao.findTargetById(targetId);
            this.modifyResources(new AbstractResourceProvider.Command<Void>(){

                @Override
                public Void invoke() throws OBDPException {
                    s_dao.remove(entity);
                    return null;
                }
            });
        }
        this.notifyDelete(Resource.Type.AlertTarget, predicate);
        return this.getRequestStatus(null);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return PK_PROPERTY_IDS;
    }

    private void createAlertTargets(Set<Map<String, Object>> requestMaps, Map<String, String> requestInfoProps) throws OBDPException {
        for (Map<String, Object> requestMap : requestMaps) {
            Collection groupIds;
            AlertTargetEntity entity;
            AbstractSet alertStateSet;
            String name = StringEscapeUtils.escapeHtml4((String)((String)requestMap.get(ALERT_TARGET_NAME)));
            String description = (String)requestMap.get(ALERT_TARGET_DESCRIPTION);
            String notificationType = (String)requestMap.get(ALERT_TARGET_NOTIFICATION_TYPE);
            Collection alertStates = (Collection)requestMap.get(ALERT_TARGET_STATES);
            String globalProperty = (String)requestMap.get(ALERT_TARGET_GLOBAL);
            String enabledProperty = (String)requestMap.get(ALERT_TARGET_ENABLED);
            if (StringUtils.isEmpty((String)name)) {
                throw new IllegalArgumentException("The name of the alert target is required.");
            }
            if (StringUtils.isEmpty((String)notificationType)) {
                throw new IllegalArgumentException("The type of the alert target is required.");
            }
            Map<String, Object> properties = this.extractProperties(requestMap);
            String propertiesJson = s_gson.toJson(properties);
            if (StringUtils.isEmpty((String)propertiesJson)) {
                throw new IllegalArgumentException("Alert targets must be created with their connection properties");
            }
            String validationDirective = requestInfoProps.get("validate_config");
            if (validationDirective != null && validationDirective.equalsIgnoreCase("true")) {
                this.validateTargetConfig(notificationType, properties);
            }
            boolean overwriteExisting = false;
            if (requestInfoProps.containsKey("overwrite_existing")) {
                overwriteExisting = true;
            }
            boolean isGlobal = false;
            if (null != globalProperty) {
                isGlobal = Boolean.parseBoolean(globalProperty);
            }
            boolean isEnabled = true;
            if (null != enabledProperty) {
                isEnabled = Boolean.parseBoolean(enabledProperty);
            }
            if (null != alertStates) {
                alertStateSet = new HashSet(alertStates.size());
                for (String state : alertStates) {
                    alertStateSet.add((AlertState)AlertState.valueOf(state));
                }
            } else {
                alertStateSet = EnumSet.allOf(AlertState.class);
            }
            if (null == (entity = s_dao.findTargetByName(name))) {
                entity = new AlertTargetEntity();
            } else if (!overwriteExisting) {
                throw new IllegalArgumentException("Alert targets already exists and can't be created");
            }
            if (requestMap.containsKey(ALERT_TARGET_GROUPS) && !(groupIds = (Collection)requestMap.get(ALERT_TARGET_GROUPS)).isEmpty()) {
                HashSet<AlertGroupEntity> groups = new HashSet<AlertGroupEntity>();
                ArrayList<Long> ids = new ArrayList<Long>(groupIds);
                groups.addAll(s_dao.findGroupsById(ids));
                entity.setAlertGroups(groups);
            }
            entity.setDescription(description);
            entity.setNotificationType(notificationType);
            entity.setProperties(propertiesJson);
            entity.setTargetName(name);
            entity.setAlertStates(alertStateSet);
            entity.setGlobal(isGlobal);
            entity.setEnabled(isEnabled);
            if (null == entity.getTargetId() || 0L == entity.getTargetId()) {
                s_dao.create(entity);
                continue;
            }
            s_dao.merge(entity);
        }
    }

    @Transactional
    void updateAlertTargets(long alertTargetId, Map<String, Object> requestMap) throws OBDPException {
        String properties;
        Map<String, Object> propertiesMap;
        AlertTargetEntity entity = s_dao.findTargetById(alertTargetId);
        if (null == entity) {
            String message = MessageFormat.format("The alert target with ID {0} could not be found", alertTargetId);
            throw new OBDPException(message);
        }
        String name = (String)requestMap.get(ALERT_TARGET_NAME);
        String description = (String)requestMap.get(ALERT_TARGET_DESCRIPTION);
        String notificationType = (String)requestMap.get(ALERT_TARGET_NOTIFICATION_TYPE);
        Collection alertStates = (Collection)requestMap.get(ALERT_TARGET_STATES);
        Collection groupIds = (Collection)requestMap.get(ALERT_TARGET_GROUPS);
        String isGlobal = (String)requestMap.get(ALERT_TARGET_GLOBAL);
        String isEnabled = (String)requestMap.get(ALERT_TARGET_ENABLED);
        if (null != isGlobal) {
            entity.setGlobal(Boolean.parseBoolean(isGlobal));
        }
        if (null != isEnabled) {
            entity.setEnabled(Boolean.parseBoolean(isEnabled));
        }
        if (!StringUtils.isBlank((String)name)) {
            entity.setTargetName(name);
        }
        if (null != description) {
            entity.setDescription(description);
        }
        if (!StringUtils.isBlank((String)notificationType)) {
            entity.setNotificationType(notificationType);
        }
        if ((propertiesMap = this.extractProperties(requestMap)) != null && !StringUtils.isEmpty((String)(properties = s_gson.toJson(propertiesMap)))) {
            LOG.debug("Updating Alert Target properties map to: " + properties);
            entity.setProperties(properties);
        }
        if (null != alertStates) {
            AbstractSet alertStateSet;
            if (alertStates.isEmpty()) {
                alertStateSet = EnumSet.allOf(AlertState.class);
            } else {
                alertStateSet = new HashSet(alertStates.size());
                for (String state : alertStates) {
                    alertStateSet.add((AlertState)AlertState.valueOf(state));
                }
            }
            entity.setAlertStates(alertStateSet);
        }
        if (null != groupIds) {
            groups = new HashSet();
            ArrayList<Long> ids = new ArrayList<Long>(groupIds);
            if (ids.size() > 0) {
                groups.addAll(s_dao.findGroupsById(ids));
            }
            entity.setAlertGroups(groups);
        } else if (entity.isGlobal()) {
            groups = new HashSet<AlertGroupEntity>(s_dao.findAllGroups());
            entity.setAlertGroups(groups);
        }
        s_dao.merge(entity);
    }

    private Resource toResource(AlertTargetEntity entity, Set<String> requestedIds) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.AlertTarget);
        resource.setProperty(ALERT_TARGET_ID, entity.getTargetId());
        resource.setProperty(ALERT_TARGET_NAME, entity.getTargetName());
        resource.setProperty(ALERT_TARGET_DESCRIPTION, entity.getDescription());
        resource.setProperty(ALERT_TARGET_NOTIFICATION_TYPE, entity.getNotificationType());
        resource.setProperty(ALERT_TARGET_ENABLED, entity.isEnabled());
        if (requestedIds.contains(ALERT_TARGET_PROPERTIES)) {
            String properties = entity.getProperties();
            Map map = (Map)s_gson.fromJson(properties, Map.class);
            resource.setProperty(ALERT_TARGET_PROPERTIES, map);
        }
        AlertTargetResourceProvider.setResourceProperty(resource, ALERT_TARGET_STATES, entity.getAlertStates(), requestedIds);
        AlertTargetResourceProvider.setResourceProperty(resource, ALERT_TARGET_GLOBAL, entity.isGlobal(), requestedIds);
        if (BaseProvider.isPropertyRequested(ALERT_TARGET_GROUPS, requestedIds)) {
            Set<AlertGroupEntity> groupEntities = entity.getAlertGroups();
            ArrayList<AlertGroup> groups = new ArrayList<AlertGroup>(groupEntities.size());
            for (AlertGroupEntity groupEntity : groupEntities) {
                AlertGroup group = new AlertGroup();
                group.setId(groupEntity.getGroupId());
                group.setName(groupEntity.getGroupName());
                group.setClusterName(groupEntity.getClusterId());
                group.setDefault(groupEntity.isDefault());
                groups.add(group);
            }
            resource.setProperty(ALERT_TARGET_GROUPS, groups);
        }
        return resource;
    }

    private Map<String, Object> extractProperties(Map<String, Object> requestMap) {
        HashMap<String, Object> normalizedMap = new HashMap<String, Object>(requestMap.size());
        boolean has_properties = false;
        for (Map.Entry<String, Object> entry : requestMap.entrySet()) {
            String key = entry.getKey();
            String propCat = PropertyHelper.getPropertyCategory(key);
            if (!propCat.equals(ALERT_TARGET_PROPERTIES)) continue;
            has_properties = true;
            String propKey = PropertyHelper.getPropertyName(key);
            normalizedMap.put(propKey, entry.getValue());
        }
        if (!has_properties) {
            normalizedMap = null;
        }
        return normalizedMap;
    }

    private void validateTargetConfig(String notificationType, Map<String, Object> properties) {
        NotificationDispatcher dispatcher = dispatchFactory.getDispatcher(notificationType);
        if (dispatcher == null) {
            throw new IllegalArgumentException("Dispatcher for given notification type doesn't exist");
        }
        TargetConfigurationResult validationResult = dispatcher.validateTargetConfig(properties);
        if (validationResult.getStatus() == TargetConfigurationResult.Status.INVALID) {
            throw new IllegalArgumentException(validationResult.getMessage());
        }
    }

    static {
        PROPERTY_IDS.add(ALERT_TARGET_ID);
        PROPERTY_IDS.add(ALERT_TARGET_NAME);
        PROPERTY_IDS.add(ALERT_TARGET_DESCRIPTION);
        PROPERTY_IDS.add(ALERT_TARGET_NOTIFICATION_TYPE);
        PROPERTY_IDS.add(ALERT_TARGET_PROPERTIES);
        PROPERTY_IDS.add(ALERT_TARGET_GROUPS);
        PROPERTY_IDS.add(ALERT_TARGET_STATES);
        PROPERTY_IDS.add(ALERT_TARGET_GLOBAL);
        PROPERTY_IDS.add(ALERT_TARGET_ENABLED);
        KEY_PROPERTY_IDS.put(Resource.Type.AlertTarget, ALERT_TARGET_ID);
        s_gson = new Gson();
    }
}

