/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.internal.BaseProvider;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.PropertyProvider;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.orm.dao.AlertHostSummaryDTO;
import id.onyx.obdp.server.orm.dao.AlertSummaryDTO;
import id.onyx.obdp.server.orm.dao.AlertsDAO;
import id.onyx.obdp.server.state.AlertState;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class AlertSummaryPropertyProvider
extends BaseProvider
implements PropertyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AlertSummaryPropertyProvider.class);
    private static final String ALERTS_SUMMARY = "alerts_summary";
    private static final String ALERTS_SUMMARY_HOSTS = "alerts_summary_hosts";
    @Inject
    private static Provider<Clusters> s_clusters = null;
    @Inject
    private static AlertsDAO s_dao = null;
    private Resource.Type m_resourceType = null;
    private String m_clusterPropertyId = null;
    private String m_typeIdPropertyId = null;

    AlertSummaryPropertyProvider(Resource.Type type, String clusterPropertyId, String typeIdPropertyId) {
        super((Set<String>)ImmutableSet.of((Object)ALERTS_SUMMARY, (Object)ALERTS_SUMMARY_HOSTS));
        this.m_resourceType = type;
        this.m_clusterPropertyId = clusterPropertyId;
        this.m_typeIdPropertyId = typeIdPropertyId;
    }

    @Override
    public Set<Resource> populateResources(Set<Resource> resources, Request request, Predicate predicate) throws SystemException {
        Set<String> propertyIds = this.getRequestPropertyIds(request, predicate);
        try {
            HashMap<Long, Map<String, AlertSummaryDTO>> perHostSummaryMap = new HashMap<Long, Map<String, AlertSummaryDTO>>();
            HashMap<Long, AlertHostSummaryDTO> hostsSummaryMap = new HashMap<Long, AlertHostSummaryDTO>();
            HashMap<String, Cluster> resourcesClusterMap = new HashMap<String, Cluster>();
            for (Resource res : resources) {
                String clusterName = (String)res.getPropertyValue(this.m_clusterPropertyId);
                if (clusterName == null || resourcesClusterMap.containsKey(clusterName)) continue;
                Cluster cluster = ((Clusters)s_clusters.get()).getCluster(clusterName);
                resourcesClusterMap.put(clusterName, cluster);
            }
            for (Cluster cluster : resourcesClusterMap.values()) {
                long clusterId = cluster.getClusterId();
                switch (this.m_resourceType.getInternalType()) {
                    case Cluster: {
                        if (!BaseProvider.isPropertyRequested(ALERTS_SUMMARY_HOSTS, propertyIds)) break;
                        hostsSummaryMap.put(clusterId, s_dao.findCurrentHostCounts(clusterId));
                        break;
                    }
                    case Host: {
                        if (resources.size() <= 1) break;
                        Map<String, AlertSummaryDTO> perHostCounts = s_dao.findCurrentPerHostCounts(clusterId);
                        perHostSummaryMap.put(clusterId, perHostCounts);
                        break;
                    }
                }
            }
            for (Resource res : resources) {
                this.populateResource(res, propertyIds, perHostSummaryMap, hostsSummaryMap);
            }
        }
        catch (OBDPException e) {
            LOG.error("Could not load built-in alerts - Executor exception ({})", (Object)e.getMessage());
        }
        return resources;
    }

    private void populateResource(Resource resource, Set<String> requestedIds, Map<Long, Map<String, AlertSummaryDTO>> perHostSummaryMap, Map<Long, AlertHostSummaryDTO> hostsSummaryMap) throws OBDPException {
        AlertSummaryDTO summary = null;
        AlertHostSummaryDTO hostSummary = null;
        String clusterName = (String)resource.getPropertyValue(this.m_clusterPropertyId);
        if (null == clusterName) {
            return;
        }
        String typeId = null == this.m_typeIdPropertyId ? null : (String)resource.getPropertyValue(this.m_typeIdPropertyId);
        Cluster cluster = ((Clusters)s_clusters.get()).getCluster(clusterName);
        switch (this.m_resourceType.getInternalType()) {
            case Cluster: {
                long clusterId = cluster.getClusterId();
                if (BaseProvider.isPropertyRequested(ALERTS_SUMMARY, requestedIds)) {
                    summary = s_dao.findCurrentCounts(cluster.getClusterId(), null, null);
                }
                if (!BaseProvider.isPropertyRequested(ALERTS_SUMMARY_HOSTS, requestedIds)) break;
                if (hostsSummaryMap.containsKey(cluster.getClusterId())) {
                    hostSummary = hostsSummaryMap.get(cluster.getClusterId());
                    break;
                }
                hostSummary = s_dao.findCurrentHostCounts(clusterId);
                break;
            }
            case Service: {
                summary = s_dao.findCurrentCounts(cluster.getClusterId(), typeId, null);
                break;
            }
            case Host: {
                if (perHostSummaryMap.containsKey(cluster.getClusterId()) && perHostSummaryMap.get(cluster.getClusterId()).containsKey(typeId)) {
                    summary = perHostSummaryMap.get(cluster.getClusterId()).get(typeId);
                    break;
                }
                summary = s_dao.findCurrentCounts(cluster.getClusterId(), null, typeId);
                break;
            }
        }
        if (null != summary) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put(AlertState.OK.name(), summary.getOkCount());
            map.put(AlertState.WARNING.name(), summary.getWarningCount());
            map.put(AlertState.CRITICAL.name(), summary.getCriticalCount());
            map.put(AlertState.UNKNOWN.name(), summary.getUnknownCount());
            map.put("MAINTENANCE", summary.getMaintenanceCount());
            AlertSummaryPropertyProvider.setResourceProperty(resource, ALERTS_SUMMARY, map, requestedIds);
        }
        if (null != hostSummary) {
            HashMap<AlertState, Integer> map = new HashMap<AlertState, Integer>();
            map.put(AlertState.OK, hostSummary.getOkCount());
            map.put(AlertState.WARNING, hostSummary.getWarningCount());
            map.put(AlertState.CRITICAL, hostSummary.getCriticalCount());
            map.put(AlertState.UNKNOWN, hostSummary.getUnknownCount());
            AlertSummaryPropertyProvider.setResourceProperty(resource, ALERTS_SUMMARY_HOSTS, map, requestedIds);
        }
    }

    @Override
    public Set<String> checkPropertyIds(Set<String> propertyIds) {
        HashSet<String> rejects = new HashSet<String>();
        for (String id : propertyIds) {
            if (id.startsWith(ALERTS_SUMMARY)) continue;
            rejects.add(id);
        }
        return rejects;
    }
}

