/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.orm.entities.AlertCurrentEntity;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.AlertGroupEntity;
import id.onyx.obdp.server.orm.entities.AlertHistoryEntity;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.ResourceEntity;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import java.util.EnumSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class AlertResourceProviderUtils {
    private static final Set<RoleAuthorization> AUTHORIZATIONS_VIEW_CLUSTER_ALERTS = EnumSet.of(RoleAuthorization.CLUSTER_VIEW_ALERTS, RoleAuthorization.CLUSTER_TOGGLE_ALERTS, RoleAuthorization.CLUSTER_MANAGE_ALERTS);
    private static final Set<RoleAuthorization> AUTHORIZATIONS_VIEW_SERVICE_ALERTS = EnumSet.of(RoleAuthorization.CLUSTER_VIEW_ALERTS, new RoleAuthorization[]{RoleAuthorization.CLUSTER_TOGGLE_ALERTS, RoleAuthorization.CLUSTER_MANAGE_ALERTS, RoleAuthorization.SERVICE_VIEW_ALERTS, RoleAuthorization.SERVICE_TOGGLE_ALERTS, RoleAuthorization.SERVICE_MANAGE_ALERTS});
    private static final Set<RoleAuthorization> AUTHORIZATIONS_EXECUTE_CLUSTER_ALERTS = AUTHORIZATIONS_VIEW_CLUSTER_ALERTS;
    private static final Set<RoleAuthorization> AUTHORIZATIONS_EXECUTE_SERVICE_ALERTS = AUTHORIZATIONS_VIEW_SERVICE_ALERTS;
    private static final Set<RoleAuthorization> AUTHORIZATIONS_TOGGLE_CLUSTER_ALERTS = EnumSet.of(RoleAuthorization.CLUSTER_TOGGLE_ALERTS, RoleAuthorization.CLUSTER_MANAGE_ALERTS);
    private static final Set<RoleAuthorization> AUTHORIZATIONS_TOGGLE_SERVICE_ALERTS = EnumSet.of(RoleAuthorization.CLUSTER_TOGGLE_ALERTS, RoleAuthorization.CLUSTER_MANAGE_ALERTS, RoleAuthorization.SERVICE_TOGGLE_ALERTS, RoleAuthorization.SERVICE_MANAGE_ALERTS);
    private static final Set<RoleAuthorization> AUTHORIZATIONS_MANAGE_CLUSTER_ALERTS = EnumSet.of(RoleAuthorization.CLUSTER_MANAGE_ALERTS);
    private static final Set<RoleAuthorization> AUTHORIZATIONS_MANAGE_SERVICE_ALERTS = EnumSet.of(RoleAuthorization.CLUSTER_MANAGE_ALERTS, RoleAuthorization.SERVICE_MANAGE_ALERTS);

    public static boolean hasViewAuthorization(AlertGroupEntity entity, Long clusterResourceId) {
        return null != entity && AlertResourceProviderUtils.hasViewAuthorization(entity.getServiceName(), clusterResourceId);
    }

    public static boolean hasViewAuthorization(String serviceName, Long clusterResourceId) {
        return AlertResourceProviderUtils.hasAuthorization(serviceName, clusterResourceId, AUTHORIZATIONS_VIEW_CLUSTER_ALERTS, AUTHORIZATIONS_VIEW_SERVICE_ALERTS);
    }

    public static void verifyViewAuthorization(AlertCurrentEntity entity) throws AuthorizationException {
        if (entity != null) {
            AlertResourceProviderUtils.verifyViewAuthorization(entity.getAlertHistory());
        }
    }

    public static void verifyViewAuthorization(AlertHistoryEntity entity) throws AuthorizationException {
        if (entity != null) {
            AlertResourceProviderUtils.verifyViewAuthorization(entity.getAlertDefinition());
        }
    }

    public static void verifyViewAuthorization(AlertGroupEntity entity, Long clusterResourceId) throws AuthorizationException {
        if (entity != null) {
            AlertResourceProviderUtils.verifyViewAuthorization(entity.getServiceName(), clusterResourceId);
        }
    }

    public static void verifyViewAuthorization(AlertDefinitionEntity entity) throws AuthorizationException {
        AlertResourceProviderUtils.verifyAuthorization(entity, AUTHORIZATIONS_VIEW_CLUSTER_ALERTS, AUTHORIZATIONS_VIEW_SERVICE_ALERTS, "view");
    }

    public static void verifyViewAuthorization(String serviceName, Long clusterResourceId) throws AuthorizationException {
        AlertResourceProviderUtils.verifyAuthorization(serviceName, clusterResourceId, AUTHORIZATIONS_VIEW_CLUSTER_ALERTS, AUTHORIZATIONS_VIEW_SERVICE_ALERTS, "view");
    }

    public static void verifyExecuteAuthorization(AlertDefinitionEntity entity) throws AuthorizationException {
        AlertResourceProviderUtils.verifyAuthorization(entity, AUTHORIZATIONS_EXECUTE_CLUSTER_ALERTS, AUTHORIZATIONS_EXECUTE_SERVICE_ALERTS, "execute");
    }

    public static void verifyExecuteAuthorization(String serviceName, Long clusterResourceId) throws AuthorizationException {
        AlertResourceProviderUtils.verifyAuthorization(serviceName, clusterResourceId, AUTHORIZATIONS_EXECUTE_CLUSTER_ALERTS, AUTHORIZATIONS_EXECUTE_SERVICE_ALERTS, "execute");
    }

    public static void verifyToggleAuthorization(AlertDefinitionEntity entity) throws AuthorizationException {
        AlertResourceProviderUtils.verifyAuthorization(entity, AUTHORIZATIONS_TOGGLE_CLUSTER_ALERTS, AUTHORIZATIONS_TOGGLE_SERVICE_ALERTS, "execute");
    }

    public static void verifyToggleAuthorization(String serviceName, Long clusterResourceId) throws AuthorizationException {
        AlertResourceProviderUtils.verifyAuthorization(serviceName, clusterResourceId, AUTHORIZATIONS_TOGGLE_CLUSTER_ALERTS, AUTHORIZATIONS_TOGGLE_SERVICE_ALERTS, "execute");
    }

    public static void verifyManageAuthorization(AlertGroupEntity entity, Long clusterResourceId) throws AuthorizationException {
        if (entity != null) {
            AlertResourceProviderUtils.verifyManageAuthorization(entity.getServiceName(), clusterResourceId);
        }
    }

    public static void verifyManageAuthorization(AlertDefinitionEntity entity) throws AuthorizationException {
        AlertResourceProviderUtils.verifyAuthorization(entity, AUTHORIZATIONS_MANAGE_CLUSTER_ALERTS, AUTHORIZATIONS_MANAGE_SERVICE_ALERTS, "manage");
    }

    public static void verifyManageAuthorization(String serviceName, Long clusterResourceId) throws AuthorizationException {
        AlertResourceProviderUtils.verifyAuthorization(serviceName, clusterResourceId, AUTHORIZATIONS_MANAGE_CLUSTER_ALERTS, AUTHORIZATIONS_MANAGE_SERVICE_ALERTS, "manage");
    }

    public static boolean hasAuthorization(String serviceName, Long clusterResourceId, Set<RoleAuthorization> clusterLevelAuthorizations, Set<RoleAuthorization> serviceLevelAuthorizations) {
        if (null == clusterResourceId) {
            clusterResourceId = -1L;
        }
        return AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, clusterResourceId, StringUtils.isEmpty((String)serviceName) || "OBDP".equals(serviceName) ? clusterLevelAuthorizations : serviceLevelAuthorizations);
    }

    public static void verifyAuthorization(AlertDefinitionEntity entity, Set<RoleAuthorization> clusterLevelAuthorizations, Set<RoleAuthorization> serviceLevelAuthorizations, String operation) throws AuthorizationException {
        ClusterEntity clusterEntity = null == entity ? null : entity.getCluster();
        ResourceEntity resourceEntity = null == clusterEntity ? null : clusterEntity.getResource();
        Long resourceId = null == resourceEntity ? null : resourceEntity.getId();
        AlertResourceProviderUtils.verifyAuthorization(null == entity ? null : entity.getServiceName(), resourceId, clusterLevelAuthorizations, serviceLevelAuthorizations, operation);
    }

    public static void verifyAuthorization(String serviceName, Long clusterResourceId, Set<RoleAuthorization> clusterLevelAuthorizations, Set<RoleAuthorization> serviceLevelAuthorizations, String operation) throws AuthorizationException {
        if (null == clusterResourceId) {
            clusterResourceId = -1L;
        }
        if (StringUtils.isEmpty((String)serviceName) || "OBDP".equals(serviceName)) {
            if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, clusterResourceId, clusterLevelAuthorizations)) {
                throw new AuthorizationException(String.format("The authenticated user is not authorized to %s cluster-level alerts", operation));
            }
        } else if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, clusterResourceId, serviceLevelAuthorizations)) {
            throw new AuthorizationException(String.format("The authenticated user is not authorized to %s service-level alerts", operation));
        }
    }
}

