/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.inject.Inject;
import com.google.inject.Provider;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.AlertCurrentRequest;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AlertResourceProviderUtils;
import id.onyx.obdp.server.controller.internal.QueryResponseImpl;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.ExtendedResourceProvider;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.QueryResponse;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.orm.dao.AlertDefinitionDAO;
import id.onyx.obdp.server.orm.dao.AlertsDAO;
import id.onyx.obdp.server.orm.entities.AlertCurrentEntity;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.AlertHistoryEntity;
import id.onyx.obdp.server.state.AlertState;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class AlertResourceProvider
extends ReadOnlyResourceProvider
implements ExtendedResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AlertResourceProvider.class);
    public static final String ALERT_ID = "Alert/id";
    public static final String ALERT_STATE = "Alert/state";
    public static final String ALERT_ORIGINAL_TIMESTAMP = "Alert/original_timestamp";
    public static final String ALERT_LATEST_TIMESTAMP = "Alert/latest_timestamp";
    public static final String ALERT_MAINTENANCE_STATE = "Alert/maintenance_state";
    public static final String ALERT_DEFINITION_ID = "Alert/definition_id";
    public static final String ALERT_DEFINITION_NAME = "Alert/definition_name";
    public static final String ALERT_TEXT = "Alert/text";
    public static final String ALERT_CLUSTER_NAME = "Alert/cluster_name";
    public static final String ALERT_COMPONENT = "Alert/component_name";
    public static final String ALERT_HOST = "Alert/host_name";
    public static final String ALERT_SERVICE = "Alert/service_name";
    protected static final String ALERT_INSTANCE = "Alert/instance";
    protected static final String ALERT_LABEL = "Alert/label";
    protected static final String ALERT_SCOPE = "Alert/scope";
    protected static final String ALERT_REPEAT_TOLERANCE = "Alert/repeat_tolerance";
    protected static final String ALERT_OCCURRENCES = "Alert/occurrences";
    protected static final String ALERT_REPEAT_TOLERANCE_REMAINING = "Alert/repeat_tolerance_remaining";
    protected static final String ALERT_FIRMNESS = "Alert/firmness";
    private static final Set<String> pkPropertyIds = new HashSet<String>(Arrays.asList("Alert/id", "Alert/definition_name"));
    @Inject
    private static AlertsDAO alertsDAO;
    @Inject
    private static AlertDefinitionDAO alertDefinitionDAO;
    @Inject
    private static Provider<Clusters> clusters;
    private static final Set<String> PROPERTY_IDS;
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS;

    AlertResourceProvider(OBDPManagementController controller) {
        super(Resource.Type.Alert, PROPERTY_IDS, KEY_PROPERTY_IDS, controller);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return pkPropertyIds;
    }

    @Override
    public QueryResponse queryForResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        return new QueryResponseImpl(this.getResources(request, predicate), request.getSortRequest() != null, request.getPageRequest() != null, alertsDAO.getCount(predicate));
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Set<String> requestPropertyIds = this.getRequestPropertyIds(request, predicate);
        LinkedHashSet<Resource> results = new LinkedHashSet<Resource>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            String clusterName = (String)propertyMap.get(ALERT_CLUSTER_NAME);
            if (null == clusterName || clusterName.isEmpty()) {
                throw new IllegalArgumentException("Invalid argument, cluster name is required");
            }
            String id = (String)propertyMap.get(ALERT_ID);
            if (null != id) {
                AlertCurrentEntity entity = alertsDAO.findCurrentById(Long.parseLong(id));
                if (null == entity) continue;
                AlertResourceProviderUtils.verifyViewAuthorization(entity);
                results.add(this.toResource(false, clusterName, entity, requestPropertyIds));
                continue;
            }
            try {
                Long clusterId = this.getClusterId(clusterName);
                String definitionName = (String)propertyMap.get(ALERT_DEFINITION_NAME);
                String definitionId = (String)propertyMap.get(ALERT_DEFINITION_ID);
                if (clusterId == null) {
                    AlertResourceProviderUtils.verifyViewAuthorization("", (Long)-1L);
                } else if (!StringUtils.isEmpty((String)definitionName)) {
                    alertDefinition = alertDefinitionDAO.findByName(clusterId, definitionName);
                    AlertResourceProviderUtils.verifyViewAuthorization(alertDefinition);
                } else if (StringUtils.isNumeric((String)definitionId)) {
                    alertDefinition = alertDefinitionDAO.findById(Long.parseLong(definitionId));
                    AlertResourceProviderUtils.verifyViewAuthorization(alertDefinition);
                } else {
                    AlertResourceProviderUtils.verifyViewAuthorization("", this.getClusterResourceId(clusterName));
                }
            }
            catch (OBDPException e) {
                throw new SystemException(e.getMessage(), e);
            }
            List<AlertCurrentEntity> entities = null;
            AlertCurrentRequest alertCurrentRequest = new AlertCurrentRequest();
            alertCurrentRequest.Predicate = predicate;
            alertCurrentRequest.Pagination = request.getPageRequest();
            alertCurrentRequest.Sort = request.getSortRequest();
            entities = alertsDAO.findAll(alertCurrentRequest);
            if (null == entities) {
                entities = Collections.emptyList();
            }
            for (AlertCurrentEntity entity : entities) {
                results.add(this.toResource(true, clusterName, entity, requestPropertyIds));
            }
        }
        return results;
    }

    private Resource toResource(boolean isCollection, String clusterName, AlertCurrentEntity entity, Set<String> requestedIds) {
        long remaining;
        AlertHistoryEntity history = entity.getAlertHistory();
        AlertDefinitionEntity definition = history.getAlertDefinition();
        ResourceImpl resource = new ResourceImpl(Resource.Type.Alert);
        AlertResourceProvider.setResourceProperty(resource, ALERT_CLUSTER_NAME, clusterName, requestedIds);
        AlertResourceProvider.setResourceProperty(resource, ALERT_ID, entity.getAlertId(), requestedIds);
        AlertResourceProvider.setResourceProperty(resource, ALERT_LATEST_TIMESTAMP, entity.getLatestTimestamp(), requestedIds);
        AlertResourceProvider.setResourceProperty(resource, ALERT_MAINTENANCE_STATE, (Object)entity.getMaintenanceState(), requestedIds);
        AlertResourceProvider.setResourceProperty(resource, ALERT_ORIGINAL_TIMESTAMP, entity.getOriginalTimestamp(), requestedIds);
        AlertResourceProvider.setResourceProperty(resource, ALERT_TEXT, entity.getLatestText(), requestedIds);
        AlertResourceProvider.setResourceProperty(resource, ALERT_INSTANCE, history.getAlertInstance(), requestedIds);
        AlertResourceProvider.setResourceProperty(resource, ALERT_LABEL, definition.getLabel(), requestedIds);
        AlertResourceProvider.setResourceProperty(resource, ALERT_STATE, (Object)history.getAlertState(), requestedIds);
        AlertResourceProvider.setResourceProperty(resource, ALERT_COMPONENT, history.getComponentName(), requestedIds);
        AlertResourceProvider.setResourceProperty(resource, ALERT_HOST, history.getHostName(), requestedIds);
        AlertResourceProvider.setResourceProperty(resource, ALERT_SERVICE, history.getServiceName(), requestedIds);
        AlertResourceProvider.setResourceProperty(resource, ALERT_DEFINITION_ID, definition.getDefinitionId(), requestedIds);
        AlertResourceProvider.setResourceProperty(resource, ALERT_DEFINITION_NAME, definition.getDefinitionName(), requestedIds);
        AlertResourceProvider.setResourceProperty(resource, ALERT_SCOPE, (Object)definition.getScope(), requestedIds);
        int repeatTolerance = this.getRepeatTolerance(definition, clusterName);
        long occurrences = entity.getOccurrences();
        long l = remaining = occurrences > (long)repeatTolerance ? 0L : (long)repeatTolerance - occurrences;
        if (history.getAlertState() == AlertState.OK) {
            remaining = 0L;
        }
        AlertResourceProvider.setResourceProperty(resource, ALERT_REPEAT_TOLERANCE, repeatTolerance, requestedIds);
        AlertResourceProvider.setResourceProperty(resource, ALERT_OCCURRENCES, occurrences, requestedIds);
        AlertResourceProvider.setResourceProperty(resource, ALERT_REPEAT_TOLERANCE_REMAINING, remaining, requestedIds);
        AlertResourceProvider.setResourceProperty(resource, ALERT_FIRMNESS, (Object)entity.getFirmness(), requestedIds);
        if (isCollection) {
            resource.setProperty(ALERT_DEFINITION_ID, definition.getDefinitionId());
            resource.setProperty(ALERT_DEFINITION_NAME, definition.getDefinitionName());
        }
        return resource;
    }

    private int getRepeatTolerance(AlertDefinitionEntity definition, String clusterName) {
        if (definition.isRepeatToleranceEnabled()) {
            return definition.getRepeatTolerance();
        }
        int repeatTolerance = 1;
        try {
            Cluster cluster = ((Clusters)clusters.get()).getCluster(clusterName);
            String value = cluster.getClusterProperty("alerts_repeat_tolerance", "1");
            repeatTolerance = NumberUtils.toInt((String)value, (int)1);
        }
        catch (OBDPException ambariException) {
            LOG.warn("Unable to read {}/{} from cluster {}, defaulting to 1", new Object[]{"cluster-env", "alerts_repeat_tolerance", clusterName, ambariException});
        }
        return repeatTolerance;
    }

    static {
        alertDefinitionDAO = null;
        PROPERTY_IDS = new HashSet<String>();
        KEY_PROPERTY_IDS = new HashMap<Resource.Type, String>();
        PROPERTY_IDS.add(ALERT_ID);
        PROPERTY_IDS.add(ALERT_STATE);
        PROPERTY_IDS.add(ALERT_ORIGINAL_TIMESTAMP);
        PROPERTY_IDS.add(ALERT_DEFINITION_ID);
        PROPERTY_IDS.add(ALERT_DEFINITION_NAME);
        PROPERTY_IDS.add(ALERT_CLUSTER_NAME);
        PROPERTY_IDS.add(ALERT_LATEST_TIMESTAMP);
        PROPERTY_IDS.add(ALERT_MAINTENANCE_STATE);
        PROPERTY_IDS.add(ALERT_INSTANCE);
        PROPERTY_IDS.add(ALERT_LABEL);
        PROPERTY_IDS.add(ALERT_TEXT);
        PROPERTY_IDS.add(ALERT_COMPONENT);
        PROPERTY_IDS.add(ALERT_HOST);
        PROPERTY_IDS.add(ALERT_SERVICE);
        PROPERTY_IDS.add(ALERT_SCOPE);
        PROPERTY_IDS.add(ALERT_REPEAT_TOLERANCE);
        PROPERTY_IDS.add(ALERT_OCCURRENCES);
        PROPERTY_IDS.add(ALERT_REPEAT_TOLERANCE_REMAINING);
        PROPERTY_IDS.add(ALERT_FIRMNESS);
        KEY_PROPERTY_IDS.put(Resource.Type.Alert, ALERT_ID);
        KEY_PROPERTY_IDS.put(Resource.Type.Cluster, ALERT_CLUSTER_NAME);
        KEY_PROPERTY_IDS.put(Resource.Type.Service, ALERT_SERVICE);
        KEY_PROPERTY_IDS.put(Resource.Type.Host, ALERT_HOST);
    }
}

