/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.AlertNoticeRequest;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AlertResourceProviderUtils;
import id.onyx.obdp.server.controller.internal.QueryResponseImpl;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.ExtendedResourceProvider;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.QueryResponse;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.orm.dao.AlertDispatchDAO;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.AlertHistoryEntity;
import id.onyx.obdp.server.orm.entities.AlertNoticeEntity;
import id.onyx.obdp.server.orm.entities.AlertTargetEntity;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

@StaticallyInject
public class AlertNoticeResourceProvider
extends AbstractControllerResourceProvider
implements ExtendedResourceProvider {
    public static final String ALERT_NOTICE_ID = "AlertNotice/id";
    public static final String ALERT_NOTICE_STATE = "AlertNotice/notification_state";
    public static final String ALERT_NOTICE_UUID = "AlertNotice/uuid";
    public static final String ALERT_NOTICE_SERVICE_NAME = "AlertNotice/service_name";
    public static final String ALERT_NOTICE_TARGET_ID = "AlertNotice/target_id";
    public static final String ALERT_NOTICE_TARGET_NAME = "AlertNotice/target_name";
    public static final String ALERT_NOTICE_HISTORY_ID = "AlertNotice/history_id";
    public static final String ALERT_NOTICE_CLUSTER_NAME = "AlertNotice/cluster_name";
    private static final Set<String> PK_PROPERTY_IDS = new HashSet<String>(Arrays.asList("AlertNotice/id"));
    @Inject
    private static AlertDispatchDAO s_dao = null;
    private static final Set<String> PROPERTY_IDS = new HashSet<String>();
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS = new HashMap<Resource.Type, String>();

    AlertNoticeResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.AlertNotice, PROPERTY_IDS, KEY_PROPERTY_IDS, managementController);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return PK_PROPERTY_IDS;
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        for (Map<String, Object> propertyMap : propertyMaps) {
            try {
                String clusterName = (String)propertyMap.get(ALERT_NOTICE_CLUSTER_NAME);
                Long clusterResourceId = StringUtils.isEmpty((String)clusterName) ? null : this.getClusterResourceId(clusterName);
                String serviceName = (String)propertyMap.get(ALERT_NOTICE_SERVICE_NAME);
                if (clusterResourceId == null) {
                    clusterResourceId = -1L;
                }
                AlertResourceProviderUtils.verifyViewAuthorization(serviceName, clusterResourceId);
            }
            catch (OBDPException e) {
                throw new SystemException(e.getMessage(), e);
            }
        }
        Set<String> requestPropertyIds = this.getRequestPropertyIds(request, predicate);
        LinkedHashSet<Resource> results = new LinkedHashSet<Resource>();
        AlertNoticeRequest noticeRequest = new AlertNoticeRequest();
        noticeRequest.Predicate = predicate;
        noticeRequest.Pagination = request.getPageRequest();
        noticeRequest.Sort = request.getSortRequest();
        List<AlertNoticeEntity> entities = s_dao.findAllNotices(noticeRequest);
        for (AlertNoticeEntity entity : entities) {
            results.add(this.toResource(entity, requestPropertyIds));
        }
        return results;
    }

    @Override
    public QueryResponse queryForResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        return new QueryResponseImpl(this.getResources(request, predicate), request.getSortRequest() != null, request.getPageRequest() != null, s_dao.getNoticesCount(predicate));
    }

    private Resource toResource(AlertNoticeEntity entity, Set<String> requestedIds) {
        AlertHistoryEntity history = entity.getAlertHistory();
        AlertTargetEntity target = entity.getAlertTarget();
        AlertDefinitionEntity definition = history.getAlertDefinition();
        ClusterEntity cluster = definition.getCluster();
        ResourceImpl resource = new ResourceImpl(Resource.Type.AlertNotice);
        resource.setProperty(ALERT_NOTICE_ID, entity.getNotificationId());
        AlertNoticeResourceProvider.setResourceProperty(resource, ALERT_NOTICE_STATE, (Object)entity.getNotifyState(), requestedIds);
        AlertNoticeResourceProvider.setResourceProperty(resource, ALERT_NOTICE_UUID, entity.getUuid(), requestedIds);
        AlertNoticeResourceProvider.setResourceProperty(resource, ALERT_NOTICE_SERVICE_NAME, definition.getServiceName(), requestedIds);
        AlertNoticeResourceProvider.setResourceProperty(resource, ALERT_NOTICE_TARGET_ID, target.getTargetId(), requestedIds);
        AlertNoticeResourceProvider.setResourceProperty(resource, ALERT_NOTICE_TARGET_NAME, target.getTargetName(), requestedIds);
        AlertNoticeResourceProvider.setResourceProperty(resource, ALERT_NOTICE_HISTORY_ID, history.getAlertId(), requestedIds);
        if (null != cluster) {
            AlertNoticeResourceProvider.setResourceProperty(resource, ALERT_NOTICE_CLUSTER_NAME, cluster.getClusterName(), requestedIds);
        }
        return resource;
    }

    static {
        PROPERTY_IDS.add(ALERT_NOTICE_ID);
        PROPERTY_IDS.add(ALERT_NOTICE_STATE);
        PROPERTY_IDS.add(ALERT_NOTICE_UUID);
        PROPERTY_IDS.add(ALERT_NOTICE_SERVICE_NAME);
        PROPERTY_IDS.add(ALERT_NOTICE_TARGET_ID);
        PROPERTY_IDS.add(ALERT_NOTICE_TARGET_NAME);
        PROPERTY_IDS.add(ALERT_NOTICE_HISTORY_ID);
        PROPERTY_IDS.add(ALERT_NOTICE_CLUSTER_NAME);
        KEY_PROPERTY_IDS.put(Resource.Type.AlertNotice, ALERT_NOTICE_ID);
        KEY_PROPERTY_IDS.put(Resource.Type.Cluster, ALERT_NOTICE_CLUSTER_NAME);
    }
}

