/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.AlertHistoryRequest;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AlertResourceProviderUtils;
import id.onyx.obdp.server.controller.internal.QueryResponseImpl;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.ExtendedResourceProvider;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.QueryResponse;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.orm.dao.AlertDefinitionDAO;
import id.onyx.obdp.server.orm.dao.AlertsDAO;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.AlertHistoryEntity;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

@StaticallyInject
public class AlertHistoryResourceProvider
extends ReadOnlyResourceProvider
implements ExtendedResourceProvider {
    public static final String ALERT_HISTORY_DEFINITION_ID = "AlertHistory/definition_id";
    public static final String ALERT_HISTORY_DEFINITION_NAME = "AlertHistory/definition_name";
    public static final String ALERT_HISTORY_ID = "AlertHistory/id";
    public static final String ALERT_HISTORY_CLUSTER_NAME = "AlertHistory/cluster_name";
    public static final String ALERT_HISTORY_SERVICE_NAME = "AlertHistory/service_name";
    public static final String ALERT_HISTORY_COMPONENT_NAME = "AlertHistory/component_name";
    public static final String ALERT_HISTORY_HOSTNAME = "AlertHistory/host_name";
    public static final String ALERT_HISTORY_LABEL = "AlertHistory/label";
    public static final String ALERT_HISTORY_STATE = "AlertHistory/state";
    public static final String ALERT_HISTORY_TEXT = "AlertHistory/text";
    public static final String ALERT_HISTORY_TIMESTAMP = "AlertHistory/timestamp";
    public static final String ALERT_HISTORY_INSTANCE = "AlertHistory/instance";
    private static final Set<String> PK_PROPERTY_IDS = new HashSet<String>(Arrays.asList("AlertHistory/id"));
    @Inject
    private static AlertsDAO s_dao = null;
    @Inject
    private static AlertDefinitionDAO alertDefinitionDAO = null;
    private static final Set<String> PROPERTY_IDS = new HashSet<String>();
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS = new HashMap<Resource.Type, String>();

    AlertHistoryResourceProvider(OBDPManagementController controller) {
        super(Resource.Type.AlertHistory, PROPERTY_IDS, KEY_PROPERTY_IDS, controller);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return PK_PROPERTY_IDS;
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        for (Map<String, Object> propertyMap : propertyMaps) {
            try {
                AlertDefinitionEntity alertDefinition;
                String clusterName = (String)propertyMap.get(ALERT_HISTORY_CLUSTER_NAME);
                Long clusterId = StringUtils.isEmpty((String)clusterName) ? null : this.getClusterId(clusterName);
                String definitionName = (String)propertyMap.get(ALERT_HISTORY_DEFINITION_NAME);
                String definitionId = (String)propertyMap.get(ALERT_HISTORY_DEFINITION_ID);
                if (clusterId == null) {
                    AlertResourceProviderUtils.verifyViewAuthorization("", (Long)-1L);
                    continue;
                }
                if (!StringUtils.isEmpty((String)definitionName)) {
                    alertDefinition = alertDefinitionDAO.findByName(clusterId, definitionName);
                    AlertResourceProviderUtils.verifyViewAuthorization(alertDefinition);
                    continue;
                }
                if (StringUtils.isNumeric((String)definitionId)) {
                    alertDefinition = alertDefinitionDAO.findById(Long.parseLong(definitionId));
                    AlertResourceProviderUtils.verifyViewAuthorization(alertDefinition);
                    continue;
                }
                AlertResourceProviderUtils.verifyViewAuthorization("", this.getClusterResourceId(clusterName));
            }
            catch (OBDPException e) {
                throw new SystemException(e.getMessage(), e);
            }
        }
        LinkedHashSet<Resource> results = new LinkedHashSet<Resource>();
        Set<String> requestPropertyIds = this.getRequestPropertyIds(request, predicate);
        AlertHistoryRequest historyRequest = new AlertHistoryRequest();
        historyRequest.Predicate = predicate;
        historyRequest.Pagination = request.getPageRequest();
        historyRequest.Sort = request.getSortRequest();
        List<AlertHistoryEntity> entities = s_dao.findAll(historyRequest);
        for (AlertHistoryEntity entity : entities) {
            results.add(this.toResource(entity, requestPropertyIds));
        }
        return results;
    }

    @Override
    public QueryResponse queryForResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        return new QueryResponseImpl(this.getResources(request, predicate), request.getSortRequest() != null, request.getPageRequest() != null, s_dao.getCount(predicate));
    }

    private Resource toResource(AlertHistoryEntity entity, Set<String> requestedIds) {
        AlertDefinitionEntity definition = entity.getAlertDefinition();
        ClusterEntity cluster = definition.getCluster();
        ResourceImpl resource = new ResourceImpl(Resource.Type.AlertHistory);
        resource.setProperty(ALERT_HISTORY_ID, entity.getAlertId());
        if (null != cluster) {
            AlertHistoryResourceProvider.setResourceProperty(resource, ALERT_HISTORY_CLUSTER_NAME, cluster.getClusterName(), requestedIds);
        }
        AlertHistoryResourceProvider.setResourceProperty(resource, ALERT_HISTORY_DEFINITION_ID, definition.getDefinitionId(), requestedIds);
        AlertHistoryResourceProvider.setResourceProperty(resource, ALERT_HISTORY_DEFINITION_NAME, definition.getDefinitionName(), requestedIds);
        AlertHistoryResourceProvider.setResourceProperty(resource, ALERT_HISTORY_SERVICE_NAME, entity.getServiceName(), requestedIds);
        AlertHistoryResourceProvider.setResourceProperty(resource, ALERT_HISTORY_COMPONENT_NAME, entity.getComponentName(), requestedIds);
        AlertHistoryResourceProvider.setResourceProperty(resource, ALERT_HISTORY_HOSTNAME, entity.getHostName(), requestedIds);
        AlertHistoryResourceProvider.setResourceProperty(resource, ALERT_HISTORY_LABEL, entity.getAlertLabel(), requestedIds);
        AlertHistoryResourceProvider.setResourceProperty(resource, ALERT_HISTORY_STATE, (Object)entity.getAlertState(), requestedIds);
        AlertHistoryResourceProvider.setResourceProperty(resource, ALERT_HISTORY_TEXT, entity.getAlertText(), requestedIds);
        AlertHistoryResourceProvider.setResourceProperty(resource, ALERT_HISTORY_TIMESTAMP, entity.getAlertTimestamp(), requestedIds);
        AlertHistoryResourceProvider.setResourceProperty(resource, ALERT_HISTORY_INSTANCE, entity.getAlertInstance(), requestedIds);
        return resource;
    }

    static {
        PROPERTY_IDS.add(ALERT_HISTORY_DEFINITION_ID);
        PROPERTY_IDS.add(ALERT_HISTORY_DEFINITION_NAME);
        PROPERTY_IDS.add(ALERT_HISTORY_ID);
        PROPERTY_IDS.add(ALERT_HISTORY_CLUSTER_NAME);
        PROPERTY_IDS.add(ALERT_HISTORY_SERVICE_NAME);
        PROPERTY_IDS.add(ALERT_HISTORY_COMPONENT_NAME);
        PROPERTY_IDS.add(ALERT_HISTORY_HOSTNAME);
        PROPERTY_IDS.add(ALERT_HISTORY_LABEL);
        PROPERTY_IDS.add(ALERT_HISTORY_STATE);
        PROPERTY_IDS.add(ALERT_HISTORY_TEXT);
        PROPERTY_IDS.add(ALERT_HISTORY_TIMESTAMP);
        PROPERTY_IDS.add(ALERT_HISTORY_INSTANCE);
        KEY_PROPERTY_IDS.put(Resource.Type.AlertHistory, ALERT_HISTORY_ID);
        KEY_PROPERTY_IDS.put(Resource.Type.Cluster, ALERT_HISTORY_CLUSTER_NAME);
        KEY_PROPERTY_IDS.put(Resource.Type.Service, ALERT_HISTORY_SERVICE_NAME);
        KEY_PROPERTY_IDS.put(Resource.Type.Host, ALERT_HISTORY_HOSTNAME);
    }
}

