/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.agent.stomp.dto.AlertGroupUpdate;
import id.onyx.obdp.server.controller.AlertDefinitionResponse;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.AlertResourceProviderUtils;
import id.onyx.obdp.server.controller.internal.BaseProvider;
import id.onyx.obdp.server.controller.internal.RequestImpl;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.events.AlertGroupsUpdateEvent;
import id.onyx.obdp.server.events.UpdateEventType;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.orm.dao.AlertDefinitionDAO;
import id.onyx.obdp.server.orm.dao.AlertDispatchDAO;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.AlertGroupEntity;
import id.onyx.obdp.server.orm.entities.AlertTargetEntity;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.alert.AlertTarget;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class AlertGroupResourceProvider
extends AbstractControllerResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AlertGroupResourceProvider.class);
    public static final String ALERT_GROUP = "AlertGroup";
    public static final String ID_PROPERTY_ID = "id";
    public static final String CLUSTER_NAME_PROPERTY_ID = "cluster_name";
    public static final String NAME_PROPERTY_ID = "name";
    public static final String DEFAULT_PROPERTY_ID = "default";
    public static final String DEFINITIONS_PROPERTY_ID = "definitions";
    public static final String TARGETS_PROPERTY_ID = "targets";
    public static final String ALERT_GROUP_ID = "AlertGroup/id";
    public static final String ALERT_GROUP_CLUSTER_NAME = "AlertGroup/cluster_name";
    public static final String ALERT_GROUP_NAME = "AlertGroup/name";
    public static final String ALERT_GROUP_DEFAULT = "AlertGroup/default";
    public static final String ALERT_GROUP_DEFINITIONS = "AlertGroup/definitions";
    public static final String ALERT_GROUP_TARGETS = "AlertGroup/targets";
    private static final Set<String> PK_PROPERTY_IDS = new HashSet<String>(Arrays.asList("AlertGroup/id", "AlertGroup/cluster_name"));
    private static final Set<String> PROPERTY_IDS = new HashSet<String>();
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS = new HashMap<Resource.Type, String>();
    @Inject
    private static AlertDispatchDAO s_dao;
    @Inject
    private static AlertDefinitionDAO s_definitionDao;
    @Inject
    private static STOMPUpdatePublisher STOMPUpdatePublisher;

    AlertGroupResourceProvider(OBDPManagementController controller) {
        super(Resource.Type.AlertGroup, PROPERTY_IDS, KEY_PROPERTY_IDS, controller);
    }

    @Override
    public RequestStatus createResources(final Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        this.createResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException, AuthorizationException {
                AlertGroupResourceProvider.this.createAlertGroups(request.getProperties());
                return null;
            }
        });
        this.notifyCreate(Resource.Type.AlertGroup, request);
        return this.getRequestStatus(null);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> results = new HashSet<Resource>();
        Set<String> requestPropertyIds = this.getRequestPropertyIds(request, predicate);
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            String clusterName = (String)propertyMap.get(ALERT_GROUP_CLUSTER_NAME);
            if (null == clusterName || clusterName.isEmpty()) {
                throw new IllegalArgumentException("The cluster name is required when retrieving alert groups");
            }
            String id = (String)propertyMap.get(ALERT_GROUP_ID);
            if (null != id) {
                AlertGroupEntity entity = s_dao.findGroupById(Long.parseLong(id));
                if (null == entity) continue;
                try {
                    AlertResourceProviderUtils.verifyViewAuthorization(entity, this.getClusterResourceId(entity.getClusterId()));
                }
                catch (OBDPException e) {
                    throw new SystemException(e.getMessage(), e);
                }
                results.add(this.toResource(clusterName, entity, requestPropertyIds));
                continue;
            }
            Cluster cluster = null;
            try {
                cluster = this.getManagementController().getClusters().getCluster(clusterName);
            }
            catch (OBDPException ae) {
                throw new NoSuchResourceException("Parent Cluster resource doesn't exist", ae);
            }
            List<AlertGroupEntity> entities = s_dao.findAllGroups(cluster.getClusterId());
            for (AlertGroupEntity entity : entities) {
                try {
                    if (!AlertResourceProviderUtils.hasViewAuthorization(entity, this.getClusterResourceId(entity.getClusterId()))) continue;
                    results.add(this.toResource(clusterName, entity, requestPropertyIds));
                }
                catch (OBDPException e) {
                    throw new SystemException(e.getMessage(), e);
                }
            }
        }
        return results;
    }

    @Override
    public RequestStatus updateResources(final Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        this.modifyResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException, AuthorizationException {
                AlertGroupResourceProvider.this.updateAlertGroups(request.getProperties());
                return null;
            }
        });
        this.notifyUpdate(Resource.Type.AlertGroup, request, predicate);
        return this.getRequestStatus(null);
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Set<Resource> resources = this.getResources(new RequestImpl(null, null, null, null), predicate);
        HashMap<Long, AlertGroupEntity> entities = new HashMap<Long, AlertGroupEntity>();
        for (Resource resource : resources) {
            Long id = (Long)resource.getPropertyValue(ALERT_GROUP_ID);
            if (entities.containsKey(id)) continue;
            AlertGroupEntity entity = s_dao.findGroupById(id);
            try {
                AlertResourceProviderUtils.verifyManageAuthorization(entity, this.getClusterResourceId(entity.getClusterId()));
                entities.put(id, entity);
            }
            catch (OBDPException e) {
                LOG.warn("The default alert group for {} cannot be removed", (Object)entity.getServiceName(), (Object)e);
            }
        }
        for (final AlertGroupEntity entity : entities.values()) {
            LOG.info("Deleting alert group {}", (Object)entity.getGroupId());
            if (entity.isDefault()) {
                LOG.warn("The default alert group for {} cannot be removed", (Object)entity.getServiceName());
                continue;
            }
            this.modifyResources(new AbstractResourceProvider.Command<Void>(){

                @Override
                public Void invoke() throws OBDPException {
                    s_dao.remove(entity);
                    return null;
                }
            });
        }
        this.notifyDelete(Resource.Type.AlertGroup, predicate);
        return this.getRequestStatus(null);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return PK_PROPERTY_IDS;
    }

    private void createAlertGroups(Set<Map<String, Object>> requestMaps) throws OBDPException, AuthorizationException {
        ArrayList<AlertGroupEntity> entities = new ArrayList<AlertGroupEntity>();
        for (Map<String, Object> requestMap : requestMaps) {
            AlertGroupEntity entity = new AlertGroupEntity();
            String name = (String)requestMap.get(ALERT_GROUP_NAME);
            String clusterName = (String)requestMap.get(ALERT_GROUP_CLUSTER_NAME);
            if (StringUtils.isEmpty((String)name)) {
                throw new IllegalArgumentException("The name of the alert group is required.");
            }
            if (StringUtils.isEmpty((String)clusterName)) {
                throw new IllegalArgumentException("The name of the cluster is required when creating an alert group.");
            }
            Cluster cluster = this.getManagementController().getClusters().getCluster(clusterName);
            entity.setClusterId(cluster.getClusterId());
            entity.setGroupName(name);
            entity.setDefault(false);
            if (requestMap.containsKey(ALERT_GROUP_TARGETS)) {
                List targetIds = (List)requestMap.get(ALERT_GROUP_TARGETS);
                HashSet<AlertTargetEntity> targets = new HashSet<AlertTargetEntity>();
                targets.addAll(s_dao.findTargetsById(targetIds));
                entity.setAlertTargets(targets);
            }
            if (requestMap.containsKey(ALERT_GROUP_DEFINITIONS)) {
                List definitionIds = (List)requestMap.get(ALERT_GROUP_DEFINITIONS);
                HashSet<AlertDefinitionEntity> definitions = new HashSet<AlertDefinitionEntity>();
                definitions.addAll(s_definitionDao.findByIds(definitionIds));
                entity.setAlertDefinitions(definitions);
            }
            AlertResourceProviderUtils.verifyManageAuthorization(entity, cluster.getResourceId());
            entities.add(entity);
        }
        s_dao.createGroups(entities);
    }

    private void updateAlertGroups(Set<Map<String, Object>> requestMaps) throws OBDPException, AuthorizationException {
        for (Map<String, Object> requestMap : requestMaps) {
            ArrayList<Long> ids;
            String stringId = (String)requestMap.get(ALERT_GROUP_ID);
            if (StringUtils.isEmpty((String)stringId)) {
                throw new IllegalArgumentException("The ID of the alert group is required when updating an existing group");
            }
            long id = Long.parseLong(stringId);
            AlertGroupEntity entity = s_dao.findGroupById(id);
            if (null == entity) {
                String message = MessageFormat.format("The alert group with ID {0} could not be found", id);
                throw new OBDPException(message);
            }
            AlertResourceProviderUtils.verifyManageAuthorization(entity, this.getClusterResourceId(entity.getClusterId()));
            String name = (String)requestMap.get(ALERT_GROUP_NAME);
            Collection targetIds = (Collection)requestMap.get(ALERT_GROUP_TARGETS);
            Collection definitionIds = (Collection)requestMap.get(ALERT_GROUP_DEFINITIONS);
            if (null != targetIds) {
                HashSet<AlertTargetEntity> targets = new HashSet<AlertTargetEntity>();
                ids = new ArrayList<Long>(targetIds.size());
                ids.addAll(targetIds);
                if (ids.size() > 0) {
                    targets.addAll(s_dao.findTargetsById(ids));
                }
                entity.setAlertTargets(targets);
            }
            if (!entity.isDefault()) {
                if (!StringUtils.isBlank((String)name)) {
                    entity.setGroupName(name);
                }
                HashSet<AlertDefinitionEntity> definitions = new HashSet<AlertDefinitionEntity>();
                if (null != definitionIds && definitionIds.size() > 0) {
                    ids = new ArrayList(definitionIds.size());
                    ids.addAll(definitionIds);
                    definitions.addAll(s_definitionDao.findByIds(ids));
                    entity.setAlertDefinitions(definitions);
                } else {
                    entity.setAlertDefinitions(definitions);
                }
            }
            s_dao.merge(entity);
            AlertGroupsUpdateEvent alertGroupsUpdateEvent = new AlertGroupsUpdateEvent(Collections.singletonList(new AlertGroupUpdate(entity)), UpdateEventType.UPDATE);
            STOMPUpdatePublisher.publish(alertGroupsUpdateEvent);
        }
    }

    private Resource toResource(String clusterName, AlertGroupEntity entity, Set<String> requestedIds) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.AlertGroup);
        resource.setProperty(ALERT_GROUP_ID, entity.getGroupId());
        resource.setProperty(ALERT_GROUP_NAME, entity.getGroupName());
        resource.setProperty(ALERT_GROUP_CLUSTER_NAME, clusterName);
        AlertGroupResourceProvider.setResourceProperty(resource, ALERT_GROUP_DEFAULT, entity.isDefault(), requestedIds);
        if (BaseProvider.isPropertyRequested(ALERT_GROUP_DEFINITIONS, requestedIds)) {
            Set<AlertDefinitionEntity> definitions = entity.getAlertDefinitions();
            ArrayList<AlertDefinitionResponse> definitionList = new ArrayList<AlertDefinitionResponse>(definitions.size());
            for (AlertDefinitionEntity definition : definitions) {
                AlertDefinitionResponse response = AlertDefinitionResponse.coerce(definition);
                definitionList.add(response);
            }
            resource.setProperty(ALERT_GROUP_DEFINITIONS, definitionList);
        }
        if (BaseProvider.isPropertyRequested(ALERT_GROUP_TARGETS, requestedIds)) {
            Set<AlertTargetEntity> targetEntities = entity.getAlertTargets();
            ArrayList<AlertTarget> targets = new ArrayList<AlertTarget>(targetEntities.size());
            for (AlertTargetEntity targetEntity : targetEntities) {
                AlertTarget target = AlertTarget.coerce(targetEntity);
                targets.add(target);
            }
            resource.setProperty(ALERT_GROUP_TARGETS, targets);
        }
        return resource;
    }

    static {
        PROPERTY_IDS.add(ALERT_GROUP_ID);
        PROPERTY_IDS.add(ALERT_GROUP_CLUSTER_NAME);
        PROPERTY_IDS.add(ALERT_GROUP_NAME);
        PROPERTY_IDS.add(ALERT_GROUP_DEFAULT);
        PROPERTY_IDS.add(ALERT_GROUP_DEFINITIONS);
        PROPERTY_IDS.add(ALERT_GROUP_TARGETS);
        KEY_PROPERTY_IDS.put(Resource.Type.AlertGroup, ALERT_GROUP_ID);
        KEY_PROPERTY_IDS.put(Resource.Type.Cluster, ALERT_GROUP_CLUSTER_NAME);
    }
}

