/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.agent.AlertExecutionCommand;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.AlertResourceProviderUtils;
import id.onyx.obdp.server.controller.internal.RequestImpl;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.events.AlertDefinitionDisabledEvent;
import id.onyx.obdp.server.events.AlertHashInvalidationEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.orm.dao.AlertDefinitionDAO;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.alert.AlertDefinition;
import id.onyx.obdp.server.state.alert.AlertDefinitionFactory;
import id.onyx.obdp.server.state.alert.AlertDefinitionHash;
import id.onyx.obdp.server.state.alert.Scope;
import id.onyx.obdp.server.state.alert.SourceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class AlertDefinitionResourceProvider
extends AbstractControllerResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AlertDefinitionResourceProvider.class);
    protected static final String ALERT_DEF = "AlertDefinition";
    protected static final String ALERT_DEF_CLUSTER_NAME = "AlertDefinition/cluster_name";
    protected static final String ALERT_DEF_ID = "AlertDefinition/id";
    protected static final String ALERT_DEF_NAME = "AlertDefinition/name";
    protected static final String ALERT_DEF_LABEL = "AlertDefinition/label";
    protected static final String ALERT_DEF_HELP_URL = "AlertDefinition/help_url";
    protected static final String ALERT_DEF_DESCRIPTION = "AlertDefinition/description";
    protected static final String ALERT_DEF_INTERVAL = "AlertDefinition/interval";
    protected static final String ALERT_DEF_SERVICE_NAME = "AlertDefinition/service_name";
    protected static final String ALERT_DEF_COMPONENT_NAME = "AlertDefinition/component_name";
    protected static final String ALERT_DEF_ENABLED = "AlertDefinition/enabled";
    protected static final String ALERT_DEF_SCOPE = "AlertDefinition/scope";
    protected static final String ALERT_DEF_IGNORE_HOST = "AlertDefinition/ignore_host";
    protected static final String ALERT_DEF_REPEAT_TOLERANCE = "AlertDefinition/repeat_tolerance";
    protected static final String ALERT_DEF_REPEAT_TOLERANCE_ENABLED = "AlertDefinition/repeat_tolerance_enabled";
    protected static final String ALERT_DEF_SOURCE = "AlertDefinition/source";
    protected static final String ALERT_DEF_SOURCE_TYPE = "AlertDefinition/source/type";
    private static final Set<String> pkPropertyIds = new HashSet<String>(Arrays.asList("AlertDefinition/id", "AlertDefinition/name"));
    private static Gson gson = new Gson();
    @Inject
    private static AlertDefinitionHash alertDefinitionHash;
    @Inject
    private static AlertDefinitionDAO alertDefinitionDAO;
    @Inject
    private static AlertDefinitionFactory definitionFactory;
    @Inject
    private static OBDPEventPublisher eventPublisher;
    private static final Set<String> PROPERTY_IDS;
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS;

    AlertDefinitionResourceProvider(OBDPManagementController controller) {
        super(Resource.Type.AlertDefinition, PROPERTY_IDS, KEY_PROPERTY_IDS, controller);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return pkPropertyIds;
    }

    @Override
    public RequestStatus createResources(final Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        this.createResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException, AuthorizationException {
                AlertDefinitionResourceProvider.this.createAlertDefinitions(request.getProperties());
                return null;
            }
        });
        this.notifyCreate(Resource.Type.AlertDefinition, request);
        return this.getRequestStatus(null);
    }

    private void createAlertDefinitions(Set<Map<String, Object>> requestMaps) throws OBDPException, AuthorizationException {
        ArrayList<AlertDefinitionEntity> entities = new ArrayList<AlertDefinitionEntity>();
        String clusterName = null;
        for (Map<String, Object> requestMap : requestMaps) {
            AlertDefinitionEntity entity = new AlertDefinitionEntity();
            this.populateEntity(entity, requestMap);
            entities.add(entity);
            if (null != clusterName) continue;
            clusterName = (String)requestMap.get(ALERT_DEF_CLUSTER_NAME);
        }
        for (AlertDefinitionEntity entity : entities) {
            alertDefinitionDAO.create(entity);
            long clusterId = entity.getClusterId();
            Set<String> invalidatedHosts = alertDefinitionHash.invalidateHosts(entity);
            AlertHashInvalidationEvent event = new AlertHashInvalidationEvent(clusterId, invalidatedHosts);
            eventPublisher.publish(event);
        }
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Set<String> requestPropertyIds = this.getRequestPropertyIds(request, predicate);
        LinkedHashSet<Resource> results = new LinkedHashSet<Resource>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            String clusterName = (String)propertyMap.get(ALERT_DEF_CLUSTER_NAME);
            if (null == clusterName || clusterName.isEmpty()) {
                throw new IllegalArgumentException("Invalid argument, cluster name is required");
            }
            String id = (String)propertyMap.get(ALERT_DEF_ID);
            if (null != id) {
                AlertDefinitionEntity entity = alertDefinitionDAO.findById(Long.parseLong(id));
                if (null == entity) continue;
                AlertResourceProviderUtils.verifyViewAuthorization(entity);
                results.add(this.toResource(clusterName, entity, requestPropertyIds));
                continue;
            }
            Cluster cluster = null;
            try {
                cluster = this.getManagementController().getClusters().getCluster(clusterName);
            }
            catch (OBDPException e) {
                throw new NoSuchResourceException("Parent Cluster resource doesn't exist", e);
            }
            List<AlertDefinitionEntity> entities = alertDefinitionDAO.findAll(cluster.getClusterId());
            boolean serviceLevelAuthorization = AlertResourceProviderUtils.hasViewAuthorization("_SERVICE_NAME_", cluster.getResourceId());
            boolean clusterLevelAuthorization = AlertResourceProviderUtils.hasViewAuthorization("", cluster.getResourceId());
            for (AlertDefinitionEntity entity : entities) {
                String serviceName = entity.getServiceName();
                if (!(StringUtils.isEmpty((String)serviceName) || "OBDP".equals(serviceName) ? clusterLevelAuthorization : serviceLevelAuthorization)) continue;
                results.add(this.toResource(clusterName, entity, requestPropertyIds));
            }
        }
        return results;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Map<String, String> requestInfoProps = request.getRequestInfoProperties();
        if (null != requestInfoProps && requestInfoProps.containsKey("run_now")) {
            Set<Map<String, Object>> predicateMaps = this.getPropertyMaps(predicate);
            for (Map<String, Object> propertyMap : predicateMaps) {
                this.scheduleImmediateAlert(propertyMap);
            }
            return this.getRequestStatus(null);
        }
        for (Map<String, Object> requestPropMap : request.getProperties()) {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(requestPropMap, predicate)) {
                String stringId = (String)propertyMap.get(ALERT_DEF_ID);
                long id = Long.parseLong(stringId);
                AlertDefinitionEntity entity = alertDefinitionDAO.findById(id);
                if (null == entity) continue;
                boolean oldEnabled = entity.getEnabled();
                try {
                    this.populateEntity(entity, propertyMap);
                    alertDefinitionDAO.merge(entity);
                    Set<String> invalidatedHosts = alertDefinitionHash.invalidateHosts(entity);
                    AlertHashInvalidationEvent event = new AlertHashInvalidationEvent(entity.getClusterId(), invalidatedHosts);
                    eventPublisher.publish(event);
                }
                catch (OBDPException ae) {
                    LOG.error("Unable to find cluster when updating alert definition", (Throwable)ae);
                }
                if (!oldEnabled || entity.getEnabled()) continue;
                AlertDefinitionDisabledEvent event = new AlertDefinitionDisabledEvent(entity.getClusterId(), entity.getDefinitionId(), entity.getDefinitionName());
                eventPublisher.publish(event);
            }
        }
        this.notifyUpdate(Resource.Type.AlertDefinition, request, predicate);
        return this.getRequestStatus(null);
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Set<Resource> resources = this.getResources(new RequestImpl(null, null, null, null), predicate);
        HashSet<Long> definitionIds = new HashSet<Long>();
        for (Resource resource : resources) {
            Long id = (Long)resource.getPropertyValue(ALERT_DEF_ID);
            definitionIds.add(id);
        }
        for (Long definitionId : definitionIds) {
            LOG.info("Deleting alert definition {}", (Object)definitionId);
            final AlertDefinitionEntity entity = alertDefinitionDAO.findById(definitionId);
            AlertResourceProviderUtils.verifyManageAuthorization(entity);
            this.modifyResources(new AbstractResourceProvider.Command<Void>(){

                @Override
                public Void invoke() throws OBDPException {
                    long clusterId = entity.getClusterId();
                    alertDefinitionDAO.remove(entity);
                    Set<String> invalidatedHosts = alertDefinitionHash.invalidateHosts(entity);
                    AlertHashInvalidationEvent event = new AlertHashInvalidationEvent(clusterId, invalidatedHosts);
                    eventPublisher.publish(event);
                    return null;
                }
            });
        }
        this.notifyDelete(Resource.Type.AlertDefinition, predicate);
        return this.getRequestStatus(null);
    }

    private void populateEntity(AlertDefinitionEntity entity, Map<String, Object> requestMap) throws OBDPException, AuthorizationException {
        boolean bCreate = true;
        if (null != entity.getDefinitionId()) {
            bCreate = false;
        }
        String clusterName = (String)requestMap.get(ALERT_DEF_CLUSTER_NAME);
        String definitionName = (String)requestMap.get(ALERT_DEF_NAME);
        String serviceName = (String)requestMap.get(ALERT_DEF_SERVICE_NAME);
        String componentName = (String)requestMap.get(ALERT_DEF_COMPONENT_NAME);
        String type = (String)requestMap.get(ALERT_DEF_SOURCE_TYPE);
        String label = (String)requestMap.get(ALERT_DEF_LABEL);
        String helpURL = (String)requestMap.get(ALERT_DEF_HELP_URL);
        String description = (String)requestMap.get(ALERT_DEF_DESCRIPTION);
        String desiredScope = (String)requestMap.get(ALERT_DEF_SCOPE);
        Integer interval = null;
        if (requestMap.containsKey(ALERT_DEF_INTERVAL)) {
            interval = Integer.valueOf((String)requestMap.get(ALERT_DEF_INTERVAL));
        }
        Boolean enabled = null;
        if (requestMap.containsKey(ALERT_DEF_ENABLED)) {
            enabled = Boolean.parseBoolean((String)requestMap.get(ALERT_DEF_ENABLED));
        } else if (bCreate) {
            enabled = Boolean.TRUE;
        }
        Boolean ignoreHost = null;
        if (requestMap.containsKey(ALERT_DEF_IGNORE_HOST)) {
            ignoreHost = Boolean.parseBoolean((String)requestMap.get(ALERT_DEF_IGNORE_HOST));
        } else if (bCreate) {
            ignoreHost = Boolean.FALSE;
        }
        Scope scope = null;
        if (null != desiredScope && desiredScope.length() > 0) {
            scope = Scope.valueOf(desiredScope);
        }
        SourceType sourceType = null;
        if (null != type && type.length() > 0) {
            sourceType = SourceType.valueOf(type);
        }
        if (null == scope && bCreate) {
            scope = Scope.ANY;
        }
        Integer repeatTolerance = null;
        if (requestMap.containsKey(ALERT_DEF_REPEAT_TOLERANCE)) {
            repeatTolerance = Integer.valueOf((String)requestMap.get(ALERT_DEF_REPEAT_TOLERANCE));
        }
        Boolean repeatToleranceEnabled = null;
        if (requestMap.containsKey(ALERT_DEF_REPEAT_TOLERANCE_ENABLED)) {
            repeatToleranceEnabled = Boolean.valueOf(requestMap.get(ALERT_DEF_REPEAT_TOLERANCE_ENABLED).toString());
        }
        if (StringUtils.isEmpty((String)clusterName)) {
            throw new IllegalArgumentException("Invalid argument, cluster name is required");
        }
        if (bCreate && !requestMap.containsKey(ALERT_DEF_INTERVAL)) {
            throw new IllegalArgumentException("Check interval must be specified");
        }
        if (bCreate && StringUtils.isEmpty((String)definitionName)) {
            throw new IllegalArgumentException("Definition name must be specified");
        }
        if (bCreate && StringUtils.isEmpty((String)serviceName)) {
            throw new IllegalArgumentException("Service name must be specified");
        }
        if (bCreate && null == sourceType) {
            throw new IllegalArgumentException(String.format("Source type must be specified and one of %s", EnumSet.allOf(SourceType.class)));
        }
        HashMap<String, JsonObject> jsonObjectMapping = new HashMap<String, JsonObject>();
        for (Map.Entry<String, Object> entry : requestMap.entrySet()) {
            String propertyKey = entry.getKey();
            if (!propertyKey.startsWith(ALERT_DEF_SOURCE)) continue;
            JsonObject jsonObject = this.getJsonObjectMapping(ALERT_DEF_SOURCE, jsonObjectMapping, propertyKey);
            String propertyName = PropertyHelper.getPropertyName(propertyKey);
            Object entryValue = entry.getValue();
            if (entryValue instanceof Collection) {
                JsonElement jsonElement = gson.toJsonTree(entryValue);
                jsonObject.add(propertyName, jsonElement);
                continue;
            }
            if (entryValue instanceof Number) {
                jsonObject.addProperty(propertyName, (Number)entryValue);
                continue;
            }
            String value = entryValue.toString();
            if (StringUtils.isNotEmpty((String)value) && NumberUtils.isNumber((String)value)) {
                Number number = NumberUtils.createNumber((String)value);
                jsonObject.addProperty(propertyName, number);
                continue;
            }
            jsonObject.addProperty(propertyName, value);
        }
        JsonObject source = (JsonObject)jsonObjectMapping.get(ALERT_DEF_SOURCE);
        if (bCreate && (null == source || 0 == source.entrySet().size())) {
            throw new IllegalArgumentException("Source must be specified");
        }
        Clusters clusters = this.getManagementController().getClusters();
        Cluster cluster = clusters.getCluster(clusterName);
        Long clusterId = cluster.getClusterId();
        boolean managed = false;
        boolean toggled = false;
        if (!clusterId.equals(entity.getClusterId())) {
            entity.setClusterId(clusterId);
            managed = true;
        }
        if (null != componentName && !componentName.equals(entity.getComponentName())) {
            entity.setComponentName(componentName);
            managed = true;
        }
        if (null != definitionName && !definitionName.equals(entity.getDefinitionName())) {
            entity.setDefinitionName(definitionName);
            managed = true;
        }
        if (null != label && !label.equals(entity.getLabel())) {
            entity.setLabel(label);
            managed = true;
        }
        if (null != helpURL && !helpURL.equals(entity.getHelpURL())) {
            entity.setHelpURL(helpURL);
            managed = true;
        }
        if (null != description && !description.equals(entity.getDescription())) {
            entity.setDescription(description);
            managed = true;
        }
        if (null != enabled && !enabled.equals(entity.getEnabled())) {
            entity.setEnabled(enabled);
            toggled = true;
        }
        if (null != ignoreHost && !ignoreHost.equals(entity.isHostIgnored())) {
            entity.setHostIgnored(ignoreHost);
            managed = true;
        }
        if (null != interval && !interval.equals(entity.getScheduleInterval())) {
            entity.setScheduleInterval(interval);
            managed = true;
        }
        if (null != serviceName && !serviceName.equals(entity.getServiceName())) {
            entity.setServiceName(serviceName);
            managed = true;
        }
        if (null != sourceType && !sourceType.equals((Object)entity.getSourceType())) {
            entity.setSourceType(sourceType);
            managed = true;
        }
        if (null != source) {
            entity.setSource(source.toString());
            managed = true;
        }
        if (null != scope && !scope.equals((Object)entity.getScope())) {
            entity.setScope(scope);
            managed = true;
        }
        if (entity.getSourceType() != SourceType.AGGREGATE) {
            if (null != repeatTolerance) {
                entity.setRepeatTolerance(repeatTolerance);
                managed = true;
            }
            if (null != repeatToleranceEnabled) {
                entity.setRepeatToleranceEnabled(repeatToleranceEnabled);
                managed = true;
            }
        }
        if (managed) {
            AlertResourceProviderUtils.verifyManageAuthorization(entity);
        } else if (toggled) {
            AlertResourceProviderUtils.verifyToggleAuthorization(entity);
        }
        entity.setHash(UUID.randomUUID().toString());
    }

    private JsonObject getJsonObjectMapping(String root, Map<String, JsonObject> jsonObjectMapping, String propertyKey) {
        if (jsonObjectMapping.containsKey(propertyKey)) {
            return jsonObjectMapping.get(propertyKey);
        }
        if (root.equals(propertyKey)) {
            JsonObject jsonRoot = jsonObjectMapping.get(root);
            if (null == jsonRoot) {
                jsonRoot = new JsonObject();
                jsonObjectMapping.put(root, jsonRoot);
            }
            return jsonRoot;
        }
        String propertyCategory = PropertyHelper.getPropertyCategory(propertyKey);
        JsonObject categoryJson = jsonObjectMapping.get(propertyCategory);
        if (null == categoryJson) {
            JsonObject parent = this.getJsonObjectMapping(root, jsonObjectMapping, propertyCategory);
            categoryJson = new JsonObject();
            jsonObjectMapping.put(propertyCategory, categoryJson);
            String categoryName = PropertyHelper.getPropertyName(propertyCategory);
            parent.add(categoryName, (JsonElement)categoryJson);
        }
        return categoryJson;
    }

    private Resource toResource(String clusterName, AlertDefinitionEntity entity, Set<String> requestedIds) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.AlertDefinition);
        resource.setProperty(ALERT_DEF_ID, entity.getDefinitionId());
        resource.setProperty(ALERT_DEF_CLUSTER_NAME, clusterName);
        resource.setProperty(ALERT_DEF_NAME, entity.getDefinitionName());
        resource.setProperty(ALERT_DEF_LABEL, entity.getLabel());
        AlertDefinitionResourceProvider.setResourceProperty(resource, ALERT_DEF_DESCRIPTION, entity.getDescription(), requestedIds);
        AlertDefinitionResourceProvider.setResourceProperty(resource, ALERT_DEF_INTERVAL, entity.getScheduleInterval(), requestedIds);
        AlertDefinitionResourceProvider.setResourceProperty(resource, ALERT_DEF_SERVICE_NAME, entity.getServiceName(), requestedIds);
        AlertDefinitionResourceProvider.setResourceProperty(resource, ALERT_DEF_COMPONENT_NAME, entity.getComponentName(), requestedIds);
        AlertDefinitionResourceProvider.setResourceProperty(resource, ALERT_DEF_ENABLED, entity.getEnabled(), requestedIds);
        AlertDefinitionResourceProvider.setResourceProperty(resource, ALERT_DEF_IGNORE_HOST, entity.isHostIgnored(), requestedIds);
        AlertDefinitionResourceProvider.setResourceProperty(resource, ALERT_DEF_SCOPE, (Object)entity.getScope(), requestedIds);
        AlertDefinitionResourceProvider.setResourceProperty(resource, ALERT_DEF_HELP_URL, entity.getHelpURL(), requestedIds);
        AlertDefinitionResourceProvider.setResourceProperty(resource, ALERT_DEF_REPEAT_TOLERANCE, entity.getRepeatTolerance(), requestedIds);
        AlertDefinitionResourceProvider.setResourceProperty(resource, ALERT_DEF_REPEAT_TOLERANCE_ENABLED, entity.isRepeatToleranceEnabled(), requestedIds);
        boolean sourceTypeRequested = AlertDefinitionResourceProvider.setResourceProperty(resource, ALERT_DEF_SOURCE_TYPE, (Object)entity.getSourceType(), requestedIds);
        if (sourceTypeRequested && null != resource.getPropertyValue(ALERT_DEF_SOURCE_TYPE)) {
            try {
                Map map = (Map)gson.fromJson(entity.getSource(), Map.class);
                for (Map.Entry entry : map.entrySet()) {
                    String subProp = PropertyHelper.getPropertyId(ALERT_DEF_SOURCE, (String)entry.getKey());
                    resource.setProperty(subProp, entry.getValue());
                }
            }
            catch (Exception e) {
                LOG.error("Could not coerce alert JSON into a type");
            }
        }
        return resource;
    }

    private void scheduleImmediateAlert(Map<String, Object> propertyMap) throws AuthorizationException {
        Clusters clusters = this.getManagementController().getClusters();
        String stringId = (String)propertyMap.get(ALERT_DEF_ID);
        long id = Long.parseLong(stringId);
        AlertDefinitionEntity entity = alertDefinitionDAO.findById(id);
        if (null == entity) {
            LOG.error("Unable to lookup alert definition with ID {}", (Object)id);
            return;
        }
        Cluster cluster = null;
        try {
            cluster = clusters.getClusterById(entity.getClusterId());
        }
        catch (OBDPException ambariException) {
            LOG.error("Unable to lookup cluster with ID {}", (Object)entity.getClusterId(), (Object)ambariException);
            return;
        }
        AlertResourceProviderUtils.verifyExecuteAuthorization(entity);
        Set<String> hostNames = alertDefinitionHash.getAssociatedHosts(cluster, entity.getSourceType(), entity.getDefinitionName(), entity.getServiceName(), entity.getComponentName());
        for (String hostName : hostNames) {
            AlertDefinition definition = definitionFactory.coerce(entity);
            AlertExecutionCommand alertExecutionCommand = new AlertExecutionCommand(cluster.getClusterName(), hostName, definition);
        }
    }

    static {
        alertDefinitionDAO = null;
        PROPERTY_IDS = new HashSet<String>();
        KEY_PROPERTY_IDS = new HashMap<Resource.Type, String>();
        PROPERTY_IDS.add(ALERT_DEF_CLUSTER_NAME);
        PROPERTY_IDS.add(ALERT_DEF_SERVICE_NAME);
        PROPERTY_IDS.add(ALERT_DEF_COMPONENT_NAME);
        PROPERTY_IDS.add(ALERT_DEF_ID);
        PROPERTY_IDS.add(ALERT_DEF_NAME);
        PROPERTY_IDS.add(ALERT_DEF_LABEL);
        PROPERTY_IDS.add(ALERT_DEF_DESCRIPTION);
        PROPERTY_IDS.add(ALERT_DEF_HELP_URL);
        PROPERTY_IDS.add(ALERT_DEF_INTERVAL);
        PROPERTY_IDS.add(ALERT_DEF_ENABLED);
        PROPERTY_IDS.add(ALERT_DEF_SCOPE);
        PROPERTY_IDS.add(ALERT_DEF_IGNORE_HOST);
        PROPERTY_IDS.add(ALERT_DEF_REPEAT_TOLERANCE);
        PROPERTY_IDS.add(ALERT_DEF_REPEAT_TOLERANCE_ENABLED);
        PROPERTY_IDS.add(ALERT_DEF_SOURCE);
        KEY_PROPERTY_IDS.put(Resource.Type.AlertDefinition, ALERT_DEF_ID);
        KEY_PROPERTY_IDS.put(Resource.Type.Cluster, ALERT_DEF_CLUSTER_NAME);
    }
}

