/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.ActiveWidgetLayoutResponse;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.WidgetResponse;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.dao.UserDAO;
import id.onyx.obdp.server.orm.dao.WidgetDAO;
import id.onyx.obdp.server.orm.dao.WidgetLayoutDAO;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.orm.entities.WidgetEntity;
import id.onyx.obdp.server.orm.entities.WidgetLayoutEntity;
import id.onyx.obdp.server.orm.entities.WidgetLayoutUserWidgetEntity;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@StaticallyInject
public class ActiveWidgetLayoutResourceProvider
extends AbstractControllerResourceProvider {
    public static final String WIDGETLAYOUT_ID_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetLayoutInfo", "id");
    public static final String WIDGETLAYOUT_CLUSTER_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetLayoutInfo", "cluster_name");
    public static final String WIDGETLAYOUT_SECTION_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetLayoutInfo", "section_name");
    public static final String WIDGETLAYOUT_LAYOUT_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetLayoutInfo", "layout_name");
    public static final String WIDGETLAYOUT_SCOPE_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetLayoutInfo", "scope");
    public static final String WIDGETLAYOUT_WIDGETS_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetLayoutInfo", "widgets");
    public static final String WIDGETLAYOUT_USERNAME_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetLayoutInfo", "user_name");
    public static final String WIDGETLAYOUT_DISPLAY_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetLayoutInfo", "display_name");
    public static final String WIDGETLAYOUT = "WidgetLayouts";
    public static final String ID = "id";
    private static final Set<String> pkPropertyIds = ImmutableSet.builder().add((Object)WIDGETLAYOUT_ID_PROPERTY_ID).build();
    public static final Set<String> propertyIds = ImmutableSet.builder().add((Object)WIDGETLAYOUT_ID_PROPERTY_ID).add((Object)WIDGETLAYOUT_SECTION_NAME_PROPERTY_ID).add((Object)WIDGETLAYOUT_LAYOUT_NAME_PROPERTY_ID).add((Object)WIDGETLAYOUT_CLUSTER_NAME_PROPERTY_ID).add((Object)WIDGETLAYOUT_WIDGETS_PROPERTY_ID).add((Object)WIDGETLAYOUT_SCOPE_PROPERTY_ID).add((Object)WIDGETLAYOUT_USERNAME_PROPERTY_ID).add((Object)WIDGETLAYOUT_DISPLAY_NAME_PROPERTY_ID).add((Object)"WidgetLayouts").build();
    public static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.ActiveWidgetLayout, (Object)WIDGETLAYOUT_ID_PROPERTY_ID).put((Object)Resource.Type.User, (Object)WIDGETLAYOUT_USERNAME_PROPERTY_ID).build();
    @Inject
    private static UserDAO userDAO;
    @Inject
    private static WidgetDAO widgetDAO;
    @Inject
    private static WidgetLayoutDAO widgetLayoutDAO;
    @Inject
    private static Gson gson;

    public static void init(UserDAO userDAO, WidgetDAO widgetDAO, WidgetLayoutDAO widgetLayoutDAO, Gson gson) {
        ActiveWidgetLayoutResourceProvider.userDAO = userDAO;
        ActiveWidgetLayoutResourceProvider.widgetDAO = widgetDAO;
        ActiveWidgetLayoutResourceProvider.widgetLayoutDAO = widgetLayoutDAO;
        ActiveWidgetLayoutResourceProvider.gson = gson;
    }

    public ActiveWidgetLayoutResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.ActiveWidgetLayout, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new SystemException("The request is not supported");
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        ArrayList<WidgetLayoutEntity> layoutEntities = new ArrayList<WidgetLayoutEntity>();
        boolean isUserAdministrator = AuthorizationHelper.isAuthorized(ResourceType.OBDP, null, RoleAuthorization.OBDP_MANAGE_USERS);
        for (Map<String, Object> propertyMap : propertyMaps) {
            String userName = this.getUserName(propertyMap);
            if (!isUserAdministrator && !AuthorizationHelper.getAuthenticatedName().equalsIgnoreCase(userName)) {
                throw new AuthorizationException();
            }
            Type type = new TypeToken<Set<Map<String, String>>>(){}.getType();
            Set activeWidgetLayouts = (Set)gson.fromJson(userDAO.findUserByName(userName).getActiveWidgetLayouts(), type);
            if (activeWidgetLayouts == null) continue;
            for (Map widgetLayoutId : activeWidgetLayouts) {
                layoutEntities.add(widgetLayoutDAO.findById(Long.parseLong((String)widgetLayoutId.get(ID))));
            }
        }
        for (WidgetLayoutEntity layoutEntity : layoutEntities) {
            ActiveWidgetLayoutResponse activeWidgetLayoutResponse = this.getResponse(layoutEntity);
            ResourceImpl resource = new ResourceImpl(Resource.Type.ActiveWidgetLayout);
            resource.setProperty(WIDGETLAYOUT_ID_PROPERTY_ID, activeWidgetLayoutResponse.getId());
            resource.setProperty(WIDGETLAYOUT_CLUSTER_NAME_PROPERTY_ID, activeWidgetLayoutResponse.getClusterName());
            resource.setProperty(WIDGETLAYOUT_LAYOUT_NAME_PROPERTY_ID, activeWidgetLayoutResponse.getLayoutName());
            resource.setProperty(WIDGETLAYOUT_SECTION_NAME_PROPERTY_ID, activeWidgetLayoutResponse.getSectionName());
            resource.setProperty(WIDGETLAYOUT_SCOPE_PROPERTY_ID, activeWidgetLayoutResponse.getScope());
            resource.setProperty(WIDGETLAYOUT_USERNAME_PROPERTY_ID, activeWidgetLayoutResponse.getUserName());
            resource.setProperty(WIDGETLAYOUT_DISPLAY_NAME_PROPERTY_ID, activeWidgetLayoutResponse.getDisplayName());
            resource.setProperty(WIDGETLAYOUT_WIDGETS_PROPERTY_ID, activeWidgetLayoutResponse.getWidgets());
            resources.add(resource);
        }
        return resources;
    }

    private ActiveWidgetLayoutResponse getResponse(WidgetLayoutEntity layoutEntity) throws SystemException {
        String clusterName = null;
        try {
            clusterName = this.getManagementController().getClusters().getClusterById(layoutEntity.getClusterId()).getClusterName();
        }
        catch (OBDPException e) {
            throw new SystemException(e.getMessage());
        }
        ArrayList<HashMap<String, WidgetResponse>> widgets = new ArrayList<HashMap<String, WidgetResponse>>();
        List<WidgetLayoutUserWidgetEntity> widgetLayoutUserWidgetEntityList = layoutEntity.getListWidgetLayoutUserWidgetEntity();
        for (WidgetLayoutUserWidgetEntity widgetLayoutUserWidgetEntity : widgetLayoutUserWidgetEntityList) {
            WidgetEntity widgetEntity = widgetLayoutUserWidgetEntity.getWidget();
            HashMap<String, WidgetResponse> widgetInfoMap = new HashMap<String, WidgetResponse>();
            widgetInfoMap.put("WidgetInfo", WidgetResponse.coerce(widgetEntity));
            widgets.add(widgetInfoMap);
        }
        return new ActiveWidgetLayoutResponse(layoutEntity.getId(), clusterName, layoutEntity.getDisplayName(), layoutEntity.getLayoutName(), layoutEntity.getSectionName(), layoutEntity.getScope(), layoutEntity.getUserName(), widgets);
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final Set<Map<String, Object>> propertyMaps = request.getProperties();
        this.modifyResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException, AuthorizationException {
                boolean isUserAdministrator = AuthorizationHelper.isAuthorized(ResourceType.OBDP, null, RoleAuthorization.OBDP_MANAGE_USERS);
                for (Map propertyMap : propertyMaps) {
                    String userName = ActiveWidgetLayoutResourceProvider.this.getUserName(propertyMap);
                    if (!isUserAdministrator && !AuthorizationHelper.getAuthenticatedName().equalsIgnoreCase(userName)) {
                        throw new AuthorizationException();
                    }
                    Set widgetLayouts = (Set)propertyMap.get(ActiveWidgetLayoutResourceProvider.WIDGETLAYOUT);
                    for (HashMap widgetLayout : widgetLayouts) {
                        Long layoutId;
                        try {
                            layoutId = Long.parseLong((String)widgetLayout.get(ActiveWidgetLayoutResourceProvider.ID));
                        }
                        catch (Exception ex) {
                            throw new OBDPException("WidgetLayout should have numerical id");
                        }
                        WidgetLayoutEntity entity = widgetLayoutDAO.findById(layoutId);
                        if (entity != null) continue;
                        throw new OBDPException("There is no widget layout with id " + layoutId);
                    }
                    UserEntity user = userDAO.findUserByName(userName);
                    user.setActiveWidgetLayouts(gson.toJson(propertyMap.get(ActiveWidgetLayoutResourceProvider.WIDGETLAYOUT)));
                    userDAO.merge(user);
                }
                return null;
            }
        });
        return this.getRequestStatus(null);
    }

    private String getUserName(Map<String, Object> propertyMap) {
        String userName;
        String string = userName = propertyMap.get(WIDGETLAYOUT_USERNAME_PROPERTY_ID) == null ? "" : propertyMap.get(WIDGETLAYOUT_USERNAME_PROPERTY_ID).toString();
        if (StringUtils.isBlank((CharSequence)userName)) {
            userName = AuthorizationHelper.getAuthenticatedName();
        }
        return userName;
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new SystemException("The request is not supported");
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return pkPropertyIds;
    }
}

