/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.ActionManager;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.controller.ActionRequest;
import id.onyx.obdp.server.controller.ActionResponse;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.customactions.ActionDefinition;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionResourceProvider
extends AbstractControllerResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ActionResourceProvider.class);
    public static final String ACTION_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Actions", "action_name");
    public static final String ACTION_TYPE_PROPERTY_ID = PropertyHelper.getPropertyId("Actions", "action_type");
    public static final String INPUTS_PROPERTY_ID = PropertyHelper.getPropertyId("Actions", "inputs");
    public static final String TARGET_SERVICE_PROPERTY_ID = PropertyHelper.getPropertyId("Actions", "target_service");
    public static final String TARGET_COMPONENT_PROPERTY_ID = PropertyHelper.getPropertyId("Actions", "target_component");
    public static final String DESCRIPTION_PROPERTY_ID = PropertyHelper.getPropertyId("Actions", "description");
    public static final String TARGET_HOST_PROPERTY_ID = PropertyHelper.getPropertyId("Actions", "target_type");
    public static final String DEFAULT_TIMEOUT_PROPERTY_ID = PropertyHelper.getPropertyId("Actions", "default_timeout");
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Action, (Object)ACTION_NAME_PROPERTY_ID).build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{ACTION_NAME_PROPERTY_ID, ACTION_TYPE_PROPERTY_ID, INPUTS_PROPERTY_ID, TARGET_SERVICE_PROPERTY_ID, TARGET_COMPONENT_PROPERTY_ID, DESCRIPTION_PROPERTY_ID, TARGET_HOST_PROPERTY_ID, DEFAULT_TIMEOUT_PROPERTY_ID});

    public ActionResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.Action, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not currently supported.");
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not currently supported.");
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<ActionRequest> requests = new HashSet<ActionRequest>();
        if (predicate != null) {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
                ActionRequest actionReq = this.getRequest(propertyMap);
                LOG.debug("Received a get request for Action with, actionName = {}", (Object)actionReq.getActionName());
                requests.add(actionReq);
            }
        } else {
            LOG.debug("Received a get request for all Actions");
            requests.add(ActionRequest.getAllRequest());
        }
        Set<ActionResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<ActionResponse>>(){

            @Override
            public Set<ActionResponse> invoke() throws OBDPException {
                return ActionResourceProvider.this.getActionDefinitions(requests);
            }
        });
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<Resource> resources = new HashSet<Resource>();
        for (ActionResponse response : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.Action);
            ActionResourceProvider.setResourceProperty(resource, ACTION_NAME_PROPERTY_ID, response.getActionName(), requestedIds);
            ActionResourceProvider.setResourceProperty(resource, ACTION_TYPE_PROPERTY_ID, response.getActionType(), requestedIds);
            ActionResourceProvider.setResourceProperty(resource, INPUTS_PROPERTY_ID, response.getInputs(), requestedIds);
            ActionResourceProvider.setResourceProperty(resource, TARGET_SERVICE_PROPERTY_ID, response.getTargetService(), requestedIds);
            ActionResourceProvider.setResourceProperty(resource, TARGET_COMPONENT_PROPERTY_ID, response.getTargetComponent(), requestedIds);
            ActionResourceProvider.setResourceProperty(resource, DESCRIPTION_PROPERTY_ID, response.getDescription(), requestedIds);
            ActionResourceProvider.setResourceProperty(resource, TARGET_HOST_PROPERTY_ID, response.getTargetType(), requestedIds);
            ActionResourceProvider.setResourceProperty(resource, DEFAULT_TIMEOUT_PROPERTY_ID, response.getDefaultTimeout(), requestedIds);
            resources.add(resource);
        }
        return resources;
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not currently supported.");
    }

    private ActionRequest getRequest(Map<String, Object> properties) {
        ActionRequest ar = new ActionRequest((String)properties.get(ACTION_NAME_PROPERTY_ID), (String)properties.get(ACTION_TYPE_PROPERTY_ID), (String)properties.get(INPUTS_PROPERTY_ID), (String)properties.get(TARGET_SERVICE_PROPERTY_ID), (String)properties.get(TARGET_COMPONENT_PROPERTY_ID), (String)properties.get(DESCRIPTION_PROPERTY_ID), (String)properties.get(TARGET_HOST_PROPERTY_ID), (String)properties.get(DEFAULT_TIMEOUT_PROPERTY_ID));
        return ar;
    }

    @Override
    public Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    private ActionManager getActionManager() {
        return this.getManagementController().getActionManager();
    }

    private OBDPMetaInfo getAmbariMetaInfo() {
        return this.getManagementController().getAmbariMetaInfo();
    }

    protected synchronized Set<ActionResponse> getActionDefinitions(Set<ActionRequest> requests) throws OBDPException {
        HashSet<ActionResponse> responses = new HashSet<ActionResponse>();
        for (ActionRequest request : requests) {
            if (request.getActionName() == null) {
                List<ActionDefinition> ads = this.getAmbariMetaInfo().getAllActionDefinition();
                for (ActionDefinition ad : ads) {
                    responses.add(ad.convertToResponse());
                }
                continue;
            }
            ActionDefinition ad = this.getAmbariMetaInfo().getActionDefinition(request.getActionName());
            if (ad == null) continue;
            responses.add(ad.convertToResponse());
        }
        return responses;
    }
}

