/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.DuplicateResourceException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ObjectNotFoundException;
import id.onyx.obdp.server.ParentObjectNotFoundException;
import id.onyx.obdp.server.controller.ConfigurationRequest;
import id.onyx.obdp.server.controller.RequestStatusResponse;
import id.onyx.obdp.server.controller.internal.BaseProvider;
import id.onyx.obdp.server.controller.internal.ObservableResourceProvider;
import id.onyx.obdp.server.controller.internal.RequestStatusImpl;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.internal.ResourceProviderEvent;
import id.onyx.obdp.server.controller.internal.ResourceProviderObserver;
import id.onyx.obdp.server.controller.internal.SimplifyingPredicateVisitor;
import id.onyx.obdp.server.controller.predicate.ArrayPredicate;
import id.onyx.obdp.server.controller.predicate.EqualsPredicate;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.RequestStatusMetaData;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.ResourceProvider;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PredicateHelper;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.utils.RetryHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceProvider
extends BaseProvider
implements ResourceProvider,
ObservableResourceProvider {
    protected final Map<Resource.Type, String> keyPropertyIds;
    private final Set<ResourceProviderObserver> observers = new HashSet<ResourceProviderObserver>();
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractResourceProvider.class);
    protected static final String PROPERTIES_ATTRIBUTES_REGEX = "properties_attributes/[a-zA-Z][a-zA-Z._-]*$";
    private static final Pattern propertiesAttributesPattern = Pattern.compile(".*/properties_attributes/[a-zA-Z][a-zA-Z._-]*$");

    protected AbstractResourceProvider(Set<String> propertyIds, Map<Resource.Type, String> keyPropertyIds) {
        super(propertyIds);
        this.keyPropertyIds = keyPropertyIds;
    }

    @Override
    public Map<Resource.Type, String> getKeyPropertyIds() {
        return this.keyPropertyIds;
    }

    @Override
    public void updateObservers(ResourceProviderEvent event) {
        for (ResourceProviderObserver observer : this.observers) {
            observer.update(event);
        }
    }

    @Override
    public void addObserver(ResourceProviderObserver observer) {
        this.observers.add(observer);
    }

    protected abstract Set<String> getPKPropertyIds();

    protected void notifyCreate(Resource.Type type, Request request) {
        this.updateObservers(new ResourceProviderEvent(type, ResourceProviderEvent.Type.Create, request, null));
    }

    protected void notifyUpdate(Resource.Type type, Request request, Predicate predicate) {
        this.updateObservers(new ResourceProviderEvent(type, ResourceProviderEvent.Type.Update, request, predicate));
    }

    protected void notifyDelete(Resource.Type type, Predicate predicate) {
        this.updateObservers(new ResourceProviderEvent(type, ResourceProviderEvent.Type.Delete, null, predicate));
    }

    protected Set<Map<String, Object>> getPropertyMaps(Predicate givenPredicate) {
        SimplifyingPredicateVisitor visitor = new SimplifyingPredicateVisitor(this);
        PredicateHelper.visit(givenPredicate, visitor);
        List<Predicate> predicates = visitor.getSimplifiedPredicates();
        HashSet<Map<String, Object>> propertyMaps = new HashSet<Map<String, Object>>();
        for (Predicate predicate : predicates) {
            propertyMaps.add(PredicateHelper.getProperties(predicate));
        }
        return propertyMaps;
    }

    protected Set<Map<String, Object>> getPropertyMaps(Map<String, Object> requestPropertyMap, Predicate givenPredicate) throws UnsupportedPropertyException, SystemException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Map<String, Object>> propertyMaps = new HashSet<Map<String, Object>>();
        if (this.specifiesUniqueResource(givenPredicate)) {
            HashMap<String, Object> propertyMap = new HashMap<String, Object>(PredicateHelper.getProperties(givenPredicate));
            propertyMap.putAll(requestPropertyMap);
            propertyMaps.add(propertyMap);
        } else {
            for (Resource resource : this.getResources(givenPredicate)) {
                HashMap<String, Object> propertyMap = new HashMap<String, Object>(PropertyHelper.getProperties(resource));
                propertyMap.putAll(requestPropertyMap);
                propertyMaps.add(propertyMap);
            }
        }
        return propertyMaps;
    }

    protected RequestStatus getRequestStatus(RequestStatusResponse response, Set<Resource> associatedResources) {
        return this.getRequestStatus(response, associatedResources, null);
    }

    protected RequestStatus getRequestStatus(RequestStatusResponse response, Set<Resource> associatedResources, RequestStatusMetaData requestStatusMetaData) {
        if (response != null) {
            ResourceImpl requestResource = new ResourceImpl(Resource.Type.Request);
            if (response.getMessage() != null) {
                requestResource.setProperty(PropertyHelper.getPropertyId("Requests", "message"), response.getMessage());
            }
            requestResource.setProperty(PropertyHelper.getPropertyId("Requests", "id"), response.getRequestId());
            requestResource.setProperty(PropertyHelper.getPropertyId("Requests", "status"), "Accepted");
            return new RequestStatusImpl(requestResource, associatedResources, requestStatusMetaData);
        }
        return new RequestStatusImpl(null, associatedResources, requestStatusMetaData);
    }

    protected RequestStatus getRequestStatus(RequestStatusResponse response) {
        return this.getRequestStatus(response, null);
    }

    protected static Object getQueryParameterValue(String queryParameterId, Predicate predicate) {
        Object result = null;
        if (predicate instanceof EqualsPredicate) {
            EqualsPredicate equalsPredicate = (EqualsPredicate)predicate;
            if (queryParameterId.equals(equalsPredicate.getPropertyId())) {
                return equalsPredicate.getValue();
            }
        } else if (predicate instanceof ArrayPredicate) {
            ArrayPredicate arrayPredicate = (ArrayPredicate)predicate;
            for (Predicate predicateItem : arrayPredicate.getPredicates()) {
                result = AbstractResourceProvider.getQueryParameterValue(queryParameterId, predicateItem);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    protected <T> T createResources(Command<T> command) throws SystemException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        try {
            return this.invokeWithRetry(command);
        }
        catch (ParentObjectNotFoundException e) {
            throw new NoSuchParentResourceException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (DuplicateResourceException e) {
            throw new ResourceAlreadyExistsException(e.getMessage());
        }
        catch (OBDPException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Caught OBDPException when creating a resource", (Throwable)e);
            }
            throw new SystemException("An internal system exception occurred: " + e.getMessage(), e);
        }
    }

    protected <T> T getResources(Command<T> command) throws SystemException, NoSuchResourceException, NoSuchParentResourceException {
        try {
            return command.invoke();
        }
        catch (ParentObjectNotFoundException e) {
            throw new NoSuchParentResourceException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (ObjectNotFoundException e) {
            throw new NoSuchResourceException("The requested resource doesn't exist: " + e.getMessage(), (Throwable)((Object)e));
        }
        catch (OBDPException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Caught OBDPException when getting a resource", (Throwable)e);
            }
            throw new SystemException("An internal system exception occurred: " + e.getMessage(), e);
        }
    }

    protected <T> T modifyResources(Command<T> command) throws SystemException, NoSuchResourceException, NoSuchParentResourceException {
        try {
            return this.invokeWithRetry(command);
        }
        catch (ParentObjectNotFoundException e) {
            throw new NoSuchParentResourceException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (ObjectNotFoundException e) {
            throw new NoSuchResourceException("The specified resource doesn't exist: " + e.getMessage(), (Throwable)((Object)e));
        }
        catch (OBDPException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Caught OBDPException when modifying a resource", (Throwable)e);
            }
            throw new SystemException("An internal system exception occurred: " + e.getMessage(), e);
        }
    }

    public static List<ConfigurationRequest> getConfigurationRequests(String parentCategory, Map<String, Object> properties) {
        LinkedList<ConfigurationRequest> configs = new LinkedList<ConfigurationRequest>();
        String desiredConfigKey = parentCategory + "/desired_config";
        if (properties.containsKey(desiredConfigKey) && properties.get(desiredConfigKey) instanceof Set) {
            Set configProperties = (Set)properties.get(desiredConfigKey);
            for (Map value : configProperties) {
                ConfigurationRequest newConfig = new ConfigurationRequest();
                for (Map.Entry e : value.entrySet()) {
                    String propName = PropertyHelper.getPropertyName(desiredConfigKey + "/" + (String)e.getKey());
                    String absCatategory = PropertyHelper.getPropertyCategory(desiredConfigKey + "/" + (String)e.getKey());
                    AbstractResourceProvider.parseProperties(newConfig, absCatategory, propName, e.getValue() == null ? null : e.getValue().toString());
                }
                configs.add(newConfig);
            }
            return configs;
        }
        ConfigurationRequest config = null;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String absCategory = PropertyHelper.getPropertyCategory(entry.getKey());
            String propName = PropertyHelper.getPropertyName(entry.getKey());
            if (absCategory == null || !absCategory.startsWith(desiredConfigKey)) continue;
            ConfigurationRequest configurationRequest = config = null == config ? new ConfigurationRequest() : config;
            if (entry.getValue() == null) continue;
            AbstractResourceProvider.parseProperties(config, absCategory, propName, entry.getValue().toString());
        }
        if (config != null) {
            configs.add(config);
        }
        return configs;
    }

    public static void parseProperties(ConfigurationRequest config, String absCategory, String propName, String propValue) {
        if (propName.equals("type")) {
            config.setType(propValue);
        } else if (propName.equals("tag")) {
            config.setVersionTag(propValue);
        } else if (propName.equals("selected")) {
            config.setSelected(Boolean.parseBoolean(propValue));
        } else if (propName.equals("service_config_version_note")) {
            config.setServiceConfigVersionNote(propValue);
        } else if (absCategory.endsWith("/properties")) {
            config.getProperties().put(propName, propValue);
        } else if (propertiesAttributesPattern.matcher(absCategory).matches()) {
            Map<String, String> attributesMap;
            String attributeName = absCategory.substring(absCategory.lastIndexOf(47) + 1);
            Map<String, Map<String, String>> configAttributesMap = config.getPropertiesAttributes();
            if (null == configAttributesMap) {
                configAttributesMap = new HashMap<String, Map<String, String>>();
                config.setPropertiesAttributes(configAttributesMap);
            }
            if (null == (attributesMap = configAttributesMap.get(attributeName))) {
                attributesMap = new HashMap<String, String>();
                configAttributesMap.put(attributeName, attributesMap);
            }
            attributesMap.put(propName, propValue);
        }
    }

    private Set<Resource> getResources(Predicate givenPredicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        return this.getResources(PropertyHelper.getReadRequest(this.getPKPropertyIds()), givenPredicate);
    }

    private boolean specifiesUniqueResource(Predicate predicate) {
        SimplifyingPredicateVisitor visitor = new SimplifyingPredicateVisitor(this);
        PredicateHelper.visit(predicate, visitor);
        List<Predicate> predicates = visitor.getSimplifiedPredicates();
        return predicates.size() == 1 && PredicateHelper.getPropertyIds(predicate).containsAll(this.getPKPropertyIds());
    }

    private <T> T invokeWithRetry(Command<T> command) throws OBDPException, AuthorizationException {
        RetryHelper.clearAffectedClusters();
        int retryAttempts = RetryHelper.getOperationsRetryAttempts();
        while (true) {
            try {
                return command.invoke();
            }
            catch (Exception e) {
                if (RetryHelper.isDatabaseException(e)) {
                    RetryHelper.invalidateAffectedClusters();
                    if (retryAttempts > 0) {
                        LOG.error("Ignoring database exception to perform operation retry, attempts remaining: " + retryAttempts, (Throwable)e);
                        --retryAttempts;
                        continue;
                    }
                    RetryHelper.clearAffectedClusters();
                    throw e;
                }
                RetryHelper.clearAffectedClusters();
                throw e;
            }
            break;
        }
    }

    protected static interface Command<T> {
        public T invoke() throws OBDPException, AuthorizationException;
    }
}

