/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.configuration.ComponentSSLConfiguration;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OBDPServer;
import id.onyx.obdp.server.controller.internal.AlertSummaryPropertyProvider;
import id.onyx.obdp.server.controller.internal.AtlasServerHttpPropertyRequest;
import id.onyx.obdp.server.controller.internal.ConfigurationResourceProvider;
import id.onyx.obdp.server.controller.internal.HostStatusHelper;
import id.onyx.obdp.server.controller.internal.HttpPropertyProvider;
import id.onyx.obdp.server.controller.internal.ObservableResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceManagerHttpPropertyRequest;
import id.onyx.obdp.server.controller.internal.ResourceProviderEvent;
import id.onyx.obdp.server.controller.internal.ResourceProviderObserver;
import id.onyx.obdp.server.controller.internal.RootServiceComponentPropertyProvider;
import id.onyx.obdp.server.controller.internal.StackDefinedPropertyProvider;
import id.onyx.obdp.server.controller.internal.URLStreamProvider;
import id.onyx.obdp.server.controller.jmx.JMXHostProvider;
import id.onyx.obdp.server.controller.metrics.MetricHostProvider;
import id.onyx.obdp.server.controller.metrics.MetricPropertyProviderFactory;
import id.onyx.obdp.server.controller.metrics.MetricsCollectorHAManager;
import id.onyx.obdp.server.controller.metrics.MetricsPropertyProvider;
import id.onyx.obdp.server.controller.metrics.MetricsReportPropertyProvider;
import id.onyx.obdp.server.controller.metrics.MetricsServiceProvider;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricCacheProvider;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.PropertyProvider;
import id.onyx.obdp.server.controller.spi.ProviderModule;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceProvider;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PredicateBuilder;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.controller.utilities.StreamProvider;
import id.onyx.obdp.server.events.ClusterConfigChangedEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponentHost;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProviderModule
implements ProviderModule,
ResourceProviderObserver,
JMXHostProvider,
MetricHostProvider,
MetricsServiceProvider {
    private static final int PROPERTY_REQUEST_CONNECT_TIMEOUT = 5000;
    private static final int PROPERTY_REQUEST_READ_TIMEOUT = 10000;
    private static final String GANGLIA_SERVER = "GANGLIA_SERVER";
    private static final String METRIC_SERVER = "METRICS_COLLECTOR";
    private static final String PROPERTIES_CATEGORY = "properties";
    private static final Map<String, String> serviceConfigVersions = new ConcurrentHashMap<String, String>();
    private static final Map<Service.Type, String> serviceConfigTypes = new EnumMap<Service.Type, String>(Service.Type.class);
    private static final Map<Service.Type, Map<String, String[]>> serviceDesiredProperties = new EnumMap<Service.Type, Map<String, String[]>>(Service.Type.class);
    private static final Map<String, Service.Type> componentServiceMap = new HashMap<String, Service.Type>();
    private static final Map<String, List<HttpPropertyProvider.HttpPropertyRequest>> HTTP_PROPERTY_REQUESTS = new HashMap<String, List<HttpPropertyProvider.HttpPropertyRequest>>();
    private static final String PROPERTY_HDFS_HTTP_POLICY_VALUE_HTTPS_ONLY = "HTTPS_ONLY";
    private static final String COLLECTOR_DEFAULT_PORT = "6188";
    private static final Map<String, Map<String, String[]>> jmxDesiredProperties = new HashMap<String, Map<String, String[]>>();
    private static final Map<String, Map<String, String[]>> jmxDesiredRpcSuffixProperties = new ConcurrentHashMap<String, Map<String, String[]>>();
    private volatile Map<String, Map<String, Map<String, String>>> jmxDesiredRpcSuffixes = new HashMap<String, Map<String, Map<String, String>>>();
    private volatile Map<String, String> clusterHdfsSiteConfigVersionMap = new HashMap<String, String>();
    private volatile Map<String, String> clusterJmxProtocolMap = new ConcurrentHashMap<String, String>();
    private volatile String clusterMetricServerPort = null;
    private volatile String clusterMetricServerVipPort = null;
    private volatile String clusterMetricserverVipHost = null;
    private final Map<Resource.Type, ResourceProvider> resourceProviders = new HashMap<Resource.Type, ResourceProvider>();
    private final Map<Resource.Type, List<PropertyProvider>> propertyProviders = new HashMap<Resource.Type, List<PropertyProvider>>();
    @Inject
    protected OBDPManagementController managementController;
    @Inject
    TimelineMetricCacheProvider metricCacheProvider;
    @Inject
    MetricsCollectorHAManager metricsCollectorHAManager;
    @Inject
    private MetricPropertyProviderFactory metricPropertyProviderFactory;
    @Inject
    protected OBDPEventPublisher eventPublisher;
    @Inject
    private Clusters clusters;
    private Map<String, Map<String, String>> clusterHostComponentMap;
    private Map<String, String> clusterGangliaCollectorMap;
    private final Map<String, ConcurrentMap<String, ConcurrentMap<String, String>>> jmxPortMap = new ConcurrentHashMap<String, ConcurrentMap<String, ConcurrentMap<String, String>>>(1);
    private volatile boolean initialized = false;
    private static final Logger LOG;

    public AbstractProviderModule() {
        if (this.managementController == null) {
            this.managementController = OBDPServer.getController();
        }
        if (this.metricCacheProvider == null && this.managementController != null) {
            this.metricCacheProvider = this.managementController.getTimelineMetricCacheProvider();
        }
        if (this.metricPropertyProviderFactory == null && this.managementController != null) {
            this.metricPropertyProviderFactory = this.managementController.getMetricPropertyProviderFactory();
        }
        if (null == this.eventPublisher && null != this.managementController) {
            this.eventPublisher = this.managementController.getAmbariEventPublisher();
            this.eventPublisher.register(this);
        }
        if (null == this.metricsCollectorHAManager && null != this.managementController) {
            this.metricsCollectorHAManager = this.managementController.getMetricsCollectorHAManager();
        }
        if (null == this.clusters && null != this.managementController) {
            this.clusters = this.managementController.getClusters();
        }
    }

    @Override
    public ResourceProvider getResourceProvider(Resource.Type type) {
        if (!this.resourceProviders.containsKey(type)) {
            this.registerResourceProvider(type);
        }
        return this.resourceProviders.get(type);
    }

    @Override
    public List<PropertyProvider> getPropertyProviders(Resource.Type type) {
        if (!this.propertyProviders.containsKey(type)) {
            this.createPropertyProviders(type);
        }
        return this.propertyProviders.get(type);
    }

    @Override
    public void update(ResourceProviderEvent event) {
        Resource.Type type = event.getResourceType();
        if (type == Resource.Type.Cluster || type == Resource.Type.Host || type == Resource.Type.HostComponent) {
            this.resetInit();
        }
    }

    @Override
    public MetricsServiceProvider.MetricsService getMetricsServiceType() {
        try {
            this.checkInit();
        }
        catch (SystemException e) {
            LOG.error("Exception during checkInit.", (Throwable)e);
        }
        if (!this.metricsCollectorHAManager.isEmpty()) {
            return MetricsServiceProvider.MetricsService.TIMELINE_METRICS;
        }
        if (!this.clusterGangliaCollectorMap.isEmpty()) {
            return MetricsServiceProvider.MetricsService.GANGLIA;
        }
        return null;
    }

    @Override
    public String getCollectorHostName(String clusterName, MetricsServiceProvider.MetricsService service) throws SystemException {
        this.checkInit();
        if (service.equals((Object)MetricsServiceProvider.MetricsService.GANGLIA)) {
            return this.clusterGangliaCollectorMap.get(clusterName);
        }
        if (service.equals((Object)MetricsServiceProvider.MetricsService.TIMELINE_METRICS)) {
            return this.getMetricsCollectorHostName(clusterName);
        }
        return null;
    }

    private void checkAndAddExternalCollectorHosts(String clusterName) throws SystemException {
        try {
            String configType = "cluster-env";
            String currentConfigVersion = this.getDesiredConfigVersion(clusterName, configType);
            String oldConfigVersion = serviceConfigVersions.get(configType);
            if (!currentConfigVersion.equals(oldConfigVersion)) {
                serviceConfigVersions.put(configType, currentConfigVersion);
                Map<String, String> configProperties = this.getDesiredConfigMap(clusterName, currentConfigVersion, configType, Collections.singletonMap(METRIC_SERVER, new String[]{"metrics_collector_external_hosts"}));
                if (!configProperties.isEmpty()) {
                    this.clusterMetricserverVipHost = configProperties.get(METRIC_SERVER);
                    if (StringUtils.isNotEmpty((String)this.clusterMetricserverVipHost)) {
                        for (String collectorHost : StringUtils.split((String)this.clusterMetricserverVipHost, (String)",")) {
                            this.metricsCollectorHAManager.addExternalMetricsCollectorHost(clusterName, collectorHost);
                        }
                        LOG.info("Setting Metrics Collector External Host : " + this.clusterMetricserverVipHost);
                    }
                }
                if (!(configProperties = this.getDesiredConfigMap(clusterName, currentConfigVersion, configType, Collections.singletonMap(METRIC_SERVER, new String[]{"metrics_collector_external_port"}))).isEmpty()) {
                    this.clusterMetricServerVipPort = configProperties.getOrDefault(METRIC_SERVER, COLLECTOR_DEFAULT_PORT);
                }
            }
        }
        catch (NoSuchParentResourceException | UnsupportedPropertyException e) {
            LOG.warn("Failed to retrieve collector hostname.", (Throwable)e);
        }
    }

    private String getMetricsCollectorHostName(String clusterName) throws SystemException {
        this.checkAndAddExternalCollectorHosts(clusterName);
        String currentCollectorHost = this.metricsCollectorHAManager.getCollectorHost(clusterName);
        LOG.debug("Cluster Metrics Vip Host : " + this.clusterMetricserverVipHost);
        return currentCollectorHost;
    }

    @Override
    public boolean isCollectorHostExternal(String clusterName) {
        return this.metricsCollectorHAManager.isExternalCollector();
    }

    @Override
    public String getCollectorPort(String clusterName, MetricsServiceProvider.MetricsService service) throws SystemException {
        this.checkInit();
        if (service.equals((Object)MetricsServiceProvider.MetricsService.GANGLIA)) {
            return "80";
        }
        if (service.equals((Object)MetricsServiceProvider.MetricsService.TIMELINE_METRICS)) {
            try {
                String oldConfigVersion;
                String configType;
                String currentConfigVersion;
                if (this.clusterMetricServerVipPort == null && !(currentConfigVersion = this.getDesiredConfigVersion(clusterName, configType = serviceConfigTypes.get((Object)Service.Type.AMBARI_METRICS))).equals(oldConfigVersion = serviceConfigVersions.get(configType))) {
                    serviceConfigVersions.put(configType, currentConfigVersion);
                    Map<String, String> configProperties = this.getDesiredConfigMap(clusterName, currentConfigVersion, configType, Collections.singletonMap(METRIC_SERVER, new String[]{"timeline.metrics.service.webapp.address"}));
                    this.clusterMetricServerPort = !configProperties.isEmpty() ? this.getPortString(configProperties.get(METRIC_SERVER)) : COLLECTOR_DEFAULT_PORT;
                }
            }
            catch (NoSuchParentResourceException | UnsupportedPropertyException e) {
                LOG.warn("Failed to retrieve collector port.", (Throwable)e);
            }
        }
        return this.clusterMetricServerVipPort != null ? this.clusterMetricServerVipPort : this.clusterMetricServerPort;
    }

    @Override
    public boolean isCollectorHostLive(String clusterName, MetricsServiceProvider.MetricsService service) throws SystemException {
        return this.metricsCollectorHAManager.isCollectorHostLive(clusterName);
    }

    @Override
    public String getHostName(String clusterName, String componentName) throws SystemException {
        this.checkInit();
        return this.clusterHostComponentMap.get(clusterName).get(componentName);
    }

    @Override
    public String getPublicHostName(String clusterName, String hostName) {
        Host host = this.getHost(clusterName, hostName);
        return host == null ? hostName : host.getPublicHostName();
    }

    @Override
    public Set<String> getHostNames(String clusterName, String componentName) {
        Set<String> hosts = null;
        try {
            Cluster cluster = this.managementController.getClusters().getCluster(clusterName);
            String serviceName = this.managementController.findServiceName(cluster, componentName);
            hosts = cluster.getService(serviceName).getServiceComponent(componentName).getServiceComponentHosts().keySet();
        }
        catch (Exception e) {
            LOG.warn("Exception in getting host names for jmx metrics: ", (Throwable)e);
        }
        return hosts;
    }

    private Host getHost(String clusterName, String hostName) {
        Host host = null;
        try {
            Cluster cluster = this.managementController.getClusters().getCluster(clusterName);
            if (cluster != null) {
                host = cluster.getHost(hostName);
            }
        }
        catch (Exception e) {
            LOG.warn("Exception in getting host info for jmx metrics: ", (Throwable)e);
        }
        return host;
    }

    @Override
    public boolean isCollectorComponentLive(String clusterName, MetricsServiceProvider.MetricsService service) throws SystemException {
        String collectorHostName = this.getCollectorHostName(clusterName, service);
        if (service.equals((Object)MetricsServiceProvider.MetricsService.GANGLIA)) {
            return HostStatusHelper.isHostComponentLive(this.managementController, clusterName, collectorHostName, "GANGLIA", Role.GANGLIA_SERVER.name());
        }
        if (service.equals((Object)MetricsServiceProvider.MetricsService.TIMELINE_METRICS)) {
            return this.metricsCollectorHAManager.isCollectorComponentLive(clusterName);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPort(String clusterName, String componentName, String hostName, boolean httpsEnabled) {
        ConcurrentMap<String, ConcurrentMap<String, String>> clusterJmxPorts;
        if (!this.jmxPortMap.containsKey(clusterName)) {
            Map<String, ConcurrentMap<String, ConcurrentMap<String, String>>> map = this.jmxPortMap;
            synchronized (map) {
                if (!this.jmxPortMap.containsKey(clusterName)) {
                    clusterJmxPorts = new ConcurrentHashMap<String, ConcurrentMap<String, String>>();
                    this.jmxPortMap.put(clusterName, clusterJmxPorts);
                }
            }
        }
        clusterJmxPorts = this.jmxPortMap.get(clusterName);
        Service.Type service = componentServiceMap.get(componentName);
        if (service != null) {
            try {
                String configType = serviceConfigTypes.get((Object)service);
                String currVersion = this.getDesiredConfigVersion(clusterName, configType);
                String oldVersion = serviceConfigVersions.get(configType);
                if (!(StringUtils.equals((String)currVersion, (String)oldVersion) && clusterJmxPorts.containsKey(hostName) && ((ConcurrentMap)clusterJmxPorts.get(hostName)).containsKey(componentName))) {
                    serviceConfigVersions.put(configType, currVersion);
                    Map<String, Object> configProperties = this.getConfigProperties(clusterName, currVersion, serviceConfigTypes.get((Object)service));
                    String publicHostName = this.getPublicHostName(clusterName, hostName);
                    HashMap<String, String[]> componentPortsProperties = new HashMap<String, String[]>();
                    componentPortsProperties.put(componentName, this.getPortProperties(service, componentName, hostName, publicHostName, configProperties, httpsEnabled));
                    Map<String, String> portMap = this.getDesiredConfigMap(clusterName, currVersion, serviceConfigTypes.get((Object)service), componentPortsProperties, configProperties);
                    for (Map.Entry<String, String> entry : portMap.entrySet()) {
                        String portString = this.getPortString(entry.getValue());
                        if (null == portString) continue;
                        clusterJmxPorts.putIfAbsent(hostName, new ConcurrentHashMap());
                        ((ConcurrentMap)clusterJmxPorts.get(hostName)).put(entry.getKey(), portString);
                    }
                    this.initRpcSuffixes(clusterName, componentName, configType, currVersion, hostName, publicHostName);
                }
            }
            catch (Exception e) {
                LOG.error("Exception initializing jmx port maps. ", (Throwable)e);
            }
        }
        LOG.debug("jmxPortMap -> {}", this.jmxPortMap);
        ConcurrentMap hostJmxPorts = (ConcurrentMap)clusterJmxPorts.get(hostName);
        if (hostJmxPorts == null) {
            LOG.debug("Jmx ports not loaded from properties: clusterName={}, componentName={}, hostName={}, clusterJmxPorts={}, jmxPortMap.get(clusterName)={}", new Object[]{clusterName, componentName, hostName, clusterJmxPorts, this.jmxPortMap.get(clusterName)});
            return null;
        }
        return (String)hostJmxPorts.get(componentName);
    }

    String[] getPortProperties(Service.Type service, String componentName, String hostName, String publicHostName, Map<String, Object> properties, boolean httpsEnabled) {
        Object object = componentName = httpsEnabled ? (String)componentName + "-HTTPS" : componentName;
        if (((String)componentName).startsWith("NAMENODE") && properties.containsKey("dfs.internal.nameservices")) {
            componentName = (String)componentName + "-HA";
            return this.getNamenodeHaProperty(properties, serviceDesiredProperties.get((Object)service).get(componentName), hostName, publicHostName);
        }
        return serviceDesiredProperties.get((Object)service).get(componentName);
    }

    private String[] getNamenodeHaProperty(Map<String, Object> properties, String[] pattern, String hostName, String publicHostName) {
        for (String nameserviceId : ((String)properties.get("dfs.internal.nameservices")).split(",")) {
            if (!properties.containsKey("dfs.ha.namenodes." + nameserviceId)) continue;
            for (String namenodeId : ((String)properties.get("dfs.ha.namenodes." + nameserviceId)).split(",")) {
                String propertyValue;
                String propHostName;
                String propertyName = String.format(pattern[0], nameserviceId, namenodeId);
                if (!properties.containsKey(propertyName) || !(propHostName = (propertyValue = (String)properties.get(propertyName)).split(":")[0]).equals(hostName) && !propHostName.equals(publicHostName)) continue;
                return new String[]{propertyName};
            }
        }
        return pattern;
    }

    private String postProcessPropertyValue(String key, String value, Map<String, String> properties, Set<String> prevProps) {
        if (value != null && key != null && value.contains("${")) {
            if (prevProps == null) {
                prevProps = new HashSet<String>();
            }
            if (prevProps.contains(key)) {
                return value;
            }
            prevProps.add(key);
            String refValueString = value;
            HashMap<CallSite, String> refMap = new HashMap<CallSite, String>();
            while (refValueString.contains("${")) {
                int startValueRef = refValueString.indexOf("${") + 2;
                int endValueRef = refValueString.indexOf(125);
                String valueRef = refValueString.substring(startValueRef, endValueRef);
                refValueString = refValueString.substring(endValueRef + 1);
                String trueValue = this.postProcessPropertyValue(valueRef, properties.get(valueRef), properties, prevProps);
                if (trueValue == null) continue;
                refMap.put((CallSite)((Object)("${" + valueRef + "}")), trueValue);
            }
            for (Map.Entry entry : refMap.entrySet()) {
                refValueString = (String)entry.getValue();
                value = value.replace((CharSequence)entry.getKey(), refValueString);
            }
            properties.put(key, value);
        }
        return value;
    }

    protected abstract ResourceProvider createResourceProvider(Resource.Type var1);

    protected void registerResourceProvider(Resource.Type type) {
        ResourceProvider resourceProvider = this.createResourceProvider(type);
        if (resourceProvider instanceof ObservableResourceProvider) {
            ((ObservableResourceProvider)((Object)resourceProvider)).addObserver(this);
        }
        this.putResourceProvider(type, resourceProvider);
    }

    protected void putResourceProvider(Resource.Type type, ResourceProvider resourceProvider) {
        this.resourceProviders.put(type, resourceProvider);
    }

    protected void putPropertyProviders(Resource.Type type, List<PropertyProvider> providers) {
        this.propertyProviders.put(type, providers);
    }

    protected void createPropertyProviders(Resource.Type type) {
        LinkedList<PropertyProvider> providers = new LinkedList<PropertyProvider>();
        ComponentSSLConfiguration configuration = ComponentSSLConfiguration.instance();
        URLStreamProvider streamProvider = new URLStreamProvider(5000, 10000, configuration);
        if (type.isInternalType()) {
            switch (type.getInternalType()) {
                case Cluster: {
                    providers.add(this.createMetricsReportPropertyProvider(type, streamProvider, ComponentSSLConfiguration.instance(), this, this, PropertyHelper.getPropertyId("Clusters", "cluster_name")));
                    providers.add(new AlertSummaryPropertyProvider(type, "Clusters/cluster_name", null));
                    break;
                }
                case Service: {
                    providers.add(new AlertSummaryPropertyProvider(type, "ServiceInfo/cluster_name", "ServiceInfo/service_name"));
                    break;
                }
                case Host: {
                    providers.add(this.createMetricsHostPropertyProvider(type, streamProvider, ComponentSSLConfiguration.instance(), this, this, PropertyHelper.getPropertyId("Hosts", "cluster_name"), PropertyHelper.getPropertyId("Hosts", "host_name")));
                    providers.add(new AlertSummaryPropertyProvider(type, "Hosts/cluster_name", "Hosts/host_name"));
                    break;
                }
                case Component: {
                    PropertyProvider jpp = this.createJMXPropertyProvider(type, streamProvider, this, this, PropertyHelper.getPropertyId("ServiceComponentInfo", "cluster_name"), null, PropertyHelper.getPropertyId("ServiceComponentInfo", "component_name"), PropertyHelper.getPropertyId("ServiceComponentInfo", "state"));
                    PropertyProvider gpp = null;
                    gpp = this.createMetricsComponentPropertyProvider(type, streamProvider, ComponentSSLConfiguration.instance(), this, this, PropertyHelper.getPropertyId("ServiceComponentInfo", "cluster_name"), PropertyHelper.getPropertyId("ServiceComponentInfo", "component_name"));
                    providers.add(new StackDefinedPropertyProvider(type, this, this, this, streamProvider, PropertyHelper.getPropertyId("ServiceComponentInfo", "cluster_name"), null, PropertyHelper.getPropertyId("ServiceComponentInfo", "component_name"), PropertyHelper.getPropertyId("ServiceComponentInfo", "state"), jpp, gpp));
                    break;
                }
                case HostComponent: {
                    PropertyProvider jpp = this.createJMXPropertyProvider(type, streamProvider, this, this, PropertyHelper.getPropertyId("HostRoles", "cluster_name"), PropertyHelper.getPropertyId("HostRoles", "host_name"), PropertyHelper.getPropertyId("HostRoles", "component_name"), PropertyHelper.getPropertyId("HostRoles", "state"));
                    PropertyProvider gpp = null;
                    gpp = this.createMetricsHostComponentPropertyProvider(type, streamProvider, ComponentSSLConfiguration.instance(), this, this, PropertyHelper.getPropertyId("HostRoles", "cluster_name"), PropertyHelper.getPropertyId("HostRoles", "host_name"), PropertyHelper.getPropertyId("HostRoles", "component_name"));
                    providers.add(new StackDefinedPropertyProvider(type, this, this, this, streamProvider, PropertyHelper.getPropertyId("HostRoles", "cluster_name"), PropertyHelper.getPropertyId("HostRoles", "host_name"), PropertyHelper.getPropertyId("HostRoles", "component_name"), PropertyHelper.getPropertyId("HostRoles", "state"), jpp, gpp));
                    providers.add(new HttpPropertyProvider(streamProvider, this.managementController.getClusters(), PropertyHelper.getPropertyId("HostRoles", "cluster_name"), PropertyHelper.getPropertyId("HostRoles", "host_name"), PropertyHelper.getPropertyId("HostRoles", "public_host_name"), PropertyHelper.getPropertyId("HostRoles", "component_name"), HTTP_PROPERTY_REQUESTS));
                    providers.add(this.managementController.getLoggingSearchPropertyProvider());
                    break;
                }
                case RootServiceComponent: {
                    providers.add(new RootServiceComponentPropertyProvider());
                    break;
                }
            }
        }
        this.putPropertyProviders(type, providers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInit() throws SystemException {
        if (!this.initialized) {
            AbstractProviderModule abstractProviderModule = this;
            synchronized (abstractProviderModule) {
                if (!this.initialized) {
                    this.initProviderMaps();
                    this.initialized = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetInit() {
        if (this.initialized) {
            AbstractProviderModule abstractProviderModule = this;
            synchronized (abstractProviderModule) {
                if (this.initialized) {
                    this.initialized = false;
                }
            }
        }
    }

    private void initProviderMaps() throws SystemException {
        this.jmxPortMap.clear();
        this.clusterHostComponentMap = new HashMap<String, Map<String, String>>();
        this.clusterGangliaCollectorMap = new HashMap<String, String>();
        boolean hasMetricCollector = false;
        Map<String, Cluster> clusterMap = this.clusters.getClusters();
        if (MapUtils.isEmpty(clusterMap)) {
            return;
        }
        for (Cluster cluster : clusterMap.values()) {
            List<ServiceComponentHost> serviceComponentHosts;
            hasMetricCollector = false;
            String clusterName = cluster.getClusterName();
            Map<String, String> hostComponentMap = this.clusterHostComponentMap.get(clusterName);
            if (hostComponentMap == null) {
                hostComponentMap = new HashMap<String, String>();
                this.clusterHostComponentMap.put(clusterName, hostComponentMap);
            }
            if (!CollectionUtils.isEmpty(serviceComponentHosts = cluster.getServiceComponentHosts())) {
                for (ServiceComponentHost sch : serviceComponentHosts) {
                    String componentName = sch.getServiceComponentName();
                    String hostName = sch.getHostName();
                    hostComponentMap.put(componentName, hostName);
                    if (componentName.equals(GANGLIA_SERVER)) {
                        this.clusterGangliaCollectorMap.put(clusterName, hostName);
                    }
                    if (!componentName.equals(METRIC_SERVER)) continue;
                    this.metricsCollectorHAManager.addCollectorHost(clusterName, hostName);
                    hasMetricCollector = true;
                }
            }
            if (hasMetricCollector) continue;
            this.checkAndAddExternalCollectorHosts(clusterName);
        }
    }

    private String getPortString(String value) {
        return value != null && value.contains(":") ? value.substring(value.lastIndexOf(":") + 1, value.length()) : value;
    }

    private String getDesiredConfigVersion(String clusterName, String configType) {
        String versionTag = "version1";
        try {
            Clusters clusters = this.managementController.getClusters();
            Cluster cluster = clusters.getCluster(clusterName);
            Map<String, DesiredConfig> desiredConfigs = cluster.getDesiredConfigs();
            DesiredConfig config = desiredConfigs.get(configType);
            if (config != null) {
                versionTag = config.getTag();
            }
        }
        catch (OBDPException ambariException) {
            LOG.error("Unable to lookup the desired configuration tag for {} on cluster {}, defaulting to {}", new Object[]{configType, clusterName, versionTag, ambariException});
        }
        return versionTag;
    }

    private Map<String, Object> getConfigProperties(String clusterName, String versionTag, String configType) throws NoSuchParentResourceException, UnsupportedPropertyException, SystemException {
        Set<Resource> configResources;
        ResourceProvider configResourceProvider = this.getResourceProvider(Resource.Type.Configuration);
        Predicate configPredicate = new PredicateBuilder().property("Config/cluster_name").equals(clusterName).and().property(ConfigurationResourceProvider.TYPE).equals(configType).and().property(ConfigurationResourceProvider.TAG).equals(versionTag).toPredicate();
        try {
            configResources = configResourceProvider.getResources(PropertyHelper.getReadRequest("Config/cluster_name", ConfigurationResourceProvider.TYPE, ConfigurationResourceProvider.TAG), configPredicate);
        }
        catch (NoSuchResourceException e) {
            LOG.info("Resource for the desired config not found.", (Throwable)e);
            return Collections.emptyMap();
        }
        return configResources.stream().findFirst().map(res -> res.getPropertiesMap().get(PROPERTIES_CATEGORY)).orElse(Collections.emptyMap());
    }

    private Map<String, String> getDesiredConfigMap(String clusterName, String versionTag, String configType, Map<String, String[]> keys) throws NoSuchParentResourceException, UnsupportedPropertyException, SystemException {
        return this.getDesiredConfigMap(clusterName, versionTag, configType, keys, null);
    }

    private Map<String, String> getDesiredConfigMap(String clusterName, String versionTag, String configType, Map<String, String[]> keys, Map<String, Object> configProperties) throws NoSuchParentResourceException, UnsupportedPropertyException, SystemException {
        if (configProperties == null) {
            configProperties = this.getConfigProperties(clusterName, versionTag, configType);
        }
        HashMap<String, String> mConfigs = new HashMap<String, String>();
        if (!configProperties.isEmpty()) {
            HashMap<String, String> evaluatedProperties = null;
            for (Map.Entry<String, String[]> entry : keys.entrySet()) {
                String propName = null;
                String value = null;
                String[] stringArray = entry.getValue();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String pname;
                    propName = pname = stringArray[i];
                    for (Map.Entry<String, Object> propertyEntry : configProperties.entrySet()) {
                        if (!propertyEntry.getKey().startsWith(pname)) continue;
                        value = (String)propertyEntry.getValue();
                        break;
                    }
                    if (null != value) break;
                }
                if (value != null && value.contains("${") && evaluatedProperties == null) {
                    evaluatedProperties = new HashMap<String, String>();
                    for (Map.Entry entry2 : configProperties.entrySet()) {
                        String keyString = (String)entry2.getKey();
                        Object object = entry2.getValue();
                        if (object == null || !(object instanceof String)) continue;
                        String valueString = (String)object;
                        evaluatedProperties.put(keyString, valueString);
                        this.postProcessPropertyValue(keyString, valueString, evaluatedProperties, null);
                    }
                }
                value = this.postProcessPropertyValue(propName, value, evaluatedProperties, null);
                LOG.debug("PROPERTY -> key: {}, value: {}", (Object)propName, (Object)value);
                mConfigs.put(entry.getKey(), value);
            }
        }
        return mConfigs;
    }

    private PropertyProvider createJMXPropertyProvider(Resource.Type type, StreamProvider streamProvider, JMXHostProvider jmxHostProvider, MetricHostProvider metricsHostProvider, String clusterNamePropertyId, String hostNamePropertyId, String componentNamePropertyId, String statePropertyId) {
        return this.metricPropertyProviderFactory.createJMXPropertyProvider(PropertyHelper.getJMXPropertyIds(type), streamProvider, jmxHostProvider, metricsHostProvider, clusterNamePropertyId, hostNamePropertyId, componentNamePropertyId, statePropertyId);
    }

    private PropertyProvider createMetricsReportPropertyProvider(Resource.Type type, URLStreamProvider streamProvider, ComponentSSLConfiguration configuration, MetricHostProvider hostProvider, MetricsServiceProvider serviceProvider, String clusterNamePropertyId) {
        return MetricsReportPropertyProvider.createInstance(PropertyHelper.getMetricPropertyIds(type), streamProvider, configuration, this.metricCacheProvider, hostProvider, serviceProvider, clusterNamePropertyId);
    }

    private PropertyProvider createMetricsHostPropertyProvider(Resource.Type type, URLStreamProvider streamProvider, ComponentSSLConfiguration configuration, MetricHostProvider hostProvider, MetricsServiceProvider serviceProvider, String clusterNamePropertyId, String hostNamePropertyId) {
        return MetricsPropertyProvider.createInstance(type, PropertyHelper.getMetricPropertyIds(type), streamProvider, configuration, this.metricCacheProvider, hostProvider, serviceProvider, clusterNamePropertyId, hostNamePropertyId, null);
    }

    private PropertyProvider createMetricsComponentPropertyProvider(Resource.Type type, URLStreamProvider streamProvider, ComponentSSLConfiguration configuration, MetricHostProvider hostProvider, MetricsServiceProvider serviceProvider, String clusterNamePropertyId, String componentNamePropertyId) {
        return MetricsPropertyProvider.createInstance(type, PropertyHelper.getMetricPropertyIds(type), streamProvider, configuration, this.metricCacheProvider, hostProvider, serviceProvider, clusterNamePropertyId, null, componentNamePropertyId);
    }

    private PropertyProvider createMetricsHostComponentPropertyProvider(Resource.Type type, URLStreamProvider streamProvider, ComponentSSLConfiguration configuration, MetricHostProvider hostProvider, MetricsServiceProvider serviceProvider, String clusterNamePropertyId, String hostNamePropertyId, String componentNamePropertyId) {
        return MetricsPropertyProvider.createInstance(type, PropertyHelper.getMetricPropertyIds(type), streamProvider, configuration, this.metricCacheProvider, hostProvider, serviceProvider, clusterNamePropertyId, hostNamePropertyId, componentNamePropertyId);
    }

    @Override
    public String getJMXProtocol(String clusterName, String componentName) {
        String mapKey = String.format("%s-%s", clusterName, componentName);
        String jmxProtocolString = this.clusterJmxProtocolMap.get(mapKey);
        if (null != jmxProtocolString) {
            return jmxProtocolString;
        }
        try {
            if (componentName.equals("NAMENODE") || componentName.equals("DATANODE") || componentName.equals("RESOURCEMANAGER") || componentName.equals("NODEMANAGER") || componentName.equals("JOURNALNODE") || componentName.equals("HISTORYSERVER") || componentName.equals("HBASE_MASTER") || componentName.equals("HBASE_REGIONSERVER")) {
                String cachedSiteConfigVersion;
                Service.Type service = componentServiceMap.get(componentName);
                String config = serviceConfigTypes.get((Object)service);
                String newSiteConfigVersion = this.getDesiredConfigVersion(clusterName, config);
                if (!newSiteConfigVersion.equals(cachedSiteConfigVersion = this.clusterHdfsSiteConfigVersionMap.get(clusterName))) {
                    Map<String, String> protocolMap = this.getDesiredConfigMap(clusterName, newSiteConfigVersion, config, jmxDesiredProperties.get(componentName));
                    String propetyVal = protocolMap.get(componentName);
                    boolean isHttpsEnabled = service.equals((Object)Service.Type.HBASE) ? Boolean.valueOf(propetyVal).booleanValue() : PROPERTY_HDFS_HTTP_POLICY_VALUE_HTTPS_ONLY.equals(propetyVal);
                    jmxProtocolString = this.getJMXProtocolStringFromBool(isHttpsEnabled);
                }
            } else {
                jmxProtocolString = "http";
            }
        }
        catch (Exception e) {
            LOG.info("Exception while detecting JMX protocol for clusterName = " + clusterName + ", componentName = " + componentName, (Throwable)e);
            LOG.info("Defaulting JMX to HTTP protocol for  for clusterName = " + clusterName + ", componentName = " + componentName + componentName);
            jmxProtocolString = "http";
        }
        if (jmxProtocolString == null) {
            LOG.debug("Detected JMX protocol is null for clusterName = {}, componentName = {}", (Object)clusterName, (Object)componentName);
            LOG.debug("Defaulting JMX to HTTP protocol for  for clusterName = {}, componentName = {}", (Object)clusterName, (Object)componentName);
            jmxProtocolString = "http";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("JMXProtocol = {}, for clusterName={}, componentName = {}", new Object[]{jmxProtocolString, clusterName, componentName});
        }
        this.clusterJmxProtocolMap.put(mapKey, jmxProtocolString);
        return jmxProtocolString;
    }

    private String getJMXProtocolStringFromBool(boolean isHttpsEnabled) {
        return isHttpsEnabled ? "https" : "http";
    }

    @Override
    public String getJMXRpcMetricTag(String clusterName, String componentName, String port) {
        Map<String, String> portToTagMap;
        Map<String, Map<String, String>> componentToPortsMap = this.jmxDesiredRpcSuffixes.get(clusterName);
        if (componentToPortsMap != null && componentToPortsMap.containsKey(componentName) && (portToTagMap = componentToPortsMap.get(componentName)) != null) {
            return portToTagMap.get(port);
        }
        return null;
    }

    private void initRpcSuffixes(String clusterName, String componentName, String config, String configVersion, String hostName, String publicHostName) throws Exception {
        if (jmxDesiredRpcSuffixProperties.containsKey(componentName)) {
            Map<String, Object> configProperties;
            Map<Object, Object> componentToPortsMap;
            if (this.jmxDesiredRpcSuffixes.containsKey(clusterName)) {
                componentToPortsMap = this.jmxDesiredRpcSuffixes.get(clusterName);
            } else {
                componentToPortsMap = new HashMap();
                componentToPortsMap.put(componentName, new HashMap());
                this.jmxDesiredRpcSuffixes.put(clusterName, componentToPortsMap);
            }
            Map portToTagMap = (Map)componentToPortsMap.get(componentName);
            portToTagMap.clear();
            Map<String, String[]> keys = jmxDesiredRpcSuffixProperties.get(componentName);
            if ("NAMENODE".equals(componentName) && (configProperties = this.getConfigProperties(clusterName, configVersion, serviceConfigTypes.get((Object)componentServiceMap.get(componentName)))).containsKey("dfs.internal.nameservices")) {
                componentName = (String)componentName + "-HA";
                keys = jmxDesiredRpcSuffixProperties.get(componentName);
                Map<String, String[]> stringMap = jmxDesiredRpcSuffixProperties.get(componentName);
                for (String tag : stringMap.keySet()) {
                    keys.put(tag, this.getNamenodeHaProperty(configProperties, stringMap.get(tag), hostName, publicHostName));
                }
            }
            Map<String, String> props = this.getDesiredConfigMap(clusterName, configVersion, config, keys);
            for (Map.Entry<String, String> prop : props.entrySet()) {
                if (prop.getValue() == null) continue;
                portToTagMap.put(this.getPortString(prop.getValue()).trim(), prop.getKey());
            }
        }
    }

    @Subscribe
    public void onConfigurationChangedEvent(ClusterConfigChangedEvent event) {
        this.clusterJmxProtocolMap.clear();
    }

    static {
        serviceConfigTypes.put(Service.Type.HDFS, "hdfs-site");
        serviceConfigTypes.put(Service.Type.HBASE, "hbase-site");
        serviceConfigTypes.put(Service.Type.YARN, "yarn-site");
        serviceConfigTypes.put(Service.Type.MAPREDUCE2, "mapred-site");
        serviceConfigTypes.put(Service.Type.AMBARI_METRICS, "ams-site");
        componentServiceMap.put("NAMENODE", Service.Type.HDFS);
        componentServiceMap.put("DATANODE", Service.Type.HDFS);
        componentServiceMap.put("JOURNALNODE", Service.Type.HDFS);
        componentServiceMap.put("HBASE_MASTER", Service.Type.HBASE);
        componentServiceMap.put("HBASE_REGIONSERVER", Service.Type.HBASE);
        componentServiceMap.put("RESOURCEMANAGER", Service.Type.YARN);
        componentServiceMap.put("NODEMANAGER", Service.Type.YARN);
        componentServiceMap.put("HISTORYSERVER", Service.Type.MAPREDUCE2);
        HashMap<String, String[]> initPropMap = new HashMap<String, String[]>();
        initPropMap.put("NAMENODE", new String[]{"dfs.http.address", "dfs.namenode.http-address"});
        initPropMap.put("NAMENODE-HTTPS", new String[]{"dfs.namenode.https-address", "dfs.https.port"});
        initPropMap.put("NAMENODE-HA", new String[]{"dfs.namenode.http-address.%s.%s"});
        initPropMap.put("NAMENODE-HTTPS-HA", new String[]{"dfs.namenode.https-address.%s.%s"});
        initPropMap.put("DATANODE", new String[]{"dfs.datanode.http.address"});
        initPropMap.put("DATANODE-HTTPS", new String[]{"dfs.datanode.https.address"});
        initPropMap.put("JOURNALNODE-HTTPS", new String[]{"dfs.journalnode.https-address"});
        initPropMap.put("JOURNALNODE", new String[]{"dfs.journalnode.http-address"});
        serviceDesiredProperties.put(Service.Type.HDFS, initPropMap);
        initPropMap = new HashMap();
        initPropMap.put("HBASE_MASTER", new String[]{"hbase.master.info.port"});
        initPropMap.put("HBASE_REGIONSERVER", new String[]{"hbase.regionserver.info.port"});
        initPropMap.put("HBASE_MASTER-HTTPS", new String[]{"hbase.master.info.port"});
        initPropMap.put("HBASE_REGIONSERVER-HTTPS", new String[]{"hbase.regionserver.info.port"});
        serviceDesiredProperties.put(Service.Type.HBASE, initPropMap);
        initPropMap = new HashMap();
        initPropMap.put("RESOURCEMANAGER", new String[]{"yarn.resourcemanager.webapp.address"});
        initPropMap.put("RESOURCEMANAGER-HTTPS", new String[]{"yarn.resourcemanager.webapp.https.address"});
        initPropMap.put("NODEMANAGER", new String[]{"yarn.nodemanager.webapp.address"});
        initPropMap.put("NODEMANAGER-HTTPS", new String[]{"yarn.nodemanager.webapp.https.address"});
        serviceDesiredProperties.put(Service.Type.YARN, initPropMap);
        initPropMap = new HashMap();
        initPropMap.put("HISTORYSERVER", new String[]{"mapreduce.jobhistory.webapp.address"});
        initPropMap.put("HISTORYSERVER-HTTPS", new String[]{"mapreduce.jobhistory.webapp.https.address"});
        serviceDesiredProperties.put(Service.Type.MAPREDUCE2, initPropMap);
        initPropMap = new HashMap();
        initPropMap.put("NAMENODE", new String[]{"dfs.http.policy"});
        jmxDesiredProperties.put("NAMENODE", initPropMap);
        initPropMap = new HashMap();
        initPropMap.put("DATANODE", new String[]{"dfs.http.policy"});
        jmxDesiredProperties.put("DATANODE", initPropMap);
        initPropMap = new HashMap();
        initPropMap.put("JOURNALNODE", new String[]{"dfs.http.policy"});
        jmxDesiredProperties.put("JOURNALNODE", initPropMap);
        initPropMap = new HashMap();
        initPropMap.put("RESOURCEMANAGER", new String[]{"yarn.http.policy"});
        jmxDesiredProperties.put("RESOURCEMANAGER", initPropMap);
        initPropMap = new HashMap();
        initPropMap.put("HBASE_MASTER", new String[]{"hbase.ssl.enabled"});
        jmxDesiredProperties.put("HBASE_MASTER", initPropMap);
        initPropMap = new HashMap();
        initPropMap.put("HBASE_REGIONSERVER", new String[]{"hbase.ssl.enabled"});
        jmxDesiredProperties.put("HBASE_REGIONSERVER", initPropMap);
        initPropMap = new HashMap();
        initPropMap.put("NODEMANAGER", new String[]{"yarn.http.policy"});
        jmxDesiredProperties.put("NODEMANAGER", initPropMap);
        initPropMap = new HashMap();
        initPropMap.put("HISTORYSERVER", new String[]{"mapreduce.jobhistory.http.policy"});
        jmxDesiredProperties.put("HISTORYSERVER", initPropMap);
        initPropMap = new HashMap();
        initPropMap.put("client", new String[]{"dfs.namenode.rpc-address"});
        initPropMap.put("datanode", new String[]{"dfs.namenode.servicerpc-address"});
        initPropMap.put("healthcheck", new String[]{"dfs.namenode.lifeline.rpc-address"});
        jmxDesiredRpcSuffixProperties.put("NAMENODE", initPropMap);
        initPropMap = new HashMap();
        initPropMap.put("client", new String[]{"dfs.namenode.rpc-address.%s.%s"});
        initPropMap.put("datanode", new String[]{"dfs.namenode.servicerpc-address.%s.%s"});
        initPropMap.put("healthcheck", new String[]{"dfs.namenode.lifeline.rpc-address.%s.%s"});
        jmxDesiredRpcSuffixProperties.put("NAMENODE-HA", initPropMap);
        HTTP_PROPERTY_REQUESTS.put("RESOURCEMANAGER", Collections.singletonList(new ResourceManagerHttpPropertyRequest()));
        HTTP_PROPERTY_REQUESTS.put("ATLAS_SERVER", Collections.singletonList(new AtlasServerHttpPropertyRequest()));
        LOG = LoggerFactory.getLogger(AbstractProviderModule.class);
    }
}

