/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OBDPServer;
import id.onyx.obdp.server.controller.internal.BaseProvider;
import id.onyx.obdp.server.controller.internal.PropertyInfo;
import id.onyx.obdp.server.controller.metrics.MetricReportingAdapter;
import id.onyx.obdp.server.controller.spi.PropertyProvider;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.TemporalInfo;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPropertyProvider
extends BaseProvider
implements PropertyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPropertyProvider.class);
    private final Map<String, Map<String, PropertyInfo>> componentMetrics;
    private static final Pattern CHECK_FOR_METRIC_ARGUMENT_METHODS_REGEX = Pattern.compile("(\\$\\d\\.[^\\$]+\\))+");
    private static final Pattern FIND_ARGUMENT_METHOD_REGEX = Pattern.compile(".\\w+\\(.*?\\)");
    private static final Pattern FIND_ARGUMENT_METHOD_ARGUMENTS_REGEX = Pattern.compile("\".*?\"|[0-9]+");
    private static final String FIND_REGEX_IN_METRIC_REGEX = "\\([^)]+\\)";
    private static final DecimalFormat decimalFormat = new DecimalFormat("#.00");

    public AbstractPropertyProvider(Map<String, Map<String, PropertyInfo>> componentMetrics) {
        super(PropertyHelper.getPropertyIds(componentMetrics));
        this.componentMetrics = componentMetrics;
    }

    public Map<String, Map<String, PropertyInfo>> getComponentMetrics() {
        return this.componentMetrics;
    }

    protected String getResourceTypeFromResources(Set<Resource> resources) {
        Resource res;
        Iterator<Resource> itr;
        String resType = null;
        if (resources != null && (itr = resources.iterator()).hasNext() && (res = itr.next()) != null) {
            resType = res.getType().toString();
        }
        return resType;
    }

    protected Set<String> getClustersNameFromResources(Set<Resource> resources, String clusterNamePropertyId) {
        HashSet<String> clusNames = new HashSet<String>();
        if (resources != null) {
            for (Resource res : resources) {
                if (res == null) continue;
                clusNames.add((String)res.getPropertyValue(clusterNamePropertyId));
            }
        }
        return clusNames;
    }

    protected Set<Long> getClustersResourceId(Set<Resource> resources, String clusterNamePropertyId) {
        HashSet<Long> clusterResId = new HashSet<Long>();
        if (clusterNamePropertyId != null) {
            try {
                OBDPManagementController amc = OBDPServer.getController();
                Set<String> clusterNames = this.getClustersNameFromResources(resources, clusterNamePropertyId);
                Iterator<String> clusNameItr = clusterNames.iterator();
                while (clusNameItr.hasNext()) {
                    clusterResId.add(amc.getClusters().getCluster(clusNameItr.next()).getResourceId());
                }
            }
            catch (OBDPException e) {
                LOG.error("Cluster Id couldn't be retrieved.");
            }
            catch (Exception e) {
                LOG.error("Cluster Id couldn't be retrieved");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieved Cluster Ids = {}", clusterResId);
        }
        return clusterResId;
    }

    protected boolean checkAuthorizationForMetrics(Set<Resource> resources, String clusterNamePropertyId) throws AuthorizationException {
        String resType = null;
        resType = this.getResourceTypeFromResources(resources);
        if (resType == null) {
            return false;
        }
        Set<Long> clusterResIds = this.getClustersResourceId(resources, clusterNamePropertyId);
        if (clusterResIds.size() == 0) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieved cluster's Resource Id = {}, Resource Type = {}", clusterResIds, (Object)resType);
        }
        block6: for (Long clusResId : clusterResIds) {
            Resource.InternalType resTypeVal = Resource.InternalType.valueOf(resType);
            switch (resTypeVal) {
                case Cluster: {
                    if (AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, clusResId, EnumSet.of(RoleAuthorization.CLUSTER_VIEW_METRICS))) continue block6;
                    throw new AuthorizationException("The authenticated user does not have authorization to view cluster metrics");
                }
                case Host: {
                    if (AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, clusResId, EnumSet.of(RoleAuthorization.HOST_VIEW_METRICS))) continue block6;
                    throw new AuthorizationException("The authenticated user does not have authorization to view Host metrics");
                }
                case Component: {
                    if (AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, clusResId, EnumSet.of(RoleAuthorization.SERVICE_VIEW_METRICS))) continue block6;
                    throw new AuthorizationException("The authenticated user does not have authorization to view Service metrics");
                }
                case HostComponent: {
                    if (AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, clusResId, EnumSet.of(RoleAuthorization.SERVICE_VIEW_METRICS))) continue block6;
                    throw new AuthorizationException("The authenticated user does not have authorization to view Service metrics");
                }
            }
            LOG.error("Unsuported Resource Type for Metrics");
            return false;
        }
        return true;
    }

    protected Map<String, PropertyInfo> getPropertyInfoMap(String componentName, String propertyId) {
        HashMap<String, PropertyInfo> propertyInfoMap = new HashMap<String, PropertyInfo>();
        this.updatePropertyInfoMap(componentName, propertyId, propertyInfoMap);
        return propertyInfoMap;
    }

    protected void updatePropertyInfoMap(String componentName, String propertyId, Map<String, PropertyInfo> propertyInfoMap) {
        Object regexKey;
        Map<String, PropertyInfo> componentMetricMap = this.getComponentMetrics().get(componentName);
        propertyInfoMap.clear();
        if (componentMetricMap == null) {
            return;
        }
        PropertyInfo propertyInfo = componentMetricMap.get(propertyId);
        if (propertyInfo != null) {
            propertyInfoMap.put((String)propertyId, propertyInfo);
            return;
        }
        Map.Entry<String, Pattern> regexEntry = this.getRegexEntry((String)propertyId);
        if (regexEntry != null && (propertyInfo = componentMetricMap.get(regexKey = regexEntry.getKey())) != null) {
            propertyInfoMap.put((String)regexKey, propertyInfo);
            return;
        }
        if (!((String)propertyId).endsWith("/")) {
            propertyId = (String)propertyId + "/";
        }
        for (Map.Entry entry : componentMetricMap.entrySet()) {
            if (!((String)entry.getKey()).startsWith((String)propertyId)) continue;
            String key = (String)entry.getKey();
            propertyInfoMap.put(key, (PropertyInfo)entry.getValue());
        }
        if (regexEntry != null) {
            Object regexPattern = regexEntry.getValue().pattern();
            regexPattern = (String)regexPattern + "(\\S*)";
            for (Map.Entry<String, PropertyInfo> entry : componentMetricMap.entrySet()) {
                if (!entry.getKey().matches((String)regexPattern)) continue;
                propertyInfoMap.put(entry.getKey(), entry.getValue());
            }
        }
    }

    protected static String substituteArgument(String propertyId, String argName, String val) {
        String value;
        int argStart = propertyId.indexOf(argName);
        String string = value = val == null ? "" : val;
        if (argStart > -1) {
            String argSegment = propertyId.substring(argStart);
            Matcher matcher = CHECK_FOR_METRIC_ARGUMENT_METHODS_REGEX.matcher(argSegment);
            if (matcher.find()) {
                argName = argSegment.substring(matcher.start(), matcher.end());
                matcher = FIND_ARGUMENT_METHOD_REGEX.matcher(argName);
                while (matcher.find()) {
                    int openParenIndex = argName.indexOf(40, matcher.start());
                    int closeParenIndex = AbstractPropertyProvider.indexOfClosingParenthesis(argName, openParenIndex);
                    String methodName = argName.substring(matcher.start() + 1, openParenIndex);
                    String args = argName.substring(openParenIndex + 1, closeParenIndex);
                    LinkedList<Object> argList = new LinkedList<Object>();
                    LinkedList paramTypes = new LinkedList();
                    Matcher argMatcher = FIND_ARGUMENT_METHOD_ARGUMENTS_REGEX.matcher(args);
                    while (argMatcher.find()) {
                        AbstractPropertyProvider.addArgument(args, argMatcher.start(), argMatcher.end(), argList, paramTypes);
                    }
                    try {
                        value = AbstractPropertyProvider.invokeArgumentMethod(value, methodName, argList, paramTypes);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Can't apply method " + methodName + " for argument " + argName + " in " + propertyId, e);
                    }
                }
                if (value.equals(val)) {
                    return propertyId;
                }
            }
            return propertyId.replace(argName, value);
        }
        throw new IllegalArgumentException("Can't substitute " + val + "  for argument " + argName + " in " + propertyId);
    }

    private static int indexOfClosingParenthesis(String s, int index) {
        int depth = 0;
        int length = s.length();
        while (index < length) {
            char c;
            if ((c = s.charAt(index++)) == '(') {
                ++depth;
                continue;
            }
            if (c != ')' || --depth != 0) continue;
            return index;
        }
        return -1;
    }

    private static void addArgument(String args, int start, int end, List<Object> argList, List<Class<?>> paramTypes) {
        String arg = args.substring(start, end);
        if (arg.contains("\"")) {
            argList.add(arg.substring(1, arg.length() - 1));
            paramTypes.add(String.class);
        } else {
            Integer number = Integer.parseInt(arg);
            argList.add(number);
            paramTypes.add(Integer.TYPE);
        }
    }

    private static String invokeArgumentMethod(String argValue, String methodName, List<Object> argList, List<Class<?>> paramTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = String.class.getMethod(methodName, paramTypes.toArray(new Class[paramTypes.size()]));
        return (String)method.invoke((Object)argValue, argList.toArray(new Object[argList.size()]));
    }

    protected void updateComponentMetricMap(Map<String, PropertyInfo> componentMetricMap, String propertyId) {
        PropertyInfo propertyInfo;
        String regexKey = null;
        Map.Entry<String, Pattern> regexEntry = this.getRegexEntry(propertyId);
        if (null != regexEntry) {
            regexKey = regexEntry.getKey();
        }
        if (!componentMetricMap.containsKey(propertyId) && regexKey != null && !regexKey.equals(propertyId) && (propertyInfo = componentMetricMap.get(regexKey)) != null) {
            List<String> regexGroups = this.getRegexGroups(regexKey, propertyId);
            String key = propertyInfo.getPropertyId();
            for (String regexGroup : regexGroups) {
                regexGroup = regexGroup.replace("/", ".");
                key = key.replaceFirst(FIND_REGEX_IN_METRIC_REGEX, regexGroup);
            }
            PropertyInfo compPropertyInfo = new PropertyInfo(key, propertyInfo.isTemporal(), propertyInfo.isPointInTime());
            compPropertyInfo.setAmsHostMetric(propertyInfo.isAmsHostMetric());
            compPropertyInfo.setAmsId(propertyInfo.getAmsId());
            compPropertyInfo.setUnit(propertyInfo.getUnit());
            componentMetricMap.put(propertyId, compPropertyInfo);
        }
    }

    protected PropertyInfo updatePropertyInfo(String propertyKey, String id, PropertyInfo propertyInfo) {
        List<String> regexGroups = this.getRegexGroups(propertyKey, id);
        String propertyId = propertyInfo.getPropertyId();
        if (propertyId != null) {
            for (String regexGroup : regexGroups) {
                regexGroup = regexGroup.replace("/", ".");
                propertyId = propertyId.replaceFirst(FIND_REGEX_IN_METRIC_REGEX, regexGroup);
            }
        }
        return new PropertyInfo(propertyId, propertyInfo.isTemporal(), propertyInfo.isPointInTime());
    }

    protected boolean isSupportedPropertyId(String componentName, String propertyId) {
        Map<String, PropertyInfo> componentMetricMap = this.componentMetrics.get(componentName);
        return componentMetricMap != null && (componentMetricMap.containsKey(propertyId) || this.checkPropertyCategory(propertyId));
    }

    protected boolean checkPropertyCategory(String propertyId) {
        Set<String> categoryIds = this.getCategoryIds();
        if (categoryIds.contains(propertyId)) {
            return true;
        }
        String category = PropertyHelper.getPropertyCategory(propertyId);
        while (category != null) {
            if (categoryIds.contains(category)) {
                return true;
            }
            category = PropertyHelper.getPropertyCategory(category);
        }
        return false;
    }

    private static Number[][] getGangliaLikeDatapoints(TimelineMetric metric, TemporalInfo temporalInfo) {
        MetricReportingAdapter rpt = new MetricReportingAdapter(metric);
        return rpt.reportMetricData(metric, temporalInfo);
    }

    protected static Object getValue(TimelineMetric metric, TemporalInfo temporalInfo) {
        Number[][] dataPoints = AbstractPropertyProvider.getGangliaLikeDatapoints(metric, temporalInfo);
        int length = dataPoints.length;
        if (temporalInfo != null) {
            return length > 0 ? dataPoints : null;
        }
        return length > 0 ? (Number)dataPoints[length - 1][0] : (Number)0;
    }
}

