/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.spi.Resource;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractJDBCResourceProvider<E extends Enum<E>>
extends AbstractResourceProvider {
    private final Map<String, E> dbFields = this.getDBFieldMap();

    protected AbstractJDBCResourceProvider(Set<String> propertyIds, Map<Resource.Type, String> keyPropertyIds) {
        super(propertyIds, keyPropertyIds);
    }

    protected abstract Map<String, E> getDBFieldMap();

    protected void setString(Resource resource, String propertyId, ResultSet rs, Set<String> requestedIds) throws SQLException {
        if (requestedIds.contains(propertyId)) {
            AbstractJDBCResourceProvider.setResourceProperty(resource, propertyId, rs.getString(((Enum)this.dbFields.get(propertyId)).toString()), requestedIds);
        }
    }

    protected void setInt(Resource resource, String propertyId, ResultSet rs, Set<String> requestedIds) throws SQLException {
        if (requestedIds.contains(propertyId)) {
            AbstractJDBCResourceProvider.setResourceProperty(resource, propertyId, rs.getInt(((Enum)this.dbFields.get(propertyId)).toString()), requestedIds);
        }
    }

    protected void setLong(Resource resource, String propertyId, ResultSet rs, Set<String> requestedIds) throws SQLException {
        if (requestedIds.contains(propertyId)) {
            AbstractJDBCResourceProvider.setResourceProperty(resource, propertyId, rs.getLong(((Enum)this.dbFields.get(propertyId)).toString()), requestedIds);
        }
    }

    protected String getDBFieldString(Set<String> requestedIds) {
        Object[] tmp = new String[requestedIds.size()];
        int i = 0;
        for (String s : requestedIds) {
            if (!this.dbFields.containsKey(s)) continue;
            tmp[i++] = ((Enum)this.dbFields.get(s)).toString();
        }
        return StringUtils.join((Object[])tmp, (String)",", (int)0, (int)i);
    }

    protected E getDBField(String propertyId) {
        return (E)((Enum)this.dbFields.get(propertyId));
    }
}

