/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.FeedResourceProvider;
import id.onyx.obdp.server.controller.internal.InstanceResourceProvider;
import id.onyx.obdp.server.controller.internal.TargetClusterResourceProvider;
import id.onyx.obdp.server.controller.ivory.IvoryService;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceProvider;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDRResourceProvider
extends AbstractResourceProvider {
    private final IvoryService ivoryService;

    protected AbstractDRResourceProvider(Set<String> propertyIds, Map<Resource.Type, String> keyPropertyIds, IvoryService ivoryService) {
        super(propertyIds, keyPropertyIds);
        this.ivoryService = ivoryService;
    }

    protected IvoryService getService() {
        return this.ivoryService;
    }

    public static ResourceProvider getResourceProvider(Resource.Type type, IvoryService service) {
        switch (type.getInternalType()) {
            case DRFeed: {
                return new FeedResourceProvider(service);
            }
            case DRTargetCluster: {
                return new TargetClusterResourceProvider(service);
            }
            case DRInstance: {
                return new InstanceResourceProvider(service);
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }
}

