/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.ResourceProviderFactory;
import id.onyx.obdp.server.controller.internal.AbstractAuthorizedResourceProvider;
import id.onyx.obdp.server.controller.internal.ActionResourceProvider;
import id.onyx.obdp.server.controller.internal.ActiveWidgetLayoutResourceProvider;
import id.onyx.obdp.server.controller.internal.BlueprintResourceProvider;
import id.onyx.obdp.server.controller.internal.ClientConfigResourceProvider;
import id.onyx.obdp.server.controller.internal.ClusterControllerImpl;
import id.onyx.obdp.server.controller.internal.ClusterKerberosDescriptorResourceProvider;
import id.onyx.obdp.server.controller.internal.ClusterResourceProvider;
import id.onyx.obdp.server.controller.internal.CompatibleRepositoryVersionResourceProvider;
import id.onyx.obdp.server.controller.internal.ConfigGroupResourceProvider;
import id.onyx.obdp.server.controller.internal.ConfigurationResourceProvider;
import id.onyx.obdp.server.controller.internal.ExtensionLinkResourceProvider;
import id.onyx.obdp.server.controller.internal.ExtensionResourceProvider;
import id.onyx.obdp.server.controller.internal.ExtensionVersionResourceProvider;
import id.onyx.obdp.server.controller.internal.GroupResourceProvider;
import id.onyx.obdp.server.controller.internal.HostComponentProcessResourceProvider;
import id.onyx.obdp.server.controller.internal.HostStackVersionResourceProvider;
import id.onyx.obdp.server.controller.internal.LoggingResourceProvider;
import id.onyx.obdp.server.controller.internal.MpackResourceProvider;
import id.onyx.obdp.server.controller.internal.QuickLinkArtifactResourceProvider;
import id.onyx.obdp.server.controller.internal.RecommendationResourceProvider;
import id.onyx.obdp.server.controller.internal.RequestResourceProvider;
import id.onyx.obdp.server.controller.internal.RequestScheduleResourceProvider;
import id.onyx.obdp.server.controller.internal.RoleAuthorizationResourceProvider;
import id.onyx.obdp.server.controller.internal.RootServiceComponentResourceProvider;
import id.onyx.obdp.server.controller.internal.RootServiceHostComponentResourceProvider;
import id.onyx.obdp.server.controller.internal.RootServiceResourceProvider;
import id.onyx.obdp.server.controller.internal.ServiceConfigVersionResourceProvider;
import id.onyx.obdp.server.controller.internal.StackArtifactResourceProvider;
import id.onyx.obdp.server.controller.internal.StackConfigurationDependencyResourceProvider;
import id.onyx.obdp.server.controller.internal.StackConfigurationResourceProvider;
import id.onyx.obdp.server.controller.internal.StackLevelConfigurationResourceProvider;
import id.onyx.obdp.server.controller.internal.StackResourceProvider;
import id.onyx.obdp.server.controller.internal.StackServiceComponentResourceProvider;
import id.onyx.obdp.server.controller.internal.StackServiceResourceProvider;
import id.onyx.obdp.server.controller.internal.StackVersionResourceProvider;
import id.onyx.obdp.server.controller.internal.TaskResourceProvider;
import id.onyx.obdp.server.controller.internal.ThemeArtifactResourceProvider;
import id.onyx.obdp.server.controller.internal.UserAuthorizationResourceProvider;
import id.onyx.obdp.server.controller.internal.ValidationResourceProvider;
import id.onyx.obdp.server.controller.internal.VersionDefinitionResourceProvider;
import id.onyx.obdp.server.controller.internal.WidgetLayoutResourceProvider;
import id.onyx.obdp.server.controller.internal.WidgetResourceProvider;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceProvider;
import id.onyx.obdp.server.controller.utilities.ClusterControllerHelper;
import id.onyx.obdp.server.state.Cluster;
import java.util.Map;
import java.util.Set;

public abstract class AbstractControllerResourceProvider
extends AbstractAuthorizedResourceProvider {
    private static ResourceProviderFactory resourceProviderFactory;
    private final OBDPManagementController managementController;

    AbstractControllerResourceProvider(Resource.Type type, Set<String> propertyIds, Map<Resource.Type, String> keyPropertyIds, OBDPManagementController managementController) {
        super(type, propertyIds, keyPropertyIds);
        this.managementController = managementController;
    }

    public static void init(ResourceProviderFactory factory) {
        resourceProviderFactory = factory;
    }

    protected OBDPManagementController getManagementController() {
        return this.managementController;
    }

    protected Long getClusterId(String clusterName) throws OBDPException {
        Cluster cluster = clusterName == null ? null : this.managementController.getClusters().getCluster(clusterName);
        return cluster == null ? null : Long.valueOf(cluster.getClusterId());
    }

    protected Long getClusterResourceId(String clusterName) throws OBDPException {
        Cluster cluster = clusterName == null ? null : this.managementController.getClusters().getCluster(clusterName);
        return cluster == null ? null : cluster.getResourceId();
    }

    protected Long getClusterResourceId(Long clusterId) throws OBDPException {
        Cluster cluster = clusterId == null ? null : this.managementController.getClusters().getClusterById(clusterId);
        return cluster == null ? null : cluster.getResourceId();
    }

    public static ResourceProvider getResourceProvider(Resource.Type type, OBDPManagementController managementController) {
        switch (type.getInternalType()) {
            case Cluster: {
                return new ClusterResourceProvider(managementController);
            }
            case Service: {
                return resourceProviderFactory.getServiceResourceProvider(managementController);
            }
            case Component: {
                return resourceProviderFactory.getComponentResourceProvider(managementController);
            }
            case Host: {
                return resourceProviderFactory.getHostResourceProvider(managementController);
            }
            case HostComponent: {
                return resourceProviderFactory.getHostComponentResourceProvider(managementController);
            }
            case Configuration: {
                return new ConfigurationResourceProvider(managementController);
            }
            case ServiceConfigVersion: {
                return new ServiceConfigVersionResourceProvider(managementController);
            }
            case Action: {
                return new ActionResourceProvider(managementController);
            }
            case Request: {
                return new RequestResourceProvider(managementController);
            }
            case Task: {
                return new TaskResourceProvider(managementController);
            }
            case User: {
                return resourceProviderFactory.getUserResourceProvider(managementController);
            }
            case UserAuthenticationSource: {
                return resourceProviderFactory.getUserAuthenticationSourceResourceProvider();
            }
            case Group: {
                return new GroupResourceProvider(managementController);
            }
            case Member: {
                return resourceProviderFactory.getMemberResourceProvider(managementController);
            }
            case Upgrade: {
                return resourceProviderFactory.getUpgradeResourceProvider(managementController);
            }
            case Stack: {
                return new StackResourceProvider(managementController);
            }
            case Mpack: {
                return new MpackResourceProvider(managementController);
            }
            case StackVersion: {
                return new StackVersionResourceProvider(managementController);
            }
            case ClusterStackVersion: {
                return resourceProviderFactory.getClusterStackVersionResourceProvider(managementController);
            }
            case HostStackVersion: {
                return new HostStackVersionResourceProvider(managementController);
            }
            case StackService: {
                return new StackServiceResourceProvider(managementController);
            }
            case StackServiceComponent: {
                return new StackServiceComponentResourceProvider(managementController);
            }
            case StackConfiguration: {
                return new StackConfigurationResourceProvider(managementController);
            }
            case StackConfigurationDependency: {
                return new StackConfigurationDependencyResourceProvider(managementController);
            }
            case StackLevelConfiguration: {
                return new StackLevelConfigurationResourceProvider(managementController);
            }
            case ExtensionLink: {
                return new ExtensionLinkResourceProvider(managementController);
            }
            case Extension: {
                return new ExtensionResourceProvider(managementController);
            }
            case ExtensionVersion: {
                return new ExtensionVersionResourceProvider(managementController);
            }
            case RootService: {
                return new RootServiceResourceProvider(managementController);
            }
            case RootServiceComponent: {
                return new RootServiceComponentResourceProvider(managementController);
            }
            case RootServiceComponentConfiguration: {
                return resourceProviderFactory.getRootServiceHostComponentConfigurationResourceProvider();
            }
            case RootServiceHostComponent: {
                return new RootServiceHostComponentResourceProvider(managementController);
            }
            case ConfigGroup: {
                return new ConfigGroupResourceProvider(managementController);
            }
            case RequestSchedule: {
                return new RequestScheduleResourceProvider(managementController);
            }
            case HostComponentProcess: {
                return new HostComponentProcessResourceProvider(managementController);
            }
            case Blueprint: {
                return new BlueprintResourceProvider(managementController);
            }
            case KerberosDescriptor: {
                return resourceProviderFactory.getKerberosDescriptorResourceProvider(managementController);
            }
            case Recommendation: {
                return new RecommendationResourceProvider(managementController);
            }
            case Validation: {
                return new ValidationResourceProvider(managementController);
            }
            case ClientConfig: {
                return new ClientConfigResourceProvider(managementController);
            }
            case RepositoryVersion: {
                return resourceProviderFactory.getRepositoryVersionResourceProvider();
            }
            case CompatibleRepositoryVersion: {
                return new CompatibleRepositoryVersionResourceProvider(managementController);
            }
            case StackArtifact: {
                return new StackArtifactResourceProvider(managementController);
            }
            case Theme: {
                return new ThemeArtifactResourceProvider(managementController);
            }
            case QuickLink: {
                return new QuickLinkArtifactResourceProvider(managementController);
            }
            case ActiveWidgetLayout: {
                return new ActiveWidgetLayoutResourceProvider(managementController);
            }
            case WidgetLayout: {
                return new WidgetLayoutResourceProvider(managementController);
            }
            case Widget: {
                return new WidgetResourceProvider(managementController);
            }
            case HostKerberosIdentity: {
                return resourceProviderFactory.getHostKerberosIdentityResourceProvider(managementController);
            }
            case Credential: {
                return resourceProviderFactory.getCredentialResourceProvider(managementController);
            }
            case RoleAuthorization: {
                return new RoleAuthorizationResourceProvider(managementController);
            }
            case UserAuthorization: {
                return new UserAuthorizationResourceProvider(managementController);
            }
            case VersionDefinition: {
                return new VersionDefinitionResourceProvider();
            }
            case ClusterKerberosDescriptor: {
                return new ClusterKerberosDescriptorResourceProvider(managementController);
            }
            case LoggingQuery: {
                return new LoggingResourceProvider(managementController);
            }
            case AlertTarget: {
                return resourceProviderFactory.getAlertTargetResourceProvider();
            }
            case ViewInstance: {
                return resourceProviderFactory.getViewInstanceResourceProvider();
            }
            case Auth: {
                return resourceProviderFactory.getAuthResourceProvider(managementController);
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    public static ResourceProvider getResourceProvider(Resource.Type type) {
        return ((ClusterControllerImpl)ClusterControllerHelper.getClusterController()).ensureResourceProvider(type);
    }
}

