/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.security.core.Authentication;

public abstract class AbstractAuthorizedResourceProvider
extends AbstractResourceProvider {
    private Set<RoleAuthorization> requiredCreateAuthorizations = Collections.emptySet();
    private Set<RoleAuthorization> requiredGetAuthorizations = Collections.emptySet();
    private Set<RoleAuthorization> requiredUpdateAuthorizations = Collections.emptySet();
    private Set<RoleAuthorization> requiredDeleteAuthorizations = Collections.emptySet();

    AbstractAuthorizedResourceProvider(Resource.Type type, Set<String> propertyIds, Map<Resource.Type, String> keyPropertyIds) {
        super(propertyIds, keyPropertyIds);
        PropertyHelper.setPropertyIds(type, propertyIds);
        PropertyHelper.setKeyPropertyIds(type, keyPropertyIds);
    }

    public Set<RoleAuthorization> getRequiredCreateAuthorizations() {
        return this.requiredCreateAuthorizations;
    }

    public void setRequiredCreateAuthorizations(Set<RoleAuthorization> requiredCreateAuthorizations) {
        this.requiredCreateAuthorizations = this.createUnmodifiableSet(requiredCreateAuthorizations);
    }

    public Set<RoleAuthorization> getRequiredGetAuthorizations() {
        return this.requiredGetAuthorizations;
    }

    public void setRequiredGetAuthorizations(Set<RoleAuthorization> requiredGetAuthorizations) {
        this.requiredGetAuthorizations = this.createUnmodifiableSet(requiredGetAuthorizations);
    }

    public Set<RoleAuthorization> getRequiredUpdateAuthorizations() {
        return this.requiredUpdateAuthorizations;
    }

    public void setRequiredUpdateAuthorizations(Set<RoleAuthorization> requiredUpdateAuthorizations) {
        this.requiredUpdateAuthorizations = this.createUnmodifiableSet(requiredUpdateAuthorizations);
    }

    public Set<RoleAuthorization> getRequiredDeleteAuthorizations() {
        return this.requiredDeleteAuthorizations;
    }

    public void setRequiredDeleteAuthorizations(Set<RoleAuthorization> requiredDeleteAuthorizations) {
        this.requiredDeleteAuthorizations = this.createUnmodifiableSet(requiredDeleteAuthorizations);
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        Authentication authentication = AuthorizationHelper.getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new AuthorizationException("Authentication data is not available, authorization to perform the requested operation is not granted");
        }
        if (!this.isAuthorizedToCreateResources(authentication, request)) {
            throw new AuthorizationException("The authenticated user does not have the appropriate authorizations to create the requested resource(s)");
        }
        return this.createResourcesAuthorized(request);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Authentication authentication = AuthorizationHelper.getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new AuthorizationException("Authentication data is not available, authorization to perform the requested operation is not granted");
        }
        if (!this.isAuthorizedToGetResources(authentication, request, predicate)) {
            throw new AuthorizationException("The authenticated user does not have the appropriate authorizations to get the requested resource(s)");
        }
        return this.getResourcesAuthorized(request, predicate);
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Authentication authentication = AuthorizationHelper.getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new AuthorizationException("Authentication data is not available, authorization to perform the requested operation is not granted");
        }
        if (!this.isAuthorizedToUpdateResources(authentication, request, predicate)) {
            throw new AuthorizationException("The authenticated user does not have the appropriate authorizations to update the requested resource(s)");
        }
        return this.updateResourcesAuthorized(request, predicate);
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Authentication authentication = AuthorizationHelper.getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new AuthorizationException("Authentication data is not available, authorization to perform the requested operation is not granted");
        }
        if (!this.isAuthorizedToDeleteResources(authentication, predicate)) {
            throw new AuthorizationException("The authenticated user does not have the appropriate authorizations to delete the requested resource(s)");
        }
        return this.deleteResourcesAuthorized(request, predicate);
    }

    protected RequestStatus createResourcesAuthorized(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("If createResources is not overwritten, then createResourcesAuthorized must be overwritten");
    }

    protected boolean isAuthorizedToCreateResources(Authentication authentication, Request request) throws SystemException {
        return AuthorizationHelper.isAuthorized(authentication, this.getResourceType(request, null), this.getResourceId(request, null), this.requiredCreateAuthorizations);
    }

    protected Set<Resource> getResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("If getResources is not overwritten, then getResourcesAuthorized must be overwritten");
    }

    protected boolean isAuthorizedToGetResources(Authentication authentication, Request request, Predicate predicate) throws SystemException {
        return AuthorizationHelper.isAuthorized(authentication, this.getResourceType(request, predicate), this.getResourceId(request, predicate), this.requiredGetAuthorizations);
    }

    protected RequestStatus updateResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("If updateResources is not overwritten, then updateResourcesAuthorized must be overwritten");
    }

    protected boolean isAuthorizedToUpdateResources(Authentication authentication, Request request, Predicate predicate) throws SystemException {
        return AuthorizationHelper.isAuthorized(authentication, this.getResourceType(request, predicate), this.getResourceId(request, predicate), this.requiredUpdateAuthorizations);
    }

    protected RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("If deleteResources is not overwritten, then deleteResourcesAuthorized must be overwritten");
    }

    protected boolean isAuthorizedToDeleteResources(Authentication authentication, Predicate predicate) throws SystemException {
        return AuthorizationHelper.isAuthorized(authentication, this.getResourceType(null, predicate), this.getResourceId(null, predicate), this.requiredDeleteAuthorizations);
    }

    protected ResourceType getResourceType(Request request, Predicate predicate) {
        return ResourceType.CLUSTER;
    }

    protected Long getResourceId(Request request, Predicate predicate) {
        return null;
    }

    private Set<RoleAuthorization> createUnmodifiableSet(Set<RoleAuthorization> set) {
        return set == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<RoleAuthorization>(set));
    }
}

