/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import id.onyx.obdp.server.controller.ApiModel;
import id.onyx.obdp.server.stack.Validable;
import io.swagger.annotations.ApiModelProperty;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StackVersionResponse
implements Validable {
    private String minJdk;
    private String maxJdk;
    private String stackName;
    private String stackVersion;
    private String minUpgradeVersion;
    private boolean active;
    private boolean valid;
    private String parentVersion;
    private Map<String, Map<String, Map<String, String>>> configTypes;
    private Collection<File> serviceKerberosDescriptorFiles;
    private Set<String> upgradePacks = Collections.emptySet();
    private Set<String> errorSet = new HashSet<String>();

    public StackVersionResponse(String stackVersion, boolean active, String parentVersion, Map<String, Map<String, Map<String, String>>> configTypes, Collection<File> serviceKerberosDescriptorFiles, Set<String> upgradePacks, boolean valid, Collection<String> errorSet, String minJdk, String maxJdk) {
        this.setStackVersion(stackVersion);
        this.setActive(active);
        this.setParentVersion(parentVersion);
        this.setConfigTypes(configTypes);
        this.setServiceKerberosDescriptorFiles(serviceKerberosDescriptorFiles);
        this.setUpgradePacks(upgradePacks);
        this.setValid(valid);
        this.addErrors(errorSet);
        this.setMinJdk(minJdk);
        this.setMaxJdk(maxJdk);
    }

    @Override
    @ApiModelProperty(name="valid")
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public void addError(String error) {
        this.errorSet.add(error);
    }

    @Override
    @ApiModelProperty(name="stack-errors")
    public Collection<String> getErrors() {
        return this.errorSet;
    }

    @Override
    public void addErrors(Collection<String> errors) {
        this.errorSet.addAll(errors);
    }

    @ApiModelProperty(name="min_jdk")
    public String getMinJdk() {
        return this.minJdk;
    }

    public void setMinJdk(String minJdk) {
        this.minJdk = minJdk;
    }

    @ApiModelProperty(name="max_jdk")
    public String getMaxJdk() {
        return this.maxJdk;
    }

    public void setMaxJdk(String maxJdk) {
        this.maxJdk = maxJdk;
    }

    @ApiModelProperty(name="stack_name")
    public String getStackName() {
        return this.stackName;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    @ApiModelProperty(name="stack_version")
    public String getStackVersion() {
        return this.stackVersion;
    }

    public void setStackVersion(String stackVersion) {
        this.stackVersion = stackVersion;
    }

    @ApiModelProperty(name="active")
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @ApiModelProperty(name="parent_stack_version")
    public String getParentVersion() {
        return this.parentVersion;
    }

    public void setParentVersion(String parentVersion) {
        this.parentVersion = parentVersion;
    }

    @ApiModelProperty(name="config_types")
    public Map<String, Map<String, Map<String, String>>> getConfigTypes() {
        return this.configTypes;
    }

    public void setConfigTypes(Map<String, Map<String, Map<String, String>>> configTypes) {
        this.configTypes = configTypes;
    }

    @ApiModelProperty(hidden=true)
    public Collection<File> getServiceKerberosDescriptorFiles() {
        return this.serviceKerberosDescriptorFiles;
    }

    public void setServiceKerberosDescriptorFiles(Collection<File> serviceKerberosDescriptorFiles) {
        this.serviceKerberosDescriptorFiles = serviceKerberosDescriptorFiles;
    }

    public void setUpgradePacks(Set<String> upgradePacks) {
        this.upgradePacks = upgradePacks;
    }

    @ApiModelProperty(name="upgrade_packs")
    public Set<String> getUpgradePacks() {
        return this.upgradePacks;
    }

    public static interface StackVersionResponseSwagger
    extends ApiModel {
        @ApiModelProperty(name="Versions")
        public StackVersionResponse getStackVersionResponse();
    }
}

