/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import id.onyx.obdp.server.controller.ApiModel;
import id.onyx.obdp.server.state.CustomCommandDefinition;
import id.onyx.obdp.server.state.ServiceInfo;
import io.swagger.annotations.ApiModelProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StackServiceResponse {
    private String stackName;
    private String stackVersion;
    private String serviceName;
    private String serviceType;
    private String serviceDisplayName;
    private String userName;
    private String comments;
    private String serviceVersion;
    private ServiceInfo.Selection selection;
    private String maintainer;
    private boolean serviceCheckSupported;
    private List<String> customCommands;
    private Map<String, Map<String, Map<String, String>>> configTypes;
    private Set<String> excludedConfigTypes;
    private List<String> requiredServices;
    private Map<String, String> serviceProperties;
    private File kerberosDescriptorFile;
    private boolean credentialStoreSupported;
    private boolean credentialStoreEnabled;
    private boolean credentialStoreRequired;
    private boolean rollingRestartSupported;
    private boolean isSupportDeleteViaUI;
    private final boolean ssoIntegrationSupported;
    private final boolean ssoIntegrationRequiresKerberos;
    private final boolean ldapIntegrationSupported;

    public StackServiceResponse(ServiceInfo service) {
        this.serviceName = service.getName();
        this.serviceType = service.getServiceType();
        this.serviceDisplayName = service.getDisplayName();
        this.userName = null;
        this.comments = service.getComment();
        this.serviceVersion = service.getVersion();
        this.configTypes = service.getConfigTypeAttributes();
        this.excludedConfigTypes = service.getExcludedConfigTypes();
        this.requiredServices = service.getRequiredServices();
        this.serviceCheckSupported = null != service.getCommandScript();
        this.selection = service.getSelection();
        this.maintainer = service.getMaintainer();
        List<CustomCommandDefinition> definitions = service.getCustomCommands();
        if (null == definitions || definitions.size() == 0) {
            this.customCommands = Collections.emptyList();
        } else {
            this.customCommands = new ArrayList<String>(definitions.size());
            for (CustomCommandDefinition command : definitions) {
                this.customCommands.add(command.getName());
            }
        }
        this.kerberosDescriptorFile = service.getKerberosDescriptorFile();
        this.serviceProperties = service.getServiceProperties();
        this.credentialStoreSupported = service.isCredentialStoreSupported();
        this.credentialStoreEnabled = service.isCredentialStoreEnabled();
        this.isSupportDeleteViaUI = service.isSupportDeleteViaUI();
        this.ssoIntegrationSupported = service.isSingleSignOnSupported();
        this.ssoIntegrationRequiresKerberos = service.isKerberosRequiredForSingleSignOnIntegration();
        this.ldapIntegrationSupported = service.isLdapSupported();
        this.rollingRestartSupported = service.isRollingRestartSupported();
    }

    @ApiModelProperty(name="selection")
    public ServiceInfo.Selection getSelection() {
        return this.selection;
    }

    public void setSelection(ServiceInfo.Selection selection) {
        this.selection = selection;
    }

    @ApiModelProperty(name="maintainer")
    public String getMaintainer() {
        return this.maintainer;
    }

    @ApiModelProperty(name="stack_name")
    public String getStackName() {
        return this.stackName;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    @ApiModelProperty(name="stack_version")
    public String getStackVersion() {
        return this.stackVersion;
    }

    public void setStackVersion(String stackVersion) {
        this.stackVersion = stackVersion;
    }

    @ApiModelProperty(name="service_name")
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @ApiModelProperty(name="service_type")
    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    @ApiModelProperty(name="display_name")
    public String getServiceDisplayName() {
        return this.serviceDisplayName;
    }

    public void setServiceDisplayName(String serviceDisplayName) {
        this.serviceDisplayName = serviceDisplayName;
    }

    @ApiModelProperty(name="user_name")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @ApiModelProperty(name="comments")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @ApiModelProperty(name="service_version")
    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    @ApiModelProperty(name="config_types")
    public Map<String, Map<String, Map<String, String>>> getConfigTypes() {
        return this.configTypes;
    }

    @ApiModelProperty(hidden=true)
    public Set<String> getExcludedConfigTypes() {
        return this.excludedConfigTypes;
    }

    @ApiModelProperty(name="required_services")
    public List<String> getRequiredServices() {
        return this.requiredServices;
    }

    public void setRequiredServices(List<String> requiredServices) {
        this.requiredServices = requiredServices;
    }

    @ApiModelProperty(hidden=true)
    public File getKerberosDescriptorFile() {
        return this.kerberosDescriptorFile;
    }

    public void setKerberosDescriptorFile(File kerberosDescriptorFile) {
        this.kerberosDescriptorFile = kerberosDescriptorFile;
    }

    @ApiModelProperty(name="service_check_supported")
    public boolean isServiceCheckSupported() {
        return this.serviceCheckSupported;
    }

    @ApiModelProperty(name="custom_commands")
    public List<String> getCustomCommands() {
        return this.customCommands;
    }

    @ApiModelProperty(name="properties")
    public Map<String, String> getServiceProperties() {
        return this.serviceProperties;
    }

    @ApiModelProperty(name="credential_store_supported")
    public boolean isCredentialStoreSupported() {
        return this.credentialStoreSupported;
    }

    public void setCredentialStoreSupported(boolean credentialStoreSupported) {
        this.credentialStoreSupported = credentialStoreSupported;
    }

    @ApiModelProperty(name="credential_store_enabled")
    public boolean isCredentialStoreEnabled() {
        return this.credentialStoreEnabled;
    }

    public void setCredentialStoreEnabled(boolean credentialStoreEnabled) {
        this.credentialStoreEnabled = credentialStoreEnabled;
    }

    @ApiModelProperty(name="credential_store_required")
    public boolean isCredentialStoreRequired() {
        return this.credentialStoreRequired;
    }

    public void setCredentialStoreRequired(boolean credentialStoreRequired) {
        this.credentialStoreRequired = credentialStoreRequired;
    }

    @ApiModelProperty(hidden=true)
    public boolean isSupportDeleteViaUI() {
        return this.isSupportDeleteViaUI;
    }

    @ApiModelProperty(name="sso_integration_supported")
    public boolean isSsoIntegrationSupported() {
        return this.ssoIntegrationSupported;
    }

    @ApiModelProperty(name="sso_integration_requires_kerberos")
    public boolean isSsoIntegrationRequiresKerberos() {
        return this.ssoIntegrationRequiresKerberos;
    }

    @ApiModelProperty(name="ldap_integration_supported")
    public boolean isLdapIntegrationSupported() {
        return this.ldapIntegrationSupported;
    }

    @ApiModelProperty(name="rolling_restart_supported")
    public boolean isRollingRestartSupported() {
        return this.rollingRestartSupported;
    }

    public void setRollingRestartSupported(boolean rollingRestartSupported) {
        this.rollingRestartSupported = rollingRestartSupported;
    }

    public static interface StackServiceResponseSwagger
    extends ApiModel {
        @ApiModelProperty(name="StackServices")
        public StackServiceResponse getStackServiceResponse();
    }
}

