/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import id.onyx.obdp.server.controller.ApiModel;
import id.onyx.obdp.server.state.AutoDeployInfo;
import id.onyx.obdp.server.state.BulkCommandDefinition;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.CustomCommandDefinition;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StackServiceComponentResponse {
    private String stackName;
    private String stackVersion;
    private String serviceName;
    private String componentName;
    private String componentDisplayName;
    private String componentCategory;
    private boolean isClient;
    private boolean isMaster;
    private String cardinality;
    private boolean versionAdvertised;
    private String decommissionAllowed;
    private boolean rollingRestartSupported;
    private AutoDeployInfo autoDeploy;
    private List<String> customCommands;
    private List<String> visibleCustomCommands;
    private boolean recoveryEnabled;
    private String bulkCommandsDisplayName;
    private String bulkCommandMasterComponentName;
    private boolean hasBulkCommands;
    private String reassignAllowed;
    private String componentType;

    public StackServiceComponentResponse(ComponentInfo component) {
        this.componentName = component.getName();
        this.componentDisplayName = component.getDisplayName();
        this.componentCategory = component.getCategory();
        this.isClient = component.isClient();
        this.isMaster = component.isMaster();
        this.cardinality = component.getCardinality();
        this.versionAdvertised = component.isVersionAdvertised();
        this.decommissionAllowed = component.getDecommissionAllowed();
        this.autoDeploy = component.getAutoDeploy();
        this.recoveryEnabled = component.isRecoveryEnabled();
        this.hasBulkCommands = this.componentHasBulkCommands(component);
        this.bulkCommandsDisplayName = this.getBulkCommandsDisplayName(component);
        this.bulkCommandMasterComponentName = this.getBulkCommandsMasterComponentName(component);
        this.reassignAllowed = component.getReassignAllowed();
        this.rollingRestartSupported = component.getRollingRestartSupported();
        this.componentType = component.getComponentType();
        List<CustomCommandDefinition> definitions = component.getCustomCommands();
        if (null == definitions || definitions.size() == 0) {
            this.customCommands = Collections.emptyList();
            this.visibleCustomCommands = Collections.emptyList();
        } else {
            this.customCommands = new ArrayList<String>(definitions.size());
            this.visibleCustomCommands = new ArrayList<String>();
            for (CustomCommandDefinition command : definitions) {
                this.customCommands.add(command.getName());
                if (command.isHidden()) continue;
                this.visibleCustomCommands.add(command.getName());
            }
        }
    }

    private String getBulkCommandsMasterComponentName(ComponentInfo component) {
        BulkCommandDefinition o = component.getBulkCommandDefinition();
        if (o == null) {
            return "";
        }
        return o.getMasterComponent();
    }

    private String getBulkCommandsDisplayName(ComponentInfo component) {
        BulkCommandDefinition o = component.getBulkCommandDefinition();
        if (o == null) {
            return "";
        }
        return o.getDisplayName();
    }

    private boolean componentHasBulkCommands(ComponentInfo component) {
        BulkCommandDefinition o = component.getBulkCommandDefinition();
        if (o == null) {
            return false;
        }
        return o.getDisplayName() != null && !o.getDisplayName().trim().isEmpty();
    }

    @ApiModelProperty(name="stack_name")
    public String getStackName() {
        return this.stackName;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    @ApiModelProperty(name="stack_version")
    public String getStackVersion() {
        return this.stackVersion;
    }

    public void setStackVersion(String stackVersion) {
        this.stackVersion = stackVersion;
    }

    @ApiModelProperty(name="service_name")
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @ApiModelProperty(name="component_name")
    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    @ApiModelProperty(name="display_name")
    public String getComponentDisplayName() {
        return this.componentDisplayName;
    }

    public void setComponentDisplayName(String componentDisplayName) {
        this.componentDisplayName = componentDisplayName;
    }

    @ApiModelProperty(name="component_category")
    public String getComponentCategory() {
        return this.componentCategory;
    }

    public void setComponentCategory(String componentCategory) {
        this.componentCategory = componentCategory;
    }

    @ApiModelProperty(name="is_client")
    public boolean isClient() {
        return this.isClient;
    }

    public void setClient(boolean isClient) {
        this.isClient = isClient;
    }

    @ApiModelProperty(name="is_master")
    public boolean isMaster() {
        return this.isMaster;
    }

    public void setMaster(boolean isMaster) {
        this.isMaster = isMaster;
    }

    @ApiModelProperty(name="cardinality")
    public String getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(String cardinality) {
        this.cardinality = cardinality;
    }

    @ApiModelProperty(name="advertise_version")
    public boolean isVersionAdvertised() {
        return this.versionAdvertised;
    }

    public void setVersionAdvertised(boolean versionAdvertised) {
        this.versionAdvertised = versionAdvertised;
    }

    @ApiModelProperty(name="decommission_allowed")
    public boolean isDecommissionAlllowed() {
        return this.decommissionAllowed != null && this.decommissionAllowed.equals("true");
    }

    public void setDecommissionAllowed(String decommissionAllowed) {
        this.decommissionAllowed = decommissionAllowed;
    }

    @ApiModelProperty(name="rollingRestartSupported")
    public boolean isRollingRestartSupported() {
        return this.rollingRestartSupported;
    }

    @ApiModelProperty(name="reassign_allowed")
    public boolean isReassignAlllowed() {
        return this.reassignAllowed != null && this.reassignAllowed.equals("true");
    }

    public void setReassignAllowed(String reassignAllowed) {
        this.reassignAllowed = reassignAllowed;
    }

    @ApiModelProperty(name="recovery_enabled")
    public boolean isRecoveryEnabled() {
        return this.recoveryEnabled;
    }

    public void setRecoveryEnabled(boolean recoveryEnabled) {
        this.recoveryEnabled = recoveryEnabled;
    }

    @ApiModelProperty(hidden=true)
    public AutoDeployInfo getAutoDeploy() {
        return this.autoDeploy;
    }

    public void setAutoDeploy(AutoDeployInfo autoDeploy) {
        this.autoDeploy = autoDeploy;
    }

    public List<String> getCustomCommands() {
        return this.customCommands;
    }

    @ApiModelProperty(name="custom_commands")
    public List<String> getVisibleCustomCommands() {
        return this.visibleCustomCommands;
    }

    @ApiModelProperty(name="has_bulk_commands_definition")
    public boolean hasBulkCommands() {
        return this.hasBulkCommands;
    }

    public String getBulkCommandsDisplayName() {
        return this.bulkCommandsDisplayName == null ? "" : this.bulkCommandsDisplayName;
    }

    @ApiModelProperty(name="bulk_commands_master_component_namen")
    public String getBulkCommandsMasterComponentName() {
        return this.bulkCommandMasterComponentName == null ? "" : this.bulkCommandMasterComponentName;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public static interface StackServiceComponentResponseSwagger
    extends ApiModel {
        @ApiModelProperty(name="StackServiceComponents")
        public StackServiceComponentResponse getStackServiceComponentResponse();
    }
}

