/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.utils.StageUtils;
import org.apache.commons.lang.StringUtils;

public class ShortTaskStatus {
    protected long requestId;
    protected long taskId;
    protected long stageId;
    protected String hostName;
    protected String role;
    protected String command;
    protected String status;
    protected String customCommandName;
    protected String outputLog;
    protected String errorLog;

    public ShortTaskStatus() {
    }

    public ShortTaskStatus(int taskId, long stageId, String hostName, String role, String command, String status, String customCommandName, String outputLog, String errorLog) {
        this.taskId = taskId;
        this.stageId = stageId;
        this.hostName = this.translateHostName(hostName);
        this.role = role;
        this.command = command;
        this.status = status;
        this.customCommandName = customCommandName;
        this.outputLog = outputLog;
        this.errorLog = errorLog;
    }

    public ShortTaskStatus(HostRoleCommand hostRoleCommand) {
        this.taskId = hostRoleCommand.getTaskId();
        this.stageId = hostRoleCommand.getStageId();
        this.command = hostRoleCommand.getRoleCommand().toString();
        this.hostName = this.translateHostName(hostRoleCommand.getHostName());
        this.role = hostRoleCommand.getRole().toString();
        this.status = hostRoleCommand.getStatus().toString();
        this.customCommandName = hostRoleCommand.getCustomCommandName();
        this.outputLog = hostRoleCommand.getOutputLog();
        this.errorLog = hostRoleCommand.getErrorLog();
    }

    public void setRequestId(long requestId) {
        this.requestId = requestId;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public String getCustomCommandName() {
        return this.customCommandName;
    }

    public void setCustomCommandName(String customCommandName) {
        this.customCommandName = customCommandName;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public long getStageId() {
        return this.stageId;
    }

    public void setStageId(long stageId) {
        this.stageId = stageId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = this.translateHostName(hostName);
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getOutputLog() {
        return this.outputLog;
    }

    public void setOutputLog(String outputLog) {
        this.outputLog = outputLog;
    }

    public String getErrorLog() {
        return this.errorLog;
    }

    public void setErrorLog(String errorLog) {
        this.errorLog = errorLog;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ShortTaskStatusDump ").append(", stageId=").append(this.stageId).append(", taskId=").append(this.taskId).append(", hostname=").append(this.hostName).append(", role=").append(this.role).append(", command=").append(this.command).append(", status=").append(this.status).append(", outputLog=").append(this.outputLog).append(", errorLog=").append(this.errorLog);
        return sb.toString();
    }

    private String translateHostName(String hostName) {
        return StringUtils.isEmpty((String)hostName) ? StageUtils.getHostName() : hostName;
    }
}

