/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.configuration.Configuration;
import org.eclipse.jetty.server.session.SessionHandler;

@Singleton
public class SessionHandlerConfigurer {
    @Inject
    Configuration configuration;

    protected void configureSessionHandler(SessionHandler sessionHandler) {
        sessionHandler.getSessionCookieConfig().setPath("/");
        sessionHandler.setSessionCookie("OBDPSESSIONID");
        sessionHandler.getSessionCookieConfig().setHttpOnly(true);
        if (this.configuration.getApiSSLAuthentication()) {
            sessionHandler.getSessionCookieConfig().setSecure(true);
        }
        this.configureMaxInactiveInterval(sessionHandler);
    }

    protected void configureMaxInactiveInterval(SessionHandler sessionHandler) {
        int sessionInactivityTimeout = this.configuration.getHttpSessionInactiveTimeout();
        sessionHandler.setMaxInactiveInterval(sessionInactivityTimeout);
    }
}

