/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.inject.Inject;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.ConfigurationResponse;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.ServiceConfigEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.state.StackId;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@StaticallyInject
public class ServiceConfigVersionResponse {
    public static final String DEFAULT_CONFIG_GROUP_NAME = "Default";
    public static final String DELETED_CONFIG_GROUP_NAME = "Deleted";
    @JsonProperty(value="cluster_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String clusterName;
    @JsonProperty(value="service_name")
    private final String serviceName;
    @JsonProperty(value="service_config_version")
    private final Long version;
    @JsonProperty(value="createtime")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Long createTime;
    @JsonProperty(value="group_id")
    private final Long groupId;
    @JsonProperty(value="group_name")
    private final String groupName;
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String userName;
    @JsonProperty(value="service_config_version_note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String note;
    @JsonProperty(value="stack_id")
    private String stackId;
    @JsonProperty(value="is_current")
    private Boolean isCurrent = Boolean.FALSE;
    @JsonProperty(value="is_cluster_compatible")
    private final Boolean isCompatibleWithCurrentStack;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<ConfigurationResponse> configurations;
    @JsonProperty(value="hosts")
    private final List<String> hosts;
    @Inject
    private static HostDAO hostDAO;

    public ServiceConfigVersionResponse(ServiceConfigEntity serviceConfigEntity, String configGroupName) {
        ClusterEntity clusterEntity = serviceConfigEntity.getClusterEntity();
        this.clusterName = clusterEntity.getClusterName();
        this.serviceName = serviceConfigEntity.getServiceName();
        this.version = serviceConfigEntity.getVersion();
        this.userName = serviceConfigEntity.getUser();
        this.createTime = serviceConfigEntity.getCreateTimestamp();
        this.note = serviceConfigEntity.getNote();
        this.groupId = null != serviceConfigEntity.getGroupId() ? serviceConfigEntity.getGroupId() : -1L;
        this.groupName = configGroupName;
        this.hosts = hostDAO.getHostNamesByHostIds(serviceConfigEntity.getHostIds());
        StackEntity serviceConfigStackEntity = serviceConfigEntity.getStack();
        StackEntity clusterStackEntity = clusterEntity.getClusterStateEntity().getCurrentStack();
        this.isCompatibleWithCurrentStack = clusterStackEntity.equals(serviceConfigStackEntity);
        this.stackId = new StackId(serviceConfigStackEntity).getStackId();
    }

    @ApiModelProperty(name="service_name")
    public String getServiceName() {
        return this.serviceName;
    }

    @ApiModelProperty(name="service_config_version")
    public Long getVersion() {
        return this.version;
    }

    @ApiModelProperty(name="createtime")
    public Long getCreateTime() {
        return this.createTime;
    }

    @ApiModelProperty(name="user")
    public String getUserName() {
        return this.userName;
    }

    @ApiModelProperty(name="cluster_name")
    public String getClusterName() {
        return this.clusterName;
    }

    @ApiModelProperty(name="configurations")
    public List<ConfigurationResponse> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<ConfigurationResponse> configurations) {
        this.configurations = configurations;
    }

    @ApiModelProperty(name="service_config_version_note")
    public String getNote() {
        return this.note;
    }

    @ApiModelProperty(name="hosts")
    public List<String> getHosts() {
        return this.hosts;
    }

    @ApiModelProperty(name="group_name")
    public String getGroupName() {
        return this.groupName;
    }

    @ApiModelProperty(name="group_id")
    public Long getGroupId() {
        return this.groupId;
    }

    @ApiModelProperty(name="stack_id")
    public String getStackId() {
        return this.stackId;
    }

    @ApiModelProperty(name="is_current")
    public Boolean getIsCurrent() {
        return this.isCurrent;
    }

    public void setIsCurrent(Boolean isCurrent) {
        this.isCurrent = isCurrent;
    }

    @ApiModelProperty(name="is_cluster_compatible")
    public Boolean isCompatibleWithCurrentStack() {
        return this.isCompatibleWithCurrentStack;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceConfigVersionResponse)) {
            return false;
        }
        ServiceConfigVersionResponse that = (ServiceConfigVersionResponse)o;
        return new EqualsBuilder().append((Object)this.clusterName, (Object)that.clusterName).append((Object)this.serviceName, (Object)that.serviceName).append((Object)this.version, (Object)that.version).append((Object)this.createTime, (Object)that.createTime).append((Object)this.groupId, (Object)that.groupId).append((Object)this.groupName, (Object)that.groupName).append((Object)this.userName, (Object)that.userName).append((Object)this.note, (Object)that.note).append((Object)this.stackId, (Object)that.stackId).append((Object)this.isCurrent, (Object)that.isCurrent).append((Object)this.isCompatibleWithCurrentStack, (Object)that.isCompatibleWithCurrentStack).append(this.configurations, that.configurations).append(this.hosts, that.hosts).isEquals();
    }

    public final int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.clusterName).append((Object)this.serviceName).append((Object)this.version).append((Object)this.createTime).append((Object)this.groupId).append((Object)this.groupName).append((Object)this.userName).append((Object)this.note).append((Object)this.stackId).append((Object)this.isCurrent).append((Object)this.isCompatibleWithCurrentStack).append(this.configurations).append(this.hosts).toHashCode();
    }
}

