/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ObjectNotFoundException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.AbstractRootServiceResponseFactory;
import id.onyx.obdp.server.controller.HostResponse;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.RootComponent;
import id.onyx.obdp.server.controller.RootService;
import id.onyx.obdp.server.controller.RootServiceComponentRequest;
import id.onyx.obdp.server.controller.RootServiceComponentResponse;
import id.onyx.obdp.server.controller.RootServiceHostComponentRequest;
import id.onyx.obdp.server.controller.RootServiceHostComponentResponse;
import id.onyx.obdp.server.controller.RootServiceRequest;
import id.onyx.obdp.server.controller.RootServiceResponse;
import id.onyx.obdp.server.utils.StageUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang.ArrayUtils;

public class RootServiceResponseFactory
extends AbstractRootServiceResponseFactory {
    private static final String RUNNING_STATE = "RUNNING";
    public static final String NOT_APPLICABLE = "NOT_APPLICABLE";
    @Inject
    private Configuration configs;
    @Inject
    private OBDPMetaInfo obdpMetaInfo;
    @Inject
    private OBDPManagementController managementController;

    @Override
    public Set<RootServiceResponse> getRootServices(RootServiceRequest request) throws ObjectNotFoundException {
        HashSet<RootServiceResponse> response;
        String serviceName = null;
        if (request != null) {
            serviceName = request.getServiceName();
        }
        if (serviceName != null) {
            RootService service;
            try {
                service = RootService.valueOf(serviceName);
            }
            catch (IllegalArgumentException ex) {
                throw new ObjectNotFoundException("Root service name: " + serviceName);
            }
            response = Collections.singleton(new RootServiceResponse(service.toString()));
        } else {
            response = new HashSet();
            for (RootService service : RootService.values()) {
                response.add(new RootServiceResponse(service.toString()));
            }
        }
        return response;
    }

    @Override
    public Set<RootServiceComponentResponse> getRootServiceComponents(RootServiceComponentRequest request) throws ObjectNotFoundException {
        RootService service;
        Set<RootServiceComponentResponse> response = new HashSet<RootServiceComponentResponse>();
        String serviceName = request.getServiceName();
        String componentName = request.getComponentName();
        try {
            service = RootService.valueOf(serviceName);
        }
        catch (IllegalArgumentException ex) {
            throw new ObjectNotFoundException("Root service name: " + serviceName);
        }
        catch (NullPointerException np) {
            throw new ObjectNotFoundException("Root service name: null");
        }
        if (componentName != null) {
            RootComponent component;
            try {
                component = RootComponent.valueOf(componentName);
                if (!ArrayUtils.contains((Object[])service.getComponents(), (Object)((Object)component))) {
                    throw new ObjectNotFoundException("No component name: " + componentName + "in service: " + serviceName);
                }
            }
            catch (IllegalArgumentException ex) {
                throw new ObjectNotFoundException("Component name: " + componentName);
            }
            response = Collections.singleton(new RootServiceComponentResponse(serviceName, component.toString(), this.getComponentVersion(componentName, null), this.getComponentProperties(componentName)));
        } else {
            for (RootComponent component : service.getComponents()) {
                response.add(new RootServiceComponentResponse(serviceName, component.toString(), this.getComponentVersion(component.name(), null), this.getComponentProperties(component.name())));
            }
        }
        return response;
    }

    private String getComponentVersion(String componentName, HostResponse host) {
        RootComponent component = RootComponent.valueOf(componentName);
        return switch (component) {
            case RootComponent.OBDP_SERVER -> this.obdpMetaInfo.getServerVersion();
            case RootComponent.AMBARI_AGENT -> {
                if (host == null) {
                    yield NOT_APPLICABLE;
                }
                yield host.getAgentVersion().getVersion();
            }
            default -> null;
        };
    }

    private Map<String, String> getComponentProperties(String componentName) {
        Map<String, String> response;
        block5: {
            block4: {
                RootComponent component = null;
                if (componentName == null) break block4;
                component = RootComponent.valueOf(componentName);
                switch (component) {
                    case OBDP_SERVER: {
                        response = this.configs.getAmbariProperties();
                        response.put("jdk_location", this.managementController.getJdkResourceUrl());
                        response.put("java.version", System.getProperty("java.specification.version"));
                        Set<String> propertiesToHideInResponse = this.configs.getPropertiesToBlackList();
                        for (String key : propertiesToHideInResponse) {
                            response.remove(key);
                        }
                        break block5;
                    }
                    default: {
                        response = Collections.emptyMap();
                        break;
                    }
                }
                break block5;
            }
            response = Collections.emptyMap();
        }
        return response;
    }

    @Override
    public Set<RootServiceHostComponentResponse> getRootServiceHostComponent(RootServiceHostComponentRequest request, Set<HostResponse> hosts) throws OBDPException {
        HashSet<RootServiceHostComponentResponse> response = new HashSet<RootServiceHostComponentResponse>();
        String serviceName = request.getServiceName();
        Set<RootServiceComponentResponse> rootServiceComponents = this.getRootServiceComponents(new RootServiceComponentRequest(serviceName, request.getComponentName()));
        for (RootServiceComponentResponse component : rootServiceComponents) {
            HashSet<HostResponse> filteredHosts = new HashSet<HostResponse>(hosts);
            if (component.getComponentName().equals(RootComponent.OBDP_SERVER.name())) {
                CollectionUtils.filter(filteredHosts, (Predicate)new Predicate(){

                    public boolean evaluate(Object arg0) {
                        HostResponse hostResponse = (HostResponse)arg0;
                        return hostResponse.getHostname().equals(StageUtils.getHostName());
                    }
                });
            }
            for (HostResponse host : filteredHosts) {
                String state = component.getComponentName().equals(RootComponent.OBDP_SERVER.name()) ? RUNNING_STATE : host.getHostState().toString();
                String componentVersion = this.getComponentVersion(component.getComponentName(), host);
                response.add(new RootServiceHostComponentResponse(serviceName, host.getHostname(), component.getComponentName(), state, componentVersion, component.getProperties()));
            }
        }
        return response;
    }
}

