/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import org.eclipse.jetty.server.session.SessionHandler;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class OBDPSessionManager {
    @Inject
    SessionHandler sessionHandler;

    public String getCurrentSessionId() {
        HttpSession session = this.getHttpSession();
        return session == null ? null : session.getId();
    }

    public String getSessionCookie() {
        return this.sessionHandler.getSessionCookieConfig().getName();
    }

    public void setAttribute(String name, Object value) {
        HttpSession session = this.getHttpSession();
        if (session != null) {
            session.setAttribute(name, value);
        }
    }

    public Object getAttribute(String name) {
        HttpSession session = this.getHttpSession();
        if (session != null) {
            return session.getAttribute(name);
        }
        return null;
    }

    public void removeAttribute(String name) {
        HttpSession session = this.getHttpSession();
        if (session != null) {
            session.removeAttribute(name);
        }
    }

    protected HttpSession getHttpSession() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null && requestAttributes instanceof ServletRequestAttributes) {
            HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
            return request == null ? null : request.getSession(true);
        }
        return null;
    }
}

