/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import com.google.common.base.Joiner;
import com.google.common.util.concurrent.ServiceManager;
import com.google.gson.Gson;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StateRecoveryManager;
import id.onyx.obdp.server.actionmanager.ActionManager;
import id.onyx.obdp.server.actionmanager.HostRoleCommandFactory;
import id.onyx.obdp.server.agent.HeartBeatHandler;
import id.onyx.obdp.server.api.ContentTypeOverrideFilter;
import id.onyx.obdp.server.api.MethodOverrideFilter;
import id.onyx.obdp.server.api.OBDPErrorHandler;
import id.onyx.obdp.server.api.OBDPPersistFilter;
import id.onyx.obdp.server.api.UserNameOverrideFilter;
import id.onyx.obdp.server.api.rest.BootStrapResource;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.KeyService;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.api.services.PersistKeyValueImpl;
import id.onyx.obdp.server.api.services.PersistKeyValueService;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorBlueprintProcessor;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorHelper;
import id.onyx.obdp.server.audit.AuditLoggerModule;
import id.onyx.obdp.server.audit.request.RequestAuditLogger;
import id.onyx.obdp.server.bootstrap.BootStrapImpl;
import id.onyx.obdp.server.checks.DatabaseConsistencyCheckHelper;
import id.onyx.obdp.server.checks.DatabaseConsistencyCheckResult;
import id.onyx.obdp.server.configuration.ComponentSSLConfiguration;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.configuration.SingleFileWatch;
import id.onyx.obdp.server.configuration.spring.AgentStompConfig;
import id.onyx.obdp.server.configuration.spring.ApiSecurityConfig;
import id.onyx.obdp.server.configuration.spring.ApiStompConfig;
import id.onyx.obdp.server.controller.ControllerModule;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.controller.OBDPHandlerList;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.ResourceProviderFactory;
import id.onyx.obdp.server.controller.SessionHandlerConfigurer;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.BaseClusterRequest;
import id.onyx.obdp.server.controller.internal.BlueprintResourceProvider;
import id.onyx.obdp.server.controller.internal.ClusterPrivilegeResourceProvider;
import id.onyx.obdp.server.controller.internal.ClusterResourceProvider;
import id.onyx.obdp.server.controller.internal.HostResourceProvider;
import id.onyx.obdp.server.controller.internal.OBDPPrivilegeResourceProvider;
import id.onyx.obdp.server.controller.internal.PermissionResourceProvider;
import id.onyx.obdp.server.controller.internal.PrivilegeResourceProvider;
import id.onyx.obdp.server.controller.internal.StackAdvisorResourceProvider;
import id.onyx.obdp.server.controller.internal.StackDefinedPropertyProvider;
import id.onyx.obdp.server.controller.internal.StackDependencyResourceProvider;
import id.onyx.obdp.server.controller.internal.UserPrivilegeResourceProvider;
import id.onyx.obdp.server.controller.internal.ViewPermissionResourceProvider;
import id.onyx.obdp.server.controller.metrics.ThreadPoolEnabledPropertyProvider;
import id.onyx.obdp.server.controller.utilities.KerberosChecker;
import id.onyx.obdp.server.controller.utilities.KerberosIdentityCleaner;
import id.onyx.obdp.server.events.AmbariPropertiesChangedEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.ldap.LdapModule;
import id.onyx.obdp.server.listeners.WebSocketInitializerListener;
import id.onyx.obdp.server.metrics.system.MetricsService;
import id.onyx.obdp.server.orm.GuiceJpaInitializer;
import id.onyx.obdp.server.orm.PersistenceType;
import id.onyx.obdp.server.orm.dao.BlueprintDAO;
import id.onyx.obdp.server.orm.dao.ClusterDAO;
import id.onyx.obdp.server.orm.dao.GroupDAO;
import id.onyx.obdp.server.orm.dao.MetainfoDAO;
import id.onyx.obdp.server.orm.dao.PermissionDAO;
import id.onyx.obdp.server.orm.dao.PrincipalDAO;
import id.onyx.obdp.server.orm.dao.PrivilegeDAO;
import id.onyx.obdp.server.orm.dao.ResourceDAO;
import id.onyx.obdp.server.orm.dao.TopologyRequestDAO;
import id.onyx.obdp.server.orm.dao.UserDAO;
import id.onyx.obdp.server.orm.dao.ViewInstanceDAO;
import id.onyx.obdp.server.orm.entities.MetainfoEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.resources.ResourceManager;
import id.onyx.obdp.server.resources.api.rest.GetResource;
import id.onyx.obdp.server.scheduler.ExecutionScheduleManager;
import id.onyx.obdp.server.security.AmbariServerSecurityHeaderFilter;
import id.onyx.obdp.server.security.AmbariViewsSecurityHeaderFilter;
import id.onyx.obdp.server.security.CertificateManager;
import id.onyx.obdp.server.security.SecurityFilter;
import id.onyx.obdp.server.security.authorization.Users;
import id.onyx.obdp.server.security.unsecured.rest.CertificateDownload;
import id.onyx.obdp.server.security.unsecured.rest.CertificateSign;
import id.onyx.obdp.server.security.unsecured.rest.ConnectionInfo;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.KerberosKeytabController;
import id.onyx.obdp.server.stack.UpdateActiveRepoVersionOnStartup;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.topology.AmbariContext;
import id.onyx.obdp.server.topology.BlueprintFactory;
import id.onyx.obdp.server.topology.SecurityConfigurationFactory;
import id.onyx.obdp.server.topology.TopologyManager;
import id.onyx.obdp.server.topology.TopologyRequestFactory;
import id.onyx.obdp.server.topology.TopologyRequestFactoryImpl;
import id.onyx.obdp.server.utils.AmbariPath;
import id.onyx.obdp.server.utils.RetryHelper;
import id.onyx.obdp.server.utils.StageUtils;
import id.onyx.obdp.server.utils.VersionUtils;
import id.onyx.obdp.server.view.AmbariViewsMDCLoggingFilter;
import id.onyx.obdp.server.view.ViewDirectoryWatcher;
import id.onyx.obdp.server.view.ViewRegistry;
import id.onyx.obdp.server.view.ViewThrottleFilter;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.BindException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.logging.LogManager;
import javax.crypto.BadPaddingException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpVersion;
import org.apache.log4j.PropertyConfigurator;
import org.apache.velocity.app.Velocity;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;
import org.springframework.web.servlet.DispatcherServlet;

@Singleton
public class OBDPServer {
    public static final String VIEWS_URL_PATTERN = "/api/v1/views/*";
    private static final Logger LOG = LoggerFactory.getLogger(OBDPServer.class);
    private static final String AGENT_THREAD_POOL_NAME = "qtp-obdp-agent";
    private static final String CLIENT_THREAD_POOL_NAME = "obdp-client-thread";
    protected static final String VELOCITY_LOG_CATEGORY = "VelocityLogger";
    public static final EnumSet<DispatcherType> DISPATCHER_TYPES = EnumSet.of(DispatcherType.REQUEST);
    private static final int DEFAULT_ACCEPTORS_COUNT = 1;
    private static final String[] DEPRECATED_SSL_PROTOCOLS = new String[]{"TLSv1"};
    private static final String CLASSPATH_CHECK_CLASS = "org/apache/ambari/server/controller/OBDPServer.class";
    private static final String CLASSPATH_SANITY_CHECK_FAILURE_MESSAGE;
    private Server server = null;
    public volatile boolean running = true;
    final String CONTEXT_PATH = "/";
    final String DISABLED_ENTRIES_SPLITTER = "\\|";
    @Inject
    Configuration configs;
    @Inject
    CertificateManager certMan;
    @Inject
    Injector injector;
    @Inject
    OBDPMetaInfo obdpMetaInfo;
    @Inject
    MetainfoDAO metainfoDAO;
    @Inject
    @Named(value="dbInitNeeded")
    boolean dbInitNeeded;
    @Inject
    private ServiceManager serviceManager;
    @Inject
    ViewRegistry viewRegistry;
    @Inject
    OBDPHandlerList handlerList;
    @Inject
    SessionHandler sessionHandler;
    @Inject
    DelegatingFilterProxy springSecurityFilter;
    @Inject
    ViewDirectoryWatcher viewDirectoryWatcher;
    @Inject
    SessionHandlerConfigurer sessionHandlerConfigurer;
    private static OBDPManagementController clusterController;

    public String getServerOsType() {
        return this.configs.getServerOsType();
    }

    static void setSystemProperties(Configuration configs) {
        System.setProperty("java.io.tmpdir", configs.getServerTempDir());
        if (configs.getJavaVersion() >= 8) {
            System.setProperty("jdk.tls.ephemeralDHKeySize", String.valueOf(configs.getTlsEphemeralDhKeySize()));
        }
    }

    public static OBDPManagementController getController() {
        return clusterController;
    }

    public static void setController(OBDPManagementController controller) {
        clusterController = controller;
    }

    public void run() throws Exception {
        this.setupJulLogging();
        this.performStaticInjection();
        this.initDB();
        Integer clientAcceptors = this.configs.getClientApiAcceptors() != null ? this.configs.getClientApiAcceptors() : 1;
        this.server = this.configureJettyThreadPool(clientAcceptors, CLIENT_THREAD_POOL_NAME, this.configs.getClientThreadPoolSize());
        DefaultSessionIdManager sessionIdManager = new DefaultSessionIdManager(this.server);
        this.sessionHandler.setSessionIdManager((SessionIdManager)sessionIdManager);
        this.server.setSessionIdManager((SessionIdManager)sessionIdManager);
        Integer agentAcceptors = this.configs.getAgentApiAcceptors() != null ? this.configs.getAgentApiAcceptors() : 1;
        Server serverForAgent = this.configureJettyThreadPool(agentAcceptors * 2, AGENT_THREAD_POOL_NAME, this.configs.getAgentThreadPoolSize());
        OBDPServer.setSystemProperties(this.configs);
        this.runDatabaseConsistencyCheck();
        try {
            ClassPathXmlApplicationContext parentSpringAppContext = new ClassPathXmlApplicationContext();
            parentSpringAppContext.refresh();
            ConfigurableListableBeanFactory factory = parentSpringAppContext.getBeanFactory();
            factory.registerSingleton("injector", (Object)this.injector);
            factory.registerSingleton("ambariUsers", this.injector.getInstance(Users.class));
            AnnotationConfigWebApplicationContext apiContext = new AnnotationConfigWebApplicationContext();
            apiContext.setParent((ApplicationContext)parentSpringAppContext);
            apiContext.register(new Class[]{ApiSecurityConfig.class});
            AnnotationConfigWebApplicationContext apiDispatcherContext = new AnnotationConfigWebApplicationContext();
            apiDispatcherContext.register(new Class[]{ApiStompConfig.class});
            DispatcherServlet apiDispatcherServlet = new DispatcherServlet((WebApplicationContext)apiDispatcherContext);
            AnnotationConfigWebApplicationContext agentDispatcherContext = new AnnotationConfigWebApplicationContext();
            agentDispatcherContext.register(new Class[]{AgentStompConfig.class});
            DispatcherServlet agentDispatcherServlet = new DispatcherServlet((WebApplicationContext)agentDispatcherContext);
            ServletContextHandler root = new ServletContextHandler(3);
            this.configureRootHandler(root);
            this.sessionHandlerConfigurer.configureSessionHandler(this.sessionHandler);
            root.setSessionHandler(this.sessionHandler);
            root.addEventListener((EventListener)new ContextLoaderListener((WebApplicationContext)apiContext));
            this.certMan.initRootCert();
            ServletContextHandler agentroot = new ServletContextHandler((HandlerContainer)serverForAgent, "/", 0);
            AnnotationConfigWebApplicationContext agentApiContext = new AnnotationConfigWebApplicationContext();
            agentApiContext.setParent((ApplicationContext)parentSpringAppContext);
            if (this.configs.isAgentApiGzipped()) {
                this.configureHandlerCompression(agentroot);
            }
            JettyWebSocketServletContainerInitializer initializerForAgentroot = new JettyWebSocketServletContainerInitializer((context, jettyContainer) -> {
                jettyContainer.setMaxTextMessageSize((long)this.configs.getStompMaxIncomingMessageSize());
                LOG.info("Configured WebSocket container max text message size: {}", (Object)this.configs.getStompMaxIncomingMessageSize());
            });
            agentroot.addEventListener((EventListener)new ContextLoaderListener((WebApplicationContext)agentApiContext));
            agentroot.addEventListener((EventListener)((Object)new WebSocketInitializerListener(initializerForAgentroot)));
            ServletHolder rootServlet = root.addServlet(DefaultServlet.class, "/");
            rootServlet.setInitParameter("dirAllowed", "false");
            rootServlet.setInitParameter("precompressed", "gzip=.gz");
            rootServlet.setInitOrder(1);
            rootServlet = agentroot.addServlet(DefaultServlet.class, "/");
            rootServlet.setInitOrder(1);
            root.addFilter(new FilterHolder((Filter)this.injector.getInstance(AmbariServerSecurityHeaderFilter.class)), "/*", DISPATCHER_TYPES);
            root.addFilter(new FilterHolder((Filter)this.injector.getInstance(AmbariViewsSecurityHeaderFilter.class)), VIEWS_URL_PATTERN, DISPATCHER_TYPES);
            root.addFilter(new FilterHolder((Filter)this.injector.getInstance(ViewThrottleFilter.class)), VIEWS_URL_PATTERN, DISPATCHER_TYPES);
            root.addFilter(new FilterHolder((Filter)this.injector.getInstance(AmbariViewsMDCLoggingFilter.class)), VIEWS_URL_PATTERN, DISPATCHER_TYPES);
            root.addFilter(new FilterHolder((Filter)this.injector.getInstance(OBDPPersistFilter.class)), "/api/*", DISPATCHER_TYPES);
            root.addFilter(new FilterHolder((Filter)new MethodOverrideFilter()), "/api/*", DISPATCHER_TYPES);
            root.addFilter(new FilterHolder((Filter)new ContentTypeOverrideFilter()), "/api/*", DISPATCHER_TYPES);
            JettyWebSocketServletContainerInitializer initializerForRoot = new JettyWebSocketServletContainerInitializer((context, jettyContainer) -> {
                jettyContainer.setMaxTextMessageSize((long)this.configs.getStompMaxIncomingMessageSize());
                LOG.info("Configured WebSocket container max text message size: {}", (Object)this.configs.getStompMaxIncomingMessageSize());
            });
            root.addEventListener((EventListener)new RequestContextListener());
            root.addEventListener((EventListener)((Object)new WebSocketInitializerListener(initializerForRoot)));
            root.addFilter(new FilterHolder((Filter)this.springSecurityFilter), "/api/*", DISPATCHER_TYPES);
            root.addFilter(new FilterHolder((Filter)new UserNameOverrideFilter()), "/api/v1/users/*", DISPATCHER_TYPES);
            agentroot.addFilter(new FilterHolder((Filter)this.injector.getInstance(OBDPPersistFilter.class)), "/agent/*", DISPATCHER_TYPES);
            agentroot.addFilter(SecurityFilter.class, "/*", DISPATCHER_TYPES);
            Map<String, String> configsMap = this.configs.getConfigsMap();
            ServerConnector agentOneWayConnector = this.createSelectChannelConnectorForAgent(serverForAgent, this.configs.getOneWayAuthPort(), false, agentAcceptors);
            ServerConnector agentTwoWayConnector = this.createSelectChannelConnectorForAgent(serverForAgent, this.configs.getTwoWayAuthPort(), this.configs.isTwoWaySsl(), agentAcceptors);
            serverForAgent.addConnector((Connector)agentOneWayConnector);
            serverForAgent.addConnector((Connector)agentTwoWayConnector);
            ServletHolder sh = new ServletHolder((Servlet)new ServletContainer(new ResourceConfig().packages(new String[]{"id.onyx.obdp.server.api.rest", "id.onyx.obdp.server.api.services", "id.onyx.obdp.eventdb.webservice", "id.onyx.obdp.server.api"}).register(JacksonFeature.class)));
            root.addServlet(sh, "/api/v1/*");
            sh.setInitOrder(2);
            ServletHolder springDispatcherServlet = new ServletHolder("springDispatcherServlet", (Servlet)apiDispatcherServlet);
            springDispatcherServlet.setInitOrder(3);
            root.addServlet(springDispatcherServlet, "/api/stomp/*");
            ServletHolder agentSpringDispatcherServlet = new ServletHolder("agentSpringDispatcherServlet", (Servlet)agentDispatcherServlet);
            agentSpringDispatcherServlet.setInitOrder(2);
            agentroot.addServlet(agentSpringDispatcherServlet, "/agent/stomp/*");
            SecurityContextHolder.setStrategyName((String)"MODE_INHERITABLETHREADLOCAL");
            this.viewRegistry.readViewArchives();
            OBDPServer.loadRequestlogHandler(this.handlerList, serverForAgent, configsMap);
            OBDPServer.enableLog4jMonitor(configsMap);
            if (this.configs.isGzipHandlerEnabledForJetty()) {
                GzipHandler gzipHandler = new GzipHandler();
                gzipHandler.setHandler((Handler)root);
                gzipHandler.setIncludedMimeTypes(new String[]{"text/html", "text/plain", "text/xml", "text/css", "application/javascript", "application/x-javascript", "application/xml", "application/x-www-form-urlencoded", "application/json"});
                this.handlerList.addHandler((Handler)gzipHandler);
            } else {
                this.handlerList.addHandler((Handler)root);
            }
            this.server.setHandler((Handler)this.handlerList);
            ServletHolder agent = new ServletHolder((Servlet)new ServletContainer(new ResourceConfig().packages(new String[]{"id.onyx.obdp.server.agent.rest", "id.onyx.obdp.server.api"}).register(JacksonFeature.class)));
            agentroot.addServlet(agent, "/agent/v1/*");
            agent.setInitOrder(3);
            ((HeartBeatHandler)this.injector.getInstance(HeartBeatHandler.class)).start();
            LOG.info("********** Started Heartbeat handler **********");
            ServletHolder cert = new ServletHolder((Servlet)new ServletContainer(new ResourceConfig().packages(new String[]{"id.onyx.obdp.server.security.unsecured.rest", "id.onyx.obdp.server.api"}).register(JacksonFeature.class)));
            agentroot.addServlet(cert, "/*");
            cert.setInitOrder(4);
            File resourcesDirectory = new File(this.configs.getResourceDirPath());
            ServletHolder resources = new ServletHolder(DefaultServlet.class);
            resources.setInitParameter("resourceBase", resourcesDirectory.getParent());
            resources.setInitParameter("dirAllowed", "false");
            root.addServlet(resources, "/resources/*");
            resources.setInitOrder(5);
            if (this.configs.csrfProtectionEnabled()) {
                sh.setInitParameter("org.glassfish.jersey.server.ContainerRequestFilter", "id.onyx.obdp.server.api.AmbariCsrfProtectionFilter");
            }
            ServerConnector apiConnector = this.createSelectChannelConnectorForClient(this.server, clientAcceptors);
            this.server.addConnector((Connector)apiConnector);
            this.server.setStopAtShutdown(true);
            serverForAgent.setStopAtShutdown(true);
            String osType = this.getServerOsType();
            if (osType == null || osType.isEmpty()) {
                throw new RuntimeException(Configuration.OS_VERSION.getKey() + " is not  set in the obdp.properties file");
            }
            LOG.info("********* Initializing Clusters **********");
            Clusters clusters = (Clusters)this.injector.getInstance(Clusters.class);
            StringBuilder clusterDump = new StringBuilder();
            LOG.info("********* Current Clusters State *********");
            LOG.info(clusterDump.toString());
            LOG.info("********* Reconciling Alert Definitions **********");
            this.obdpMetaInfo.reconcileAlertDefinitions(clusters, false);
            LOG.info("********* Initializing ActionManager **********");
            ActionManager manager = (ActionManager)this.injector.getInstance(ActionManager.class);
            LOG.info("********* Initializing Controller **********");
            OBDPManagementController controller = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
            LOG.info("********* Initializing Scheduled Request Manager **********");
            ExecutionScheduleManager executionScheduleManager = (ExecutionScheduleManager)this.injector.getInstance(ExecutionScheduleManager.class);
            MetricsService metricsService = (MetricsService)this.injector.getInstance(MetricsService.class);
            clusterController = controller;
            StateRecoveryManager recoveryManager = (StateRecoveryManager)this.injector.getInstance(StateRecoveryManager.class);
            recoveryManager.doWork();
            this.server.start();
            this.handlerList.shareSessionCacheToViews(this.sessionHandler.getSessionCache());
            this.sessionHandlerConfigurer.configureMaxInactiveInterval(this.sessionHandler);
            serverForAgent.start();
            LOG.info("********* Started Server **********");
            if (!this.configs.isViewDirectoryWatcherServiceDisabled()) {
                LOG.info("Starting View Directory Watcher");
                this.viewDirectoryWatcher.start();
            }
            manager.start();
            LOG.info("********* Started ActionManager **********");
            executionScheduleManager.start();
            LOG.info("********* Started Scheduled Request Manager **********");
            this.serviceManager.startAsync();
            LOG.info("********* Started Services **********");
            if (!this.configs.isMetricsServiceDisabled()) {
                metricsService.start();
            } else {
                LOG.info("OBDPServer Metrics disabled.");
            }
            this.server.join();
            LOG.info("Joined the Server");
        }
        catch (BadPaddingException bpe) {
            LOG.error("Bad keystore or private key password. HTTPS certificate re-importing may be required.");
            throw bpe;
        }
        catch (BindException bindException) {
            LOG.error("Could not bind to server port - instance may already be running. Terminating this instance.", (Throwable)bindException);
            throw bindException;
        }
    }

    private ServerConnector createSelectChannelConnectorForAgent(Server server, int port, boolean needClientAuth, int acceptors) {
        ServerConnector agentConnector;
        Map<String, String> configsMap = this.configs.getConfigsMap();
        if (this.configs.getAgentSSLAuthentication()) {
            ServerConnector agentSslConnector;
            String keystore = configsMap.get(Configuration.SRVR_KSTR_DIR.getKey()) + File.separator + configsMap.get(Configuration.KSTR_NAME.getKey());
            String truststore = configsMap.get(Configuration.SRVR_KSTR_DIR.getKey()) + File.separator + configsMap.get(Configuration.TSTR_NAME.getKey());
            String srvrCrtPass = configsMap.get(Configuration.SRVR_CRT_PASS.getKey());
            SecureRequestCustomizer src = new SecureRequestCustomizer();
            src.setSniHostCheck(false);
            src.setSniRequired(false);
            HttpConfiguration https_config = new HttpConfiguration();
            https_config.addCustomizer((HttpConfiguration.Customizer)src);
            https_config.setRequestHeaderSize(this.configs.getHttpRequestHeaderSize());
            https_config.setResponseHeaderSize(this.configs.getHttpResponseHeaderSize());
            https_config.setSendServerVersion(false);
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            this.disableInsecureProtocols((SslContextFactory)sslContextFactory);
            sslContextFactory.setKeyStorePath(keystore);
            sslContextFactory.setTrustStorePath(truststore);
            sslContextFactory.setKeyStorePassword(srvrCrtPass);
            sslContextFactory.setKeyManagerPassword(srvrCrtPass);
            sslContextFactory.setTrustStorePassword(srvrCrtPass);
            sslContextFactory.setKeyStoreType(configsMap.get(Configuration.KSTR_TYPE.getKey()));
            sslContextFactory.setTrustStoreType(configsMap.get(Configuration.TSTR_TYPE.getKey()));
            sslContextFactory.setNeedClientAuth(needClientAuth);
            sslContextFactory.setSniRequired(false);
            agentConnector = agentSslConnector = new ServerConnector(server, acceptors, -1, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.toString()), new HttpConnectionFactory(https_config)});
        } else {
            agentConnector = new ServerConnector(server, acceptors, -1);
            agentConnector.setIdleTimeout((long)this.configs.getConnectionMaxIdleTime());
        }
        agentConnector.setPort(port);
        return agentConnector;
    }

    private ServerConnector createSelectChannelConnectorForClient(Server server, int acceptors) {
        ServerConnector apiConnector;
        Map<String, String> configsMap = this.configs.getConfigsMap();
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setRequestHeaderSize(this.configs.getHttpRequestHeaderSize());
        http_config.setResponseHeaderSize(this.configs.getHttpResponseHeaderSize());
        http_config.setSendServerVersion(false);
        if (this.configs.getApiSSLAuthentication()) {
            String httpsKeystore = configsMap.get(Configuration.CLIENT_API_SSL_KSTR_DIR_NAME.getKey()) + File.separator + configsMap.get(Configuration.CLIENT_API_SSL_KSTR_NAME.getKey());
            String httpsTruststore = configsMap.get(Configuration.CLIENT_API_SSL_KSTR_DIR_NAME.getKey()) + File.separator + configsMap.get(Configuration.CLIENT_API_SSL_TSTR_NAME.getKey());
            LOG.info("API SSL Authentication is turned on. Keystore - " + httpsKeystore);
            String httpsCrtPass = configsMap.get(Configuration.CLIENT_API_SSL_CRT_PASS.getKey());
            HttpConfiguration https_config = new HttpConfiguration(http_config);
            SecureRequestCustomizer src = new SecureRequestCustomizer();
            src.setSniRequired(false);
            src.setSniHostCheck(false);
            https_config.addCustomizer((HttpConfiguration.Customizer)src);
            https_config.setSecurePort(this.configs.getClientSSLApiPort());
            SslContextFactory.Server contextFactoryApi = new SslContextFactory.Server();
            this.disableInsecureProtocols((SslContextFactory)contextFactoryApi);
            contextFactoryApi.setKeyStorePath(httpsKeystore);
            contextFactoryApi.setTrustStorePath(httpsTruststore);
            contextFactoryApi.setKeyStorePassword(httpsCrtPass);
            contextFactoryApi.setKeyManagerPassword(httpsCrtPass);
            contextFactoryApi.setTrustStorePassword(httpsCrtPass);
            contextFactoryApi.setKeyStoreType(configsMap.get(Configuration.CLIENT_API_SSL_KSTR_TYPE.getKey()));
            contextFactoryApi.setTrustStoreType(configsMap.get(Configuration.CLIENT_API_SSL_KSTR_TYPE.getKey()));
            contextFactoryApi.setSniRequired(false);
            apiConnector = new ServerConnector(server, acceptors, -1, new ConnectionFactory[]{new SslConnectionFactory(contextFactoryApi, HttpVersion.HTTP_1_1.toString()), new HttpConnectionFactory(https_config)});
            apiConnector.setPort(this.configs.getClientSSLApiPort());
        } else {
            apiConnector = new ServerConnector(server, acceptors, -1, new ConnectionFactory[]{new HttpConnectionFactory(http_config)});
            apiConnector.setPort(this.configs.getClientApiPort());
        }
        apiConnector.setIdleTimeout((long)this.configs.getConnectionMaxIdleTime());
        return apiConnector;
    }

    protected void runDatabaseConsistencyCheck() throws Exception {
        if (System.getProperty("skipDatabaseConsistencyCheck") == null) {
            boolean fixIssues = System.getProperty("fixDatabaseConsistency") != null;
            try {
                DatabaseConsistencyCheckResult checkResult = DatabaseConsistencyCheckHelper.runAllDBChecks(fixIssues);
                System.out.println("Database consistency check result: " + checkResult);
                if (checkResult.isError()) {
                    System.exit(1);
                }
            }
            catch (Throwable ex) {
                System.out.println("Database consistency check result: " + DatabaseConsistencyCheckResult.DB_CHECK_ERROR);
                throw new Exception(ex);
            }
        }
    }

    private void setupJulLogging() {
        LogManager.getLogManager().reset();
        SLF4JBridgeHandler.install();
    }

    protected Server configureJettyThreadPool(int acceptorThreads, String threadPoolName, int configuredThreadPoolSize) {
        int reservedJettyThreads = acceptorThreads * 2;
        int minumumAvailableThreads = 20;
        if (configuredThreadPoolSize < reservedJettyThreads + minumumAvailableThreads) {
            int newThreadPoolSize = reservedJettyThreads + minumumAvailableThreads;
            LOG.warn("The configured Jetty {} thread pool value of {} is not sufficient on a host with {} processors. Increasing the value to {}.", new Object[]{threadPoolName, configuredThreadPoolSize, Runtime.getRuntime().availableProcessors(), newThreadPoolSize});
            configuredThreadPoolSize = newThreadPoolSize;
        }
        LOG.info("Jetty is configuring {} with {} reserved acceptors/selectors and a total pool size of {} for {} processors.", new Object[]{threadPoolName, acceptorThreads * 2, configuredThreadPoolSize, Runtime.getRuntime().availableProcessors()});
        QueuedThreadPool qtp = new QueuedThreadPool(configuredThreadPoolSize);
        qtp.setName(threadPoolName);
        return new Server((ThreadPool)qtp);
    }

    private void disableInsecureProtocols(SslContextFactory factory) {
        String[] masks;
        factory.setExcludeProtocols(DEPRECATED_SSL_PROTOCOLS);
        factory.setIncludeProtocols(new String[]{"SSLv2Hello", "SSLv3", "TLSv1.1", "TLSv1.2"});
        if (!this.configs.getSrvrDisabledCiphers().isEmpty()) {
            masks = this.configs.getSrvrDisabledCiphers().split("\\|");
            factory.setExcludeCipherSuites(masks);
        }
        if (!this.configs.getSrvrDisabledProtocols().isEmpty()) {
            masks = this.configs.getSrvrDisabledProtocols().split("\\|");
            factory.setExcludeProtocols(masks);
        }
    }

    protected void configureRootHandler(ServletContextHandler root) {
        this.configureHandlerCompression(root);
        this.configureAdditionalContentTypes(root);
        root.setContextPath("/");
        OBDPErrorHandler ambariErrorHandler = (OBDPErrorHandler)((Object)this.injector.getInstance(OBDPErrorHandler.class));
        ambariErrorHandler.setShowStacks(this.configs.isServerShowErrorStacks());
        root.setErrorHandler((ErrorHandler)ambariErrorHandler);
        root.setMaxFormContentSize(-1);
        root.setResourceBase(this.configs.getWebAppDir());
    }

    protected void configureHandlerCompression(ServletContextHandler context) {
        if (this.configs.isApiGzipped()) {
            GzipHandler gzipHandler = new GzipHandler();
            gzipHandler.setIncludedMethods(new String[]{"GET", "POST", "PUT", "DELETE"});
            gzipHandler.setExcludedPaths(new String[]{"*.woff", "*.ttf", "*.woff2", "*.eot", "*.svg"});
            gzipHandler.setIncludedMimeTypes(new String[]{"text/html", "text/plain", "text/xml", "text/css", "application/x-javascript", "application/xml", "application/x-www-form-urlencoded", "application/javascript", "application/json"});
            gzipHandler.setMinGzipSize(Integer.parseInt(this.configs.getApiGzipMinSize()));
            context.setGzipHandler(gzipHandler);
        }
    }

    private void configureAdditionalContentTypes(ServletContextHandler root) {
        root.getMimeTypes().addMimeMapping("woff", "application/font-woff");
        root.getMimeTypes().addMimeMapping("ttf", "application/font-sfnt");
    }

    @Transactional
    protected void initDB() throws OBDPException {
        if (this.configs.getPersistenceType() == PersistenceType.IN_MEMORY || this.dbInitNeeded) {
            LOG.info("Database init needed - creating default data");
            Users users = (Users)this.injector.getInstance(Users.class);
            UserEntity userEntity = users.createUser("admin", "admin", "admin");
            users.addLocalAuthentication(userEntity, "admin");
            users.grantAdminPrivilege(userEntity);
            userEntity = users.createUser("user", "user", "user");
            users.addLocalAuthentication(userEntity, "user");
            MetainfoEntity schemaVersion = new MetainfoEntity();
            schemaVersion.setMetainfoName("version");
            schemaVersion.setMetainfoValue(VersionUtils.getVersionSubstring((String)this.obdpMetaInfo.getServerVersion()));
            this.metainfoDAO.create(schemaVersion);
        }
    }

    public void stop() throws Exception {
        if (this.server == null) {
            throw new OBDPException("Error stopping the server");
        }
        try {
            this.server.stop();
        }
        catch (Exception e) {
            LOG.error("Error stopping the server", (Throwable)e);
        }
    }

    @Deprecated
    public void performStaticInjection() {
        CertificateDownload.init((CertificateManager)this.injector.getInstance(CertificateManager.class));
        ConnectionInfo.init((Configuration)this.injector.getInstance(Configuration.class));
        CertificateSign.init((CertificateManager)this.injector.getInstance(CertificateManager.class));
        GetResource.init((ResourceManager)this.injector.getInstance(ResourceManager.class));
        PersistKeyValueService.init((PersistKeyValueImpl)this.injector.getInstance(PersistKeyValueImpl.class));
        KeyService.init((PersistKeyValueImpl)this.injector.getInstance(PersistKeyValueImpl.class));
        BootStrapResource.init((BootStrapImpl)this.injector.getInstance(BootStrapImpl.class));
        StackAdvisorResourceProvider.init((StackAdvisorHelper)this.injector.getInstance(StackAdvisorHelper.class), (Configuration)this.injector.getInstance(Configuration.class), (Clusters)this.injector.getInstance(Clusters.class), (OBDPMetaInfo)this.injector.getInstance(OBDPMetaInfo.class));
        StageUtils.setGson((Gson)this.injector.getInstance(Gson.class));
        StageUtils.setTopologyManager((TopologyManager)this.injector.getInstance(TopologyManager.class));
        StageUtils.setConfiguration((Configuration)this.injector.getInstance(Configuration.class));
        SecurityFilter.init((Configuration)this.injector.getInstance(Configuration.class));
        StackDefinedPropertyProvider.init(this.injector);
        AbstractControllerResourceProvider.init((ResourceProviderFactory)this.injector.getInstance(ResourceProviderFactory.class));
        BlueprintResourceProvider.init((BlueprintFactory)this.injector.getInstance(BlueprintFactory.class), (BlueprintDAO)this.injector.getInstance(BlueprintDAO.class), (TopologyRequestDAO)this.injector.getInstance(TopologyRequestDAO.class), (SecurityConfigurationFactory)this.injector.getInstance(SecurityConfigurationFactory.class), (Gson)this.injector.getInstance(Gson.class), this.obdpMetaInfo);
        StackDependencyResourceProvider.init(this.obdpMetaInfo);
        ClusterResourceProvider.init((TopologyManager)this.injector.getInstance(TopologyManager.class), (TopologyRequestFactory)this.injector.getInstance(TopologyRequestFactoryImpl.class), (SecurityConfigurationFactory)this.injector.getInstance(SecurityConfigurationFactory.class), (Gson)this.injector.getInstance(Gson.class));
        HostResourceProvider.setTopologyManager((TopologyManager)this.injector.getInstance(TopologyManager.class));
        BlueprintFactory.init((BlueprintDAO)this.injector.getInstance(BlueprintDAO.class));
        BaseClusterRequest.init((BlueprintFactory)this.injector.getInstance(BlueprintFactory.class));
        AmbariContext.init((HostRoleCommandFactory)this.injector.getInstance(HostRoleCommandFactory.class));
        PermissionResourceProvider.init((PermissionDAO)this.injector.getInstance(PermissionDAO.class));
        ViewPermissionResourceProvider.init((PermissionDAO)this.injector.getInstance(PermissionDAO.class));
        PrivilegeResourceProvider.init((PrivilegeDAO)this.injector.getInstance(PrivilegeDAO.class), (UserDAO)this.injector.getInstance(UserDAO.class), (GroupDAO)this.injector.getInstance(GroupDAO.class), (PrincipalDAO)this.injector.getInstance(PrincipalDAO.class), (PermissionDAO)this.injector.getInstance(PermissionDAO.class), (ResourceDAO)this.injector.getInstance(ResourceDAO.class));
        UserPrivilegeResourceProvider.init((UserDAO)this.injector.getInstance(UserDAO.class), (ClusterDAO)this.injector.getInstance(ClusterDAO.class), (GroupDAO)this.injector.getInstance(GroupDAO.class), (ViewInstanceDAO)this.injector.getInstance(ViewInstanceDAO.class), (Users)this.injector.getInstance(Users.class));
        ClusterPrivilegeResourceProvider.init((ClusterDAO)this.injector.getInstance(ClusterDAO.class));
        OBDPPrivilegeResourceProvider.init((ClusterDAO)this.injector.getInstance(ClusterDAO.class));
        ActionManager.setTopologyManager((TopologyManager)this.injector.getInstance(TopologyManager.class));
        KerberosKeytabController.setKerberosHelper((KerberosHelper)this.injector.getInstance(KerberosHelper.class));
        StackAdvisorBlueprintProcessor.init((StackAdvisorHelper)this.injector.getInstance(StackAdvisorHelper.class));
        ThreadPoolEnabledPropertyProvider.init((Configuration)this.injector.getInstance(Configuration.class));
        BaseService.init((RequestAuditLogger)this.injector.getInstance(RequestAuditLogger.class));
        RetryHelper.init((Clusters)this.injector.getInstance(Clusters.class), this.configs.getOperationsRetryAttempts());
        KerberosIdentityCleaner identityCleaner = (KerberosIdentityCleaner)this.injector.getInstance(KerberosIdentityCleaner.class);
        identityCleaner.register();
        this.configureFileWatcher();
    }

    private void configureFileWatcher() {
        OBDPEventPublisher ambariEventPublisher = (OBDPEventPublisher)this.injector.getInstance(OBDPEventPublisher.class);
        Configuration config = (Configuration)this.injector.getInstance(Configuration.class);
        SingleFileWatch watch = new SingleFileWatch(config.getConfigFile(), file -> ambariEventPublisher.publish(new AmbariPropertiesChangedEvent()));
        watch.start();
    }

    public void initViewRegistry() {
        ViewRegistry.initInstance(this.viewRegistry);
    }

    public static void setupProxyAuth() {
        final String proxyUser = System.getProperty("http.proxyUser");
        final String proxyPass = System.getProperty("http.proxyPassword");
        if (null != proxyUser && null != proxyPass) {
            LOG.info("Proxy authentication enabled");
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxyUser, proxyPass.toCharArray());
                }
            });
        } else {
            LOG.debug("Proxy authentication not specified");
        }
    }

    private static void logStartup() {
        String linePrefix = "STARTUP_MESSAGE: ";
        String classpathPropertyName = "java.class.path";
        String classpath = System.getProperty("java.class.path");
        Object[] rawMessages = new String[]{"STARTUP_MESSAGE: Starting OBDPServer.java executable", "java.class.path = " + classpath};
        LOG.info(Joiner.on((String)"\nSTARTUP_MESSAGE: ").join(rawMessages));
    }

    public static void enableLog4jMonitor(Map<String, String> configsMap) {
        String log4jpath = OBDPServer.class.getResource("/log4j.properties").toString();
        String monitorDelay = configsMap.get(Configuration.LOG4JMONITOR_DELAY.getKey());
        long monitorDelayLong = Configuration.LOG4JMONITOR_DELAY.getDefaultValue();
        try {
            log4jpath = log4jpath.replace("file:", "");
            if (StringUtils.isNotBlank((String)monitorDelay)) {
                monitorDelayLong = Long.parseLong(monitorDelay);
            }
            PropertyConfigurator.configureAndWatch((String)log4jpath, (long)monitorDelayLong);
        }
        catch (Exception e) {
            LOG.error("Exception in setting log4j monitor delay of {} for {}", new Object[]{monitorDelay, log4jpath, e});
        }
    }

    private static void loadRequestlogHandler(OBDPHandlerList handlerList, Server serverForAgent, Map<String, String> configsMap) {
        String requestlogpath = configsMap.get(Configuration.REQUEST_LOGPATH.getKey());
        if (!StringUtils.isBlank((String)requestlogpath)) {
            String logfullpath = requestlogpath + "//" + Configuration.REQUEST_LOGNAMEPATTERN.getDefaultValue();
            LOG.info("********* Initializing request access log: " + logfullpath);
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            CustomRequestLog requestLog = new CustomRequestLog(requestlogpath);
            String retaindays = configsMap.get(Configuration.REQUEST_LOG_RETAINDAYS.getKey());
            int retaindaysInt = Configuration.REQUEST_LOG_RETAINDAYS.getDefaultValue();
            if (retaindays != null && !StringUtils.isBlank((String)retaindays)) {
                retaindaysInt = Integer.parseInt(retaindays.trim());
            }
            requestLogHandler.setRequestLog((RequestLog)requestLog);
            handlerList.addHandler((Handler)requestLogHandler);
            HandlerCollection handlers = new HandlerCollection();
            Handler[] handler = serverForAgent.getHandlers();
            if (handler != null) {
                handlers.setHandlers(handler);
                handlers.addHandler((Handler)requestLogHandler);
                serverForAgent.setHandler((Handler)handlers);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        OBDPServer.logStartup();
        Injector injector = Guice.createInjector((Module[])new Module[]{new ControllerModule(), new AuditLoggerModule(), new LdapModule()});
        OBDPServer server = null;
        try {
            LOG.info("Getting the controller");
            Configuration config = (Configuration)injector.getInstance(Configuration.class);
            config.validatePasswordPolicyRegexp();
            if (!config.isActiveInstance()) {
                String errMsg = "This instance of OBDP server is not designated as active. Cannot start OBDP server.The property active.instance is set to false in obdp.properties";
                throw new OBDPException(errMsg);
            }
            OBDPServer.setupProxyAuth();
            GuiceJpaInitializer jpaInitializer = (GuiceJpaInitializer)injector.getInstance(GuiceJpaInitializer.class);
            jpaInitializer.setInitialized();
            DatabaseConsistencyCheckHelper.checkDBVersionCompatible();
            server = (OBDPServer)injector.getInstance(OBDPServer.class);
            ((UpdateActiveRepoVersionOnStartup)injector.getInstance(UpdateActiveRepoVersionOnStartup.class)).process();
            CertificateManager certMan = (CertificateManager)injector.getInstance(CertificateManager.class);
            certMan.initRootCert();
            KerberosChecker.checkJaasConfiguration();
            ViewRegistry.initInstance(server.viewRegistry);
            ComponentSSLConfiguration.instance().init(server.configs);
            server.run();
        }
        catch (Throwable t) {
            System.err.println("An unexpected error occured during starting OBDP Server.");
            t.printStackTrace();
            LOG.error("Failed to run the OBDP Server", t);
            if (server != null) {
                server.stop();
            }
            System.exit(-1);
        }
    }

    static {
        Velocity.setProperty((String)"runtime.log.logsystem.log4j.logger", (Object)VELOCITY_LOG_CATEGORY);
        CLASSPATH_SANITY_CHECK_FAILURE_MESSAGE = "%s class is found in multiple jar files. Possible reasons include multiple OBDP server jar files in the OBDP classpath.\n" + String.format("Check for additional OBDP server jar files and check that %s matches only one file.", AmbariPath.getPath("/usr/lib/obdp-server/obdp-server*.jar"));
        try {
            Enumeration<URL> ambariServerClassUrls = OBDPServer.class.getClassLoader().getResources(CLASSPATH_CHECK_CLASS);
            int ambariServerClassUrlsSize = 0;
            while (ambariServerClassUrls.hasMoreElements()) {
                ++ambariServerClassUrlsSize;
                URL url = ambariServerClassUrls.nextElement();
                LOG.info(String.format("Found %s class in %s", CLASSPATH_CHECK_CLASS, url.getPath()));
            }
            if (ambariServerClassUrlsSize > 1) {
                throw new RuntimeException(String.format(CLASSPATH_SANITY_CHECK_FAILURE_MESSAGE, CLASSPATH_CHECK_CLASS));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        clusterController = null;
    }
}

