/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.ClusterNotFoundException;
import id.onyx.obdp.server.DuplicateResourceException;
import id.onyx.obdp.server.HostNotFoundException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ObjectNotFoundException;
import id.onyx.obdp.server.ParentObjectNotFoundException;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.ServiceComponentHostNotFoundException;
import id.onyx.obdp.server.ServiceComponentNotFoundException;
import id.onyx.obdp.server.ServiceNotFoundException;
import id.onyx.obdp.server.StackAccessException;
import id.onyx.obdp.server.actionmanager.ActionManager;
import id.onyx.obdp.server.actionmanager.CommandExecutionType;
import id.onyx.obdp.server.actionmanager.ExecutionCommandWrapper;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.RequestFactory;
import id.onyx.obdp.server.actionmanager.Stage;
import id.onyx.obdp.server.actionmanager.StageFactory;
import id.onyx.obdp.server.agent.CommandRepository;
import id.onyx.obdp.server.agent.ExecutionCommand;
import id.onyx.obdp.server.agent.stomp.HostLevelParamsHolder;
import id.onyx.obdp.server.agent.stomp.TopologyHolder;
import id.onyx.obdp.server.agent.stomp.dto.MetadataCluster;
import id.onyx.obdp.server.agent.stomp.dto.MetadataServiceInfo;
import id.onyx.obdp.server.agent.stomp.dto.TopologyCluster;
import id.onyx.obdp.server.agent.stomp.dto.TopologyComponent;
import id.onyx.obdp.server.agent.stomp.dto.TopologyUpdateHandlingReport;
import id.onyx.obdp.server.api.services.LoggingService;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.AbstractRootServiceResponseFactory;
import id.onyx.obdp.server.controller.ActionExecutionContext;
import id.onyx.obdp.server.controller.AmbariManagementHelper;
import id.onyx.obdp.server.controller.ClusterRequest;
import id.onyx.obdp.server.controller.ClusterResponse;
import id.onyx.obdp.server.controller.ConfigGroupRequest;
import id.onyx.obdp.server.controller.ConfigGroupResponse;
import id.onyx.obdp.server.controller.ConfigurationRequest;
import id.onyx.obdp.server.controller.ConfigurationResponse;
import id.onyx.obdp.server.controller.ExecuteActionRequest;
import id.onyx.obdp.server.controller.ExecuteCommandJson;
import id.onyx.obdp.server.controller.ExtensionLinkRequest;
import id.onyx.obdp.server.controller.ExtensionRequest;
import id.onyx.obdp.server.controller.ExtensionResponse;
import id.onyx.obdp.server.controller.ExtensionVersionRequest;
import id.onyx.obdp.server.controller.ExtensionVersionResponse;
import id.onyx.obdp.server.controller.GroupRequest;
import id.onyx.obdp.server.controller.GroupResponse;
import id.onyx.obdp.server.controller.HostsMap;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.controller.LdapSyncRequest;
import id.onyx.obdp.server.controller.MaintenanceStateHelper;
import id.onyx.obdp.server.controller.MemberRequest;
import id.onyx.obdp.server.controller.MemberResponse;
import id.onyx.obdp.server.controller.MpackRequest;
import id.onyx.obdp.server.controller.MpackResponse;
import id.onyx.obdp.server.controller.OBDPActionExecutionHelper;
import id.onyx.obdp.server.controller.OBDPCustomCommandExecutionHelper;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OperatingSystemRequest;
import id.onyx.obdp.server.controller.OperatingSystemResponse;
import id.onyx.obdp.server.controller.RepositoryRequest;
import id.onyx.obdp.server.controller.RepositoryResponse;
import id.onyx.obdp.server.controller.RequestStatusResponse;
import id.onyx.obdp.server.controller.RootServiceComponentRequest;
import id.onyx.obdp.server.controller.RootServiceComponentResponse;
import id.onyx.obdp.server.controller.RootServiceRequest;
import id.onyx.obdp.server.controller.RootServiceResponse;
import id.onyx.obdp.server.controller.ServiceComponentHostRequest;
import id.onyx.obdp.server.controller.ServiceComponentHostResponse;
import id.onyx.obdp.server.controller.ServiceConfigVersionRequest;
import id.onyx.obdp.server.controller.ServiceConfigVersionResponse;
import id.onyx.obdp.server.controller.ShortTaskStatus;
import id.onyx.obdp.server.controller.StackConfigurationDependencyRequest;
import id.onyx.obdp.server.controller.StackConfigurationDependencyResponse;
import id.onyx.obdp.server.controller.StackConfigurationRequest;
import id.onyx.obdp.server.controller.StackConfigurationResponse;
import id.onyx.obdp.server.controller.StackLevelConfigurationRequest;
import id.onyx.obdp.server.controller.StackRequest;
import id.onyx.obdp.server.controller.StackResponse;
import id.onyx.obdp.server.controller.StackServiceComponentRequest;
import id.onyx.obdp.server.controller.StackServiceComponentResponse;
import id.onyx.obdp.server.controller.StackServiceRequest;
import id.onyx.obdp.server.controller.StackServiceResponse;
import id.onyx.obdp.server.controller.StackVersionRequest;
import id.onyx.obdp.server.controller.StackVersionResponse;
import id.onyx.obdp.server.controller.internal.DeleteHostComponentStatusMetaData;
import id.onyx.obdp.server.controller.internal.DeleteStatusMetaData;
import id.onyx.obdp.server.controller.internal.HostComponentResourceProvider;
import id.onyx.obdp.server.controller.internal.RequestOperationLevel;
import id.onyx.obdp.server.controller.internal.RequestResourceFilter;
import id.onyx.obdp.server.controller.internal.RequestStageContainer;
import id.onyx.obdp.server.controller.internal.URLRedirectProvider;
import id.onyx.obdp.server.controller.internal.WidgetLayoutResourceProvider;
import id.onyx.obdp.server.controller.internal.WidgetResourceProvider;
import id.onyx.obdp.server.controller.logging.LoggingSearchPropertyProvider;
import id.onyx.obdp.server.controller.metrics.MetricPropertyProviderFactory;
import id.onyx.obdp.server.controller.metrics.MetricsCollectorHAManager;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricCacheProvider;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.customactions.ActionDefinition;
import id.onyx.obdp.server.events.MetadataUpdateEvent;
import id.onyx.obdp.server.events.TopologyUpdateEvent;
import id.onyx.obdp.server.events.UpdateEventType;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.metadata.ActionMetadata;
import id.onyx.obdp.server.metadata.RoleCommandOrder;
import id.onyx.obdp.server.metadata.RoleCommandOrderProvider;
import id.onyx.obdp.server.orm.dao.ClusterDAO;
import id.onyx.obdp.server.orm.dao.ExtensionDAO;
import id.onyx.obdp.server.orm.dao.ExtensionLinkDAO;
import id.onyx.obdp.server.orm.dao.HostComponentDesiredStateDAO;
import id.onyx.obdp.server.orm.dao.RepositoryVersionDAO;
import id.onyx.obdp.server.orm.dao.ServiceComponentDesiredStateDAO;
import id.onyx.obdp.server.orm.dao.SettingDAO;
import id.onyx.obdp.server.orm.dao.StackDAO;
import id.onyx.obdp.server.orm.dao.WidgetDAO;
import id.onyx.obdp.server.orm.dao.WidgetLayoutDAO;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.ExtensionLinkEntity;
import id.onyx.obdp.server.orm.entities.HostComponentDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.MpackEntity;
import id.onyx.obdp.server.orm.entities.RepoDefinitionEntity;
import id.onyx.obdp.server.orm.entities.RepoOsEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.ServiceComponentDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.SettingEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.orm.entities.WidgetEntity;
import id.onyx.obdp.server.orm.entities.WidgetLayoutEntity;
import id.onyx.obdp.server.orm.entities.WidgetLayoutUserWidgetEntity;
import id.onyx.obdp.server.scheduler.ExecutionScheduleManager;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.Group;
import id.onyx.obdp.server.security.authorization.GroupType;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.security.authorization.User;
import id.onyx.obdp.server.security.authorization.Users;
import id.onyx.obdp.server.security.encryption.CredentialStoreService;
import id.onyx.obdp.server.security.encryption.CredentialStoreType;
import id.onyx.obdp.server.security.ldap.LdapBatchDto;
import id.onyx.obdp.server.security.ldap.LdapSyncDto;
import id.onyx.obdp.server.security.ldap.LdapUserDto;
import id.onyx.obdp.server.security.ldap.OBDPLdapDataPopulator;
import id.onyx.obdp.server.serveraction.kerberos.KerberosInvalidConfigurationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationException;
import id.onyx.obdp.server.stack.ExtensionHelper;
import id.onyx.obdp.server.stack.RepoUtil;
import id.onyx.obdp.server.stack.upgrade.RepositoryVersionHelper;
import id.onyx.obdp.server.stageplanner.RoleGraph;
import id.onyx.obdp.server.stageplanner.RoleGraphFactory;
import id.onyx.obdp.server.state.BlueprintProvisioningState;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.CommandScriptDefinition;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.ConfigFactory;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.DependencyInfo;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.ExtensionInfo;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.HostState;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.Module;
import id.onyx.obdp.server.state.Mpack;
import id.onyx.obdp.server.state.OperatingSystemInfo;
import id.onyx.obdp.server.state.PropertyDependencyInfo;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.RepositoryInfo;
import id.onyx.obdp.server.state.SecurityType;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentFactory;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.ServiceComponentHostEvent;
import id.onyx.obdp.server.state.ServiceComponentHostFactory;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.ServiceOsSpecific;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.State;
import id.onyx.obdp.server.state.UnlimitedKeyJCERequirement;
import id.onyx.obdp.server.state.configgroup.ConfigGroupFactory;
import id.onyx.obdp.server.state.fsm.InvalidStateTransitionException;
import id.onyx.obdp.server.state.quicklinksprofile.QuickLinkVisibilityController;
import id.onyx.obdp.server.state.quicklinksprofile.QuickLinkVisibilityControllerFactory;
import id.onyx.obdp.server.state.repository.VersionDefinitionXml;
import id.onyx.obdp.server.state.scheduler.RequestExecutionFactory;
import id.onyx.obdp.server.state.stack.OsFamily;
import id.onyx.obdp.server.state.stack.RepositoryXml;
import id.onyx.obdp.server.state.stack.WidgetLayout;
import id.onyx.obdp.server.state.stack.WidgetLayoutInfo;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostInstallEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostOpInProgressEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostOpSucceededEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostStartEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostStopEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostUpgradeEvent;
import id.onyx.obdp.server.topology.STOMPComponentsDeleteHandler;
import id.onyx.obdp.server.utils.SecretReference;
import id.onyx.obdp.server.utils.StageUtils;
import id.onyx.obdp.server.utils.URLCredentialsHider;
import jakarta.persistence.RollbackException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OBDPManagementControllerImpl
implements OBDPManagementController {
    private static final Logger LOG = LoggerFactory.getLogger(OBDPManagementControllerImpl.class);
    private static final Logger configChangeLog = LoggerFactory.getLogger((String)"configchange");
    private static final Type hostAttributesType = new TypeToken<Map<String, String>>(){}.getType();
    public static final String CLUSTER_PHASE_PROPERTY = "phase";
    public static final String CLUSTER_PHASE_INITIAL_INSTALL = "INITIAL_INSTALL";
    public static final String CLUSTER_PHASE_INITIAL_START = "INITIAL_START";
    private static final String AMBARI_SERVER_HOST = "ambari_server_host";
    private static final String AMBARI_SERVER_PORT = "ambari_server_port";
    private static final String AMBARI_SERVER_USE_SSL = "ambari_server_use_ssl";
    private static final String BASE_LOG_DIR = "/tmp/obdp";
    private static final String PASSWORD = "password";
    public static final String CLUSTER_NAME_VALIDATION_REGEXP = "^[a-zA-Z0-9_-]{1,100}$";
    public static final Pattern CLUSTER_NAME_PTRN = Pattern.compile("^[a-zA-Z0-9_-]{1,100}$");
    private final Clusters clusters;
    private final ActionManager actionManager;
    private final Injector injector;
    private final Gson gson;
    @Inject
    private RoleCommandOrderProvider roleCommandOrderProvider;
    @Inject
    private ServiceComponentFactory serviceComponentFactory;
    @Inject
    private ServiceComponentHostFactory serviceComponentHostFactory;
    @Inject
    private ConfigFactory configFactory;
    @Inject
    private StageFactory stageFactory;
    @Inject
    private RequestFactory requestFactory;
    @Inject
    private ActionMetadata actionMetadata;
    @Inject
    private OBDPMetaInfo obdpMetaInfo;
    @Inject
    private Users users;
    @Inject
    private HostsMap hostsMap;
    @Inject
    private Configuration configs;
    @Inject
    private AbstractRootServiceResponseFactory rootServiceResponseFactory;
    @Inject
    private RoleGraphFactory roleGraphFactory;
    @Inject
    private ConfigGroupFactory configGroupFactory;
    @Inject
    private ConfigHelper configHelper;
    @Inject
    private RequestExecutionFactory requestExecutionFactory;
    @Inject
    private ExecutionScheduleManager executionScheduleManager;
    @Inject
    private OBDPLdapDataPopulator ldapDataPopulator;
    @Inject
    private RepositoryVersionDAO repositoryVersionDAO;
    @Inject
    private WidgetDAO widgetDAO;
    @Inject
    private WidgetLayoutDAO widgetLayoutDAO;
    @Inject
    private ClusterDAO clusterDAO;
    @Inject
    private CredentialStoreService credentialStoreService;
    @Inject
    private SettingDAO settingDAO;
    private MaintenanceStateHelper maintenanceStateHelper;
    private AmbariManagementHelper helper;
    @Inject
    private ExtensionDAO extensionDAO;
    @Inject
    private ExtensionLinkDAO linkDAO;
    @Inject
    private StackDAO stackDAO;
    @Inject
    protected OsFamily osFamily;
    @Inject
    private STOMPComponentsDeleteHandler STOMPComponentsDeleteHandler;
    @Inject
    private Provider<TopologyHolder> m_topologyHolder;
    @Inject
    private Provider<HostLevelParamsHolder> m_hostLevelParamsHolder;
    @Inject
    private ServiceComponentDesiredStateDAO serviceComponentDesiredStateDAO;
    @Inject
    private RepositoryVersionHelper repoVersionHelper;
    @Inject
    private HostComponentDesiredStateDAO hostComponentDesiredStateDAO;
    private KerberosHelper kerberosHelper;
    private final String masterHostname;
    private final Integer masterPort;
    private final String masterProtocol;
    private static final String JDK_RESOURCE_LOCATION = "/resources";
    private static final int REPO_URL_CONNECT_TIMEOUT = 3000;
    private static final int REPO_URL_READ_TIMEOUT = 2000;
    private final String jdkResourceUrl;
    private final String javaHome;
    private final String ambariJavaHome;
    private final String jdkName;
    private final String jceName;
    private final String ojdbcUrl;
    private final String serverDB;
    private final String mysqljdbcUrl;
    private boolean ldapSyncInProgress;
    private Cache<ClusterRequest, ClusterResponse> clusterUpdateCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private Cache<ConfigGroupRequest, ConfigGroupResponse> configGroupUpdateCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    @Inject
    private OBDPCustomCommandExecutionHelper customCommandExecutionHelper;
    @Inject
    private OBDPActionExecutionHelper actionExecutionHelper;
    private Map<String, Map<String, Map<String, String>>> configCredentialsForService = new HashMap<String, Map<String, Map<String, String>>>();

    @Inject
    public OBDPManagementControllerImpl(ActionManager actionManager, Clusters clusters, Injector injector) throws Exception {
        this.clusters = clusters;
        this.actionManager = actionManager;
        this.injector = injector;
        injector.injectMembers((Object)this);
        this.gson = (Gson)injector.getInstance(Gson.class);
        LOG.info("Initializing the OBDPManagementControllerImpl");
        this.masterHostname = InetAddress.getLocalHost().getCanonicalHostName();
        this.maintenanceStateHelper = (MaintenanceStateHelper)injector.getInstance(MaintenanceStateHelper.class);
        this.kerberosHelper = (KerberosHelper)injector.getInstance(KerberosHelper.class);
        if (this.configs != null) {
            if (this.configs.getApiSSLAuthentication()) {
                this.masterProtocol = "https";
                this.masterPort = this.configs.getClientSSLApiPort();
            } else {
                this.masterProtocol = "http";
                this.masterPort = this.configs.getClientApiPort();
            }
            this.jdkResourceUrl = this.getAmbariServerURI(JDK_RESOURCE_LOCATION);
            this.javaHome = this.configs.getJavaHome();
            this.ambariJavaHome = this.configs.getAmbariJavaHome();
            this.jdkName = this.configs.getJDKName();
            this.jceName = this.configs.getJCEName();
            this.ojdbcUrl = this.getAmbariServerURI("/resources/" + this.configs.getOjdbcJarName());
            this.mysqljdbcUrl = this.getAmbariServerURI("/resources/" + this.configs.getMySQLJarName());
            this.serverDB = this.configs.getServerDBName();
        } else {
            this.masterProtocol = null;
            this.masterPort = null;
            this.jdkResourceUrl = null;
            this.javaHome = null;
            this.ambariJavaHome = null;
            this.jdkName = null;
            this.jceName = null;
            this.ojdbcUrl = null;
            this.mysqljdbcUrl = null;
            this.serverDB = null;
        }
        this.helper = new AmbariManagementHelper(this.stackDAO, this.extensionDAO, this.linkDAO);
    }

    @Override
    public String getAmbariServerURI(String path) {
        if (this.masterProtocol == null || this.masterHostname == null || this.masterPort == null) {
            return null;
        }
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme(this.masterProtocol);
        uriBuilder.setHost(this.masterHostname);
        uriBuilder.setPort(this.masterPort.intValue());
        String[] parts = path.split("\\?");
        if (parts.length > 1) {
            uriBuilder.setPath(parts[0]);
            uriBuilder.setQuery(parts[1]);
        } else {
            uriBuilder.setPath(path);
        }
        return uriBuilder.toString();
    }

    @Override
    public RoleCommandOrder getRoleCommandOrder(Cluster cluster) {
        return this.roleCommandOrderProvider.getRoleCommandOrder(cluster);
    }

    @Override
    public void createCluster(ClusterRequest request) throws OBDPException {
        if (request.getClusterName() == null || request.getClusterName().isEmpty() || request.getClusterId() != null) {
            throw new IllegalArgumentException("Cluster name should be provided and clusterId should be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received a createCluster request, clusterName={}, request={}", (Object)request.getClusterName(), (Object)request);
        }
        if (request.getStackVersion() == null || request.getStackVersion().isEmpty()) {
            throw new IllegalArgumentException("Stack information should be provided when creating a cluster");
        }
        StackId stackId = new StackId(request.getStackVersion());
        StackInfo stackInfo = this.obdpMetaInfo.getStack(stackId.getStackName(), stackId.getStackVersion());
        if (stackInfo == null) {
            throw new StackAccessException("stackName=" + stackId.getStackName() + ", stackVersion=" + stackId.getStackVersion());
        }
        boolean foundInvalidHosts = false;
        StringBuilder invalidHostsStr = new StringBuilder();
        if (request.getHostNames() != null) {
            for (String hostname : request.getHostNames()) {
                try {
                    this.clusters.getHost(hostname);
                }
                catch (HostNotFoundException e) {
                    if (foundInvalidHosts) {
                        invalidHostsStr.append(",");
                    }
                    foundInvalidHosts = true;
                    invalidHostsStr.append(hostname);
                }
            }
        }
        if (foundInvalidHosts) {
            throw new HostNotFoundException(invalidHostsStr.toString());
        }
        this.clusters.addCluster(request.getClusterName(), stackId, request.getSecurityType());
        Cluster c = this.clusters.getCluster(request.getClusterName());
        if (request.getHostNames() != null) {
            this.clusters.mapAndPublishHostsToCluster(request.getHostNames(), request.getClusterName());
        }
        this.initializeWidgetsAndLayouts(c, null);
    }

    @Override
    public synchronized void createHostComponents(Set<ServiceComponentHostRequest> requests) throws OBDPException, AuthorizationException {
        this.createHostComponents(requests, false);
    }

    @Override
    public MpackResponse registerMpack(MpackRequest request) throws IOException, AuthorizationException, ResourceAlreadyExistsException {
        MpackResponse mpackResponse = this.obdpMetaInfo.registerMpack(request);
        this.updateStacks();
        return mpackResponse;
    }

    @Override
    public Set<MpackResponse> getMpacks() {
        Collection<Mpack> mpacks = this.obdpMetaInfo.getMpacks();
        HashSet<MpackResponse> responseSet = new HashSet<MpackResponse>();
        for (Mpack mpack : mpacks) {
            responseSet.add(new MpackResponse(mpack));
        }
        return responseSet;
    }

    @Override
    public MpackResponse getMpack(Long mpackId) {
        Mpack mpack = this.obdpMetaInfo.getMpack(mpackId);
        if (mpack != null) {
            return new MpackResponse(mpack);
        }
        return null;
    }

    @Override
    public List<Module> getModules(Long mpackId) {
        return this.obdpMetaInfo.getModules(mpackId);
    }

    @Override
    public synchronized void createHostComponents(Set<ServiceComponentHostRequest> requests, boolean isBlueprintProvisioned) throws OBDPException, AuthorizationException {
        if (requests.isEmpty()) {
            LOG.warn("Received an empty requests set");
            return;
        }
        HashMap<String, Map<String, Map<String, Set<String>>>> hostComponentNames = new HashMap<String, Map<String, Map<String, Set<String>>>>();
        HashSet<CallSite> duplicates = new HashSet<CallSite>();
        for (ServiceComponentHostRequest request : requests) {
            Host host;
            Service s;
            State state;
            Cluster cluster;
            this.validateServiceComponentHostRequest(request);
            try {
                cluster = this.clusters.getCluster(request.getClusterName());
            }
            catch (ClusterNotFoundException e) {
                throw new ParentObjectNotFoundException("Attempted to add a host_component to a cluster which doesn't exist: ", e);
            }
            if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), EnumSet.of(RoleAuthorization.SERVICE_ADD_DELETE_SERVICES, RoleAuthorization.HOST_ADD_DELETE_COMPONENTS))) {
                throw new AuthorizationException("The authenticated user is not authorized to install service components on to hosts");
            }
            if (StringUtils.isEmpty((String)request.getServiceName())) {
                request.setServiceName(this.findServiceName(cluster, request.getComponentName()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received a createHostComponent request, clusterName={}, serviceName={}, componentName={}, hostname={}, request={}", new Object[]{request.getClusterName(), request.getServiceName(), request.getComponentName(), request.getHostname(), request});
            }
            if (!hostComponentNames.containsKey(request.getClusterName())) {
                hostComponentNames.put(request.getClusterName(), new HashMap());
            }
            if (!((Map)hostComponentNames.get(request.getClusterName())).containsKey(request.getServiceName())) {
                ((Map)hostComponentNames.get(request.getClusterName())).put(request.getServiceName(), new HashMap());
            }
            if (!((Map)((Map)hostComponentNames.get(request.getClusterName())).get(request.getServiceName())).containsKey(request.getComponentName())) {
                ((Map)((Map)hostComponentNames.get(request.getClusterName())).get(request.getServiceName())).put(request.getComponentName(), new HashSet());
            }
            if (((Set)((Map)((Map)hostComponentNames.get(request.getClusterName())).get(request.getServiceName())).get(request.getComponentName())).contains(request.getHostname())) {
                duplicates.add((CallSite)((Object)("[clusterName=" + request.getClusterName() + ", hostName=" + request.getHostname() + ", componentName=" + request.getComponentName() + "]")));
                continue;
            }
            ((Set)((Map)((Map)hostComponentNames.get(request.getClusterName())).get(request.getServiceName())).get(request.getComponentName())).add(request.getHostname());
            if (!(request.getDesiredState() == null || request.getDesiredState().isEmpty() || (state = State.valueOf(request.getDesiredState())).isValidDesiredState() && state == State.INIT)) {
                throw new IllegalArgumentException("Invalid desired state only INIT state allowed during creation, providedDesiredState=" + request.getDesiredState());
            }
            try {
                s = cluster.getService(request.getServiceName());
            }
            catch (ServiceNotFoundException e) {
                throw new IllegalArgumentException("The service[" + request.getServiceName() + "] associated with the component[" + request.getComponentName() + "] doesn't exist for the cluster[" + request.getClusterName() + "]");
            }
            ServiceComponent sc = s.getServiceComponent(request.getComponentName());
            this.setRestartRequiredServices(s, request.getComponentName());
            try {
                host = this.clusters.getHost(request.getHostname());
            }
            catch (HostNotFoundException e) {
                throw new ParentObjectNotFoundException("Attempted to add a host_component to a host that doesn't exist: ", e);
            }
            Set<Cluster> mappedClusters = this.clusters.getClustersForHost(request.getHostname());
            boolean validCluster = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Looking to match host to cluster, hostnameViaReg={}, hostname={}, clusterName={}, hostClusterMapCount={}", new Object[]{host.getHostName(), request.getHostname(), request.getClusterName(), mappedClusters.size()});
            }
            for (Cluster mappedCluster : mappedClusters) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Host belongs to cluster, hostname={}, clusterName={}", (Object)request.getHostname(), (Object)mappedCluster.getClusterName());
                }
                if (!mappedCluster.getClusterName().equals(request.getClusterName())) continue;
                validCluster = true;
                break;
            }
            if (!validCluster) {
                throw new ParentObjectNotFoundException("Attempted to add a host_component to a host that doesn't exist: clusterName=" + request.getClusterName() + ", hostName=" + request.getHostname());
            }
            try {
                ServiceComponentHost sch = sc.getServiceComponentHost(request.getHostname());
                if (sch == null) continue;
                duplicates.add((CallSite)((Object)("[clusterName=" + request.getClusterName() + ", hostName=" + request.getHostname() + ", componentName=" + request.getComponentName() + "]")));
            }
            catch (OBDPException oBDPException) {}
        }
        if (hostComponentNames.size() != 1) {
            throw new IllegalArgumentException("Invalid arguments - updates allowed on only one cluster at a time");
        }
        if (!duplicates.isEmpty()) {
            String names = String.join((CharSequence)",", duplicates);
            String msg = duplicates.size() == 1 ? "Attempted to create a host_component which already exists: " : "Attempted to create host_component's which already exist: ";
            throw new DuplicateResourceException(msg + names);
        }
        if (!isBlueprintProvisioned) {
            this.validateExclusiveDependencies(hostComponentNames);
        }
        this.setMonitoringServicesRestartRequired(requests);
        this.persistServiceComponentHosts(requests, isBlueprintProvisioned);
        ((TopologyHolder)this.m_topologyHolder.get()).updateData(this.getAddedComponentsTopologyEvent(requests));
    }

    private void validateExclusiveDependencies(Map<String, Map<String, Map<String, Set<String>>>> hostComponentNames) throws OBDPException {
        ArrayList<CallSite> validationIssues = new ArrayList<CallSite>();
        for (Map.Entry<String, Map<String, Map<String, Set<String>>>> clusterEntry : hostComponentNames.entrySet()) {
            for (Map.Entry<String, Map<String, Set<String>>> serviceEntry : clusterEntry.getValue().entrySet()) {
                for (Map.Entry<String, Set<String>> componentEntry : serviceEntry.getValue().entrySet()) {
                    Set<String> hostnames = componentEntry.getValue();
                    if (hostnames == null || hostnames.isEmpty()) continue;
                    ServiceComponent sc = this.clusters.getCluster(clusterEntry.getKey()).getService(serviceEntry.getKey()).getServiceComponent(componentEntry.getKey());
                    StackId stackId = sc.getDesiredStackId();
                    List<DependencyInfo> dependencyInfos = this.obdpMetaInfo.getComponentDependencies(stackId.getStackName(), stackId.getStackVersion(), serviceEntry.getKey(), componentEntry.getKey());
                    for (DependencyInfo dependencyInfo : dependencyInfos) {
                        ServiceComponent dependentSC;
                        Service depService;
                        if (!"host".equals(dependencyInfo.getScope()) || !"exclusive".equals(dependencyInfo.getType())) continue;
                        try {
                            depService = this.clusters.getCluster(clusterEntry.getKey()).getService(dependencyInfo.getServiceName());
                        }
                        catch (ServiceNotFoundException e) {
                            LOG.debug("Skipping dependency " + dependencyInfo + " for " + serviceEntry.getKey() + " since the dependent service is not installed ");
                            continue;
                        }
                        if (depService == null || !depService.getServiceComponents().containsKey(dependencyInfo.getComponentName()) || (dependentSC = depService.getServiceComponent(dependencyInfo.getComponentName())) == null) continue;
                        HashSet<String> dependentComponentHosts = new HashSet<String>(dependentSC.getServiceComponentHosts().keySet());
                        if (clusterEntry.getValue().containsKey(dependentSC.getServiceName()) && clusterEntry.getValue().get(dependentSC.getServiceName()).containsKey(dependentSC.getName())) {
                            dependentComponentHosts.addAll((Collection<String>)clusterEntry.getValue().get(dependentSC.getServiceName()).get(dependentSC.getName()));
                        }
                        dependentComponentHosts.retainAll(hostnames);
                        if (dependentComponentHosts.isEmpty()) continue;
                        validationIssues.add((CallSite)((Object)("Component " + componentEntry.getKey() + " can't be co-hosted with component " + dependencyInfo.getComponentName() + " on hosts " + dependentComponentHosts + " due to exclusive dependency")));
                    }
                }
            }
        }
        if (!validationIssues.isEmpty()) {
            throw new OBDPException("The components exclusive dependencies are not respected: " + validationIssues);
        }
    }

    void persistServiceComponentHosts(Set<ServiceComponentHostRequest> requests, boolean isBlueprintProvisioned) throws OBDPException {
        ArrayListMultimap schMap = ArrayListMultimap.create();
        HashMap<Long, Map<String, List<String>>> serviceComponentNames = new HashMap<Long, Map<String, List<String>>>();
        HashMap<Long, Map> serviceComponentDesiredStateEntities = new HashMap<Long, Map>();
        for (ServiceComponentHostRequest request : requests) {
            Cluster cluster = this.clusters.getCluster(request.getClusterName());
            Service s = cluster.getService(request.getServiceName());
            ServiceComponent sc = s.getServiceComponent(request.getComponentName());
            serviceComponentNames.computeIfAbsent(sc.getClusterId(), c -> new HashMap()).computeIfAbsent(sc.getServiceName(), h -> new ArrayList()).add(sc.getName());
        }
        List<ServiceComponentDesiredStateEntity> entities = this.serviceComponentDesiredStateDAO.findByNames(serviceComponentNames);
        for (ServiceComponentDesiredStateEntity stateEntity : entities) {
            serviceComponentDesiredStateEntities.computeIfAbsent(stateEntity.getClusterId(), c -> new HashMap()).computeIfAbsent(stateEntity.getServiceName(), h -> new HashMap()).putIfAbsent(stateEntity.getComponentName(), stateEntity);
        }
        for (ServiceComponentHostRequest request : requests) {
            Cluster cluster = this.clusters.getCluster(request.getClusterName());
            Service s = cluster.getService(request.getServiceName());
            ServiceComponent sc = s.getServiceComponent(request.getComponentName());
            ServiceComponentHost sch = this.serviceComponentHostFactory.createNew(sc, request.getHostname(), (ServiceComponentDesiredStateEntity)((Map)((Map)serviceComponentDesiredStateEntities.get(cluster.getClusterId())).get(s.getName())).get(sc.getName()));
            if (request.getDesiredState() != null && !request.getDesiredState().isEmpty()) {
                State state = State.valueOf(request.getDesiredState());
                sch.setDesiredState(state);
            }
            if (isBlueprintProvisioned && !sch.isClientComponent()) {
                HostComponentDesiredStateEntity desiredStateEntity = sch.getDesiredStateEntity();
                desiredStateEntity.setBlueprintProvisioningState(BlueprintProvisioningState.IN_PROGRESS);
                this.hostComponentDesiredStateDAO.merge(desiredStateEntity);
            }
            schMap.put((Object)cluster, (Object)sch);
        }
        for (Cluster cluster : schMap.keySet()) {
            cluster.addServiceComponentHosts(schMap.get((Object)cluster));
        }
    }

    @Override
    public TopologyUpdateEvent getAddedComponentsTopologyEvent(Set<ServiceComponentHostRequest> requests) throws OBDPException {
        TreeMap<String, TopologyCluster> topologyUpdates = new TreeMap<String, TopologyCluster>();
        HashSet<String> hostsToUpdate = new HashSet<String>();
        for (ServiceComponentHostRequest request : requests) {
            String serviceName = request.getServiceName();
            String componentName = request.getComponentName();
            Cluster cluster = this.clusters.getCluster(request.getClusterName());
            Collection<Host> clusterHosts = cluster.getHosts();
            Service s = cluster.getService(serviceName);
            ServiceComponent sc = s.getServiceComponent(componentName);
            String hostName = request.getHostname();
            hostsToUpdate.add(hostName);
            Set<Long> hostIds = clusterHosts.stream().filter(h -> hostName.equals(h.getHostName())).map(h -> h.getHostId()).collect(Collectors.toSet());
            Set<String> publicHostNames = clusterHosts.stream().filter(h -> hostName.equals(h.getHostName())).map(h -> h.getPublicHostName()).collect(Collectors.toSet());
            HashSet<String> hostNames = new HashSet<String>();
            hostNames.add(hostName);
            ServiceComponentHost sch = sc.getServiceComponentHost(request.getHostname());
            TopologyComponent newComponent = TopologyComponent.newBuilder().setComponentName(sch.getServiceComponentName()).setServiceName(sch.getServiceName()).setDisplayName(sc.getDisplayName()).setHostIdentifiers(hostIds, hostNames).setPublicHostNames(publicHostNames).setComponentLevelParams(this.getTopologyComponentLevelParams(cluster.getClusterId(), serviceName, componentName, cluster.getSecurityType())).setCommandParams(this.getTopologyCommandParams(cluster.getClusterId(), serviceName, componentName, sch)).build();
            String clusterId = Long.toString(cluster.getClusterId());
            if (!topologyUpdates.containsKey(clusterId)) {
                topologyUpdates.put(clusterId, new TopologyCluster());
            }
            if (topologyUpdates.get(clusterId).getTopologyComponents().contains(newComponent)) {
                HashSet<TopologyComponent> newComponents = new HashSet<TopologyComponent>();
                newComponents.add(newComponent);
                topologyUpdates.get(clusterId).update(newComponents, Collections.emptySet(), UpdateEventType.UPDATE, new TopologyUpdateHandlingReport());
                continue;
            }
            topologyUpdates.get(clusterId).addTopologyComponent(newComponent);
        }
        for (String hostName : hostsToUpdate) {
            Host host = this.clusters.getHost(hostName);
            ((HostLevelParamsHolder)this.m_hostLevelParamsHolder.get()).updateData(((HostLevelParamsHolder)this.m_hostLevelParamsHolder.get()).getCurrentData(host.getHostId()));
        }
        return new TopologyUpdateEvent(topologyUpdates, UpdateEventType.UPDATE);
    }

    private void setMonitoringServicesRestartRequired(Set<ServiceComponentHostRequest> requests) throws OBDPException {
        for (ServiceComponentHostRequest request : requests) {
            Cluster cluster = this.clusters.getCluster(request.getClusterName());
            for (Service service : cluster.getServices().values()) {
                ServiceInfo serviceInfo = this.obdpMetaInfo.getService(service);
                if (!BooleanUtils.toBoolean((Boolean)serviceInfo.isMonitoringService())) continue;
                for (ServiceComponent sc : service.getServiceComponents().values()) {
                    ServiceComponentHost sch2;
                    if (sc.isMasterComponent()) {
                        for (ServiceComponentHost sch2 : sc.getServiceComponentHosts().values()) {
                            sch2.setRestartRequired(true);
                        }
                        continue;
                    }
                    String hostname = request.getHostname();
                    if (!sc.getServiceComponentHosts().containsKey(hostname)) continue;
                    sch2 = sc.getServiceComponentHost(hostname);
                    sch2.setRestartRequired(true);
                }
            }
        }
    }

    private void setRestartRequiredServices(Service service, String componentName) throws OBDPException {
        StackId stackId = service.getDesiredStackId();
        if (service.getServiceComponent(componentName).isClientComponent()) {
            return;
        }
        Set<String> needRestartServices = this.obdpMetaInfo.getRestartRequiredServicesNames(stackId.getStackName(), stackId.getStackVersion());
        if (needRestartServices.contains(service.getName())) {
            Map<String, ServiceComponent> m = service.getServiceComponents();
            for (Map.Entry<String, ServiceComponent> entry : m.entrySet()) {
                ServiceComponent serviceComponent = entry.getValue();
                Map<String, ServiceComponentHost> schMap = serviceComponent.getServiceComponentHosts();
                for (Map.Entry<String, ServiceComponentHost> sch : schMap.entrySet()) {
                    ServiceComponentHost serviceComponentHost = sch.getValue();
                    serviceComponentHost.setRestartRequired(true);
                }
            }
        }
    }

    @Override
    public void registerRackChange(String clusterName) throws OBDPException {
        Cluster cluster = this.clusters.getCluster(clusterName);
        for (Service service : cluster.getServices().values()) {
            ServiceInfo serviceInfo = this.obdpMetaInfo.getService(service);
            if (!BooleanUtils.toBoolean((Boolean)serviceInfo.isRestartRequiredAfterRackChange())) continue;
            Map<String, ServiceComponent> serviceComponents = service.getServiceComponents();
            for (ServiceComponent serviceComponent : serviceComponents.values()) {
                Map<String, ServiceComponentHost> schMap = serviceComponent.getServiceComponentHosts();
                for (Map.Entry<String, ServiceComponentHost> sch : schMap.entrySet()) {
                    ServiceComponentHost serviceComponentHost = sch.getValue();
                    serviceComponentHost.setRestartRequired(true);
                }
            }
        }
    }

    @Override
    public synchronized ConfigurationResponse createConfiguration(ConfigurationRequest request, boolean refreshCluster) throws OBDPException, AuthorizationException {
        Map<String, Config> configs;
        Map<PropertyInfo.PropertyType, Set<String>> propertiesTypes;
        String refValue;
        Object ref;
        String passwordPropertyValue;
        if (null == request.getClusterName() || request.getClusterName().isEmpty() || null == request.getType() || request.getType().isEmpty() || null == request.getProperties()) {
            throw new IllegalArgumentException("Invalid Arguments, clustername, config type and configs should not be null or empty");
        }
        Cluster cluster = this.clusters.getCluster(request.getClusterName());
        String configType = request.getType();
        String service = cluster.getServiceByConfigType(configType);
        Map<String, String[]> propertyChanges = this.getPropertyChanges(cluster, request);
        if (StringUtils.isEmpty((String)service)) {
            this.validateAuthorizationToManageServiceAutoStartConfiguration(cluster, configType, propertyChanges);
            this.validateAuthorizationToModifyConfigurations(cluster, configType, propertyChanges, Collections.singletonMap("cluster-env", Collections.singleton("recovery_enabled")), false);
        } else {
            this.validateAuthorizationToModifyConfigurations(cluster, configType, propertyChanges, null, true);
            this.validateAuthorizationToUpdateServiceUsersAndGroups(cluster, configType, propertyChanges);
        }
        Map<String, String> requestProperties = request.getProperties();
        Map<String, Map<String, String>> requestPropertiesAttributes = request.getPropertiesAttributes();
        if (requestPropertiesAttributes != null && requestPropertiesAttributes.containsKey(PASSWORD)) {
            for (Map.Entry<String, String> requestEntry : requestPropertiesAttributes.get(PASSWORD).entrySet()) {
                String passwordProperty = (String)requestEntry.getKey();
                if (!requestProperties.containsKey(passwordProperty) || !((String)requestEntry.getValue()).equals("true") || !SecretReference.isSecret(passwordPropertyValue = requestProperties.get(passwordProperty))) continue;
                ref = new SecretReference(passwordPropertyValue, cluster);
                refValue = ((SecretReference)ref).getValue();
                requestProperties.put(passwordProperty, refValue);
            }
        }
        if ((propertiesTypes = cluster.getConfigPropertiesTypes(request.getType())).containsKey((Object)PropertyInfo.PropertyType.PASSWORD)) {
            for (String passwordProperty : propertiesTypes.get((Object)PropertyInfo.PropertyType.PASSWORD)) {
                if (!requestProperties.containsKey(passwordProperty) || !SecretReference.isSecret(passwordPropertyValue = requestProperties.get(passwordProperty))) continue;
                ref = new SecretReference(passwordPropertyValue, cluster);
                refValue = ((SecretReference)ref).getValue();
                requestProperties.put(passwordProperty, refValue);
            }
        }
        if (null == (configs = cluster.getConfigsByType(request.getType()))) {
            configs = new HashMap<String, Config>();
        }
        HashMap<String, Map<String, String>> propertiesAttributes = new HashMap<String, Map<String, String>>();
        HashSet<StackId> visitedStacks = new HashSet<StackId>();
        for (Service clusterService : cluster.getServices().values()) {
            StackId stackId = clusterService.getDesiredStackId();
            StackInfo stackInfo = this.obdpMetaInfo.getStack(clusterService.getDesiredStackId());
            if (visitedStacks.contains(stackId)) continue;
            Map<String, Map<String, String>> defaultConfigAttributes = stackInfo.getDefaultConfigAttributesForConfigType(configType);
            if (null != defaultConfigAttributes) {
                ConfigHelper.mergeConfigAttributes(propertiesAttributes, defaultConfigAttributes);
            }
            visitedStacks.add(stackId);
        }
        if (requestPropertiesAttributes != null) {
            ConfigHelper.mergeConfigAttributes(propertiesAttributes, requestPropertiesAttributes);
        }
        if (configs.containsKey(request.getVersionTag())) {
            throw new OBDPException(MessageFormat.format("Configuration with tag ''{0}'' exists for ''{1}''", request.getVersionTag(), request.getType()));
        }
        StackId stackId = null;
        if (null != service) {
            try {
                Service svc = cluster.getService(service);
                stackId = svc.getDesiredStackId();
            }
            catch (OBDPException ambariException) {
                LOG.warn("Adding configurations for {} even though its parent service {} is not installed", (Object)configType, (Object)service);
            }
        }
        if (null == stackId) {
            stackId = cluster.getDesiredStackVersion();
        }
        Config config = this.createConfig(cluster, stackId, request.getType(), requestProperties, request.getVersionTag(), propertiesAttributes, refreshCluster);
        LOG.info(MessageFormat.format("Creating configuration with tag ''{0}'' to cluster ''{1}''  for configuration type {2}", request.getVersionTag(), request.getClusterName(), configType));
        return new ConfigurationResponse(cluster.getClusterName(), config);
    }

    @Override
    public synchronized ConfigurationResponse createConfiguration(ConfigurationRequest request) throws OBDPException, AuthorizationException {
        return this.createConfiguration(request, true);
    }

    @Override
    public Config createConfig(Cluster cluster, StackId stackId, String type, Map<String, String> properties, String versionTag, Map<String, Map<String, String>> propertiesAttributes, boolean refreshCluster) {
        Config config = this.configFactory.createNew(stackId, type, cluster, versionTag, properties, propertiesAttributes, refreshCluster);
        cluster.addConfig(config);
        return config;
    }

    @Override
    public Config createConfig(Cluster cluster, StackId stackId, String type, Map<String, String> properties, String versionTag, Map<String, Map<String, String>> propertiesAttributes) {
        return this.createConfig(cluster, stackId, type, properties, versionTag, propertiesAttributes, true);
    }

    @Override
    public void createGroups(Set<GroupRequest> requests) throws OBDPException {
        for (GroupRequest request : requests) {
            if (StringUtils.isBlank((String)request.getGroupName())) {
                throw new OBDPException("Group name must be supplied.");
            }
            Group group = this.users.getGroup(request.getGroupName());
            if (group != null) {
                throw new OBDPException("Group already exists.");
            }
            this.users.createGroup(request.getGroupName(), GroupType.LOCAL);
        }
    }

    @Override
    public void createMembers(Set<MemberRequest> requests) throws OBDPException {
        for (MemberRequest request : requests) {
            if (StringUtils.isBlank((String)request.getGroupName()) || StringUtils.isBlank((String)request.getUserName())) {
                throw new OBDPException("Both group name and user name must be supplied.");
            }
            this.users.addMemberToGroup(request.getGroupName(), request.getUserName());
        }
    }

    @Override
    public Set<MemberResponse> getMembers(Set<MemberRequest> requests) throws OBDPException {
        HashSet<MemberResponse> responses = new HashSet<MemberResponse>();
        for (MemberRequest request : requests) {
            LOG.debug("Received a getMembers request, {}", (Object)request);
            Group group = this.users.getGroup(request.getGroupName());
            if (null == group) {
                if (requests.size() != 1) continue;
                throw new ObjectNotFoundException("Cannot find group '" + request.getGroupName() + "'");
            }
            for (User user : this.users.getGroupMembers(group.getGroupName())) {
                MemberResponse response = new MemberResponse(group.getGroupName(), user.getUserName());
                responses.add(response);
            }
        }
        return responses;
    }

    @Override
    public synchronized void updateMembers(Set<MemberRequest> requests) throws OBDPException {
        String groupName = null;
        for (MemberRequest memberRequest : requests) {
            if (groupName != null && !memberRequest.getGroupName().equals(groupName)) {
                throw new OBDPException("Can't manage members of different groups in one request");
            }
            groupName = memberRequest.getGroupName();
        }
        ArrayList<String> requiredMembers = new ArrayList<String>();
        for (MemberRequest request : requests) {
            if (request.getUserName() == null) continue;
            requiredMembers.add(request.getUserName());
        }
        List<String> list = this.users.getAllMembers(groupName);
        for (String user : CollectionUtils.subtract(list, requiredMembers)) {
            this.users.removeMemberFromGroup(groupName, user);
        }
        for (String user : CollectionUtils.subtract(requiredMembers, list)) {
            this.users.addMemberToGroup(groupName, user);
        }
    }

    private Stage createNewStage(long id, Cluster cluster, long requestId, String requestContext, String commandParamsStage, String hostParamsStage) {
        String logDir = BASE_LOG_DIR + File.pathSeparator + requestId;
        Stage stage = this.stageFactory.createNew(requestId, logDir, null == cluster ? null : cluster.getClusterName(), null == cluster ? -1L : cluster.getClusterId(), requestContext, commandParamsStage, hostParamsStage);
        stage.setStageId(id);
        return stage;
    }

    private Set<ClusterResponse> getClusters(ClusterRequest request) throws OBDPException, AuthorizationException {
        HashSet<ClusterResponse> response = new HashSet<ClusterResponse>();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received a getClusters request, clusterName={}, clusterId={}, stackInfo={}", new Object[]{request.getClusterName(), request.getClusterId(), request.getStackVersion()});
        }
        Cluster singleCluster = null;
        try {
            if (request.getClusterName() != null) {
                singleCluster = this.clusters.getCluster(request.getClusterName());
            } else if (request.getClusterId() != null) {
                singleCluster = this.clusters.getClusterById(request.getClusterId());
            }
        }
        catch (ClusterNotFoundException e) {
            if (AuthorizationHelper.isAuthorized(ResourceType.OBDP, null, RoleAuthorization.OBDP_ADD_DELETE_CLUSTERS)) {
                throw e;
            }
            throw new AuthorizationException();
        }
        if (singleCluster != null) {
            ClusterResponse cr = singleCluster.convertToResponse();
            cr.setDesiredConfigs(singleCluster.getDesiredConfigs());
            cr.setDesiredServiceConfigVersions(singleCluster.getActiveServiceConfigVersions());
            cr.setCredentialStoreServiceProperties(this.getCredentialStoreServiceProperties());
            response.add(cr);
            return response;
        }
        Map<String, Cluster> allClusters = this.clusters.getClusters();
        for (Cluster c : allClusters.values()) {
            ClusterResponse cr = c.convertToResponse();
            cr.setDesiredConfigs(c.getDesiredConfigs());
            cr.setDesiredServiceConfigVersions(c.getActiveServiceConfigVersions());
            cr.setCredentialStoreServiceProperties(this.getCredentialStoreServiceProperties());
            response.add(cr);
        }
        StringBuilder builder = new StringBuilder();
        if (LOG.isDebugEnabled()) {
            this.clusters.debugDump(builder);
            LOG.debug("Cluster State for cluster {}", (Object)builder);
        }
        return response;
    }

    private Set<ServiceComponentHostResponse> getHostComponents(ServiceComponentHostRequest request) throws OBDPException {
        return this.getHostComponents(request, false);
    }

    private Set<ServiceComponentHostResponse> getHostComponents(ServiceComponentHostRequest request, boolean statusOnly) throws OBDPException {
        Cluster cluster;
        LOG.debug("Processing request {}", (Object)request);
        if (request.getClusterName() == null || request.getClusterName().isEmpty()) {
            IllegalArgumentException e = new IllegalArgumentException("Invalid arguments, cluster name should not be null");
            LOG.debug("Cluster not specified in request", (Throwable)e);
            throw e;
        }
        try {
            cluster = this.clusters.getCluster(request.getClusterName());
        }
        catch (ClusterNotFoundException e) {
            LOG.error("Cluster not found ", (Throwable)((Object)e));
            throw new ParentObjectNotFoundException("Parent Cluster resource doesn't exist", e);
        }
        if (request.getHostname() != null) {
            try {
                if (!this.clusters.getClustersForHost(request.getHostname()).contains(cluster)) {
                    LOG.error("Host doesn't belong to cluster - " + request.getHostname());
                    throw new ParentObjectNotFoundException("Parent Host resource doesn't exist", new HostNotFoundException(request.getClusterName(), request.getHostname()));
                }
            }
            catch (HostNotFoundException e) {
                LOG.error("Host not found", (Throwable)((Object)e));
                throw new ParentObjectNotFoundException("Parent Host resource doesn't exist", new HostNotFoundException(request.getClusterName(), request.getHostname()));
            }
        }
        if (request.getComponentName() != null && StringUtils.isBlank((String)request.getServiceName())) {
            String serviceName = this.findServiceName(cluster, request.getComponentName());
            if (StringUtils.isBlank((String)serviceName)) {
                LOG.error("Unable to find service for component {}", (Object)request.getComponentName());
                throw new ServiceComponentHostNotFoundException(cluster.getClusterName(), null, request.getComponentName(), request.getHostname());
            }
            request.setServiceName(serviceName);
        }
        HashSet<Service> services = new HashSet<Service>();
        if (request.getServiceName() != null && !request.getServiceName().isEmpty()) {
            services.add(cluster.getService(request.getServiceName()));
        } else {
            services.addAll(cluster.getServices().values());
        }
        HashSet<ServiceComponentHostResponse> response = new HashSet<ServiceComponentHostResponse>();
        boolean checkDesiredState = false;
        State desiredStateToCheck = null;
        boolean checkState = false;
        State stateToCheck = null;
        boolean filterBasedConfigStaleness = false;
        boolean staleConfig = true;
        if (request.getStaleConfig() != null) {
            filterBasedConfigStaleness = true;
            staleConfig = "true".equals(request.getStaleConfig().toLowerCase());
        }
        if (request.getDesiredState() != null && !request.getDesiredState().isEmpty()) {
            desiredStateToCheck = State.valueOf(request.getDesiredState());
            if (!desiredStateToCheck.isValidDesiredState()) {
                throw new IllegalArgumentException("Invalid arguments, invalid desired state, desiredState=" + desiredStateToCheck);
            }
            checkDesiredState = true;
        }
        if (!StringUtils.isEmpty((String)request.getState())) {
            stateToCheck = State.valueOf(request.getState());
            if (stateToCheck == null) {
                throw new IllegalArgumentException("Invalid arguments, invalid state, State=" + request.getState());
            }
            checkState = true;
        }
        Map<String, DesiredConfig> desiredConfigs = cluster.getDesiredConfigs();
        Map<String, Host> hosts = this.clusters.getHostsForCluster(cluster.getClusterName());
        for (Service s : services) {
            HashSet<ServiceComponent> components = new HashSet<ServiceComponent>();
            if (request.getComponentName() != null) {
                components.add(s.getServiceComponent(request.getComponentName()));
            } else {
                components.addAll(s.getServiceComponents().values());
            }
            for (ServiceComponent sc : components) {
                if (request.getComponentName() != null && !sc.getName().equals(request.getComponentName())) continue;
                Map<String, ServiceComponentHost> serviceComponentHostMap = sc.getServiceComponentHosts();
                if (request.getHostname() != null) {
                    try {
                        ServiceComponentHostResponse r;
                        if (serviceComponentHostMap == null || !serviceComponentHostMap.containsKey(request.getHostname())) {
                            throw new ServiceComponentHostNotFoundException(cluster.getClusterName(), s.getName(), sc.getName(), request.getHostname());
                        }
                        ServiceComponentHost sch = serviceComponentHostMap.get(request.getHostname());
                        if (null == sch || checkDesiredState && desiredStateToCheck != sch.getDesiredState() || checkState && stateToCheck != sch.getState()) continue;
                        if (request.getAdminState() != null) {
                            String stringToMatch;
                            String string = stringToMatch = sch.getComponentAdminState() == null ? "" : sch.getComponentAdminState().name();
                            if (!request.getAdminState().equals(stringToMatch)) continue;
                        }
                        if (null == (r = statusOnly ? sch.convertToResponseStatusOnly(desiredConfigs, filterBasedConfigStaleness) : sch.convertToResponse(desiredConfigs)) || filterBasedConfigStaleness && r.isStaleConfig() != staleConfig) continue;
                        Host host = hosts.get(sch.getHostName());
                        if (host == null) {
                            throw new HostNotFoundException(cluster.getClusterName(), sch.getHostName());
                        }
                        MaintenanceState effectiveMaintenanceState = this.maintenanceStateHelper.getEffectiveState(sch, host);
                        if (this.filterByMaintenanceState(request, effectiveMaintenanceState)) continue;
                        r.setMaintenanceState(effectiveMaintenanceState.name());
                        response.add(r);
                        continue;
                    }
                    catch (ServiceComponentHostNotFoundException e) {
                        if (request.getServiceName() == null || request.getComponentName() == null) {
                            LOG.debug("Ignoring not specified host_component ", (Throwable)((Object)e));
                            continue;
                        }
                        LOG.debug("ServiceComponentHost not found ", (Throwable)((Object)e));
                        throw new ServiceComponentHostNotFoundException(cluster.getClusterName(), request.getServiceName(), request.getComponentName(), request.getHostname());
                    }
                }
                for (ServiceComponentHost sch : serviceComponentHostMap.values()) {
                    ServiceComponentHostResponse r;
                    if (null == sch || checkDesiredState && desiredStateToCheck != sch.getDesiredState() || checkState && stateToCheck != sch.getState()) continue;
                    if (request.getAdminState() != null) {
                        String stringToMatch;
                        String string = stringToMatch = sch.getComponentAdminState() == null ? "" : sch.getComponentAdminState().name();
                        if (!request.getAdminState().equals(stringToMatch)) continue;
                    }
                    if (null == (r = statusOnly ? sch.convertToResponseStatusOnly(desiredConfigs, filterBasedConfigStaleness) : sch.convertToResponse(desiredConfigs)) || filterBasedConfigStaleness && r.isStaleConfig() != staleConfig) continue;
                    Host host = hosts.get(sch.getHostName());
                    if (host == null) {
                        throw new HostNotFoundException(cluster.getClusterName(), sch.getHostName());
                    }
                    MaintenanceState effectiveMaintenanceState = this.maintenanceStateHelper.getEffectiveState(sch, host);
                    if (this.filterByMaintenanceState(request, effectiveMaintenanceState)) continue;
                    r.setMaintenanceState(effectiveMaintenanceState.name());
                    response.add(r);
                }
            }
        }
        return response;
    }

    private boolean filterByMaintenanceState(ServiceComponentHostRequest request, MaintenanceState effectiveMaintenanceState) {
        MaintenanceState desiredMaintenanceState;
        return request.getMaintenanceState() != null && ((desiredMaintenanceState = MaintenanceState.valueOf(request.getMaintenanceState())).equals((Object)MaintenanceState.ON) ? effectiveMaintenanceState.equals((Object)MaintenanceState.OFF) : !desiredMaintenanceState.equals((Object)effectiveMaintenanceState));
    }

    @Override
    public MaintenanceState getEffectiveMaintenanceState(ServiceComponentHost sch) throws OBDPException {
        return this.maintenanceStateHelper.getEffectiveState(sch);
    }

    private Set<ConfigurationResponse> getConfigurations(ConfigurationRequest request) throws OBDPException {
        HashSet<ConfigurationResponse> responses;
        block4: {
            boolean includeProps;
            Cluster cluster;
            block5: {
                block3: {
                    if (request.getClusterName() == null) {
                        throw new IllegalArgumentException("Invalid arguments, cluster name should not be null");
                    }
                    cluster = this.clusters.getCluster(request.getClusterName());
                    responses = new HashSet<ConfigurationResponse>();
                    if (null == request.getType() || null == request.getVersionTag()) break block3;
                    Config config = cluster.getConfig(request.getType(), request.getVersionTag());
                    if (null == config) break block4;
                    ConfigurationResponse response = new ConfigurationResponse(cluster.getClusterName(), config);
                    responses.add(response);
                    break block4;
                }
                includeProps = request.includeProperties();
                if (null == request.getType()) break block5;
                Map<String, Config> configs = cluster.getConfigsByType(request.getType());
                if (null == configs) break block4;
                for (Map.Entry<String, Config> entry : configs.entrySet()) {
                    Config config = entry.getValue();
                    ConfigurationResponse response = new ConfigurationResponse(cluster.getClusterName(), config.getStackId(), request.getType(), config.getTag(), entry.getValue().getVersion(), includeProps ? config.getProperties() : new HashMap<String, String>(), includeProps ? config.getPropertiesAttributes() : new HashMap<String, Map<String, String>>(), config.getPropertiesTypes());
                    responses.add(response);
                }
                break block4;
            }
            Collection<Config> all = cluster.getAllConfigs();
            for (Config config : all) {
                ConfigurationResponse response = new ConfigurationResponse(cluster.getClusterName(), config.getStackId(), config.getType(), config.getTag(), config.getVersion(), includeProps ? config.getProperties() : new HashMap<String, String>(), includeProps ? config.getPropertiesAttributes() : new HashMap<String, Map<String, String>>(), config.getPropertiesTypes());
                responses.add(response);
            }
        }
        return responses;
    }

    @Override
    @Transactional
    public synchronized RequestStatusResponse updateClusters(Set<ClusterRequest> requests, Map<String, String> requestProperties) throws OBDPException, AuthorizationException {
        return this.updateClusters(requests, requestProperties, true, true);
    }

    @Override
    @Transactional
    public synchronized RequestStatusResponse updateClusters(Set<ClusterRequest> requests, Map<String, String> requestProperties, boolean fireAgentUpdates, boolean refreshCluster) throws OBDPException, AuthorizationException {
        RequestStatusResponse response = null;
        for (ClusterRequest request : requests) {
            response = this.updateCluster(request, requestProperties, fireAgentUpdates, refreshCluster);
        }
        return response;
    }

    private Map<String, String> getConfigKeyDeltaToAction(Config existingConfig, Map<String, String> newConfigValues) {
        HashMap<String, String> configsChanged = new HashMap<String, String>();
        if (null != existingConfig) {
            Map<String, String> existingConfigValues = existingConfig.getProperties();
            for (Map.Entry<String, String> pair : existingConfigValues.entrySet()) {
                if (newConfigValues.containsKey(pair.getKey())) {
                    if (newConfigValues.get(pair.getKey()).equals(pair.getValue())) continue;
                    configsChanged.put(pair.getKey(), "changed");
                    continue;
                }
                configsChanged.put(pair.getKey(), "deleted");
            }
            for (Map.Entry<String, String> pair : newConfigValues.entrySet()) {
                if (existingConfigValues.keySet().contains(pair.getKey())) continue;
                configsChanged.put(pair.getKey(), "added");
            }
        } else {
            for (String key : newConfigValues.keySet()) {
                configsChanged.put(key, "added");
            }
        }
        return configsChanged;
    }

    private Map<String, List<String>> inverseMapByValue(Map<String, String> configKeyToAction) {
        HashMap<String, List<String>> mapByValue = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> pair : configKeyToAction.entrySet()) {
            if (mapByValue.containsKey(pair.getValue())) {
                ((List)mapByValue.get(pair.getValue())).add(pair.getKey());
                continue;
            }
            ArrayList<String> configListForAction = new ArrayList<String>();
            configListForAction.add(pair.getKey());
            mapByValue.put(pair.getValue(), configListForAction);
        }
        return mapByValue;
    }

    private String getActionToConfigListAsString(Map<String, List<String>> actionToConfigKeyList) {
        Object output = "";
        String[] actions = new String[]{"added", "deleted", "changed"};
        int i = 0;
        for (String action : actions) {
            ++i;
            output = (String)output + action + ": [";
            if (actionToConfigKeyList.containsKey(action)) {
                List<String> values = actionToConfigKeyList.get(action);
                output = (String)output + StringUtils.join(values, (String)", ");
            }
            output = i < actions.length ? (String)output + "], " : (String)output + "]";
        }
        return output;
    }

    private synchronized RequestStatusResponse updateCluster(ClusterRequest request, Map<String, String> requestProperties, boolean fireAgentUpdates, boolean refreshCluster) throws OBDPException, AuthorizationException {
        SecurityType securityType;
        boolean requiresHostListUpdate;
        RequestStageContainer requestStageContainer = null;
        if (request.getClusterId() == null && (request.getClusterName() == null || request.getClusterName().isEmpty())) {
            throw new IllegalArgumentException("Invalid arguments, cluster id or cluster name should not be null");
        }
        LOG.info("Received a updateCluster request, clusterId=" + request.getClusterId() + ", clusterName=" + request.getClusterName() + ", securityType=" + request.getSecurityType() + ", request=" + request);
        Cluster cluster = request.getClusterId() == null ? this.clusters.getCluster(request.getClusterName()) : this.clusters.getClusterById(request.getClusterId());
        List<ConfigurationRequest> desiredConfigs = request.getDesiredConfig();
        if (desiredConfigs != null) {
            for (ConfigurationRequest configurationRequest : desiredConfigs) {
                if (!StringUtils.isEmpty((String)configurationRequest.getVersionTag())) continue;
                configurationRequest.setVersionTag(UUID.randomUUID().toString());
            }
        }
        AuthorizationHelper.verifyAuthorization(ResourceType.CLUSTER, cluster.getResourceId(), RoleAuthorization.AUTHORIZATIONS_UPDATE_CLUSTER);
        LinkedList<ConfigurationResponse> configurationResponses = new LinkedList<ConfigurationResponse>();
        ServiceConfigVersionResponse serviceConfigVersionResponse = null;
        boolean nonServiceConfigsChanged = false;
        if (desiredConfigs != null && request.getServiceConfigVersionRequest() != null) {
            String msg = "Unable to set desired configs and rollback at same time, request = " + request;
            LOG.error(msg);
            throw new IllegalArgumentException(msg);
        }
        if (request.getClusterName() != null && !cluster.getClusterName().equals(request.getClusterName())) {
            OBDPManagementControllerImpl.validateClusterName(request.getClusterName());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received cluster name change request from {} to {}", (Object)cluster.getClusterName(), (Object)request.getClusterName());
            }
            if (!AuthorizationHelper.isAuthorized(ResourceType.OBDP, null, EnumSet.of(RoleAuthorization.OBDP_RENAME_CLUSTER))) {
                throw new AuthorizationException("The authenticated user does not have authorization to rename the cluster");
            }
            cluster.setClusterName(request.getClusterName());
        }
        boolean isConfigurationCreationNeeded = false;
        if (desiredConfigs != null) {
            block5: for (ConfigurationRequest desiredConfig : desiredConfigs) {
                Object existingConfig;
                Map<String, String> requestConfigProperties = desiredConfig.getProperties();
                Map<String, Map<String, String>> map = desiredConfig.getPropertiesAttributes();
                if (requestConfigProperties != null && !requestConfigProperties.isEmpty()) {
                    Map<PropertyInfo.PropertyType, Set<String>> propertiesTypes = cluster.getConfigPropertiesTypes(desiredConfig.getType());
                    for (Map.Entry property : requestConfigProperties.entrySet()) {
                        String propertyName = (String)property.getKey();
                        String propertyValue = (String)property.getValue();
                        if ((!propertiesTypes.containsKey((Object)PropertyInfo.PropertyType.PASSWORD) || !propertiesTypes.get((Object)PropertyInfo.PropertyType.PASSWORD).contains(propertyName)) && (map == null || !map.containsKey(PASSWORD) || !map.get(PASSWORD).containsKey(propertyName) || !map.get(PASSWORD).get(propertyName).equals("true")) || !SecretReference.isSecret(propertyValue)) continue;
                        SecretReference ref = new SecretReference(propertyValue, cluster);
                        requestConfigProperties.put(propertyName, ref.getValue());
                    }
                }
                Config clusterConfig = cluster.getDesiredConfigByType(desiredConfig.getType());
                Map<String, String> clusterConfigProperties = null;
                Map<String, Map<String, String>> clusterConfigAttributes = null;
                if (clusterConfig != null) {
                    clusterConfigProperties = clusterConfig.getProperties();
                    clusterConfigAttributes = clusterConfig.getPropertiesAttributes();
                    if (!this.isAttributeMapsEqual(map, clusterConfigAttributes)) {
                        isConfigurationCreationNeeded = true;
                        break;
                    }
                } else {
                    isConfigurationCreationNeeded = true;
                    break;
                }
                if ((requestConfigProperties == null || requestConfigProperties.isEmpty()) && (existingConfig = cluster.getConfig(desiredConfig.getType(), desiredConfig.getVersionTag())) != null && !StringUtils.equals((String)existingConfig.getTag(), (String)clusterConfig.getTag())) {
                    isConfigurationCreationNeeded = true;
                    break;
                }
                if (requestConfigProperties == null || clusterConfigProperties == null) continue;
                if (requestConfigProperties.size() != clusterConfigProperties.size()) {
                    isConfigurationCreationNeeded = true;
                    break;
                }
                if (cluster.getServiceByConfigType(clusterConfig.getType()) != null && clusterConfig.getServiceConfigVersions().isEmpty()) {
                    LOG.warn("Existing desired config doesn't belong to any service config version, forcing config recreation, clusterName={}, type = {}, tag={}", new Object[]{cluster.getClusterName(), clusterConfig.getType(), clusterConfig.getTag()});
                    isConfigurationCreationNeeded = true;
                    break;
                }
                existingConfig = requestConfigProperties.entrySet().iterator();
                while (existingConfig.hasNext()) {
                    Map.Entry property = (Map.Entry)existingConfig.next();
                    if (StringUtils.equals((String)((String)property.getValue()), (String)clusterConfigProperties.get(property.getKey()))) continue;
                    isConfigurationCreationNeeded = true;
                    continue block5;
                }
            }
        }
        if (isConfigurationCreationNeeded && !desiredConfigs.isEmpty()) {
            HashSet<Config> configs = new HashSet<Config>();
            String note = null;
            for (ConfigurationRequest configurationRequest : desiredConfigs) {
                Map<String, Config> all;
                String configType = configurationRequest.getType();
                if (!(null == configurationRequest.getProperties() || null != (all = cluster.getConfigsByType(configType)) && all.containsKey(configurationRequest.getVersionTag()) && configurationRequest.getProperties().size() <= 0)) {
                    configurationRequest.setClusterName(cluster.getClusterName());
                    configurationResponses.add(this.createConfiguration(configurationRequest, refreshCluster));
                    LOG.info(MessageFormat.format("Applying configuration with tag ''{0}'' to cluster ''{1}''  for configuration type {2}", configurationRequest.getVersionTag(), request.getClusterName(), configType));
                }
                note = configurationRequest.getServiceConfigVersionNote();
                Config config = cluster.getConfig(configType, configurationRequest.getVersionTag());
                if (null == config) continue;
                configs.add(config);
            }
            if (!configs.isEmpty()) {
                HashMap<String, Config> existingConfigTypeToConfig = new HashMap<String, Config>();
                for (Config config : configs) {
                    Config existingConfig = cluster.getDesiredConfigByType(config.getType());
                    existingConfigTypeToConfig.put(config.getType(), existingConfig);
                }
                String string = this.getAuthName();
                serviceConfigVersionResponse = cluster.addDesiredConfig(string, configs, note);
                if (serviceConfigVersionResponse != null) {
                    List<String> hosts = serviceConfigVersionResponse.getHosts();
                    int numAffectedHosts = null != hosts ? hosts.size() : 0;
                    configChangeLog.info("(configchange) Changing default config. cluster: '{}', changed by: '{}', service_name: '{}', config_group: '{}', num affected hosts during creation: '{}', note: '{}'", new Object[]{request.getClusterName(), string, serviceConfigVersionResponse.getServiceName(), serviceConfigVersionResponse.getGroupName(), numAffectedHosts, serviceConfigVersionResponse.getNote()});
                    for (Config config : configs) {
                        config.getVersion();
                        serviceConfigVersionResponse.getNote();
                        configChangeLog.info("(configchange)    type: '{}', tag: '{}', version: '{}'", new Object[]{config.getType(), config.getTag(), config.getVersion()});
                        Map<String, String> configKeyToAction = this.getConfigKeyDeltaToAction((Config)existingConfigTypeToConfig.get(config.getType()), config.getProperties());
                        Map<String, List<String>> actionToListConfigKeys = this.inverseMapByValue(configKeyToAction);
                        if (actionToListConfigKeys.isEmpty()) continue;
                        String configOutput = this.getActionToConfigListAsString(actionToListConfigKeys);
                        configChangeLog.info("(configchange)    Config type '{}' was modified with the following keys, {}", (Object)config.getType(), (Object)configOutput);
                    }
                } else {
                    nonServiceConfigsChanged = true;
                }
            }
        }
        StackId currentVersion = cluster.getCurrentStackVersion();
        StackId desiredVersion = cluster.getDesiredStackVersion();
        if (currentVersion == null) {
            if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), EnumSet.of(RoleAuthorization.CLUSTER_UPGRADE_DOWNGRADE_STACK))) {
                throw new AuthorizationException("The authenticated user does not have authorization to modify stack version");
            }
            cluster.setCurrentStackVersion(desiredVersion);
        }
        boolean bl = requiresHostListUpdate = request.getHostNames() != null && !request.getHostNames().isEmpty();
        if (requiresHostListUpdate) {
            this.clusters.mapAndPublishHostsToCluster(request.getHostNames(), request.getClusterName());
        }
        if (null != request.getProvisioningState()) {
            boolean isStateTransitionValid;
            State state = cluster.getProvisioningState();
            State provisioningState = State.valueOf(request.getProvisioningState());
            if (provisioningState != State.INIT && provisioningState != State.INSTALLED) {
                LOG.warn("Invalid cluster provisioning state {} cannot be set on the cluster {}", (Object)provisioningState, (Object)request.getClusterName());
                throw new IllegalArgumentException("Invalid cluster provisioning state " + provisioningState + " cannot be set on cluster " + request.getClusterName());
            }
            if (provisioningState != state && !(isStateTransitionValid = State.isValidDesiredStateTransition(state, provisioningState))) {
                LOG.warn("Invalid cluster provisioning state {} cannot be set on the cluster {} because the current state is {}", new Object[]{provisioningState, request.getClusterName(), state});
                throw new OBDPException("Invalid transition for cluster provisioning state, clusterName=" + cluster.getClusterName() + ", clusterId=" + cluster.getClusterId() + ", currentProvisioningState=" + state + ", newProvisioningState=" + provisioningState);
            }
            cluster.setProvisioningState(provisioningState);
        }
        if (null != request.getServiceConfigVersionRequest()) {
            if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), EnumSet.of(RoleAuthorization.SERVICE_MODIFY_CONFIGS))) {
                throw new AuthorizationException("The authenticated user does not have authorization to modify service configurations");
            }
            ServiceConfigVersionRequest serviceConfigVersionRequest = request.getServiceConfigVersionRequest();
            if (StringUtils.isEmpty((String)serviceConfigVersionRequest.getServiceName()) || null == serviceConfigVersionRequest.getVersion()) {
                String msg = "Service name and version should be specified in service config version";
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
            serviceConfigVersionResponse = cluster.setServiceConfigVersion(serviceConfigVersionRequest.getServiceName(), serviceConfigVersionRequest.getVersion(), this.getAuthName(), serviceConfigVersionRequest.getNote());
        }
        if (serviceConfigVersionResponse != null) {
            if (!configurationResponses.isEmpty()) {
                serviceConfigVersionResponse.setConfigurations(configurationResponses);
            }
            ClusterResponse clusterResponse = new ClusterResponse(cluster.getClusterId(), cluster.getClusterName(), null, null, null, 0, null, null);
            HashMap<String, Collection<ServiceConfigVersionResponse>> map = new HashMap<String, Collection<ServiceConfigVersionResponse>>();
            map.put(serviceConfigVersionResponse.getServiceName(), Collections.singletonList(serviceConfigVersionResponse));
            clusterResponse.setDesiredServiceConfigVersions(map);
            this.saveClusterUpdate(request, clusterResponse);
        }
        if ((securityType = request.getSecurityType()) != null) {
            if (this.kerberosHelper.shouldExecuteCustomOperations(securityType, requestProperties)) {
                if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), EnumSet.of(RoleAuthorization.CLUSTER_TOGGLE_KERBEROS))) {
                    throw new AuthorizationException("The authenticated user does not have authorization to perform Kerberos-specific operations");
                }
                try {
                    requestStageContainer = this.kerberosHelper.executeCustomOperations(cluster, requestProperties, requestStageContainer, this.kerberosHelper.getManageIdentitiesDirective(requestProperties));
                }
                catch (KerberosOperationException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            } else {
                boolean forceToggleKerberos = this.kerberosHelper.getForceToggleKerberosDirective(requestProperties);
                if (forceToggleKerberos || cluster.getSecurityType() != securityType) {
                    LOG.info("Received cluster security type change request from {} to {} (forced: {})", new Object[]{cluster.getSecurityType().name(), securityType.name(), forceToggleKerberos});
                    if (securityType == SecurityType.KERBEROS || securityType == SecurityType.NONE) {
                        if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), EnumSet.of(RoleAuthorization.CLUSTER_TOGGLE_KERBEROS))) {
                            throw new AuthorizationException("The authenticated user does not have authorization to enable or disable Kerberos");
                        }
                        try {
                            requestStageContainer = this.kerberosHelper.toggleKerberos(cluster, securityType, requestStageContainer, this.kerberosHelper.getManageIdentitiesDirective(requestProperties));
                        }
                        catch (KerberosOperationException e) {
                            throw new IllegalArgumentException(e.getMessage(), e);
                        }
                    } else {
                        throw new IllegalArgumentException(String.format("Unexpected security type encountered: %s", securityType.name()));
                    }
                    cluster.setSecurityType(securityType);
                }
            }
        }
        if (fireAgentUpdates && (serviceConfigVersionResponse != null || nonServiceConfigsChanged)) {
            this.configHelper.updateAgentConfigs(Collections.singleton(cluster.getClusterName()));
        }
        if (requestStageContainer != null) {
            requestStageContainer.persist();
            return requestStageContainer.getRequestStatusResponse();
        }
        return null;
    }

    public static void validateClusterName(String clusterName) {
        if (clusterName == null) {
            throw new IllegalArgumentException("Invalid arguments, cluster name should not be null");
        }
        if (clusterName.isEmpty()) {
            throw new IllegalArgumentException("Invalid arguments, cluster name should not be empty");
        }
        Matcher mtch = CLUSTER_NAME_PTRN.matcher(clusterName);
        if (!mtch.matches()) {
            throw new IllegalArgumentException("Invalid arguments, cluster name should contains only alphabetical, numeric, '_' and '-' characters and length 1-100 characters");
        }
    }

    private Map<String, String[]> getPropertyChanges(Cluster cluster, ConfigurationRequest request) {
        Config existingConfig;
        Map<String, String> existingProperties;
        HashMap<String, String[]> changedProperties = new HashMap<String, String[]>();
        Map<String, String> requestedProperties = request.getProperties();
        if (requestedProperties == null) {
            requestedProperties = Collections.emptyMap();
        }
        Map<String, String> map = existingProperties = (existingConfig = cluster.getDesiredConfigByType(request.getType())) == null ? null : existingConfig.getProperties();
        if (existingProperties == null) {
            existingProperties = Collections.emptyMap();
        }
        HashSet<String> propertyNames = new HashSet<String>();
        propertyNames.addAll(requestedProperties.keySet());
        propertyNames.addAll(existingProperties.keySet());
        for (String propertyName : propertyNames) {
            String requestedValue = requestedProperties.get(propertyName);
            String existingValue = existingProperties.get(propertyName);
            if (!(requestedValue == null ? existingValue != null : !requestedValue.equals(existingValue))) continue;
            changedProperties.put(propertyName, new String[]{existingValue, requestedValue});
        }
        return changedProperties;
    }

    public boolean isAttributeMapsEqual(Map<String, Map<String, String>> requestConfigAttributes, Map<String, Map<String, String>> clusterConfigAttributes) {
        boolean isAttributesEqual = true;
        if (requestConfigAttributes != null && clusterConfigAttributes == null || requestConfigAttributes == null && clusterConfigAttributes != null || requestConfigAttributes != null && clusterConfigAttributes != null && !requestConfigAttributes.keySet().equals(clusterConfigAttributes.keySet())) {
            return false;
        }
        if (clusterConfigAttributes != null && requestConfigAttributes != null) {
            for (Map.Entry<String, Map<String, String>> ClusterEntrySet : clusterConfigAttributes.entrySet()) {
                Map<String, String> clusterMapAttributes = ClusterEntrySet.getValue();
                Map<String, String> requestMapAttributes = requestConfigAttributes.get(ClusterEntrySet.getKey());
                if (requestMapAttributes != null && clusterMapAttributes == null || requestMapAttributes == null && clusterMapAttributes != null || requestMapAttributes != null && clusterMapAttributes != null && !requestMapAttributes.keySet().equals(clusterMapAttributes.keySet())) {
                    return false;
                }
                if (requestMapAttributes == null || clusterMapAttributes == null) continue;
                for (Map.Entry<String, String> requestPropertyEntrySet : requestMapAttributes.entrySet()) {
                    String requestPropertyValue = requestPropertyEntrySet.getValue();
                    String clusterPropertyValue = clusterMapAttributes.get(requestPropertyEntrySet.getKey());
                    if (!(requestPropertyValue != null && clusterPropertyValue == null || requestPropertyValue == null && clusterPropertyValue != null) && (requestPropertyValue == null || clusterPropertyValue == null || requestPropertyValue.equals(clusterPropertyValue))) continue;
                    return false;
                }
            }
        }
        return isAttributesEqual;
    }

    public void saveClusterUpdate(ClusterRequest clusterRequest, ClusterResponse clusterResponse) {
        this.clusterUpdateCache.put((Object)clusterRequest, (Object)clusterResponse);
    }

    @Override
    public ClusterResponse getClusterUpdateResults(ClusterRequest clusterRequest) {
        return (ClusterResponse)this.clusterUpdateCache.getIfPresent((Object)clusterRequest);
    }

    @Override
    public ConfigGroupResponse getConfigGroupUpdateResults(ConfigGroupRequest configGroupRequest) {
        return (ConfigGroupResponse)this.configGroupUpdateCache.getIfPresent((Object)configGroupRequest);
    }

    @Override
    public void saveConfigGroupUpdate(ConfigGroupRequest configGroupRequest, ConfigGroupResponse configGroupResponse) {
        this.configGroupUpdateCache.put((Object)configGroupRequest, (Object)configGroupResponse);
    }

    @Override
    public String getJobTrackerHost(Cluster cluster) {
        try {
            Service svc = cluster.getService("MAPREDUCE");
            ServiceComponent sc = svc.getServiceComponent(Role.JOBTRACKER.toString());
            if (sc.getServiceComponentHosts() != null && !sc.getServiceComponentHosts().isEmpty()) {
                return sc.getServiceComponentHosts().keySet().iterator().next();
            }
        }
        catch (OBDPException ex) {
            return null;
        }
        return null;
    }

    private Set<String> getServicesForSmokeTests(Cluster cluster, Map<State, List<Service>> changedServices, Map<String, Map<State, List<ServiceComponentHost>>> changedScHosts, boolean runSmokeTest) throws OBDPException {
        Resource.Type opLvl = Resource.Type.Cluster;
        HashSet<String> smokeTestServices = new HashSet<String>();
        if (changedServices != null) {
            for (Map.Entry<State, List<Service>> entry : changedServices.entrySet()) {
                if (State.STARTED != entry.getKey()) continue;
                for (Service service : entry.getValue()) {
                    if (!runSmokeTest || State.INSTALLED != service.getDesiredState() || !this.maintenanceStateHelper.isOperationAllowed(opLvl, service)) continue;
                    smokeTestServices.add(service.getName());
                }
            }
        }
        HashMap changedComponentCount = new HashMap();
        for (Map<State, List<ServiceComponentHost>> map : changedScHosts.values()) {
            for (Map.Entry<State, List<ServiceComponentHost>> entry : map.entrySet()) {
                if (State.STARTED != entry.getKey()) continue;
                for (ServiceComponentHost sch : entry.getValue()) {
                    if (State.INSTALLED != sch.getState() || !this.maintenanceStateHelper.isOperationAllowed(opLvl, sch)) continue;
                    if (!changedComponentCount.containsKey(sch.getServiceName())) {
                        changedComponentCount.put(sch.getServiceName(), new HashMap());
                    }
                    if (!((Map)changedComponentCount.get(sch.getServiceName())).containsKey(sch.getServiceComponentName())) {
                        ((Map)changedComponentCount.get(sch.getServiceName())).put(sch.getServiceComponentName(), 1);
                        continue;
                    }
                    Integer i = (Integer)((Map)changedComponentCount.get(sch.getServiceName())).get(sch.getServiceComponentName());
                    i = i + 1;
                    ((Map)changedComponentCount.get(sch.getServiceName())).put(sch.getServiceComponentName(), i);
                }
            }
        }
        for (Map.Entry entry : changedComponentCount.entrySet()) {
            String string = (String)entry.getKey();
            Service s = cluster.getService(string);
            if (runSmokeTest && ((Map)entry.getValue()).size() > 1 && this.maintenanceStateHelper.isOperationAllowed(opLvl, s)) {
                smokeTestServices.add(string);
                continue;
            }
            for (String componentName : ((Map)changedComponentCount.get(string)).keySet()) {
                ServiceComponent sc = cluster.getService(string).getServiceComponent(componentName);
                StackId stackId = sc.getDesiredStackId();
                ComponentInfo compInfo = this.obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), string, componentName);
                if (!runSmokeTest || !compInfo.isMaster() || !this.maintenanceStateHelper.isOperationAllowed(opLvl, s)) continue;
                smokeTestServices.add(string);
            }
        }
        return smokeTestServices;
    }

    private void addClientSchForReinstall(Cluster cluster, Map<State, List<Service>> changedServices, Map<String, Map<State, List<ServiceComponentHost>>> changedScHosts) throws OBDPException {
        HashSet<String> services = new HashSet<String>();
        if (changedServices != null) {
            for (Map.Entry<State, List<Service>> entry : changedServices.entrySet()) {
                if (State.STARTED != entry.getKey()) continue;
                for (Service service : entry.getValue()) {
                    if (State.INSTALLED != service.getDesiredState()) continue;
                    services.add(service.getName());
                }
            }
        }
        ArrayList serviceComponentHosts = new ArrayList();
        if (changedScHosts != null && !changedScHosts.isEmpty()) {
            for (Map.Entry<String, Map<State, List<ServiceComponentHost>>> stringMapEntry : changedScHosts.entrySet()) {
                for (State state : stringMapEntry.getValue().keySet()) {
                    if (state != State.STARTED) continue;
                    serviceComponentHosts.addAll(stringMapEntry.getValue().get((Object)state));
                }
            }
        }
        if (!serviceComponentHosts.isEmpty()) {
            for (ServiceComponentHost sch : serviceComponentHosts) {
                services.add(sch.getServiceName());
            }
        }
        if (services.isEmpty()) {
            return;
        }
        HashMap hashMap = new HashMap();
        for (String string : services) {
            Service s = cluster.getService(string);
            for (String component : s.getServiceComponents().keySet()) {
                ArrayList<ServiceComponentHost> potentialHosts = new ArrayList<ServiceComponentHost>();
                ServiceComponent sc = s.getServiceComponents().get(component);
                if (sc.isClientComponent()) {
                    for (ServiceComponentHost potentialSch : sc.getServiceComponentHosts().values()) {
                        Host host = this.clusters.getHost(potentialSch.getHostName());
                        if (potentialSch.getHostState().equals((Object)HostState.HEARTBEAT_LOST) || potentialSch.getMaintenanceState() == MaintenanceState.ON || host.getMaintenanceState(cluster.getClusterId()) != MaintenanceState.OFF) continue;
                        potentialHosts.add(potentialSch);
                    }
                }
                if (potentialHosts.isEmpty()) continue;
                hashMap.put(sc.getName(), potentialHosts);
            }
        }
        LOG.info("Client hosts for reinstall : " + hashMap.size());
        if (changedScHosts != null) {
            for (Map.Entry entry : hashMap.entrySet()) {
                EnumMap<State, List> schMap = new EnumMap<State, List>(State.class);
                schMap.put(State.INSTALLED, (List)entry.getValue());
                changedScHosts.put((String)entry.getKey(), schMap);
            }
        }
    }

    @Override
    public Map<String, Map<String, String>> findConfigurationTagsWithOverrides(Cluster cluster, String hostName, @Nullable Map<String, DesiredConfig> desiredConfigs) throws OBDPException {
        return this.configHelper.getEffectiveDesiredTags(cluster, hostName, desiredConfigs);
    }

    @Override
    public RequestExecutionFactory getRequestExecutionFactory() {
        return this.requestExecutionFactory;
    }

    @Override
    public ExecutionScheduleManager getExecutionScheduleManager() {
        return this.executionScheduleManager;
    }

    private void createHostAction(Cluster cluster, Stage stage, ServiceComponentHost scHost, RoleCommand roleCommand, Map<String, String> commandParamsInp, ServiceComponentHostEvent event, boolean skipFailure, RepositoryVersionEntity repoVersion, boolean isUpgradeSuspended, Configuration.DatabaseType databaseType, Map<String, DesiredConfig> clusterDesiredConfigs, boolean useLatestConfigs) throws OBDPException {
        CommandRepository commandRepository;
        String repoInfo;
        File customCache;
        String actualTimeout;
        String serviceName = scHost.getServiceName();
        stage.addHostRoleExecutionCommand(scHost.getHost(), Role.valueOf(scHost.getServiceComponentName()), roleCommand, event, cluster, serviceName, false, skipFailure);
        String componentName = scHost.getServiceComponentName();
        String hostname = scHost.getHostName();
        Host host = this.clusters.getHost(hostname);
        HostEntity hostEntity = host.getHostEntity();
        Map hostAttributes = (Map)this.gson.fromJson(hostEntity.getHostAttributes(), hostAttributesType);
        String osFamily = host.getOSFamilyFromHostAttributes(hostAttributes);
        StackId stackId = scHost.getServiceComponent().getDesiredStackId();
        ServiceInfo serviceInfo = this.obdpMetaInfo.getService(stackId.getStackName(), stackId.getStackVersion(), serviceName);
        ComponentInfo componentInfo = this.obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), serviceName, componentName);
        StackInfo stackInfo = this.obdpMetaInfo.getStack(stackId.getStackName(), stackId.getStackVersion());
        Map<String, ServiceInfo> servicesMap = this.obdpMetaInfo.getServices(stackInfo.getName(), stackInfo.getVersion());
        ExecutionCommandWrapper execCmdWrapper = stage.getExecutionCommandWrapper(hostname, componentName);
        ExecutionCommand execCmd = execCmdWrapper.getExecutionCommand();
        execCmd.setConfigurations(new TreeMap<String, Map<String, String>>());
        Service clusterService = cluster.getService(serviceName);
        execCmd.setCredentialStoreEnabled(String.valueOf(clusterService.isCredentialStoreEnabled()));
        ServiceComponent component = clusterService.getServiceComponent(componentName);
        Map<String, Map<String, String>> configCredentials = this.configCredentialsForService.get(clusterService.getName());
        if (configCredentials == null) {
            configCredentials = this.configHelper.getCredentialStoreEnabledProperties(stackId, clusterService);
            this.configCredentialsForService.put(clusterService.getName(), configCredentials);
        }
        execCmd.setConfigurationCredentials(configCredentials);
        TreeMap<String, String> commandParams = new TreeMap<String, String>();
        if (commandParamsInp != null) {
            commandParams.putAll(commandParamsInp);
        }
        boolean isInstallCommand = roleCommand.equals((Object)RoleCommand.INSTALL);
        String agentDefaultCommandTimeout = this.configs.getDefaultAgentTaskTimeout(isInstallCommand);
        String scriptCommandTimeout = "";
        CommandScriptDefinition script = componentInfo.getCommandScript();
        if (serviceInfo.getSchemaVersion().equals("2.0")) {
            if (script != null) {
                commandParams.put("script", script.getScript());
                commandParams.put("script_type", script.getScriptType().toString());
                boolean retryEnabled = false;
                Integer retryMaxTime = 0;
                if (commandParams.containsKey(CLUSTER_PHASE_PROPERTY) && (((String)commandParams.get(CLUSTER_PHASE_PROPERTY)).equals(CLUSTER_PHASE_INITIAL_INSTALL) || ((String)commandParams.get(CLUSTER_PHASE_PROPERTY)).equals(CLUSTER_PHASE_INITIAL_START))) {
                    String retryEnabledStr = this.configHelper.getValueFromDesiredConfigurations(cluster, "cluster-env", "command_retry_enabled");
                    String commandsStr = this.configHelper.getValueFromDesiredConfigurations(cluster, "cluster-env", "commands_to_retry");
                    String retryMaxTimeStr = this.configHelper.getValueFromDesiredConfigurations(cluster, "cluster-env", "command_retry_max_time_in_sec");
                    if (StringUtils.isNotEmpty((String)retryEnabledStr)) {
                        retryEnabled = Boolean.TRUE.toString().equals(retryEnabledStr);
                    }
                    if (retryEnabled) {
                        retryMaxTime = NumberUtils.toInt((String)retryMaxTimeStr, (int)0);
                        if (retryMaxTime < 0) {
                            retryMaxTime = 0;
                        }
                        if (StringUtils.isNotEmpty((String)commandsStr)) {
                            String[] commands;
                            boolean commandMayBeRetried = false;
                            for (String command : commands = commandsStr.split(",")) {
                                if (!roleCommand.toString().equals(command.trim())) continue;
                                commandMayBeRetried = true;
                            }
                            retryEnabled = commandMayBeRetried;
                        }
                    }
                    LOG.info("Auto retry setting for {}-{} on {} is retryEnabled={} and retryMaxTime={}", new Object[]{serviceName, componentName, scHost.getHostName(), retryEnabled, retryMaxTime});
                }
                commandParams.put("max_duration_for_retries", Integer.toString(retryMaxTime));
                commandParams.put("command_retry_enabled", Boolean.toString(retryEnabled));
                if (script.getTimeout() > 0) {
                    scriptCommandTimeout = String.valueOf(script.getTimeout());
                }
            } else {
                String message = String.format("Component %s of service %s has no command script defined", componentName, serviceName);
                throw new OBDPException(message);
            }
        }
        String string = actualTimeout = !scriptCommandTimeout.equals("") ? scriptCommandTimeout : agentDefaultCommandTimeout;
        if (roleCommand.equals((Object)RoleCommand.INSTALL) && !agentDefaultCommandTimeout.equals("") && Integer.parseInt(actualTimeout) < Integer.parseInt(agentDefaultCommandTimeout)) {
            actualTimeout = agentDefaultCommandTimeout;
        }
        commandParams.put("command_timeout", actualTimeout);
        String customCacheDirectory = componentInfo.getCustomFolder();
        if (customCacheDirectory != null && (customCache = new File(this.configs.getResourceDirPath(), customCacheDirectory)).exists() && customCache.isDirectory()) {
            commandParams.put("custom_folder", customCacheDirectory);
        }
        String clusterName = cluster.getClusterName();
        if (this.customCommandExecutionHelper.isTopologyRefreshRequired(roleCommand.name(), clusterName, serviceName)) {
            commandParams.put("refresh_topology", "True");
        }
        StageUtils.useAmbariJdkInCommandParams(commandParams, this.configs);
        try {
            repoInfo = this.repoVersionHelper.getRepoInfoString(cluster, component, host);
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending repo information to agent, hostname={}, clusterName={}, stackInfo={}, repoInfo={}", new Object[]{scHost.getHostName(), clusterName, stackId.getStackId(), repoInfo});
        }
        TreeMap<String, String> hostParams = new TreeMap<String, String>();
        if (roleCommand.equals((Object)RoleCommand.INSTALL)) {
            List<ServiceOsSpecific.Package> packages = this.getPackagesForServiceHost(serviceInfo, hostParams, osFamily);
            String packageList = this.gson.toJson(packages);
            commandParams.put("package_list", packageList);
        }
        Set<PropertyInfo> stackProperties = this.obdpMetaInfo.getStackProperties(stackInfo.getName(), stackInfo.getVersion());
        Set<String> userSet = this.configHelper.getPropertyValuesWithPropertyType(PropertyInfo.PropertyType.USER, cluster, clusterDesiredConfigs, servicesMap, stackProperties);
        String userList = this.gson.toJson(userSet);
        hostParams.put("user_list", userList);
        Map<String, Set<String>> userGroupsMap = this.configHelper.createUserGroupsMap(cluster, clusterDesiredConfigs, servicesMap, stackProperties);
        String userGroups = this.gson.toJson(userGroupsMap);
        hostParams.put("user_groups", userGroups);
        Set<String> groupSet = this.configHelper.getPropertyValuesWithPropertyType(PropertyInfo.PropertyType.GROUP, cluster, clusterDesiredConfigs, servicesMap, stackProperties);
        String groupList = this.gson.toJson(groupSet);
        hostParams.put("group_list", groupList);
        Map<PropertyInfo, String> notManagedHdfsPathMap = this.configHelper.getPropertiesWithPropertyType(PropertyInfo.PropertyType.NOT_MANAGED_HDFS_PATH, cluster, clusterDesiredConfigs, servicesMap, stackProperties);
        Set<String> notManagedHdfsPathSet = this.configHelper.filterInvalidPropertyValues(notManagedHdfsPathMap, "not_managed_hdfs_path_list");
        String notManagedHdfsPathList = this.gson.toJson(notManagedHdfsPathSet);
        hostParams.put("not_managed_hdfs_path_list", notManagedHdfsPathList);
        if (databaseType == Configuration.DatabaseType.ORACLE) {
            hostParams.put("db_driver_filename", this.configs.getOjdbcJarName());
        } else if (databaseType == Configuration.DatabaseType.MYSQL) {
            hostParams.put("db_driver_filename", this.configs.getMySQLJarName());
        }
        hostParams.put("clientsToUpdateConfigs", this.getClientsToUpdateConfigs(componentInfo));
        execCmd.setHostLevelParams(hostParams);
        TreeMap<String, String> roleParams = new TreeMap<String, String>();
        if (isUpgradeSuspended) {
            cluster.addSuspendedUpgradeParameters(commandParams, roleParams);
        }
        execCmd.setRoleParams(roleParams);
        execCmd.setCommandParams(commandParams);
        try {
            commandRepository = this.repoVersionHelper.getCommandRepository(cluster, component, host);
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
        execCmd.setRepositoryFile(commandRepository);
        execCmdWrapper.setVersions(cluster, null);
        if (useLatestConfigs) {
            execCmd.setUseLatestConfigs(useLatestConfigs);
        }
    }

    protected ServiceOsSpecific populateServicePackagesInfo(ServiceInfo serviceInfo, Map<String, String> hostParams, String osFamily) {
        ServiceOsSpecific hostOs = new ServiceOsSpecific(osFamily);
        List<ServiceOsSpecific> foundOSSpecifics = this.getOSSpecificsByFamily(serviceInfo.getOsSpecifics(), osFamily);
        if (!foundOSSpecifics.isEmpty()) {
            for (ServiceOsSpecific osSpecific : foundOSSpecifics) {
                hostOs.addPackages(osSpecific.getPackages());
            }
            ServiceOsSpecific.Repo serviceRepo = hostOs.getRepo();
            if (serviceRepo != null) {
                String serviceRepoInfo = this.gson.toJson((Object)serviceRepo);
                hostParams.put("service_repo_info", serviceRepoInfo);
            }
        }
        return hostOs;
    }

    @Override
    public List<ServiceOsSpecific.Package> getPackagesForServiceHost(ServiceInfo serviceInfo, Map<String, String> hostParams, String osFamily) {
        ServiceOsSpecific anyOs = null;
        if (serviceInfo.getOsSpecifics().containsKey("any")) {
            anyOs = serviceInfo.getOsSpecifics().get("any");
        }
        ServiceOsSpecific hostOs = this.populateServicePackagesInfo(serviceInfo, hostParams, osFamily);
        ArrayList<ServiceOsSpecific.Package> packages = new ArrayList<ServiceOsSpecific.Package>();
        if (anyOs != null) {
            packages.addAll(anyOs.getPackages());
        }
        if (hostOs != null) {
            packages.addAll(hostOs.getPackages());
        }
        return packages;
    }

    private List<ServiceOsSpecific> getOSSpecificsByFamily(Map<String, ServiceOsSpecific> osSpecifics, String osFamily) {
        ArrayList<ServiceOsSpecific> foundOSSpecifics = new ArrayList<ServiceOsSpecific>();
        block0: for (Map.Entry<String, ServiceOsSpecific> osSpecific : osSpecifics.entrySet()) {
            String[] osFamilyNames;
            for (String osFamilyName : osFamilyNames = osSpecific.getKey().split("\\s*,\\s*")) {
                if (!this.osFamily.isVersionedOsFamilyExtendedByVersionedFamily(osFamily, osFamilyName)) continue;
                foundOSSpecifics.add(osSpecific.getValue());
                continue block0;
            }
        }
        return foundOSSpecifics;
    }

    private ActionExecutionContext getActionExecutionContext(ExecuteActionRequest actionRequest) throws OBDPException {
        RequestOperationLevel operationLevel = actionRequest.getOperationLevel();
        if (actionRequest.isCommand().booleanValue()) {
            ActionExecutionContext actionExecutionContext = new ActionExecutionContext(actionRequest.getClusterName(), actionRequest.getCommandName(), actionRequest.getResourceFilters(), actionRequest.getParameters());
            actionExecutionContext.setOperationLevel(operationLevel);
            return actionExecutionContext;
        }
        ActionDefinition actionDef = this.obdpMetaInfo.getActionDefinition(actionRequest.getActionName());
        if (actionDef == null) {
            throw new OBDPException("Action " + actionRequest.getActionName() + " does not exist");
        }
        ActionExecutionContext actionExecutionContext = new ActionExecutionContext(actionRequest.getClusterName(), actionRequest.getActionName(), actionRequest.getResourceFilters(), actionRequest.getParameters(), actionDef.getTargetType(), actionDef.getDefaultTimeout(), actionDef.getTargetService(), actionDef.getTargetComponent());
        actionExecutionContext.setOperationLevel(operationLevel);
        return actionExecutionContext;
    }

    protected RequestStageContainer doStageCreation(RequestStageContainer requestStages, Cluster cluster, Map<State, List<Service>> changedServices, Map<State, List<ServiceComponent>> changedComps, Map<String, Map<State, List<ServiceComponentHost>>> changedScHosts, Map<String, String> requestParameters, Map<String, String> requestProperties, boolean runSmokeTest, boolean reconfigureClients, boolean useLatestConfigs, boolean useClusterHostInfo) throws OBDPException {
        if (!(changedServices != null && !changedServices.isEmpty() || changedComps != null && !changedComps.isEmpty() || changedScHosts != null && !changedScHosts.isEmpty())) {
            LOG.info("Created 0 stages");
            return requestStages;
        }
        this.configHelper.checkAllStageConfigsPresentInDesiredConfigs(cluster);
        boolean isUpgradeSuspended = cluster.isUpgradeSuspended();
        Configuration.DatabaseType databaseType = this.configs.getDatabaseType();
        Set<String> smokeTestServices = this.getServicesForSmokeTests(cluster, changedServices, changedScHosts, runSmokeTest);
        if (reconfigureClients) {
            this.addClientSchForReinstall(cluster, changedServices, changedScHosts);
        }
        if (!changedScHosts.isEmpty() || !smokeTestServices.isEmpty()) {
            List<Stage> stages;
            State oldSchState;
            long nowTimestamp = System.currentTimeMillis();
            Map<String, Set<String>> clusterHostInfo = StageUtils.getClusterHostInfo(cluster);
            String clusterHostInfoJson = StageUtils.getGson().toJson(clusterHostInfo);
            Stage stage = this.createNewStage(requestStages.getLastStageId(), cluster, requestStages.getId(), requestProperties.get("context"), "{}", null);
            boolean skipFailure = false;
            if (requestProperties.containsKey("skip_failure") && requestProperties.get("skip_failure").equalsIgnoreCase("true")) {
                skipFailure = true;
            }
            stage.setAutoSkipFailureSupported(skipFailure);
            stage.setSkippable(skipFailure);
            ArrayList<ServiceComponentHost> componentsToEnableKerberos = new ArrayList<ServiceComponentHost>();
            HashSet<String> hostsToForceKerberosOperations = new HashSet<String>();
            if (this.kerberosHelper.isClusterKerberosEnabled(cluster)) {
                Iterator<String> componentsToConfigureForKerberos = new ArrayList();
                for (Map<State, List<ServiceComponentHost>> changedScHostStates : changedScHosts.values()) {
                    if (changedScHostStates == null) continue;
                    for (Map.Entry<State, List<ServiceComponentHost>> changedScHostState : changedScHostStates.entrySet()) {
                        List<ServiceComponentHost> scHosts;
                        State newState = changedScHostState.getKey();
                        if (newState != State.INSTALLED || (scHosts = changedScHostState.getValue()) == null) continue;
                        for (ServiceComponentHost scHost : scHosts) {
                            oldSchState = scHost.getState();
                            if (oldSchState != State.INIT && oldSchState != State.INSTALL_FAILED) continue;
                            if (!this.hostComponentAlreadyExists(cluster, scHost) && !CLUSTER_PHASE_INITIAL_INSTALL.equals(requestProperties.get(CLUSTER_PHASE_PROPERTY))) {
                                componentsToConfigureForKerberos.add((String)((Object)scHost));
                            }
                            componentsToEnableKerberos.add(scHost);
                            if (!Service.Type.KERBEROS.name().equalsIgnoreCase(scHost.getServiceName()) || !Role.KERBEROS_CLIENT.name().equalsIgnoreCase(scHost.getServiceComponentName())) continue;
                            hostsToForceKerberosOperations.add(scHost.getHostName());
                        }
                    }
                }
                if (!componentsToConfigureForKerberos.isEmpty()) {
                    Map<State, List<ServiceComponentHost>> changedScHostStates;
                    HashMap<String, Collection<String>> serviceFilter = new HashMap<String, Collection<String>>();
                    changedScHostStates = componentsToConfigureForKerberos.iterator();
                    while (changedScHostStates.hasNext()) {
                        ServiceComponentHost scHost = (ServiceComponentHost)changedScHostStates.next();
                        String serviceName = scHost.getServiceName();
                        HashSet<String> componentFilter = (HashSet<String>)serviceFilter.get(serviceName);
                        if (componentFilter == null) {
                            componentFilter = new HashSet<String>();
                            serviceFilter.put(serviceName, componentFilter);
                        }
                        componentFilter.add(scHost.getServiceComponentName());
                    }
                    try {
                        this.kerberosHelper.configureServices(cluster, serviceFilter);
                    }
                    catch (KerberosInvalidConfigurationException e) {
                        throw new OBDPException(e.getMessage(), (Throwable)e);
                    }
                }
            }
            for (String compName : changedScHosts.keySet()) {
                for (State newState : changedScHosts.get(compName).keySet()) {
                    block22: for (ServiceComponentHost scHost : changedScHosts.get(compName).get((Object)newState)) {
                        String keyName;
                        RoleCommand roleCommand;
                        Service service = cluster.getService(scHost.getServiceName());
                        ServiceComponent serviceComponent = service.getServiceComponent(compName);
                        if (StringUtils.isBlank((String)stage.getHostParamsStage())) {
                            RepositoryVersionEntity repositoryVersion = serviceComponent.getDesiredRepositoryVersion();
                            stage.setHostParamsStage(StageUtils.getGson().toJson(this.customCommandExecutionHelper.createDefaultHostParams(cluster, repositoryVersion.getStackId())));
                        }
                        if (scHost.getHostState().equals((Object)HostState.HEARTBEAT_LOST)) {
                            LOG.info("Command is not created for servicecomponenthost , clusterName=" + cluster.getClusterName() + ", clusterId=" + cluster.getClusterId() + ", serviceName=" + scHost.getServiceName() + ", componentName=" + scHost.getServiceComponentName() + ", hostname=" + scHost.getHostName() + ", hostState=" + scHost.getHostState() + ", targetNewState=" + newState);
                            continue;
                        }
                        oldSchState = scHost.getState();
                        ServiceComponentHostEvent event = switch (newState) {
                            case State.INSTALLED -> {
                                if (oldSchState == State.INIT || oldSchState == State.UNINSTALLED || oldSchState == State.INSTALLED || oldSchState == State.INSTALLING || oldSchState == State.UNKNOWN || oldSchState == State.INSTALL_FAILED) {
                                    roleCommand = RoleCommand.INSTALL;
                                    if (scHost.isClientComponent() && oldSchState == State.INSTALLED) {
                                        yield new ServiceComponentHostOpInProgressEvent(scHost.getServiceComponentName(), scHost.getHostName(), nowTimestamp);
                                    }
                                    yield new ServiceComponentHostInstallEvent(scHost.getServiceComponentName(), scHost.getHostName(), nowTimestamp, serviceComponent.getDesiredStackId().getStackId());
                                }
                                if (oldSchState == State.STARTED || oldSchState == State.STOPPING) {
                                    roleCommand = RoleCommand.STOP;
                                    yield new ServiceComponentHostStopEvent(scHost.getServiceComponentName(), scHost.getHostName(), nowTimestamp);
                                }
                                if (oldSchState == State.UPGRADING) {
                                    roleCommand = RoleCommand.UPGRADE;
                                    yield new ServiceComponentHostUpgradeEvent(scHost.getServiceComponentName(), scHost.getHostName(), nowTimestamp, serviceComponent.getDesiredStackId().getStackId());
                                }
                                throw new OBDPException("Invalid transition for servicecomponenthost, clusterName=" + cluster.getClusterName() + ", clusterId=" + cluster.getClusterId() + ", serviceName=" + scHost.getServiceName() + ", componentName=" + scHost.getServiceComponentName() + ", hostname=" + scHost.getHostName() + ", currentState=" + oldSchState + ", newDesiredState=" + newState);
                            }
                            case State.STARTED -> {
                                StackId stackId = serviceComponent.getDesiredStackId();
                                ComponentInfo compInfo = this.obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), scHost.getServiceName(), scHost.getServiceComponentName());
                                if (oldSchState == State.INSTALLED || oldSchState != State.STARTING) {
                                    // empty if block
                                }
                                roleCommand = RoleCommand.START;
                                yield new ServiceComponentHostStartEvent(scHost.getServiceComponentName(), scHost.getHostName(), nowTimestamp);
                            }
                            case State.UNINSTALLED -> {
                                if (oldSchState == State.INSTALLED || oldSchState == State.UNINSTALLING) {
                                    roleCommand = RoleCommand.UNINSTALL;
                                    yield new ServiceComponentHostStartEvent(scHost.getServiceComponentName(), scHost.getHostName(), nowTimestamp);
                                }
                                throw new OBDPException("Invalid transition for servicecomponenthost, clusterName=" + cluster.getClusterName() + ", clusterId=" + cluster.getClusterId() + ", serviceName=" + scHost.getServiceName() + ", componentName=" + scHost.getServiceComponentName() + ", hostname=" + scHost.getHostName() + ", currentState=" + oldSchState + ", newDesiredState=" + newState);
                            }
                            case State.INIT -> {
                                if (oldSchState == State.INSTALLED || oldSchState == State.INSTALL_FAILED || oldSchState == State.INIT) {
                                    scHost.setState(State.INIT);
                                    continue block22;
                                }
                                throw new OBDPException("Unsupported transition to INIT for servicecomponenthost, clusterName=" + cluster.getClusterName() + ", clusterId=" + cluster.getClusterId() + ", serviceName=" + scHost.getServiceName() + ", componentName=" + scHost.getServiceComponentName() + ", hostname=" + scHost.getHostName() + ", currentState=" + oldSchState + ", newDesiredState=" + newState);
                            }
                            default -> throw new OBDPException("Unsupported state change operation, newState=" + newState);
                        };
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Create a new host action, requestId={}, componentName={}, hostname={}, roleCommand={}", new Object[]{requestStages.getId(), scHost.getServiceComponentName(), scHost.getHostName(), roleCommand.name()});
                        }
                        if (requestProperties.containsKey(keyName = scHost.getServiceComponentName().toLowerCase())) {
                            if (oldSchState == newState) {
                                switch (oldSchState) {
                                    case INSTALLED: {
                                        roleCommand = RoleCommand.STOP;
                                        event = new ServiceComponentHostStopEvent(scHost.getServiceComponentName(), scHost.getHostName(), nowTimestamp);
                                        break;
                                    }
                                    case STARTED: {
                                        roleCommand = RoleCommand.START;
                                        event = new ServiceComponentHostStartEvent(scHost.getServiceComponentName(), scHost.getHostName(), nowTimestamp);
                                        break;
                                    }
                                }
                            }
                            if (null == requestParameters) {
                                requestParameters = new HashMap<String, String>();
                            }
                            requestParameters.put(keyName, requestProperties.get(keyName));
                        }
                        if (requestProperties.containsKey(CLUSTER_PHASE_PROPERTY)) {
                            if (null == requestParameters) {
                                requestParameters = new HashMap<String, String>();
                            }
                            requestParameters.put(CLUSTER_PHASE_PROPERTY, requestProperties.get(CLUSTER_PHASE_PROPERTY));
                        }
                        Map<String, DesiredConfig> clusterDesiredConfigs = cluster.getDesiredConfigs();
                        if (newState == State.INSTALLED && this.skipInstallTaskForComponent(requestProperties, cluster, scHost)) {
                            LOG.info("Skipping create of INSTALL task for {} on {}.", (Object)scHost.getServiceComponentName(), (Object)scHost.getHostName());
                            scHost.setState(State.INSTALLING);
                            long now = System.currentTimeMillis();
                            try {
                                scHost.handleEvent(new ServiceComponentHostOpSucceededEvent(scHost.getServiceComponentName(), scHost.getHostName(), now));
                            }
                            catch (InvalidStateTransitionException e) {
                                LOG.error("Error transitioning ServiceComponentHost state to INSTALLED", (Throwable)e);
                            }
                            continue;
                        }
                        RepositoryVersionEntity repoVersion = serviceComponent.getDesiredRepositoryVersion();
                        this.createHostAction(cluster, stage, scHost, roleCommand, requestParameters, event, skipFailure, repoVersion, isUpgradeSuspended, databaseType, clusterDesiredConfigs, useLatestConfigs);
                    }
                }
            }
            for (String serviceName : smokeTestServices) {
                Service s = cluster.getService(serviceName);
                ServiceComponent component = this.getClientComponentForRunningAction(cluster, s);
                String componentName = component != null ? component.getName() : null;
                String clientHost = this.getClientHostForRunningAction(cluster, s, component);
                String smokeTestRole = this.actionMetadata.getServiceCheckAction(serviceName);
                if (clientHost == null || smokeTestRole == null) {
                    LOG.info("Nothing to do for service check as could not find role or or host to run check on, clusterName=" + cluster.getClusterName() + ", serviceName=" + serviceName + ", clientHost=" + clientHost + ", serviceCheckRole=" + smokeTestRole);
                    continue;
                }
                if (StringUtils.isBlank((String)stage.getHostParamsStage())) {
                    RepositoryVersionEntity repositoryVersion = component.getDesiredRepositoryVersion();
                    stage.setHostParamsStage(StageUtils.getGson().toJson(this.customCommandExecutionHelper.createDefaultHostParams(cluster, repositoryVersion.getStackId())));
                }
                this.customCommandExecutionHelper.addServiceCheckAction(stage, clientHost, smokeTestRole, nowTimestamp, serviceName, componentName, null, false, false, useLatestConfigs);
            }
            RoleCommandOrder rco = this.getRoleCommandOrder(cluster);
            RoleGraph rg = this.roleGraphFactory.createNew(rco);
            if (CommandExecutionType.DEPENDENCY_ORDERED == this.configs.getStageExecutionType() && CLUSTER_PHASE_INITIAL_START.equals(requestProperties.get(CLUSTER_PHASE_PROPERTY))) {
                LOG.info("Set DEPENDENCY_ORDERED CommandExecutionType on stage: {}", (Object)stage.getRequestContext());
                rg.setCommandExecutionType(CommandExecutionType.DEPENDENCY_ORDERED);
            }
            rg.build(stage);
            if (useClusterHostInfo) {
                requestStages.setClusterHostInfo(clusterHostInfoJson);
            }
            requestStages.addStages(rg.getStages());
            if (!componentsToEnableKerberos.isEmpty()) {
                HashMap<String, HashSet<String>> serviceFilter = new HashMap<String, HashSet<String>>();
                HashSet<String> hostFilter = new HashSet<String>();
                for (ServiceComponentHost scHost : componentsToEnableKerberos) {
                    String serviceName = scHost.getServiceName();
                    HashSet<String> componentFilter = (HashSet<String>)serviceFilter.get(serviceName);
                    if (componentFilter == null) {
                        componentFilter = new HashSet<String>();
                        serviceFilter.put(serviceName, componentFilter);
                    }
                    componentFilter.add(scHost.getServiceComponentName());
                    hostFilter.add(scHost.getHostName());
                }
                try {
                    this.kerberosHelper.ensureIdentities(cluster, serviceFilter, hostFilter, null, hostsToForceKerberosOperations, requestStages, this.kerberosHelper.getManageIdentitiesDirective(requestProperties));
                }
                catch (KerberosOperationException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
            LOG.debug("Created {} stages", (Object)((stages = requestStages.getStages()) != null ? stages.size() : 0));
        } else {
            LOG.debug("Created 0 stages");
        }
        return requestStages;
    }

    private boolean hostComponentAlreadyExists(Cluster cluster, ServiceComponentHost sch) throws OBDPException {
        ServiceComponent serviceComponent;
        Service service = cluster.getService(sch.getServiceName());
        if (service != null && (serviceComponent = service.getServiceComponent(sch.getServiceComponentName())) != null) {
            Map<String, ServiceComponentHost> serviceComponentHostMap = serviceComponent.getServiceComponentHosts();
            for (ServiceComponentHost serviceComponentHost : serviceComponentHostMap.values()) {
                if (serviceComponentHost.getState() != State.INSTALLED && serviceComponentHost.getState() != State.STARTED) continue;
                return true;
            }
        }
        return false;
    }

    private boolean skipInstallTaskForComponent(Map<String, String> requestProperties, Cluster cluster, ServiceComponentHost sch) throws OBDPException {
        ServiceComponent serviceComponent;
        boolean isClientComponent = false;
        Service service = cluster.getService(sch.getServiceName());
        String componentName = sch.getServiceComponentName();
        if (service != null && (serviceComponent = service.getServiceComponent(componentName)) != null) {
            isClientComponent = serviceComponent.isClientComponent();
        }
        return HostComponentResourceProvider.shouldSkipInstallTaskForComponent(componentName, isClientComponent, requestProperties);
    }

    @Override
    public ExecutionCommand getExecutionCommand(Cluster cluster, ServiceComponentHost scHost, RoleCommand roleCommand) throws OBDPException {
        Map<String, String> hostParamsCmd = this.customCommandExecutionHelper.createDefaultHostParams(cluster, scHost.getServiceComponent().getDesiredStackId());
        Stage stage = this.createNewStage(0L, cluster, 1L, "", "{}", "");
        RepositoryVersionEntity repoVersion = null;
        if (null != scHost.getServiceComponent().getDesiredRepositoryVersion()) {
            repoVersion = scHost.getServiceComponent().getDesiredRepositoryVersion();
        } else {
            Service service = cluster.getService(scHost.getServiceName());
            repoVersion = service.getDesiredRepositoryVersion();
        }
        boolean isUpgradeSuspended = cluster.isUpgradeSuspended();
        Configuration.DatabaseType databaseType = this.configs.getDatabaseType();
        Map<String, DesiredConfig> clusterDesiredConfigs = cluster.getDesiredConfigs();
        this.createHostAction(cluster, stage, scHost, roleCommand, null, null, false, repoVersion, isUpgradeSuspended, databaseType, clusterDesiredConfigs, false);
        ExecutionCommand ec = stage.getExecutionCommands().get(scHost.getHostName()).get(0).getExecutionCommand();
        hostParamsCmd.putAll(ec.getHostLevelParams());
        ec.getHostLevelParams().putAll(hostParamsCmd);
        for (ServiceComponentHost sch : cluster.getServiceComponentHosts(scHost.getHostName())) {
            ec.getLocalComponents().add(sch.getServiceComponentName());
        }
        return ec;
    }

    @Override
    public Set<StackConfigurationDependencyResponse> getStackConfigurationDependencies(Set<StackConfigurationDependencyRequest> requests) throws OBDPException {
        HashSet<StackConfigurationDependencyResponse> response = new HashSet<StackConfigurationDependencyResponse>();
        if (requests != null) {
            for (StackConfigurationDependencyRequest request : requests) {
                String stackName = request.getStackName();
                String stackVersion = request.getStackVersion();
                String serviceName = request.getServiceName();
                String propertyName = request.getPropertyName();
                Set<StackConfigurationDependencyResponse> stackConfigurations = this.getStackConfigurationDependencies(request);
                for (StackConfigurationDependencyResponse dependencyResponse : stackConfigurations) {
                    dependencyResponse.setStackName(stackName);
                    dependencyResponse.setStackVersion(stackVersion);
                    dependencyResponse.setServiceName(serviceName);
                    dependencyResponse.setPropertyName(propertyName);
                }
                response.addAll(stackConfigurations);
            }
        }
        return response;
    }

    private Set<StackConfigurationDependencyResponse> getStackConfigurationDependencies(StackConfigurationDependencyRequest request) throws OBDPException {
        HashSet<StackConfigurationDependencyResponse> response = new HashSet<StackConfigurationDependencyResponse>();
        String stackName = request.getStackName();
        String stackVersion = request.getStackVersion();
        String serviceName = request.getServiceName();
        String propertyName = request.getPropertyName();
        String dependencyName = request.getDependencyName();
        Set<PropertyInfo> properties = this.obdpMetaInfo.getPropertiesByName(stackName, stackVersion, serviceName, propertyName);
        for (PropertyInfo property : properties) {
            for (PropertyDependencyInfo dependency : property.getDependedByProperties()) {
                if (dependencyName != null && !dependency.getName().equals(dependencyName)) continue;
                response.add(dependency.convertToResponse());
            }
        }
        return response;
    }

    @Transactional
    void updateServiceStates(Cluster cluster, Map<State, List<Service>> changedServices, Map<State, List<ServiceComponent>> changedComps, Map<String, Map<State, List<ServiceComponentHost>>> changedScHosts, Collection<ServiceComponentHost> ignoredScHosts) {
        Object newState;
        if (changedServices != null) {
            for (Map.Entry<State, List<Object>> entry : changedServices.entrySet()) {
                newState = entry.getKey();
                for (Service service : entry.getValue()) {
                    if (service.isClientOnlyService() && newState == State.STARTED) continue;
                    service.setDesiredState((State)((Object)newState));
                }
            }
        }
        if (changedComps != null) {
            for (Map.Entry<State, List<Object>> entry : changedComps.entrySet()) {
                newState = entry.getKey();
                for (ServiceComponent serviceComponent : entry.getValue()) {
                    serviceComponent.setDesiredState((State)((Object)newState));
                }
            }
        }
        HashMap<String, String> serviceMasterForDecommissionMap = new HashMap<String, String>();
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        for (Map map : changedScHosts.values()) {
            for (Map.Entry entry : map.entrySet()) {
                State newState2 = (State)((Object)entry.getKey());
                for (ServiceComponentHost sch : (List)entry.getValue()) {
                    String componentName = sch.getServiceComponentName();
                    if (OBDPCustomCommandExecutionHelper.masterToSlaveMappingForDecom.containsValue(componentName) && sch.getState() == State.INIT && newState2 == State.INSTALLED) {
                        String serviceName = sch.getServiceName();
                        String masterComponentName = null;
                        for (Map.Entry<String, String> entrySet : OBDPCustomCommandExecutionHelper.masterToSlaveMappingForDecom.entrySet()) {
                            if (!entrySet.getValue().equals(componentName)) continue;
                            masterComponentName = entrySet.getKey();
                        }
                        try {
                            if (this.isServiceComponentStartedOnAnyHost(cluster, serviceName, masterComponentName)) {
                                serviceMasterForDecommissionMap.put(serviceName, masterComponentName);
                                hashMap.putIfAbsent(masterComponentName, new HashSet());
                                ((Set)hashMap.get(masterComponentName)).add(sch.getHostName());
                            } else {
                                LOG.info(String.format("Not adding %s service from include/exclude files refresh map because it's master is not started", serviceName));
                            }
                        }
                        catch (OBDPException e) {
                            LOG.error("Exception during INIT masters cleanup : ", (Throwable)e);
                        }
                    }
                    sch.setDesiredState(newState2);
                }
            }
        }
        try {
            this.createAndExecuteRefreshIncludeExcludeFilesActionForMasters(serviceMasterForDecommissionMap, hashMap, cluster.getClusterName(), false);
        }
        catch (OBDPException e) {
            LOG.error("Exception during refresh include exclude files action : ", (Throwable)e);
        }
        if (ignoredScHosts != null) {
            for (ServiceComponentHost serviceComponentHost : ignoredScHosts) {
                serviceComponentHost.setDesiredState(serviceComponentHost.getState());
            }
        }
    }

    private boolean isServiceComponentStartedOnAnyHost(Cluster cluster, String serviceName, String masterComponentName) throws OBDPException {
        Service service = cluster.getService(serviceName);
        ServiceComponent serviceComponent = service.getServiceComponent(masterComponentName);
        Map<String, ServiceComponentHost> schMap = serviceComponent.getServiceComponentHosts();
        for (ServiceComponentHost sch : schMap.values()) {
            if (sch.getState() != State.STARTED) continue;
            return true;
        }
        return false;
    }

    @Override
    public RequestStatusResponse createAndPersistStages(Cluster cluster, Map<String, String> requestProperties, Map<String, String> requestParameters, Map<State, List<Service>> changedServices, Map<State, List<ServiceComponent>> changedComponents, Map<String, Map<State, List<ServiceComponentHost>>> changedHosts, Collection<ServiceComponentHost> ignoredHosts, boolean runSmokeTest, boolean reconfigureClients) throws OBDPException {
        RequestStageContainer request = this.addStages(null, cluster, requestProperties, requestParameters, changedServices, changedComponents, changedHosts, ignoredHosts, runSmokeTest, reconfigureClients, false);
        request.persist();
        return request.getRequestStatusResponse();
    }

    @Override
    public RequestStageContainer addStages(RequestStageContainer requestStages, Cluster cluster, Map<String, String> requestProperties, Map<String, String> requestParameters, Map<State, List<Service>> changedServices, Map<State, List<ServiceComponent>> changedComponents, Map<String, Map<State, List<ServiceComponentHost>>> changedHosts, Collection<ServiceComponentHost> ignoredHosts, boolean runSmokeTest, boolean reconfigureClients, boolean useGeneratedConfigs) throws OBDPException {
        return this.addStages(requestStages, cluster, requestProperties, requestParameters, changedServices, changedComponents, changedHosts, ignoredHosts, runSmokeTest, reconfigureClients, useGeneratedConfigs, false);
    }

    @Override
    public RequestStageContainer addStages(RequestStageContainer requestStages, Cluster cluster, Map<String, String> requestProperties, Map<String, String> requestParameters, Map<State, List<Service>> changedServices, Map<State, List<ServiceComponent>> changedComponents, Map<String, Map<State, List<ServiceComponentHost>>> changedHosts, Collection<ServiceComponentHost> ignoredHosts, boolean runSmokeTest, boolean reconfigureClients, boolean useGeneratedConfigs, boolean useClusterHostInfo) throws OBDPException {
        if (requestStages == null) {
            requestStages = new RequestStageContainer(this.actionManager.getNextRequestId(), null, this.requestFactory, this.actionManager);
        }
        requestStages = this.doStageCreation(requestStages, cluster, changedServices, changedComponents, changedHosts, requestParameters, requestProperties, runSmokeTest, reconfigureClients, useGeneratedConfigs, useClusterHostInfo);
        this.updateServiceStates(cluster, changedServices, changedComponents, changedHosts, ignoredHosts);
        return requestStages;
    }

    public void validateServiceComponentHostRequest(ServiceComponentHostRequest request) {
        if (request.getClusterName() == null || request.getClusterName().isEmpty() || request.getComponentName() == null || request.getComponentName().isEmpty() || request.getHostname() == null || request.getHostname().isEmpty()) {
            throw new IllegalArgumentException("Invalid arguments, cluster name, component name and host name should be provided");
        }
        if (request.getAdminState() != null) {
            throw new IllegalArgumentException("Property adminState cannot be modified through update. Use service specific DECOMMISSION action to decommision/recommission components.");
        }
    }

    private void checkIfHostComponentsInDeleteFriendlyState(ServiceComponentHostRequest request, Cluster cluster) throws OBDPException {
        Service service = cluster.getService(request.getServiceName());
        ServiceComponent component = service.getServiceComponent(request.getComponentName());
        ServiceComponentHost componentHost = component.getServiceComponentHost(request.getHostname());
        if (!componentHost.canBeRemoved()) {
            throw new OBDPException("Current host component state prohibiting component removal., clusterName=" + request.getClusterName() + ", serviceName=" + request.getServiceName() + ", componentName=" + request.getComponentName() + ", hostname=" + request.getHostname() + ", request=" + request + ", state=" + componentHost.getState());
        }
    }

    @Override
    public String findServiceName(Cluster cluster, String componentName) throws OBDPException {
        return cluster.getServiceByComponentName(componentName).getName();
    }

    @Override
    public synchronized void deleteCluster(ClusterRequest request) throws OBDPException {
        if (request.getClusterName() == null || request.getClusterName().isEmpty()) {
            throw new OBDPException("Invalid arguments");
        }
        LOG.info("Received a delete cluster request, clusterName = " + request.getClusterName());
        if (request.getHostNames() == null) {
            this.clusters.deleteCluster(request.getClusterName());
        }
    }

    @Override
    public DeleteStatusMetaData deleteHostComponents(Set<ServiceComponentHostRequest> requests) throws OBDPException, AuthorizationException {
        HashSet<ServiceComponentHostRequest> expanded = new HashSet<ServiceComponentHostRequest>();
        for (ServiceComponentHostRequest request : requests) {
            if (null == request.getComponentName()) {
                if (null == request.getClusterName() || request.getClusterName().isEmpty() || null == request.getHostname() || request.getHostname().isEmpty()) {
                    throw new IllegalArgumentException("Cluster name and hostname must be specified.");
                }
                Cluster cluster = this.clusters.getCluster(request.getClusterName());
                if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), EnumSet.of(RoleAuthorization.SERVICE_ADD_DELETE_SERVICES, RoleAuthorization.HOST_ADD_DELETE_COMPONENTS))) {
                    throw new AuthorizationException("The authenticated user is not authorized to delete service components from hosts");
                }
                for (ServiceComponentHost sch : cluster.getServiceComponentHosts(request.getHostname())) {
                    ServiceComponentHostRequest serviceComponentHostRequest = new ServiceComponentHostRequest(request.getClusterName(), sch.getServiceName(), sch.getServiceComponentName(), sch.getHostName(), null);
                    expanded.add(serviceComponentHostRequest);
                }
                continue;
            }
            expanded.add(request);
        }
        HashMap safeToRemoveSCHs = new HashMap();
        DeleteHostComponentStatusMetaData deleteMetaData = new DeleteHostComponentStatusMetaData();
        for (ServiceComponentHostRequest request : expanded) {
            this.validateServiceComponentHostRequest(request);
            Iterator cluster = this.clusters.getCluster(request.getClusterName());
            if (StringUtils.isEmpty((String)request.getServiceName())) {
                request.setServiceName(this.findServiceName((Cluster)((Object)cluster), request.getComponentName()));
            }
            LOG.info("Received a hostComponent DELETE request, clusterName=" + request.getClusterName() + ", serviceName=" + request.getServiceName() + ", componentName=" + request.getComponentName() + ", hostname=" + request.getHostname() + ", request=" + request);
            Service service = cluster.getService(request.getServiceName());
            ServiceComponent component = service.getServiceComponent(request.getComponentName());
            ServiceComponentHost componentHost = component.getServiceComponentHost(request.getHostname());
            this.setRestartRequiredServices(service, request.getComponentName());
            try {
                this.checkIfHostComponentsInDeleteFriendlyState(request, (Cluster)((Object)cluster));
                if (!safeToRemoveSCHs.containsKey(component)) {
                    safeToRemoveSCHs.put(component, new HashSet());
                }
                ((Set)safeToRemoveSCHs.get(component)).add(componentHost);
            }
            catch (Exception ex) {
                deleteMetaData.addException(request.getHostname() + "/" + request.getComponentName(), ex);
            }
        }
        HashMap clusterServiceMasterForDecommissionMap = new HashMap();
        HashMap clusterMasterSlaveHostsMap = new HashMap();
        for (Map.Entry entry : safeToRemoveSCHs.entrySet()) {
            for (ServiceComponentHost componentHost : (Set)entry.getValue()) {
                try {
                    ((ServiceComponent)entry.getKey()).deleteServiceComponentHosts(componentHost.getHostName(), deleteMetaData);
                    String componentName = componentHost.getServiceComponentName();
                    if (!OBDPCustomCommandExecutionHelper.masterToSlaveMappingForDecom.containsValue(componentName)) continue;
                    String masterComponentName = null;
                    for (Map.Entry<String, String> entrySet : OBDPCustomCommandExecutionHelper.masterToSlaveMappingForDecom.entrySet()) {
                        if (!entrySet.getValue().equals(componentName)) continue;
                        masterComponentName = entrySet.getKey();
                    }
                    if (clusterServiceMasterForDecommissionMap.containsKey(componentHost.getClusterName())) {
                        ((Map)clusterServiceMasterForDecommissionMap.get(componentHost.getClusterName())).put(componentHost.getServiceName(), masterComponentName);
                        Map masterSlaveMap = (Map)clusterMasterSlaveHostsMap.get(componentHost.getClusterName());
                        masterSlaveMap.putIfAbsent(masterComponentName, new HashSet());
                        ((Set)masterSlaveMap.get(masterComponentName)).add(componentHost.getHostName());
                        continue;
                    }
                    HashMap<String, String> serviceMasterMap = new HashMap<String, String>();
                    serviceMasterMap.put(componentHost.getServiceName(), masterComponentName);
                    clusterServiceMasterForDecommissionMap.put(componentHost.getClusterName(), serviceMasterMap);
                    HashMap<String, HashSet<String>> masterSlaveHostsMap = new HashMap<String, HashSet<String>>();
                    masterSlaveHostsMap.put(masterComponentName, new HashSet<String>(Collections.singletonList(componentHost.getHostName())));
                    clusterMasterSlaveHostsMap.put(componentHost.getClusterName(), masterSlaveHostsMap);
                }
                catch (Exception ex) {
                    deleteMetaData.addException(componentHost.getHostName() + "/" + componentHost.getServiceComponentName(), ex);
                }
            }
        }
        for (String string : clusterServiceMasterForDecommissionMap.keySet()) {
            this.createAndExecuteRefreshIncludeExcludeFilesActionForMasters((Map)clusterServiceMasterForDecommissionMap.get(string), (Map)clusterMasterSlaveHostsMap.get(string), string, true);
        }
        if (deleteMetaData.getDeletedKeys().size() + deleteMetaData.getExceptionForKeys().size() == 1) {
            if (deleteMetaData.getDeletedKeys().size() == 1) {
                this.STOMPComponentsDeleteHandler.processDeleteByMetaData(deleteMetaData);
                return null;
            }
            Exception ex = deleteMetaData.getExceptionForKeys().values().iterator().next();
            if (ex instanceof OBDPException) {
                throw (OBDPException)((Object)ex);
            }
            throw new OBDPException(ex.getMessage(), (Throwable)ex);
        }
        if (!safeToRemoveSCHs.isEmpty()) {
            this.setMonitoringServicesRestartRequired(requests);
        }
        this.STOMPComponentsDeleteHandler.processDeleteByMetaData(deleteMetaData);
        return deleteMetaData;
    }

    @Override
    public void deleteGroups(Set<GroupRequest> requests) throws OBDPException {
        for (GroupRequest request : requests) {
            LOG.debug("Received a delete group request, groupname={}", (Object)request.getGroupName());
            Group group = this.users.getGroup(request.getGroupName());
            if (group == null) continue;
            this.users.removeGroup(group);
        }
    }

    private void createAndExecuteRefreshIncludeExcludeFilesActionForMasters(Map<String, String> serviceMasterMap, Map<String, Set<String>> masterSlaveHostsMap, String clusterName, boolean isDecommission) throws OBDPException {
        serviceMasterMap.remove(Service.Type.HBASE.toString());
        if (serviceMasterMap.isEmpty()) {
            return;
        }
        LOG.debug("Refresh include/exclude files action will be executed for " + serviceMasterMap);
        HashMap<String, String> requestProperties = new HashMap<String, String>();
        requestProperties.put("context", "Update Include/Exclude Files for " + serviceMasterMap.keySet().toString());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("update_files_only", String.valueOf(isDecommission));
        for (String string : masterSlaveHostsMap.keySet()) {
            if (isDecommission) continue;
            params.put(string + "_included_hosts", StringUtils.join((Object[])masterSlaveHostsMap.get(string).toArray(), (String)","));
        }
        params.put("is_add_or_delete_slave_request", "true");
        ArrayList<RequestResourceFilter> resourceFilters = new ArrayList<RequestResourceFilter>(serviceMasterMap.size());
        for (String serviceName : serviceMasterMap.keySet()) {
            resourceFilters.add(new RequestResourceFilter(serviceName, serviceMasterMap.get(serviceName), null));
        }
        ExecuteActionRequest executeActionRequest = new ExecuteActionRequest(clusterName, "DECOMMISSION", null, resourceFilters, null, params, false);
        this.createAction(executeActionRequest, requestProperties);
    }

    @Override
    public void deleteMembers(Set<MemberRequest> requests) throws OBDPException {
        for (MemberRequest request : requests) {
            LOG.debug("Received a delete member request, {}", (Object)request);
            this.users.removeMemberFromGroup(request.getGroupName(), request.getUserName());
        }
    }

    @Override
    public void removeMpack(MpackEntity mpackEntity, StackEntity stackEntity) throws IOException {
        this.obdpMetaInfo.removeMpack(mpackEntity, stackEntity);
    }

    @Override
    public Set<ServiceConfigVersionResponse> createServiceConfigVersion(Set<ServiceConfigVersionRequest> requests) throws OBDPException, AuthorizationException {
        return null;
    }

    RequestStatusResponse getRequestStatusResponse(long requestId) {
        RequestStatusResponse response = new RequestStatusResponse(requestId);
        List<HostRoleCommand> hostRoleCommands = this.actionManager.getRequestTasks(requestId);
        response.setRequestContext(this.actionManager.getRequestContext(requestId));
        ArrayList<ShortTaskStatus> tasks = new ArrayList<ShortTaskStatus>();
        for (HostRoleCommand hostRoleCommand : hostRoleCommands) {
            tasks.add(new ShortTaskStatus(hostRoleCommand));
        }
        response.setTasks(tasks);
        return response;
    }

    @Override
    public Set<ClusterResponse> getClusters(Set<ClusterRequest> requests) throws OBDPException, AuthorizationException {
        HashSet<ClusterResponse> response = new HashSet<ClusterResponse>();
        for (ClusterRequest request : requests) {
            try {
                response.addAll(this.getClusters(request));
            }
            catch (ClusterNotFoundException e) {
                if (requests.size() != 1) continue;
                throw e;
            }
        }
        return response;
    }

    @Override
    public Set<ServiceComponentHostResponse> getHostComponents(Set<ServiceComponentHostRequest> requests) throws OBDPException {
        return this.getHostComponents(requests, false);
    }

    @Override
    public Set<ServiceComponentHostResponse> getHostComponents(Set<ServiceComponentHostRequest> requests, boolean statusOnly) throws OBDPException {
        LOG.debug("Processing requests: {}", requests);
        HashSet<ServiceComponentHostResponse> response = new HashSet<ServiceComponentHostResponse>();
        for (ServiceComponentHostRequest request : requests) {
            try {
                response.addAll(this.getHostComponents(request, statusOnly));
            }
            catch (ServiceComponentHostNotFoundException | ServiceComponentNotFoundException | ServiceNotFoundException e) {
                if (requests.size() == 1) {
                    throw e;
                }
                LOG.debug("Ignoring not found exception due to other requests", (Throwable)((Object)e));
            }
            catch (ParentObjectNotFoundException e) {
                boolean throwException = true;
                if (requests.size() > 1 && HostNotFoundException.class.isInstance(e.getCause())) {
                    for (ServiceComponentHostRequest r : requests) {
                        if (r.getHostname() != null) continue;
                        throwException = false;
                        LOG.debug("HostNotFoundException ignored", (Throwable)((Object)e));
                        break;
                    }
                }
                if (!throwException) continue;
                throw e;
            }
        }
        return response;
    }

    @Override
    public Set<ConfigurationResponse> getConfigurations(Set<ConfigurationRequest> requests) throws OBDPException {
        HashSet<ConfigurationResponse> response = new HashSet<ConfigurationResponse>();
        for (ConfigurationRequest request : requests) {
            response.addAll(this.getConfigurations(request));
        }
        return response;
    }

    @Override
    public Set<ServiceConfigVersionResponse> getServiceConfigVersions(Set<ServiceConfigVersionRequest> requests) throws OBDPException {
        LinkedHashSet<ServiceConfigVersionResponse> responses = new LinkedHashSet<ServiceConfigVersionResponse>();
        for (ServiceConfigVersionRequest request : requests) {
            responses.addAll(this.getServiceConfigVersions(request));
        }
        return responses;
    }

    private Set<ServiceConfigVersionResponse> getServiceConfigVersions(ServiceConfigVersionRequest request) throws OBDPException {
        if (request.getClusterName() == null) {
            throw new IllegalArgumentException("Invalid arguments, cluster name should not be null");
        }
        Cluster cluster = this.clusters.getCluster(request.getClusterName());
        LinkedHashSet<ServiceConfigVersionResponse> result = new LinkedHashSet<ServiceConfigVersionResponse>();
        String serviceName = request.getServiceName();
        ArrayList<ServiceConfigVersionResponse> serviceConfigVersionResponses = new ArrayList<ServiceConfigVersionResponse>();
        if (Boolean.TRUE.equals(request.getIsCurrent()) && serviceName != null) {
            serviceConfigVersionResponses.addAll(cluster.getActiveServiceConfigVersionResponse(serviceName));
        } else {
            serviceConfigVersionResponses.addAll(cluster.getServiceConfigVersions());
        }
        for (ServiceConfigVersionResponse response : serviceConfigVersionResponses) {
            if (serviceName != null && !StringUtils.equals((String)serviceName, (String)response.getServiceName()) || request.getVersion() != null && NumberUtils.compare((float)request.getVersion().longValue(), (float)response.getVersion().longValue()) != 0 || request.getUserName() != null && !StringUtils.equals((String)request.getUserName(), (String)response.getUserName())) continue;
            result.add(response);
        }
        return result;
    }

    @Override
    public Set<GroupResponse> getGroups(Set<GroupRequest> requests) throws OBDPException {
        HashSet<GroupResponse> responses = new HashSet<GroupResponse>();
        for (GroupRequest request : requests) {
            LOG.debug("Received a getGroups request, groupRequest={}", (Object)request);
            if (null == request.getGroupName()) {
                for (Group group : this.users.getAllGroups()) {
                    GroupResponse response = new GroupResponse(group.getGroupName(), group.isLdapGroup(), group.getGroupType());
                    responses.add(response);
                }
                continue;
            }
            Group group = this.users.getGroup(request.getGroupName());
            if (null == group) {
                if (requests.size() != 1) continue;
                throw new ObjectNotFoundException("Cannot find group '" + request.getGroupName() + "'");
            }
            GroupResponse response = new GroupResponse(group.getGroupName(), group.isLdapGroup(), group.getGroupType());
            responses.add(response);
        }
        return responses;
    }

    @Override
    public void updateGroups(Set<GroupRequest> requests) throws OBDPException {
    }

    protected String getClientHostForRunningAction(Cluster cluster, Service service, ServiceComponent serviceComponent) throws OBDPException {
        if (serviceComponent != null && !serviceComponent.getServiceComponentHosts().isEmpty()) {
            Set<String> candidateHosts = serviceComponent.getServiceComponentHosts().keySet();
            this.filterHostsForAction(candidateHosts, service, cluster, Resource.Type.Cluster);
            return this.getHealthyHost(candidateHosts);
        }
        return null;
    }

    protected ServiceComponent getClientComponentForRunningAction(Cluster cluster, Service service) throws OBDPException {
        Map<String, ServiceComponent> components;
        StackId stackId = service.getDesiredStackId();
        ComponentInfo compInfo = this.obdpMetaInfo.getService(stackId.getStackName(), stackId.getStackVersion(), service.getName()).getClientComponent();
        if (compInfo != null) {
            try {
                ServiceComponent serviceComponent = service.getServiceComponent(compInfo.getName());
                if (!serviceComponent.getServiceComponentHosts().isEmpty()) {
                    return serviceComponent;
                }
            }
            catch (ServiceComponentNotFoundException e) {
                LOG.warn("Could not find required component to run action, clusterName=" + cluster.getClusterName() + ", serviceName=" + service.getName() + ", componentName=" + compInfo.getName());
            }
        }
        if (!(components = service.getServiceComponents()).isEmpty()) {
            for (ServiceComponent serviceComponent : components.values()) {
                if (serviceComponent.getServiceComponentHosts().isEmpty()) continue;
                return serviceComponent;
            }
        }
        return null;
    }

    protected void filterHostsForAction(Set<String> candidateHosts, Service service, final Cluster cluster, final Resource.Type level) throws OBDPException {
        Set<String> ignoredHosts = this.maintenanceStateHelper.filterHostsInMaintenanceState(candidateHosts, new MaintenanceStateHelper.HostPredicate(){

            @Override
            public boolean shouldHostBeRemoved(String hostname) throws OBDPException {
                Host host = OBDPManagementControllerImpl.this.clusters.getHost(hostname);
                return !OBDPManagementControllerImpl.this.maintenanceStateHelper.isOperationAllowed(host, cluster.getClusterId(), level);
            }
        });
        LOG.debug("Ignoring hosts when selecting available hosts for action due to maintenance state.Ignored hosts ={}, cluster={}, service={}", new Object[]{ignoredHosts, cluster.getClusterName(), service.getName()});
    }

    @Override
    public List<String> selectHealthyHosts(Set<String> hostList) throws OBDPException {
        ArrayList<String> healthyHosts = new ArrayList<String>();
        for (String candidateHostName : hostList) {
            Host candidateHost = this.clusters.getHost(candidateHostName);
            if (candidateHost.getState() != HostState.HEALTHY) continue;
            healthyHosts.add(candidateHostName);
        }
        return healthyHosts;
    }

    @Override
    public String getHealthyHost(Set<String> hostList) throws OBDPException {
        List<String> healthyHosts = this.selectHealthyHosts(hostList);
        if (!healthyHosts.isEmpty()) {
            Collections.shuffle(healthyHosts);
            return healthyHosts.get(0);
        }
        return null;
    }

    @Override
    public RequestStatusResponse createAction(ExecuteActionRequest actionRequest, Map<String, String> requestProperties) throws OBDPException {
        RoleGraph rg;
        String clusterName = actionRequest.getClusterName();
        String requestContext = "";
        if (requestProperties != null && (requestContext = StringEscapeUtils.escapeHtml4((String)requestProperties.get("context"))) == null) {
            requestContext = "";
        }
        Cluster cluster = null;
        if (null != clusterName) {
            cluster = this.clusters.getCluster(clusterName);
            LOG.info("Received action execution request, clusterName=" + actionRequest.getClusterName() + ", request=" + actionRequest);
        }
        ActionExecutionContext actionExecContext = this.getActionExecutionContext(actionRequest);
        if (actionRequest.isCommand().booleanValue()) {
            this.customCommandExecutionHelper.validateAction(actionRequest);
        } else {
            this.actionExecutionHelper.validateAction(actionRequest);
        }
        long requestId = this.actionManager.getNextRequestId();
        RequestStageContainer requestStageContainer = new RequestStageContainer(requestId, null, this.requestFactory, this.actionManager, actionRequest);
        ExecuteCommandJson jsons = this.customCommandExecutionHelper.getCommandJson(actionExecContext, cluster, null == cluster ? null : cluster.getDesiredStackVersion(), requestContext);
        String commandParamsForStage = jsons.getCommandParamsForStage();
        Map commandParamsStage = (Map)this.gson.fromJson(commandParamsForStage, new TypeToken<Map<String, String>>(){}.getType());
        if (!requestContext.isEmpty()) {
            requestStageContainer.setRequestContext(requestContext);
        }
        SecretReference.replaceReferencesWithPasswords(commandParamsStage, cluster);
        boolean kerberosServiceCheck = Role.KERBEROS_SERVICE_CHECK.name().equals(actionRequest.getCommandName());
        if (kerberosServiceCheck) {
            try {
                requestStageContainer = this.kerberosHelper.createTestIdentity(cluster, commandParamsStage, requestStageContainer);
            }
            catch (KerberosOperationException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        commandParamsForStage = this.gson.toJson((Object)commandParamsStage);
        Stage stage = this.createNewStage(requestStageContainer.getLastStageId(), cluster, requestId, requestContext, commandParamsForStage, jsons.getHostParamsForStage());
        if (actionRequest.isCommand().booleanValue()) {
            this.customCommandExecutionHelper.addExecutionCommandsToStage(actionExecContext, stage, requestProperties, jsons);
        } else {
            this.actionExecutionHelper.addExecutionCommandsToStage(actionExecContext, stage, requestProperties);
        }
        if (null != cluster) {
            RoleCommandOrder rco = this.getRoleCommandOrder(cluster);
            rg = this.roleGraphFactory.createNew(rco);
        } else {
            rg = this.roleGraphFactory.createNew();
        }
        rg.build(stage);
        List<Stage> stages = rg.getStages();
        if (stages != null && !stages.isEmpty()) {
            requestStageContainer.addStages(stages);
        }
        if (kerberosServiceCheck) {
            commandParamsStage = (Map)this.gson.fromJson(commandParamsForStage, new TypeToken<Map<String, String>>(){}.getType());
            try {
                requestStageContainer = this.kerberosHelper.deleteTestIdentity(cluster, commandParamsStage, requestStageContainer);
            }
            catch (KerberosOperationException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        requestStageContainer.persist();
        return requestStageContainer.getRequestStatusResponse();
    }

    @Override
    public Set<StackResponse> getStacks(Set<StackRequest> requests) throws OBDPException {
        HashSet<StackResponse> response = new HashSet<StackResponse>();
        for (StackRequest request : requests) {
            try {
                response.addAll(this.getStacks(request));
            }
            catch (StackAccessException e) {
                if (requests.size() != 1) continue;
                throw e;
            }
        }
        return response;
    }

    private Set<StackResponse> getStacks(StackRequest request) throws OBDPException {
        HashSet<StackResponse> response;
        String stackName = request.getStackName();
        if (stackName != null) {
            this.obdpMetaInfo.getStacks(stackName);
            response = Collections.singleton(new StackResponse(stackName));
        } else {
            Collection<StackInfo> supportedStacks = this.obdpMetaInfo.getStacks();
            response = new HashSet();
            for (StackInfo stack : supportedStacks) {
                response.add(new StackResponse(stack.getName()));
            }
        }
        return response;
    }

    @Override
    public synchronized RequestStatusResponse updateStacks() throws OBDPException {
        try {
            this.obdpMetaInfo.init();
        }
        catch (OBDPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OBDPException("Ambari Meta Information can't be read from the stack root directory");
        }
        return null;
    }

    @Override
    public Set<ExtensionResponse> getExtensions(Set<ExtensionRequest> requests) throws OBDPException {
        HashSet<ExtensionResponse> response = new HashSet<ExtensionResponse>();
        for (ExtensionRequest request : requests) {
            try {
                response.addAll(this.getExtensions(request));
            }
            catch (StackAccessException e) {
                if (requests.size() != 1) continue;
                throw e;
            }
        }
        return response;
    }

    private Set<ExtensionResponse> getExtensions(ExtensionRequest request) throws OBDPException {
        HashSet<ExtensionResponse> response;
        String extensionName = request.getExtensionName();
        if (extensionName != null) {
            this.obdpMetaInfo.getExtensions(extensionName);
            response = Collections.singleton(new ExtensionResponse(extensionName));
        } else {
            Collection<ExtensionInfo> supportedExtensions = this.obdpMetaInfo.getExtensions();
            response = new HashSet();
            for (ExtensionInfo extension : supportedExtensions) {
                response.add(new ExtensionResponse(extension.getName()));
            }
        }
        return response;
    }

    @Override
    public Set<ExtensionVersionResponse> getExtensionVersions(Set<ExtensionVersionRequest> requests) throws OBDPException {
        HashSet<ExtensionVersionResponse> response = new HashSet<ExtensionVersionResponse>();
        for (ExtensionVersionRequest request : requests) {
            String extensionName = request.getExtensionName();
            try {
                Set<ExtensionVersionResponse> stackVersions = this.getExtensionVersions(request);
                for (ExtensionVersionResponse stackVersionResponse : stackVersions) {
                    stackVersionResponse.setExtensionName(extensionName);
                }
                response.addAll(stackVersions);
            }
            catch (StackAccessException e) {
                if (requests.size() != 1) continue;
                throw e;
            }
        }
        return response;
    }

    private Set<ExtensionVersionResponse> getExtensionVersions(ExtensionVersionRequest request) throws OBDPException {
        Set<ExtensionVersionResponse> response;
        String extensionName = request.getExtensionName();
        String extensionVersion = request.getExtensionVersion();
        if (extensionVersion != null) {
            ExtensionInfo extensionInfo = this.obdpMetaInfo.getExtension(extensionName, extensionVersion);
            response = Collections.singleton(extensionInfo.convertToResponse());
        } else {
            try {
                Collection<ExtensionInfo> extensionInfos = this.obdpMetaInfo.getExtensions(extensionName);
                response = new HashSet<ExtensionVersionResponse>();
                for (ExtensionInfo extensionInfo : extensionInfos) {
                    response.add(extensionInfo.convertToResponse());
                }
            }
            catch (StackAccessException e) {
                response = Collections.emptySet();
            }
        }
        return response;
    }

    @Override
    public Set<RepositoryResponse> getRepositories(Set<RepositoryRequest> requests) throws OBDPException {
        HashSet<RepositoryResponse> response = new HashSet<RepositoryResponse>();
        for (RepositoryRequest request : requests) {
            try {
                String stackName = request.getStackName();
                String stackVersion = request.getStackVersion();
                Set<RepositoryResponse> repositories = this.getRepositories(request);
                for (RepositoryResponse repositoryResponse : repositories) {
                    if (repositoryResponse.getStackName() == null) {
                        repositoryResponse.setStackName(stackName);
                    }
                    if (repositoryResponse.getStackVersion() == null) {
                        repositoryResponse.setStackVersion(stackVersion);
                    }
                    repositoryResponse.setClusterVersionId(request.getClusterVersionId());
                }
                response.addAll(repositories);
            }
            catch (StackAccessException e) {
                if (requests.size() != 1) continue;
                throw e;
            }
        }
        return response;
    }

    private Set<RepositoryResponse> getRepositories(RepositoryRequest request) throws OBDPException {
        String stackName = request.getStackName();
        String stackVersion = request.getStackVersion();
        String osType = request.getOsType();
        String repoId = request.getRepoId();
        Long repositoryVersionId = request.getRepositoryVersionId();
        String versionDefinitionId = request.getVersionDefinitionId();
        if (null == repositoryVersionId && null != versionDefinitionId && NumberUtils.isDigits((String)versionDefinitionId)) {
            repositoryVersionId = Long.valueOf(versionDefinitionId);
        }
        Set<RepositoryResponse> responses = new HashSet<RepositoryResponse>();
        if (repositoryVersionId != null) {
            RepositoryVersionEntity repositoryVersion = (RepositoryVersionEntity)this.repositoryVersionDAO.findByPK(repositoryVersionId);
            if (repositoryVersion != null) {
                for (RepoOsEntity operatingSystem : repositoryVersion.getRepoOsEntities()) {
                    if (!operatingSystem.getFamily().equals(osType)) continue;
                    for (RepoDefinitionEntity repository : operatingSystem.getRepoDefinitionEntities()) {
                        RepositoryResponse response = new RepositoryResponse(repository.getBaseUrl(), osType, repository.getRepoID(), repository.getRepoName(), repository.getDistribution(), repository.getComponents(), "", "", repository.getTags(), repository.getApplicableServices());
                        if (null != versionDefinitionId) {
                            response.setVersionDefinitionId(versionDefinitionId);
                        } else {
                            response.setRepositoryVersionId(repositoryVersionId);
                        }
                        response.setStackName(repositoryVersion.getStackName());
                        response.setStackVersion(repositoryVersion.getStackVersion());
                        responses.add(response);
                    }
                    break;
                }
            }
        } else if (null != versionDefinitionId) {
            VersionDefinitionXml xml = this.obdpMetaInfo.getVersionDefinition(versionDefinitionId);
            if (null == xml) {
                throw new OBDPException(String.format("Version identified by %s does not exist", versionDefinitionId));
            }
            StackId stackId = new StackId(xml.release.stackId);
            ListMultimap<String, RepositoryInfo> stackRepositoriesByOs = this.obdpMetaInfo.getStackManager().getStack(stackName, stackVersion).getRepositoriesByOs();
            for (RepositoryXml.Os os : xml.repositoryInfo.getOses()) {
                for (RepositoryXml.Repo repo : os.getRepos()) {
                    RepositoryResponse resp = new RepositoryResponse(repo.getBaseUrl(), os.getFamily(), repo.getRepoId(), repo.getRepoName(), repo.getDistribution(), repo.getComponents(), repo.getMirrorsList(), repo.getBaseUrl(), repo.getTags(), Collections.EMPTY_LIST);
                    resp.setVersionDefinitionId(versionDefinitionId);
                    resp.setStackName(stackId.getStackName());
                    resp.setStackVersion(stackId.getStackVersion());
                    responses.add(resp);
                }
            }
            List<RepositoryInfo> serviceRepos = RepoUtil.getServiceRepos(xml.repositoryInfo.getRepositories(), stackRepositoriesByOs);
            responses.addAll(RepoUtil.asResponses(serviceRepos, versionDefinitionId, stackName, stackVersion));
        } else if (repoId == null) {
            List<RepositoryInfo> repositories = this.obdpMetaInfo.getRepositories(stackName, stackVersion, osType);
            for (RepositoryInfo repository : repositories) {
                responses.add(repository.convertToResponse());
            }
        } else {
            RepositoryInfo repository = this.obdpMetaInfo.getRepository(stackName, stackVersion, osType, repoId);
            responses = Collections.singleton(repository.convertToResponse());
        }
        return responses;
    }

    @Override
    public void verifyRepositories(Set<RepositoryRequest> requests) throws OBDPException {
        for (RepositoryRequest request : requests) {
            if (request.getBaseUrl() == null) {
                throw new OBDPException("Base url is missing for request " + request);
            }
            this.verifyRepository(request);
        }
    }

    private void verifyRepository(RepositoryRequest request) throws OBDPException {
        String[] suffixes;
        URLRedirectProvider usp = new URLRedirectProvider(3000, 2000, true);
        String repoName = request.getRepoName();
        if (StringUtils.isEmpty((String)repoName)) {
            throw new IllegalArgumentException("repo_name is required to verify repository");
        }
        Object errorMessage = null;
        IOException e = null;
        for (String suffix : suffixes = this.configs.getRepoValidationSuffixes(request.getOsType())) {
            String formatted_suffix = String.format(suffix, repoName);
            Object spec = request.getBaseUrl().trim();
            spec = ((String)spec).charAt(((String)spec).length() - 1) != '/' && formatted_suffix.charAt(0) != '/' ? (String)spec + "/" + formatted_suffix : (((String)spec).charAt(((String)spec).length() - 1) == '/' && formatted_suffix.charAt(0) == '/' ? (String)spec + formatted_suffix.substring(1) : (String)spec + formatted_suffix);
            String FILE_SCHEME = "file://";
            if (((String)spec).toLowerCase().startsWith("file://")) {
                String filePath = ((String)spec).substring("file://".length());
                File f = new File(filePath);
                if (f.exists()) continue;
                errorMessage = "Could not access base url . " + (String)spec + " . ";
                e = new FileNotFoundException((String)errorMessage);
                break;
            }
            try {
                URLRedirectProvider.RequestResult result = usp.executeGet((String)spec);
                if (result.getCode() == 200) continue;
                errorMessage = String.format("Could not access base url '%s', code: '%d', response: '%s'", URLCredentialsHider.hideCredentials(request.getBaseUrl()), result.getCode(), result.getContent());
            }
            catch (IOException ioe) {
                e = ioe;
                errorMessage = String.format("Could not access base url '%s'", URLCredentialsHider.hideCredentials(request.getBaseUrl()));
                if (LOG.isDebugEnabled()) {
                    errorMessage = (String)errorMessage + ioe;
                    break;
                }
                errorMessage = (String)errorMessage + ioe.getMessage();
                break;
            }
        }
        if (errorMessage != null) {
            LOG.error(errorMessage);
            if (e == null) {
                throw new IllegalArgumentException((String)errorMessage);
            }
            throw new IllegalArgumentException((String)errorMessage, e);
        }
    }

    @Override
    public Set<StackVersionResponse> getStackVersions(Set<StackVersionRequest> requests) throws OBDPException {
        HashSet<StackVersionResponse> response = new HashSet<StackVersionResponse>();
        for (StackVersionRequest request : requests) {
            String stackName = request.getStackName();
            try {
                Set<StackVersionResponse> stackVersions = this.getStackVersions(request);
                for (StackVersionResponse stackVersionResponse : stackVersions) {
                    stackVersionResponse.setStackName(stackName);
                }
                response.addAll(stackVersions);
            }
            catch (StackAccessException e) {
                if (requests.size() != 1) continue;
                throw e;
            }
        }
        return response;
    }

    private Set<StackVersionResponse> getStackVersions(StackVersionRequest request) throws OBDPException {
        Set<StackVersionResponse> response;
        String stackName = request.getStackName();
        String stackVersion = request.getStackVersion();
        if (stackVersion != null) {
            StackInfo stackInfo = this.obdpMetaInfo.getStack(stackName, stackVersion);
            response = Collections.singleton(stackInfo.convertToResponse());
        } else {
            try {
                Collection<StackInfo> stackInfos = this.obdpMetaInfo.getStacks(stackName);
                response = new HashSet<StackVersionResponse>();
                for (StackInfo stackInfo : stackInfos) {
                    response.add(stackInfo.convertToResponse());
                }
            }
            catch (StackAccessException e) {
                response = Collections.emptySet();
            }
        }
        return response;
    }

    @Override
    public Set<StackServiceResponse> getStackServices(Set<StackServiceRequest> requests) throws OBDPException {
        HashSet<StackServiceResponse> response = new HashSet<StackServiceResponse>();
        for (StackServiceRequest request : requests) {
            String stackName = request.getStackName();
            String stackVersion = request.getStackVersion();
            try {
                Set<StackServiceResponse> stackServices = this.getStackServices(request);
                for (StackServiceResponse stackServiceResponse : stackServices) {
                    stackServiceResponse.setStackName(stackName);
                    stackServiceResponse.setStackVersion(stackVersion);
                }
                response.addAll(stackServices);
            }
            catch (StackAccessException e) {
                if (requests.size() != 1) continue;
                throw e;
            }
        }
        return response;
    }

    private Set<StackServiceResponse> getStackServices(StackServiceRequest request) throws OBDPException {
        HashSet<StackServiceResponse> response;
        String stackName = request.getStackName();
        String stackVersion = request.getStackVersion();
        String serviceName = request.getServiceName();
        if (serviceName != null) {
            ServiceInfo service = this.obdpMetaInfo.getService(stackName, stackVersion, serviceName);
            response = Collections.singleton(new StackServiceResponse(service));
        } else {
            Map<String, ServiceInfo> services = this.obdpMetaInfo.getServices(stackName, stackVersion);
            response = new HashSet();
            for (ServiceInfo service : services.values()) {
                response.add(new StackServiceResponse(service));
            }
        }
        return response;
    }

    @Override
    public Set<StackConfigurationResponse> getStackLevelConfigurations(Set<StackLevelConfigurationRequest> requests) throws OBDPException {
        HashSet<StackConfigurationResponse> response = new HashSet<StackConfigurationResponse>();
        for (StackLevelConfigurationRequest request : requests) {
            String stackName = request.getStackName();
            String stackVersion = request.getStackVersion();
            Set<StackConfigurationResponse> stackConfigurations = this.getStackLevelConfigurations(request);
            for (StackConfigurationResponse stackConfigurationResponse : stackConfigurations) {
                stackConfigurationResponse.setStackName(stackName);
                stackConfigurationResponse.setStackVersion(stackVersion);
            }
            response.addAll(stackConfigurations);
        }
        return response;
    }

    private Set<StackConfigurationResponse> getStackLevelConfigurations(StackLevelConfigurationRequest request) throws OBDPException {
        HashSet<StackConfigurationResponse> response = new HashSet<StackConfigurationResponse>();
        String stackName = request.getStackName();
        String stackVersion = request.getStackVersion();
        String propertyName = request.getPropertyName();
        Set<PropertyInfo> configs = propertyName != null ? this.obdpMetaInfo.getStackPropertiesByName(stackName, stackVersion, propertyName) : this.obdpMetaInfo.getStackProperties(stackName, stackVersion);
        for (PropertyInfo property : configs) {
            response.add(property.convertToResponse());
        }
        return response;
    }

    @Override
    public Set<StackConfigurationResponse> getStackConfigurations(Set<StackConfigurationRequest> requests) throws OBDPException {
        HashSet<StackConfigurationResponse> response = new HashSet<StackConfigurationResponse>();
        for (StackConfigurationRequest request : requests) {
            String stackName = request.getStackName();
            String stackVersion = request.getStackVersion();
            String serviceName = request.getServiceName();
            Set<StackConfigurationResponse> stackConfigurations = this.getStackConfigurations(request);
            for (StackConfigurationResponse stackConfigurationResponse : stackConfigurations) {
                stackConfigurationResponse.setStackName(stackName);
                stackConfigurationResponse.setStackVersion(stackVersion);
                stackConfigurationResponse.setServiceName(serviceName);
            }
            response.addAll(stackConfigurations);
        }
        return response;
    }

    private Set<StackConfigurationResponse> getStackConfigurations(StackConfigurationRequest request) throws OBDPException {
        HashSet<StackConfigurationResponse> response = new HashSet<StackConfigurationResponse>();
        String stackName = request.getStackName();
        String stackVersion = request.getStackVersion();
        String serviceName = request.getServiceName();
        String propertyName = request.getPropertyName();
        Set<PropertyInfo> properties = propertyName != null ? this.obdpMetaInfo.getPropertiesByName(stackName, stackVersion, serviceName, propertyName) : this.obdpMetaInfo.getServiceProperties(stackName, stackVersion, serviceName);
        for (PropertyInfo property : properties) {
            response.add(property.convertToResponse());
        }
        return response;
    }

    @Override
    public Set<StackServiceComponentResponse> getStackComponents(Set<StackServiceComponentRequest> requests) throws OBDPException {
        HashSet<StackServiceComponentResponse> response = new HashSet<StackServiceComponentResponse>();
        for (StackServiceComponentRequest request : requests) {
            String stackName = request.getStackName();
            String stackVersion = request.getStackVersion();
            String serviceName = request.getServiceName();
            try {
                Set<StackServiceComponentResponse> stackComponents = this.getStackComponents(request);
                for (StackServiceComponentResponse stackServiceComponentResponse : stackComponents) {
                    stackServiceComponentResponse.setStackName(stackName);
                    stackServiceComponentResponse.setStackVersion(stackVersion);
                    stackServiceComponentResponse.setServiceName(serviceName);
                }
                response.addAll(stackComponents);
            }
            catch (StackAccessException e) {
                if (requests.size() != 1) continue;
                throw e;
            }
        }
        return response;
    }

    private Set<StackServiceComponentResponse> getStackComponents(StackServiceComponentRequest request) throws OBDPException {
        HashSet<StackServiceComponentResponse> response;
        String stackName = request.getStackName();
        String stackVersion = request.getStackVersion();
        String serviceName = request.getServiceName();
        String componentName = request.getComponentName();
        if (componentName != null) {
            ComponentInfo component = this.obdpMetaInfo.getComponent(stackName, stackVersion, serviceName, componentName);
            response = Collections.singleton(new StackServiceComponentResponse(component));
        } else {
            List<ComponentInfo> components = this.obdpMetaInfo.getComponentsByService(stackName, stackVersion, serviceName);
            response = new HashSet();
            for (ComponentInfo component : components) {
                response.add(new StackServiceComponentResponse(component));
            }
        }
        return response;
    }

    @Override
    public Set<OperatingSystemResponse> getOperatingSystems(Set<OperatingSystemRequest> requests) throws OBDPException {
        HashSet<OperatingSystemResponse> response = new HashSet<OperatingSystemResponse>();
        for (OperatingSystemRequest request : requests) {
            try {
                String stackName = request.getStackName();
                String stackVersion = request.getStackVersion();
                Set<OperatingSystemResponse> stackOperatingSystems = this.getOperatingSystems(request);
                for (OperatingSystemResponse operatingSystemResponse : stackOperatingSystems) {
                    if (operatingSystemResponse.getStackName() == null) {
                        operatingSystemResponse.setStackName(stackName);
                    }
                    if (operatingSystemResponse.getStackVersion() != null) continue;
                    operatingSystemResponse.setStackVersion(stackVersion);
                }
                response.addAll(stackOperatingSystems);
            }
            catch (StackAccessException e) {
                if (requests.size() != 1) continue;
                throw e;
            }
        }
        return response;
    }

    private Set<OperatingSystemResponse> getOperatingSystems(OperatingSystemRequest request) throws OBDPException {
        Set<OperatingSystemResponse> responses;
        block12: {
            String versionDefinitionId;
            String osType;
            String stackVersion;
            String stackName;
            block11: {
                responses = new HashSet<OperatingSystemResponse>();
                stackName = request.getStackName();
                stackVersion = request.getStackVersion();
                osType = request.getOsType();
                Long repositoryVersionId = request.getRepositoryVersionId();
                versionDefinitionId = request.getVersionDefinitionId();
                if (null == repositoryVersionId && null != versionDefinitionId && NumberUtils.isDigits((String)versionDefinitionId)) {
                    repositoryVersionId = Long.valueOf(versionDefinitionId);
                }
                if (repositoryVersionId == null) break block11;
                RepositoryVersionEntity repositoryVersion = (RepositoryVersionEntity)this.repositoryVersionDAO.findByPK(repositoryVersionId);
                if (repositoryVersion == null) break block12;
                for (RepoOsEntity operatingSystem : repositoryVersion.getRepoOsEntities()) {
                    OperatingSystemResponse response = new OperatingSystemResponse(operatingSystem.getFamily());
                    if (null != versionDefinitionId) {
                        response.setVersionDefinitionId(repositoryVersionId.toString());
                    } else {
                        response.setRepositoryVersionId(repositoryVersionId);
                    }
                    response.setStackName(repositoryVersion.getStackName());
                    response.setStackVersion(repositoryVersion.getStackVersion());
                    response.setAmbariManagedRepos(operatingSystem.isAmbariManaged());
                    responses.add(response);
                }
                break block12;
            }
            if (null != versionDefinitionId) {
                VersionDefinitionXml xml = this.obdpMetaInfo.getVersionDefinition(versionDefinitionId);
                if (null == xml) {
                    throw new OBDPException(String.format("Version identified by %s does not exist", versionDefinitionId));
                }
                StackId stackId = new StackId(xml.release.stackId);
                for (RepositoryXml.Os os : xml.repositoryInfo.getOses()) {
                    OperatingSystemResponse resp = new OperatingSystemResponse(os.getFamily());
                    resp.setVersionDefinitionId(versionDefinitionId);
                    resp.setStackName(stackId.getStackName());
                    resp.setStackVersion(stackId.getStackVersion());
                    responses.add(resp);
                }
            } else if (osType != null) {
                OperatingSystemInfo operatingSystem = this.obdpMetaInfo.getOperatingSystem(stackName, stackVersion, osType);
                responses = Collections.singleton(operatingSystem.convertToResponse());
            } else {
                Set<OperatingSystemInfo> operatingSystems = this.obdpMetaInfo.getOperatingSystems(stackName, stackVersion);
                for (OperatingSystemInfo operatingSystem : operatingSystems) {
                    responses.add(operatingSystem.convertToResponse());
                }
            }
        }
        return responses;
    }

    @Override
    public String getAuthName() {
        return AuthorizationHelper.getAuthenticatedName(this.configs.getAnonymousAuditName());
    }

    @Override
    public int getAuthId() {
        return AuthorizationHelper.getAuthenticatedId();
    }

    @Override
    public Set<RootServiceResponse> getRootServices(Set<RootServiceRequest> requests) throws OBDPException {
        HashSet<RootServiceResponse> response = new HashSet<RootServiceResponse>();
        for (RootServiceRequest request : requests) {
            try {
                response.addAll(this.getRootServices(request));
            }
            catch (OBDPException e) {
                if (requests.size() != 1) continue;
                throw e;
            }
        }
        return response;
    }

    private Set<RootServiceResponse> getRootServices(RootServiceRequest request) throws OBDPException {
        return this.rootServiceResponseFactory.getRootServices(request);
    }

    @Override
    public Set<RootServiceComponentResponse> getRootServiceComponents(Set<RootServiceComponentRequest> requests) throws OBDPException {
        HashSet<RootServiceComponentResponse> response = new HashSet<RootServiceComponentResponse>();
        for (RootServiceComponentRequest request : requests) {
            try {
                Set<RootServiceComponentResponse> rootServiceComponents = this.getRootServiceComponents(request);
                response.addAll(rootServiceComponents);
            }
            catch (OBDPException e) {
                if (requests.size() != 1) continue;
                throw e;
            }
        }
        return response;
    }

    private Set<RootServiceComponentResponse> getRootServiceComponents(RootServiceComponentRequest request) throws OBDPException {
        return this.rootServiceResponseFactory.getRootServiceComponents(request);
    }

    @Override
    public Clusters getClusters() {
        return this.clusters;
    }

    @Override
    public ConfigHelper getConfigHelper() {
        return this.configHelper;
    }

    @Override
    public OBDPMetaInfo getAmbariMetaInfo() {
        return this.obdpMetaInfo;
    }

    @Override
    public ServiceComponentFactory getServiceComponentFactory() {
        return this.serviceComponentFactory;
    }

    @Override
    public ConfigGroupFactory getConfigGroupFactory() {
        return this.configGroupFactory;
    }

    @Override
    public RoleGraphFactory getRoleGraphFactory() {
        return this.roleGraphFactory;
    }

    @Override
    public AbstractRootServiceResponseFactory getRootServiceResponseFactory() {
        return this.rootServiceResponseFactory;
    }

    @Override
    public ActionManager getActionManager() {
        return this.actionManager;
    }

    @Override
    public String getJdkResourceUrl() {
        return this.jdkResourceUrl;
    }

    @Override
    public String getJavaHome() {
        return this.javaHome;
    }

    @Override
    public String getAmbariJavaHome() {
        return this.ambariJavaHome;
    }

    @Override
    public String getJDKName() {
        return this.jdkName;
    }

    @Override
    public String getJCEName() {
        return this.jceName;
    }

    @Override
    public String getServerDB() {
        return this.serverDB;
    }

    @Override
    public String getOjdbcUrl() {
        return this.ojdbcUrl;
    }

    @Override
    public String getMysqljdbcUrl() {
        return this.mysqljdbcUrl;
    }

    @Override
    public Map<String, String> getRcaParameters() {
        String hostName = StageUtils.getHostName();
        String url = this.configs.getRcaDatabaseUrl();
        if (url.contains("{hostname}")) {
            url = url.replace("{hostname}", this.hostsMap.getHostMap(hostName));
        }
        HashMap<String, String> rcaParameters = new HashMap<String, String>();
        rcaParameters.put("ambari_db_rca_url", url);
        rcaParameters.put("ambari_db_rca_driver", this.configs.getRcaDatabaseDriver());
        rcaParameters.put("ambari_db_rca_username", this.configs.getRcaDatabaseUser());
        rcaParameters.put("ambari_db_rca_password", this.configs.getRcaDatabasePassword());
        return rcaParameters;
    }

    @Override
    public boolean checkLdapConfigured() {
        return this.ldapDataPopulator.isLdapEnabled();
    }

    @Override
    public LdapSyncDto getLdapSyncInfo() throws OBDPException {
        return this.ldapDataPopulator.getLdapSyncInfo();
    }

    @Override
    public boolean isLdapSyncInProgress() {
        return this.ldapSyncInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized LdapBatchDto synchronizeLdapUsersAndGroups(LdapSyncRequest userRequest, LdapSyncRequest groupRequest) throws OBDPException {
        this.ldapSyncInProgress = true;
        try {
            Set<LdapUserDto> ignoredUsers;
            LdapBatchDto batchInfo = new LdapBatchDto();
            boolean postProcessExistingUsers = false;
            boolean postProcessExistingUsersInGroups = false;
            if (userRequest != null) {
                postProcessExistingUsers = userRequest.getPostProcessExistingUsers();
                if (postProcessExistingUsers && !this.configs.isUserHookEnabled()) {
                    LOG.warn("Post processing existing users is requested while processing users; however, the user post creation hook is turned off.");
                    postProcessExistingUsers = false;
                }
                switch (userRequest.getType()) {
                    case ALL: {
                        this.ldapDataPopulator.synchronizeAllLdapUsers(batchInfo, postProcessExistingUsers);
                        break;
                    }
                    case EXISTING: {
                        this.ldapDataPopulator.synchronizeExistingLdapUsers(batchInfo, postProcessExistingUsers);
                        break;
                    }
                    case SPECIFIC: {
                        this.ldapDataPopulator.synchronizeLdapUsers(userRequest.getPrincipalNames(), batchInfo, postProcessExistingUsers);
                    }
                }
            }
            if (groupRequest != null) {
                postProcessExistingUsersInGroups = groupRequest.getPostProcessExistingUsers();
                if (postProcessExistingUsersInGroups && !this.configs.isUserHookEnabled()) {
                    LOG.warn("Post processing existing users is requested while processing groups; however, the user post creation hook is turned off.");
                    postProcessExistingUsersInGroups = false;
                }
                switch (groupRequest.getType()) {
                    case ALL: {
                        this.ldapDataPopulator.synchronizeAllLdapGroups(batchInfo, postProcessExistingUsersInGroups);
                        break;
                    }
                    case EXISTING: {
                        this.ldapDataPopulator.synchronizeExistingLdapGroups(batchInfo, postProcessExistingUsersInGroups);
                        break;
                    }
                    case SPECIFIC: {
                        this.ldapDataPopulator.synchronizeLdapGroups(groupRequest.getPrincipalNames(), batchInfo, postProcessExistingUsersInGroups);
                    }
                }
            }
            this.users.processLdapSync(batchInfo);
            if ((postProcessExistingUsers || postProcessExistingUsersInGroups) && CollectionUtils.isNotEmpty(ignoredUsers = batchInfo.getUsersIgnored())) {
                HashMap<String, Set<String>> userGroupsMap = new HashMap<String, Set<String>>();
                for (LdapUserDto ignoredUser : ignoredUsers) {
                    userGroupsMap.put(ignoredUser.getUserName(), Collections.emptySet());
                }
                this.users.executeUserHook(userGroupsMap);
            }
            LdapBatchDto ldapBatchDto = batchInfo;
            return ldapBatchDto;
        }
        finally {
            this.ldapSyncInProgress = false;
        }
    }

    @Override
    public void initializeWidgetsAndLayouts(Cluster cluster, Service service) throws OBDPException {
        Type widgetLayoutType = new TypeToken<Map<String, List<WidgetLayout>>>(){}.getType();
        HashSet<File> widgetDescriptorFiles = new HashSet<File>();
        if (null != service) {
            ServiceInfo serviceInfo = this.obdpMetaInfo.getService(service);
            File widgetDescriptorFile = serviceInfo.getWidgetsDescriptorFile();
            if (widgetDescriptorFile != null && widgetDescriptorFile.exists()) {
                widgetDescriptorFiles.add(widgetDescriptorFile);
            }
        } else {
            File commonWidgetsFile = this.obdpMetaInfo.getCommonWidgetsDescriptorFile();
            if (commonWidgetsFile != null && commonWidgetsFile.exists()) {
                widgetDescriptorFiles.add(commonWidgetsFile);
            } else {
                LOG.warn("Common widgets file with path {%s} doesn't exist. No cluster widgets will be created.", (Object)commonWidgetsFile);
            }
        }
        for (File widgetDescriptorFile : widgetDescriptorFiles) {
            Map widgetDescriptor = null;
            try {
                widgetDescriptor = (Map)this.gson.fromJson((Reader)new FileReader(widgetDescriptorFile), widgetLayoutType);
                for (Object artifact : widgetDescriptor.values()) {
                    List widgetLayouts = (List)artifact;
                    this.createWidgetsAndLayouts(cluster, widgetLayouts);
                }
            }
            catch (Exception ex) {
                String msg = "Error loading widgets from file: " + widgetDescriptorFile;
                LOG.error(msg, (Throwable)ex);
                throw new OBDPException(msg);
            }
        }
    }

    private WidgetEntity addIfNotExistsWidgetEntity(WidgetLayoutInfo layoutInfo, ClusterEntity clusterEntity, String user, long createTime) {
        List<WidgetEntity> createdEntities = this.widgetDAO.findByName(clusterEntity.getClusterId(), layoutInfo.getWidgetName(), user, layoutInfo.getDefaultSectionName());
        if (createdEntities == null || createdEntities.isEmpty()) {
            WidgetEntity widgetEntity = new WidgetEntity();
            widgetEntity.setClusterId(clusterEntity.getClusterId());
            widgetEntity.setClusterEntity(clusterEntity);
            widgetEntity.setScope(WidgetResourceProvider.SCOPE.CLUSTER.name());
            widgetEntity.setWidgetName(layoutInfo.getWidgetName());
            widgetEntity.setDefaultSectionName(layoutInfo.getDefaultSectionName());
            widgetEntity.setAuthor(user);
            widgetEntity.setDescription(layoutInfo.getDescription());
            widgetEntity.setTimeCreated(createTime);
            widgetEntity.setWidgetType(layoutInfo.getType());
            widgetEntity.setMetrics(this.gson.toJson(layoutInfo.getMetricsInfo()));
            widgetEntity.setProperties(this.gson.toJson(layoutInfo.getProperties()));
            widgetEntity.setWidgetValues(this.gson.toJson(layoutInfo.getValues()));
            widgetEntity.setListWidgetLayoutUserWidgetEntity(new LinkedList<WidgetLayoutUserWidgetEntity>());
            LOG.info("Creating cluster widget with: name = " + layoutInfo.getWidgetName() + ", type = " + layoutInfo.getType() + ", cluster = " + clusterEntity.getClusterName());
            if (!layoutInfo.isVisible()) {
                this.widgetDAO.create(widgetEntity);
            }
            return widgetEntity;
        }
        LOG.warn("Skip creating widget from stack artifact since one or more already exits with name = " + layoutInfo.getWidgetName() + ", clusterId = " + clusterEntity.getClusterId() + ", user = " + user);
        return null;
    }

    @Transactional
    void createWidgetsAndLayouts(Cluster cluster, List<WidgetLayout> widgetLayouts) {
        String user = "ambari";
        Long clusterId = cluster.getClusterId();
        ClusterEntity clusterEntity = this.clusterDAO.findById(clusterId);
        if (clusterEntity == null) {
            return;
        }
        Long now = System.currentTimeMillis();
        if (widgetLayouts != null) {
            for (WidgetLayout widgetLayout : widgetLayouts) {
                int order;
                List<WidgetLayoutEntity> existingEntities = this.widgetLayoutDAO.findByName(clusterId, widgetLayout.getLayoutName(), user);
                if (existingEntities == null || existingEntities.isEmpty()) {
                    WidgetLayoutEntity layoutEntity = new WidgetLayoutEntity();
                    layoutEntity.setClusterEntity(clusterEntity);
                    layoutEntity.setClusterId(clusterId);
                    layoutEntity.setLayoutName(widgetLayout.getLayoutName());
                    layoutEntity.setDisplayName(widgetLayout.getDisplayName());
                    layoutEntity.setSectionName(widgetLayout.getSectionName());
                    layoutEntity.setScope(WidgetLayoutResourceProvider.SCOPE.CLUSTER.name());
                    layoutEntity.setUserName(user);
                    LinkedList<WidgetLayoutUserWidgetEntity> widgetLayoutUserWidgetEntityList = new LinkedList<WidgetLayoutUserWidgetEntity>();
                    order = 0;
                    for (WidgetLayoutInfo layoutInfo : widgetLayout.getWidgetLayoutInfoList()) {
                        WidgetEntity widgetEntity;
                        if (layoutInfo.getDefaultSectionName() == null) {
                            layoutInfo.setDefaultSectionName(layoutEntity.getSectionName());
                        }
                        if ((widgetEntity = this.addIfNotExistsWidgetEntity(layoutInfo, clusterEntity, user, now)) == null || !layoutInfo.isVisible()) continue;
                        WidgetLayoutUserWidgetEntity widgetLayoutUserWidgetEntity = new WidgetLayoutUserWidgetEntity();
                        widgetLayoutUserWidgetEntity.setWidget(widgetEntity);
                        widgetLayoutUserWidgetEntity.setWidgetOrder(order++);
                        widgetLayoutUserWidgetEntity.setWidgetLayout(layoutEntity);
                        widgetLayoutUserWidgetEntityList.add(widgetLayoutUserWidgetEntity);
                        widgetEntity.getListWidgetLayoutUserWidgetEntity().add(widgetLayoutUserWidgetEntity);
                    }
                    layoutEntity.setListWidgetLayoutUserWidgetEntity(widgetLayoutUserWidgetEntityList);
                    this.widgetLayoutDAO.createWithFlush(layoutEntity);
                    continue;
                }
                if (existingEntities.size() > 1) {
                    LOG.warn("Skip updating layout since multiple widget layouts found with: name = " + widgetLayout.getLayoutName() + ", user = " + user + ", cluster = " + cluster.getClusterName());
                    continue;
                }
                WidgetLayoutEntity existingLayoutEntity = existingEntities.iterator().next();
                existingLayoutEntity.setSectionName(widgetLayout.getSectionName());
                existingLayoutEntity.setDisplayName(widgetLayout.getDisplayName());
                List<WidgetLayoutUserWidgetEntity> layoutUserWidgetEntities = existingLayoutEntity.getListWidgetLayoutUserWidgetEntity();
                if (layoutUserWidgetEntities == null) {
                    layoutUserWidgetEntities = new LinkedList<WidgetLayoutUserWidgetEntity>();
                    existingLayoutEntity.setListWidgetLayoutUserWidgetEntity(layoutUserWidgetEntities);
                }
                order = layoutUserWidgetEntities.size() - 1;
                List<WidgetLayoutInfo> layoutInfoList = widgetLayout.getWidgetLayoutInfoList();
                if (layoutInfoList != null && !layoutInfoList.isEmpty()) {
                    for (WidgetLayoutInfo layoutInfo : layoutInfoList) {
                        WidgetEntity widgetEntity = this.addIfNotExistsWidgetEntity(layoutInfo, clusterEntity, user, now);
                        if (widgetEntity == null || !layoutInfo.isVisible()) continue;
                        WidgetLayoutUserWidgetEntity widgetLayoutUserWidgetEntity = new WidgetLayoutUserWidgetEntity();
                        widgetLayoutUserWidgetEntity.setWidget(widgetEntity);
                        widgetLayoutUserWidgetEntity.setWidgetOrder(order++);
                        widgetLayoutUserWidgetEntity.setWidgetLayout(existingLayoutEntity);
                        layoutUserWidgetEntities.add(widgetLayoutUserWidgetEntity);
                        widgetEntity.getListWidgetLayoutUserWidgetEntity().add(widgetLayoutUserWidgetEntity);
                    }
                }
                this.widgetLayoutDAO.mergeWithFlush(existingLayoutEntity);
            }
        }
    }

    @Override
    public TimelineMetricCacheProvider getTimelineMetricCacheProvider() {
        return (TimelineMetricCacheProvider)this.injector.getInstance(TimelineMetricCacheProvider.class);
    }

    @Override
    public MetricPropertyProviderFactory getMetricPropertyProviderFactory() {
        return (MetricPropertyProviderFactory)this.injector.getInstance(MetricPropertyProviderFactory.class);
    }

    @Override
    public LoggingSearchPropertyProvider getLoggingSearchPropertyProvider() {
        return (LoggingSearchPropertyProvider)this.injector.getInstance(LoggingSearchPropertyProvider.class);
    }

    @Override
    public LoggingService getLoggingService(String clusterName) {
        LoggingService loggingService = new LoggingService(clusterName);
        this.injector.injectMembers((Object)loggingService);
        return loggingService;
    }

    @Override
    public OBDPEventPublisher getAmbariEventPublisher() {
        return (OBDPEventPublisher)this.injector.getInstance(OBDPEventPublisher.class);
    }

    @Override
    public KerberosHelper getKerberosHelper() {
        return this.kerberosHelper;
    }

    @Override
    public CredentialStoreService getCredentialStoreService() {
        return this.credentialStoreService;
    }

    public Map<String, String> getCredentialStoreServiceProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("storage.persistent", String.valueOf(this.credentialStoreService.isInitialized(CredentialStoreType.PERSISTED)));
        properties.put("storage.temporary", String.valueOf(this.credentialStoreService.isInitialized(CredentialStoreType.TEMPORARY)));
        return properties;
    }

    @Override
    public MetricsCollectorHAManager getMetricsCollectorHAManager() {
        return (MetricsCollectorHAManager)this.injector.getInstance(MetricsCollectorHAManager.class);
    }

    protected void validateAuthorizationToUpdateServiceUsersAndGroups(Cluster cluster, String configType, Map<String, String[]> propertyChanges) throws AuthorizationException {
        if (propertyChanges != null && !propertyChanges.isEmpty() && !AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), RoleAuthorization.SERVICE_SET_SERVICE_USERS_GROUPS)) {
            Set<String> groupProperties;
            Map<PropertyInfo.PropertyType, Set<String>> propertyTypes = cluster.getConfigPropertiesTypes(configType);
            HashSet<String> propertiesToCheck = new HashSet<String>();
            Set<String> userProperties = propertyTypes.get((Object)PropertyInfo.PropertyType.USER);
            if (userProperties != null) {
                propertiesToCheck.addAll(userProperties);
            }
            if ((groupProperties = propertyTypes.get((Object)PropertyInfo.PropertyType.GROUP)) != null) {
                propertiesToCheck.addAll(groupProperties);
            }
            for (String propertyName : propertiesToCheck) {
                String[] values = propertyChanges.get(propertyName);
                if (values == null) continue;
                String existingValue = values[0];
                String requestedValue = values[1];
                if (!(existingValue == null ? requestedValue != null : !existingValue.equals(requestedValue))) continue;
                throw new AuthorizationException("The authenticated user is not authorized to set service user and groups");
            }
        }
    }

    protected void validateAuthorizationToManageServiceAutoStartConfiguration(Cluster cluster, String configType, Map<String, String[]> propertyChanges) throws AuthorizationException {
        if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), RoleAuthorization.CLUSTER_MANAGE_AUTO_START) && "cluster-env".equals(configType) && propertyChanges.containsKey("recovery_enabled")) {
            throw new AuthorizationException("The authenticated user is not authorized to set service user and groups");
        }
    }

    private void validateAuthorizationToModifyConfigurations(Cluster cluster, String configType, Map<String, String[]> propertyChanges, Map<String, Set<String>> changesToIgnore, boolean isServiceConfiguration) throws AuthorizationException {
        if (propertyChanges != null && !propertyChanges.isEmpty()) {
            boolean isAuthorized;
            boolean bl = isAuthorized = isServiceConfiguration ? AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), RoleAuthorization.SERVICE_MODIFY_CONFIGS) : AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), RoleAuthorization.CLUSTER_MODIFY_CONFIGS);
            if (!isAuthorized && changesToIgnore != null) {
                Map<String, String[]> relevantPropertyChanges;
                Set<String> relevantChangesToIgnore = changesToIgnore.get(configType);
                if (relevantChangesToIgnore == null) {
                    relevantPropertyChanges = propertyChanges;
                } else {
                    relevantPropertyChanges = new HashMap<String, String[]>(propertyChanges);
                    for (String propertyName : relevantChangesToIgnore) {
                        relevantPropertyChanges.remove(propertyName);
                    }
                }
                if (relevantPropertyChanges.size() == 0) {
                    return;
                }
            }
            if (!isAuthorized) {
                throw new AuthorizationException(String.format("The authenticated user does not have authorization to modify %s configurations", isServiceConfiguration ? "service" : "cluster"));
            }
        }
    }

    @Override
    public void deleteExtensionLink(ExtensionLinkRequest request) throws OBDPException {
        if (request.getLinkId() == null) {
            throw new IllegalArgumentException("Link ID should be provided");
        }
        ExtensionLinkEntity linkEntity = null;
        try {
            linkEntity = this.linkDAO.findById(Long.parseLong(request.getLinkId()));
        }
        catch (RollbackException e) {
            throw new OBDPException("Unable to find extension link, linkId=" + request.getLinkId(), (Throwable)e);
        }
        StackInfo stackInfo = this.obdpMetaInfo.getStack(linkEntity.getStack().getStackName(), linkEntity.getStack().getStackVersion());
        if (stackInfo == null) {
            throw new StackAccessException("stackName=" + linkEntity.getStack().getStackName() + ", stackVersion=" + linkEntity.getStack().getStackVersion());
        }
        ExtensionInfo extensionInfo = this.obdpMetaInfo.getExtension(linkEntity.getExtension().getExtensionName(), linkEntity.getExtension().getExtensionVersion());
        if (extensionInfo == null) {
            throw new StackAccessException("extensionName=" + linkEntity.getExtension().getExtensionName() + ", extensionVersion=" + linkEntity.getExtension().getExtensionVersion());
        }
        ExtensionHelper.validateDeleteLink(this.getClusters(), stackInfo, extensionInfo);
        this.obdpMetaInfo.getStackManager().unlinkStackAndExtension(stackInfo, extensionInfo);
        try {
            this.linkDAO.remove(linkEntity);
        }
        catch (RollbackException e) {
            throw new OBDPException("Unable to delete extension link, linkId=" + request.getLinkId() + ", stackName=" + request.getStackName() + ", stackVersion=" + request.getStackVersion() + ", extensionName=" + request.getExtensionName() + ", extensionVersion=" + request.getExtensionVersion(), (Throwable)e);
        }
    }

    @Override
    public void createExtensionLink(ExtensionLinkRequest request) throws OBDPException {
        if (StringUtils.isBlank((String)request.getStackName()) || StringUtils.isBlank((String)request.getStackVersion()) || StringUtils.isBlank((String)request.getExtensionName()) || StringUtils.isBlank((String)request.getExtensionVersion())) {
            throw new IllegalArgumentException("Stack name, stack version, extension name and extension version should be provided");
        }
        StackInfo stackInfo = this.obdpMetaInfo.getStack(request.getStackName(), request.getStackVersion());
        if (stackInfo == null) {
            throw new StackAccessException("stackName=" + request.getStackName() + ", stackVersion=" + request.getStackVersion());
        }
        ExtensionInfo extensionInfo = this.obdpMetaInfo.getExtension(request.getExtensionName(), request.getExtensionVersion());
        if (extensionInfo == null) {
            throw new StackAccessException("extensionName=" + request.getExtensionName() + ", extensionVersion=" + request.getExtensionVersion());
        }
        this.helper.createExtensionLink(this.obdpMetaInfo.getStackManager(), stackInfo, extensionInfo);
    }

    @Override
    public void updateExtensionLink(ExtensionLinkRequest request) throws OBDPException {
        if (request.getLinkId() == null) {
            throw new OBDPException("Link ID should be provided");
        }
        ExtensionLinkEntity linkEntity = null;
        try {
            linkEntity = this.linkDAO.findById(Long.parseLong(request.getLinkId()));
        }
        catch (RollbackException e) {
            throw new OBDPException("Unable to find extension link, linkId=" + request.getLinkId(), (Throwable)e);
        }
        this.updateExtensionLink(linkEntity, request);
    }

    @Override
    public void updateExtensionLink(ExtensionLinkEntity oldLinkEntity, ExtensionLinkRequest newLinkRequest) throws OBDPException {
        StackInfo stackInfo = this.obdpMetaInfo.getStack(oldLinkEntity.getStack().getStackName(), oldLinkEntity.getStack().getStackVersion());
        if (stackInfo == null) {
            throw new StackAccessException(String.format("stackName=%s, stackVersion=%s", oldLinkEntity.getStack().getStackName(), oldLinkEntity.getStack().getStackVersion()));
        }
        if (newLinkRequest.getExtensionName() == null || newLinkRequest.getExtensionVersion() == null) {
            throw new OBDPException(String.format("Invalid extension name or version: %s/%s", newLinkRequest.getExtensionName(), newLinkRequest.getExtensionVersion()));
        }
        if (!newLinkRequest.getExtensionName().equals(oldLinkEntity.getExtension().getExtensionName())) {
            throw new OBDPException(String.format("Update is not allowed to switch the extension name, only the version.  Old name/new name: %s/%s", oldLinkEntity.getExtension().getExtensionName(), newLinkRequest.getExtensionName()));
        }
        ExtensionInfo oldExtensionInfo = this.obdpMetaInfo.getExtension(oldLinkEntity.getExtension().getExtensionName(), oldLinkEntity.getExtension().getExtensionVersion());
        ExtensionInfo newExtensionInfo = this.obdpMetaInfo.getExtension(newLinkRequest.getExtensionName(), newLinkRequest.getExtensionVersion());
        if (oldExtensionInfo == null) {
            throw new StackAccessException(String.format("Old extensionName=%s, extensionVersion=%s", oldLinkEntity.getExtension().getExtensionName(), oldLinkEntity.getExtension().getExtensionVersion()));
        }
        if (newExtensionInfo == null) {
            throw new StackAccessException(String.format("New extensionName=%s, extensionVersion=%s", newLinkRequest.getExtensionName(), newLinkRequest.getExtensionVersion()));
        }
        this.helper.updateExtensionLink(this.obdpMetaInfo.getStackManager(), oldLinkEntity, stackInfo, oldExtensionInfo, newExtensionInfo);
    }

    @Override
    public QuickLinkVisibilityController getQuicklinkVisibilityController() {
        SettingEntity entity = this.settingDAO.findByName("QuickLinksProfile");
        String quickLinkProfileJson = null != entity ? entity.getContent() : null;
        return QuickLinkVisibilityControllerFactory.get(quickLinkProfileJson);
    }

    public MetadataUpdateEvent getClustersMetadata() throws OBDPException {
        TreeMap<String, MetadataCluster> metadataClusters = new TreeMap<String, MetadataCluster>();
        for (Cluster cl : this.clusters.getClusters().values()) {
            StackId stackId = cl.getDesiredStackVersion();
            SecurityType securityType = cl.getSecurityType();
            MetadataCluster metadataCluster = new MetadataCluster(securityType, this.getMetadataServiceLevelParams(cl), true, this.getMetadataClusterLevelParams(cl, stackId), null);
            metadataClusters.put(Long.toString(cl.getClusterId()), metadataCluster);
        }
        MetadataUpdateEvent metadataUpdateEvent = new MetadataUpdateEvent(metadataClusters, this.getMetadataAmbariLevelParams(), this.getMetadataAgentConfigs(), UpdateEventType.CREATE);
        return metadataUpdateEvent;
    }

    public MetadataUpdateEvent getClusterMetadata(Cluster cl) throws OBDPException {
        TreeMap<String, MetadataCluster> metadataClusters = new TreeMap<String, MetadataCluster>();
        MetadataCluster metadataCluster = new MetadataCluster(cl.getSecurityType(), this.getMetadataServiceLevelParams(cl), true, this.getMetadataClusterLevelParams(cl, cl.getDesiredStackVersion()), null);
        metadataClusters.put(Long.toString(cl.getClusterId()), metadataCluster);
        return new MetadataUpdateEvent(metadataClusters, null, this.getMetadataAgentConfigs(), UpdateEventType.UPDATE);
    }

    @Override
    public MetadataUpdateEvent getClusterMetadataOnConfigsUpdate(Cluster cl) throws OBDPException {
        TreeMap<String, MetadataCluster> metadataClusters = new TreeMap<String, MetadataCluster>();
        metadataClusters.put(Long.toString(cl.getClusterId()), MetadataCluster.clusterLevelParamsMetadataCluster(null, this.getMetadataClusterLevelParams(cl, cl.getDesiredStackVersion())));
        return new MetadataUpdateEvent(metadataClusters, null, this.getMetadataAgentConfigs(), UpdateEventType.UPDATE);
    }

    public MetadataUpdateEvent getClusterMetadataOnRepoUpdate(Cluster cl) throws OBDPException {
        TreeMap<String, MetadataCluster> metadataClusters = new TreeMap<String, MetadataCluster>();
        metadataClusters.put(Long.toString(cl.getClusterId()), MetadataCluster.serviceLevelParamsMetadataCluster(null, this.getMetadataServiceLevelParams(cl), true));
        return new MetadataUpdateEvent(metadataClusters, null, this.getMetadataAgentConfigs(), UpdateEventType.UPDATE);
    }

    public MetadataUpdateEvent getClusterMetadataOnServiceInstall(Cluster cl, String serviceName) throws OBDPException {
        return this.getClusterMetadataOnServiceCredentialStoreUpdate(cl, serviceName);
    }

    public MetadataUpdateEvent getClusterMetadataOnServiceCredentialStoreUpdate(Cluster cl, String serviceName) throws OBDPException {
        TreeMap<String, MetadataCluster> metadataClusters = new TreeMap<String, MetadataCluster>();
        metadataClusters.put(Long.toString(cl.getClusterId()), MetadataCluster.serviceLevelParamsMetadataCluster(null, this.getMetadataServiceLevelParams(cl), false));
        return new MetadataUpdateEvent(metadataClusters, null, this.getMetadataAgentConfigs(), UpdateEventType.UPDATE);
    }

    private String getClientsToUpdateConfigs(ComponentInfo componentInfo) {
        List<String> clientsToUpdateConfigsList = componentInfo.getClientsToUpdateConfigs();
        if (clientsToUpdateConfigsList == null) {
            clientsToUpdateConfigsList = new ArrayList<String>();
            clientsToUpdateConfigsList.add("*");
        }
        return this.gson.toJson(clientsToUpdateConfigsList);
    }

    private Boolean getUnlimitedKeyJCERequirement(ComponentInfo componentInfo, SecurityType clusterSecurityType) {
        UnlimitedKeyJCERequirement unlimitedKeyJCERequirement = componentInfo.getUnlimitedKeyJCERequired();
        if (unlimitedKeyJCERequirement == null) {
            unlimitedKeyJCERequirement = UnlimitedKeyJCERequirement.DEFAULT;
        }
        return UnlimitedKeyJCERequirement.ALWAYS == unlimitedKeyJCERequirement || UnlimitedKeyJCERequirement.KERBEROS_ENABLED == unlimitedKeyJCERequirement && clusterSecurityType == SecurityType.KERBEROS;
    }

    public TreeMap<String, String> getTopologyComponentLevelParams(Long clusterId, String serviceName, String componentName, SecurityType clusterSecurityType) throws OBDPException {
        TreeMap<String, String> statusCommandParams = new TreeMap<String, String>();
        RepositoryVersionEntity repositoryVersion = this.getComponentRepositoryVersion(clusterId, serviceName, componentName);
        if (null != repositoryVersion) {
            StackId stackId = repositoryVersion.getStackId();
            ComponentInfo componentInfo = this.obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), serviceName, componentName);
            statusCommandParams.put("clientsToUpdateConfigs", this.getClientsToUpdateConfigs(componentInfo));
            statusCommandParams.put("unlimited_key_jce_required", Boolean.toString(this.getUnlimitedKeyJCERequirement(componentInfo, clusterSecurityType)));
        }
        return statusCommandParams;
    }

    @Override
    public Map<String, BlueprintProvisioningState> getBlueprintProvisioningStates(Long clusterId, Long hostId) throws OBDPException {
        HashMap<String, BlueprintProvisioningState> blueprintProvisioningStates = new HashMap<String, BlueprintProvisioningState>();
        Host host = this.clusters.getHostById(hostId);
        Cluster cl = this.clusters.getCluster(clusterId);
        for (ServiceComponentHost sch : cl.getServiceComponentHosts(host.getHostName())) {
            if (sch.isClientComponent()) continue;
            blueprintProvisioningStates.put(sch.getServiceComponentName(), sch.getDesiredStateEntity().getBlueprintProvisioningState());
        }
        return blueprintProvisioningStates;
    }

    public TreeMap<String, String> getTopologyCommandParams(Long clusterId, String serviceName, String componentName, ServiceComponentHost sch) throws OBDPException {
        String schVersion;
        TreeMap<String, String> commandParams = new TreeMap<String, String>();
        RepositoryVersionEntity repositoryVersion = this.getComponentRepositoryVersion(clusterId, serviceName, componentName);
        if (null != repositoryVersion) {
            StackId stackId = repositoryVersion.getStackId();
            ServiceInfo serviceInfo = this.obdpMetaInfo.getService(stackId.getStackName(), stackId.getStackVersion(), serviceName);
            ComponentInfo componentInfo = this.obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), serviceName, componentName);
            commandParams.put("service_package_folder", serviceInfo.getServicePackageFolder());
            String scriptName = null;
            String scriptCommandTimeout = "";
            CommandScriptDefinition script = componentInfo.getCommandScript();
            if (serviceInfo.getSchemaVersion().equals("2.0")) {
                if (script != null) {
                    scriptName = script.getScript();
                    if (script.getTimeout() > 0) {
                        scriptCommandTimeout = String.valueOf(script.getTimeout());
                    }
                } else {
                    String message = String.format("Component %s of service %s has not command script defined", componentName, serviceName);
                    throw new OBDPException(message);
                }
            }
            String agentDefaultCommandTimeout = this.configs.getDefaultAgentTaskTimeout(false);
            String actualTimeout = !scriptCommandTimeout.equals("") ? scriptCommandTimeout : agentDefaultCommandTimeout;
            commandParams.put("command_timeout", actualTimeout);
            commandParams.put("script", scriptName);
            commandParams.put("script_type", script.getScriptType().toString());
        }
        if (!(schVersion = sch.getVersion()).equals("UNKNOWN")) {
            commandParams.put("version", schVersion);
        }
        return commandParams;
    }

    private RepositoryVersionEntity getComponentRepositoryVersion(Long clusterId, String serviceName, String componentName) throws OBDPException {
        Service service;
        RepositoryVersionEntity repositoryVersion = null;
        if (!StringUtils.isEmpty((String)serviceName) && null != (service = this.clusters.getCluster(clusterId).getService(serviceName))) {
            ServiceComponent serviceComponent;
            repositoryVersion = service.getDesiredRepositoryVersion();
            if (!StringUtils.isEmpty((String)componentName) && service.getServiceComponents().containsKey(componentName) && null != (serviceComponent = service.getServiceComponent(componentName))) {
                repositoryVersion = serviceComponent.getDesiredRepositoryVersion();
            }
        }
        return repositoryVersion;
    }

    public TreeMap<String, String> getMetadataClusterLevelParams(Cluster cluster, StackId stackId) throws OBDPException {
        TreeMap<String, String> clusterLevelParams = new TreeMap<String, String>();
        clusterLevelParams.put("stack_name", stackId.getStackName());
        clusterLevelParams.put("stack_version", stackId.getStackVersion());
        clusterLevelParams.putAll(this.getMetadataClusterLevelConfigsParams(cluster, stackId));
        clusterLevelParams.put("cluster_name", cluster.getClusterName());
        clusterLevelParams.put("hooks_folder", this.configs.getProperty(Configuration.HOOKS_FOLDER));
        return clusterLevelParams;
    }

    private TreeMap<String, String> getMetadataClusterLevelConfigsParams(Cluster cluster, StackId stackId) throws OBDPException {
        TreeMap<String, String> clusterLevelParams = new TreeMap<String, String>();
        Map<String, DesiredConfig> desiredConfigs = cluster.getDesiredConfigs(false);
        if (MapUtils.isNotEmpty(desiredConfigs)) {
            Set<String> userSet = this.configHelper.getPropertyValuesWithPropertyType(stackId, PropertyInfo.PropertyType.USER, cluster, desiredConfigs);
            String userList = this.gson.toJson(userSet);
            clusterLevelParams.put("user_list", userList);
            Map<String, Set<String>> userGroupsMap = this.configHelper.createUserGroupsMap(stackId, cluster, desiredConfigs);
            String userGroups = this.gson.toJson(userGroupsMap);
            clusterLevelParams.put("user_groups", userGroups);
            Set<String> groupSet = this.configHelper.getPropertyValuesWithPropertyType(stackId, PropertyInfo.PropertyType.GROUP, cluster, desiredConfigs);
            String groupList = this.gson.toJson(groupSet);
            clusterLevelParams.put("group_list", groupList);
        }
        Set<String> notManagedHdfsPathSet = this.configHelper.getPropertyValuesWithPropertyType(stackId, PropertyInfo.PropertyType.NOT_MANAGED_HDFS_PATH, cluster, desiredConfigs);
        String notManagedHdfsPathList = this.gson.toJson(notManagedHdfsPathSet);
        clusterLevelParams.put("not_managed_hdfs_path_list", notManagedHdfsPathList);
        for (Service service : cluster.getServices().values()) {
            ServiceInfo serviceInfoInstance = this.obdpMetaInfo.getService(service);
            String serviceType = serviceInfoInstance.getServiceType();
            if (serviceType == null) continue;
            LOG.debug("Adding {} to command parameters for {}", (Object)serviceInfoInstance.getServiceType(), (Object)serviceInfoInstance.getName());
            clusterLevelParams.put("dfs_type", serviceInfoInstance.getServiceType());
            break;
        }
        return clusterLevelParams;
    }

    public TreeMap<String, MetadataServiceInfo> getMetadataServiceLevelParams(Cluster cluster) throws OBDPException {
        TreeMap<String, MetadataServiceInfo> serviceLevelParams = new TreeMap<String, MetadataServiceInfo>();
        for (Map.Entry<String, Service> serviceEntry : cluster.getServices().entrySet()) {
            Service service = serviceEntry.getValue();
            serviceLevelParams.putAll(this.getMetadataServiceLevelParams(service));
        }
        return serviceLevelParams;
    }

    public TreeMap<String, MetadataServiceInfo> getMetadataServiceLevelParams(Service service) throws OBDPException {
        TreeMap<String, MetadataServiceInfo> serviceLevelParams = new TreeMap<String, MetadataServiceInfo>();
        RepositoryVersionEntity repositoryVersion = service.getDesiredRepositoryVersion();
        if (null != repositoryVersion) {
            StackId serviceStackId = repositoryVersion.getStackId();
            ServiceInfo serviceInfo = this.obdpMetaInfo.getService(serviceStackId.getStackName(), serviceStackId.getStackVersion(), service.getName());
            Long statusCommandTimeout = null;
            if (serviceInfo.getCommandScript() != null) {
                statusCommandTimeout = new Long(this.customCommandExecutionHelper.getStatusCommandTimeout(serviceInfo));
            }
            String servicePackageFolder = serviceInfo.getServicePackageFolder();
            Map<String, Map<String, String>> configCredentials = this.configCredentialsForService.get(service.getName());
            if (configCredentials == null) {
                configCredentials = this.configHelper.getCredentialStoreEnabledProperties(serviceStackId, service);
                this.configCredentialsForService.put(service.getName(), configCredentials);
            }
            serviceLevelParams.put(serviceInfo.getName(), new MetadataServiceInfo(serviceInfo.getVersion(), service.isCredentialStoreEnabled(), configCredentials, statusCommandTimeout, servicePackageFolder));
        }
        return serviceLevelParams;
    }

    public TreeMap<String, String> getMetadataAmbariLevelParams() {
        TreeMap<String, String> clusterLevelParams = new TreeMap<String, String>();
        clusterLevelParams.put("jdk_location", this.getJdkResourceUrl());
        clusterLevelParams.put("java_home", this.getJavaHome());
        clusterLevelParams.put("ambari_java_home", this.getAmbariJavaHome());
        clusterLevelParams.put("java_version", String.valueOf(this.configs.getJavaVersion()));
        clusterLevelParams.put("jdk_name", this.getJDKName());
        clusterLevelParams.put("jce_name", this.getJCEName());
        clusterLevelParams.put("db_name", this.getServerDB());
        clusterLevelParams.put("mysql_jdbc_url", this.getMysqljdbcUrl());
        clusterLevelParams.put("oracle_jdbc_url", this.getOjdbcUrl());
        clusterLevelParams.put("db_driver_filename", this.configs.getMySQLJarName());
        clusterLevelParams.putAll(this.getRcaParameters());
        clusterLevelParams.put("host_sys_prepped", this.configs.areHostsSysPrepped());
        clusterLevelParams.put("agent_stack_retry_on_unavailability", this.configs.isAgentStackRetryOnInstallEnabled());
        clusterLevelParams.put("agent_stack_retry_count", this.configs.getAgentStackRetryOnInstallCount());
        boolean serverUseSsl = this.configs.getApiSSLAuthentication();
        int port = serverUseSsl ? this.configs.getClientSSLApiPort() : this.configs.getClientApiPort();
        clusterLevelParams.put(AMBARI_SERVER_HOST, StageUtils.getHostName());
        clusterLevelParams.put(AMBARI_SERVER_PORT, Integer.toString(port));
        clusterLevelParams.put(AMBARI_SERVER_USE_SSL, Boolean.toString(serverUseSsl));
        for (Map.Entry<String, String> dbConnectorName : this.configs.getDatabaseConnectorNames().entrySet()) {
            clusterLevelParams.put(dbConnectorName.getKey(), dbConnectorName.getValue());
        }
        for (Map.Entry<String, String> previousDBConnectorName : this.configs.getPreviousDatabaseConnectorNames().entrySet()) {
            clusterLevelParams.put(previousDBConnectorName.getKey(), previousDBConnectorName.getValue());
        }
        clusterLevelParams.put("gpl_license_accepted", this.configs.getGplLicenseAccepted().toString());
        return clusterLevelParams;
    }

    public SortedMap<String, SortedMap<String, String>> getMetadataAgentConfigs() {
        TreeMap<String, SortedMap<String, String>> agentConfigs = new TreeMap<String, SortedMap<String, String>>();
        Map<String, Map<String, String>> agentConfigsMap = this.configs.getAgentConfigsMap();
        for (String key : agentConfigsMap.keySet()) {
            agentConfigs.put(key, new TreeMap<String, String>(agentConfigsMap.get(key)));
        }
        return agentConfigs;
    }
}

