/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import id.onyx.obdp.server.api.OBDPErrorHandler;
import id.onyx.obdp.server.api.OBDPPersistFilter;
import id.onyx.obdp.server.api.OBDPViewErrorHandlerProxy;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.OBDPServer;
import id.onyx.obdp.server.controller.SessionHandlerConfigurer;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import id.onyx.obdp.server.security.AmbariViewsSecurityHeaderFilter;
import id.onyx.obdp.server.view.ViewContextImpl;
import id.onyx.obdp.server.view.ViewInstanceHandlerList;
import id.onyx.obdp.server.view.ViewRegistry;
import id.onyx.obdp.view.SystemException;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import jakarta.servlet.Filter;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.session.SessionCache;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.DelegatingFilterProxy;

@Singleton
public class OBDPHandlerList
extends HandlerCollection
implements ViewInstanceHandlerList {
    private static final Pattern VIEW_RESOURCE_TARGET_PATTERN = Pattern.compile("/api/(\\S+)/views/(\\S+)/versions/(\\S+)/instances/(\\S+)/resources/(\\S+)");
    @Inject
    ViewRegistry viewRegistry;
    @Inject
    SessionHandler sessionHandler;
    @Inject
    Provider<WebAppContext> webAppContextProvider;
    @Inject
    OBDPPersistFilter persistFilter;
    @Inject
    DelegatingFilterProxy springSecurityFilter;
    @Inject
    AmbariViewsSecurityHeaderFilter ambariViewsSecurityHeaderFilter;
    @Inject
    SessionHandlerConfigurer sessionHandlerConfigurer;
    @Inject
    Configuration configuration;
    @Inject
    OBDPErrorHandler ambariErrorHandler;
    private final Map<ViewInstanceEntity, WebAppContext> viewHandlerMap = new HashMap<ViewInstanceEntity, WebAppContext>();
    private final Collection<Handler> nonViewHandlers = new HashSet<Handler>();
    private static final Logger LOG = LoggerFactory.getLogger(OBDPHandlerList.class);

    public OBDPHandlerList() {
        super(true, new Handler[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ViewEntity viewEntity = this.getTargetView(target);
        if (viewEntity == null) {
            this.processHandlers(target, baseRequest, request, response);
        } else {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader viewClassLoader = viewEntity.getClassLoader();
                if (viewClassLoader == null) {
                    LOG.debug("No class loader associated with view {}.", (Object)viewEntity.getName());
                } else {
                    Thread.currentThread().setContextClassLoader(viewClassLoader);
                }
                this.processHandlers(target, baseRequest, request, response);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    public void addHandler(Handler handler) {
        this.nonViewHandlers.add(handler);
        super.addHandler(handler);
    }

    @Override
    public void addViewInstance(ViewInstanceEntity viewInstanceDefinition) throws SystemException {
        WebAppContext handler = this.getHandler(viewInstanceDefinition);
        this.viewHandlerMap.put(viewInstanceDefinition, handler);
        super.addHandler((Handler)handler);
        if (!this.isStopped() && !this.isStopping()) {
            try {
                handler.start();
            }
            catch (Exception e) {
                throw new SystemException("Caught exception adding a view instance.", (Throwable)e);
            }
        }
        handler.getSessionHandler().setSessionCache(this.sessionHandler.getSessionCache());
    }

    @Override
    public void shareSessionCacheToViews(SessionCache serverSessionCache) {
        for (WebAppContext webAppContext : this.viewHandlerMap.values()) {
            webAppContext.getSessionHandler().setSessionCache(serverSessionCache);
        }
    }

    @Override
    public void removeViewInstance(ViewInstanceEntity viewInstanceDefinition) {
        Handler handler = (Handler)this.viewHandlerMap.get(viewInstanceDefinition);
        if (handler != null) {
            this.viewHandlerMap.remove(viewInstanceDefinition);
            this.removeHandler(handler);
        }
    }

    private void processHandlers(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Handler[] handlers = this.getHandlers();
        if (handlers != null && this.isStarted() && !this.processHandlers(this.viewHandlerMap.values(), target, baseRequest, request, response)) {
            this.processHandlers(this.nonViewHandlers, target, baseRequest, request, response);
        }
    }

    private boolean processHandlers(Collection<? extends Handler> handlers, String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        for (Handler handler : handlers) {
            handler.handle(target, baseRequest, request, response);
            if (!baseRequest.isHandled()) continue;
            return true;
        }
        return false;
    }

    private WebAppContext getHandler(ViewInstanceEntity viewInstanceDefinition) throws SystemException {
        ViewEntity viewDefinition = viewInstanceDefinition.getViewEntity();
        WebAppContext webAppContext = (WebAppContext)this.webAppContextProvider.get();
        webAppContext.setWar(viewDefinition.getArchive());
        webAppContext.setContextPath(viewInstanceDefinition.getContextPath());
        webAppContext.setClassLoader(viewInstanceDefinition.getViewEntity().getClassLoader());
        webAppContext.setAttribute("obdp-view-context", (Object)new ViewContextImpl(viewInstanceDefinition, this.viewRegistry));
        webAppContext.setSessionHandler((SessionHandler)new SharedSessionHandler(this.sessionHandler));
        webAppContext.addFilter(new FilterHolder((Filter)this.ambariViewsSecurityHeaderFilter), "/*", OBDPServer.DISPATCHER_TYPES);
        webAppContext.addFilter(new FilterHolder((Filter)this.persistFilter), "/*", OBDPServer.DISPATCHER_TYPES);
        webAppContext.addFilter(new FilterHolder((Filter)this.springSecurityFilter), "/*", OBDPServer.DISPATCHER_TYPES);
        webAppContext.setAllowNullPathInfo(true);
        if (webAppContext.getErrorHandler() != null) {
            ErrorHandler errorHandlerProxy = this.createAmbariViewErrorHandlerProxy(webAppContext.getErrorHandler());
            if (errorHandlerProxy != null) {
                webAppContext.setErrorHandler(errorHandlerProxy);
            }
            webAppContext.getErrorHandler().setShowStacks(this.configuration.isServerShowErrorStacks());
        }
        return webAppContext;
    }

    private ErrorHandler createAmbariViewErrorHandlerProxy(ErrorHandler errorHandler) {
        ErrorHandler proxy = null;
        try {
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.setSuperclass(ErrorHandler.class);
            proxy = (ErrorHandler)proxyFactory.create(new Class[0], new Object[0], (MethodHandler)new OBDPViewErrorHandlerProxy(errorHandler, this.ambariErrorHandler));
        }
        catch (Exception e) {
            LOG.error("An error occurred while instantiating the error handler proxy instance", (Throwable)e);
        }
        return proxy;
    }

    private ViewEntity getTargetView(String target) {
        Matcher matcher = VIEW_RESOURCE_TARGET_PATTERN.matcher(target);
        return matcher.matches() ? this.viewRegistry.getDefinition(matcher.group(2), matcher.group(3)) : null;
    }

    private class SharedSessionHandler
    extends SessionHandler {
        public SharedSessionHandler(SessionHandler sessionHandler) {
            this.setSessionIdManager(sessionHandler.getSessionIdManager());
            OBDPHandlerList.this.sessionHandlerConfigurer.configureSessionHandler(this);
        }

        protected void doStop() throws Exception {
        }
    }
}

