/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.actionmanager.Stage;
import id.onyx.obdp.server.agent.AgentCommand;
import id.onyx.obdp.server.agent.ExecutionCommand;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.ActionExecutionContext;
import id.onyx.obdp.server.controller.ExecuteActionRequest;
import id.onyx.obdp.server.controller.ExecuteCommandJson;
import id.onyx.obdp.server.controller.MaintenanceStateHelper;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.RequestOperationLevel;
import id.onyx.obdp.server.controller.internal.RequestResourceFilter;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.metadata.ActionMetadata;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.CommandScriptDefinition;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.CustomCommandDefinition;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.HostComponentAdminState;
import id.onyx.obdp.server.state.HostState;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.ServiceComponentHostEvent;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.State;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostOpInProgressEvent;
import id.onyx.obdp.server.utils.StageUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OBDPCustomCommandExecutionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(OBDPCustomCommandExecutionHelper.class);
    static final Map<String, String> masterToSlaveMappingForDecom = ImmutableMap.builder().put((Object)"NAMENODE", (Object)"DATANODE").put((Object)"RESOURCEMANAGER", (Object)"NODEMANAGER").put((Object)"HBASE_MASTER", (Object)"HBASE_REGIONSERVER").put((Object)"JOBTRACKER", (Object)"TASKTRACKER").build();
    public static final String DECOM_INCLUDED_HOSTS = "included_hosts";
    public static final String DECOM_EXCLUDED_HOSTS = "excluded_hosts";
    public static final String ALL_DECOMMISSIONED_HOSTS = "all_decommissioned_hosts";
    public static final String DECOM_SLAVE_COMPONENT = "slave_type";
    public static final String HBASE_MARK_DRAINING_ONLY = "mark_draining_only";
    public static final String UPDATE_FILES_ONLY = "update_files_only";
    public static final String IS_ADD_OR_DELETE_SLAVE_REQUEST = "is_add_or_delete_slave_request";
    private static final String ALIGN_MAINTENANCE_STATE = "align_maintenance_state";
    public static final int MIN_STRICT_SERVICE_CHECK_TIMEOUT = 120;
    @Inject
    private ActionMetadata actionMetadata;
    @Inject
    private Clusters clusters;
    @Inject
    private OBDPManagementController managementController;
    @Inject
    private Gson gson;
    @Inject
    private Configuration configs;
    @Inject
    private OBDPMetaInfo obdpMetaInfo;
    @Inject
    private ConfigHelper configHelper;
    @Inject
    private MaintenanceStateHelper maintenanceStateHelper;
    @Inject
    private HostRoleCommandDAO hostRoleCommandDAO;
    private Map<String, Map<String, Map<String, String>>> configCredentialsForService = new HashMap<String, Map<String, Map<String, String>>>();
    protected static final String SERVICE_CHECK_COMMAND_NAME = "SERVICE_CHECK";
    protected static final String START_COMMAND_NAME = "START";
    protected static final String RESTART_COMMAND_NAME = "RESTART";
    protected static final String INSTALL_COMMAND_NAME = "INSTALL";
    public static final String DECOMMISSION_COMMAND_NAME = "DECOMMISSION";

    private Boolean isServiceCheckCommand(String command, String service) {
        List<String> actions = this.actionMetadata.getActions(service);
        return actions != null && actions.size() != 0 && actions.contains(command);
    }

    private Boolean isValidCustomCommand(String clusterName, String serviceName, String componentName, String commandName) throws OBDPException {
        if (componentName == null) {
            return false;
        }
        Cluster cluster = this.clusters.getCluster(clusterName);
        Service service = cluster.getService(serviceName);
        ServiceComponent component = service.getServiceComponent(componentName);
        StackId stackId = component.getDesiredStackId();
        ComponentInfo componentInfo = this.obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), serviceName, componentName);
        return componentInfo.isCustomCommand(commandName) || this.actionMetadata.isDefaultHostComponentCommand(commandName);
    }

    private Boolean isValidCustomCommand(ActionExecutionContext actionExecutionContext, RequestResourceFilter resourceFilter) throws OBDPException {
        if (actionExecutionContext.isFutureCommand()) {
            return true;
        }
        String clusterName = actionExecutionContext.getClusterName();
        String serviceName = resourceFilter.getServiceName();
        String componentName = resourceFilter.getComponentName();
        String commandName = actionExecutionContext.getActionName();
        if (componentName == null) {
            return false;
        }
        return this.isValidCustomCommand(clusterName, serviceName, componentName, commandName);
    }

    private Boolean isValidCustomCommand(ExecuteActionRequest actionRequest, RequestResourceFilter resourceFilter) throws OBDPException {
        String clusterName = actionRequest.getClusterName();
        String serviceName = resourceFilter.getServiceName();
        String componentName = resourceFilter.getComponentName();
        String commandName = actionRequest.getCommandName();
        if (componentName == null) {
            return false;
        }
        return this.isValidCustomCommand(clusterName, serviceName, componentName, commandName);
    }

    private String getReadableCustomCommandDetail(ActionExecutionContext actionRequest, RequestResourceFilter resourceFilter) {
        StringBuilder sb = new StringBuilder();
        sb.append(actionRequest.getActionName());
        if (resourceFilter.getServiceName() != null && !resourceFilter.getServiceName().equals("")) {
            sb.append(" ");
            sb.append(resourceFilter.getServiceName());
        }
        if (resourceFilter.getComponentName() != null && !resourceFilter.getComponentName().equals("")) {
            sb.append("/");
            sb.append(resourceFilter.getComponentName());
        }
        return sb.toString();
    }

    private void addCustomCommandAction(final ActionExecutionContext actionExecutionContext, final RequestResourceFilter resourceFilter, Stage stage, Map<String, String> additionalCommandParams, String commandDetail, Map<String, String> requestParams) throws OBDPException {
        final String serviceName = resourceFilter.getServiceName();
        final String componentName = resourceFilter.getComponentName();
        String commandName = actionExecutionContext.getActionName();
        boolean retryAllowed = actionExecutionContext.isRetryAllowed();
        boolean autoSkipFailure = actionExecutionContext.isFailureAutoSkipped();
        String clusterName = stage.getClusterName();
        final Cluster cluster = this.clusters.getCluster(clusterName);
        HashSet<String> candidateHosts = new HashSet<String>(resourceFilter.getHostNames());
        Set<String> ignoredHosts = this.maintenanceStateHelper.filterHostsInMaintenanceState(candidateHosts, new MaintenanceStateHelper.HostPredicate(){

            @Override
            public boolean shouldHostBeRemoved(String hostname) throws OBDPException {
                if (actionExecutionContext.isFutureCommand()) {
                    return false;
                }
                return !OBDPCustomCommandExecutionHelper.this.maintenanceStateHelper.isOperationAllowed(cluster, actionExecutionContext.getOperationLevel(), resourceFilter, serviceName, componentName, hostname);
            }
        });
        Set<String> unhealthyHosts = this.getUnhealthyHosts(candidateHosts, actionExecutionContext, resourceFilter);
        if (!ignoredHosts.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("While building the {} custom command for {}/{}, the following hosts were excluded: unhealthy[{}], maintenance[{}]", new Object[]{commandName, serviceName, componentName, StringUtils.join(unhealthyHosts, (char)','), StringUtils.join(ignoredHosts, (char)',')});
            }
        } else if (!unhealthyHosts.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("While building the {} custom command for {}/{}, the following hosts were excluded: unhealthy[{}], maintenance[{}]", new Object[]{commandName, serviceName, componentName, StringUtils.join(unhealthyHosts, (char)','), StringUtils.join(ignoredHosts, (char)',')});
            }
        } else if (candidateHosts.isEmpty()) {
            String message = MessageFormat.format("While building the {0} custom command for {1}/{2}, there were no healthy eligible hosts", commandName, serviceName, componentName);
            throw new OBDPException(message);
        }
        Service service = cluster.getService(serviceName);
        StackId stackId = service.getDesiredStackId();
        if (null != actionExecutionContext.getStackId()) {
            stackId = actionExecutionContext.getStackId();
        }
        OBDPMetaInfo obdpMetaInfo = this.managementController.getAmbariMetaInfo();
        ServiceInfo serviceInfo = obdpMetaInfo.getService(service);
        CustomCommandDefinition customCommandDefinition = null;
        ComponentInfo ci = serviceInfo.getComponentByName(componentName);
        if (ci != null) {
            customCommandDefinition = ci.getCustomCommandByName(commandName);
        }
        long nowTimestamp = System.currentTimeMillis();
        for (String hostName : candidateHosts) {
            String refreshConfigsCommand;
            boolean isUpgradeSuspended;
            String componentRollingRestartTimeout;
            Config clusterEnvConfig;
            String requestContext;
            HostRoleCommand cmd;
            stage.addHostRoleExecutionCommand(hostName, Role.valueOf(componentName), RoleCommand.CUSTOM_COMMAND, (ServiceComponentHostEvent)new ServiceComponentHostOpInProgressEvent(componentName, hostName, nowTimestamp), cluster.getClusterName(), serviceName, retryAllowed, autoSkipFailure);
            ExecutionCommand execCmd = stage.getExecutionCommandWrapper(hostName, componentName).getExecutionCommand();
            if (actionExecutionContext.getParameters() != null && actionExecutionContext.getParameters().containsKey("overrideConfigs")) {
                execCmd.setOverrideConfigs(true);
            }
            if ((cmd = stage.getHostRoleCommand(hostName, componentName)) != null) {
                cmd.setCommandDetail(commandDetail);
                cmd.setCustomCommandName(commandName);
                if (customCommandDefinition != null) {
                    cmd.setOpsDisplayName(customCommandDefinition.getOpsDisplayName());
                }
            }
            if (customCommandDefinition != null && customCommandDefinition.isBackground()) {
                cmd.setBackgroundCommand(true);
                execCmd.setCommandType(AgentCommand.AgentCommandType.BACKGROUND_EXECUTION_COMMAND);
            }
            execCmd.setComponentVersions(cluster);
            execCmd.setConfigurations(new TreeMap<String, Map<String, String>>());
            Service clusterService = cluster.getService(serviceName);
            execCmd.setCredentialStoreEnabled(String.valueOf(clusterService.isCredentialStoreEnabled()));
            Map<String, Map<String, String>> configCredentials = this.configCredentialsForService.get(clusterService.getName());
            if (configCredentials == null) {
                configCredentials = this.configHelper.getCredentialStoreEnabledProperties(stackId, clusterService);
                this.configCredentialsForService.put(clusterService.getName(), configCredentials);
            }
            execCmd.setConfigurationCredentials(configCredentials);
            TreeMap<String, String> hostLevelParams = new TreeMap<String, String>();
            hostLevelParams.put("stack_name", stackId.getStackName());
            hostLevelParams.put("stack_version", stackId.getStackVersion());
            Map<String, DesiredConfig> desiredConfigs = cluster.getDesiredConfigs();
            Set<String> userSet = this.configHelper.getPropertyValuesWithPropertyType(stackId, PropertyInfo.PropertyType.USER, cluster, desiredConfigs);
            String userList = this.gson.toJson(userSet);
            hostLevelParams.put("user_list", userList);
            Map<String, Set<String>> userGroupsMap = this.configHelper.createUserGroupsMap(stackId, cluster, desiredConfigs);
            String userGroups = this.gson.toJson(userGroupsMap);
            hostLevelParams.put("user_groups", userGroups);
            Set<String> groupSet = this.configHelper.getPropertyValuesWithPropertyType(stackId, PropertyInfo.PropertyType.GROUP, cluster, desiredConfigs);
            String groupList = this.gson.toJson(groupSet);
            hostLevelParams.put("group_list", groupList);
            Map<PropertyInfo, String> notManagedHdfsPathMap = this.configHelper.getPropertiesWithPropertyType(stackId, PropertyInfo.PropertyType.NOT_MANAGED_HDFS_PATH, cluster, desiredConfigs);
            Set<String> notManagedHdfsPathSet = this.configHelper.filterInvalidPropertyValues(notManagedHdfsPathMap, "not_managed_hdfs_path_list");
            String notManagedHdfsPathList = this.gson.toJson(notManagedHdfsPathSet);
            hostLevelParams.put("not_managed_hdfs_path_list", notManagedHdfsPathList);
            execCmd.setHostLevelParams(hostLevelParams);
            TreeMap<String, String> commandParams = new TreeMap<String, String>();
            if (additionalCommandParams != null) {
                for (String key : additionalCommandParams.keySet()) {
                    commandParams.put(key, additionalCommandParams.get(key));
                }
            }
            commandParams.put("custom_command", commandName);
            boolean isInstallCommand = commandName.equals(RoleCommand.INSTALL.toString());
            int commandTimeout = Integer.valueOf(this.configs.getDefaultAgentTaskTimeout(isInstallCommand));
            ComponentInfo componentInfo = obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), serviceName, componentName);
            if (serviceInfo.getSchemaVersion().equals("2.0")) {
                CommandScriptDefinition script = componentInfo.getCommandScript();
                if (script != null) {
                    commandParams.put("script", script.getScript());
                    commandParams.put("script_type", script.getScriptType().toString());
                    if (script.getTimeout() > 0) {
                        commandTimeout = script.getTimeout();
                    }
                } else {
                    String message = String.format("Component %s has not command script defined. It is not possible to send command for this service", componentName);
                    throw new OBDPException(message);
                }
            }
            if (null != actionExecutionContext.getTimeout()) {
                commandTimeout = actionExecutionContext.getTimeout();
                commandTimeout = Math.max(60, commandTimeout);
            }
            if (requestParams != null && requestParams.containsKey("context") && StringUtils.isNotEmpty((String)(requestContext = requestParams.get("context"))) && requestContext.toLowerCase().contains("rolling-restart") && (clusterEnvConfig = cluster.getDesiredConfigByType("cluster-env")) != null && StringUtils.isNotEmpty((String)(componentRollingRestartTimeout = clusterEnvConfig.getProperties().get("namenode_rolling_restart_timeout")))) {
                commandTimeout = Integer.parseInt(componentRollingRestartTimeout);
            }
            commandParams.put("command_timeout", "" + commandTimeout);
            Map<String, String> roleParams = execCmd.getRoleParams();
            if (roleParams == null) {
                roleParams = new TreeMap<String, String>();
            }
            if (isUpgradeSuspended = cluster.isUpgradeSuspended()) {
                cluster.addSuspendedUpgradeParameters(commandParams, roleParams);
            }
            StageUtils.useAmbariJdkInCommandParams(commandParams, this.configs);
            roleParams.put("component_category", componentInfo.getCategory());
            if (commandName.equals("RECONFIGURE") && (refreshConfigsCommand = this.configHelper.getRefreshConfigsCommand(cluster, hostName, serviceName, componentName)) != null && !refreshConfigsCommand.equals("refresh_configs")) {
                LOG.info("Refreshing configs for {}/{} with command: ", new Object[]{componentName, hostName, refreshConfigsCommand});
                commandParams.put("reconfigureAction", refreshConfigsCommand);
            }
            execCmd.setCommandParams(commandParams);
            execCmd.setRoleParams(roleParams);
            if (actionExecutionContext.isFutureCommand()) continue;
            this.applyCustomCommandBackendLogic(cluster, serviceName, componentName, commandName, hostName);
        }
    }

    private void applyCustomCommandBackendLogic(Cluster cluster, String serviceName, String componentName, String commandName, String hostname) throws OBDPException {
        switch (commandName) {
            case "RESTART": {
                ServiceComponent serviceComponent = cluster.getService(serviceName).getServiceComponent(componentName);
                ServiceComponentHost serviceComponentHost = serviceComponent.getServiceComponentHost(hostname);
                State currentDesiredState = serviceComponentHost.getDesiredState();
                if (!serviceComponent.isClientComponent()) {
                    if (currentDesiredState == State.STARTED) break;
                    LOG.info("Updating desired state to {} on RESTART for {}/{} because it was {}", new Object[]{State.STARTED, serviceName, componentName, currentDesiredState});
                    serviceComponentHost.setDesiredState(State.STARTED);
                    break;
                }
                LOG.debug("Desired state for client components should not be updated on RESTART. Service/Component {}/{}", (Object)serviceName, (Object)componentName);
                break;
            }
            default: {
                LOG.debug("No backend operations needed for the custom command: {}", (Object)commandName);
            }
        }
    }

    private void findHostAndAddServiceCheckAction(ActionExecutionContext actionExecutionContext, RequestResourceFilter resourceFilter, Stage stage) throws OBDPException {
        List<String> healthyHostNames;
        Set<String> candidateHosts;
        Map<String, ServiceComponentHost> serviceHostComponents;
        String clusterName = actionExecutionContext.getClusterName();
        Cluster cluster = this.clusters.getCluster(clusterName);
        String componentName = this.actionMetadata.getClient(resourceFilter.getServiceName());
        String serviceName = resourceFilter.getServiceName();
        String smokeTestRole = this.actionMetadata.getServiceCheckAction(serviceName);
        if (null == smokeTestRole) {
            smokeTestRole = actionExecutionContext.getActionName();
        }
        if (componentName != null) {
            serviceHostComponents = cluster.getService(serviceName).getServiceComponent(componentName).getServiceComponentHosts();
            if (serviceHostComponents.isEmpty()) {
                throw new OBDPException(MessageFormat.format("No hosts found for service: {0}, component: {1} in cluster: {2}", serviceName, componentName, clusterName));
            }
            List<String> candidateHostsList = resourceFilter.getHostNames();
            if (candidateHostsList != null && !candidateHostsList.isEmpty()) {
                candidateHosts = new HashSet<String>(candidateHostsList);
                candidateHosts.retainAll(serviceHostComponents.keySet());
                if (candidateHosts.isEmpty()) {
                    throw new OBDPException(MessageFormat.format("The resource filter for hosts does not contain components for service: {0}, component: {1} in cluster: {2}", serviceName, componentName, clusterName));
                }
            } else {
                candidateHosts = serviceHostComponents.keySet();
            }
        } else {
            Map<String, ServiceComponent> serviceComponents = cluster.getService(serviceName).getServiceComponents();
            Iterator<String> serviceComponentNameIterator = serviceComponents.keySet().iterator();
            while (serviceComponentNameIterator.hasNext()) {
                String componentToCheck = serviceComponentNameIterator.next();
                if (!serviceComponents.get(componentToCheck).getServiceComponentHosts().isEmpty()) continue;
                serviceComponentNameIterator.remove();
            }
            if (serviceComponents.isEmpty()) {
                throw new OBDPException(MessageFormat.format("Did not find any hosts with components for service: {0} in cluster: {1}", serviceName, clusterName));
            }
            ServiceComponent serviceComponent = serviceComponents.values().iterator().next();
            serviceHostComponents = serviceComponent.getServiceComponentHosts();
            candidateHosts = serviceHostComponents.keySet();
        }
        for (String candidateHostName : candidateHosts) {
            ServiceComponentHost serviceComponentHost = serviceHostComponents.get(candidateHostName);
            if (serviceComponentHost != null) continue;
            throw new OBDPException("Provided hostname = " + candidateHostName + " is either not a valid cluster host or does not satisfy the filter condition.");
        }
        HashSet<String> hostsInMaintenanceMode = new HashSet<String>();
        if (actionExecutionContext.isMaintenanceModeHostExcluded()) {
            Iterator<String> iterator = candidateHosts.iterator();
            while (iterator.hasNext()) {
                String candidateHostName = iterator.next();
                ServiceComponentHost serviceComponentHost = serviceHostComponents.get(candidateHostName);
                Host host = serviceComponentHost.getHost();
                if (host.getMaintenanceState(cluster.getClusterId()) != MaintenanceState.ON) continue;
                hostsInMaintenanceMode.add(candidateHostName);
                iterator.remove();
            }
        }
        if ((healthyHostNames = this.managementController.selectHealthyHosts(candidateHosts)).isEmpty()) {
            String message = MessageFormat.format("While building a service check command for {0}, there were no healthy eligible hosts: unhealthy[{1}], maintenance[{2}]", serviceName, StringUtils.join(candidateHosts, (char)','), StringUtils.join(hostsInMaintenanceMode, (char)','));
            throw new OBDPException(message);
        }
        String preferredHostName = this.selectRandomHostNameWithPreferenceOnAvailability(healthyHostNames);
        long nowTimestamp = System.currentTimeMillis();
        Map<String, String> actionParameters = actionExecutionContext.getParameters();
        this.addServiceCheckAction(stage, preferredHostName, smokeTestRole, nowTimestamp, serviceName, componentName, actionParameters, actionExecutionContext.isRetryAllowed(), actionExecutionContext.isFailureAutoSkipped(), false);
    }

    private String selectRandomHostNameWithPreferenceOnAvailability(List<String> candidateHostNames) throws OBDPException {
        ArrayList<String> preferredList;
        if (null == candidateHostNames || candidateHostNames.isEmpty()) {
            return null;
        }
        if (candidateHostNames.size() == 1) {
            return candidateHostNames.get(0);
        }
        ArrayList<String> hostsWithZeroCommands = new ArrayList<String>();
        ArrayList<String> hostsWithInProgressCommands = new ArrayList<String>();
        Map<Long, Integer> hostIdToCount = this.hostRoleCommandDAO.getHostIdToCountOfCommandsWithStatus(HostRoleStatus.IN_PROGRESS_STATUSES);
        for (String hostName : candidateHostNames) {
            Host host = this.clusters.getHost(hostName);
            if (hostIdToCount.containsKey(host.getHostId()) && hostIdToCount.get(host.getHostId()) > 0) {
                hostsWithInProgressCommands.add(hostName);
                continue;
            }
            hostsWithZeroCommands.add(hostName);
        }
        ArrayList<String> arrayList = preferredList = !hostsWithZeroCommands.isEmpty() ? hostsWithZeroCommands : hostsWithInProgressCommands;
        if (!preferredList.isEmpty()) {
            int randomIndex = new Random().nextInt(preferredList.size());
            return (String)preferredList.get(randomIndex);
        }
        return null;
    }

    public void addServiceCheckAction(Stage stage, String hostname, String smokeTestRole, long nowTimestamp, String serviceName, String componentName, Map<String, String> actionParameters, boolean retryAllowed, boolean autoSkipFailure, boolean useLatestConfigs) throws OBDPException {
        String clusterName = stage.getClusterName();
        Cluster cluster = this.clusters.getCluster(clusterName);
        Service service = cluster.getService(serviceName);
        ServiceComponent component = null;
        if (null != componentName) {
            component = service.getServiceComponent(componentName);
        }
        StackId stackId = null != component ? component.getDesiredStackId() : service.getDesiredStackId();
        OBDPMetaInfo obdpMetaInfo = this.managementController.getAmbariMetaInfo();
        ServiceInfo serviceInfo = obdpMetaInfo.getService(stackId.getStackName(), stackId.getStackVersion(), serviceName);
        stage.addHostRoleExecutionCommand(hostname, Role.valueOf(smokeTestRole), RoleCommand.SERVICE_CHECK, (ServiceComponentHostEvent)new ServiceComponentHostOpInProgressEvent(componentName, hostname, nowTimestamp), cluster.getClusterName(), serviceName, retryAllowed, autoSkipFailure);
        HostRoleCommand hrc = stage.getHostRoleCommand(hostname, smokeTestRole);
        if (hrc != null) {
            hrc.setCommandDetail(String.format("%s %s", RoleCommand.SERVICE_CHECK.toString(), serviceName));
        }
        TreeMap<String, Map<String, String>> configurations = new TreeMap<String, Map<String, String>>();
        ExecutionCommand execCmd = stage.getExecutionCommandWrapper(hostname, smokeTestRole).getExecutionCommand();
        if (actionParameters != null && actionParameters.containsKey("overrideConfigs")) {
            execCmd.setOverrideConfigs(true);
        }
        execCmd.setConfigurations(configurations);
        for (ServiceComponentHost sch : cluster.getServiceComponentHosts(hostname)) {
            execCmd.getLocalComponents().add(sch.getServiceComponentName());
        }
        TreeMap<String, String> commandParams = new TreeMap<String, String>();
        String commandTimeout = this.getStatusCommandTimeout(serviceInfo);
        if (serviceInfo.getSchemaVersion().equals("2.0")) {
            CommandScriptDefinition script = serviceInfo.getCommandScript();
            if (script != null) {
                commandParams.put("script", script.getScript());
                commandParams.put("script_type", script.getScriptType().toString());
            } else {
                String message = String.format("Service %s has no command script defined. It is not possible to run service check for this service", serviceName);
                throw new OBDPException(message);
            }
        }
        commandParams.put("command_timeout", commandTimeout);
        String checkType = this.configHelper.getValueFromDesiredConfigurations(cluster, "cluster-env", "service_check_type");
        if ("minimal".equals(checkType)) {
            int actualTimeout = Integer.parseInt((String)commandParams.get("command_timeout")) / 2;
            actualTimeout = actualTimeout < 120 ? 120 : actualTimeout;
            commandParams.put("command_timeout", Integer.toString(actualTimeout));
        }
        StageUtils.useAmbariJdkInCommandParams(commandParams, this.configs);
        execCmd.setCommandParams(commandParams);
        if (actionParameters != null) {
            execCmd.setRoleParams(actionParameters);
        }
        if (useLatestConfigs) {
            execCmd.setUseLatestConfigs(useLatestConfigs);
        }
    }

    private Set<String> getHostList(Map<String, String> cmdParameters, String key) {
        String allHosts;
        HashSet<String> hosts = new HashSet<String>();
        if (cmdParameters.containsKey(key) && (allHosts = cmdParameters.get(key)) != null) {
            for (String hostName : allHosts.trim().split(",")) {
                hosts.add(hostName.trim());
            }
        }
        return hosts;
    }

    private void addDecommissionAction(final ActionExecutionContext actionExecutionContext, final RequestResourceFilter resourceFilter, Stage stage, ExecuteCommandJson executeCommandJson) throws OBDPException {
        HashSet<String> filteredIncludedHosts;
        String slaveCompType;
        String clusterName = actionExecutionContext.getClusterName();
        final Cluster cluster = this.clusters.getCluster(clusterName);
        final String serviceName = resourceFilter.getServiceName();
        String masterCompType = resourceFilter.getComponentName();
        List<String> hosts = resourceFilter.getHostNames();
        if (hosts != null && !hosts.isEmpty()) {
            throw new OBDPException("Decommission command cannot be issued with target host(s) specified.");
        }
        Set<String> excludedHosts = this.getHostList(actionExecutionContext.getParameters(), DECOM_EXCLUDED_HOSTS);
        Set<String> includedHosts = this.getHostList(actionExecutionContext.getParameters(), DECOM_INCLUDED_HOSTS);
        if (actionExecutionContext.getParameters().get(IS_ADD_OR_DELETE_SLAVE_REQUEST) != null && actionExecutionContext.getParameters().get(IS_ADD_OR_DELETE_SLAVE_REQUEST).equalsIgnoreCase("true")) {
            includedHosts = this.getHostList(actionExecutionContext.getParameters(), masterCompType + "_included_hosts");
        }
        HashSet<String> cloneSet = new HashSet<String>(excludedHosts);
        cloneSet.retainAll(includedHosts);
        if (cloneSet.size() > 0) {
            throw new OBDPException("Same host cannot be specified for inclusion as well as exclusion. Hosts: " + cloneSet);
        }
        Service service = cluster.getService(serviceName);
        if (service == null) {
            throw new OBDPException("Specified service " + serviceName + " is not a valid/deployed service.");
        }
        Map<String, ServiceComponent> svcComponents = service.getServiceComponents();
        if (!svcComponents.containsKey(masterCompType)) {
            throw new OBDPException("Specified component " + masterCompType + " does not belong to service " + serviceName + ".");
        }
        ServiceComponent masterComponent = svcComponents.get(masterCompType);
        if (!masterComponent.isMasterComponent()) {
            throw new OBDPException("Specified component " + masterCompType + " is not a MASTER for service " + serviceName + ".");
        }
        if (!masterToSlaveMappingForDecom.containsKey(masterCompType)) {
            throw new OBDPException("Decommissioning is not supported for " + masterCompType);
        }
        String slaveCompStr = actionExecutionContext.getParameters().get(DECOM_SLAVE_COMPONENT);
        if (slaveCompStr == null || slaveCompStr.equals("")) {
            slaveCompType = masterToSlaveMappingForDecom.get(masterCompType);
        } else {
            slaveCompType = slaveCompStr;
            if (!masterToSlaveMappingForDecom.get(masterCompType).equals(slaveCompType)) {
                throw new OBDPException("Component " + slaveCompType + " is not supported for decommissioning.");
            }
        }
        String isDrainOnlyRequest = actionExecutionContext.getParameters().get(HBASE_MARK_DRAINING_ONLY);
        if (isDrainOnlyRequest != null && !slaveCompType.equals(Role.HBASE_REGIONSERVER.name())) {
            throw new OBDPException("mark_draining_only is not a valid parameter for " + masterCompType);
        }
        HashSet<String> filteredExcludedHosts = new HashSet<String>(excludedHosts);
        MaintenanceStateHelper.HostPredicate hostPredicate = new MaintenanceStateHelper.HostPredicate(){

            @Override
            public boolean shouldHostBeRemoved(String hostname) throws OBDPException {
                String upd_excl_file_only_str = actionExecutionContext.getParameters().get(OBDPCustomCommandExecutionHelper.UPDATE_FILES_ONLY);
                String decom_incl_hosts_str = actionExecutionContext.getParameters().get(OBDPCustomCommandExecutionHelper.DECOM_INCLUDED_HOSTS);
                if (upd_excl_file_only_str != null && !upd_excl_file_only_str.trim().equals("")) {
                    upd_excl_file_only_str = upd_excl_file_only_str.trim();
                }
                boolean upd_excl_file_only = false;
                if (upd_excl_file_only_str != null && !upd_excl_file_only_str.equals("") && (upd_excl_file_only_str.equals("\"true\"") || upd_excl_file_only_str.equals("'true'") || upd_excl_file_only_str.equals("true"))) {
                    upd_excl_file_only = true;
                }
                if (upd_excl_file_only && decom_incl_hosts_str != null && !decom_incl_hosts_str.trim().equals("")) {
                    return upd_excl_file_only;
                }
                return !OBDPCustomCommandExecutionHelper.this.maintenanceStateHelper.isOperationAllowed(cluster, actionExecutionContext.getOperationLevel(), resourceFilter, serviceName, slaveCompType, hostname);
            }
        };
        Set<String> ignoredHosts = this.maintenanceStateHelper.filterHostsInMaintenanceState(filteredExcludedHosts, hostPredicate);
        if (!ignoredHosts.isEmpty()) {
            String message = String.format("Some hosts (%s) from host exclude list have been ignored because components on them are in Maintenance state.", ignoredHosts);
            LOG.debug(message);
        }
        if (!(ignoredHosts = this.maintenanceStateHelper.filterHostsInMaintenanceState(filteredIncludedHosts = new HashSet<String>(includedHosts), hostPredicate)).isEmpty()) {
            String message = String.format("Some hosts (%s) from host include list have been ignored because components on them are in Maintenance state.", ignoredHosts);
            LOG.debug(message);
        }
        for (ServiceComponentHost sch : svcComponents.get(slaveCompType).getServiceComponentHosts().values()) {
            if (!filteredExcludedHosts.contains(sch.getHostName()) || "true".equals(isDrainOnlyRequest) || sch.getState() == State.STARTED) continue;
            throw new OBDPException("Component " + slaveCompType + " on host " + sch.getHostName() + " cannot be decommissioned as its not in STARTED state. Aborting the whole request.");
        }
        String alignMtnStateStr = actionExecutionContext.getParameters().get(ALIGN_MAINTENANCE_STATE);
        boolean alignMtnState = "true".equals(alignMtnStateStr);
        ArrayList<String> listOfExcludedHosts = new ArrayList<String>();
        for (ServiceComponentHost sch : svcComponents.get(slaveCompType).getServiceComponentHosts().values()) {
            if (filteredExcludedHosts.contains(sch.getHostName())) {
                sch.setComponentAdminState(HostComponentAdminState.DECOMMISSIONED);
                listOfExcludedHosts.add(sch.getHostName());
                if (alignMtnState) {
                    sch.setMaintenanceState(MaintenanceState.ON);
                    LOG.info("marking Maintenance=ON on " + sch.getHostName());
                }
                LOG.info("Decommissioning " + slaveCompType + " on " + sch.getHostName());
            }
            if (!filteredIncludedHosts.contains(sch.getHostName())) continue;
            sch.setComponentAdminState(HostComponentAdminState.INSERVICE);
            if (alignMtnState) {
                sch.setMaintenanceState(MaintenanceState.OFF);
                LOG.info("marking Maintenance=OFF on " + sch.getHostName());
            }
            LOG.info("Recommissioning " + slaveCompType + " on " + sch.getHostName());
        }
        Map<String, ServiceComponentHost> masterSchs = masterComponent.getServiceComponentHosts();
        String primaryCandidate = null;
        for (String hostName : masterSchs.keySet()) {
            if (primaryCandidate == null) {
                primaryCandidate = hostName;
                continue;
            }
            ServiceComponentHost sch = masterSchs.get(hostName);
            if (sch.getState() != State.STARTED) continue;
            primaryCandidate = hostName;
        }
        StringBuilder commandDetail = this.getReadableDecommissionCommandDetail(actionExecutionContext, filteredIncludedHosts, listOfExcludedHosts);
        for (String hostName : masterSchs.keySet()) {
            RequestResourceFilter commandFilter = new RequestResourceFilter(serviceName, masterComponent.getName(), Collections.singletonList(hostName));
            ArrayList<RequestResourceFilter> resourceFilters = new ArrayList<RequestResourceFilter>();
            resourceFilters.add(commandFilter);
            ActionExecutionContext commandContext = new ActionExecutionContext(clusterName, actionExecutionContext.getActionName(), resourceFilters);
            String clusterHostInfoJson = StageUtils.getGson().toJson(StageUtils.getClusterHostInfo(cluster));
            if (executeCommandJson != null) {
                executeCommandJson.setClusterHostInfo(clusterHostInfoJson);
            }
            HashMap<String, String> commandParams = new HashMap<String, String>();
            commandParams.put(ALL_DECOMMISSIONED_HOSTS, StringUtils.join(this.calculateDecommissionedNodes(service, slaveCompType), (char)','));
            if (serviceName.equals(Service.Type.HBASE.name())) {
                commandParams.put(DECOM_EXCLUDED_HOSTS, StringUtils.join(listOfExcludedHosts, (char)','));
                if (isDrainOnlyRequest != null && isDrainOnlyRequest.equals("true")) {
                    commandParams.put(HBASE_MARK_DRAINING_ONLY, isDrainOnlyRequest);
                } else {
                    commandParams.put(HBASE_MARK_DRAINING_ONLY, "false");
                }
            }
            if (serviceName.equals(Service.Type.HBASE.name()) && !hostName.equals(primaryCandidate)) continue;
            commandParams.put(UPDATE_FILES_ONLY, "false");
            this.addCustomCommandAction(commandContext, commandFilter, stage, commandParams, commandDetail.toString(), null);
        }
    }

    private Set<String> calculateDecommissionedNodes(Service service, String slaveCompType) throws OBDPException {
        HashSet<String> decommissionedHostsSet = new HashSet<String>();
        ServiceComponent serviceComponent = service.getServiceComponent(slaveCompType);
        for (ServiceComponentHost serviceComponentHost : serviceComponent.getServiceComponentHosts().values()) {
            if (serviceComponentHost.getComponentAdminState() != HostComponentAdminState.DECOMMISSIONED) continue;
            decommissionedHostsSet.add(serviceComponentHost.getHostName());
        }
        return decommissionedHostsSet;
    }

    private StringBuilder getReadableDecommissionCommandDetail(ActionExecutionContext actionExecutionContext, Set<String> includedHosts, List<String> listOfExcludedHosts) {
        StringBuilder commandDetail = new StringBuilder();
        commandDetail.append(actionExecutionContext.getActionName());
        if (actionExecutionContext.getParameters().containsKey(IS_ADD_OR_DELETE_SLAVE_REQUEST) && actionExecutionContext.getParameters().get(IS_ADD_OR_DELETE_SLAVE_REQUEST).equalsIgnoreCase("true")) {
            commandDetail.append(", Update Include/Exclude Files");
            return commandDetail;
        }
        if (listOfExcludedHosts.size() > 0) {
            commandDetail.append(", Excluded: ").append(StringUtils.join(listOfExcludedHosts, (char)','));
        }
        if (includedHosts.size() > 0) {
            commandDetail.append(", Included: ").append(StringUtils.join(includedHosts, (char)','));
        }
        return commandDetail;
    }

    public void validateAction(ExecuteActionRequest actionRequest) throws OBDPException {
        List<RequestResourceFilter> resourceFilters = actionRequest.getResourceFilters();
        if (resourceFilters != null && resourceFilters.isEmpty() && actionRequest.getParameters().containsKey("HAS_RESOURCE_FILTERS") && actionRequest.getParameters().get("HAS_RESOURCE_FILTERS").equalsIgnoreCase("true")) {
            LOG.warn("Couldn't find any resource that satisfies given resource filters");
            return;
        }
        if (resourceFilters == null || resourceFilters.isEmpty()) {
            throw new OBDPException("Command execution cannot proceed without a resource filter.");
        }
        for (RequestResourceFilter resourceFilter : resourceFilters) {
            if (resourceFilter.getServiceName() == null || resourceFilter.getServiceName().isEmpty() || actionRequest.getCommandName() == null || actionRequest.getCommandName().isEmpty()) {
                throw new OBDPException("Invalid resource filter : cluster = " + actionRequest.getClusterName() + ", service = " + resourceFilter.getServiceName() + ", command = " + actionRequest.getCommandName());
            }
            if (this.isServiceCheckCommand(actionRequest.getCommandName(), resourceFilter.getServiceName()).booleanValue() || this.isValidCustomCommand(actionRequest, resourceFilter).booleanValue()) continue;
            throw new OBDPException("Unsupported action " + actionRequest.getCommandName() + " for Service: " + resourceFilter.getServiceName() + " and Component: " + resourceFilter.getComponentName());
        }
    }

    public void addExecutionCommandsToStage(ActionExecutionContext actionExecutionContext, Stage stage, Map<String, String> requestParams, ExecuteCommandJson executeCommandJson) throws OBDPException {
        List<RequestResourceFilter> resourceFilters = actionExecutionContext.getResourceFilters();
        for (RequestResourceFilter resourceFilter : resourceFilters) {
            LOG.debug("Received a command execution request, clusterName={}, serviceName={}, request={}", new Object[]{actionExecutionContext.getClusterName(), resourceFilter.getServiceName(), actionExecutionContext});
            String actionName = actionExecutionContext.getActionName();
            if (actionName.contains(SERVICE_CHECK_COMMAND_NAME)) {
                this.findHostAndAddServiceCheckAction(actionExecutionContext, resourceFilter, stage);
                continue;
            }
            if (actionName.equals(DECOMMISSION_COMMAND_NAME)) {
                this.addDecommissionAction(actionExecutionContext, resourceFilter, stage, executeCommandJson);
                continue;
            }
            if (this.isValidCustomCommand(actionExecutionContext, resourceFilter).booleanValue()) {
                String serviceName;
                String clusterName;
                RequestOperationLevel operationLevel;
                String componentName;
                String commandDetail = this.getReadableCustomCommandDetail(actionExecutionContext, resourceFilter);
                HashMap<String, String> extraParams = new HashMap<String, String>();
                String string = componentName = null == resourceFilter.getComponentName() ? null : resourceFilter.getComponentName().toLowerCase();
                if (null != componentName && requestParams.containsKey(componentName)) {
                    extraParams.put(componentName, requestParams.get(componentName));
                }
                if (requestParams.containsKey("command_retry_enabled")) {
                    String commandRetryDurationStr;
                    Integer commandRetryDurationInt;
                    extraParams.put("command_retry_enabled", requestParams.get("command_retry_enabled"));
                    String commandRetryDuration = "600";
                    if (requestParams.containsKey("max_duration_for_retries") && (commandRetryDurationInt = Integer.valueOf(NumberUtils.toInt((String)(commandRetryDurationStr = requestParams.get("max_duration_for_retries")), (int)0))) > 0) {
                        commandRetryDuration = Integer.toString(commandRetryDurationInt);
                    }
                    extraParams.put("max_duration_for_retries", commandRetryDuration);
                }
                if (requestParams.containsKey("log_output")) {
                    extraParams.put("log_output", requestParams.get("log_output"));
                }
                if (requestParams.containsKey("overrideConfigs")) {
                    actionExecutionContext.getParameters().put("overrideConfigs", requestParams.get("overrideConfigs"));
                }
                if ((operationLevel = actionExecutionContext.getOperationLevel()) != null && this.isTopologyRefreshRequired(actionName, clusterName = operationLevel.getClusterName(), serviceName = operationLevel.getServiceName())) {
                    extraParams.put("refresh_topology", "True");
                }
                this.addCustomCommandAction(actionExecutionContext, resourceFilter, stage, extraParams, commandDetail, requestParams);
                continue;
            }
            throw new OBDPException("Unsupported action " + actionName);
        }
    }

    public ExecuteCommandJson getCommandJson(ActionExecutionContext actionExecContext, Cluster cluster, StackId stackId, String requestContext) throws OBDPException {
        Map<String, String> commandParamsStage = StageUtils.getCommandParamsStage(actionExecContext, requestContext);
        Map<Object, Object> hostParamsStage = new HashMap();
        String clusterHostInfoJson = "{}";
        if (null != cluster) {
            Map<String, Set<String>> clusterHostInfo = StageUtils.getClusterHostInfo(cluster);
            hostParamsStage = this.createDefaultHostParams(cluster, stackId);
            String componentName = null;
            String serviceName = null;
            if (actionExecContext.getOperationLevel() != null) {
                componentName = actionExecContext.getOperationLevel().getHostComponentName();
                serviceName = actionExecContext.getOperationLevel().getServiceName();
            }
            if (serviceName != null && componentName != null) {
                Service service = cluster.getService(serviceName);
                ServiceComponent component = service.getServiceComponent(componentName);
                stackId = component.getDesiredStackId();
                ComponentInfo componentInfo = this.obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), serviceName, componentName);
                List<String> clientsToUpdateConfigsList = componentInfo.getClientsToUpdateConfigs();
                if (clientsToUpdateConfigsList == null) {
                    clientsToUpdateConfigsList = new ArrayList<String>();
                    clientsToUpdateConfigsList.add("*");
                }
                String clientsToUpdateConfigs = this.gson.toJson(clientsToUpdateConfigsList);
                hostParamsStage.put("clientsToUpdateConfigs", clientsToUpdateConfigs);
            }
            clusterHostInfoJson = StageUtils.getGson().toJson(clusterHostInfo);
        }
        String hostParamsStageJson = StageUtils.getGson().toJson(hostParamsStage);
        String commandParamsStageJson = StageUtils.getGson().toJson(commandParamsStage);
        return new ExecuteCommandJson(clusterHostInfoJson, commandParamsStageJson, hostParamsStageJson);
    }

    Map<String, String> createDefaultHostParams(Cluster cluster, StackId stackId) throws OBDPException {
        if (null == stackId) {
            stackId = cluster.getDesiredStackVersion();
        }
        TreeMap<String, String> hostLevelParams = new TreeMap<String, String>();
        StageUtils.useStackJdkIfExists(hostLevelParams, this.configs);
        hostLevelParams.put("jdk_location", this.managementController.getJdkResourceUrl());
        hostLevelParams.put("stack_name", stackId.getStackName());
        hostLevelParams.put("stack_version", stackId.getStackVersion());
        hostLevelParams.put("db_name", this.managementController.getServerDB());
        hostLevelParams.put("mysql_jdbc_url", this.managementController.getMysqljdbcUrl());
        hostLevelParams.put("oracle_jdbc_url", this.managementController.getOjdbcUrl());
        hostLevelParams.put("db_driver_filename", this.configs.getMySQLJarName());
        hostLevelParams.putAll(this.managementController.getRcaParameters());
        hostLevelParams.put("host_sys_prepped", this.configs.areHostsSysPrepped());
        hostLevelParams.put("agent_stack_retry_on_unavailability", this.configs.isAgentStackRetryOnInstallEnabled());
        hostLevelParams.put("agent_stack_retry_count", this.configs.getAgentStackRetryOnInstallCount());
        hostLevelParams.put("gpl_license_accepted", this.configs.getGplLicenseAccepted().toString());
        Map<String, DesiredConfig> desiredConfigs = cluster.getDesiredConfigs();
        Map<PropertyInfo, String> notManagedHdfsPathMap = this.configHelper.getPropertiesWithPropertyType(stackId, PropertyInfo.PropertyType.NOT_MANAGED_HDFS_PATH, cluster, desiredConfigs);
        Set<String> notManagedHdfsPathSet = this.configHelper.filterInvalidPropertyValues(notManagedHdfsPathMap, "not_managed_hdfs_path_list");
        String notManagedHdfsPathList = this.gson.toJson(notManagedHdfsPathSet);
        hostLevelParams.put("not_managed_hdfs_path_list", notManagedHdfsPathList);
        for (Map.Entry<String, String> dbConnectorName : this.configs.getDatabaseConnectorNames().entrySet()) {
            hostLevelParams.put(dbConnectorName.getKey(), dbConnectorName.getValue());
        }
        for (Map.Entry<String, String> previousDBConnectorName : this.configs.getPreviousDatabaseConnectorNames().entrySet()) {
            hostLevelParams.put(previousDBConnectorName.getKey(), previousDBConnectorName.getValue());
        }
        return hostLevelParams;
    }

    public boolean isTopologyRefreshRequired(String actionName, String clusterName, String serviceName) throws OBDPException {
        if (actionName.equals(START_COMMAND_NAME) || actionName.equals(RESTART_COMMAND_NAME)) {
            Boolean restartRequiredAfterRackChange;
            ServiceInfo serviceInfo;
            OBDPMetaInfo obdpMetaInfo;
            StackInfo stack;
            Cluster cluster = this.clusters.getCluster(clusterName);
            StackId stackId = null;
            if (serviceName != null) {
                try {
                    Service service = cluster.getService(serviceName);
                    stackId = service.getDesiredStackId();
                }
                catch (OBDPException e) {
                    LOG.debug("Could not load service {}, skipping topology check", (Object)serviceName);
                }
            }
            if (stackId == null) {
                stackId = cluster.getDesiredStackVersion();
            }
            if ((stack = (obdpMetaInfo = this.managementController.getAmbariMetaInfo()).getStack(stackId.getStackName(), stackId.getStackVersion())) != null && (serviceInfo = stack.getService(serviceName)) != null && (restartRequiredAfterRackChange = serviceInfo.isRestartRequiredAfterRackChange()) != null && restartRequiredAfterRackChange.booleanValue()) {
                return true;
            }
        }
        return false;
    }

    private ServiceComponent getServiceComponent(ActionExecutionContext actionExecutionContext, RequestResourceFilter resourceFilter) {
        try {
            Cluster cluster = this.clusters.getCluster(actionExecutionContext.getClusterName());
            Service service = cluster.getService(resourceFilter.getServiceName());
            return service.getServiceComponent(resourceFilter.getComponentName());
        }
        catch (Exception e) {
            LOG.debug("Unknown error appears during getting service component: {}", (Object)e.getMessage());
            return null;
        }
    }

    private boolean filterUnhealthHostItem(String hostname, ActionExecutionContext actionExecutionContext, RequestResourceFilter resourceFilter) throws OBDPException {
        RequestOperationLevel operationLevel = actionExecutionContext.getOperationLevel();
        ServiceComponent serviceComponent = this.getServiceComponent(actionExecutionContext, resourceFilter);
        if (serviceComponent != null && operationLevel != null && operationLevel.getLevel() == Resource.Type.Service && actionExecutionContext.getResourceFilters().size() > 1 && !serviceComponent.isMasterComponent()) {
            return this.clusters.getHost(hostname).getState() != HostState.HEALTHY;
        }
        if (serviceComponent != null && operationLevel != null && operationLevel.getLevel() == Resource.Type.Host && actionExecutionContext.getResourceFilters().size() > 1 && serviceComponent.getServiceComponentHosts().containsKey(hostname) && !serviceComponent.isMasterComponent()) {
            State hostState = serviceComponent.getServiceComponentHosts().get(hostname).getState();
            return hostState == State.UNKNOWN;
        }
        return false;
    }

    private Set<String> getUnhealthyHosts(Set<String> hosts, ActionExecutionContext actionExecutionContext, RequestResourceFilter resourceFilter) throws OBDPException {
        HashSet<String> removedHosts = new HashSet<String>();
        for (String hostname : hosts) {
            if (!this.filterUnhealthHostItem(hostname, actionExecutionContext, resourceFilter)) continue;
            removedHosts.add(hostname);
        }
        hosts.removeAll(removedHosts);
        return removedHosts;
    }

    public String getStatusCommandTimeout(ServiceInfo serviceInfo) throws OBDPException {
        Long overriddenTimeout;
        String commandTimeout = this.configs.getDefaultAgentTaskTimeout(false);
        if (serviceInfo.getSchemaVersion().equals("2.0")) {
            CommandScriptDefinition script = serviceInfo.getCommandScript();
            if (script != null) {
                if (script.getTimeout() > 0) {
                    commandTimeout = String.valueOf(script.getTimeout());
                }
            } else {
                String message = String.format("Service %s has no command script defined. It is not possible to run service check for this service", serviceInfo.getName());
                throw new OBDPException(message);
            }
        }
        if (!(overriddenTimeout = this.configs.getAgentServiceCheckTaskTimeout()).equals(Configuration.AGENT_SERVICE_CHECK_TASK_TIMEOUT.getDefaultValue())) {
            commandTimeout = String.valueOf(overriddenTimeout);
        }
        return commandTimeout;
    }
}

