/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ObjectNotFoundException;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.StackAccessException;
import id.onyx.obdp.server.actionmanager.Stage;
import id.onyx.obdp.server.actionmanager.TargetHostType;
import id.onyx.obdp.server.agent.ExecutionCommand;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.ActionExecutionContext;
import id.onyx.obdp.server.controller.ExecuteActionRequest;
import id.onyx.obdp.server.controller.MaintenanceStateHelper;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.RequestResourceFilter;
import id.onyx.obdp.server.customactions.ActionDefinition;
import id.onyx.obdp.server.stack.upgrade.RepositoryVersionHelper;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.ServiceComponentHostEvent;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostOpInProgressEvent;
import id.onyx.obdp.server.utils.SecretReference;
import id.onyx.obdp.server.utils.StageUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OBDPActionExecutionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(OBDPActionExecutionHelper.class);
    private static final String TYPE_PYTHON = "PYTHON";
    private static final String ACTION_FILE_EXTENSION = "py";
    private static final String ACTION_UPDATE_REPO = "update_repo";
    private static final String SUCCESS_FACTOR_PARAMETER = "success_factor";
    private static final float UPDATE_REPO_SUCCESS_FACTOR_DEFAULT = 0.0f;
    @Inject
    private Clusters clusters;
    @Inject
    private OBDPManagementController managementController;
    @Inject
    private OBDPMetaInfo obdpMetaInfo;
    @Inject
    private MaintenanceStateHelper maintenanceStateHelper;
    @Inject
    private Configuration configs;
    @Inject
    private RepositoryVersionHelper repoVersionHelper;

    public void validateAction(ExecuteActionRequest actionRequest) throws OBDPException {
        TargetHostType targetHostType;
        if (actionRequest.getActionName() == null || actionRequest.getActionName().isEmpty()) {
            throw new OBDPException("Action name must be specified");
        }
        ActionDefinition actionDef = this.obdpMetaInfo.getActionDefinition(actionRequest.getActionName());
        if (actionDef == null) {
            throw new OBDPException("Action " + actionRequest.getActionName() + " does not exist");
        }
        if (actionDef.getInputs() != null) {
            String[] inputs;
            for (String input : inputs = actionDef.getInputs().split(",")) {
                String inputName = input.trim();
                if (inputName.isEmpty()) continue;
                boolean mandatory = true;
                if (inputName.startsWith("[") && inputName.endsWith("]")) {
                    mandatory = false;
                }
                if (!mandatory || actionRequest.getParameters().containsKey(inputName)) continue;
                throw new OBDPException("Action " + actionRequest.getActionName() + " requires input '" + input.trim() + "' that is not provided.");
            }
        }
        List<RequestResourceFilter> resourceFilters = actionRequest.getResourceFilters();
        RequestResourceFilter resourceFilter = null;
        if (resourceFilters != null && !resourceFilters.isEmpty()) {
            if (resourceFilters.size() > 1) {
                throw new OBDPException("Custom action definition only allows one resource filter to be specified.");
            }
            resourceFilter = resourceFilters.get(0);
        }
        String targetService = "";
        String targetComponent = "";
        if (null != actionRequest.getClusterName()) {
            String actualComponent;
            String actualService;
            Cluster cluster = this.clusters.getCluster(actionRequest.getClusterName());
            if (cluster == null) {
                throw new OBDPException("Unable to find cluster. clusterName = " + actionRequest.getClusterName());
            }
            String expectedService = actionDef.getTargetService() == null ? "" : actionDef.getTargetService();
            String string = actualService = resourceFilter == null || resourceFilter.getServiceName() == null ? "" : resourceFilter.getServiceName();
            if (!(expectedService.isEmpty() || actualService.isEmpty() || expectedService.equals(actualService))) {
                throw new OBDPException("Action " + actionRequest.getActionName() + " targets service " + actualService + " that does not match with expected " + expectedService);
            }
            targetService = expectedService;
            if (StringUtils.isBlank((String)targetService)) {
                targetService = actualService;
            }
            if (StringUtils.isNotBlank((String)targetService)) {
                ServiceInfo serviceInfo;
                Service service = cluster.getService(targetService);
                StackId stackId = service.getDesiredStackId();
                try {
                    serviceInfo = this.obdpMetaInfo.getService(stackId.getStackName(), stackId.getStackVersion(), targetService);
                }
                catch (StackAccessException se) {
                    serviceInfo = null;
                }
                if (serviceInfo == null) {
                    throw new OBDPException("Action " + actionRequest.getActionName() + " targets service " + targetService + " that does not exist.");
                }
            }
            String expectedComponent = actionDef.getTargetComponent() == null ? "" : actionDef.getTargetComponent();
            String string2 = actualComponent = resourceFilter == null || resourceFilter.getComponentName() == null ? "" : resourceFilter.getComponentName();
            if (!(expectedComponent.isEmpty() || actualComponent.isEmpty() || expectedComponent.equals(actualComponent))) {
                throw new OBDPException("Action " + actionRequest.getActionName() + " targets component " + actualComponent + " that does not match with expected " + expectedComponent);
            }
            targetComponent = expectedComponent;
            if (StringUtils.isBlank((String)targetComponent)) {
                targetComponent = actualComponent;
            }
            if (StringUtils.isNotBlank((String)targetComponent) && StringUtils.isBlank((String)targetService)) {
                throw new OBDPException("Action " + actionRequest.getActionName() + " targets component " + targetComponent + " without specifying the target service.");
            }
            if (StringUtils.isNotBlank((String)targetComponent)) {
                ComponentInfo compInfo;
                Service service = cluster.getService(targetService);
                ServiceComponent component = service.getServiceComponent(targetComponent);
                StackId stackId = component.getDesiredStackId();
                try {
                    compInfo = this.obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), targetService, targetComponent);
                }
                catch (StackAccessException se) {
                    compInfo = null;
                }
                if (compInfo == null) {
                    throw new OBDPException("Action " + actionRequest.getActionName() + " targets component " + targetComponent + " that does not exist.");
                }
            }
        }
        if ((TargetHostType.SPECIFIC.equals((Object)(targetHostType = actionDef.getTargetType())) || targetService.isEmpty() && targetComponent.isEmpty()) && (resourceFilter == null || resourceFilter.getHostNames().size() == 0) && !this.isTargetHostTypeAllowsEmptyHosts(targetHostType)) {
            throw new OBDPException("Action " + actionRequest.getActionName() + " requires explicit target host(s) that is not provided.");
        }
    }

    private boolean isTargetHostTypeAllowsEmptyHosts(TargetHostType targetHostType) {
        return targetHostType.equals((Object)TargetHostType.ALL) || targetHostType.equals((Object)TargetHostType.ANY) || targetHostType.equals((Object)TargetHostType.MAJORITY);
    }

    public void addExecutionCommandsToStage(ActionExecutionContext actionContext, Stage stage, Map<String, String> requestParams) throws OBDPException {
        this.addExecutionCommandsToStage(actionContext, stage, requestParams, true);
    }

    public void addExecutionCommandsToStage(final ActionExecutionContext actionContext, Stage stage, Map<String, String> requestParams, boolean checkHostIsMemberOfCluster) throws OBDPException {
        List<String> targetHosts;
        String actionName = actionContext.getActionName();
        String clusterName = actionContext.getClusterName();
        final Cluster cluster = null != clusterName ? this.clusters.getCluster(clusterName) : null;
        ComponentInfo componentInfo = null;
        List<RequestResourceFilter> resourceFilters = actionContext.getResourceFilters();
        final RequestResourceFilter resourceFilter = resourceFilters != null && !resourceFilters.isEmpty() ? resourceFilters.get(0) : new RequestResourceFilter();
        HashSet<String> candidateHosts = new HashSet<String>();
        final String serviceName = actionContext.getExpectedServiceName();
        final String componentName = actionContext.getExpectedComponentName();
        LOG.debug("Called addExecutionCommandsToStage() for serviceName: {}, componentName: {}.", (Object)serviceName, (Object)componentName);
        if (resourceFilter.getHostNames().isEmpty()) {
            LOG.debug("Resource filter has no hostnames.");
        } else {
            LOG.debug("Resource filter has hosts: {}", (Object)StringUtils.join(resourceFilter.getHostNames(), (String)", "));
        }
        if (null != cluster) {
            if (serviceName != null && !serviceName.isEmpty()) {
                if (componentName != null && !componentName.isEmpty()) {
                    Service service = cluster.getService(serviceName);
                    ServiceComponent serviceComponent = service.getServiceComponent(componentName);
                    StackId stackId = serviceComponent.getDesiredStackId();
                    Map<String, ServiceComponentHost> componentHosts = serviceComponent.getServiceComponentHosts();
                    candidateHosts.addAll(componentHosts.keySet());
                    try {
                        componentInfo = this.obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), serviceName, componentName);
                    }
                    catch (ObjectNotFoundException e) {
                        LOG.error("Did not find service {} and component {} in stack {}.", new Object[]{serviceName, componentName, stackId.getStackName()});
                    }
                } else {
                    for (String string : cluster.getService(serviceName).getServiceComponents().keySet()) {
                        Map<String, ServiceComponentHost> componentHosts = cluster.getService(serviceName).getServiceComponent(string).getServiceComponentHosts();
                        candidateHosts.addAll(componentHosts.keySet());
                    }
                }
            } else {
                candidateHosts.addAll(this.clusters.getHostsForCluster(cluster.getClusterName()).keySet());
            }
            LOG.debug("Request for service {} and component {} is set to run on candidate hosts: {}.", new Object[]{serviceName, componentName, StringUtils.join(candidateHosts, (String)", ")});
            Set<String> ignoredHosts = this.maintenanceStateHelper.filterHostsInMaintenanceState(candidateHosts, new MaintenanceStateHelper.HostPredicate(){

                @Override
                public boolean shouldHostBeRemoved(String hostname) throws OBDPException {
                    return !OBDPActionExecutionHelper.this.maintenanceStateHelper.isOperationAllowed(cluster, actionContext.getOperationLevel(), resourceFilter, serviceName, componentName, hostname);
                }
            });
            if (!ignoredHosts.isEmpty()) {
                LOG.debug("Hosts to ignore: {}.", (Object)ignoredHosts);
                LOG.debug("Ignoring action for hosts due to maintenance state.Ignored hosts ={}, component={}, service={}, cluster={}, actionName={}", new Object[]{ignoredHosts, componentName, serviceName, cluster.getClusterName(), actionContext.getActionName()});
            }
        }
        if (resourceFilter.getHostNames().isEmpty() && candidateHosts.isEmpty()) {
            throw new OBDPException("Suitable hosts not found, component=" + componentName + ", service=" + serviceName + (String)(null == cluster ? "" : ", cluster=" + cluster.getClusterName() + ", ") + "actionName=" + actionContext.getActionName());
        }
        if (checkHostIsMemberOfCluster && !resourceFilter.getHostNames().isEmpty() && !candidateHosts.isEmpty()) {
            for (String string : resourceFilter.getHostNames()) {
                if (candidateHosts.contains(string)) continue;
                throw new OBDPException("Request specifies host " + string + " but it is not a valid host based on the target service=" + serviceName + " and component=" + componentName);
            }
        }
        if ((targetHosts = resourceFilter.getHostNames()).isEmpty()) {
            TargetHostType targetHostType = actionContext.getTargetType();
            switch (targetHostType) {
                case ALL: {
                    targetHosts.addAll(candidateHosts);
                    break;
                }
                case ANY: {
                    targetHosts.add(this.managementController.getHealthyHost(candidateHosts));
                    break;
                }
                case MAJORITY: {
                    for (int i = 0; i < candidateHosts.size() / 2 + 1; ++i) {
                        String hostname = this.managementController.getHealthyHost(candidateHosts);
                        targetHosts.add(hostname);
                        candidateHosts.remove(hostname);
                    }
                    break;
                }
                default: {
                    throw new OBDPException("Unsupported target type = " + targetHostType);
                }
            }
        }
        this.setAdditionalParametersForStageAccordingToAction(stage, actionContext);
        for (String hostName : targetHosts) {
            Map<String, String> actionParameters = actionContext.getParameters();
            stage.addHostRoleExecutionCommand(hostName, Role.valueOf(actionContext.getActionName()), RoleCommand.ACTIONEXECUTE, (ServiceComponentHostEvent)new ServiceComponentHostOpInProgressEvent(actionContext.getActionName(), hostName, System.currentTimeMillis()), clusterName, serviceName, actionContext.isRetryAllowed(), actionContext.isFailureAutoSkipped());
            TreeMap<String, String> commandParams = new TreeMap<String, String>();
            int taskTimeout = Integer.parseInt(this.configs.getDefaultAgentTaskTimeout(false));
            if (null != actionContext.getTimeout() && actionContext.getTimeout() > taskTimeout) {
                commandParams.put("command_timeout", actionContext.getTimeout().toString());
            } else {
                commandParams.put("command_timeout", Integer.toString(taskTimeout));
            }
            if (requestParams != null && requestParams.containsKey("log_output")) {
                LOG.info("Should command log output?: " + requestParams.get("log_output"));
                commandParams.put("log_output", requestParams.get("log_output"));
            }
            commandParams.put("script", actionName + ".py");
            commandParams.put("script_type", TYPE_PYTHON);
            StageUtils.useAmbariJdkInCommandParams(commandParams, this.configs);
            ExecutionCommand execCmd = stage.getExecutionCommandWrapper(hostName, actionContext.getActionName()).getExecutionCommand();
            execCmd.setConfigurations(new TreeMap<String, Map<String, String>>());
            if (null != actionParameters && !actionParameters.isEmpty()) {
                if (actionParameters.containsKey("overrideConfigs")) {
                    execCmd.setOverrideConfigs(true);
                }
                if (actionParameters.containsKey("overrideStackName")) {
                    Map<String, String> clusterLevelParams = execCmd.getClusterLevelParams();
                    if (clusterLevelParams == null) {
                        clusterLevelParams = new HashMap<String, String>();
                    }
                    clusterLevelParams.put("stack_name", actionContext.getStackId().getStackName());
                    execCmd.setClusterLevelParams(clusterLevelParams);
                }
            }
            execCmd.setServiceName(serviceName == null || serviceName.isEmpty() ? resourceFilter.getServiceName() : serviceName);
            execCmd.setComponentName(componentName == null || componentName.isEmpty() ? resourceFilter.getComponentName() : componentName);
            Map<String, String> hostLevelParams = execCmd.getHostLevelParams();
            hostLevelParams.put("gpl_license_accepted", this.configs.getGplLicenseAccepted().toString());
            hostLevelParams.put("agent_stack_retry_on_unavailability", this.configs.isAgentStackRetryOnInstallEnabled());
            hostLevelParams.put("agent_stack_retry_count", this.configs.getAgentStackRetryOnInstallCount());
            for (Map.Entry<String, String> dbConnectorName : this.configs.getDatabaseConnectorNames().entrySet()) {
                hostLevelParams.put(dbConnectorName.getKey(), dbConnectorName.getValue());
            }
            for (Map.Entry<String, String> previousDBConnectorName : this.configs.getPreviousDatabaseConnectorNames().entrySet()) {
                hostLevelParams.put(previousDBConnectorName.getKey(), previousDBConnectorName.getValue());
            }
            if (StringUtils.isNotBlank((String)serviceName)) {
                Service service = cluster.getService(serviceName);
                this.repoVersionHelper.addRepoInfoToHostLevelParams(cluster, actionContext, service.getDesiredRepositoryVersion(), hostLevelParams, hostName);
            } else {
                this.repoVersionHelper.addRepoInfoToHostLevelParams(cluster, actionContext, null, hostLevelParams, hostName);
            }
            Map<String, String> roleParams = execCmd.getRoleParams();
            if (roleParams == null) {
                roleParams = new TreeMap<String, String>();
            }
            roleParams.putAll(actionParameters);
            SecretReference.replaceReferencesWithPasswords(roleParams, cluster);
            if (componentInfo != null) {
                roleParams.put("component_category", componentInfo.getCategory());
            }
            if (null != cluster && cluster.isUpgradeSuspended()) {
                cluster.addSuspendedUpgradeParameters(commandParams, roleParams);
            }
            execCmd.setCommandParams(commandParams);
            execCmd.setRoleParams(roleParams);
            if (null != cluster) {
                for (ServiceComponentHost sch : cluster.getServiceComponentHosts(hostName)) {
                    execCmd.getLocalComponents().add(sch.getServiceComponentName());
                }
            }
            actionContext.visitAll(execCmd);
        }
    }

    private void setAdditionalParametersForStageAccordingToAction(Stage stage, ActionExecutionContext actionExecutionContext) throws OBDPException {
        if (actionExecutionContext.getActionName().equals(ACTION_UPDATE_REPO)) {
            Map<String, String> params = actionExecutionContext.getParameters();
            float successFactor = 0.0f;
            if (params != null && params.containsKey(SUCCESS_FACTOR_PARAMETER)) {
                try {
                    successFactor = Float.valueOf(params.get(SUCCESS_FACTOR_PARAMETER)).floatValue();
                }
                catch (Exception ex) {
                    throw new OBDPException("Failed to cast success_factor value to float!", ex.getCause());
                }
            }
            stage.getSuccessFactors().put(Role.UPDATE_REPO, Float.valueOf(successFactor));
        }
    }
}

