/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import id.onyx.obdp.server.HostNotFoundException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.RootService;
import id.onyx.obdp.server.controller.internal.RequestOperationLevel;
import id.onyx.obdp.server.controller.internal.RequestResourceFilter;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.state.Alert;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MaintenanceStateHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MaintenanceStateHelper.class);
    @Inject
    private Clusters clusters;

    @Inject
    public MaintenanceStateHelper(Injector injector) {
        injector.injectMembers((Object)this);
    }

    public boolean isOperationAllowed(Cluster cluster, RequestOperationLevel levelObj, RequestResourceFilter reqFilter, String serviceName, String componentName, String hostname) throws OBDPException {
        Resource.Type level = levelObj == null ? this.guessOperationLevel(reqFilter) : levelObj.getLevel();
        return this.isOperationAllowed(cluster, level, serviceName, componentName, hostname);
    }

    boolean isOperationAllowed(Cluster cluster, Resource.Type level, String serviceName, String componentName, String hostname) throws OBDPException {
        if (serviceName != null && !serviceName.isEmpty()) {
            Service service = cluster.getService(serviceName);
            if (componentName != null && !componentName.isEmpty()) {
                ServiceComponentHost sch = service.getServiceComponent(componentName).getServiceComponentHost(hostname);
                return this.isOperationAllowed(level, sch);
            }
            return this.isOperationAllowed(level, service);
        }
        Host host = this.clusters.getHost(hostname);
        return this.isOperationAllowed(host, cluster.getClusterId(), level);
    }

    public boolean isOperationAllowed(Resource.Type level, Service service) throws OBDPException {
        if (level == Resource.Type.Cluster) {
            return service.getMaintenanceState() == MaintenanceState.OFF;
        }
        return true;
    }

    public boolean isOperationAllowed(Host host, long clusterId, Resource.Type level) throws OBDPException {
        if (level == Resource.Type.Cluster) {
            return host.getMaintenanceState(clusterId) == MaintenanceState.OFF;
        }
        return true;
    }

    public MaintenanceState getEffectiveState(ServiceComponentHost sch, Host host) throws OBDPException {
        Cluster cluster = this.clusters.getCluster(sch.getClusterName());
        Service service = cluster.getService(sch.getServiceName());
        if (null == host) {
            throw new HostNotFoundException(cluster.getClusterName(), sch.getHostName());
        }
        return this.getEffectiveState(cluster.getClusterId(), service, host, sch);
    }

    public MaintenanceState getEffectiveState(ServiceComponentHost sch) throws OBDPException {
        Host host = this.clusters.getHost(sch.getHostName());
        return this.getEffectiveState(sch, host);
    }

    private MaintenanceState getEffectiveState(long clusterId, Service service, Host host, ServiceComponentHost sch) {
        MaintenanceState schState = sch.getMaintenanceState();
        if (MaintenanceState.ON == schState) {
            return MaintenanceState.ON;
        }
        MaintenanceState serviceState = service.getMaintenanceState();
        MaintenanceState hostState = host.getMaintenanceState(clusterId);
        if (MaintenanceState.OFF != serviceState && MaintenanceState.OFF != hostState) {
            return MaintenanceState.IMPLIED_FROM_SERVICE_AND_HOST;
        }
        if (MaintenanceState.OFF != serviceState) {
            return MaintenanceState.IMPLIED_FROM_SERVICE;
        }
        if (MaintenanceState.OFF != hostState) {
            return MaintenanceState.IMPLIED_FROM_HOST;
        }
        return schState;
    }

    public MaintenanceState getEffectiveState(long clusterId, Alert alert) throws OBDPException {
        ServiceComponent serviceComponent;
        ServiceComponentHost serviceComponentHost;
        Host host;
        String serviceName = alert.getService();
        String componentName = alert.getComponent();
        String hostName = alert.getHostName();
        if (null == serviceName && null == hostName) {
            LOG.warn("Unable to determine maintenance state for an alert without a service or host");
            return MaintenanceState.OFF;
        }
        if (StringUtils.isNotBlank((String)hostName) && (host = this.clusters.getHost(hostName)).getMaintenanceState(clusterId) != MaintenanceState.OFF) {
            return MaintenanceState.ON;
        }
        if (StringUtils.equals((String)RootService.OBDP.name(), (String)serviceName)) {
            return MaintenanceState.OFF;
        }
        Cluster cluster = this.clusters.getClusterById(clusterId);
        Service service = cluster.getService(serviceName);
        if (service.getMaintenanceState() != MaintenanceState.OFF) {
            return MaintenanceState.ON;
        }
        if (StringUtils.isNotBlank((String)componentName) && (serviceComponentHost = (serviceComponent = service.getServiceComponent(componentName)).getServiceComponentHost(hostName)).getMaintenanceState() != MaintenanceState.OFF) {
            return MaintenanceState.ON;
        }
        return MaintenanceState.OFF;
    }

    public Set<Map<String, String>> getMaintenanceHostComponents(Clusters clusters, Cluster cluster) throws OBDPException {
        HashSet<Map<String, String>> set = new HashSet<Map<String, String>>();
        Map<String, Host> hosts = clusters.getHostsForCluster(cluster.getClusterName());
        for (Service service : cluster.getServices().values()) {
            for (ServiceComponent sc : service.getServiceComponents().values()) {
                if (sc.isClientComponent()) continue;
                for (ServiceComponentHost sch : sc.getServiceComponentHosts().values()) {
                    Host host = hosts.get(sch.getHostName());
                    if (MaintenanceState.OFF == this.getEffectiveState(cluster.getClusterId(), service, host, sch)) continue;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("host", sch.getHostName());
                    map.put("service", sch.getServiceName());
                    map.put("component", sch.getServiceComponentName());
                    set.add(map);
                }
            }
        }
        return set;
    }

    public boolean isOperationAllowed(Resource.Type operationLevel, ServiceComponentHost sch) throws OBDPException {
        MaintenanceState maintenanceState = this.getEffectiveState(sch);
        switch (operationLevel.getInternalType()) {
            case Cluster: {
                if (!maintenanceState.equals((Object)MaintenanceState.OFF)) break;
                return true;
            }
            case Service: {
                if (!maintenanceState.equals((Object)MaintenanceState.IMPLIED_FROM_SERVICE) && !maintenanceState.equals((Object)MaintenanceState.OFF)) break;
                return true;
            }
            case Host: {
                if (!maintenanceState.equals((Object)MaintenanceState.IMPLIED_FROM_HOST) && !maintenanceState.equals((Object)MaintenanceState.OFF)) break;
                return true;
            }
            case HostComponent: {
                return true;
            }
            default: {
                LOG.warn("Unsupported Resource type, type = " + operationLevel);
            }
        }
        return false;
    }

    public Resource.Type guessOperationLevel(RequestResourceFilter filter) {
        Resource.Type result;
        if (filter == null) {
            result = Resource.Type.Cluster;
        } else {
            boolean hostsDefined;
            boolean serviceDefined = filter.getServiceName() != null;
            boolean componentDefined = filter.getComponentName() != null;
            boolean bl = hostsDefined = filter.getHostNames() != null && filter.getHostNames().size() > 0;
            result = hostsDefined & componentDefined ? Resource.Type.HostComponent : (!serviceDefined & hostsDefined ? Resource.Type.Host : (serviceDefined & !hostsDefined ? Resource.Type.Service : Resource.Type.Cluster));
        }
        return result;
    }

    public Set<String> filterHostsInMaintenanceState(Set<String> candidateHosts, HostPredicate condition) throws OBDPException {
        HashSet<String> removedHosts = new HashSet<String>();
        for (String hostname : candidateHosts) {
            if (!condition.shouldHostBeRemoved(hostname)) continue;
            removedHosts.add(hostname);
        }
        candidateHosts.removeAll(removedHosts);
        return removedHosts;
    }

    public static interface HostPredicate {
        public boolean shouldHostBeRemoved(String var1) throws OBDPException;
    }
}

