/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.ServiceNotFoundException;
import id.onyx.obdp.server.actionmanager.ActionManager;
import id.onyx.obdp.server.actionmanager.RequestFactory;
import id.onyx.obdp.server.actionmanager.Stage;
import id.onyx.obdp.server.actionmanager.StageFactory;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorException;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorHelper;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorRequest;
import id.onyx.obdp.server.api.services.stackadvisor.recommendations.RecommendationResponse;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.ActionExecutionContext;
import id.onyx.obdp.server.controller.AuthToLocalBuilder;
import id.onyx.obdp.server.controller.DeleteIdentityHandler;
import id.onyx.obdp.server.controller.KerberosDetails;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.controller.OBDPCustomCommandExecutionHelper;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OrderedRequestStageContainer;
import id.onyx.obdp.server.controller.RootComponent;
import id.onyx.obdp.server.controller.RootService;
import id.onyx.obdp.server.controller.UpdateConfigurationPolicy;
import id.onyx.obdp.server.controller.internal.RequestResourceFilter;
import id.onyx.obdp.server.controller.internal.RequestStageContainer;
import id.onyx.obdp.server.controller.utilities.KerberosChecker;
import id.onyx.obdp.server.metadata.RoleCommandOrder;
import id.onyx.obdp.server.orm.dao.ArtifactDAO;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.dao.KerberosKeytabDAO;
import id.onyx.obdp.server.orm.dao.KerberosKeytabPrincipalDAO;
import id.onyx.obdp.server.orm.dao.KerberosPrincipalDAO;
import id.onyx.obdp.server.orm.entities.ArtifactEntity;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.KerberosKeytabEntity;
import id.onyx.obdp.server.orm.entities.KerberosKeytabPrincipalEntity;
import id.onyx.obdp.server.orm.entities.KerberosPrincipalEntity;
import id.onyx.obdp.server.security.credential.Credential;
import id.onyx.obdp.server.security.credential.PrincipalKeyCredential;
import id.onyx.obdp.server.security.encryption.CredentialStoreService;
import id.onyx.obdp.server.serveraction.ServerAction;
import id.onyx.obdp.server.serveraction.kerberos.CleanupServerAction;
import id.onyx.obdp.server.serveraction.kerberos.Component;
import id.onyx.obdp.server.serveraction.kerberos.ConfigureOBDPIdentitiesServerAction;
import id.onyx.obdp.server.serveraction.kerberos.CreateKeytabFilesServerAction;
import id.onyx.obdp.server.serveraction.kerberos.CreatePrincipalsServerAction;
import id.onyx.obdp.server.serveraction.kerberos.DestroyPrincipalsServerAction;
import id.onyx.obdp.server.serveraction.kerberos.FinalizeKerberosServerAction;
import id.onyx.obdp.server.serveraction.kerberos.KDCType;
import id.onyx.obdp.server.serveraction.kerberos.KerberosAdminAuthenticationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosIdentityDataFileWriter;
import id.onyx.obdp.server.serveraction.kerberos.KerberosInvalidConfigurationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosKDCConnectionException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosKDCSSLConnectionException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosLDAPContainerException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosMissingAdminCredentialsException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationHandler;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationHandlerFactory;
import id.onyx.obdp.server.serveraction.kerberos.KerberosRealmException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosServerAction;
import id.onyx.obdp.server.serveraction.kerberos.PrepareDisableKerberosServerAction;
import id.onyx.obdp.server.serveraction.kerberos.PrepareEnableKerberosServerAction;
import id.onyx.obdp.server.serveraction.kerberos.PrepareKerberosIdentitiesServerAction;
import id.onyx.obdp.server.serveraction.kerberos.UpdateKerberosConfigsServerAction;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosKeytab;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosPrincipal;
import id.onyx.obdp.server.stageplanner.RoleGraph;
import id.onyx.obdp.server.stageplanner.RoleGraphFactory;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.HostState;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.SecurityType;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.State;
import id.onyx.obdp.server.state.ValueAttributesInfo;
import id.onyx.obdp.server.state.kerberos.AbstractKerberosDescriptorContainer;
import id.onyx.obdp.server.state.kerberos.KerberosComponentDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosConfigurationDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptorFactory;
import id.onyx.obdp.server.state.kerberos.KerberosIdentityDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosKeytabDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosPrincipalDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosPrincipalType;
import id.onyx.obdp.server.state.kerberos.KerberosServiceDescriptor;
import id.onyx.obdp.server.state.kerberos.VariableReplacementHelper;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostServerActionEvent;
import id.onyx.obdp.server.utils.StageUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.server.kerberos.shared.keytab.Keytab;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KerberosHelperImpl
implements KerberosHelper {
    public static final String BASE_LOG_DIR = "/tmp/obdp";
    private static final Logger LOG = LoggerFactory.getLogger(KerberosHelperImpl.class);
    private static final Set<State> PREVIOUSLY_INSTALLED_STATES = EnumSet.of(State.INSTALLED, State.STARTED, State.DISABLED);
    public static final String CHECK_KEYTABS = "CHECK_KEYTABS";
    public static final String SET_KEYTAB = "SET_KEYTAB";
    public static final String REMOVE_KEYTAB = "REMOVE_KEYTAB";
    @Inject
    private OBDPCustomCommandExecutionHelper customCommandExecutionHelper;
    @Inject
    private OBDPManagementController ambariManagementController;
    @Inject
    private OBDPMetaInfo obdpMetaInfo;
    @Inject
    private ActionManager actionManager;
    @Inject
    private RequestFactory requestFactory;
    @Inject
    private StageFactory stageFactory;
    @Inject
    private RoleGraphFactory roleGraphFactory;
    @Inject
    private Clusters clusters;
    @Inject
    private ConfigHelper configHelper;
    @Inject
    private VariableReplacementHelper variableReplacementHelper;
    @Inject
    private Configuration configuration;
    @Inject
    private KerberosOperationHandlerFactory kerberosOperationHandlerFactory;
    @Inject
    private KerberosDescriptorFactory kerberosDescriptorFactory;
    @Inject
    private ArtifactDAO artifactDAO;
    @Inject
    private KerberosPrincipalDAO kerberosPrincipalDAO;
    @Inject
    private KerberosKeytabDAO kerberosKeytabDAO;
    @Inject
    private KerberosKeytabPrincipalDAO kerberosKeytabPrincipalDAO;
    @Inject
    private HostDAO hostDAO;
    @Inject
    private Injector injector;
    @Inject
    private CredentialStoreService credentialStoreService;
    @Inject
    private StackAdvisorHelper stackAdvisorHelper;

    @Override
    public RequestStageContainer toggleKerberos(Cluster cluster, SecurityType securityType, RequestStageContainer requestStageContainer, Boolean manageIdentities) throws OBDPException, KerberosOperationException {
        KerberosDetails kerberosDetails = this.getKerberosDetails(cluster, manageIdentities);
        kerberosDetails.setSecurityType(securityType);
        if (securityType == SecurityType.KERBEROS) {
            LOG.info("Configuring Kerberos for realm {} on cluster, {}", (Object)kerberosDetails.getDefaultRealm(), (Object)cluster.getClusterName());
            requestStageContainer = this.handle(cluster, kerberosDetails, null, null, null, null, requestStageContainer, new EnableKerberosHandler());
        } else if (securityType == SecurityType.NONE) {
            LOG.info("Disabling Kerberos from cluster, {}", (Object)cluster.getClusterName());
            requestStageContainer = this.handle(cluster, kerberosDetails, null, null, null, null, requestStageContainer, new DisableKerberosHandler());
        } else {
            throw new OBDPException(String.format("Unexpected security type value: %s", securityType.name()));
        }
        return requestStageContainer;
    }

    @Override
    public RequestStageContainer executeCustomOperations(Cluster cluster, Map<String, String> requestProperties, RequestStageContainer requestStageContainer, Boolean manageIdentities) throws OBDPException, KerberosOperationException {
        if (requestProperties != null) {
            block3: for (SupportedCustomOperation operation : SupportedCustomOperation.values()) {
                if (!requestProperties.containsKey(operation.name().toLowerCase())) continue;
                String value = requestProperties.get(operation.name().toLowerCase());
                switch (operation) {
                    case REGENERATE_KEYTABS: {
                        KerberosServerAction.OperationType operationType;
                        if (cluster.getSecurityType() != SecurityType.KERBEROS) {
                            throw new OBDPException(String.format("Custom operation %s can only be requested with the security type cluster property: %s", operation.name(), SecurityType.KERBEROS.name()));
                        }
                        if ("true".equalsIgnoreCase(value) || "all".equalsIgnoreCase(value)) {
                            operationType = KerberosServerAction.OperationType.RECREATE_ALL;
                        } else if ("missing".equalsIgnoreCase(value)) {
                            operationType = KerberosServerAction.OperationType.CREATE_MISSING;
                        } else {
                            throw new OBDPException(String.format("Unexpected directive value: %s", value));
                        }
                        boolean retryAllowed = false;
                        if (requestProperties.containsKey("allow_retry_on_failure")) {
                            String allowRetryString = requestProperties.get("allow_retry_on_failure");
                            retryAllowed = Boolean.parseBoolean(allowRetryString);
                        }
                        Set<String> hostFilter = KerberosHelperImpl.parseHostFilter(requestProperties);
                        Map<String, Set<String>> serviceComponentFilter = KerberosHelperImpl.parseComponentFilter(requestProperties);
                        UpdateConfigurationPolicy updateConfigurationsPolicy = UpdateConfigurationPolicy.ALL;
                        if (requestProperties.containsKey("config_update_policy")) {
                            String policyValue = requestProperties.get("config_update_policy");
                            updateConfigurationsPolicy = UpdateConfigurationPolicy.translate(policyValue);
                            if (updateConfigurationsPolicy == null) {
                                throw new OBDPException(String.format("Unexpected comfiguration policy value: %s", policyValue));
                            }
                        } else if (requestProperties.containsKey("ignore_config_updates") && "true".equalsIgnoreCase(requestProperties.get("ignore_config_updates"))) {
                            updateConfigurationsPolicy = UpdateConfigurationPolicy.NEW_AND_IDENTITIES;
                        }
                        boolean forceAllHosts = hostFilter == null || hostFilter.contains("*");
                        CreatePrincipalsAndKeytabsHandler handler = new CreatePrincipalsAndKeytabsHandler(operationType, updateConfigurationsPolicy, forceAllHosts, true);
                        handler.setRetryAllowed(retryAllowed);
                        requestStageContainer = this.handle(cluster, this.getKerberosDetails(cluster, manageIdentities), serviceComponentFilter, hostFilter, null, null, requestStageContainer, handler);
                        continue block3;
                    }
                    default: {
                        throw new OBDPException(String.format("Custom operation not supported: %s", operation.name()));
                    }
                }
            }
        }
        return requestStageContainer;
    }

    public static Set<String> parseHostFilter(Map<String, String> requestProperties) {
        if (requestProperties.containsKey("regenerate_hosts")) {
            return ImmutableSet.copyOf((Object[])requestProperties.get("regenerate_hosts").split(","));
        }
        return null;
    }

    public static Map<String, Set<String>> parseComponentFilter(Map<String, String> requestProperties) {
        if (requestProperties.containsKey("regenerate_components")) {
            ImmutableMap.Builder serviceComponentFilter = ImmutableMap.builder();
            for (String serviceString : requestProperties.get("regenerate_components").split(",")) {
                String[] serviceComponentsArray = serviceString.split(":");
                String serviceName = serviceComponentsArray[0];
                if (serviceComponentsArray.length == 2) {
                    serviceComponentFilter.put((Object)serviceName, (Object)ImmutableSet.copyOf((Object[])serviceComponentsArray[1].split(";")));
                    continue;
                }
                serviceComponentFilter.put((Object)serviceName, (Object)ImmutableSet.of((Object)"*"));
            }
            return serviceComponentFilter.build();
        }
        return null;
    }

    @Override
    public RequestStageContainer ensureIdentities(Cluster cluster, Map<String, ? extends Collection<String>> serviceComponentFilter, Set<String> hostFilter, Collection<String> identityFilter, Set<String> hostsToForceKerberosOperations, RequestStageContainer requestStageContainer, Boolean manageIdentities) throws OBDPException, KerberosOperationException {
        return this.handle(cluster, this.getKerberosDetails(cluster, manageIdentities), serviceComponentFilter, hostFilter, identityFilter, hostsToForceKerberosOperations, requestStageContainer, new CreatePrincipalsAndKeytabsHandler(KerberosServerAction.OperationType.DEFAULT, UpdateConfigurationPolicy.NONE, false, false));
    }

    @Override
    public RequestStageContainer deleteIdentities(Cluster cluster, Map<String, ? extends Collection<String>> serviceComponentFilter, Set<String> hostFilter, Collection<String> identityFilter, RequestStageContainer requestStageContainer, Boolean manageIdentities) throws OBDPException, KerberosOperationException {
        return this.handle(cluster, this.getKerberosDetails(cluster, manageIdentities), serviceComponentFilter, hostFilter, identityFilter, null, requestStageContainer, new DeletePrincipalsAndKeytabsHandler());
    }

    @Override
    public void deleteIdentities(Cluster cluster, List<Component> components, Set<String> identities) throws OBDPException, KerberosOperationException {
        LOG.info("Deleting identities: ", identities);
        KerberosDetails kerberosDetails = this.getKerberosDetails(cluster, null);
        this.validateKDCCredentials(kerberosDetails, cluster);
        File dataDirectory = this.createTemporaryDirectory();
        RoleCommandOrder roleCommandOrder = this.ambariManagementController.getRoleCommandOrder(cluster);
        DeleteIdentityHandler handler = new DeleteIdentityHandler(this.customCommandExecutionHelper, this.configuration.getDefaultServerTaskTimeout(), this.stageFactory, this.ambariManagementController);
        DeleteIdentityHandler.CommandParams commandParameters = new DeleteIdentityHandler.CommandParams(components, identities, this.ambariManagementController.getAuthName(), dataDirectory, kerberosDetails.getDefaultRealm(), kerberosDetails.getKdcType());
        OrderedRequestStageContainer stageContainer = new OrderedRequestStageContainer(this.roleGraphFactory, roleCommandOrder, new RequestStageContainer(this.actionManager.getNextRequestId(), null, this.requestFactory, this.actionManager));
        handler.addDeleteIdentityStages(cluster, stageContainer, commandParameters, kerberosDetails.manageIdentities());
        stageContainer.getRequestStageContainer().persist();
    }

    @Override
    public void configureServices(Cluster cluster, Map<String, Collection<String>> serviceFilter) throws OBDPException, KerberosInvalidConfigurationException {
        HashMap<String, Set<String>> installedServices = new HashMap<String, Set<String>>();
        HashSet<String> previouslyExistingServices = new HashSet<String>();
        this.getServiceComponentHosts(cluster, sch -> {
            if (sch != null) {
                String serviceName = sch.getServiceName();
                Set installedComponents = installedServices.computeIfAbsent(serviceName, k -> new HashSet());
                installedComponents.add(sch.getServiceComponentName());
                if (!previouslyExistingServices.contains(serviceName) && PREVIOUSLY_INSTALLED_STATES.contains((Object)sch.getState())) {
                    previouslyExistingServices.add(serviceName);
                }
                return true;
            }
            return false;
        });
        Map<String, Map<String, String>> existingConfigurations = this.configHelper.calculateExistingConfigurations(this.ambariManagementController, cluster, null, null);
        Map<String, Map<String, String>> updates = this.getServiceConfigurationUpdates(cluster, existingConfigurations, installedServices, serviceFilter, previouslyExistingServices, true, true);
        for (Map.Entry<String, Map<String, String>> entry : updates.entrySet()) {
            this.configHelper.updateConfigType(cluster, cluster.getDesiredStackVersion(), this.ambariManagementController, entry.getKey(), entry.getValue(), null, this.ambariManagementController.getAuthName(), "Enabling Kerberos for added components");
        }
    }

    @Override
    public Map<String, Map<String, String>> getServiceConfigurationUpdates(Cluster cluster, Map<String, Map<String, String>> existingConfigurations, Map<String, Set<String>> installedServices, Map<String, Collection<String>> serviceFilter, Set<String> previouslyExistingServices, boolean kerberosEnabled, boolean applyStackAdvisorUpdates) throws KerberosInvalidConfigurationException, OBDPException {
        HashMap<String, Map<String, String>> kerberosConfigurations = new HashMap<String, Map<String, String>>();
        KerberosDetails kerberosDetails = this.getKerberosDetails(cluster, null);
        KerberosDescriptor kerberosDescriptor = this.getKerberosDescriptor(cluster, false);
        Map<String, String> kerberosDescriptorProperties = kerberosDescriptor.getProperties();
        Map<String, Map<String, String>> configurations = this.addAdditionalConfigurations(cluster, this.deepCopy(existingConfigurations), null, kerberosDescriptorProperties, null);
        HashMap<String, Set<String>> propertiesToIgnore = new HashMap<String, Set<String>>();
        if (this.createAmbariIdentities(existingConfigurations.get("kerberos-env"))) {
            installedServices = new HashMap<String, Set<String>>(installedServices);
            installedServices.put(RootService.OBDP.name(), Collections.singleton(RootComponent.OBDP_SERVER.name()));
        }
        HashMap<String, Object> filterContext = new HashMap<String, Object>();
        filterContext.put("configurations", configurations);
        filterContext.put("services", installedServices.keySet());
        for (Map.Entry<String, Set<String>> installedServiceEntry : installedServices.entrySet()) {
            String installedService = installedServiceEntry.getKey();
            if (serviceFilter != null && !serviceFilter.containsKey(installedService)) continue;
            Collection<String> componentFilter = serviceFilter == null ? null : serviceFilter.get(installedService);
            Set<String> installedComponents = installedServiceEntry.getValue();
            KerberosServiceDescriptor serviceDescriptor = kerberosDescriptor.getService(installedService);
            if (serviceDescriptor == null || installedComponents == null) continue;
            boolean servicePreviouslyExisted = previouslyExistingServices != null && previouslyExistingServices.contains(installedService);
            for (String installedComponent : installedComponents) {
                KerberosComponentDescriptor componentDescriptor;
                if (componentFilter != null && !componentFilter.contains(installedComponent) || (componentDescriptor = serviceDescriptor.getComponent(installedComponent)) == null) continue;
                Map<String, Map<String, String>> identityConfigurations = this.getIdentityConfigurations(serviceDescriptor.getIdentities(true, filterContext));
                this.processIdentityConfigurations(identityConfigurations, kerberosConfigurations, configurations, propertiesToIgnore);
                identityConfigurations = this.getIdentityConfigurations(componentDescriptor.getIdentities(true, filterContext));
                this.processIdentityConfigurations(identityConfigurations, kerberosConfigurations, configurations, propertiesToIgnore);
                this.mergeConfigurations(kerberosConfigurations, componentDescriptor.getConfigurations(!servicePreviouslyExisted), configurations, null);
            }
        }
        this.setAuthToLocalRules(cluster, kerberosDescriptor, kerberosDetails.getDefaultRealm(), installedServices, configurations, kerberosConfigurations, false);
        return applyStackAdvisorUpdates ? this.applyStackAdvisorUpdates(cluster, installedServices.keySet(), configurations, kerberosConfigurations, propertiesToIgnore, new HashMap<String, Set<String>>(), kerberosEnabled) : kerberosConfigurations;
    }

    private void applyStackAdvisorHostRecommendations(Cluster cluster, Set<String> services, Set<String> componentFilter, Map<String, Map<String, String>> configurations) throws OBDPException {
        StackId stackVersion = cluster.getCurrentStackVersion();
        ArrayList<String> hostNames = new ArrayList<String>();
        Collection<Host> hosts = cluster.getHosts();
        if (hosts != null) {
            for (Host host : hosts) {
                hostNames.add(host.getHostName());
            }
        }
        StackAdvisorRequest request = StackAdvisorRequest.StackAdvisorRequestBuilder.forStack(stackVersion.getStackName(), stackVersion.getStackVersion()).forServices(services).forHosts(hostNames).withComponentHostsMap(cluster.getServiceComponentHostMap(null, services)).ofType(StackAdvisorRequest.StackAdvisorRequestType.HOST_GROUPS).build();
        try {
            Set<RecommendationResponse.HostGroup> hostGroups;
            RecommendationResponse response = this.stackAdvisorHelper.recommend(request);
            RecommendationResponse.Recommendation recommendation = response == null ? null : response.getRecommendations();
            RecommendationResponse.Blueprint blueprint = recommendation == null ? null : recommendation.getBlueprint();
            Set<RecommendationResponse.HostGroup> set = hostGroups = blueprint == null ? null : blueprint.getHostGroups();
            if (hostGroups != null) {
                Set<RecommendationResponse.BindingHostGroup> bindingHostGroups;
                RecommendationResponse.BlueprintClusterBinding blueprintBinding = recommendation.getBlueprintClusterBinding();
                HashMap<String, RecommendationResponse.BindingHostGroup> bindingMap = new HashMap<String, RecommendationResponse.BindingHostGroup>();
                if (blueprintBinding != null && (bindingHostGroups = blueprintBinding.getHostGroups()) != null) {
                    for (RecommendationResponse.BindingHostGroup bindingHostGroup : bindingHostGroups) {
                        bindingMap.put(bindingHostGroup.getName(), bindingHostGroup);
                    }
                }
                Map clusterHostInfoMap = configurations.computeIfAbsent("clusterHostInfo", __ -> new HashMap());
                for (RecommendationResponse.HostGroup hostGroup : hostGroups) {
                    Set<Map<String, String>> hostGroupHosts;
                    RecommendationResponse.BindingHostGroup binding;
                    Set<Map<String, String>> components = hostGroup.getComponents();
                    if (components == null || (binding = (RecommendationResponse.BindingHostGroup)bindingMap.get(hostGroup.getName())) == null || (hostGroupHosts = binding.getHosts()) == null) continue;
                    for (Map<String, String> component : components) {
                        String componentName = component.get("name");
                        if (componentFilter != null && !componentFilter.contains(componentName)) continue;
                        String key = StageUtils.getClusterHostInfoKey(componentName);
                        TreeSet<String> fqdns = new TreeSet<String>();
                        if (!StringUtils.isEmpty((String)((String)clusterHostInfoMap.get(key)))) {
                            fqdns.addAll(Arrays.asList(((String)clusterHostInfoMap.get(key)).split(",")));
                        }
                        for (Map<String, String> hostGroupHost : hostGroupHosts) {
                            String fqdn = hostGroupHost.get("fqdn");
                            if (StringUtils.isEmpty((String)fqdn)) continue;
                            fqdns.add(fqdn);
                        }
                        clusterHostInfoMap.put(key, StringUtils.join(fqdns, (char)','));
                    }
                }
            }
        }
        catch (StackAdvisorException e) {
            LOG.error("Failed to obtain the recommended host groups for the preconfigured components.", (Throwable)e);
            throw new OBDPException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Map<String, Map<String, String>> applyStackAdvisorUpdates(Cluster cluster, Set<String> services, Map<String, Map<String, String>> existingConfigurations, Map<String, Map<String, String>> kerberosConfigurations, Map<String, Set<String>> propertiesToIgnore, Map<String, Set<String>> propertiesToRemove, boolean kerberosEnabled) throws OBDPException {
        ArrayList<String> hostNames = new ArrayList<String>();
        Collection<Host> hosts = cluster.getHosts();
        if (hosts != null) {
            for (Host host : hosts) {
                hostNames.add(host.getHostName());
            }
        }
        if (!hostNames.isEmpty()) {
            HashMap<String, Map<String, Map<String, String>>> requestConfigurations = new HashMap<String, Map<String, Map<String, String>>>();
            if (existingConfigurations != null) {
                for (Map.Entry<String, Map<String, String>> configuration : existingConfigurations.entrySet()) {
                    HashMap<String, Map<String, String>> properties = new HashMap<String, Map<String, String>>();
                    String configType = configuration.getKey();
                    Map<String, String> configurationProperties = configuration.getValue();
                    if (configurationProperties == null) {
                        configurationProperties = Collections.emptyMap();
                    }
                    if ("cluster-env".equals(configType)) {
                        configurationProperties = new HashMap<String, String>(configurationProperties);
                        configurationProperties.put("security_enabled", kerberosEnabled ? "true" : "false");
                    }
                    properties.put("properties", configurationProperties);
                    requestConfigurations.put(configType, properties);
                }
            }
            for (Map.Entry<String, Map<String, String>> configuration : kerberosConfigurations.entrySet()) {
                HashMap<String, String> requestConfigurationProperties;
                String configType = configuration.getKey();
                Map<String, String> configurationProperties = configuration.getValue();
                if (configurationProperties == null || configurationProperties.isEmpty()) continue;
                HashMap requestConfiguration = (HashMap)requestConfigurations.get(configType);
                if (requestConfiguration == null) {
                    requestConfiguration = new HashMap();
                    requestConfigurations.put(configType, requestConfiguration);
                }
                requestConfigurationProperties = (requestConfigurationProperties = (HashMap<String, String>)requestConfiguration.get("properties")) == null ? new HashMap<String, String>() : new HashMap(requestConfigurationProperties);
                requestConfigurationProperties.putAll(configurationProperties);
                requestConfiguration.put("properties", requestConfigurationProperties);
            }
            HashSet<StackId> hashSet = new HashSet<StackId>();
            Map<String, Service> installedServices = cluster.getServices();
            for (String serviceName : services) {
                StackId stackId;
                Service service = installedServices.get(serviceName);
                if (service == null || hashSet.contains(stackId = service.getDesiredStackId())) continue;
                StackAdvisorRequest request = StackAdvisorRequest.StackAdvisorRequestBuilder.forStack(stackId.getStackName(), stackId.getStackVersion()).forServices(services).forHosts(hostNames).withComponentHostsMap(cluster.getServiceComponentHostMap(null, services)).withConfigurations(requestConfigurations).ofType(StackAdvisorRequest.StackAdvisorRequestType.KERBEROS_CONFIGURATIONS).build();
                try {
                    Map<String, RecommendationResponse.BlueprintConfigurations> configurations;
                    RecommendationResponse response = this.stackAdvisorHelper.recommend(request);
                    RecommendationResponse.Recommendation recommendation = response == null ? null : response.getRecommendations();
                    RecommendationResponse.Blueprint blueprint = recommendation == null ? null : recommendation.getBlueprint();
                    Map<String, RecommendationResponse.BlueprintConfigurations> map = configurations = blueprint == null ? null : blueprint.getConfigurations();
                    if (configurations != null) {
                        for (Map.Entry<String, RecommendationResponse.BlueprintConfigurations> configuration : configurations.entrySet()) {
                            String configType = configuration.getKey();
                            Map<String, String> recommendedConfigProperties = configuration.getValue().getProperties();
                            Map<String, ValueAttributesInfo> recommendedConfigPropertyAttributes = configuration.getValue().getPropertyAttributes();
                            Map<String, String> existingConfigProperties = existingConfigurations == null ? null : existingConfigurations.get(configType);
                            Map<String, String> kerberosConfigProperties = kerberosConfigurations.get(configType);
                            Set<String> ignoreProperties = propertiesToIgnore == null ? null : propertiesToIgnore.get(configType);
                            this.addRecommendedPropertiesForConfigType(kerberosConfigurations, configType, recommendedConfigProperties, existingConfigProperties, kerberosConfigProperties, ignoreProperties);
                            if (recommendedConfigPropertyAttributes == null) continue;
                            this.removeRecommendedPropertiesForConfigType(configType, recommendedConfigPropertyAttributes, existingConfigProperties, kerberosConfigurations, ignoreProperties, propertiesToRemove);
                        }
                    }
                }
                catch (Exception e) {
                    throw new OBDPException(e.getMessage(), (Throwable)e);
                }
                hashSet.add(stackId);
            }
        }
        return kerberosConfigurations;
    }

    private void addRecommendedPropertiesForConfigType(Map<String, Map<String, String>> kerberosConfigurations, String configType, Map<String, String> recommendedConfigProperties, Map<String, String> existingConfigProperties, Map<String, String> kerberosConfigProperties, Set<String> ignoreProperties) {
        for (Map.Entry<String, String> property : recommendedConfigProperties.entrySet()) {
            String propertyName = property.getKey();
            if (ignoreProperties != null && ignoreProperties.contains(propertyName)) continue;
            String recommendedValue = property.getValue();
            if (kerberosConfigProperties == null || !kerberosConfigProperties.containsKey(propertyName)) {
                if (existingConfigProperties != null && existingConfigProperties.containsKey(propertyName)) continue;
                LOG.debug("Adding Kerberos configuration based on StackAdvisor recommendation:\n\tConfigType: {}\n\tProperty: {}\n\tValue: {}", new Object[]{configType, propertyName, recommendedValue});
                if (kerberosConfigProperties == null) {
                    kerberosConfigProperties = new HashMap<String, String>();
                    kerberosConfigurations.put(configType, kerberosConfigProperties);
                }
                kerberosConfigProperties.put(propertyName, recommendedValue);
                continue;
            }
            String value = kerberosConfigProperties.get(propertyName);
            if (!(value == null ? recommendedValue != null : !value.equals(recommendedValue))) continue;
            LOG.debug("Updating Kerberos configuration based on StackAdvisor recommendation:\n\tConfigType: {}\n\tProperty: {}\n\tOld Value: {}\n\tNew Value: {}", new Object[]{configType, propertyName, value == null ? "" : value, recommendedValue == null ? "" : recommendedValue});
            kerberosConfigProperties.put(propertyName, recommendedValue);
        }
    }

    private void removeRecommendedPropertiesForConfigType(String configType, Map<String, ValueAttributesInfo> recommendedConfigPropertyAttributes, Map<String, String> existingConfigProperties, Map<String, Map<String, String>> kerberosConfigurations, Set<String> ignoreProperties, Map<String, Set<String>> propertiesToRemove) {
        for (Map.Entry<String, ValueAttributesInfo> property : recommendedConfigPropertyAttributes.entrySet()) {
            String propertyName = property.getKey();
            if (!"true".equalsIgnoreCase(property.getValue().getDelete())) continue;
            Map<String, String> kerberosConfigProperties = kerberosConfigurations.get(configType);
            if (ignoreProperties != null && ignoreProperties.contains(propertyName) || kerberosConfigProperties != null && kerberosConfigProperties.get(propertyName) != null || existingConfigProperties == null || !existingConfigProperties.containsKey(propertyName)) continue;
            LOG.debug("Property to remove from configuration based on StackAdvisor recommendation:\n\tConfigType: {}\n\tProperty: {}", (Object)configType, (Object)propertyName);
            if (propertiesToRemove != null) {
                Set<String> properties = propertiesToRemove.get(configType);
                if (properties == null) {
                    properties = new HashSet<String>();
                    propertiesToRemove.put(configType, properties);
                }
                properties.add(propertyName);
                continue;
            }
            if (kerberosConfigProperties == null) {
                kerberosConfigProperties = new HashMap<String, String>();
                kerberosConfigurations.put(configType, kerberosConfigProperties);
            }
            kerberosConfigProperties.put(propertyName, "");
        }
    }

    @Override
    public boolean ensureHeadlessIdentities(Cluster cluster, Map<String, Map<String, String>> existingConfigurations, Set<String> services) throws KerberosInvalidConfigurationException, OBDPException {
        KerberosDetails kerberosDetails = this.getKerberosDetails(cluster, null);
        if (kerberosDetails.manageIdentities()) {
            KerberosDescriptor kerberosDescriptor = this.getKerberosDescriptor(cluster, false);
            Map<String, String> kerberosDescriptorProperties = kerberosDescriptor.getProperties();
            Map<String, Map<String, String>> configurations = this.addAdditionalConfigurations(cluster, this.deepCopy(existingConfigurations), null, kerberosDescriptorProperties, null);
            Map<String, String> kerberosConfiguration = kerberosDetails.getKerberosEnvProperties();
            KerberosOperationHandler kerberosOperationHandler = this.kerberosOperationHandlerFactory.getKerberosOperationHandler(kerberosDetails.getKdcType());
            PrincipalKeyCredential administratorCredential = this.getKDCAdministratorCredentials(cluster.getClusterName());
            try {
                kerberosOperationHandler.open(administratorCredential, kerberosDetails.getDefaultRealm(), kerberosConfiguration);
            }
            catch (KerberosOperationException e) {
                String message = String.format("Failed to process the identities, could not properly open the KDC operation handler: %s", e.getMessage());
                LOG.error(message);
                throw new OBDPException(message, (Throwable)e);
            }
            HashMap<String, Object> filterContext = new HashMap<String, Object>();
            filterContext.put("configurations", configurations);
            filterContext.put("services", services);
            for (String serviceName : services) {
                Map<String, KerberosComponentDescriptor> componentDescriptors;
                KerberosServiceDescriptor serviceDescriptor = kerberosDescriptor.getService(serviceName);
                if (serviceDescriptor == null || null == (componentDescriptors = serviceDescriptor.getComponents())) continue;
                for (KerberosComponentDescriptor componentDescriptor : componentDescriptors.values()) {
                    if (componentDescriptor == null) continue;
                    List<KerberosIdentityDescriptor> identityDescriptors = serviceDescriptor.getIdentities(true, filterContext);
                    if (identityDescriptors != null) {
                        for (KerberosIdentityDescriptor identityDescriptor : identityDescriptors) {
                            this.createIdentity(identityDescriptor, KerberosPrincipalType.USER, kerberosConfiguration, kerberosOperationHandler, configurations, null);
                        }
                    }
                    if ((identityDescriptors = componentDescriptor.getIdentities(true, filterContext)) == null) continue;
                    for (KerberosIdentityDescriptor identityDescriptor : identityDescriptors) {
                        this.createIdentity(identityDescriptor, KerberosPrincipalType.USER, kerberosConfiguration, kerberosOperationHandler, configurations, null);
                    }
                }
            }
            if (kerberosDetails.createAmbariPrincipal()) {
                this.installAmbariIdentities(kerberosDescriptor, kerberosOperationHandler, kerberosConfiguration, configurations, kerberosDetails);
            }
            try {
                kerberosOperationHandler.close();
            }
            catch (KerberosOperationException kerberosOperationException) {
                // empty catch block
            }
        }
        return true;
    }

    private void installAmbariIdentities(KerberosDescriptor kerberosDescriptor, KerberosOperationHandler kerberosOperationHandler, Map<String, String> kerberosEnvProperties, Map<String, Map<String, String>> configurations, KerberosDetails kerberosDetails) throws OBDPException {
        List<KerberosIdentityDescriptor> ambariIdentities = this.getAmbariServerIdentities(kerberosDescriptor);
        if (!ambariIdentities.isEmpty()) {
            String ambariServerHostname = StageUtils.getHostName();
            for (KerberosIdentityDescriptor identity : ambariIdentities) {
                KerberosPrincipalDescriptor principal;
                if (identity == null || (principal = identity.getPrincipalDescriptor()) == null) continue;
                boolean updateJAASFile = "obdp-server".equals(identity.getName());
                Keytab keytab = this.createIdentity(identity, principal.getType(), kerberosEnvProperties, kerberosOperationHandler, configurations, ambariServerHostname);
                this.installAmbariIdentity(identity, keytab, configurations, ambariServerHostname, kerberosDetails, updateJAASFile);
                if (!updateJAASFile) continue;
                try {
                    KerberosChecker.checkJaasConfiguration();
                }
                catch (OBDPException e) {
                    LOG.error("Error in Ambari JAAS configuration: " + e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installAmbariIdentity(KerberosIdentityDescriptor ambariServerIdentity, Keytab keytab, Map<String, Map<String, String>> configurations, String hostname, KerberosDetails kerberosDetails, boolean updateJAASFile) throws OBDPException {
        KerberosPrincipalDescriptor principalDescriptor = ambariServerIdentity.getPrincipalDescriptor();
        if (principalDescriptor != null) {
            KerberosKeytabDescriptor keytabDescriptor;
            String principal = this.variableReplacementHelper.replaceVariables(principalDescriptor.getValue(), configurations);
            if (!StringUtils.isEmpty((String)hostname)) {
                principal = principal.replace("_HOST", hostname);
            }
            if ((keytabDescriptor = ambariServerIdentity.getKeytabDescriptor()) != null) {
                String destKeytabFilePath = this.variableReplacementHelper.replaceVariables(keytabDescriptor.getFile(), configurations);
                File destKeytabFile = new File(destKeytabFilePath);
                ConfigureOBDPIdentitiesServerAction ConfigureOBDPIdentitiesServerAction2 = (ConfigureOBDPIdentitiesServerAction)this.injector.getInstance(ConfigureOBDPIdentitiesServerAction.class);
                if (keytab != null) {
                    try {
                        KerberosOperationHandler operationHandler = this.kerberosOperationHandlerFactory.getKerberosOperationHandler(kerberosDetails.getKdcType());
                        File tmpKeytabFile = this.createTemporaryFile();
                        try {
                            if (operationHandler != null && operationHandler.createKeytabFile(keytab, tmpKeytabFile)) {
                                String ownerName = this.variableReplacementHelper.replaceVariables(keytabDescriptor.getOwnerName(), configurations);
                                String ownerAccess = keytabDescriptor.getOwnerAccess();
                                String groupName = this.variableReplacementHelper.replaceVariables(keytabDescriptor.getGroupName(), configurations);
                                String groupAccess = keytabDescriptor.getGroupAccess();
                                String componentName = principal.contains("obdp-server") ? "AMBARI_SERVER_SELF" : RootComponent.OBDP_SERVER.name();
                                ResolvedKerberosPrincipal resolvedKerberosPrincipal = new ResolvedKerberosPrincipal(null, hostname, principal, false, null, RootService.OBDP.name(), componentName, destKeytabFilePath);
                                ConfigureOBDPIdentitiesServerAction2.installAmbariServerIdentity(resolvedKerberosPrincipal, tmpKeytabFile.getAbsolutePath(), destKeytabFilePath, ownerName, ownerAccess, groupName, groupAccess, null);
                                LOG.debug("Successfully created keytab file for {} at {}", (Object)principal, (Object)destKeytabFile.getAbsolutePath());
                            }
                            LOG.error("Failed to create keytab file for {} at {}", (Object)principal, (Object)destKeytabFile.getAbsolutePath());
                        }
                        finally {
                            tmpKeytabFile.delete();
                        }
                    }
                    catch (KerberosOperationException e) {
                        throw new OBDPException(String.format("Failed to create keytab file for %s at %s: %s:", principal, destKeytabFile.getAbsolutePath(), e.getLocalizedMessage()), (Throwable)e);
                    }
                } else {
                    LOG.error("No keytab data is available to create the keytab file for {} at {}", (Object)principal, (Object)destKeytabFile.getAbsolutePath());
                }
                if (updateJAASFile) {
                    ConfigureOBDPIdentitiesServerAction2.configureJAAS(principal, destKeytabFile.getAbsolutePath(), null);
                }
            }
        }
    }

    @Override
    public RequestStageContainer createTestIdentity(Cluster cluster, Map<String, String> commandParamsStage, RequestStageContainer requestStageContainer) throws KerberosOperationException, OBDPException {
        return this.handleTestIdentity(cluster, this.getKerberosDetails(cluster, null), commandParamsStage, requestStageContainer, new CreatePrincipalsAndKeytabsHandler(KerberosServerAction.OperationType.DEFAULT, UpdateConfigurationPolicy.NONE, false, false));
    }

    @Override
    public RequestStageContainer deleteTestIdentity(Cluster cluster, Map<String, String> commandParamsStage, RequestStageContainer requestStageContainer) throws KerberosOperationException, OBDPException {
        requestStageContainer = this.handleTestIdentity(cluster, this.getKerberosDetails(cluster, null), commandParamsStage, requestStageContainer, new DeletePrincipalsAndKeytabsHandler());
        return requestStageContainer;
    }

    @Override
    public void validateKDCCredentials(Cluster cluster) throws KerberosMissingAdminCredentialsException, KerberosAdminAuthenticationException, KerberosInvalidConfigurationException, OBDPException {
        this.validateKDCCredentials(null, cluster);
    }

    @Override
    public void setAuthToLocalRules(Cluster cluster, KerberosDescriptor kerberosDescriptor, String realm, Map<String, Set<String>> installedServices, Map<String, Map<String, String>> existingConfigurations, Map<String, Map<String, String>> kerberosConfigurations, boolean includePreconfigureData) throws OBDPException {
        boolean processAuthToLocalRules = true;
        Map<String, String> kerberosEnvProperties = existingConfigurations.get("kerberos-env");
        if (kerberosEnvProperties.containsKey("manage_auth_to_local")) {
            processAuthToLocalRules = Boolean.valueOf(kerberosEnvProperties.get("manage_auth_to_local"));
        }
        if (kerberosDescriptor != null && processAuthToLocalRules) {
            Map<String, KerberosServiceDescriptor> serviceDescriptors;
            HashSet<String> authToLocalPropertiesToSet = new HashSet<String>();
            boolean caseInsensitiveUser = Boolean.valueOf(existingConfigurations.get("kerberos-env").get("case_insensitive_username_rules"));
            String additionalRealms = kerberosDescriptor.getProperty("additional_realms");
            HashMap<String, Object> filterContext = new HashMap<String, Object>();
            filterContext.put("configurations", existingConfigurations);
            filterContext.put("services", installedServices.keySet());
            AuthToLocalBuilder authToLocalBuilder = new AuthToLocalBuilder(realm, additionalRealms, caseInsensitiveUser);
            Map<String, Map<String, String>> replacements = includePreconfigureData ? this.addConfigurationsForPreProcessedServices(this.deepCopy(existingConfigurations), cluster, kerberosDescriptor, false) : existingConfigurations;
            this.addIdentities(authToLocalBuilder, kerberosDescriptor.getIdentities(true, filterContext), null, replacements);
            Set<String> authToLocalProperties = kerberosDescriptor.getAuthToLocalProperties();
            if (authToLocalProperties != null) {
                authToLocalPropertiesToSet.addAll(authToLocalProperties);
            }
            if ((serviceDescriptors = kerberosDescriptor.getServices()) != null) {
                boolean includeAllComponents = Boolean.valueOf(kerberosEnvProperties.get("include_all_components_in_auth_to_local_rules"));
                for (KerberosServiceDescriptor serviceDescriptor : serviceDescriptors.values()) {
                    Map<String, KerberosComponentDescriptor> componentDescriptors;
                    String serviceName = serviceDescriptor.getName();
                    boolean preconfigure = includePreconfigureData && serviceDescriptor.shouldPreconfigure();
                    boolean explicitlyAdded = installedServices.containsKey(serviceName);
                    if (!preconfigure && !explicitlyAdded) continue;
                    LOG.info("Adding identities for service {} to auth to local mapping [{}]", (Object)serviceName, (Object)(explicitlyAdded ? "explicit" : "preconfigured"));
                    this.addIdentities(authToLocalBuilder, serviceDescriptor.getIdentities(true, filterContext), null, replacements);
                    authToLocalProperties = serviceDescriptor.getAuthToLocalProperties();
                    if (authToLocalProperties != null) {
                        authToLocalPropertiesToSet.addAll(authToLocalProperties);
                    }
                    if ((componentDescriptors = serviceDescriptor.getComponents()) == null) continue;
                    Set<String> installedServiceComponents = installedServices.get(serviceName);
                    if (installedServiceComponents == null) {
                        installedServiceComponents = Collections.emptySet();
                    }
                    for (KerberosComponentDescriptor componentDescriptor : componentDescriptors.values()) {
                        String componentName = componentDescriptor.getName();
                        if (!preconfigure && !includeAllComponents && !installedServiceComponents.contains(componentName)) continue;
                        LOG.info("Adding identities for component {} to auth to local mapping", (Object)componentName);
                        this.addIdentities(authToLocalBuilder, componentDescriptor.getIdentities(true, filterContext), null, replacements);
                        authToLocalProperties = componentDescriptor.getAuthToLocalProperties();
                        if (authToLocalProperties == null) continue;
                        authToLocalPropertiesToSet.addAll(authToLocalProperties);
                    }
                }
            }
            if (!authToLocalPropertiesToSet.isEmpty()) {
                for (String authToLocalProperty : authToLocalPropertiesToSet) {
                    Map<String, String> kerberosConfiguration;
                    Map<String, String> existingConfiguration;
                    AuthToLocalBuilder builder;
                    Matcher m = KerberosDescriptor.AUTH_TO_LOCAL_PROPERTY_SPECIFICATION_PATTERN.matcher(authToLocalProperty);
                    if (!m.matches()) continue;
                    try {
                        builder = (AuthToLocalBuilder)authToLocalBuilder.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        LOG.error("Failed to clone the AuthToLocalBuilder: " + e.getLocalizedMessage(), (Throwable)e);
                        throw new OBDPException("Failed to clone the AuthToLocalBuilder: " + e.getLocalizedMessage(), (Throwable)e);
                    }
                    String configType = m.group(1);
                    String propertyName = m.group(2);
                    if (configType == null) {
                        configType = "";
                    }
                    if ((existingConfiguration = existingConfigurations.get(configType)) != null) {
                        builder.addRules(existingConfiguration.get(propertyName));
                    }
                    if ((kerberosConfiguration = kerberosConfigurations.get(configType)) != null) {
                        builder.addRules(kerberosConfiguration.get(propertyName));
                    } else {
                        kerberosConfiguration = new HashMap<String, String>();
                        kerberosConfigurations.put(configType, kerberosConfiguration);
                    }
                    kerberosConfiguration.put(propertyName, builder.generate(AuthToLocalBuilder.ConcatenationType.translate(m.group(3))));
                }
            }
        }
    }

    @Override
    public List<ServiceComponentHost> getServiceComponentHostsToProcess(Cluster cluster, final KerberosDescriptor kerberosDescriptor, final Map<String, ? extends Collection<String>> serviceComponentFilter, final Collection<String> hostFilter) throws OBDPException {
        return this.getServiceComponentHosts(cluster, new KerberosHelper.Command<Boolean, ServiceComponentHost>(){

            @Override
            public Boolean invoke(ServiceComponentHost sch) throws OBDPException {
                if (sch != null && (hostFilter == null || hostFilter.contains("*") || hostFilter.contains(sch.getHostName()))) {
                    KerberosServiceDescriptor serviceDescriptor;
                    String serviceName = sch.getServiceName();
                    if ((serviceComponentFilter == null || serviceComponentFilter.containsKey("*") || serviceComponentFilter.containsKey(serviceName)) && (serviceDescriptor = kerberosDescriptor.getService(serviceName)) != null) {
                        Collection componentFilter = serviceComponentFilter == null || serviceComponentFilter.containsKey("*") ? null : (Collection)serviceComponentFilter.get(serviceName);
                        return componentFilter == null || componentFilter.contains("*") || componentFilter.contains(sch.getServiceComponentName());
                    }
                }
                return false;
            }
        });
    }

    private List<ServiceComponentHost> getServiceComponentHosts(Cluster cluster, KerberosHelper.Command<Boolean, ServiceComponentHost> shouldIncludeCommand) throws OBDPException {
        ArrayList<ServiceComponentHost> serviceComponentHostsToProcess = new ArrayList<ServiceComponentHost>();
        Collection<Host> hosts = cluster.getHosts();
        if (hosts != null && !hosts.isEmpty()) {
            for (Host host : hosts) {
                String hostname = host.getHostName();
                List<ServiceComponentHost> serviceComponentHosts = cluster.getServiceComponentHosts(hostname);
                if (serviceComponentHosts == null || serviceComponentHosts.isEmpty()) continue;
                for (ServiceComponentHost sch : serviceComponentHosts) {
                    if (shouldIncludeCommand != null && !shouldIncludeCommand.invoke(sch).booleanValue()) continue;
                    serviceComponentHostsToProcess.add(sch);
                }
            }
        }
        return serviceComponentHostsToProcess;
    }

    @Override
    public Set<String> getHostsWithValidKerberosClient(Cluster cluster) throws OBDPException {
        HashSet<String> hostsWithValidKerberosClient = new HashSet<String>();
        List<ServiceComponentHost> schKerberosClients = cluster.getServiceComponentHosts(Service.Type.KERBEROS.name(), Role.KERBEROS_CLIENT.name());
        if (schKerberosClients != null) {
            for (ServiceComponentHost sch : schKerberosClients) {
                if (sch.getState() != State.INSTALLED) continue;
                hostsWithValidKerberosClient.add(sch.getHostName());
            }
        }
        return hostsWithValidKerberosClient;
    }

    @Override
    public KerberosDescriptor getKerberosDescriptor(Cluster cluster, boolean includePreconfigureData, @Nullable KerberosDescriptor userDescriptor, @Nullable Map<String, DesiredConfig> desiredConfigs) throws OBDPException {
        return this.getKerberosDescriptor(KerberosHelper.KerberosDescriptorType.COMPOSITE, cluster, false, null, includePreconfigureData, userDescriptor, desiredConfigs);
    }

    @Override
    public KerberosDescriptor getKerberosDescriptor(Cluster cluster, boolean includePreconfigureData) throws OBDPException {
        return this.getKerberosDescriptor(KerberosHelper.KerberosDescriptorType.COMPOSITE, cluster, false, null, includePreconfigureData, null, null);
    }

    @Override
    public KerberosDescriptor getKerberosDescriptor(KerberosHelper.KerberosDescriptorType kerberosDescriptorType, Cluster cluster, boolean evaluateWhenClauses, Collection<String> additionalServices, boolean includePreconfigureData, @Nullable KerberosDescriptor userDescriptor, @Nullable Map<String, DesiredConfig> desiredConfigs) throws OBDPException {
        StackId stackId = cluster.getDesiredStackVersion();
        KerberosDescriptor kerberosDescriptor = this.getKerberosDescriptor(kerberosDescriptorType, cluster, stackId, includePreconfigureData, userDescriptor);
        if (evaluateWhenClauses) {
            HashSet<String> services = new HashSet<String>(cluster.getServices().keySet());
            if (additionalServices != null) {
                services.addAll(additionalServices);
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("configurations", this.calculateConfigurations(cluster, null, kerberosDescriptor, false, false, desiredConfigs));
            context.put("services", services);
            Map<String, Set<String>> identitiesToRemove = this.processWhenClauses("", kerberosDescriptor, context, new HashMap<String, Set<String>>());
            for (Map.Entry<String, Set<String>> identity : identitiesToRemove.entrySet()) {
                String[] path = identity.getKey().split("/");
                AbstractKerberosDescriptorContainer container = null;
                for (String name : path) {
                    if (container == null) {
                        container = kerberosDescriptor;
                        continue;
                    }
                    if ((container = container.getChildContainer(name)) == null) break;
                }
                if (container == null) continue;
                for (String identityName : identity.getValue()) {
                    container.removeIdentity(identityName);
                }
            }
        }
        return kerberosDescriptor;
    }

    @Override
    public KerberosDescriptor getKerberosDescriptor(KerberosHelper.KerberosDescriptorType kerberosDescriptorType, Cluster cluster, StackId stackId, boolean includePreconfigureData, @Nullable KerberosDescriptor userDescriptor) throws OBDPException {
        KerberosDescriptor stackDescriptor;
        KerberosDescriptor kerberosDescriptor = stackDescriptor = kerberosDescriptorType == KerberosHelper.KerberosDescriptorType.STACK || kerberosDescriptorType == KerberosHelper.KerberosDescriptorType.COMPOSITE ? this.getKerberosDescriptorFromStack(stackId, includePreconfigureData) : null;
        KerberosDescriptor finalUserDescriptor = kerberosDescriptorType == KerberosHelper.KerberosDescriptorType.USER || kerberosDescriptorType == KerberosHelper.KerberosDescriptorType.COMPOSITE ? (userDescriptor == null ? this.getKerberosDescriptorUpdates(cluster) : userDescriptor) : null;
        return this.combineKerberosDescriptors(stackDescriptor, finalUserDescriptor);
    }

    @Override
    public Map<String, Map<String, String>> mergeConfigurations(Map<String, Map<String, String>> configurations, Map<String, KerberosConfigurationDescriptor> updates, Map<String, Map<String, String>> replacements, Set<String> configurationTypeFilter) throws OBDPException {
        if (updates != null && !updates.isEmpty()) {
            if (configurations == null) {
                configurations = new HashMap<String, Map<String, String>>();
            }
            for (Map.Entry<String, KerberosConfigurationDescriptor> entry : updates.entrySet()) {
                KerberosConfigurationDescriptor configurationDescriptor;
                String type = entry.getKey();
                if (configurationTypeFilter != null && !configurationTypeFilter.contains(type) || (configurationDescriptor = entry.getValue()) == null) continue;
                Map<String, String> updatedProperties = configurationDescriptor.getProperties();
                this.mergeConfigurations(configurations, type, updatedProperties, replacements);
            }
        }
        return configurations;
    }

    @Override
    public Map<String, Map<String, String>> processPreconfiguredServiceConfigurations(Map<String, Map<String, String>> configurations, Map<String, Map<String, String>> replacements, Cluster cluster, KerberosDescriptor kerberosDescriptor) throws OBDPException {
        Map<String, KerberosServiceDescriptor> serviceDescriptors;
        if (kerberosDescriptor == null) {
            kerberosDescriptor = this.getKerberosDescriptor(cluster, true);
        }
        if ((serviceDescriptors = kerberosDescriptor.getServices()) != null) {
            if (configurations == null) {
                configurations = new HashMap<String, Map<String, String>>();
            }
            Map<String, Map<String, String>> replacementsWithDefaults = this.addConfigurationsForPreProcessedServices(this.deepCopy(replacements), cluster, kerberosDescriptor, true);
            Map<String, Service> existingServices = cluster.getServices();
            for (KerberosServiceDescriptor serviceDescriptor : serviceDescriptors.values()) {
                String serviceName = serviceDescriptor.getName();
                boolean shouldPreconfigure = serviceDescriptor.shouldPreconfigure();
                if (existingServices.containsKey(serviceName) || !shouldPreconfigure) continue;
                configurations = this.mergeConfigurations(configurations, serviceDescriptor.getConfigurations(), replacementsWithDefaults, replacements.keySet());
                Map<String, KerberosComponentDescriptor> componentDescriptors = serviceDescriptor.getComponents();
                if (componentDescriptors == null) continue;
                for (KerberosComponentDescriptor componentDescriptor : componentDescriptors.values()) {
                    configurations = this.mergeConfigurations(configurations, componentDescriptor.getConfigurations(), replacementsWithDefaults, replacements.keySet());
                }
            }
        }
        return configurations;
    }

    @Override
    public int addIdentities(KerberosIdentityDataFileWriter kerberosIdentityDataFileWriter, Collection<KerberosIdentityDescriptor> identities, Collection<String> identityFilter, String hostname, Long hostId, String serviceName, String componentName, Map<String, Map<String, String>> kerberosConfigurations, Map<String, Map<String, String>> configurations, Map<String, ResolvedKerberosKeytab> resolvedKeytabs, String realm) throws IOException {
        int identitiesAdded = 0;
        if (identities != null) {
            for (KerberosIdentityDescriptor identity : identities) {
                if (identityFilter != null && !identityFilter.contains(identity.getPath())) continue;
                KerberosPrincipalDescriptor principalDescriptor = identity.getPrincipalDescriptor();
                String principal = null;
                String principalType = null;
                String principalConfiguration = null;
                if (principalDescriptor != null) {
                    principal = this.variableReplacementHelper.replaceVariables(principalDescriptor.getValue(), configurations);
                    principalType = KerberosPrincipalType.translate(principalDescriptor.getType());
                    principalConfiguration = this.variableReplacementHelper.replaceVariables(principalDescriptor.getConfiguration(), configurations);
                }
                if (principal == null) continue;
                KerberosKeytabDescriptor keytabDescriptor = identity.getKeytabDescriptor();
                String keytabFilePath = null;
                String keytabFileOwnerName = null;
                String keytabFileOwnerAccess = null;
                String keytabFileGroupName = null;
                String keytabFileGroupAccess = null;
                String keytabFileConfiguration = null;
                if (keytabDescriptor != null) {
                    keytabFilePath = this.variableReplacementHelper.replaceVariables(keytabDescriptor.getFile(), configurations);
                    keytabFileOwnerName = this.variableReplacementHelper.replaceVariables(keytabDescriptor.getOwnerName(), configurations);
                    keytabFileOwnerAccess = this.variableReplacementHelper.replaceVariables(keytabDescriptor.getOwnerAccess(), configurations);
                    keytabFileGroupName = this.variableReplacementHelper.replaceVariables(keytabDescriptor.getGroupName(), configurations);
                    keytabFileGroupAccess = this.variableReplacementHelper.replaceVariables(keytabDescriptor.getGroupAccess(), configurations);
                    keytabFileConfiguration = this.variableReplacementHelper.replaceVariables(keytabDescriptor.getConfiguration(), configurations);
                    if (keytabFileOwnerName == null || keytabFileGroupName == null) {
                        LOG.warn("Missing owner ({}) or group name ({}) of kerberos descriptor {}", new Object[]{keytabFileOwnerName, keytabFileGroupName, keytabDescriptor.getName()});
                    }
                } else {
                    throw new OBDPException("Missing keytab descriptor for " + identity.getName());
                }
                String evaluatedPrincipal = principal.replace("_HOST", hostname).replace("_REALM", realm);
                ResolvedKerberosKeytab resolvedKeytab = new ResolvedKerberosKeytab(keytabFilePath, keytabFileOwnerName, keytabFileOwnerAccess, keytabFileGroupName, keytabFileGroupAccess, Sets.newHashSet((Object[])new ResolvedKerberosPrincipal[]{new ResolvedKerberosPrincipal(hostId, hostname, evaluatedPrincipal, "service".equalsIgnoreCase(principalType), null, serviceName, componentName, keytabFilePath)}), serviceName.equalsIgnoreCase(RootService.OBDP.name()), componentName.equalsIgnoreCase("AMBARI_SERVER_SELF"));
                if (resolvedKeytabs.containsKey(keytabFilePath)) {
                    ResolvedKerberosKeytab sameKeytab = resolvedKeytabs.get(keytabFilePath);
                    boolean differentOwners = false;
                    String warnTemplate = "Keytab '{}' on host '{}' has different {}, originally set to '{}' and '{}:{}' has '{}', using '{}'";
                    if (!StringUtils.equals((String)resolvedKeytab.getOwnerName(), (String)sameKeytab.getOwnerName())) {
                        LOG.warn(warnTemplate, new Object[]{keytabFilePath, hostname, "owners", sameKeytab.getOwnerName(), serviceName, componentName, resolvedKeytab.getOwnerName(), sameKeytab.getOwnerName()});
                        differentOwners = true;
                    }
                    if (!StringUtils.equals((String)resolvedKeytab.getOwnerAccess(), (String)sameKeytab.getOwnerAccess())) {
                        LOG.warn(warnTemplate, new Object[]{keytabFilePath, hostname, "owner access", sameKeytab.getOwnerAccess(), serviceName, componentName, resolvedKeytab.getOwnerAccess(), sameKeytab.getOwnerAccess()});
                    }
                    if (!StringUtils.equals((String)resolvedKeytab.getGroupName(), (String)sameKeytab.getGroupName())) {
                        if (differentOwners) {
                            LOG.error(warnTemplate, new Object[]{keytabFilePath, hostname, "groups", sameKeytab.getGroupName(), serviceName, componentName, resolvedKeytab.getGroupName(), sameKeytab.getGroupName()});
                        } else {
                            LOG.warn(warnTemplate, new Object[]{keytabFilePath, hostname, "groups", sameKeytab.getGroupName(), serviceName, componentName, resolvedKeytab.getGroupName(), sameKeytab.getGroupName()});
                        }
                    }
                    if (!StringUtils.equals((String)resolvedKeytab.getGroupAccess(), (String)sameKeytab.getGroupAccess())) {
                        if (differentOwners) {
                            if (!sameKeytab.getGroupAccess().contains("r")) {
                                LOG.error("Keytab '{}' on host '{}' referenced by multiple identities which have different owners,but 'r' attribute missing for group. Make sure all users (that need this keytab) are in '{}' +group and keytab can be read by this group", new Object[]{keytabFilePath, hostname, sameKeytab.getGroupName()});
                            }
                            LOG.error(warnTemplate, new Object[]{keytabFilePath, hostname, "group access", sameKeytab.getGroupAccess(), serviceName, componentName, resolvedKeytab.getGroupAccess(), sameKeytab.getGroupAccess()});
                        } else {
                            LOG.warn(warnTemplate, new Object[]{keytabFilePath, hostname, "group access", sameKeytab.getGroupAccess(), serviceName, componentName, resolvedKeytab.getGroupAccess(), sameKeytab.getGroupAccess()});
                        }
                    }
                    sameKeytab.mergePrincipals(resolvedKeytab);
                    if (sameKeytab.isMustWriteAmbariJaasFile() || resolvedKeytab.isMustWriteAmbariJaasFile()) {
                        sameKeytab.setMustWriteAmbariJaasFile(true);
                    }
                    if (sameKeytab.isAmbariServerKeytab() || resolvedKeytab.isAmbariServerKeytab()) {
                        sameKeytab.setAmbariServerKeytab(true);
                    }
                } else {
                    resolvedKeytabs.put(keytabFilePath, resolvedKeytab);
                    LOG.info("Keytab {} owner:'{}:{}', group:'{}:{}' is defined", new Object[]{keytabFilePath, keytabFileOwnerName, keytabFileOwnerAccess, keytabFileGroupName, keytabFileGroupAccess});
                }
                if (kerberosIdentityDataFileWriter != null) {
                    kerberosIdentityDataFileWriter.writeRecord(hostname, serviceName, componentName, evaluatedPrincipal, principalType, keytabFilePath, keytabFileOwnerName, keytabFileOwnerAccess, keytabFileGroupName, keytabFileGroupAccess, "true");
                }
                this.mergeConfiguration(kerberosConfigurations, principalConfiguration, principal, null);
                this.mergeConfiguration(kerberosConfigurations, keytabFileConfiguration, keytabFilePath, null);
                ++identitiesAdded;
            }
        }
        return identitiesAdded;
    }

    @Override
    public Map<String, Map<String, String>> calculateConfigurations(Cluster cluster, String hostname, KerberosDescriptor kerberosDescriptor, boolean includePreconfigureData, boolean calculateClusterHostInfo, Map<String, String> componentHosts, @Nullable Map<String, DesiredConfig> desiredConfigs) throws OBDPException {
        return this.calculateConfigurations(cluster, hostname, kerberosDescriptor, null, includePreconfigureData, calculateClusterHostInfo, componentHosts, desiredConfigs);
    }

    @Override
    public Map<String, Map<String, String>> calculateConfigurations(Cluster cluster, String hostname, KerberosDescriptor kerberosDescriptor, KerberosDescriptor userDescriptor, boolean includePreconfigureData, boolean calculateClusterHostInfo, Map<String, String> componentHosts, @Nullable Map<String, DesiredConfig> desiredConfigs) throws OBDPException {
        Map<String, Map<String, String>> calculatedConfigurations = this.addAdditionalConfigurations(cluster, this.configHelper.calculateExistingConfigurations(this.ambariManagementController, cluster, hostname, desiredConfigs), hostname, kerberosDescriptor == null ? null : kerberosDescriptor.getProperties(), userDescriptor, componentHosts, desiredConfigs);
        if (includePreconfigureData) {
            calculatedConfigurations = this.addConfigurationsForPreProcessedServices(calculatedConfigurations, cluster, kerberosDescriptor, calculateClusterHostInfo);
        }
        return calculatedConfigurations;
    }

    @Override
    public Map<String, Map<String, String>> calculateConfigurations(Cluster cluster, String hostname, KerberosDescriptor kerberosDescriptor, boolean includePreconfigureData, boolean calculateClusterHostInfo, @Nullable Map<String, DesiredConfig> desiredConfigs) throws OBDPException {
        return this.calculateConfigurations(cluster, hostname, kerberosDescriptor, includePreconfigureData, calculateClusterHostInfo, null, desiredConfigs);
    }

    private Map<String, String> principalNames(Cluster cluster, Map<String, Map<String, String>> configuration, @Nullable KerberosDescriptor userDescriptor, @Nullable Map<String, DesiredConfig> desiredConfigs) throws OBDPException {
        HashMap<String, String> result = new HashMap<String, String>();
        this.getKerberosDescriptor(cluster, false, userDescriptor, desiredConfigs).principals().forEach((key, value) -> result.put((String)key, this.variableReplacementHelper.replaceVariables((String)value, configuration)));
        return result;
    }

    @Override
    public Map<String, Collection<KerberosIdentityDescriptor>> getActiveIdentities(String clusterName, String hostName, String serviceName, String componentName, boolean replaceHostNames, Map<String, Map<String, Map<String, String>>> hostConfigurations, KerberosDescriptor kerberosDescriptor, @Nullable Map<String, DesiredConfig> desiredConfigs) throws OBDPException {
        Collection<String> hosts;
        if (clusterName == null || clusterName.isEmpty()) {
            throw new IllegalArgumentException("Invalid argument, cluster name is required");
        }
        Cluster cluster = this.clusters.getCluster(clusterName);
        if (cluster == null) {
            throw new OBDPException(String.format("The cluster object for the cluster name %s is not available", clusterName));
        }
        HashMap<String, Collection<KerberosIdentityDescriptor>> activeIdentities = new HashMap<String, Collection<KerberosIdentityDescriptor>>();
        Config kerberosEnvConfig = cluster.getDesiredConfigByType("kerberos-env", desiredConfigs);
        if (kerberosEnvConfig == null) {
            LOG.debug("Calculating the active identities for {} is being skipped since the kerberos-env configuration is not available", new Object[]{clusterName, cluster.getSecurityType().name(), SecurityType.KERBEROS.name()});
            return activeIdentities;
        }
        String ambariServerHostname = StageUtils.getHostName();
        boolean ambariServerHostnameIsForced = false;
        if (hostName == null) {
            Map<String, Host> hostMap = this.clusters.getHostsForCluster(clusterName);
            Collection<Object> collection = hosts = hostMap == null ? Collections.emptySet() : hostMap.keySet();
            if (!hosts.contains(ambariServerHostname)) {
                ArrayList<String> extendedHosts = new ArrayList<String>(hosts.size() + 1);
                extendedHosts.addAll(hosts);
                extendedHosts.add(ambariServerHostname);
                hosts = extendedHosts;
                ambariServerHostnameIsForced = true;
            }
        } else {
            hosts = Collections.singleton(hostName);
        }
        if (null == hostConfigurations) {
            hostConfigurations = new HashMap<String, Map<String, Map<String, String>>>();
        }
        if (hosts.isEmpty()) {
            return activeIdentities;
        }
        if (null == kerberosDescriptor) {
            kerberosDescriptor = this.getKerberosDescriptor(cluster, false);
        }
        if (kerberosDescriptor == null) {
            return activeIdentities;
        }
        Set<String> existingServices = cluster.getServices().keySet();
        for (String host : hosts) {
            List<KerberosIdentityDescriptor> ambariIdentities;
            Map<String, Map<String, String>> configurations = hostConfigurations.get(host);
            if (configurations == null) {
                configurations = this.calculateConfigurations(cluster, (String)(ambariServerHostnameIsForced && ambariServerHostname.equals(host) ? null : host), kerberosDescriptor, false, false, desiredConfigs);
                hostConfigurations.put(host, configurations);
            }
            HashMap<String, Object> filterContext = new HashMap<String, Object>();
            filterContext.put("configurations", configurations);
            filterContext.put("services", existingServices);
            HashMap<String, KerberosIdentityDescriptor> hostActiveIdentities = new HashMap<String, KerberosIdentityDescriptor>();
            List<KerberosIdentityDescriptor> identities = this.getActiveIdentities(cluster, host, serviceName, componentName, kerberosDescriptor, filterContext);
            if (host.equals(ambariServerHostname) && this.createAmbariIdentities(kerberosEnvConfig.getProperties()) && (ambariIdentities = this.getAmbariServerIdentities(kerberosDescriptor)) != null) {
                identities.addAll(ambariIdentities);
            }
            if (!identities.isEmpty()) {
                for (KerberosIdentityDescriptor identity : identities) {
                    String uniqueKey;
                    KerberosPrincipalDescriptor principalDescriptor = identity.getPrincipalDescriptor();
                    String principal = null;
                    if (principalDescriptor != null) {
                        principal = this.variableReplacementHelper.replaceVariables(principalDescriptor.getValue(), configurations);
                    }
                    if (principal == null) continue;
                    KerberosKeytabDescriptor keytabDescriptor = identity.getKeytabDescriptor();
                    String keytabFile = null;
                    if (keytabDescriptor != null) {
                        keytabFile = this.variableReplacementHelper.replaceVariables(keytabDescriptor.getFile(), configurations);
                    }
                    if (replaceHostNames) {
                        principal = principal.replace("_HOST", host);
                    }
                    if (hostActiveIdentities.containsKey(uniqueKey = String.format("%s|%s", principal, keytabFile == null ? "" : keytabFile)) && (!StringUtils.isNotBlank((String)((KerberosIdentityDescriptor)hostActiveIdentities.get(uniqueKey)).getReference()) || !StringUtils.isBlank((String)identity.getReference()))) continue;
                    KerberosPrincipalType principalType = principalDescriptor.getType();
                    if (principalType == null) {
                        principalType = KerberosPrincipalType.SERVICE;
                    }
                    KerberosPrincipalDescriptor resolvedPrincipalDescriptor = new KerberosPrincipalDescriptor(principal, principalType, this.variableReplacementHelper.replaceVariables(principalDescriptor.getConfiguration(), configurations), this.variableReplacementHelper.replaceVariables(principalDescriptor.getLocalUsername(), configurations));
                    KerberosKeytabDescriptor resolvedKeytabDescriptor = keytabFile == null ? null : new KerberosKeytabDescriptor(keytabFile, this.variableReplacementHelper.replaceVariables(keytabDescriptor.getOwnerName(), configurations), this.variableReplacementHelper.replaceVariables(keytabDescriptor.getOwnerAccess(), configurations), this.variableReplacementHelper.replaceVariables(keytabDescriptor.getGroupName(), configurations), this.variableReplacementHelper.replaceVariables(keytabDescriptor.getGroupAccess(), configurations), this.variableReplacementHelper.replaceVariables(keytabDescriptor.getConfiguration(), configurations), keytabDescriptor.isCachable());
                    hostActiveIdentities.put(uniqueKey, new KerberosIdentityDescriptor(identity.getName(), identity.getReference(), resolvedPrincipalDescriptor, resolvedKeytabDescriptor, identity.getWhen()));
                }
            }
            activeIdentities.put(host, hostActiveIdentities.values());
        }
        return activeIdentities;
    }

    @Override
    public List<KerberosIdentityDescriptor> getAmbariServerIdentities(KerberosDescriptor kerberosDescriptor) throws OBDPException {
        ArrayList<KerberosIdentityDescriptor> ambariIdentities = new ArrayList<KerberosIdentityDescriptor>();
        KerberosServiceDescriptor ambariKerberosDescriptor = kerberosDescriptor.getService(RootService.OBDP.name());
        if (ambariKerberosDescriptor != null) {
            List<KerberosIdentityDescriptor> componentIdentities;
            List<KerberosIdentityDescriptor> serviceIdentities = ambariKerberosDescriptor.getIdentities(true, null);
            KerberosComponentDescriptor ambariServerKerberosComponentDescriptor = ambariKerberosDescriptor.getComponent(RootComponent.OBDP_SERVER.name());
            if (serviceIdentities != null) {
                ambariIdentities.addAll(serviceIdentities);
            }
            if (ambariServerKerberosComponentDescriptor != null && (componentIdentities = ambariServerKerberosComponentDescriptor.getIdentities(true, null)) != null) {
                ambariIdentities.addAll(componentIdentities);
            }
        }
        return ambariIdentities;
    }

    @Override
    public boolean createAmbariIdentities(Map<String, String> kerberosEnvProperties) {
        return kerberosEnvProperties == null || !"false".equalsIgnoreCase(kerberosEnvProperties.get("create_obdp_principal"));
    }

    @Override
    public PrincipalKeyCredential getKDCAdministratorCredentials(String clusterName) throws OBDPException {
        Credential credentials = this.credentialStoreService.getCredential(clusterName, "kdc.admin.credential");
        if (credentials instanceof PrincipalKeyCredential) {
            return (PrincipalKeyCredential)credentials;
        }
        return null;
    }

    @Override
    @Transactional
    public void createResolvedKeytab(ResolvedKerberosKeytab resolvedKerberosKeytab, @Nullable List<KerberosKeytabPrincipalEntity> keytabList) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        KerberosKeytabEntity kke = this.kerberosKeytabDAO.findOrCreate(resolvedKerberosKeytab);
        resolvedKerberosKeytab.getPrincipals().forEach(principal -> {
            KerberosPrincipalEntity kpe = this.kerberosPrincipalDAO.find(principal.getPrincipal());
            if (kpe == null) {
                kpe = this.kerberosPrincipalDAO.create(principal.getPrincipal(), principal.isService());
            }
            Boolean[] mergeBidirectionalAssociatedEntities = new Boolean[]{false};
            KerberosPrincipalEntity finalKpe = kpe;
            principal.getServiceMapping().forEach((serviceName, value) -> {
                HostEntity hostEntity = principal.getHostId() != null ? this.hostDAO.findById(principal.getHostId()) : null;
                KerberosKeytabPrincipalDAO.KeytabPrincipalFindOrCreateResult result = this.kerberosKeytabPrincipalDAO.findOrCreate(kke, hostEntity, finalKpe, keytabList);
                KerberosKeytabPrincipalEntity kkp = result.kkp;
                if (keytabList != null && result.created) {
                    keytabList.add(result.kkp);
                }
                mergeBidirectionalAssociatedEntities[0] = mergeBidirectionalAssociatedEntities[0] != false || result.created;
                if (kkp.putServiceMapping((String)serviceName, (String)value)) {
                    this.kerberosKeytabPrincipalDAO.merge(kkp);
                }
            });
            if (mergeBidirectionalAssociatedEntities[0].booleanValue()) {
                this.kerberosKeytabDAO.merge(kke);
                this.kerberosPrincipalDAO.merge(kpe);
            }
        });
        LOG.info("Resolving this keytab and all associated principals took {} ms ", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    @Override
    public void removeStaleKeytabs(Collection<ResolvedKerberosKeytab> expectedKeytabs) {
    }

    @Override
    public Map<String, Set<String>> translateConfigurationSpecifications(Collection<String> configurationSpecifications) {
        HashMap<String, HashSet<String>> translation = null;
        if (configurationSpecifications != null) {
            translation = new HashMap<String, HashSet<String>>();
            for (String configurationSpecification : configurationSpecifications) {
                HashSet<String> propertyNames;
                Matcher m = KerberosDescriptor.AUTH_TO_LOCAL_PROPERTY_SPECIFICATION_PATTERN.matcher(configurationSpecification);
                if (!m.matches()) continue;
                String configType = m.group(1);
                String propertyName = m.group(2);
                if (configType == null) {
                    configType = "";
                }
                if ((propertyNames = (HashSet<String>)translation.get(configType)) == null) {
                    propertyNames = new HashSet<String>();
                    translation.put(configType, propertyNames);
                }
                propertyNames.add(propertyName);
            }
        }
        return translation;
    }

    private Keytab createIdentity(KerberosIdentityDescriptor identityDescriptor, KerberosPrincipalType expectedType, Map<String, String> kerberosEnvProperties, KerberosOperationHandler kerberosOperationHandler, Map<String, Map<String, String>> configurations, String hostname) throws OBDPException {
        KerberosPrincipalDescriptor principalDescriptor;
        Keytab keytab = null;
        if (identityDescriptor != null && (principalDescriptor = identityDescriptor.getPrincipalDescriptor()) != null && expectedType == principalDescriptor.getType()) {
            String principal = this.variableReplacementHelper.replaceVariables(principalDescriptor.getValue(), configurations);
            if (!StringUtils.isEmpty((String)hostname)) {
                principal = principal.replace("_HOST", hostname);
            }
            if (!this.kerberosPrincipalDAO.exists(principal)) {
                CreatePrincipalsServerAction.CreatePrincipalResult result = ((CreatePrincipalsServerAction)this.injector.getInstance(CreatePrincipalsServerAction.class)).createPrincipal(principal, KerberosPrincipalType.SERVICE.equals((Object)expectedType), kerberosEnvProperties, kerberosOperationHandler, false, null);
                if (result == null) {
                    throw new OBDPException("Failed to create the account for " + principal);
                }
                KerberosKeytabDescriptor keytabDescriptor = identityDescriptor.getKeytabDescriptor();
                if (keytabDescriptor != null) {
                    KerberosPrincipalEntity principalEntity = this.kerberosPrincipalDAO.find(principal);
                    keytab = ((CreateKeytabFilesServerAction)this.injector.getInstance(CreateKeytabFilesServerAction.class)).createKeytab(principal, principalEntity, result.getPassword(), result.getKeyNumber(), kerberosOperationHandler, true, true, null);
                    if (keytab == null) {
                        throw new OBDPException("Failed to create the keytab for " + principal);
                    }
                }
            }
        }
        return keytab;
    }

    private void validateKDCCredentials(KerberosDetails kerberosDetails, Cluster cluster) throws KerberosMissingAdminCredentialsException, KerberosAdminAuthenticationException, KerberosInvalidConfigurationException, OBDPException {
        if (kerberosDetails == null) {
            kerberosDetails = this.getKerberosDetails(cluster, null);
        }
        if (kerberosDetails.manageIdentities()) {
            PrincipalKeyCredential credentials = this.getKDCAdministratorCredentials(cluster.getClusterName());
            if (credentials == null) {
                throw new KerberosMissingAdminCredentialsException();
            }
            KerberosOperationHandler operationHandler = this.kerberosOperationHandlerFactory.getKerberosOperationHandler(kerberosDetails.getKdcType());
            if (operationHandler == null) {
                throw new OBDPException("Failed to get an appropriate Kerberos operation handler.");
            }
            boolean missingCredentials = false;
            try {
                operationHandler.open(credentials, kerberosDetails.getDefaultRealm(), kerberosDetails.getKerberosEnvProperties());
                missingCredentials = !operationHandler.testAdministratorCredentials();
            }
            catch (KerberosAdminAuthenticationException e) {
                throw new KerberosAdminAuthenticationException("Invalid KDC administrator credentials.\nThe KDC administrator credentials must be set as a persisted or temporary credential resource.This may be done by issuing a POST (or PUT for updating) to the /api/v1/clusters/:clusterName/credentials/kdc.admin.credential API entry point with the following payload:\n{\n  \"Credential\" : {\n    \"principal\" : \"(PRINCIPAL)\", \"key\" : \"(PASSWORD)\", \"type\" : \"(persisted|temporary)\"}\n  }\n}", e);
            }
            catch (KerberosKDCConnectionException e) {
                throw new KerberosInvalidConfigurationException("Failed to connect to KDC - " + e.getMessage() + "\nUpdate the KDC settings in krb5-conf and kerberos-env configurations to correct this issue.", e);
            }
            catch (KerberosKDCSSLConnectionException e) {
                throw new KerberosInvalidConfigurationException("Failed to connect to KDC - " + e.getMessage() + "\nMake sure the server's SSL certificate or CA certificates have been imported into Ambari's truststore.", e);
            }
            catch (KerberosRealmException e) {
                throw new KerberosInvalidConfigurationException("Failed to find a KDC for the specified realm - " + e.getMessage() + "\nUpdate the KDC settings in krb5-conf and kerberos-env configurations to correct this issue.", e);
            }
            catch (KerberosLDAPContainerException e) {
                throw new KerberosInvalidConfigurationException("The principal container was not specified\nSet the 'container_dn' value in the kerberos-env configuration to correct this issue.", e);
            }
            catch (KerberosOperationException e) {
                throw new OBDPException(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    operationHandler.close();
                }
                catch (KerberosOperationException kerberosOperationException) {}
            }
            if (missingCredentials) {
                throw new KerberosMissingAdminCredentialsException();
            }
        }
    }

    @Transactional
    RequestStageContainer handle(Cluster cluster, KerberosDetails kerberosDetails, Map<String, ? extends Collection<String>> serviceComponentFilter, Set<String> hostFilter, Collection<String> identityFilter, Set<String> hostsToForceKerberosOperations, RequestStageContainer requestStageContainer, Handler handler) throws OBDPException, KerberosOperationException {
        KerberosDescriptor kerberosDescriptor = this.getKerberosDescriptor(cluster, false);
        List<ServiceComponentHost> schToProcess = this.getServiceComponentHostsToProcess(cluster, kerberosDescriptor, serviceComponentFilter, hostFilter);
        Set<String> hostsWithValidKerberosClient = null;
        File dataDirectory = null;
        if (!schToProcess.isEmpty()) {
            this.validateKDCCredentials(kerberosDetails, cluster);
            dataDirectory = this.createTemporaryDirectory();
            hostsWithValidKerberosClient = this.getHostsWithValidKerberosClient(cluster);
            if (hostsToForceKerberosOperations != null) {
                hostsWithValidKerberosClient.addAll(hostsToForceKerberosOperations);
            }
        }
        Map<String, Set<String>> clusterHostInfo = StageUtils.getClusterHostInfo(cluster);
        String clusterHostInfoJson = StageUtils.getGson().toJson(clusterHostInfo);
        Map<String, String> hostParams = this.customCommandExecutionHelper.createDefaultHostParams(cluster, cluster.getDesiredStackVersion());
        String hostParamsJson = StageUtils.getGson().toJson(hostParams);
        String ambariServerHostname = StageUtils.getHostName();
        ServiceComponentHostServerActionEvent event = new ServiceComponentHostServerActionEvent(RootComponent.OBDP_SERVER.name(), ambariServerHostname, System.currentTimeMillis());
        RoleCommandOrder roleCommandOrder = this.ambariManagementController.getRoleCommandOrder(cluster);
        if (requestStageContainer == null) {
            requestStageContainer = new RequestStageContainer(this.actionManager.getNextRequestId(), null, this.requestFactory, this.actionManager);
        }
        handler.createStages(cluster, clusterHostInfoJson, hostParamsJson, event, roleCommandOrder, kerberosDetails, dataDirectory, requestStageContainer, schToProcess, serviceComponentFilter, hostFilter, identityFilter, hostsWithValidKerberosClient);
        handler.addFinalizeOperationStage(cluster, clusterHostInfoJson, hostParamsJson, event, dataDirectory, roleCommandOrder, requestStageContainer, kerberosDetails);
        return requestStageContainer;
    }

    private RequestStageContainer handleTestIdentity(Cluster cluster, KerberosDetails kerberosDetails, Map<String, String> commandParameters, RequestStageContainer requestStageContainer, Handler handler) throws OBDPException, KerberosOperationException {
        if (kerberosDetails.manageIdentities()) {
            if (commandParameters == null) {
                throw new OBDPException("The properties map must not be null.  It is needed to store data related to the service check identity");
            }
            ArrayList<ServiceComponentHost> serviceComponentHostsToProcess = new ArrayList<ServiceComponentHost>();
            KerberosDescriptor kerberosDescriptor = this.getKerberosDescriptor(cluster, false);
            Set<String> hostsWithValidKerberosClient = this.getHostsWithValidKerberosClient(cluster);
            File dataDirectory = this.createTemporaryDirectory();
            Map<String, Map<String, String>> configurations = this.calculateConfigurations(cluster, null, kerberosDescriptor, false, false, null);
            String principal = this.variableReplacementHelper.replaceVariables("${kerberos-env/service_check_principal_name}@${realm}", configurations);
            String keytabFilePath = this.variableReplacementHelper.replaceVariables("${keytab_dir}/kerberos.service_check.${short_date}.keytab", configurations);
            String keytabFileOwnerName = this.variableReplacementHelper.replaceVariables("${cluster-env/smokeuser}", configurations);
            String keytabFileOwnerAccess = "rw";
            String keytabFileGroupName = this.variableReplacementHelper.replaceVariables("${cluster-env/user_group}", configurations);
            String keytabFileGroupAccess = "r";
            commandParameters.put("principal_name", principal);
            commandParameters.put("keytab_file", keytabFilePath);
            try {
                List<ServiceComponentHost> serviceComponentHosts = cluster.getServiceComponentHosts(Service.Type.KERBEROS.name(), Role.KERBEROS_CLIENT.name());
                if (serviceComponentHosts != null && !serviceComponentHosts.isEmpty()) {
                    for (ServiceComponentHost sch : serviceComponentHosts) {
                        KerberosPrincipalEntity kpe;
                        if (sch.getState() != State.INSTALLED) continue;
                        String hostname = sch.getHostName();
                        KerberosKeytabEntity kke = this.kerberosKeytabDAO.find(keytabFilePath);
                        if (kke == null) {
                            kke = new KerberosKeytabEntity();
                            kke.setKeytabPath(keytabFilePath);
                            kke.setOwnerName(keytabFileOwnerName);
                            kke.setOwnerAccess(keytabFileOwnerAccess);
                            kke.setGroupName(keytabFileGroupName);
                            kke.setGroupAccess(keytabFileGroupAccess);
                            this.kerberosKeytabDAO.create(kke);
                        }
                        if ((kpe = this.kerberosPrincipalDAO.find(principal)) == null) {
                            kpe = new KerberosPrincipalEntity(principal, false, null);
                            this.kerberosPrincipalDAO.create(kpe);
                        }
                        KerberosKeytabPrincipalDAO.KeytabPrincipalFindOrCreateResult result = this.kerberosKeytabPrincipalDAO.findOrCreate(kke, this.hostDAO.findById(sch.getHost().getHostId()), kpe, null);
                        KerberosKeytabPrincipalEntity kkp = result.kkp;
                        if (kkp.putServiceMapping(sch.getServiceName(), sch.getServiceComponentName())) {
                            this.kerberosKeytabPrincipalDAO.merge(kkp);
                        }
                        this.kerberosKeytabDAO.merge(kke);
                        this.kerberosPrincipalDAO.merge(kpe);
                        hostsWithValidKerberosClient.add(hostname);
                        serviceComponentHostsToProcess.add(sch);
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Failed " + e);
                throw e;
            }
            if (!serviceComponentHostsToProcess.isEmpty()) {
                try {
                    this.validateKDCCredentials(kerberosDetails, cluster);
                }
                catch (Exception e) {
                    LOG.error("Cannot validate credentials: " + e);
                    try {
                        FileUtils.deleteDirectory((File)dataDirectory);
                    }
                    catch (Throwable t) {
                        LOG.warn(String.format("The data directory (%s) was not deleted due to an error condition - {%s}", dataDirectory.getAbsolutePath(), t.getMessage()), t);
                    }
                    throw e;
                }
            }
            Map<String, Set<String>> clusterHostInfo = StageUtils.getClusterHostInfo(cluster);
            String clusterHostInfoJson = StageUtils.getGson().toJson(clusterHostInfo);
            Map<String, String> hostParams = this.customCommandExecutionHelper.createDefaultHostParams(cluster, cluster.getDesiredStackVersion());
            String hostParamsJson = StageUtils.getGson().toJson(hostParams);
            String ambariServerHostname = StageUtils.getHostName();
            ServiceComponentHostServerActionEvent event = new ServiceComponentHostServerActionEvent(RootComponent.OBDP_SERVER.name(), ambariServerHostname, System.currentTimeMillis());
            RoleCommandOrder roleCommandOrder = this.ambariManagementController.getRoleCommandOrder(cluster);
            if (requestStageContainer == null) {
                requestStageContainer = new RequestStageContainer(this.actionManager.getNextRequestId(), null, this.requestFactory, this.actionManager);
            }
            handler.createStages(cluster, clusterHostInfoJson, hostParamsJson, event, roleCommandOrder, kerberosDetails, dataDirectory, requestStageContainer, serviceComponentHostsToProcess, null, null, Sets.newHashSet((Object[])new String[]{principal}), hostsWithValidKerberosClient);
            handler.addFinalizeOperationStage(cluster, clusterHostInfoJson, hostParamsJson, event, dataDirectory, roleCommandOrder, requestStageContainer, kerberosDetails);
        }
        return requestStageContainer;
    }

    @Override
    public KerberosDetails getKerberosDetails(Cluster cluster, Boolean manageIdentities) throws KerberosInvalidConfigurationException, OBDPException {
        KDCType kdcType;
        KerberosDetails kerberosDetails = new KerberosDetails();
        if (cluster == null) {
            String message = "The cluster object is not available";
            LOG.error(message);
            throw new OBDPException(message);
        }
        Config configKrb5Conf = cluster.getDesiredConfigByType("krb5-conf");
        if (configKrb5Conf == null) {
            String message = "The 'krb5-conf' configuration is not available";
            LOG.error(message);
            throw new OBDPException(message);
        }
        Map<String, String> krb5ConfProperties = configKrb5Conf.getProperties();
        if (krb5ConfProperties == null) {
            String message = "The 'krb5-conf' configuration properties are not available";
            LOG.error(message);
            throw new OBDPException(message);
        }
        Config configKerberosEnv = cluster.getDesiredConfigByType("kerberos-env");
        if (configKerberosEnv == null) {
            String message = "The 'kerberos-env' configuration is not available";
            LOG.error(message);
            throw new OBDPException(message);
        }
        Map<String, String> kerberosEnvProperties = configKerberosEnv.getProperties();
        if (kerberosEnvProperties == null) {
            String message = "The 'kerberos-env' configuration properties are not available";
            LOG.error(message);
            throw new OBDPException(message);
        }
        kerberosDetails.setSecurityType(cluster.getSecurityType());
        kerberosDetails.setDefaultRealm(kerberosEnvProperties.get("realm"));
        kerberosDetails.setKerberosEnvProperties(kerberosEnvProperties);
        kerberosDetails.setManageIdentities(manageIdentities);
        String kdcTypeProperty = kerberosEnvProperties.get("kdc_type");
        if (kdcTypeProperty == null && kerberosDetails.manageIdentities()) {
            String message = "The 'kerberos-env/kdc_type' value must be set to a valid KDC type";
            LOG.error(message);
            throw new KerberosInvalidConfigurationException(message);
        }
        try {
            kdcType = KDCType.translate(kdcTypeProperty);
        }
        catch (IllegalArgumentException e) {
            String message = String.format("Invalid 'kdc_type' value: %s", kdcTypeProperty);
            LOG.error(message);
            throw new OBDPException(message);
        }
        kerberosDetails.setKdcType(kdcType == null ? KDCType.MIT_KDC : kdcType);
        return kerberosDetails;
    }

    @Override
    public File createTemporaryDirectory() throws OBDPException {
        try {
            File directory;
            File temporaryDirectory = this.getConfiguredTemporaryDirectory();
            int tries = 0;
            long now = System.currentTimeMillis();
            do {
                if ((directory = new File(temporaryDirectory, String.format("%s%d-%d.d", ".ambari_", now, tries))).exists() || !directory.mkdirs()) {
                    directory = null;
                    continue;
                }
                LOG.debug("Created temporary directory: {}", (Object)directory.getAbsolutePath());
            } while (directory == null && ++tries < 100);
            if (directory == null) {
                throw new IOException(String.format("Failed to create a temporary directory in %s", temporaryDirectory));
            }
            return directory;
        }
        catch (IOException e) {
            String message = "Failed to create the temporary data directory.";
            LOG.error(message, (Throwable)e);
            throw new OBDPException(message, (Throwable)e);
        }
    }

    private void mergeConfiguration(Map<String, Map<String, String>> configurations, String configurationSpecification, String value, Map<String, Map<String, String>> replacements) throws OBDPException {
        String[] parts;
        if (configurationSpecification != null && (parts = configurationSpecification.split("/")).length == 2) {
            String type = parts[0];
            String property = parts[1];
            this.mergeConfigurations(configurations, type, Collections.singletonMap(property, value), replacements);
        }
    }

    private void mergeConfigurations(Map<String, Map<String, String>> configurations, String type, Map<String, String> updates, Map<String, Map<String, String>> replacements) throws OBDPException {
        if (updates != null) {
            Map<String, String> existingProperties = configurations.get(type);
            if (existingProperties == null) {
                existingProperties = new HashMap<String, String>();
                configurations.put(type, existingProperties);
            }
            for (Map.Entry<String, String> property : updates.entrySet()) {
                existingProperties.put(this.variableReplacementHelper.replaceVariables(property.getKey(), replacements), this.variableReplacementHelper.replaceVariables(property.getValue(), replacements));
            }
        }
    }

    private void addIdentities(AuthToLocalBuilder authToLocalBuilder, List<KerberosIdentityDescriptor> identities, Collection<String> identityFilter, Map<String, Map<String, String>> configurations) throws OBDPException {
        if (identities != null) {
            for (KerberosIdentityDescriptor identity : identities) {
                KerberosPrincipalDescriptor principalDescriptor;
                if (identityFilter != null && !identityFilter.contains(identity.getName()) || (principalDescriptor = identity.getPrincipalDescriptor()) == null) continue;
                authToLocalBuilder.addRule(this.variableReplacementHelper.replaceVariables(principalDescriptor.getValue(), configurations), this.variableReplacementHelper.replaceVariables(principalDescriptor.getLocalUsername(), configurations));
            }
        }
    }

    protected File createTemporaryFile() throws OBDPException {
        try {
            return File.createTempFile("tmp", ".tmp", this.getConfiguredTemporaryDirectory());
        }
        catch (IOException e) {
            String message = "Failed to create a temporary file.";
            LOG.error(message, (Throwable)e);
            throw new OBDPException(message, (Throwable)e);
        }
    }

    protected File getConfiguredTemporaryDirectory() throws IOException {
        String tempDirectoryPath = this.configuration.getServerTempDir();
        if (StringUtils.isEmpty((String)tempDirectoryPath)) {
            tempDirectoryPath = System.getProperty("java.io.tmpdir");
        }
        if (tempDirectoryPath == null) {
            throw new IOException("The System property 'java.io.tmpdir' does not specify a temporary directory");
        }
        return new File(tempDirectoryPath);
    }

    private Stage createNewStage(long id, Cluster cluster, long requestId, String requestContext, String commandParams, String hostParams) {
        Stage stage = this.stageFactory.createNew(requestId, BASE_LOG_DIR + File.pathSeparator + requestId, cluster.getClusterName(), cluster.getClusterId(), requestContext, commandParams, hostParams);
        stage.setStageId(id);
        return stage;
    }

    private List<String> createUniqueHostList(Collection<ServiceComponentHost> serviceComponentHosts, Set<HostState> allowedStates) throws OBDPException {
        HashSet<String> hostNames = new HashSet<String>();
        HashSet<String> visitedHostNames = new HashSet<String>();
        if (serviceComponentHosts != null) {
            for (ServiceComponentHost sch : serviceComponentHosts) {
                String hostname = sch.getHostName();
                if (visitedHostNames.contains(hostname)) continue;
                if (allowedStates == null) {
                    hostNames.add(hostname);
                } else {
                    Host host = this.clusters.getHost(hostname);
                    if (allowedStates.contains((Object)host.getState())) {
                        hostNames.add(hostname);
                    } else {
                        LOG.warn("Host {} was excluded due {} state is not allowed. Allowed states: {}", new Object[]{hostname, host.getState(), allowedStates});
                    }
                }
                visitedHostNames.add(hostname);
            }
        }
        return new ArrayList<String>(hostNames);
    }

    @Override
    public boolean isClusterKerberosEnabled(Cluster cluster) {
        return cluster.getSecurityType() == SecurityType.KERBEROS;
    }

    @Override
    public boolean shouldExecuteCustomOperations(SecurityType requestSecurityType, Map<String, String> requestProperties) {
        if (!(requestSecurityType != SecurityType.KERBEROS && requestSecurityType != SecurityType.NONE || requestProperties == null || requestProperties.isEmpty())) {
            for (SupportedCustomOperation type : SupportedCustomOperation.values()) {
                if (!requestProperties.containsKey(type.name().toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Boolean getManageIdentitiesDirective(Map<String, String> requestProperties) {
        String value;
        String string = value = requestProperties == null ? null : requestProperties.get("manage_kerberos_identities");
        return value == null ? null : Boolean.valueOf(!"false".equalsIgnoreCase(value));
    }

    @Override
    public boolean getForceToggleKerberosDirective(Map<String, String> requestProperties) {
        return requestProperties != null && "true".equalsIgnoreCase(requestProperties.get("force_toggle_kerberos"));
    }

    @Override
    public Map<String, Map<String, String>> getIdentityConfigurations(List<KerberosIdentityDescriptor> identityDescriptors) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        if (identityDescriptors != null) {
            for (KerberosIdentityDescriptor identityDescriptor : identityDescriptors) {
                KerberosKeytabDescriptor keytabDescriptor;
                KerberosPrincipalDescriptor principalDescriptor = identityDescriptor.getPrincipalDescriptor();
                if (principalDescriptor != null) {
                    this.putConfiguration(map, principalDescriptor.getConfiguration(), principalDescriptor.getValue());
                }
                if ((keytabDescriptor = identityDescriptor.getKeytabDescriptor()) == null) continue;
                this.putConfiguration(map, keytabDescriptor.getConfiguration(), keytabDescriptor.getFile());
            }
        }
        return map;
    }

    private void putConfiguration(Map<String, Map<String, String>> map, String configuration, String value) {
        String[] principalTokens;
        if (configuration != null && (principalTokens = configuration.split("/")).length == 2) {
            String type = principalTokens[0];
            String propertyName = principalTokens[1];
            Map<String, String> properties = map.get(type);
            if (properties == null) {
                properties = new HashMap<String, String>();
                map.put(type, properties);
            }
            properties.put(propertyName, value);
        }
    }

    private List<KerberosIdentityDescriptor> getActiveIdentities(Cluster cluster, String hostname, String serviceName, String componentName, KerberosDescriptor kerberosDescriptor, Map<String, Object> filterContext) {
        ArrayList<KerberosIdentityDescriptor> identities = new ArrayList<KerberosIdentityDescriptor>();
        List<ServiceComponentHost> serviceComponentHosts = cluster.getServiceComponentHosts(hostname);
        if (serviceComponentHosts == null) {
            return identities;
        }
        serviceComponentHosts.forEach(serviceComponentHost -> {
            KerberosServiceDescriptor serviceDescriptor;
            String schServiceName = serviceComponentHost.getServiceName();
            String schComponentName = serviceComponentHost.getServiceComponentName();
            if ((serviceName == null || serviceName.equals(schServiceName)) && (componentName == null || componentName.equals(schComponentName)) && (serviceDescriptor = kerberosDescriptor.getService(schServiceName)) != null) {
                KerberosComponentDescriptor componentDescriptor;
                List<KerberosIdentityDescriptor> serviceIdentities;
                try {
                    serviceIdentities = serviceDescriptor.getIdentities(true, filterContext);
                }
                catch (OBDPException e) {
                    serviceIdentities = null;
                }
                if (serviceIdentities != null) {
                    identities.addAll(serviceIdentities);
                }
                if ((componentDescriptor = serviceDescriptor.getComponent(schComponentName)) != null) {
                    List<KerberosIdentityDescriptor> componentIdentities;
                    try {
                        componentIdentities = componentDescriptor.getIdentities(true, filterContext);
                    }
                    catch (OBDPException e) {
                        componentIdentities = null;
                    }
                    if (componentIdentities != null) {
                        identities.addAll(componentIdentities);
                    }
                }
            }
        });
        return identities;
    }

    private Map<String, Map<String, String>> addAdditionalConfigurations(Cluster cluster, Map<String, Map<String, String>> configurations, String hostname, Map<String, String> kerberosDescriptorProperties, @Nullable KerberosDescriptor userDescriptor, Map<String, String> componentHosts, @Nullable Map<String, DesiredConfig> desiredConfigs) throws OBDPException {
        Map generalProperties = configurations.computeIfAbsent("", k -> new HashMap());
        if (kerberosDescriptorProperties != null) {
            generalProperties.putAll(kerberosDescriptorProperties);
        }
        if (!StringUtils.isEmpty((String)hostname)) {
            generalProperties.put("host", hostname);
            generalProperties.put("hostname", hostname);
        }
        generalProperties.put("cluster_name", cluster.getClusterName());
        generalProperties.put("short_date", new SimpleDateFormat("MMddyy").format(new Date()));
        if (configurations.get("clusterHostInfo") == null) {
            Map<String, Set<String>> clusterHostInfo;
            if (componentHosts == null) {
                componentHosts = new HashMap<String, String>();
            }
            if (componentHosts.isEmpty() && (clusterHostInfo = StageUtils.getClusterHostInfo(cluster)) != null) {
                clusterHostInfo = StageUtils.substituteHostIndexes(clusterHostInfo);
                for (Map.Entry<String, Set<String>> entry : clusterHostInfo.entrySet()) {
                    componentHosts.put(entry.getKey(), StringUtils.join((Collection)entry.getValue(), (String)","));
                }
            }
            if (!componentHosts.isEmpty()) {
                configurations.put("clusterHostInfo", componentHosts);
            }
        }
        configurations.put("principals", this.principalNames(cluster, configurations, userDescriptor, desiredConfigs));
        return configurations;
    }

    private Map<String, Map<String, String>> addAdditionalConfigurations(Cluster cluster, Map<String, Map<String, String>> configurations, String hostname, Map<String, String> kerberosDescriptorProperties, KerberosDescriptor userDescriptor) throws OBDPException {
        return this.addAdditionalConfigurations(cluster, configurations, hostname, kerberosDescriptorProperties, userDescriptor, null, null);
    }

    private Map<String, Map<String, String>> deepCopy(Map<String, Map<String, String>> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, Map<String, String>> copy = new HashMap<String, Map<String, String>>();
        Iterator<Map.Entry<String, Map<String, String>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map<String, String> innerMap;
            Map.Entry<String, Map<String, String>> entry;
            copy.put(entry.getKey(), (Map<String, String>)((innerMap = (entry = iterator.next()).getValue()) == null ? null : new HashMap<String, String>(innerMap)));
        }
        return copy;
    }

    @Override
    public KerberosDescriptor getKerberosDescriptorUpdates(Cluster cluster) {
        TreeMap<String, String> foreignKeys = new TreeMap<String, String>();
        foreignKeys.put("cluster", String.valueOf(cluster.getClusterId()));
        ArtifactEntity entity = this.artifactDAO.findByNameAndForeignKeys("kerberos_descriptor", foreignKeys);
        return entity == null ? null : this.kerberosDescriptorFactory.createInstance(entity.getArtifactData());
    }

    private KerberosDescriptor getKerberosDescriptorFromStack(StackId stackId, boolean includePreconfigureData) throws OBDPException {
        return this.obdpMetaInfo.getKerberosDescriptor(stackId.getStackName(), stackId.getStackVersion(), includePreconfigureData);
    }

    private Map<String, Set<String>> processWhenClauses(String currentPath, AbstractKerberosDescriptorContainer container, Map<String, Object> context, Map<String, Set<String>> identitiesToRemove) throws OBDPException {
        Collection<? extends AbstractKerberosDescriptorContainer> children;
        List<KerberosIdentityDescriptor> identities = container.getIdentities(true, null);
        if (identities != null && !identities.isEmpty()) {
            HashSet<String> set = null;
            for (KerberosIdentityDescriptor kerberosIdentityDescriptor : identities) {
                if (kerberosIdentityDescriptor.shouldInclude(context)) continue;
                if (set == null) {
                    set = new HashSet<String>();
                    identitiesToRemove.put(currentPath, set);
                }
                set.add(kerberosIdentityDescriptor.getName());
            }
        }
        if ((children = container.getChildContainers()) != null) {
            for (AbstractKerberosDescriptorContainer abstractKerberosDescriptorContainer : children) {
                identitiesToRemove = this.processWhenClauses(currentPath + "/" + abstractKerberosDescriptorContainer.getName(), abstractKerberosDescriptorContainer, context, identitiesToRemove);
            }
        }
        return identitiesToRemove;
    }

    private void processIdentityConfigurations(Map<String, Map<String, String>> identityConfigurations, Map<String, Map<String, String>> kerberosConfigurations, Map<String, Map<String, String>> configurations, Map<String, Set<String>> propertiesToIgnore) throws OBDPException {
        if (identityConfigurations != null) {
            for (Map.Entry<String, Map<String, String>> identitiyEntry : identityConfigurations.entrySet()) {
                String configType = identitiyEntry.getKey();
                Map<String, String> properties = identitiyEntry.getValue();
                this.mergeConfigurations(kerberosConfigurations, configType, identitiyEntry.getValue(), configurations);
                if (properties == null || properties.isEmpty()) continue;
                Set<String> propertyNames = propertiesToIgnore.get(configType);
                if (propertyNames == null) {
                    propertyNames = new HashSet<String>();
                    propertiesToIgnore.put(configType, propertyNames);
                }
                propertyNames.addAll(properties.keySet());
            }
        }
    }

    private Map<String, Map<String, String>> addConfigurationsForPreProcessedServices(Map<String, Map<String, String>> configurations, Cluster cluster, @Nullable KerberosDescriptor kerberosDescriptor, boolean calculateClusterHostInfo) throws OBDPException {
        Map<String, KerberosServiceDescriptor> serviceDescriptorMap = kerberosDescriptor.getServices();
        if (serviceDescriptorMap != null) {
            Map<String, Service> existingServices = cluster.getServices();
            HashSet<String> allServices = new HashSet<String>(existingServices.keySet());
            HashSet<String> componentFilter = new HashSet<String>();
            StackId stackVersion = cluster.getCurrentStackVersion();
            for (KerberosServiceDescriptor serviceDescriptor : serviceDescriptorMap.values()) {
                String serviceName = serviceDescriptor.getName();
                boolean shouldPreconfigure = serviceDescriptor.shouldPreconfigure();
                if (!shouldPreconfigure || existingServices.containsKey(serviceName) || !this.obdpMetaInfo.isValidService(stackVersion.getStackName(), stackVersion.getStackVersion(), serviceName)) continue;
                ServiceInfo serviceInfo = this.obdpMetaInfo.getService(stackVersion.getStackName(), stackVersion.getStackVersion(), serviceName);
                List<PropertyInfo> servicePropertiesInfos = serviceInfo.getProperties();
                if (servicePropertiesInfos != null) {
                    HashMap<String, HashMap<String, String>> propertiesToAdd = new HashMap<String, HashMap<String, String>>();
                    for (PropertyInfo propertyInfo : servicePropertiesInfos) {
                        String type = ConfigHelper.fileNameToConfigType(propertyInfo.getFilename());
                        HashMap<String, String> map = (HashMap<String, String>)propertiesToAdd.get(type);
                        if (map == null) {
                            map = new HashMap<String, String>();
                            propertiesToAdd.put(type, map);
                        }
                        map.put(propertyInfo.getName(), propertyInfo.getValue());
                    }
                    for (Map.Entry entry : propertiesToAdd.entrySet()) {
                        if (configurations.containsKey(entry.getKey())) continue;
                        configurations.put((String)entry.getKey(), (Map)entry.getValue());
                    }
                }
                if (!calculateClusterHostInfo) continue;
                allServices.add(serviceName);
                List<ComponentInfo> componentInfos = serviceInfo.getComponents();
                if (componentInfos == null) continue;
                for (ComponentInfo componentInfo : componentInfos) {
                    componentFilter.add(componentInfo.getName());
                }
            }
            if (calculateClusterHostInfo && allServices.size() > existingServices.size()) {
                this.applyStackAdvisorHostRecommendations(cluster, allServices, componentFilter, configurations);
            }
        }
        return configurations;
    }

    private KerberosDescriptor combineKerberosDescriptors(KerberosDescriptor stackDescriptor, KerberosDescriptor userDescriptor) {
        KerberosDescriptor kerberosDescriptor;
        if (stackDescriptor == null) {
            if (userDescriptor == null) {
                return new KerberosDescriptor();
            }
            kerberosDescriptor = userDescriptor;
        } else {
            if (userDescriptor != null) {
                stackDescriptor.update(userDescriptor);
            }
            kerberosDescriptor = stackDescriptor;
        }
        return kerberosDescriptor;
    }

    private Collection<ServiceComponentHost> filterServiceComponentHostsForHosts(Collection<ServiceComponentHost> serviceComponentHosts, Set<String> hosts) {
        if (serviceComponentHosts != null && hosts != null) {
            Iterator<ServiceComponentHost> iterator = serviceComponentHosts.iterator();
            while (iterator.hasNext()) {
                ServiceComponentHost sch = iterator.next();
                if (hosts.contains(sch.getHostName())) continue;
                iterator.remove();
            }
        }
        return serviceComponentHosts;
    }

    private List<String> calculateHosts(Cluster cluster, List<ServiceComponentHost> serviceComponentHosts, Set<String> hostsWithValidKerberosClient, boolean forceAllHosts) throws OBDPException {
        if (forceAllHosts) {
            ArrayList<String> hosts = new ArrayList<String>();
            Collection<Host> clusterHosts = cluster.getHosts();
            if (!CollectionUtils.isEmpty(clusterHosts)) {
                for (Host host : clusterHosts) {
                    if (host.getState() == HostState.HEALTHY) {
                        hosts.add(host.getHostName());
                        continue;
                    }
                    LOG.warn("Host {} was excluded due {} state", (Object)host.getHostName(), (Object)host.getState());
                }
            }
            return hosts;
        }
        Collection<ServiceComponentHost> filteredComponents = this.filterServiceComponentHostsForHosts(new ArrayList<ServiceComponentHost>(serviceComponentHosts), hostsWithValidKerberosClient);
        if (filteredComponents.isEmpty()) {
            return Collections.emptyList();
        }
        return this.createUniqueHostList(filteredComponents, Collections.singleton(HostState.HEALTHY));
    }

    private class EnableKerberosHandler
    extends Handler {
        private EnableKerberosHandler() {
        }

        @Override
        public long createStages(Cluster cluster, String clusterHostInfoJson, String hostParamsJson, ServiceComponentHostServerActionEvent event, RoleCommandOrder roleCommandOrder, KerberosDetails kerberosDetails, File dataDirectory, RequestStageContainer requestStageContainer, List<ServiceComponentHost> serviceComponentHosts, Map<String, ? extends Collection<String>> serviceComponentFilter, Set<String> hostFilter, Collection<String> identityFilter, Set<String> hostsWithValidKerberosClient) throws OBDPException {
            if (requestStageContainer == null) {
                requestStageContainer = new RequestStageContainer(KerberosHelperImpl.this.actionManager.getNextRequestId(), null, KerberosHelperImpl.this.requestFactory, KerberosHelperImpl.this.actionManager);
            }
            HashMap<String, String> commandParameters = new HashMap<String, String>();
            commandParameters.put("authenticated_user_name", KerberosHelperImpl.this.ambariManagementController.getAuthName());
            commandParameters.put("update_configuration_note", "Enabling Kerberos");
            commandParameters.put("update_configuration_policy", UpdateConfigurationPolicy.ALL.name());
            commandParameters.put("default_realm", kerberosDetails.getDefaultRealm());
            commandParameters.put("include_ambari_identity", kerberosDetails.createAmbariPrincipal() ? "true" : "false");
            commandParameters.put("preconfigure_services", kerberosDetails.getPreconfigureServices());
            if (dataDirectory != null) {
                commandParameters.put("data_directory", dataDirectory.getAbsolutePath());
            }
            if (serviceComponentFilter != null) {
                commandParameters.put("service_component_filter", StageUtils.getGson().toJson(serviceComponentFilter));
            }
            if (hostFilter != null) {
                commandParameters.put("host_filter", StageUtils.getGson().toJson(hostFilter));
            }
            if (identityFilter != null) {
                commandParameters.put("identity_filter", StageUtils.getGson().toJson(identityFilter));
            }
            this.addPrepareEnableKerberosOperationsStage(cluster, clusterHostInfoJson, hostParamsJson, event, commandParameters, roleCommandOrder, requestStageContainer);
            if (kerberosDetails.manageIdentities()) {
                List<String> hostsToInclude = KerberosHelperImpl.this.calculateHosts(cluster, serviceComponentHosts, hostsWithValidKerberosClient, false);
                commandParameters.put("kdc_type", kerberosDetails.getKdcType().name());
                this.addCreatePrincipalsStage(cluster, clusterHostInfoJson, hostParamsJson, event, commandParameters, roleCommandOrder, requestStageContainer);
                this.addCreateKeytabFilesStage(cluster, clusterHostInfoJson, hostParamsJson, event, commandParameters, roleCommandOrder, requestStageContainer);
                if (kerberosDetails.createAmbariPrincipal()) {
                    this.addConfigureAmbariIdentityStage(cluster, clusterHostInfoJson, hostParamsJson, event, commandParameters, roleCommandOrder, requestStageContainer);
                }
                this.addDistributeKeytabFilesStage(cluster, clusterHostInfoJson, hostParamsJson, commandParameters, roleCommandOrder, requestStageContainer, hostsToInclude);
            }
            this.addUpdateConfigurationsStage(cluster, clusterHostInfoJson, hostParamsJson, event, commandParameters, roleCommandOrder, requestStageContainer);
            return requestStageContainer.getLastStageId();
        }
    }

    private abstract class Handler {
        protected boolean retryAllowed = false;

        private Handler() {
        }

        void setRetryAllowed(boolean retryAllowed) {
            this.retryAllowed = retryAllowed;
        }

        abstract long createStages(Cluster var1, String var2, String var3, ServiceComponentHostServerActionEvent var4, RoleCommandOrder var5, KerberosDetails var6, File var7, RequestStageContainer var8, List<ServiceComponentHost> var9, Map<String, ? extends Collection<String>> var10, Set<String> var11, Collection<String> var12, Set<String> var13) throws OBDPException;

        public void addPrepareEnableKerberosOperationsStage(Cluster cluster, String clusterHostInfoJson, String hostParamsJson, ServiceComponentHostServerActionEvent event, Map<String, String> commandParameters, RoleCommandOrder roleCommandOrder, RequestStageContainer requestStageContainer) throws OBDPException {
            Stage stage = this.createServerActionStage(requestStageContainer.getLastStageId(), cluster, requestStageContainer.getId(), "Preparing Operations", "{}", hostParamsJson, PrepareEnableKerberosServerAction.class, event, commandParameters, "Preparing Operations", KerberosHelperImpl.this.configuration.getDefaultServerTaskTimeout());
            RoleGraph roleGraph = KerberosHelperImpl.this.roleGraphFactory.createNew(roleCommandOrder);
            roleGraph.build(stage);
            requestStageContainer.addStages(roleGraph.getStages());
        }

        public void addPrepareKerberosIdentitiesStage(Cluster cluster, String clusterHostInfoJson, String hostParamsJson, ServiceComponentHostServerActionEvent event, Map<String, String> commandParameters, RoleCommandOrder roleCommandOrder, RequestStageContainer requestStageContainer) throws OBDPException {
            Stage stage = this.createServerActionStage(requestStageContainer.getLastStageId(), cluster, requestStageContainer.getId(), "Preparing Operations", "{}", hostParamsJson, PrepareKerberosIdentitiesServerAction.class, event, commandParameters, "Preparing Operations", KerberosHelperImpl.this.configuration.getDefaultServerTaskTimeout());
            RoleGraph roleGraph = KerberosHelperImpl.this.roleGraphFactory.createNew(roleCommandOrder);
            roleGraph.build(stage);
            requestStageContainer.addStages(roleGraph.getStages());
        }

        public void addPrepareDisableKerberosOperationsStage(Cluster cluster, String clusterHostInfoJson, String hostParamsJson, ServiceComponentHostServerActionEvent event, Map<String, String> commandParameters, RoleCommandOrder roleCommandOrder, RequestStageContainer requestStageContainer) throws OBDPException {
            Stage stage = this.createServerActionStage(requestStageContainer.getLastStageId(), cluster, requestStageContainer.getId(), "Preparing Operations", "{}", hostParamsJson, PrepareDisableKerberosServerAction.class, event, commandParameters, "Preparing Operations", KerberosHelperImpl.this.configuration.getDefaultServerTaskTimeout());
            RoleGraph roleGraph = KerberosHelperImpl.this.roleGraphFactory.createNew(roleCommandOrder);
            roleGraph.build(stage);
            requestStageContainer.addStages(roleGraph.getStages());
        }

        public void addCreatePrincipalsStage(Cluster cluster, String clusterHostInfoJson, String hostParamsJson, ServiceComponentHostServerActionEvent event, Map<String, String> commandParameters, RoleCommandOrder roleCommandOrder, RequestStageContainer requestStageContainer) throws OBDPException {
            Stage stage = this.createServerActionStage(requestStageContainer.getLastStageId(), cluster, requestStageContainer.getId(), "Create Principals", "{}", hostParamsJson, CreatePrincipalsServerAction.class, event, commandParameters, "Create Principals", Math.max(36000, KerberosHelperImpl.this.configuration.getDefaultServerTaskTimeout()));
            RoleGraph roleGraph = KerberosHelperImpl.this.roleGraphFactory.createNew(roleCommandOrder);
            roleGraph.build(stage);
            requestStageContainer.addStages(roleGraph.getStages());
        }

        public void addDestroyPrincipalsStage(Cluster cluster, String clusterHostInfoJson, String hostParamsJson, ServiceComponentHostServerActionEvent event, Map<String, String> commandParameters, RoleCommandOrder roleCommandOrder, RequestStageContainer requestStageContainer) throws OBDPException {
            Stage stage = this.createServerActionStage(requestStageContainer.getLastStageId(), cluster, requestStageContainer.getId(), "Destroy Principals", "{}", hostParamsJson, DestroyPrincipalsServerAction.class, event, commandParameters, "Destroy Principals", Math.max(36000, KerberosHelperImpl.this.configuration.getDefaultServerTaskTimeout()));
            RoleGraph roleGraph = KerberosHelperImpl.this.roleGraphFactory.createNew(roleCommandOrder);
            roleGraph.build(stage);
            requestStageContainer.addStages(roleGraph.getStages());
        }

        public void addConfigureAmbariIdentityStage(Cluster cluster, String clusterHostInfoJson, String hostParamsJson, ServiceComponentHostServerActionEvent event, Map<String, String> commandParameters, RoleCommandOrder roleCommandOrder, RequestStageContainer requestStageContainer) throws OBDPException {
            Stage stage = this.createServerActionStage(requestStageContainer.getLastStageId(), cluster, requestStageContainer.getId(), "Configure ONYX Big Data Platform Identity", "{}", hostParamsJson, ConfigureOBDPIdentitiesServerAction.class, event, commandParameters, "Configure ONYX Big Data Platform Identity", KerberosHelperImpl.this.configuration.getDefaultServerTaskTimeout());
            RoleGraph roleGraph = KerberosHelperImpl.this.roleGraphFactory.createNew(roleCommandOrder);
            roleGraph.build(stage);
            requestStageContainer.addStages(roleGraph.getStages());
        }

        public void addCreateKeytabFilesStage(Cluster cluster, String clusterHostInfoJson, String hostParamsJson, ServiceComponentHostServerActionEvent event, Map<String, String> commandParameters, RoleCommandOrder roleCommandOrder, RequestStageContainer requestStageContainer) throws OBDPException {
            Stage stage = this.createServerActionStage(requestStageContainer.getLastStageId(), cluster, requestStageContainer.getId(), "Create Keytabs", "{}", hostParamsJson, CreateKeytabFilesServerAction.class, event, commandParameters, "Create Keytabs", Math.max(36000, KerberosHelperImpl.this.configuration.getDefaultServerTaskTimeout()));
            RoleGraph roleGraph = KerberosHelperImpl.this.roleGraphFactory.createNew(roleCommandOrder);
            roleGraph.build(stage);
            requestStageContainer.addStages(roleGraph.getStages());
        }

        void addDistributeKeytabFilesStage(Cluster cluster, String clusterHostInfoJson, String hostParamsJson, Map<String, String> commandParameters, RoleCommandOrder roleCommandOrder, RequestStageContainer requestStageContainer, List<String> hosts) throws OBDPException {
            Stage stage = KerberosHelperImpl.this.createNewStage(requestStageContainer.getLastStageId(), cluster, requestStageContainer.getId(), "Distribute Keytabs", StageUtils.getGson().toJson(commandParameters), hostParamsJson);
            if (!hosts.isEmpty()) {
                HashMap<String, String> requestParams = new HashMap<String, String>();
                ActionExecutionContext actionExecContext = this.createActionExecutionContext(cluster.getClusterName(), KerberosHelperImpl.SET_KEYTAB, this.createRequestResourceFilters(hosts), requestParams, this.retryAllowed);
                KerberosHelperImpl.this.customCommandExecutionHelper.addExecutionCommandsToStage(actionExecContext, stage, requestParams, null);
            } else {
                LOG.warn("Skipping {} command. No suitable hosts found", (Object)KerberosHelperImpl.SET_KEYTAB);
            }
            RoleGraph roleGraph = KerberosHelperImpl.this.roleGraphFactory.createNew(roleCommandOrder);
            roleGraph.build(stage);
            requestStageContainer.addStages(roleGraph.getStages());
        }

        void addCheckMissingKeytabsStage(Cluster cluster, String clusterHostInfoJson, String hostParamsJson, Map<String, String> commandParameters, RoleCommandOrder roleCommandOrder, RequestStageContainer requestStageContainer, List<String> hostsToInclude) throws OBDPException {
            Stage stage = KerberosHelperImpl.this.createNewStage(requestStageContainer.getLastStageId(), cluster, requestStageContainer.getId(), "Checking keytabs", StageUtils.getGson().toJson(commandParameters), hostParamsJson);
            if (!hostsToInclude.isEmpty()) {
                HashMap<String, String> requestParams = new HashMap<String, String>();
                ActionExecutionContext actionExecContext = this.createActionExecutionContext(cluster.getClusterName(), KerberosHelperImpl.CHECK_KEYTABS, this.createRequestResourceFilters(hostsToInclude), requestParams, this.retryAllowed);
                KerberosHelperImpl.this.customCommandExecutionHelper.addExecutionCommandsToStage(actionExecContext, stage, requestParams, null);
            }
            RoleGraph roleGraph = KerberosHelperImpl.this.roleGraphFactory.createNew(roleCommandOrder);
            roleGraph.build(stage);
            requestStageContainer.addStages(roleGraph.getStages());
        }

        void addDisableSecurityHookStage(Cluster cluster, String clusterHostInfoJson, String hostParamsJson, Map<String, String> commandParameters, RoleCommandOrder roleCommandOrder, RequestStageContainer requestStageContainer) throws OBDPException {
            Stage stage = KerberosHelperImpl.this.createNewStage(requestStageContainer.getLastStageId(), cluster, requestStageContainer.getId(), "Disable security", StageUtils.getGson().toJson(commandParameters), hostParamsJson);
            this.addDisableSecurityCommandToAllServices(cluster, stage);
            RoleGraph roleGraph = KerberosHelperImpl.this.roleGraphFactory.createNew(roleCommandOrder);
            roleGraph.build(stage);
            requestStageContainer.addStages(roleGraph.getStages());
        }

        private void addDisableSecurityCommandToAllServices(Cluster cluster, Stage stage) throws OBDPException {
            for (Service service : cluster.getServices().values()) {
                for (ServiceComponent component : service.getServiceComponents().values()) {
                    if (component.getServiceComponentHosts().isEmpty()) continue;
                    String firstHost = component.getServiceComponentHosts().keySet().iterator().next();
                    ActionExecutionContext exec = new ActionExecutionContext(cluster.getClusterName(), "DISABLE_SECURITY", Collections.singletonList(new RequestResourceFilter(service.getName(), component.getName(), Collections.singletonList(firstHost))), Collections.emptyMap());
                    KerberosHelperImpl.this.customCommandExecutionHelper.addExecutionCommandsToStage(exec, stage, Collections.emptyMap(), null);
                }
            }
        }

        void addStopZookeeperStage(Cluster cluster, String clusterHostInfoJson, String hostParamsJson, Map<String, String> commandParameters, RoleCommandOrder roleCommandOrder, RequestStageContainer requestStageContainer) throws OBDPException {
            Service zookeeper;
            try {
                zookeeper = cluster.getService("ZOOKEEPER");
            }
            catch (ServiceNotFoundException e) {
                return;
            }
            Stage stage = KerberosHelperImpl.this.createNewStage(requestStageContainer.getLastStageId(), cluster, requestStageContainer.getId(), "Stopping ZooKeeper", StageUtils.getGson().toJson(commandParameters), hostParamsJson);
            for (ServiceComponent component : zookeeper.getServiceComponents().values()) {
                Set<String> hosts = component.getServiceComponentHosts().keySet();
                ActionExecutionContext exec = new ActionExecutionContext(cluster.getClusterName(), "STOP", Collections.singletonList(new RequestResourceFilter(zookeeper.getName(), component.getName(), new ArrayList<String>(hosts))), Collections.emptyMap());
                KerberosHelperImpl.this.customCommandExecutionHelper.addExecutionCommandsToStage(exec, stage, Collections.emptyMap(), null);
            }
            RoleGraph roleGraph = KerberosHelperImpl.this.roleGraphFactory.createNew(roleCommandOrder);
            roleGraph.build(stage);
            requestStageContainer.addStages(roleGraph.getStages());
        }

        public void addDeleteKeytabFilesStage(Cluster cluster, List<ServiceComponentHost> serviceComponentHosts, String clusterHostInfoJson, String hostParamsJson, Map<String, String> commandParameters, RoleCommandOrder roleCommandOrder, RequestStageContainer requestStageContainer, Set<String> hostsWithValidKerberosClient) throws OBDPException {
            List<String> hostsToUpdate;
            Stage stage = KerberosHelperImpl.this.createNewStage(requestStageContainer.getLastStageId(), cluster, requestStageContainer.getId(), "Delete Keytabs", StageUtils.getGson().toJson(commandParameters), hostParamsJson);
            Collection<ServiceComponentHost> filteredComponents = KerberosHelperImpl.this.filterServiceComponentHostsForHosts(new ArrayList<ServiceComponentHost>(serviceComponentHosts), hostsWithValidKerberosClient);
            if (!filteredComponents.isEmpty() && !(hostsToUpdate = KerberosHelperImpl.this.createUniqueHostList(filteredComponents, Collections.singleton(HostState.HEALTHY))).isEmpty()) {
                HashMap<String, String> requestParams = new HashMap<String, String>();
                ArrayList<RequestResourceFilter> requestResourceFilters = new ArrayList<RequestResourceFilter>();
                RequestResourceFilter reqResFilter = new RequestResourceFilter("KERBEROS", "KERBEROS_CLIENT", hostsToUpdate);
                requestResourceFilters.add(reqResFilter);
                ActionExecutionContext actionExecContext = new ActionExecutionContext(cluster.getClusterName(), KerberosHelperImpl.REMOVE_KEYTAB, requestResourceFilters, requestParams);
                KerberosHelperImpl.this.customCommandExecutionHelper.addExecutionCommandsToStage(actionExecContext, stage, requestParams, null);
            }
            RoleGraph roleGraph = KerberosHelperImpl.this.roleGraphFactory.createNew(roleCommandOrder);
            roleGraph.build(stage);
            requestStageContainer.addStages(roleGraph.getStages());
        }

        public void addUpdateConfigurationsStage(Cluster cluster, String clusterHostInfoJson, String hostParamsJson, ServiceComponentHostServerActionEvent event, Map<String, String> commandParameters, RoleCommandOrder roleCommandOrder, RequestStageContainer requestStageContainer) throws OBDPException {
            Stage stage = this.createServerActionStage(requestStageContainer.getLastStageId(), cluster, requestStageContainer.getId(), "Update Configurations", "{}", hostParamsJson, UpdateKerberosConfigsServerAction.class, event, commandParameters, "Update Service Configurations", KerberosHelperImpl.this.configuration.getDefaultServerTaskTimeout());
            RoleGraph roleGraph = KerberosHelperImpl.this.roleGraphFactory.createNew(roleCommandOrder);
            roleGraph.build(stage);
            requestStageContainer.addStages(roleGraph.getStages());
        }

        public void addFinalizeOperationStage(Cluster cluster, String clusterHostInfoJson, String hostParamsJson, ServiceComponentHostServerActionEvent event, File dataDirectory, RoleCommandOrder roleCommandOrder, RequestStageContainer requestStageContainer, KerberosDetails kerberosDetails) throws OBDPException {
            HashMap<String, String> commandParameters = new HashMap<String, String>();
            commandParameters.put("default_realm", kerberosDetails.getDefaultRealm());
            commandParameters.put("kdc_type", kerberosDetails.getKdcType().name());
            commandParameters.put("authenticated_user_name", KerberosHelperImpl.this.ambariManagementController.getAuthName());
            if (dataDirectory != null) {
                commandParameters.put("data_directory", dataDirectory.getAbsolutePath());
            }
            int timeout = KerberosHelperImpl.this.configuration.getKerberosServerActionFinalizeTimeout();
            Stage stage = this.createServerActionStage(requestStageContainer.getLastStageId(), cluster, requestStageContainer.getId(), "Finalize Operations", "{}", hostParamsJson, FinalizeKerberosServerAction.class, event, commandParameters, "Finalize Operations", timeout);
            RoleGraph roleGraph = KerberosHelperImpl.this.roleGraphFactory.createNew(roleCommandOrder);
            roleGraph.build(stage);
            requestStageContainer.addStages(roleGraph.getStages());
        }

        public void addCleanupStage(Cluster cluster, String clusterHostInfoJson, String hostParamsJson, ServiceComponentHostServerActionEvent event, Map<String, String> commandParameters, RoleCommandOrder roleCommandOrder, RequestStageContainer requestStageContainer) throws OBDPException {
            Stage stage = this.createServerActionStage(requestStageContainer.getLastStageId(), cluster, requestStageContainer.getId(), "Kerberization Clean Up", "{}", hostParamsJson, CleanupServerAction.class, event, commandParameters, "Kerberization Clean Up", KerberosHelperImpl.this.configuration.getDefaultServerTaskTimeout());
            RoleGraph roleGraph = KerberosHelperImpl.this.roleGraphFactory.createNew(roleCommandOrder);
            roleGraph.build(stage);
            requestStageContainer.addStages(roleGraph.getStages());
        }

        private List<RequestResourceFilter> createRequestResourceFilters(List<String> hostsToInclude) {
            ArrayList<RequestResourceFilter> requestResourceFilters = new ArrayList<RequestResourceFilter>();
            RequestResourceFilter reqResFilter = new RequestResourceFilter(Service.Type.KERBEROS.name(), Role.KERBEROS_CLIENT.name(), hostsToInclude);
            requestResourceFilters.add(reqResFilter);
            return requestResourceFilters;
        }

        private Stage createServerActionStage(long id, Cluster cluster, long requestId, String requestContext, String commandParams, String hostParams, Class<? extends ServerAction> actionClass, ServiceComponentHostServerActionEvent event, Map<String, String> commandParameters, String commandDetail, Integer timeout) throws OBDPException {
            Stage stage = KerberosHelperImpl.this.createNewStage(id, cluster, requestId, requestContext, commandParams, hostParams);
            stage.addServerActionCommand(actionClass.getName(), null, Role.AMBARI_SERVER_ACTION, RoleCommand.EXECUTE, cluster.getClusterName(), event, commandParameters, commandDetail, KerberosHelperImpl.this.ambariManagementController.findConfigurationTagsWithOverrides(cluster, null, null), timeout, this.retryAllowed, false);
            return stage;
        }

        private ActionExecutionContext createActionExecutionContext(String clusterName, String commandName, List<RequestResourceFilter> resourceFilters, Map<String, String> parameters, boolean retryAllowed) {
            ActionExecutionContext actionExecContext = new ActionExecutionContext(clusterName, commandName, resourceFilters, parameters);
            actionExecContext.setRetryAllowed(retryAllowed);
            return actionExecContext;
        }
    }

    private class DisableKerberosHandler
    extends Handler {
        private DisableKerberosHandler() {
        }

        @Override
        public long createStages(Cluster cluster, String clusterHostInfoJson, String hostParamsJson, ServiceComponentHostServerActionEvent event, RoleCommandOrder roleCommandOrder, KerberosDetails kerberosDetails, File dataDirectory, RequestStageContainer requestStageContainer, List<ServiceComponentHost> serviceComponentHosts, Map<String, ? extends Collection<String>> serviceComponentFilter, Set<String> hostFilter, Collection<String> identityFilter, Set<String> hostsWithValidKerberosClient) throws OBDPException {
            if (requestStageContainer == null) {
                requestStageContainer = new RequestStageContainer(KerberosHelperImpl.this.actionManager.getNextRequestId(), null, KerberosHelperImpl.this.requestFactory, KerberosHelperImpl.this.actionManager);
            }
            HashMap<String, String> commandParameters = new HashMap<String, String>();
            commandParameters.put("authenticated_user_name", KerberosHelperImpl.this.ambariManagementController.getAuthName());
            commandParameters.put("update_configuration_note", "Disabling Kerberos");
            commandParameters.put("update_configuration_policy", UpdateConfigurationPolicy.ALL.name());
            commandParameters.put("default_realm", kerberosDetails.getDefaultRealm());
            if (dataDirectory != null) {
                commandParameters.put("data_directory", dataDirectory.getAbsolutePath());
            }
            if (serviceComponentFilter != null) {
                commandParameters.put("service_component_filter", StageUtils.getGson().toJson(serviceComponentFilter));
            }
            if (hostFilter != null) {
                commandParameters.put("host_filter", StageUtils.getGson().toJson(hostFilter));
            }
            if (identityFilter != null) {
                commandParameters.put("identity_filter", StageUtils.getGson().toJson(identityFilter));
            }
            this.addDisableSecurityHookStage(cluster, clusterHostInfoJson, hostParamsJson, commandParameters, roleCommandOrder, requestStageContainer);
            this.addStopZookeeperStage(cluster, clusterHostInfoJson, hostParamsJson, commandParameters, roleCommandOrder, requestStageContainer);
            this.addPrepareDisableKerberosOperationsStage(cluster, clusterHostInfoJson, hostParamsJson, event, commandParameters, roleCommandOrder, requestStageContainer);
            this.addUpdateConfigurationsStage(cluster, clusterHostInfoJson, hostParamsJson, event, commandParameters, roleCommandOrder, requestStageContainer);
            if (kerberosDetails.manageIdentities()) {
                commandParameters.put("kdc_type", kerberosDetails.getKdcType().name());
                this.addDeleteKeytabFilesStage(cluster, serviceComponentHosts, clusterHostInfoJson, hostParamsJson, commandParameters, roleCommandOrder, requestStageContainer, hostsWithValidKerberosClient);
                this.addDestroyPrincipalsStage(cluster, clusterHostInfoJson, hostParamsJson, event, commandParameters, roleCommandOrder, requestStageContainer);
            }
            this.addCleanupStage(cluster, clusterHostInfoJson, hostParamsJson, event, commandParameters, roleCommandOrder, requestStageContainer);
            return requestStageContainer.getLastStageId();
        }
    }

    public static enum SupportedCustomOperation {
        REGENERATE_KEYTABS;

    }

    private class CreatePrincipalsAndKeytabsHandler
    extends Handler {
        private KerberosServerAction.OperationType operationType;
        private UpdateConfigurationPolicy updateConfigurationPolicy;
        private boolean forceAllHosts;
        private boolean includeAmbariIdentity;

        CreatePrincipalsAndKeytabsHandler(KerberosServerAction.OperationType operationType, UpdateConfigurationPolicy updateConfigurationPolicy, boolean forceAllHosts, boolean includeAmbariIdentity) {
            this.operationType = operationType;
            this.updateConfigurationPolicy = updateConfigurationPolicy;
            this.forceAllHosts = forceAllHosts;
            this.includeAmbariIdentity = includeAmbariIdentity;
        }

        @Override
        public long createStages(Cluster cluster, String clusterHostInfoJson, String hostParamsJson, ServiceComponentHostServerActionEvent event, RoleCommandOrder roleCommandOrder, KerberosDetails kerberosDetails, File dataDirectory, RequestStageContainer requestStageContainer, List<ServiceComponentHost> serviceComponentHosts, Map<String, ? extends Collection<String>> serviceComponentFilter, Set<String> hostFilter, Collection<String> identityFilter, Set<String> hostsWithValidKerberosClient) throws OBDPException {
            if (requestStageContainer == null) {
                requestStageContainer = new RequestStageContainer(KerberosHelperImpl.this.actionManager.getNextRequestId(), null, KerberosHelperImpl.this.requestFactory, KerberosHelperImpl.this.actionManager);
            }
            boolean processAmbariIdentity = this.includeAmbariIdentity;
            HashMap<String, String> commandParameters = new HashMap<String, String>();
            commandParameters.put("authenticated_user_name", KerberosHelperImpl.this.ambariManagementController.getAuthName());
            commandParameters.put("default_realm", kerberosDetails.getDefaultRealm());
            if (dataDirectory != null) {
                commandParameters.put("data_directory", dataDirectory.getAbsolutePath());
            }
            if (serviceComponentFilter != null) {
                commandParameters.put("service_component_filter", StageUtils.getGson().toJson(serviceComponentFilter));
                boolean bl = processAmbariIdentity = serviceComponentFilter.containsKey(RootService.OBDP.name()) && (serviceComponentFilter.get(RootService.OBDP.name()) == null || serviceComponentFilter.get(RootService.OBDP.name()).contains("*") || serviceComponentFilter.get("OBDP").contains(RootComponent.OBDP_SERVER.name()));
            }
            if (hostFilter != null) {
                commandParameters.put("host_filter", StageUtils.getGson().toJson(hostFilter));
                boolean bl = processAmbariIdentity = hostFilter.contains("*") || hostFilter.contains(StageUtils.getHostName());
            }
            if (identityFilter != null) {
                commandParameters.put("identity_filter", StageUtils.getGson().toJson(identityFilter));
            }
            commandParameters.put("operation_type", this.operationType == null ? KerberosServerAction.OperationType.DEFAULT.name() : this.operationType.name());
            commandParameters.put("include_ambari_identity", processAmbariIdentity ? "true" : "false");
            if (this.updateConfigurationPolicy != UpdateConfigurationPolicy.NONE) {
                commandParameters.put("update_configuration_note", "Updated Kerberos-related configurations");
                commandParameters.put("update_configuration_policy", this.updateConfigurationPolicy.name());
            }
            List<String> hostsToInclude = KerberosHelperImpl.this.calculateHosts(cluster, serviceComponentHosts, hostsWithValidKerberosClient, this.forceAllHosts);
            this.addPrepareKerberosIdentitiesStage(cluster, clusterHostInfoJson, hostParamsJson, event, commandParameters, roleCommandOrder, requestStageContainer);
            if (kerberosDetails.manageIdentities()) {
                commandParameters.put("kdc_type", kerberosDetails.getKdcType().name());
                if (this.operationType != KerberosServerAction.OperationType.RECREATE_ALL) {
                    this.addCheckMissingKeytabsStage(cluster, clusterHostInfoJson, hostParamsJson, commandParameters, roleCommandOrder, requestStageContainer, hostsToInclude);
                }
                this.addCreatePrincipalsStage(cluster, clusterHostInfoJson, hostParamsJson, event, commandParameters, roleCommandOrder, requestStageContainer);
                this.addCreateKeytabFilesStage(cluster, clusterHostInfoJson, hostParamsJson, event, commandParameters, roleCommandOrder, requestStageContainer);
                if (processAmbariIdentity && kerberosDetails.createAmbariPrincipal()) {
                    this.addConfigureAmbariIdentityStage(cluster, clusterHostInfoJson, hostParamsJson, event, commandParameters, roleCommandOrder, requestStageContainer);
                }
                this.addDistributeKeytabFilesStage(cluster, clusterHostInfoJson, hostParamsJson, commandParameters, roleCommandOrder, requestStageContainer, hostsToInclude);
            }
            if (this.updateConfigurationPolicy != UpdateConfigurationPolicy.NONE) {
                this.addUpdateConfigurationsStage(cluster, clusterHostInfoJson, hostParamsJson, event, commandParameters, roleCommandOrder, requestStageContainer);
            }
            return requestStageContainer.getLastStageId();
        }
    }

    private class DeletePrincipalsAndKeytabsHandler
    extends Handler {
        private DeletePrincipalsAndKeytabsHandler() {
        }

        @Override
        public long createStages(Cluster cluster, String clusterHostInfoJson, String hostParamsJson, ServiceComponentHostServerActionEvent event, RoleCommandOrder roleCommandOrder, KerberosDetails kerberosDetails, File dataDirectory, RequestStageContainer requestStageContainer, List<ServiceComponentHost> serviceComponentHosts, Map<String, ? extends Collection<String>> serviceComponentFilter, Set<String> hostFilter, Collection<String> identityFilter, Set<String> hostsWithValidKerberosClient) throws OBDPException {
            if (requestStageContainer == null) {
                requestStageContainer = new RequestStageContainer(KerberosHelperImpl.this.actionManager.getNextRequestId(), null, KerberosHelperImpl.this.requestFactory, KerberosHelperImpl.this.actionManager);
            }
            if (kerberosDetails.manageIdentities()) {
                HashMap<String, String> commandParameters = new HashMap<String, String>();
                commandParameters.put("authenticated_user_name", KerberosHelperImpl.this.ambariManagementController.getAuthName());
                commandParameters.put("default_realm", kerberosDetails.getDefaultRealm());
                if (dataDirectory != null) {
                    commandParameters.put("data_directory", dataDirectory.getAbsolutePath());
                }
                if (serviceComponentFilter != null) {
                    commandParameters.put("service_component_filter", StageUtils.getGson().toJson(serviceComponentFilter));
                }
                if (hostFilter != null) {
                    commandParameters.put("host_filter", StageUtils.getGson().toJson(hostFilter));
                }
                if (identityFilter != null) {
                    commandParameters.put("identity_filter", StageUtils.getGson().toJson(identityFilter));
                }
                commandParameters.put("kdc_type", kerberosDetails.getKdcType().name());
                commandParameters.put("update_configuration_policy", UpdateConfigurationPolicy.ALL.name());
                this.addPrepareKerberosIdentitiesStage(cluster, clusterHostInfoJson, hostParamsJson, event, commandParameters, roleCommandOrder, requestStageContainer);
                this.addDeleteKeytabFilesStage(cluster, serviceComponentHosts, clusterHostInfoJson, hostParamsJson, commandParameters, roleCommandOrder, requestStageContainer, hostsWithValidKerberosClient);
                this.addDestroyPrincipalsStage(cluster, clusterHostInfoJson, hostParamsJson, event, commandParameters, roleCommandOrder, requestStageContainer);
                this.addCleanupStage(cluster, clusterHostInfoJson, hostParamsJson, event, commandParameters, roleCommandOrder, requestStageContainer);
            }
            return requestStageContainer.getLastStageId();
        }
    }
}

